package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

/**
 * Thread to download a remote file
 * Created by dsoukhov on 03/04/17.
 */
public class FileDownloader extends Thread {

    private AbstractUIProgressHandler handler;
    private boolean result = true, download = true;
    private String outputPath, filename;
    private AutomatedInstallData data;
    private String url;

    public FileDownloader(AbstractUIProgressHandler handler, String url){
        this.handler = handler;
        data = InstallData.getInstance();
        // Sanitize the URL (JBEAP-9567 comment)
        url = url.replace('\\', '/');
        this.filename = url.substring(url.lastIndexOf("/") + 1, url.length());
        this.url = url;
        getValidFilename(0);
    }

    public boolean getResult(){
        return result;
    }

    public String getPath(){
        return outputPath;
    }

    private void getValidFilename(int i){
        String affix = "";
        if(i != 0) affix = Integer.toString(i);

        String potentialPath = data.getInstallPath() + File.separator + filename + affix;
        File tmp = new File(potentialPath);
        if (!tmp.exists()){
            filename = filename + affix;
            outputPath = potentialPath;
        }else{
            getValidFilename(i+1);
        }
    }

    public boolean isDownloading(){
        return download;
    }

    public void stopDownload(){
        download = result = false;
    }

    public void run(){

        try {
            if(!download) return;

            URLConnection conn = new URL(url).openConnection();

            InputStream inputStream = conn.getInputStream();

            int len = conn.getContentLength();

            FileOutputStream outputStream = new FileOutputStream(outputPath);

            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[BUFFER_SIZE];
            int bytesRead;
            long totalBytesRead = 0;
            int percentCompleted;

            handler.startAction(data.langpack.getString("filedownloader.preparing"), 100);

            while ((bytesRead = inputStream.read(buffer)) != -1 && download) {
                outputStream.write(buffer, 0, bytesRead);
                totalBytesRead += bytesRead;
                percentCompleted = (int) (totalBytesRead * 100.0 / len);

                handler.progress(percentCompleted, String.format(data.langpack.getString("filedownloader.download.progress"), percentCompleted));
            }

            outputStream.close();
            inputStream.close();
        }catch (Exception e){
            handler.emitError(data.langpack.getString("filedownloader.error"),
                    String.format(data.langpack.getString("filedownloader.error.writing"), filename));
            result = false;
        }finally {
            handler.stopAction();
            download = false;
            synchronized (this) {
                this.notifyAll();
            }
            if(new File(outputPath).exists()) data.addTmpFile(outputPath);
        }

    }

}
