/*
 * Copyright 2018 JBoss by Red Hat.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.services.backend.constants;

public class ResourcesConstants {

    public static final String KJAR_2_ALL_RESOURCES = "target/test-classes/kjar-2-all-resources";
    public static final String KJAR_2_SINGLE_RESOURCES = "target/test-classes/kjar-2-single-resources";
    public static final String KJAR_2_SINGLE_FAIL_RESOURCES = "target/test-classes/kjar-2-single-fail-resources";
    public static final String KJAR_2_SINGLE_RESOURCES_WITH_ERROR = "target/test-classes/kjar-2-single-resources_with_error";
    public static final String KJAR_2_SINGLE_RESOURCES_OVERRIDE = "target/test-classes/kjar-2-single-resources_override";

    public static final String DUMMY = "target/test-classes/dummy";
    public static final String DUMMYUNTOUCHED = "target/test-classes/dummyuntouched";
    public static final String DUMMY_OVERRIDE = "target/test-classes/dummy_override";

    public static final String DUMMY_DEPS_SIMPLE = "target/test-classes/dummy_deps_simple";
    public static final String DUMMY_FAIL_DEPS_SIMPLE = "target/test-classes/dummy_fail_deps_simple";

    public static final String DUMMY_KIE_INCREMENTAL = "target/test-classes/dummy_kie_incremental";

    public static final String DUMMY_DIR = "target/test-classes/dummy";
    public static final String DUMMY_INCREMENTAL_DIR = "target/test-classes/dummy_incremental";

    public static final String DUMMY_DEPS_COMPLEX_DIR = "target/test-classes/dummy_deps_complex";
    public static final String DUMMY_DEPS_SIMPLE_DIR = "target/test-classes/dummy_deps_simple";

    public static final String DUMMY_KIE_UNTOUCHED_DIR = "target/test-classes/dummy_kie_untouched";
    public static final String DUMMY_KIE_UNVALID_UNTOUCHED_DIR = "target/test-classes/dummy_kie_unvalid_untouched";
    public static final String DUMMY_KIE_MULTIMODULE_CLASSLOADER_DIR = "target/test-classes/dummy_kie_multimodule_classloader";
    public static final String DUMMY_KIE_MULTIMODULE_UNTOUCHED_DIR = "target/test-classes/dummy_kie_multimodule_untouched/";
    public static final String DUMMY_KIE_MULTIMODULE_UNTOUCHED_WITH_ERROR_DIR = "target/test-classes/dummy_kie_multimodule_untouched_with_error";
}
