/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.IOException;
import java.io.PrintWriter;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;
import org.jboss.util.Strings;

public class QueryMethodCommand
extends MBeanServerCommand {
    private String query;
    private boolean displayCount;
    private String filter = "*:*";

    public QueryMethodCommand() {
        super("queryMethod", "Query the server for a list of matching methods of MBeans");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " [options] <query>");
        out.println("options:");
        out.println("    -c, --count    Display the matching method count");
        out.println("    -f, --filter   Filter by domain");
        out.println("    --             Stop processing options");
        out.println("Examples:");
        out.println(" query methods of all MBeans: " + this.name + " list");
        out.println(" query all methods of all MBeans in the jboss domain: " + this.name + " -f \"jboss:*\" list");
        out.flush();
    }

    private void processArguments(String[] args) throws CommandException {
        int code;
        this.log.debug((Object)("processing arguments: " + Strings.join((Object[])args, (String)",")));
        if (args.length == 0) {
            throw new CommandException("Command requires arguments");
        }
        String sopts = "-:cf:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("count", 0, null, 99), new LongOpt("filter", 1, null, 102)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        int argidx = 0;
        while ((code = getopt.getopt()) != -1) {
            block0 : switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 1: {
                    String arg = getopt.getOptarg();
                    switch (argidx++) {
                        case 0: {
                            this.query = arg;
                            this.log.debug((Object)("query: " + this.query));
                            break block0;
                        }
                    }
                    throw new CommandException("Unused argument: " + arg);
                }
                case 99: {
                    this.displayCount = true;
                    break;
                }
                case 102: {
                    this.filter = getopt.getOptarg();
                    this.log.debug((Object)("filter: " + this.filter));
                }
            }
        }
    }

    public void execute(String[] args) throws Exception {
        this.processArguments(args);
        if (this.query == null) {
            throw new CommandException("Missing MBean method query");
        }
        ObjectName[] names = this.queryMBeans(this.filter);
        PrintWriter out = this.context.getWriter();
        if (this.displayCount) {
            out.println(this.getHits(names));
        } else {
            out.println(this.getResult(names));
        }
        out.flush();
    }

    private String getResult(ObjectName[] names) throws IntrospectionException, InstanceNotFoundException, IOException, ReflectionException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            MBeanOperationInfo[] ops = this.getMBeanServer().getMBeanInfo(names[i]).getOperations();
            for (int j = 0; j < ops.length; ++j) {
                MBeanOperationInfo op = ops[j];
                if (!op.getName().toLowerCase().contains(this.query.toLowerCase())) continue;
                buffer.append(this.getMBeanInfoString(names[i])).append(" ").append(this.getMethodInfoString(op)).append("\n");
            }
        }
        return buffer.toString();
    }

    private int getHits(ObjectName[] names) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        int hits = 0;
        for (int i = 0; i < names.length; ++i) {
            MBeanOperationInfo[] ops = this.getMBeanServer().getMBeanInfo(names[i]).getOperations();
            for (int j = 0; j < ops.length; ++j) {
                MBeanOperationInfo op = ops[j];
                if (!op.getName().toLowerCase().contains(this.query.toLowerCase())) continue;
                ++hits;
            }
        }
        return hits;
    }

    private String getMBeanInfoString(ObjectName name) {
        return new StringBuffer().append(name.getDomain()).append(":").append(name.getKeyPropertyListString()).append(" ").toString();
    }

    private String getMethodInfoString(MBeanOperationInfo op) {
        MBeanParameterInfo[] params = op.getSignature();
        StringBuffer sb = new StringBuffer().append(op.getName()).append(" ");
        for (int k = 0; k < params.length; ++k) {
            sb.append(params[k].getType()).append(" ");
        }
        return sb.toString();
    }
}

