/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.targets;

import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.UnknownElement;
import org.jboss.ant.targets.DynamicTarget;
import org.jboss.ant.types.AbstractBuildDataType;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.util.MacroUtil;

public abstract class AbstractTargetDefinitionTarget
extends DynamicTarget {
    private TargetDefinition targetDefinition;

    public AbstractTargetDefinitionTarget(AbstractBuildDataType dataType, String name, String description, TargetDefinition targetDefinition) {
        super(dataType, name, description);
        this.targetDefinition = targetDefinition;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created target definition, type.id=" + dataType.getId() + ", name=" + name + ", targetDefinition.id=" + targetDefinition.getId());
        }
    }

    public TargetDefinition getTargetDefinition() {
        return this.targetDefinition;
    }

    protected void generate() {
        List dynamicTypes = this.getDynamicTypes();
        if (dynamicTypes != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("generate");
            }
            for (int i = 0; i < dynamicTypes.size(); ++i) {
                DynamicType dynamicType = (DynamicType)((Object)dynamicTypes.get(i));
                if (!dynamicType.applies((Object)this.getDataType())) continue;
                this.generateTasks(dynamicType);
            }
        }
    }

    public void show() {
        List dynamicTypes = this.getDynamicTypes();
        if (dynamicTypes != null) {
            for (int i = 0; i < dynamicTypes.size(); ++i) {
                DynamicType dynamicType = (DynamicType)((Object)dynamicTypes.get(i));
                Vector taskDefinitions = dynamicType.getElements();
                if (!dynamicType.applies((Object)this.getDataType())) continue;
                for (int j = 0; j < taskDefinitions.size(); ++j) {
                    DynamicType taskDefinition = (DynamicType)((Object)taskDefinitions.get(j));
                    RuntimeConfigurable rc = this.createMacro(taskDefinition.getId());
                    MacroUtil.configure(rc, taskDefinition, (Object)this.getDataType(), this.getProject(), this);
                    System.out.print(MacroUtil.dumpMacro((UnknownElement)rc.getProxy()));
                }
            }
        } else {
            System.out.print("\n<!-- Nothing -->");
        }
    }

    protected abstract List getDynamicTypes();
}

