/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.jboss.ant.tasks.build.BuildTask;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.graph.ComponentRefGraphClasspathVisitor;
import org.jboss.ant.util.graph.Graph;

public class GenerateLibrariesFile
extends BuildTask {
    private String fileName = "libraries.ent";
    private String aliasFileName = "aliases.ent";
    private String path = "../tools/etc/buildmagic/";

    public void execute() {
        File baseLocation = FileUtil.resolve(this.getBuildInstance().getProject().getBaseDir(), this.path);
        File output = FileUtil.resolve(this.getBuildInstance().getProject().getBaseDir(), this.getFileName());
        File input = FileUtil.resolve(baseLocation, this.aliasFileName);
        File outputPath = new File(output.getParent());
        try {
            if (!outputPath.exists()) {
                outputPath.mkdirs();
            }
            output.createNewFile();
            FileWriter fileWriter = new FileWriter(output);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            ComponentRefGraphClasspathVisitor visitor = new ComponentRefGraphClasspathVisitor(this.project);
            visitor.setBufferedWriter(bufferedWriter);
            Graph graph = this.getGraph();
            graph.breadthFirstSearch(graph.getVertex(0), visitor);
            graph.clearMark();
            FileInputStream fstream = new FileInputStream(input);
            BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
            int ch = in.read();
            while (ch != -1) {
                bufferedWriter.write(ch);
                ch = in.read();
            }
            in.close();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Unable to find file:\n " + output.getAbsolutePath() + "/" + this.getFileName() + ":\n" + e.getMessage());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read or write to file:\n " + output.getAbsolutePath() + ":\n" + e.getMessage());
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

