/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jboss.ant.tasks.build.BuildTask;
import org.jboss.ant.types.Compatible;
import org.jboss.ant.types.ComponentRef;
import org.jboss.ant.types.Import;
import org.jboss.ant.types.attributes.Version;
import org.jboss.ant.types.build.Build;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.util.DownloadUtil;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.ImportUtil;
import org.jboss.ant.util.graph.ComponentRefGraphChildResolverVistor;
import org.jboss.ant.util.graph.ComponentRefGraphComponentInfoResolverVisitor;
import org.jboss.ant.util.graph.ComponentRefGraphFileResolverVisitor;
import org.jboss.ant.util.graph.ComponentRefVertex;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.RootVertex;

public class ResolveComponentRefsTask
extends BuildTask {
    private String build;

    public void execute() throws BuildException {
        if (this.getBuildInstance().getGraph() == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Executing task ResolveComponentRefsTask");
            }
            this.setTaskName("ResolveComponentRefsTask");
            Graph componentRefGraph = this.createInitialGraph();
            ComponentRefGraphComponentInfoResolverVisitor componentInfoResolverVisitor = new ComponentRefGraphComponentInfoResolverVisitor();
            ComponentRefGraphChildResolverVistor childResolverVisitor = new ComponentRefGraphChildResolverVistor();
            this.resolveDependencies(componentRefGraph, componentInfoResolverVisitor, childResolverVisitor);
            this.getBuildInstance().setGraph(componentRefGraph);
        }
    }

    private void resolveDependencies(Graph componentGraph, ComponentRefGraphComponentInfoResolverVisitor fileResolver, ComponentRefGraphChildResolverVistor childResolver) throws BuildException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Resolving componentRefs");
        }
        do {
            fileResolver.getUnresolvedComponents().clear();
            childResolver.getUnexpandedVertexes().clear();
            componentGraph.clearMark();
            componentGraph.breadthFirstSearch(componentGraph.getVertex(0), fileResolver);
            this.downloadDependencies(fileResolver.getUnresolvedComponents());
            componentGraph.clearMark();
            componentGraph.breadthFirstSearch(componentGraph.getVertex(0), childResolver);
            this.importComponents(childResolver.getUnexpandedVertexes(), componentGraph);
        } while (fileResolver.getUnresolvedComponents().size() != 0 || childResolver.getUnexpandedVertexes().size() != 0);
        componentGraph.clearMark();
    }

    private void importComponents(Vector unexpandedVertexes, Graph graph) throws BuildException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("importComponents, unexpandedVertexes: " + unexpandedVertexes);
        }
        Project project = this.getProject();
        for (int i = 0; i < unexpandedVertexes.size(); ++i) {
            Component newComponent;
            ComponentRefVertex currentComponentVertex = (ComponentRefVertex)unexpandedVertexes.elementAt(i);
            ComponentRef currentComponentRef = currentComponentVertex.getComponentRef();
            if (this.log.isTraceEnabled()) {
                this.log.trace("[" + i + "]: " + currentComponentRef.getName());
            }
            if ((newComponent = (Component)((Object)project.getReference(currentComponentRef.getName()))) == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Component with name " + currentComponentRef.getName() + " does not exist in project, will import the component-info file");
                }
                ImportUtil.importFile(currentComponentRef.getComponentFile(), project);
                newComponent = (Component)((Object)project.getReference(currentComponentRef.getName()));
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Successfully imported component " + (Object)((Object)newComponent));
                }
                if (newComponent == null) {
                    throw new BuildException("Failed to retrieve the component: " + currentComponentRef.getName() + " from the ANT hashtable");
                }
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Component with name " + currentComponentRef.getName() + " already exsists in the project, will compare it to componentRef " + (Object)((Object)newComponent));
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Creating a new version from string: " + newComponent.getVersion().toString() + " . This version will be placed in a compatible.");
                }
                Version newVersion = newComponent.getVersion();
                Compatible newVersionInfo = new Compatible(newVersion);
                SortedSet oldVersions = currentComponentRef.getCompatibleVersions();
                if (oldVersions != null && !oldVersions.contains(newVersionInfo)) {
                    String newCompID = newComponent.getId();
                    String importCompID = currentComponentRef.getImportingComponent().getId();
                    throw new BuildException("A versioning problem exists:\nComponent: " + newCompID + " is at version: " + newVersion + "\n but it is also required to be compatible with: " + oldVersions + "\n by: " + importCompID);
                }
            }
            if (!this.getBuildInstance().componentExists(newComponent)) {
                newComponent.setExecutable(currentComponentRef.getExecutable());
                this.getBuildInstance().addComponent(newComponent);
            }
            currentComponentRef.setComponent(newComponent);
            for (int j = 0; j < newComponent.getImports().size(); ++j) {
                Import currentImport = (Import)((Object)newComponent.getImports().elementAt(j));
                ComponentRef newComponentRef = new ComponentRef(currentImport);
                newComponentRef.setProject(project);
                newComponentRef.setName(currentImport.getComponentRef());
                SortedSet compatibles = currentImport.getCompatibleVersions();
                newComponentRef.setCompatibleVersions(compatibles);
                this.getBuildInstance().addComponentRef(newComponentRef);
                ComponentRefVertex newComponentVertex = new ComponentRefVertex(newComponentRef.getId());
                newComponentVertex.setComponentRef(newComponentRef);
                graph.addVertex(newComponentVertex);
                graph.addEdge(currentComponentVertex, newComponentVertex, 0);
            }
        }
    }

    private void downloadDependencies(Vector unresolvedComponents) {
        for (int i = 0; i < unresolvedComponents.size(); ++i) {
            ComponentRefVertex currentComponentVertex = (ComponentRefVertex)unresolvedComponents.elementAt(i);
            ComponentRef currentComponentRef = currentComponentVertex.getComponentRef();
            if (this.componentInfoExists(currentComponentRef)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Component-info.xml for component ref: " + currentComponentRef.getName() + " already exists in file system. ");
                }
                currentComponentRef.setFileResolved(true);
                continue;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to retrieve a component-info.xml from repository file for componentRef with name " + currentComponentRef.getName());
            }
            this.createComponentInfoDir(currentComponentRef);
            URL repositoryFile = null;
            try {
                repositoryFile = FileUtil.resolve(currentComponentRef.getLocation(), currentComponentRef.getFilename());
            }
            catch (MalformedURLException e) {
                throw new BuildException(repositoryFile.getProtocol() + "://" + repositoryFile.getHost() + "/" + repositoryFile.getPath() + "/" + repositoryFile.getFile(), (Throwable)e);
            }
            File downloadedFile = DownloadUtil.getFile(currentComponentRef.getComponentFile(), repositoryFile, this.getProject());
            currentComponentRef.setFileResolved(true);
        }
    }

    private boolean componentInfoExists(ComponentRef componentRef) {
        File filename = !componentRef.isLocal() ? FileUtil.resolve(componentRef.getThirdpartyDir(), componentRef.getFilename()) : FileUtil.resolve(componentRef.getDir(), componentRef.getFilename());
        return filename.exists();
    }

    private void createComponentInfoDir(ComponentRef componentRef) {
        File dir = !componentRef.isLocal() ? componentRef.getThirdpartyDir() : componentRef.getDir();
        if (!dir.exists()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Directory: " + dir.getAbsolutePath() + " does not exist.  Creating...");
            }
            FileUtil.mkdir(dir, this.getProject());
        }
    }

    private void viewUnresolvedDependencies(ComponentRefGraphFileResolverVisitor visitor) {
        System.out.println("Currently the following components are unresolved:");
        for (int i = 0; i < visitor.getUnresolvedComponents().size(); ++i) {
            Component unresolvedComponent = (Component)((Object)visitor.getUnresolvedComponents().elementAt(i));
            System.out.println(unresolvedComponent.getId());
        }
    }

    private Graph createInitialGraph() {
        Graph componentRefGraph = new Graph();
        RootVertex root = new RootVertex("ROOT");
        componentRefGraph.addVertex(root);
        Build mainBuild = this.getBuildInstance();
        for (int i = 0; i < mainBuild.getComponentRefs().size(); ++i) {
            ComponentRef currentComponentRef = (ComponentRef)((Object)mainBuild.getComponentRefs().elementAt(i));
            ComponentRefVertex componentRefVertex = new ComponentRefVertex(currentComponentRef.getName());
            componentRefVertex.setComponentRef(currentComponentRef);
            componentRefGraph.addVertex(componentRefVertex);
            componentRefGraph.addEdge(root, componentRefVertex, 1);
        }
        return componentRefGraph;
    }

    private ComponentRefGraphFileResolverVisitor createVisitor() {
        ComponentRefGraphFileResolverVisitor visitor = new ComponentRefGraphFileResolverVisitor();
        return visitor;
    }
}

