/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.component;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.jboss.ant.targets.AbstractTargetDefinitionTarget;
import org.jboss.ant.targets.ComponentDefinitionTarget;
import org.jboss.ant.targets.ShowTarget;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.component.ArtifactDefinition;
import org.jboss.ant.types.component.ClassPathDefinition;
import org.jboss.ant.types.component.GeneratedSourceDefinition;
import org.jboss.ant.types.component.ResourceDefinition;
import org.jboss.ant.types.component.SourceDefinition;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.types.target.TargetInsertionDefinition;
import org.jboss.ant.util.FileUtil;

public class ComponentDefinition
extends Source {
    private String component;
    private Vector artifactDefinitions = new Vector();
    private Vector sourceDefinitions = new Vector();
    private Vector resourceDefinitions = new Vector();
    private Vector generatedSourceDefinitions = new Vector();
    private Vector targetInsertionDefinitions = new Vector();
    private Vector classPathDefinitions = new Vector();
    private Hashtable targetMap = new Hashtable();
    private String required_jdk;
    private static ComponentDefinition componentDefinitionInstance;
    static /* synthetic */ Class class$org$jboss$ant$types$build$Component;

    public static ComponentDefinition getComponentDefinition() {
        return componentDefinitionInstance;
    }

    public ComponentDefinition() {
        if (componentDefinitionInstance != null) {
            throw new BuildException("Duplicate component definition");
        }
        componentDefinitionInstance = this;
    }

    public Component getComponent() {
        return (Component)this.resolve("component", this.component, class$org$jboss$ant$types$build$Component == null ? (class$org$jboss$ant$types$build$Component = ComponentDefinition.class$("org.jboss.ant.types.build.Component")) : class$org$jboss$ant$types$build$Component);
    }

    public String getComponentName() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Set component: " + component);
        }
        this.getComponent().setComponentDefinition(this);
    }

    public Vector getSources() {
        return this.sourceDefinitions;
    }

    public void addSource(SourceDefinition sourceDefinition) {
        this.sourceDefinitions.add(sourceDefinition);
        sourceDefinition.setComponentDefinition(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added source " + sourceDefinition.toShortString());
        }
    }

    public void addClassPathDefinition(ClassPathDefinition classPathDefinition) {
        this.classPathDefinitions.add(classPathDefinition);
        classPathDefinition.setComponentDefinition(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added classPathDefinition " + classPathDefinition.toShortString());
        }
    }

    public Vector getResources() {
        return this.resourceDefinitions;
    }

    public void addResource(ResourceDefinition resourceDefinition) {
        this.resourceDefinitions.add(resourceDefinition);
        resourceDefinition.setComponentDefinition(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added resource " + resourceDefinition.toShortString());
        }
    }

    public void addTargetInsertionDefinition(TargetInsertionDefinition targetInsertionDefinition) {
        targetInsertionDefinition.setComponentDefinition(this);
        this.targetInsertionDefinitions.add(targetInsertionDefinition);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added targetInsertionDefintion " + targetInsertionDefinition.toShortString());
        }
    }

    public Vector getTargetInsertionDefinitions() {
        return this.targetInsertionDefinitions;
    }

    public Vector getGeneratedSources() {
        return this.generatedSourceDefinitions;
    }

    public void addGeneratedSource(GeneratedSourceDefinition generatedSourceDefinition) {
        this.generatedSourceDefinitions.add(generatedSourceDefinition);
        generatedSourceDefinition.setComponentDefinition(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added generated source " + generatedSourceDefinition.toShortString());
        }
    }

    public Vector getArtifacts() {
        return this.artifactDefinitions;
    }

    public void addArtifactDef(ArtifactDefinition artifactDefinition) {
        this.artifactDefinitions.add(artifactDefinition);
        artifactDefinition.setComponentDefinition(this);
    }

    public void addClassPathDef(ClassPathDefinition classPathDefinition) {
        this.classPathDefinitions.add(classPathDefinition);
        classPathDefinition.setComponentDefinition(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added classpathdefinition " + classPathDefinition.toShortString());
        }
    }

    public File getOutput() {
        return this.getComponent().getOutput();
    }

    public void generate() {
        this.validate();
        this.generateTargets();
        this.generateResourceTargets();
        this.generateGeneratedSourceTargets();
        this.generateSourceTargets();
        this.generateArtifactTargets();
        this.generateTargetInsertions();
        this.generateClassPaths();
        this.addTarget(new ShowTarget(this));
    }

    protected void doValidate() {
        this.getComponent().validate();
        this.validate(this.sourceDefinitions);
        this.validate(this.artifactDefinitions);
        this.validate(this.resourceDefinitions);
        this.validate(this.generatedSourceDefinitions);
        this.validate(this.targetInsertionDefinitions);
        this.validate(this.classPathDefinitions);
    }

    protected void appendIdentity(StringBuffer buffer) {
        super.appendIdentity(buffer);
        buffer.append(" component=").append(this.component);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        buffer.append(" component=").append(this.component);
        if (this.sourceDefinitions.size() > 0) {
            buffer.append(" sources=").append(this.sourceDefinitions);
        }
        if (this.artifactDefinitions.size() > 0) {
            buffer.append(" artifactDefs=").append(this.artifactDefinitions);
        }
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description == null) {
            description = this.getComponent().getDescription();
        }
        if (description == null) {
            description = this.getComponent().getBuild().getDescription();
        }
        return description;
    }

    protected void generateTargets() {
        Vector definitions = this.getComponent().getTargetDefinitions();
        block0: for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            List component = definition.getComponent();
            if (component == null) continue;
            ComponentDefinitionTarget target = null;
            for (int j = 0; j < component.size(); ++j) {
                DynamicType type = (DynamicType)((Object)component.get(j));
                if (!type.applies((Object)this) || target != null) continue;
                target = new ComponentDefinitionTarget(this, definition);
                this.addTarget(target);
                this.targetMap.put(definition.getTarget(), target);
                this.addDepends(target, type);
                continue block0;
            }
        }
    }

    protected void generateTargetInsertions() {
        Vector targetInsertions = this.getTargetInsertionDefinitions();
        for (int i = 0; i < targetInsertions.size(); ++i) {
            TargetInsertionDefinition targetInsertion = (TargetInsertionDefinition)((Object)targetInsertions.get(i));
            ComponentDefinitionTarget target = (ComponentDefinitionTarget)((Object)this.getProject().getTargets().get(targetInsertion.getTarget()));
            if (target == null) {
                throw new BuildException("Unable to find a target with name " + targetInsertion.getTarget() + "for componentdef " + this.getComponent().getId());
            }
            target.addDependency(targetInsertion.getDepends());
        }
    }

    protected void generateClassPaths() {
        Vector classPaths = this.getClassPathDefinitions();
        for (int i = 0; i < classPaths.size(); ++i) {
            ClassPathDefinition classPathDefinition = (ClassPathDefinition)((Object)classPaths.get(i));
            Path path = new Path(this.getProject());
            ArrayList classpathList = (ArrayList)classPathDefinition.getClasspath();
            for (int j = 0; j < classpathList.size(); ++j) {
                File currentFile = (File)classPathDefinition.getClasspath().get(j);
                path.setLocation(currentFile);
            }
            this.getProject().getReferences().put(classPathDefinition.getId(), path);
        }
    }

    protected void generateSourceTargets() {
        Vector sources = this.getSources();
        for (int i = 0; i < sources.size(); ++i) {
            SourceDefinition source = (SourceDefinition)((Object)sources.get(i));
            source.generateTargets();
        }
    }

    protected void generateResourceTargets() {
        Vector resources = this.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            ResourceDefinition resource = (ResourceDefinition)((Object)resources.get(i));
            resource.generateTargets();
        }
    }

    protected void generateGeneratedSourceTargets() {
        Vector generatedSources = this.getGeneratedSources();
        for (int i = 0; i < generatedSources.size(); ++i) {
            GeneratedSourceDefinition genSource = (GeneratedSourceDefinition)((Object)generatedSources.get(i));
            genSource.generateTargets();
        }
    }

    protected void generateArtifactTargets() {
        Vector artifacts = this.getArtifacts();
        for (int i = 0; i < artifacts.size(); ++i) {
            ArtifactDefinition artifact = (ArtifactDefinition)((Object)artifacts.get(i));
            artifact.generateTargets();
        }
    }

    protected void addDependency(AbstractTargetDefinitionTarget target) {
        this.addTarget(target);
        TargetDefinition targetDefinition = target.getTargetDefinition();
        String targetName = targetDefinition.getTarget();
        ComponentDefinitionTarget componentsTarget = (ComponentDefinitionTarget)((Object)this.targetMap.get(targetName));
        if (componentsTarget == null) {
            throw new BuildException("No components target for " + (Object)((Object)targetDefinition));
        }
        componentsTarget.addDependency(target.getName());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added components dependency " + target.getName() + " for " + (Object)((Object)targetDefinition));
        }
    }

    protected String getSourcePath(String name) {
        return this.getComponent().getSourcePath() + "/" + name;
    }

    protected String getResourcePath(String name) {
        return this.getComponent().getResourcePath() + "/" + name;
    }

    protected String getTestPath(String name) {
        return this.getComponent().getTestPath() + "/" + name;
    }

    protected File getClassOutput(String name) {
        File output = this.getOutput();
        File classes = FileUtil.resolve(output, this.getComponent().getClassesPath());
        return FileUtil.resolve(classes, name);
    }

    protected File getResourceOutput(String name) {
        File output = this.getOutput();
        File resources = FileUtil.resolve(output, this.getComponent().getResourceOutputPath());
        return FileUtil.resolve(resources, name);
    }

    protected File getGeneratedSourceOutput(String name) {
        File output = this.getOutput();
        File resources = FileUtil.resolve(output, this.getComponent().getGeneratedSourceOutputPath());
        return FileUtil.resolve(resources, name);
    }

    public Vector getClassPathDefinitions() {
        return this.classPathDefinitions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

