/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * Thrown when a service is unavailable
 */
public class UnavailableException extends ResourceException
{
   /**
	 * Create an unavailable exception.
	 */
   public UnavailableException()
   {
      super();
   }

   /**
	 * Create an unavailable exception with a reason.
	 * 
	 * @param reason the reason
	 */
   public UnavailableException(String reason)
   {
      super(reason);
   }

   /**
	 * Create an unavailable exception with a reason and an errorCode.
	 * 
	 * @param reason the reason
	 * @param errorCode the error code
	 */
   public UnavailableException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
	 * Create an unavailable exception with a reason and an error.
	 * 
	 * @param reason the reason
	 * @param throwable the error
	 */
   public UnavailableException(String reason, Throwable throwable)
   {
      super(reason, throwable);
   }

   /**
	 * Create an unavailable exception with an error.
	 * 
	 * @param throwable the error
	 */
   public UnavailableException(Throwable throwable)
   {
      super(throwable);
   }
}