/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import org.ajax4jsf.io.FastBufferReader;
import org.ajax4jsf.io.parser.ParserState;
import org.ajax4jsf.io.parser.ParsingContext;
import org.ajax4jsf.io.parser.ParsingStateManager;
import org.ajax4jsf.webapp.HtmlParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastHtmlParser
implements HtmlParser {
    private static final Log log = LogFactory.getLog((Class)(class$org$ajax4jsf$io$parser$FastHtmlParser == null ? (class$org$ajax4jsf$io$parser$FastHtmlParser = FastHtmlParser.class$("org.ajax4jsf.io.parser.FastHtmlParser")) : class$org$ajax4jsf$io$parser$FastHtmlParser));
    private Set scripts;
    private Set styles;
    private Set userStyles;
    private String encoding;
    private String doctype;
    private String viewState;
    private String mimeType;
    static /* synthetic */ Class class$org$ajax4jsf$io$parser$FastHtmlParser;

    public void parse(Reader in, Writer out) throws IOException {
        boolean haveHtml = false;
        boolean haveHead = false;
        boolean closingElement = false;
        if (null != this.scripts || null != this.styles || null != this.userStyles) {
            int nextChar;
            ParsingStateManager stateManager = ParsingStateManager.getInstance();
            ParserState state = stateManager.getInitialState();
            ParsingContext context = new ParsingContext(out);
            while ((nextChar = in.read()) > 0) {
                char c = (char)nextChar;
                state = state.getNextState(c, context);
                if (log.isDebugEnabled()) {
                    Class<?> stateMgrClass = stateManager.getClass();
                    Field[] fields = stateMgrClass.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        try {
                            if (field.get(stateManager) != state) continue;
                            log.debug((Object)("Parser reached state is StateManager." + field.getName()));
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                state.send(c, context);
                if (state == stateManager.LT) {
                    closingElement = false;
                    continue;
                }
                if (state == stateManager.CLOSINGELEMENT) {
                    closingElement = true;
                    continue;
                }
                if (state == stateManager.ENDELEMENT) {
                    if (context.getLastMatched() == stateManager.HTML) {
                        haveHtml = true;
                        context.send();
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Found <html> element");
                        continue;
                    }
                    if (context.getLastMatched() == stateManager.HEAD) {
                        haveHead = true;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Found <head> element");
                        }
                        if (closingElement) {
                            this.writeToHead(out, haveHtml, haveHead);
                            break;
                        }
                        context.send();
                        continue;
                    }
                    if (context.getLastMatched() == stateManager.TITLE) {
                        context.send();
                        haveHead = true;
                        haveHtml = true;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Found <title> element");
                        continue;
                    }
                    if (context.getLastMatched() == stateManager.BASE) {
                        context.send();
                        haveHead = true;
                        haveHtml = true;
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Found <base> element");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"non <html> or <head><title>|<base> element");
                    }
                    this.writeToHead(out, haveHtml, haveHead);
                    break;
                }
                if (state != stateManager.ELEMENT) continue;
                this.writeToHead(out, haveHtml, haveHead);
                break;
            }
            context.send();
        } else {
            haveHtml = true;
        }
        if (in instanceof FastBufferReader) {
            FastBufferReader fastIn = (FastBufferReader)in;
            fastIn.writeTo(out);
        } else {
            char[] buffer = new char[1024];
            int buffersCount = -1;
            int length = in.read(buffer);
            while (length > 0) {
                out.write(buffer, 0, length);
                ++buffersCount;
                length = in.read(buffer);
            }
        }
        if (!haveHtml) {
            out.write("</html>");
        }
    }

    private void writeToHead(Writer out, boolean haveHtml, boolean haveHead) throws IOException {
        String style;
        Iterator iter;
        if (!haveHead && !haveHtml) {
            out.write("<html  xmlns=\"http://www.w3.org/1999/xhtml\">");
        }
        if (!haveHead) {
            out.write("<head>");
        }
        if (null != this.styles) {
            iter = this.styles.iterator();
            while (iter.hasNext()) {
                style = (String)iter.next();
                out.write("<link rel='stylesheet' class='component' type='text/css' href='");
                out.write(style);
                out.write("' />");
            }
        }
        if (null != this.userStyles) {
            iter = this.userStyles.iterator();
            while (iter.hasNext()) {
                style = (String)iter.next();
                out.write("<link rel='stylesheet' class='user' type='text/css' href='");
                out.write(style);
                out.write("' />");
            }
        }
        if (null != this.scripts) {
            iter = this.scripts.iterator();
            while (iter.hasNext()) {
                String script = (String)iter.next();
                out.write("<script type='text/javascript' src='");
                out.write(script);
                out.write("'></script>");
            }
        }
        if (!haveHead) {
            out.write("</head>");
        }
    }

    public Set getScripts() {
        return this.scripts;
    }

    public void setScripts(Set scripts) {
        this.scripts = scripts;
    }

    public Set getStyles() {
        return this.styles;
    }

    public void setStyles(Set styles) {
        this.styles = styles;
    }

    public Set getUserStyles() {
        return this.userStyles;
    }

    public void setUserStyles(Set userStyles) {
        this.userStyles = userStyles;
    }

    public void parseHtml(InputStream input, Writer output) throws IOException {
        this.parse(new InputStreamReader(input, this.encoding), output);
    }

    public void parseHtml(Reader input, Writer output) throws IOException {
        this.parse(input, output);
    }

    public void setInputEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputEncoding(String encoding) {
    }

    public void setMoveElements(boolean move) {
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setViewState(String viewState) {
        this.viewState = viewState;
    }

    public boolean setMime(String mimeType) {
        this.mimeType = mimeType;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

