/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.json;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.richfaces.json.JSONAccessor;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;

public class JSONMap
extends AbstractMap {
    private final JSONObject jsonObject;

    public JSONMap() throws JSONException {
        this.jsonObject = new JSONObject();
    }

    public JSONMap(String jsonString) throws JSONException {
        this.jsonObject = new JSONObject(jsonString);
    }

    public JSONMap(JSONObject object) {
        this.jsonObject = object;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new Iterator(){
                    private Iterator keys;
                    private String currentName;
                    {
                        this.keys = JSONMap.this.jsonObject.keys();
                    }

                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    public Object next() {
                        this.currentName = (String)this.keys.next();
                        return new Map.Entry(){
                            private String key;
                            {
                                this.key = currentName;
                            }

                            public Object getKey() {
                                return this.key;
                            }

                            public Object getValue() {
                                try {
                                    return JSONAccessor.getValue(JSONMap.this.jsonObject, this.key);
                                }
                                catch (JSONException e) {
                                    throw new RuntimeException(e.getMessage(), e);
                                }
                            }

                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public int size() {
                return JSONMap.this.jsonObject.length();
            }

            public boolean add(Object o) {
                Map.Entry entry = (Map.Entry)o;
                return JSONAccessor.putValue(JSONMap.this.jsonObject, (String)entry.getKey(), entry.getValue());
            }
        };
    }

    public Object put(Object key, Object value) {
        String keyString = key.toString();
        try {
            Object previousValue = JSONAccessor.getValue(this.jsonObject, keyString);
            JSONAccessor.putValue(this.jsonObject, keyString, value);
            return previousValue;
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getString() throws JSONException {
        return this.jsonObject.toString(0);
    }

    public String getString(int indentFactor) throws JSONException {
        return this.jsonObject.toString(indentFactor);
    }
}

