/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.validation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.ws.extensions.validation.StrictlyValidErrorHandler;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class SchemaValidationHelper {
    private URL xsdURL;
    private ErrorHandler errorHandler = new StrictlyValidErrorHandler();

    public SchemaValidationHelper(URL xsdURL) {
        this.xsdURL = xsdURL;
    }

    public SchemaValidationHelper setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public void validateDocument(String inxml) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(inxml.getBytes());
        this.validateDocument(bais);
    }

    public void validateDocument(Element inxml) throws Exception {
        String xmlStr = DOMWriter.printNode((Node)inxml, (boolean)false);
        this.validateDocument(xmlStr);
    }

    public void validateDocument(InputStream inxml) throws Exception {
        DocumentBuilder builder = this.getDocumentBuilder();
        builder.parse(inxml);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", this.xsdURL.toExternalForm());
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(this.errorHandler);
        return builder;
    }
}

