/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Set;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.Agent;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.ClassVisitorImpl;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.Config;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.asm.ClassReader;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.asm.ClassWriter;

public class ClassFileTransformerImpl
implements ClassFileTransformer {
    private Set<Class<?>> targetClasses;
    private Set<Class<?>> transformedClasses;

    public ClassFileTransformerImpl(Set<Class<?>> targetClasses, Set<Class<?>> transformedClasses) {
        this.targetClasses = targetClasses;
        this.transformedClasses = transformedClasses;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!ClassFileTransformerImpl.isProfiledClassLoader(loader) || !ClassFileTransformerImpl.matches(className, Config.getInstance().profiledPackages) || ClassFileTransformerImpl.matches(className, Config.getInstance().ignoredPackages)) {
            return classfileBuffer;
        }
        this.targetClasses.add(classBeingRedefined);
        this.transformedClasses.add(classBeingRedefined);
        Agent.logInfo("Instrumented class: %s", className);
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(1);
        ClassVisitorImpl visitor = new ClassVisitorImpl(writer, className);
        reader.accept(visitor, 2);
        return writer.toByteArray();
    }

    private static boolean matches(String className, Set<String> packages) {
        String packageName;
        if (packages.isEmpty()) {
            return false;
        }
        if (className.contains("/")) {
            packageName = className.substring(0, className.lastIndexOf(47)).replace('/', '.');
        } else {
            if (className.startsWith("$")) {
                return false;
            }
            packageName = "<default>";
        }
        for (String pkg : packages) {
            if (!(pkg.endsWith("*") ? packageName.concat(".").startsWith(pkg.substring(0, pkg.length() - 1)) : packageName.equals(pkg))) continue;
            return true;
        }
        return false;
    }

    private static boolean isProfiledClassLoader(ClassLoader loader) {
        if (Config.getInstance().profiledClassLoaders.isEmpty()) {
            return true;
        }
        for (String classLoader : Config.getInstance().profiledClassLoaders) {
            if (loader == null || !loader.getClass().getName().equals(classLoader)) continue;
            return true;
        }
        return false;
    }
}

