/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.AbstractSelectLockingStrategy;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class PessimisticWriteSelectLockingStrategy
extends AbstractSelectLockingStrategy {
    public PessimisticWriteSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        super(lockable, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Serializable id, Object version, Object object, int timeout, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        String sql = this.determineSql(timeout);
        SessionFactoryImplementor factory = session.getFactory();
        try {
            PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
            try {
                this.getLockable().getIdentifierType().nullSafeSet(st, id, 1, session);
                if (this.getLockable().isVersioned()) {
                    this.getLockable().getVersionType().nullSafeSet(st, version, this.getLockable().getIdentifierType().getColumnSpan(factory) + 1, session);
                }
                ResultSet rs = st.executeQuery();
                try {
                    if (!rs.next()) {
                        if (factory.getStatistics().isStatisticsEnabled()) {
                            factory.getStatisticsImplementor().optimisticFailure(this.getLockable().getEntityName());
                        }
                        throw new StaleObjectStateException(this.getLockable().getEntityName(), id);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                st.close();
            }
        }
        catch (SQLException sqle) {
            JDBCException e = session.getFactory().getSQLExceptionHelper().convert(sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this.getLockable(), id, session.getFactory()), sql);
            throw new PessimisticLockException("could not obtain pessimistic lock", e, object);
        }
    }

    @Override
    protected String generateLockString(int lockTimeout) {
        SessionFactoryImplementor factory = this.getLockable().getFactory();
        LockOptions lockOptions = new LockOptions(this.getLockMode());
        lockOptions.setTimeOut(lockTimeout);
        SimpleSelect select = new SimpleSelect(factory.getDialect()).setLockOptions(lockOptions).setTableName(this.getLockable().getRootTableName()).addColumn(this.getLockable().getRootTableIdentifierColumnNames()[0]).addCondition(this.getLockable().getRootTableIdentifierColumnNames(), "=?");
        if (this.getLockable().isVersioned()) {
            select.addCondition(this.getLockable().getVersionColumnName(), "=?");
        }
        if (factory.getSettings().isCommentsEnabled()) {
            select.setComment((Object)((Object)this.getLockMode()) + " lock " + this.getLockable().getEntityName());
        }
        return select.toStatementString();
    }
}

