/*
 * Decompiled with CFR 0.152.
 */
package org.swtjar.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.ZipFileSet;
import org.swtjar.SWTLoader;

public class SWTJarTask
extends Jar {
    private String targetmainclass = null;
    private String swtversion = null;

    public void setTargetmainclass(String targetmainclass) {
        this.targetmainclass = targetmainclass;
    }

    public void setSwtversion(String swtversion) {
        this.swtversion = swtversion;
    }

    public void execute() throws BuildException {
        if (this.targetmainclass == null) {
            throw new BuildException("Must specify targetmainclass");
        }
        if (this.swtversion == null) {
            throw new BuildException("Must specify swtversion");
        }
        try {
            Manifest swtAttrs = new Manifest();
            swtAttrs.getMainSection().addConfiguredAttribute(new Manifest.Attribute("SwtJar-TargetMainClass", this.targetmainclass));
            swtAttrs.getMainSection().addConfiguredAttribute(new Manifest.Attribute("SwtJar-SwtVersion", this.swtversion));
            swtAttrs.getMainSection().addConfiguredAttribute(new Manifest.Attribute("Main-Class", SWTLoader.class.getName()));
            this.addConfiguredManifest(swtAttrs);
        }
        catch (ManifestException ex) {
            throw new BuildException("Failed to construct SWT manifest: " + ex.getMessage());
        }
        ZipFileSet zset = new ZipFileSet();
        String jarFile = this.getJarFilePath();
        System.out.println(jarFile);
        zset.setSrc(new File(jarFile));
        zset.setIncludes("**/jarinjarloader/**/*.class,**/SWTLoader*.class");
        this.addZipfileset(zset);
        super.execute();
    }

    private String getJarFilePath() {
        String name = ((Object)((Object)this)).getClass().getName().replace('.', '/');
        name = ((Object)((Object)this)).getClass().getResource("/" + name + ".class").toString();
        int jarIndex = name.indexOf(".jar");
        if (jarIndex < 0) {
            throw new BuildException("This class must be run from within a JAR file");
        }
        name = name.substring(0, jarIndex + ".jar".length());
        name = name.substring(name.lastIndexOf(58) + 1);
        name = name.replace('%', ' ');
        name = name.replace('/', File.separatorChar);
        return name;
    }
}

