/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JOptionPane;

final class WindowUtils {
    private static final String PROPERTY_FOCUSED_WINDOW = "focusedWindow";
    private static Reference lastFocusManager = new WeakReference<Object>(null);
    private static Reference lastFocusedWindow = lastFocusManager;
    private static Reference parent;
    private static PropertyChangeListener focusListener;

    private WindowUtils() {
    }

    public static synchronized Window getParentWindow() {
        Window w;
        Window window = w = parent != null ? (Window)parent.get() : null;
        if (w == null && (w = WindowUtils.getLastFocusedWindow()) == null) {
            w = WindowUtils.getAnyShowingWindow();
        }
        for (Container c = w; c != null; c = c.getParent()) {
            if (!(c instanceof Window) || !((Component)c).isShowing()) continue;
            return c;
        }
        return JOptionPane.getRootFrame();
    }

    public static synchronized void setParentWindow(Window w) {
        parent = w != null ? new WeakReference<Window>(w) : null;
    }

    public static Window getLastFocusedWindow() {
        WindowUtils.observeFocusedWindow();
        return (Window)lastFocusedWindow.get();
    }

    private static synchronized void observeFocusedWindow() {
        KeyboardFocusManager lfm = (KeyboardFocusManager)lastFocusManager.get();
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (fm == lfm) {
            return;
        }
        if (lfm != null) {
            lfm.removePropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        }
        fm.addPropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        lastFocusManager = new WeakReference<KeyboardFocusManager>(fm);
        lastFocusedWindow = new WeakReference<Window>(fm.getFocusedWindow());
    }

    private static final Window getAnyShowingWindow() {
        return WindowUtils.getAnyShowingWindow(Frame.getFrames());
    }

    private static Window getAnyShowingWindow(Window[] windows) {
        int l = windows.length;
        for (int i = 0; i < l; ++i) {
            Window window = windows[i];
            if (window.isShowing()) {
                return window;
            }
            if ((window = WindowUtils.getAnyShowingWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    static {
        focusListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Window w = (Window)evt.getNewValue();
                if (w != null) {
                    lastFocusedWindow = new WeakReference<Window>(w);
                }
            }
        };
    }
}

