/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.richfaces.component.UITree;
import org.richfaces.component.state.events.TreeStateCommandsListener;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;

public class TreeState
implements DataComponentState,
TreeStateCommandsListener,
StateHolder,
Serializable {
    private static final long serialVersionUID = 9083705369340888171L;
    private static final TreeRange RANGE_UNCONSTRAINED = new TreeRange(){

        public boolean processChildren(TreeRowKey rowKey) {
            return true;
        }

        public boolean processNode(TreeRowKey rowKey) {
            return true;
        }
    };
    private boolean stopInCollapsed = false;
    private TreeRowKey selectedNode = null;
    private Set expandedNodes = new HashSet();
    private Set queuedExpandedNodes = new HashSet();
    private Set queuedCollapsedNodes = new HashSet();
    private boolean _transient;
    private transient TreeRange treeRange = null;

    public TreeState() {
    }

    public TreeState(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    public boolean isExpanded(TreeRowKey rowKey) {
        if (rowKey == null) {
            return true;
        }
        return this.expandedNodes.contains(rowKey) || this.queuedExpandedNodes.contains(rowKey);
    }

    public boolean isSelected(TreeRowKey rowKey) {
        return rowKey == null && this.selectedNode == null || this.selectedNode != null && this.selectedNode.equals(rowKey);
    }

    public TreeRowKey getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelected(TreeRowKey rowKey) {
        this.selectedNode = rowKey;
    }

    public Range getRange() {
        if (this.treeRange != null) {
            return this.treeRange;
        }
        if (this.stopInCollapsed) {
            return new TreeRange(){

                public boolean processChildren(TreeRowKey rowKey) {
                    if (rowKey == null) {
                        return true;
                    }
                    return TreeState.this.expandedNodes.contains(rowKey);
                }

                public boolean processNode(TreeRowKey rowKey) {
                    return true;
                }
            };
        }
        return RANGE_UNCONSTRAINED;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        this.expandedNodes = (Set)_state[0];
        this._transient = (Boolean)_state[1];
        this.stopInCollapsed = (Boolean)_state[2];
        this.selectedNode = (TreeRowKey)_state[3];
        this.queuedExpandedNodes = (Set)_state[4];
        this.queuedCollapsedNodes = (Set)_state[5];
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.expandedNodes, new Boolean(this._transient), new Boolean(this.stopInCollapsed), this.selectedNode, this.queuedExpandedNodes, this.queuedCollapsedNodes};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public boolean isStopInCollapsed() {
        return this.stopInCollapsed;
    }

    public void setStopInCollapsed(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitNodes(UITree tree, TreeRange treeRange, TreeRowKey rootKey) throws IOException {
        try {
            this.treeRange = treeRange;
            Object oldKey = tree.getRowKey();
            tree.walkModel(FacesContext.getCurrentInstance(), new Visitor(rootKey, tree), (Range)treeRange, rootKey, null);
            tree.setRowKey(oldKey);
        }
        finally {
            this.treeRange = null;
        }
    }

    public void expandAll(UITree tree) throws IOException {
        this.queuedCollapsedNodes.clear();
        this.visitNodes(tree, RANGE_UNCONSTRAINED, null);
    }

    public void collapseAll(UITree tree) throws IOException {
        this.expandedNodes.clear();
        this.queuedExpandedNodes.clear();
    }

    public void collapseNode(UITree tree, TreeRowKey rowKey) throws IOException {
        this.expandedNodes.remove(rowKey);
        this.queuedExpandedNodes.remove(rowKey);
        this.queuedCollapsedNodes.add(rowKey);
    }

    public void expandNode(UITree tree, final TreeRowKey rowKey) throws IOException {
        TreeRange range = new TreeRange(){

            public boolean processChildren(TreeRowKey nextKey) {
                return true;
            }

            public boolean processNode(TreeRowKey nextKey) {
                return rowKey == null && nextKey == null || nextKey.equals(rowKey) || nextKey.isSubKey(rowKey);
            }
        };
        this.visitNodes(tree, range, rowKey);
    }

    public void transferQueuedNodes() {
        this.expandedNodes.addAll(this.queuedExpandedNodes);
        this.queuedExpandedNodes.clear();
        this.expandedNodes.removeAll(this.queuedCollapsedNodes);
        this.queuedCollapsedNodes.clear();
    }

    private final class Visitor
    implements DataVisitor {
        private TreeRowKey key;
        private UITree tree;

        public Visitor(TreeRowKey key, UITree tree) {
            this.key = key;
            this.tree = tree;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            this.tree.setRowKey(context, rowKey);
            if (this.tree.isRowAvailable()) {
                TreeRowKey nextKey = (TreeRowKey)rowKey;
                if (!this.tree.isLeaf() && nextKey != null && (this.key == null || nextKey.isSubKey(this.key) || nextKey.equals(this.key))) {
                    if (this.tree.isImmediate()) {
                        TreeState.this.queuedExpandedNodes.add(nextKey);
                    } else {
                        TreeState.this.expandedNodes.add(nextKey);
                    }
                    TreeState.this.queuedCollapsedNodes.remove(nextKey);
                }
            } else {
                FacesMessage message = new FacesMessage("Row key: " + rowKey + " isn't available!");
                message.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.tree.getBaseClientId(context), message);
            }
        }
    }
}

