/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 * 2001/04/08: kjenks: Initial author
 * 2001/06/14: jpedersen: Updated javadoc, removed abstract from methods
 */
package javax.sql;

import java.sql.SQLException;

/**
 * An object implementing the RowSetReader interface may be registered with a RowSet object that supports
 * the reader/writer paradigm. A RowSetReader object is called by a rowset to produce a new set of rows which
 * will become the rowset's contents. 
 */
public interface RowSetReader {
  /**
   * <p>Read the new contents of a rowset. This method is invoked internally by the RowSet.execute()
   * method for rowsets that support the reader/writer paradigm.</p>
   *
   * <p>The readData() method uses the RowSet.insertRow() or RowSet.populate() methods to add rows
   * to the caller. In general, any of the caller's methods may be called by the reader with one
   * exception, calling execute() will throw an SQLException since execute may not be called
   * recursively. Also, rowset events, such as RowSetChanged, etc. are not generated by RowSet methods
   * invoked by a reader.</p>
   *
   * @param rowSetInternal - the rowset that called the reader
   * @exception SQLException - if a database-access error occurs
   */
  public void readData(RowSetInternal rowSetInternal)
    throws SQLException;
}
