/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.security.jacc;

/** This checked exception is thrown by the policy context and configuration
 * classes.
 * 
 * @see http://java.sun.com/j2ee/1.4/docs/api/
 * @see javax.security.jacc.PolicyConfiguration
 * @see javax.security.jacc.PolicyConfigurationFactory
 * @see javax.security.jacc.PolicyContext
 * 
 * @author Scott.Stark@jboss.org
 * @author Ron Monzillo, Gary Ellison (javadoc)
 * @version $Revision: 1.1 $
 */
public class PolicyContextException extends Exception
{
   public PolicyContextException()
   {
   }

   public PolicyContextException(String msg)
   {
      super(msg);
   }

   public PolicyContextException(String msg, Throwable cause)
   {
      super(msg, cause);
   }

   public PolicyContextException(Throwable cause)
   {
      super(cause);
   }
}
