/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * An optioanl mixin interface for connection managers that support the lazy connection
 * association optimization.
 */
public interface LazyAssociatableConnectionManager
{
   /**
    * Invoked by a resource adapter to lazily associate a connection handle with the managed connection
    *
    * @param connection the connection handle
    * @param mcf the managed connection factory
    * @param cxRequestInfo the connection request info
    * @throws ResourceException for an generic error
    * @throws ApplicationServerInternalException for problems in the application server
    * @throws SecurityException for security problems
    * @throws ResourceAllocationException for problems allocating resources
    * @throws ResourceAdapterInternalException for errors from the resource adapter 
    */
   void associateConnection(Object connection, ManagedConnectionFactory mcf, ConnectionRequestInfo cxReqInfo) throws ResourceException;
}