/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.agent;

import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.CpuBciProfilerMXBeanImpl;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.DataTransferMXBeanImpl;
import org.jboss.tools.jmx.jvmmonitor.internal.agent.SWTResourceMonitorMXBeanImpl;

public class Agent {
    public static void premain(String agentArgs, Instrumentation inst) {
        try {
            Agent.init(Agent.getAgentJar(), inst);
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot not register CpuBciProfilerMXBean.", new Object[0]);
        }
    }

    public static void agentmain(String options, Instrumentation inst) {
        try {
            Agent.init(options, inst);
        }
        catch (Throwable t) {
            Agent.logError(t, "Cannot not register CpuBciProfilerMXBean.", new Object[0]);
        }
    }

    protected static void logInfo(String format, Object ... args) {
        Logger.getLogger("org.jboss.tools.jmx.jvmmonitor.agent").fine(String.format(format, args));
    }

    protected static void logError(Throwable t, String format, Object ... args) {
        Logger.getLogger("org.jboss.tools.jmx.jvmmonitor.agent").log(Level.SEVERE, String.format(format, args), t);
    }

    private static void init(String agentJar, Instrumentation inst) throws Throwable {
        inst.appendToBootstrapClassLoaderSearch(new JarFile(agentJar));
        if (Agent.registerMXBeans(inst)) {
            Agent.logInfo("Agent has been loaded.", new Object[0]);
        } else {
            Agent.logInfo("Agent has been already loaded.", new Object[0]);
        }
    }

    private static String getAgentJar() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMXBean.getInputArguments();
        for (String argument : arguments) {
            if (!argument.contains("-javaagent:")) continue;
            return argument.replace("-javaagent:", "");
        }
        throw new IllegalStateException();
    }

    private static boolean registerMXBeans(Instrumentation inst) throws Throwable {
        boolean agentLoaded = false;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName profilerObjectName = new ObjectName("org.jboss.tools.jmx.jvmmonitor:type=CPU BCI Profiler");
        ObjectName dataTransferObjectName = new ObjectName("org.jboss.tools.jmx.jvmmonitor:type=Data Transfer");
        ObjectName swtResourceMonitorObjectName = new ObjectName("org.jboss.tools.jmx.jvmmonitor:type=SWT Resource Monitor");
        if (!server.isRegistered(profilerObjectName)) {
            CpuBciProfilerMXBeanImpl profiler = new CpuBciProfilerMXBeanImpl(inst);
            server.registerMBean(profiler, profilerObjectName);
            agentLoaded = true;
        }
        if (!server.isRegistered(dataTransferObjectName)) {
            DataTransferMXBeanImpl dataTransfer = new DataTransferMXBeanImpl();
            server.registerMBean(dataTransfer, dataTransferObjectName);
            agentLoaded = true;
        }
        if (!server.isRegistered(swtResourceMonitorObjectName)) {
            SWTResourceMonitorMXBeanImpl swtResourceMonitor = new SWTResourceMonitorMXBeanImpl(inst);
            if (swtResourceMonitor.isSuppoted()) {
                server.registerMBean(swtResourceMonitor, swtResourceMonitorObjectName);
            }
            agentLoaded = true;
        }
        return agentLoaded;
    }
}

