/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String RENDERKIT = "render-kit";
    private static final String RENDERKIT_ID = "render-kit-id";
    private static final String RENDERKIT_CLASS = "render-kit-class";
    private static final String RENDERER = "renderer";
    private static final String RENDERER_FAMILY = "component-family";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String RENDERER_CLASS = "renderer-class";
    private static final String CLIENT_BEHAVIOR_RENDERER = "client-behavior-renderer";
    private static final String CLIENT_BEHAVIOR_RENDERER_TYPE = "client-behavior-renderer-type";
    private static final String CLIENT_BEHAVIOR_RENDERER_CLASS = "client-behavior-renderer-class";

    @Override
    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        RenderKit rk;
        LinkedHashMap<String, Map<Document, List<Node>>> renderers = new LinkedHashMap<String, Map<Document, List<Node>>>();
        LinkedHashMap<String, Map<Document, List<Node>>> behaviorRenderers = new LinkedHashMap<String, Map<Document, List<Node>>>();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing render-kit elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList renderkits = document.getDocumentElement().getElementsByTagNameNS(namespace, RENDERKIT);
            if (renderkits == null || renderkits.getLength() <= 0) continue;
            this.addRenderKits(renderkits, document, renderers, behaviorRenderers, rkf);
        }
        this.processAnnotations(FacesRenderer.class);
        this.processAnnotations(FacesBehaviorRenderer.class);
        for (Map.Entry entry : renderers.entrySet()) {
            rk = rkf.getRenderKit(null, (String)entry.getKey());
            if (rk == null) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.CONFIG_RENDERER_REGISTRATION_MISSING_RENDERKIT", entry.getKey()));
            }
            for (Map.Entry renderEntry : ((Map)entry.getValue()).entrySet()) {
                this.addRenderers(rk, (Document)renderEntry.getKey(), (List)renderEntry.getValue());
            }
        }
        for (Map.Entry entry : behaviorRenderers.entrySet()) {
            rk = rkf.getRenderKit(null, (String)entry.getKey());
            if (rk == null) {
                throw new ConfigurationException(MessageUtils.getExceptionMessageString("com.sun.faces.CONFIG_RENDERER_REGISTRATION_MISSING_RENDERKIT", entry.getKey()));
            }
            for (Map.Entry renderEntry : ((Map)entry.getValue()).entrySet()) {
                this.addClientBehaviorRenderers(rk, (Document)renderEntry.getKey(), (List)renderEntry.getValue());
            }
        }
        this.invokeNext(sc, documentInfos);
    }

    private void addRenderKits(NodeList renderKits, Document owningDocument, Map<String, Map<Document, List<Node>>> renderers, Map<String, Map<Document, List<Node>>> behaviorRenderers, RenderKitFactory rkf) {
        String namespace = owningDocument.getDocumentElement().getNamespaceURI();
        int size = renderKits.getLength();
        for (int i = 0; i < size; ++i) {
            Map<Document, List<Node>> existingRenderers;
            Node renderKit = renderKits.item(i);
            NodeList children = ((Element)renderKit).getElementsByTagNameNS(namespace, "*");
            String rkId = null;
            String rkClass = null;
            ArrayList<Node> renderersList = new ArrayList<Node>(children.getLength());
            ArrayList<Node> behaviorRenderersList = new ArrayList<Node>(children.getLength());
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (RENDERKIT_ID.equals(n.getLocalName())) {
                    rkId = this.getNodeText(n);
                    continue;
                }
                if (RENDERKIT_CLASS.equals(n.getLocalName())) {
                    rkClass = this.getNodeText(n);
                    continue;
                }
                if (RENDERER.equals(n.getLocalName())) {
                    renderersList.add(n);
                    continue;
                }
                if (!CLIENT_BEHAVIOR_RENDERER.equals(n.getLocalName())) continue;
                behaviorRenderersList.add(n);
            }
            String string = rkId = rkId == null ? "HTML_BASIC" : rkId;
            if (rkClass != null) {
                RenderKit previous = rkf.getRenderKit(FacesContext.getCurrentInstance(), rkId);
                RenderKit rk = (RenderKit)this.createInstance(rkClass, RenderKit.class, previous, renderKit);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKitFactory.addRenderKit({0}, {1})", rkId, rkClass));
                }
                rkf.addRenderKit(rkId, rk);
            }
            if ((existingRenderers = renderers.get(rkId)) != null) {
                List<Node> list = existingRenderers.get(owningDocument);
                if (list != null) {
                    list.addAll(renderersList);
                } else {
                    existingRenderers.put(owningDocument, renderersList);
                }
            } else {
                existingRenderers = new LinkedHashMap<Document, List<Node>>();
                existingRenderers.put(owningDocument, renderersList);
            }
            renderers.put(rkId, existingRenderers);
            Map<Document, List<Node>> existingBehaviorRenderers = behaviorRenderers.get(rkId);
            if (existingBehaviorRenderers != null) {
                List<Node> list = existingBehaviorRenderers.get(owningDocument);
                if (list != null) {
                    list.addAll(behaviorRenderersList);
                } else {
                    existingBehaviorRenderers.put(owningDocument, behaviorRenderersList);
                }
            } else {
                existingBehaviorRenderers = new LinkedHashMap<Document, List<Node>>();
                existingBehaviorRenderers.put(owningDocument, behaviorRenderersList);
            }
            behaviorRenderers.put(rkId, existingBehaviorRenderers);
        }
    }

    private void addRenderers(RenderKit renderKit, Document owningDocument, List<Node> renderers) {
        String namespace = owningDocument.getDocumentElement().getNamespaceURI();
        for (Node renderer : renderers) {
            Renderer r;
            NodeList children = ((Element)renderer).getElementsByTagNameNS(namespace, "*");
            String rendererFamily = null;
            String rendererType = null;
            String rendererClass = null;
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                if (RENDERER_FAMILY.equals(n.getLocalName())) {
                    rendererFamily = this.getNodeText(n);
                    continue;
                }
                if (RENDERER_TYPE.equals(n.getLocalName())) {
                    rendererType = this.getNodeText(n);
                    continue;
                }
                if (!RENDERER_CLASS.equals(n.getLocalName())) continue;
                rendererClass = this.getNodeText(n);
            }
            if (rendererFamily == null || rendererType == null || rendererClass == null || (r = (Renderer)this.createInstance(rendererClass, Renderer.class, null, renderer)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKit.addRenderer({0},{1}, {2}) for RenderKit ''{3}''", rendererFamily, rendererType, rendererClass, renderKit.getClass()));
            }
            renderKit.addRenderer(rendererFamily, rendererType, r);
        }
    }

    private void addClientBehaviorRenderers(RenderKit renderKit, Document owningDocument, List<Node> behaviorRenderers) {
        String namespace = owningDocument.getDocumentElement().getNamespaceURI();
        for (Node behaviorRenderer : behaviorRenderers) {
            ClientBehaviorRenderer r;
            NodeList children = ((Element)behaviorRenderer).getElementsByTagNameNS(namespace, "*");
            String behaviorRendererType = null;
            String behaviorRendererClass = null;
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                if (CLIENT_BEHAVIOR_RENDERER_TYPE.equals(n.getLocalName())) {
                    behaviorRendererType = this.getNodeText(n);
                    continue;
                }
                if (!CLIENT_BEHAVIOR_RENDERER_CLASS.equals(n.getLocalName())) continue;
                behaviorRendererClass = this.getNodeText(n);
            }
            if (behaviorRendererType == null || behaviorRendererClass == null || (r = (ClientBehaviorRenderer)this.createInstance(behaviorRendererClass, ClientBehaviorRenderer.class, null, behaviorRenderer)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKit.addClientBehaviorRenderer({0},{1}, {2}) for RenderKit ''{2}''", behaviorRendererType, behaviorRendererClass, renderKit.getClass()));
            }
            renderKit.addClientBehaviorRenderer(behaviorRendererType, r);
        }
    }
}

