/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicesUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$ajax4jsf$util$ServicesUtils == null ? (class$org$ajax4jsf$util$ServicesUtils = ServicesUtils.class$("org.ajax4jsf.util.ServicesUtils")) : class$org$ajax4jsf$util$ServicesUtils));
    private static Map _services = Collections.synchronizedMap(new HashMap());
    private static Map _instances = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$ajax4jsf$util$ServicesUtils;

    private ServicesUtils() {
    }

    public static Class getService(String name) throws ClassNotFoundException {
        ClassLoader loader;
        Class serviceClass;
        Map<ClassLoader, Class> contextClasses = (Map<ClassLoader, Class>)_services.get(name);
        if (null == contextClasses) {
            contextClasses = Collections.synchronizedMap(new HashMap());
            _services.put(name, contextClasses);
        }
        if (null == (serviceClass = (Class)contextClasses.get(loader = Thread.currentThread().getContextClassLoader()))) {
            serviceClass = ServicesUtils.loadServiceClass(loader, name);
            contextClasses.put(loader, serviceClass);
        }
        return serviceClass;
    }

    public static Object getServiceInstance(String name) {
        ClassLoader loader;
        Object serviceInstance;
        Map contextInstances = (Map)_instances.get(name);
        if (null == contextInstances) {
            contextInstances = Collections.synchronizedMap(new HashMap());
            _instances.put(name, contextInstances);
        }
        if (null == (serviceInstance = contextInstances.get(loader = Thread.currentThread().getContextClassLoader()))) {
            try {
                Class serviceClass = ServicesUtils.loadServiceClass(loader, name);
                serviceInstance = serviceClass.newInstance();
            }
            catch (Exception e) {
                throw new FacesException("Error create instance for service " + name, (Throwable)e);
            }
            contextInstances.put(loader, serviceInstance);
        }
        return serviceInstance;
    }

    public static Class loadServiceClass(ClassLoader loader, String name) throws ClassNotFoundException {
        Class serviceClass;
        block3: {
            try {
                String resource = "META-INF/services/" + name;
                InputStream in = URLToStreamHelper.urlToStreamSafe((URL)loader.getResource(resource));
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String serviceClassName = reader.readLine();
                reader.close();
                serviceClass = ServicesUtils.loadClass(loader, serviceClassName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Class for service " + name + " set to " + serviceClassName));
                }
            }
            catch (Exception e) {
                serviceClass = ServicesUtils.loadClass(loader, name);
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Service class set to default implementation " + name));
            }
        }
        return serviceClass;
    }

    public static Class loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Class " + name + "not found by Context Classloader"));
            }
            clazz = (class$org$ajax4jsf$util$ServicesUtils == null ? (class$org$ajax4jsf$util$ServicesUtils = ServicesUtils.class$("org.ajax4jsf.util.ServicesUtils")) : class$org$ajax4jsf$util$ServicesUtils).getClassLoader().loadClass(name);
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

