/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.Messages;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.resource.InternetResourceService;
import org.ajax4jsf.webapp.BaseXMLFilter;
import org.ajax4jsf.webapp.Log4JConfigurator;
import org.ajax4jsf.webapp.PollEventsManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseFilter
implements Filter {
    public static final String AJAX_PUSH_KEY_HEADER = "Ajax-Push-Key";
    private static final Log log = LogFactory.getLog((Class)(class$org$ajax4jsf$webapp$BaseFilter == null ? (class$org$ajax4jsf$webapp$BaseFilter = BaseFilter.class$("org.ajax4jsf.webapp.BaseFilter")) : class$org$ajax4jsf$webapp$BaseFilter));
    public static final boolean DEBUG = true;
    private FilterConfig filterConfig;
    private static final String FUNCTION_NAME_PARAMETER = "function";
    private String function = "alert('Data received');JSHttpRequest.dataReady";
    private String attributesNames;
    private boolean rewriteid = false;
    public static final String REWRITEID_PARAMETER = "rewriteid";
    public static final String STYLESHEET_PARAMETER = "xsl";
    public static final String ABSOLUTE_TAGS_PARAMETER = "absolute-attributes";
    private static final long serialVersionUID = -2295534611886142935L;
    public static final String DATA_PARAMETER = "DATA";
    public static final String DEFAULT_SERVLET_PATH = "/resource";
    public static final String RENDERER_PREFIX = "/renderer";
    public static final String CACHEABLE_PREFIX = "/cache";
    public static final String FILTER_PERFORMED = "com.exade.vcp.Filter.done";
    public static final String RESPONSE_WRAPPER_ATTRIBUTE = "com.exade.vcp.Filter.ResponseWrapper";
    protected BaseXMLFilter xmlFilter = null;
    protected InternetResourceService resourceService = null;
    protected PollEventsManager eventsManager;
    static /* synthetic */ Class class$org$ajax4jsf$webapp$BaseFilter;

    public void init(FilterConfig config) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Init ajax4jsf filter with nane: " + config.getFilterName()));
            Enumeration parameterNames = config.getInitParameterNames();
            StringBuffer parameters = new StringBuffer("Init parameters :\n");
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                parameters.append(name).append(" : '").append(config.getInitParameter(name)).append('\n');
            }
            log.debug((Object)parameters);
        }
        this.filterConfig = config;
        this.setFunction((String)this.nz(this.filterConfig.getInitParameter(FUNCTION_NAME_PARAMETER), this.getFunction()));
        this.setAttributesNames(this.filterConfig.getInitParameter(ABSOLUTE_TAGS_PARAMETER));
        this.xmlFilter.init(config);
        if ("true".equalsIgnoreCase(this.filterConfig.getInitParameter(REWRITEID_PARAMETER))) {
            this.setRewriteid(true);
        }
        String prefix = this.filterConfig.getServletContext().getRealPath("/");
        String file = this.filterConfig.getInitParameter("log4j-init-file");
        if (file != null) {
            Log4JConfigurator log4jconfig = new Log4JConfigurator(prefix);
            log4jconfig.doConfigure(file);
        }
        this.resourceService = new InternetResourceService();
        this.resourceService.init(this.filterConfig);
        this.eventsManager = new PollEventsManager();
        this.eventsManager.init(this.filterConfig.getServletContext());
    }

    protected void setupRequestEncoding(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        String contentType = httpServletRequest.getHeader("Content-Type");
        String characterEncoding = this.lookupCharacterEncoding(contentType);
        if (characterEncoding == null) {
            HttpSession session = httpServletRequest.getSession(false);
            if (session != null) {
                characterEncoding = (String)session.getAttribute("javax.faces.request.charset");
            }
            if (characterEncoding != null) {
                httpServletRequest.setCharacterEncoding(characterEncoding);
            }
        }
    }

    private String lookupCharacterEncoding(String contentType) {
        String characterEncoding = null;
        if (contentType != null) {
            int charsetFind = contentType.indexOf("charset=");
            if (charsetFind != -1) {
                if (charsetFind == 0) {
                    characterEncoding = contentType.substring(8);
                } else {
                    char charBefore = contentType.charAt(charsetFind - 1);
                    if (charBefore == ';' || Character.isWhitespace(charBefore)) {
                        characterEncoding = contentType.substring(charsetFind + 8);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage((String)"CONTENT_TYPE_ENCODING", (Object)characterEncoding));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"CONTENT_TYPE_NO_ENCODING", (Object)contentType));
            }
        }
        return characterEncoding;
    }

    private Object nz(Object param, Object def) {
        return param != null ? param : def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        startTimeMills = 0L;
        httpServletRequest = (HttpServletRequest)request;
        httpServletResponse = (HttpServletResponse)response;
        if (BaseFilter.log.isDebugEnabled()) {
            startTimeMills = System.currentTimeMillis();
            BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_START_INFO", (Object)new Date(startTimeMills), (Object)httpServletRequest.getRequestURI()));
        }
        if (request.getAttribute("com.exade.vcp.Filter.done") != Boolean.TRUE) {
            try {
                request.setAttribute("com.exade.vcp.Filter.done", (Object)Boolean.TRUE);
                ajaxPushHeader = httpServletRequest.getHeader("Ajax-Push-Key");
                if (httpServletRequest.getMethod().equals("HEAD") && null != ajaxPushHeader) {
                    listener = this.eventsManager.getListener(ajaxPushHeader);
                    if (listener.isPerformed()) {
                        listener.processed();
                        httpServletResponse.setStatus(200);
                        if (!BaseFilter.log.isDebugEnabled()) ** GOTO lbl39
                        BaseFilter.log.debug((Object)("Occurs event for a id " + ajaxPushHeader));
                    }
                    httpServletResponse.setStatus(204);
                    if (!BaseFilter.log.isDebugEnabled()) ** GOTO lbl39
                    BaseFilter.log.debug((Object)("No event for a id " + ajaxPushHeader));
                }
                if (this.getResourceService().serviceResource(httpServletRequest, httpServletResponse)) ** GOTO lbl39
                this.setupRequestEncoding(httpServletRequest);
                if (BaseFilter.log.isDebugEnabled()) {
                    BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_XML_OUTPUT"));
                }
                this.xmlFilter.doXmlFilter(chain, httpServletRequest, httpServletResponse);
            }
            finally {
                request.removeAttribute("com.exade.vcp.Filter.done");
                ajaxContext = request.getAttribute("ajaxContext");
                if (null != ajaxContext && ajaxContext instanceof AjaxContext) {
                    ((AjaxContext)ajaxContext).release();
                    request.removeAttribute("ajaxContext");
                }
            }
        } else {
            if (BaseFilter.log.isDebugEnabled()) {
                BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_NO_XML_CHAIN_2"));
            }
            chain.doFilter(request, response);
        }
lbl39:
        // 7 sources

        if (BaseFilter.log.isDebugEnabled()) {
            startTimeMills = System.currentTimeMillis() - startTimeMills;
            BaseFilter.log.debug((Object)Messages.getMessage((String)"FILTER_STOP_INFO", (Object)("" + startTimeMills), (Object)httpServletRequest.getRequestURI()));
        }
    }

    protected boolean isAjaxRequest(ServletRequest request) {
        try {
            return null != request.getParameter("AJAXREQUEST");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void destroy() {
    }

    ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected synchronized InternetResourceService getResourceService() throws ServletException {
        return this.resourceService;
    }

    protected void setFunction(String function) {
        this.function = function;
    }

    protected String getFunction() {
        return this.function;
    }

    protected void setRewriteid(boolean rewriteid) {
        this.rewriteid = rewriteid;
    }

    protected boolean isRewriteid() {
        return this.rewriteid;
    }

    protected void setAttributesNames(String attributesNames) {
        this.attributesNames = attributesNames;
    }

    protected String getAttributesNames() {
        return this.attributesNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

