/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.util;

import java.io.File;

public class Paths {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final String normalize(String path) {
        return Paths.normalize(path, File.separatorChar);
    }

    public static String normalize(String path, char separatorChar) {
        String result;
        int prefixLen = Paths.prefixLength(path, separatorChar);
        int pathLen = path.length();
        StringBuffer buffer = new StringBuffer(pathLen);
        Paths.normalize(path.substring(prefixLen, pathLen), separatorChar, 0, pathLen - prefixLen, buffer);
        buffer.insert(0, path.substring(0, prefixLen));
        if (buffer.length() == prefixLen && (prefixLen <= 0 || buffer.charAt(prefixLen - 1) != separatorChar)) {
            buffer.append('.');
        }
        if (pathLen > 0 && path.charAt(pathLen - 1) == separatorChar && buffer.charAt(buffer.length() - 1) != separatorChar) {
            buffer.append(separatorChar);
        }
        return path.equals(result = buffer.toString()) ? path : result;
    }

    private static int normalize(String path, char separatorChar, int skip, int end, StringBuffer result) {
        int resultLen;
        int skipped;
        if (!$assertionsDisabled && skip < 0) {
            throw new AssertionError();
        }
        if (end <= 0) {
            return 0;
        }
        int next = path.lastIndexOf(separatorChar, end - 1);
        String base = path.substring(next + 1, end);
        if (base.length() == 0 || ".".equals(base)) {
            return Paths.normalize(path, separatorChar, skip, next, result);
        }
        if ("..".equals(base)) {
            int toSkip = skip + 1;
            skipped = Paths.normalize(path, separatorChar, toSkip, next, result);
            if (!$assertionsDisabled && skipped > toSkip) {
                throw new AssertionError();
            }
            if (skipped == toSkip) {
                return skip;
            }
        } else {
            if (skip > 0) {
                return Paths.normalize(path, separatorChar, skip - 1, next, result) + 1;
            }
            if (!$assertionsDisabled && skip != 0) {
                throw new AssertionError();
            }
            skipped = Paths.normalize(path, separatorChar, skip, next, result);
            if (!$assertionsDisabled && skipped != 0) {
                throw new AssertionError();
            }
        }
        if ((resultLen = result.length()) > 0 && result.charAt(resultLen - 1) != separatorChar) {
            result.append(separatorChar);
        }
        result.append(base);
        return skipped;
    }

    public static final String cutTrailingSeparators(String path, char separatorChar) {
        int i = path.length();
        if (i <= 0 || path.charAt(--i) != separatorChar) {
            return path;
        }
        while (i > 0 && path.charAt(--i) == separatorChar) {
        }
        return path.substring(0, ++i);
    }

    public static final String cutTrailingSeparator(String path, char separatorChar) {
        int pathEnd = path.length() - 1;
        if (pathEnd > 0 && path.charAt(pathEnd) == separatorChar) {
            return path.substring(0, pathEnd);
        }
        return path;
    }

    public static final String[] split(String path) {
        return Paths.split(path, File.separatorChar);
    }

    public static final String[] split(String path, char separatorChar) {
        return Paths.split(path, separatorChar, new String[2]);
    }

    public static String[] split(String path, char separatorChar, String[] split) {
        int prefix = Paths.prefixLength(path, separatorChar);
        int base = -1;
        int end = path.length() - 1;
        if (prefix <= end) {
            end = Paths.lastIndexNot(path, separatorChar, end);
            base = path.lastIndexOf(separatorChar, end);
        }
        ++end;
        if (base >= prefix) {
            int j = Paths.lastIndexNot(path, separatorChar, base) + 1;
            split[0] = path.substring(0, j > prefix ? j : prefix);
            split[1] = path.substring(base + 1, end);
        } else {
            split[0] = 0 < prefix && prefix < end ? path.substring(0, prefix) : null;
            split[1] = path.substring(prefix, end);
        }
        return split;
    }

    private static int prefixLength(String path, char separatorChar) {
        char drive;
        int pathLen = path.length();
        int len = 0;
        if (pathLen > 0 && path.charAt(0) == separatorChar) {
            ++len;
        } else if (pathLen > 1 && path.charAt(1) == ':' && ('A' <= (drive = path.charAt(0)) && drive <= 'Z' || 'a' <= drive && drive <= 'z')) {
            len = 2;
        }
        if (pathLen > len && path.charAt(len) == separatorChar) {
            ++len;
        }
        return len;
    }

    private static final int lastIndexNot(String path, char separatorChar, int last) {
        while (path.charAt(last) == separatorChar && --last >= 0) {
        }
        return last;
    }

    protected Paths() {
    }

    static {
        $assertionsDisabled = !Paths.class.desiredAssertionStatus();
    }
}

