/*
 * Decompiled with CFR 0.152.
 */
package stopka.us.ui.app.link;

import stopka.us.ui.app.link.HtmlFragment;

public abstract class FileLink
implements HtmlFragment {
    private final String file;

    public FileLink(String file) {
        if (file == null) {
            throw new IllegalArgumentException("File couldn't be empty");
        }
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public String toHtml() {
        return this.toHtml("");
    }

    protected String toHtml(String htmlTemplate, String serverUrl, String resourcesDir) {
        return String.format(htmlTemplate, this.getUrl(serverUrl, resourcesDir));
    }

    protected String getUrl(String serverUrl, String resourcesDir) {
        assert (serverUrl != null);
        assert (resourcesDir != null && resourcesDir.length() > 0);
        StringBuilder url = new StringBuilder(serverUrl);
        if (!this.file.matches("(?:^|.*/)" + resourcesDir + "/.*")) {
            url.append(resourcesDir).append("/");
        }
        url.append(this.file);
        return url.toString();
    }

    public abstract String toHtml(String var1);

    public String toString() {
        return "FileLink{ file='" + this.file + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileLink)) {
            return false;
        }
        FileLink fileLink = (FileLink)o;
        return this.file == null ? fileLink.file == null : this.file.equals(fileLink.file);
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }
}

