/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.concurrent.atomic.AtomicLong;

public final class Timestamper {
    private static final int BIN_DIGITS = 12;
    public static final short ONE_MS = 4096;
    private static final AtomicLong VALUE = new AtomicLong();

    public static long next() {
        block0: while (true) {
            long base = System.currentTimeMillis() << 12;
            long maxValue = base + 4096L - 1L;
            long current = VALUE.get();
            long update = Math.max(base, current + 1L);
            while (true) {
                if (update >= maxValue) continue block0;
                if (VALUE.compareAndSet(current, update)) {
                    return update;
                }
                current = VALUE.get();
                update = Math.max(base, current + 1L);
            }
            break;
        }
    }

    private Timestamper() {
    }
}

