/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.classloading.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private final ClassLoader classClassLoader;
    private final ClassLoader resourcesClassLoader;

    public ClassLoaderServiceImpl() {
        this(ClassLoaderServiceImpl.class.getClassLoader());
    }

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this(classLoader, classLoader, classLoader, classLoader);
    }

    public ClassLoaderServiceImpl(ClassLoader applicationClassLoader, ClassLoader resourcesClassLoader, ClassLoader hibernateClassLoader, ClassLoader environmentClassLoader) {
        if (hibernateClassLoader == null) {
            hibernateClassLoader = ClassLoaderServiceImpl.class.getClassLoader();
        }
        if (environmentClassLoader == null || applicationClassLoader == null) {
            ClassLoader sysClassLoader = ClassLoaderServiceImpl.locateSystemClassLoader();
            ClassLoader tccl = ClassLoaderServiceImpl.locateTCCL();
            if (environmentClassLoader == null) {
                ClassLoader classLoader = environmentClassLoader = sysClassLoader != null ? sysClassLoader : hibernateClassLoader;
            }
            if (applicationClassLoader == null) {
                ClassLoader classLoader = applicationClassLoader = tccl != null ? tccl : hibernateClassLoader;
            }
        }
        if (resourcesClassLoader == null) {
            resourcesClassLoader = applicationClassLoader;
        }
        final LinkedHashSet<ClassLoader> classLoadingClassLoaders = new LinkedHashSet<ClassLoader>();
        classLoadingClassLoaders.add(applicationClassLoader);
        classLoadingClassLoaders.add(hibernateClassLoader);
        classLoadingClassLoaders.add(environmentClassLoader);
        this.classClassLoader = new ClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                for (ClassLoader loader : classLoadingClassLoaders) {
                    try {
                        return loader.loadClass(name);
                    }
                    catch (Exception ignore) {
                    }
                }
                throw new ClassNotFoundException("Could not load requested class : " + name);
            }
        };
        this.resourcesClassLoader = resourcesClassLoader;
    }

    public static ClassLoaderServiceImpl fromConfigSettings(Map configVales) {
        return new ClassLoaderServiceImpl((ClassLoader)configVales.get("hibernate.classLoader.application"), (ClassLoader)configVales.get("hibernate.classLoader.resources"), (ClassLoader)configVales.get("hibernate.classLoader.hibernate"), (ClassLoader)configVales.get("hibernate.classLoader.environment"));
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> Class<T> classForName(String className) {
        try {
            return this.classClassLoader.loadClass(className);
        }
        catch (Exception e) {
            throw new ClassLoadingException("Unable to load class [" + className + "]", e);
        }
    }

    @Override
    public URL locateResource(String name) {
        try {
            return new URL(name);
        }
        catch (Exception ignore) {
            try {
                return this.resourcesClassLoader.getResource(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public InputStream locateResourceStream(String name) {
        try {
            return new URL(name).openStream();
        }
        catch (Exception ignore) {
            try {
                return this.resourcesClassLoader.getResourceAsStream(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public List<URL> locateResources(String name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Enumeration<URL> urlEnumeration = this.resourcesClassLoader.getResources(name);
            if (urlEnumeration != null && urlEnumeration.hasMoreElements()) {
                while (urlEnumeration.hasMoreElements()) {
                    urls.add(urlEnumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    @Override
    public <S> LinkedHashSet<S> loadJavaServices(Class<S> serviceContract) {
        ClassLoader serviceLoaderClassLoader = new ClassLoader(){
            final ClassLoader[] classLoaderArray;
            {
                this.classLoaderArray = new ClassLoader[]{this.getClass().getClassLoader(), ClassLoaderServiceImpl.this.resourcesClassLoader, ClassLoaderServiceImpl.this.classClassLoader};
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                final HashSet<URL> resourceUrls = new HashSet<URL>();
                for (ClassLoader classLoader : this.classLoaderArray) {
                    Enumeration<URL> urls = classLoader.getResources(name);
                    while (urls.hasMoreElements()) {
                        resourceUrls.add(urls.nextElement());
                    }
                }
                return new Enumeration<URL>(){
                    final Iterator<URL> resourceUrlIterator;
                    {
                        this.resourceUrlIterator = resourceUrls.iterator();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.resourceUrlIterator.hasNext();
                    }

                    @Override
                    public URL nextElement() {
                        return this.resourceUrlIterator.next();
                    }
                };
            }

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                for (ClassLoader classLoader : this.classLoaderArray) {
                    try {
                        return classLoader.loadClass(name);
                    }
                    catch (Exception ignore) {
                    }
                }
                throw new ClassNotFoundException("Could not load requested class : " + name);
            }
        };
        ServiceLoader<S> loader = ServiceLoader.load(serviceContract, serviceLoaderClassLoader);
        LinkedHashSet<S> services = new LinkedHashSet<S>();
        for (S service : loader) {
            services.add(service);
        }
        return services;
    }
}

