/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.time;

import com.ocpsoft.pretty.time.Duration;
import com.ocpsoft.pretty.time.TimeFormat;

public class BasicTimeFormat
implements TimeFormat {
    private static final String NEGATIVE = "-";
    public static final String SIGN = "%s";
    public static final String QUANTITY = "%n";
    public static final String UNIT = "%u";
    private String pattern = "";
    private String futurePrefix = "";
    private String futureSuffix = "";
    private String pastPrefix = "";
    private String pastSuffix = "";
    private int roundingTolerance = 50;

    public String format(Duration duration) {
        String sign = this.getSign(duration);
        String unit = this.getGramaticallyCorrectName(duration);
        long quantity = this.getQuantity(duration);
        String result = this.applyPattern(sign, unit, quantity);
        result = this.decorate(sign, result);
        return result;
    }

    private String decorate(String sign, String result) {
        result = NEGATIVE.equals(sign) ? this.pastPrefix + " " + result + " " + this.pastSuffix : this.futurePrefix + " " + result + " " + this.futureSuffix;
        return result.replaceAll("\\s+", " ").trim();
    }

    private String applyPattern(String sign, String unit, long quantity) {
        String result = this.pattern.replaceAll(SIGN, sign);
        result = result.replaceAll(QUANTITY, String.valueOf(quantity));
        result = result.replaceAll(UNIT, unit);
        return result;
    }

    private long getQuantity(Duration duration) {
        double threshold;
        long quantity = Math.abs(duration.getQuantity());
        if (duration.getDelta() != 0L && (threshold = Math.abs((double)duration.getDelta() / (double)duration.getUnit().getMillisPerUnit() * 100.0)) > (double)this.roundingTolerance) {
            ++quantity;
        }
        return quantity;
    }

    private String getGramaticallyCorrectName(Duration d) {
        String result = d.getUnit().getName();
        if (Math.abs(this.getQuantity(d)) == 0L || Math.abs(this.getQuantity(d)) > 1L) {
            result = d.getUnit().getPluralName();
        }
        return result;
    }

    private String getSign(Duration d) {
        if (d.getQuantity() < 0L) {
            return NEGATIVE;
        }
        return "";
    }

    public BasicTimeFormat setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public BasicTimeFormat setFuturePrefix(String futurePrefix) {
        this.futurePrefix = futurePrefix.trim();
        return this;
    }

    public BasicTimeFormat setFutureSuffix(String futureSuffix) {
        this.futureSuffix = futureSuffix.trim();
        return this;
    }

    public BasicTimeFormat setPastPrefix(String pastPrefix) {
        this.pastPrefix = pastPrefix.trim();
        return this;
    }

    public BasicTimeFormat setPastSuffix(String pastSuffix) {
        this.pastSuffix = pastSuffix.trim();
        return this;
    }

    public BasicTimeFormat setRoundingTolerance(int roundingTolerance) {
        this.roundingTolerance = roundingTolerance;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getFuturePrefix() {
        return this.futurePrefix;
    }

    public String getFutureSuffix() {
        return this.futureSuffix;
    }

    public String getPastPrefix() {
        return this.pastPrefix;
    }

    public String getPastSuffix() {
        return this.pastSuffix;
    }

    public int getRoundingTolerance() {
        return this.roundingTolerance;
    }
}

