/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.DOMOutputImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ObjectFactory;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.parsers.DOMParserImpl;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.DOMSerializerImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class CoreDOMImplementationImpl
implements DOMImplementation,
DOMImplementationLS {
    private static final int SIZE = 2;
    private RevalidationHandler[] validators = new RevalidationHandler[2];
    private RevalidationHandler[] dtdValidators = new RevalidationHandler[2];
    private int freeValidatorIndex = -1;
    private int freeDTDValidatorIndex = -1;
    private int currentSize = 2;
    private int docAndDoctypeCounter = 0;
    static CoreDOMImplementationImpl singleton = new CoreDOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String string, String string2) {
        boolean bl;
        boolean bl2 = bl = string2 == null || string2.length() == 0;
        if (string.equalsIgnoreCase("+XPath") && (bl || string2.equals("3.0"))) {
            try {
                Class clazz = ObjectFactory.findProviderClass("org.apache.xpath.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!classArray[i].getName().equals("org.w3c.dom.xpath.XPathEvaluator")) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        return string.equalsIgnoreCase("Core") && (bl || string2.equals("1.0") || string2.equals("2.0") || string2.equals("3.0")) || string.equalsIgnoreCase("XML") && (bl || string2.equals("1.0") || string2.equals("2.0") || string2.equals("3.0")) || string.equalsIgnoreCase("LS") && (bl || string2.equals("3.0"));
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        this.checkQName(string);
        return new DocumentTypeImpl(null, string, string2, string3);
    }

    final void checkQName(String string) {
        int n;
        int n2 = string.indexOf(58);
        int n3 = string.lastIndexOf(58);
        int n4 = string.length();
        if (n2 == 0 || n2 == n4 - 1 || n3 != n2) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, string2);
        }
        int n5 = 0;
        if (n2 > 0) {
            if (!XMLChar.isNCNameStart(string.charAt(n5))) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, string3);
            }
            for (n = 1; n < n2; ++n) {
                if (XMLChar.isNCName(string.charAt(n))) continue;
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                throw new DOMException(5, string4);
            }
            n5 = n2 + 1;
        }
        if (!XMLChar.isNCNameStart(string.charAt(n5))) {
            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string5);
        }
        for (n = n5 + 1; n < n4; ++n) {
            if (XMLChar.isNCName(string.charAt(n))) continue;
            String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string6);
        }
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        if (documentType != null && documentType.getOwnerDocument() != null) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string3);
        }
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl(documentType);
        Element element = coreDocumentImpl.createElementNS(string, string2);
        coreDocumentImpl.appendChild(element);
        return coreDocumentImpl;
    }

    public Object getFeature(String string, String string2) {
        if (singleton.hasFeature(string, string2)) {
            if (string.equalsIgnoreCase("+XPath")) {
                try {
                    Class clazz = ObjectFactory.findProviderClass("org.apache.xpath.domapi.XPathEvaluatorImpl", ObjectFactory.findClassLoader(), true);
                    Class<?>[] classArray = clazz.getInterfaces();
                    for (int i = 0; i < classArray.length; ++i) {
                        if (!classArray[i].getName().equals("org.w3c.dom.xpath.XPathEvaluator")) continue;
                        return clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            } else {
                return singleton;
            }
        }
        return null;
    }

    public LSParser createLSParser(short s, String string) throws DOMException {
        if (s != 1 || string != null && !"http://www.w3.org/2001/XMLSchema".equals(string) && !"http://www.w3.org/TR/REC-xml".equals(string)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string2);
        }
        if (string != null && string.equals("http://www.w3.org/TR/REC-xml")) {
            return new DOMParserImpl("org.apache.xerces.parsers.DTDConfiguration", string);
        }
        return new DOMParserImpl("org.apache.xerces.parsers.XIncludeAwareParserConfiguration", string);
    }

    public LSSerializer createLSSerializer() {
        return new DOMSerializerImpl();
    }

    public LSInput createLSInput() {
        return new DOMInputImpl();
    }

    synchronized RevalidationHandler getValidator(String string) {
        if (string == "http://www.w3.org/2001/XMLSchema") {
            if (this.freeValidatorIndex < 0) {
                return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.xs.XMLSchemaValidator", ObjectFactory.findClassLoader(), true);
            }
            RevalidationHandler revalidationHandler = this.validators[this.freeValidatorIndex];
            this.validators[this.freeValidatorIndex--] = null;
            return revalidationHandler;
        }
        if (string == "http://www.w3.org/TR/REC-xml") {
            if (this.freeDTDValidatorIndex < 0) {
                return (RevalidationHandler)ObjectFactory.newInstance("org.apache.xerces.impl.dtd.XMLDTDValidator", ObjectFactory.findClassLoader(), true);
            }
            RevalidationHandler revalidationHandler = this.dtdValidators[this.freeDTDValidatorIndex];
            this.dtdValidators[this.freeDTDValidatorIndex--] = null;
            return revalidationHandler;
        }
        return null;
    }

    synchronized void releaseValidator(String string, RevalidationHandler revalidationHandler) {
        if (string == "http://www.w3.org/2001/XMLSchema") {
            ++this.freeValidatorIndex;
            if (this.validators.length == this.freeValidatorIndex) {
                this.currentSize += 2;
                RevalidationHandler[] revalidationHandlerArray = new RevalidationHandler[this.currentSize];
                System.arraycopy(this.validators, 0, revalidationHandlerArray, 0, this.validators.length);
                this.validators = revalidationHandlerArray;
            }
            this.validators[this.freeValidatorIndex] = revalidationHandler;
        } else if (string == "http://www.w3.org/TR/REC-xml") {
            ++this.freeDTDValidatorIndex;
            if (this.dtdValidators.length == this.freeDTDValidatorIndex) {
                this.currentSize += 2;
                RevalidationHandler[] revalidationHandlerArray = new RevalidationHandler[this.currentSize];
                System.arraycopy(this.dtdValidators, 0, revalidationHandlerArray, 0, this.dtdValidators.length);
                this.dtdValidators = revalidationHandlerArray;
            }
            this.dtdValidators[this.freeDTDValidatorIndex] = revalidationHandler;
        }
    }

    protected synchronized int assignDocumentNumber() {
        return ++this.docAndDoctypeCounter;
    }

    protected synchronized int assignDocTypeNumber() {
        return ++this.docAndDoctypeCounter;
    }

    public LSOutput createLSOutput() {
        return new DOMOutputImpl();
    }
}

