/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.tjws;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.tjws.AuthenticatedHttpServletRequest;
import org.jboss.resteasy.plugins.server.tjws.PatchedHttpServletRequest;

public class TJWSRequestPreProcessor {
    private SecurityDomain domain;
    private String contextPath = "";

    public TJWSRequestPreProcessor(SecurityDomain domain) {
        this.domain = domain;
    }

    public TJWSRequestPreProcessor() {
    }

    public void setContextPath(String contextPath) {
        if (contextPath == null) {
            contextPath = "";
        } else if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.contextPath = contextPath;
    }

    public void setSecurityDomain(SecurityDomain domain) {
        this.domain = domain;
    }

    public HttpServletRequest preProcessRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.domain != null) {
            String auth = request.getHeader("Authorization");
            if (auth != null && auth.length() > 5) {
                String type = auth.substring(0, 5);
                if ("basic".equals(type = type.toLowerCase())) {
                    String cookie = auth.substring(6);
                    cookie = new String(Base64.decodeBase64((byte[])cookie.getBytes()));
                    String[] split = cookie.split(":");
                    Principal user = null;
                    try {
                        user = this.domain.authenticate(split[0], split[1]);
                    }
                    catch (SecurityException e) {
                        response.sendError(401);
                        return null;
                    }
                    request = new AuthenticatedHttpServletRequest(request, this.domain, user, "BASIC", this.contextPath);
                }
            }
        } else {
            request = new PatchedHttpServletRequest(request, this.contextPath);
        }
        return request;
    }
}

