/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package javax.resource.cci;

import javax.resource.ResourceException;

/**
 * ResourceWarning provides information on warnings generated by the
 * underlying resource.  They are chained to an Interaction object for
 * later retrieval.
 */

public class ResourceWarning extends ResourceException {
    /**
     * Create an warning with a reason.
     */
    public ResourceWarning( String reason ) {
        super( reason );
    }

    /**
     * Create an warning with a reason and an errorCode.
     */
    public ResourceWarning( String reason, String errorCode ) {
        super( reason, errorCode );
    }

    /**
     * Set a linked warning.
     */
    public void setLinkedWarning( ResourceWarning linkedWarning ) {
        setLinkedException( linkedWarning );
    }

    /**
     * Get any linked warning.
     */
    public ResourceWarning getLinkedWarning() {
        return (ResourceWarning) getLinkedException();
    }
}
