/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package javax.ejb;

/**
 * <P>The EJBMetaData interface allows a client to obtain the enterprise
 * Bean's meta-data information. </P>
 * 
 * <P>The meta-data is intended for development tools used for building
 * applications that use deployed enterprise Beans, and for clients using
 * a scripting language to access the enterprise Bean. </P>
 * 
 * <P>Note that the EJBMetaData is not a remote interface. The class that
 * implements this interface (this class is typically generated by container
 * tools) must be serializable, and must be a valid RMI/IDL value type. </P>
 */
public interface EJBMetaData {

  /**
   * Obtains the home interface of the enterprise Bean.
   *
   * @return The home interface of the enterprise Bean.
   */
  public EJBHome getEJBHome();

  /**
   * Obtains the Class object for the enterprise Bean's home interface.
   *
   * @return The class object for the enterprise Bean's home interface.
   */
  public Class getHomeInterfaceClass();

   /**
    * Obtains the Class object for the enterprise Bean's remote interface.
    *
    * @return The class object for the enterprise Bean's remote interface.
    */
   public Class getRemoteInterfaceClass();

  /**
   * Obtains the Class object for the enterprise Bean's primary key class.
   *
   * @return The class object for the enterprise Bean's primary key class.
   */
  public Class getPrimaryKeyClass();

  /**
   * Tests if the type of the enterprise Bean is "session".
   *
   * @return True if the type of the enterprise Bean is session bean.
   */
  public boolean isSession();

  /**
   * Tests if the type of the enterprise Bean is "stateless session".
   *
   * @return True if the type of the enterprise Bean is stateless session.
   */
  public boolean isStatelessSession();
}
