/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ImageResourceCell;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import org.jboss.as.console.client.teiid.model.DataPermission;
import org.jboss.as.console.client.teiid.model.DataPolicy;
import org.jboss.as.console.client.teiid.model.ListBoxItem;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.as.console.client.teiid.widgets.TeiidIcons;
import org.jboss.ballroom.client.widgets.forms.ButtonItem;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.NumberBoxItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.jboss.ballroom.client.widgets.icons.Icons;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBDataRolesTab
extends VDBProvider {
    private VDBPresenter presenter;
    private ListDataProvider<DataPermission> dataPermissionProvider = new ListDataProvider();
    private ListDataProvider<DataPolicy> dataPolicyProvider = new ListDataProvider();
    private DefaultCellTable dataPermissionsTable;
    private Form<DataPolicy> mappedRolesForm;
    private Form<DataPermission> conditionPanel;

    public VDBDataRolesTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        Label policyLabel = new Label("Policies In VDB");
        policyLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        final DefaultCellTable policyTable = this.getPolicyTable();
        this.dataPolicyProvider.addDataDisplay((HasData)policyTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB selection) {
                List<DataPolicy> policies = null;
                if (selection != null) {
                    VDBDataRolesTab.this.setVdbName(selection.getName());
                    VDBDataRolesTab.this.setVdbVersion(selection.getVersion());
                    policies = selection.getDataPolicies();
                } else {
                    VDBDataRolesTab.this.setVdbName(null);
                    VDBDataRolesTab.this.setVdbVersion(0);
                }
                if (policies == null || policies.isEmpty()) {
                    VDBDataRolesTab.this.setPolicyName(null);
                    VDBDataRolesTab.this.dataPolicyProvider.getList().clear();
                    VDBDataRolesTab.this.dataPermissionProvider.getList().clear();
                    VDBDataRolesTab.this.mappedRolesForm.clearValues();
                } else {
                    VDBDataRolesTab.this.dataPolicyProvider.getList().clear();
                    VDBDataRolesTab.this.dataPolicyProvider.getList().addAll(policies);
                    policyTable.getSelectionModel().setSelected((Object)policies.get(0), true);
                    VDBDataRolesTab.this.setPolicyName(policies.get(0).getName());
                    List<DataPermission> permissions = policies.get(0).getPermissions();
                    VDBDataRolesTab.this.dataPermissionProvider.getList().clear();
                    if (!permissions.isEmpty()) {
                        VDBDataRolesTab.this.dataPermissionProvider.getList().addAll(permissions);
                        VDBDataRolesTab.this.conditionPanel.edit((Object)permissions.get(0));
                    }
                    VDBDataRolesTab.this.mappedRolesForm.edit((Object)policies.get(0));
                }
            }
        });
        DefaultPager policyTablePager = new DefaultPager();
        policyTablePager.setDisplay((HasRows)policyTable);
        Form form = new Form(DataPolicy.class);
        form.setNumColumns(1);
        form.setEnabled(false);
        TextItem descriptionLabel = new TextItem("description", "Description");
        form.setFields(new FormItem[]{descriptionLabel});
        form.bind((CellTable)policyTable);
        Label permissionsLabel = new Label("Permissions");
        permissionsLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        this.dataPermissionsTable = this.getPermissionsTable();
        this.dataPermissionProvider = new ListDataProvider();
        this.dataPermissionProvider.addDataDisplay((HasData)this.dataPermissionsTable);
        VDBView.onTableSectionChange(policyTable, new VDBView.TableSelectionCallback<DataPolicy>(){

            @Override
            public void onSelectionChange(DataPolicy selection) {
                if (selection != null) {
                    VDBDataRolesTab.this.setPolicyName(selection.getName());
                    VDBDataRolesTab.this.dataPermissionProvider.getList().clear();
                    VDBDataRolesTab.this.dataPermissionProvider.getList().addAll(selection.getPermissions());
                    if (!selection.getPermissions().isEmpty()) {
                        VDBDataRolesTab.this.dataPermissionsTable.getSelectionModel().setSelected((Object)selection.getPermissions().get(0), true);
                    }
                } else {
                    VDBDataRolesTab.this.setPolicyName(null);
                    VDBDataRolesTab.this.dataPermissionProvider.getList().clear();
                }
            }
        });
        DefaultPager dataPermissionsTablePager = new DefaultPager();
        dataPermissionsTablePager.setDisplay((HasRows)this.dataPermissionsTable);
        this.conditionPanel = new Form(DataPermission.class);
        this.conditionPanel.setNumColumns(2);
        this.conditionPanel.setEnabled(false);
        TextItem conditionLabel = new TextItem("condition", "Condition");
        CheckBoxItem constraintLabel = new CheckBoxItem("constraint", "Filter");
        TextItem maskLabel = new TextItem("mask", "Mask");
        NumberBoxItem maskOrderLabel = new NumberBoxItem("order", "Mask Order");
        this.conditionPanel.setFields(new FormItem[]{constraintLabel, conditionLabel, maskLabel, maskOrderLabel});
        this.conditionPanel.bind((CellTable)this.dataPermissionsTable);
        this.mappedRolesForm = new Form(DataPolicy.class);
        this.mappedRolesForm.setNumColumns(1);
        this.mappedRolesForm.setEnabled(true);
        final TextItem addInput = new TextItem("newrole", "New Role");
        addInput.setEnabled(true);
        final ListBoxItem mappedRoleNames = new ListBoxItem("mappedRoleNames", "Mapped Role Names");
        mappedRoleNames.setVisibleItemCount(4);
        mappedRoleNames.setEnabled(true);
        this.mappedRolesForm.setFields(new FormItem[]{addInput, mappedRoleNames});
        this.mappedRolesForm.bind((CellTable)policyTable);
        HorizontalPanel btnPanel = new HorizontalPanel();
        ButtonItem addBtn = new ButtonItem("add", "Add", "Add");
        ButtonItem removeBtn = new ButtonItem("remove", "Remove", "Remove");
        btnPanel.add((Widget)new Label("           "));
        btnPanel.add(addBtn.asWidget());
        btnPanel.add(removeBtn.asWidget());
        CaptionPanel captionPanel = new CaptionPanel("Manage Data Roles");
        VerticalPanel mappedRolesPanel = new VerticalPanel();
        mappedRolesPanel.add(this.mappedRolesForm.asWidget());
        mappedRolesPanel.add(btnPanel.asWidget());
        mappedRolesPanel.getElement().setAttribute("style", "margin-top:5px;margin-bottom:5px");
        captionPanel.add((Widget)mappedRolesPanel);
        captionPanel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        addBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                String roleName = addInput.getValue();
                if (VDBDataRolesTab.this.getPolicyName() != null && !roleName.isEmpty() && mappedRoleNames.addItem(roleName)) {
                    addInput.clearValue();
                    VDBDataRolesTab.this.presenter.addRoleName(VDBDataRolesTab.this.getVdbName(), VDBDataRolesTab.this.getVdbVersion(), VDBDataRolesTab.this.getPolicyName(), roleName);
                }
            }
        });
        removeBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                String removedRole = mappedRoleNames.removeSelected();
                VDBDataRolesTab.this.presenter.removeRoleName(VDBDataRolesTab.this.getVdbName(), VDBDataRolesTab.this.getVdbVersion(), VDBDataRolesTab.this.getPolicyName(), removedRole);
            }
        });
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add(policyLabel.asWidget());
        formPanel.add(policyTable.asWidget());
        formPanel.add((Widget)policyTablePager);
        formPanel.add(form.asWidget());
        formPanel.add(permissionsLabel.asWidget());
        formPanel.add(this.dataPermissionsTable.asWidget());
        formPanel.add((Widget)dataPermissionsTablePager);
        formPanel.add(this.conditionPanel.asWidget());
        formPanel.add(captionPanel.asWidget());
        return formPanel;
    }

    private DefaultCellTable getPolicyTable() {
        ProvidesKey<DataPolicy> keyProvider = new ProvidesKey<DataPolicy>(){

            public Object getKey(DataPolicy item) {
                return VDBDataRolesTab.this.getVdbName() + "." + VDBDataRolesTab.this.getVdbVersion() + "." + item.getName();
            }
        };
        DefaultCellTable table = new DefaultCellTable(8, (ProvidesKey)keyProvider);
        TextColumn<DataPolicy> nameColumn = new TextColumn<DataPolicy>(){

            public String getValue(DataPolicy record) {
                return record.getName();
            }
        };
        Column<DataPolicy, ImageResource> anyAuthenticatedColumn = new Column<DataPolicy, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPolicy record) {
                ImageResource res = null;
                res = record.isAnyAuthenticated() != false ? Icons.INSTANCE.status_good() : TeiidIcons.INSTANCE.status_not_ok();
                return res;
            }
        };
        Column<DataPolicy, ImageResource> allowCreateTempTablesColumn = new Column<DataPolicy, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPolicy record) {
                ImageResource res = null;
                res = record.isAllowCreateTemporaryTables() != false ? Icons.INSTANCE.status_good() : TeiidIcons.INSTANCE.status_not_ok();
                return res;
            }
        };
        Column<DataPolicy, ImageResource> grantAllColumn = new Column<DataPolicy, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPolicy record) {
                ImageResource res = null;
                res = record.isGrantAll() != false ? Icons.INSTANCE.status_good() : TeiidIcons.INSTANCE.status_not_ok();
                return res;
            }
        };
        table.setTitle("Data Policies");
        table.addColumn((Column)nameColumn, "Policy Name");
        table.addColumn((Column)anyAuthenticatedColumn, "Allows Any Authenticated User");
        table.addColumn((Column)allowCreateTempTablesColumn, "Allows Creation Of Temp Tables");
        table.addColumn((Column)grantAllColumn, "Grant All");
        table.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        return table;
    }

    private DefaultCellTable getPermissionsTable() {
        ProvidesKey<DataPermission> keyProvider = new ProvidesKey<DataPermission>(){

            public Object getKey(DataPermission item) {
                return VDBDataRolesTab.this.getVdbName() + "." + VDBDataRolesTab.this.getVdbVersion() + "." + VDBDataRolesTab.this.getPolicyName() + "." + item.getResourceName();
            }
        };
        DefaultCellTable table = new DefaultCellTable(8, (ProvidesKey)keyProvider);
        TextColumn<DataPermission> nameColumn = new TextColumn<DataPermission>(){

            public String getValue(DataPermission record) {
                return record.getResourceName();
            }
        };
        Column<DataPermission, ImageResource> createColumn = new Column<DataPermission, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPermission permission) {
                ImageResource res = null;
                res = permission.isAllowCreate() == null || permission.isAllowCreate() == false ? TeiidIcons.INSTANCE.status_not_ok() : Icons.INSTANCE.status_good();
                return res;
            }
        };
        Column<DataPermission, ImageResource> readColumn = new Column<DataPermission, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPermission permission) {
                ImageResource res = null;
                res = permission.isAllowRead() == null || permission.isAllowRead() == false ? TeiidIcons.INSTANCE.status_not_ok() : Icons.INSTANCE.status_good();
                return res;
            }
        };
        Column<DataPermission, ImageResource> updateColumn = new Column<DataPermission, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPermission permission) {
                ImageResource res = null;
                res = permission.isAllowUpdate() == null || permission.isAllowUpdate() == false ? TeiidIcons.INSTANCE.status_not_ok() : Icons.INSTANCE.status_good();
                return res;
            }
        };
        Column<DataPermission, ImageResource> deleteColumn = new Column<DataPermission, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPermission permission) {
                ImageResource res = null;
                res = permission.isAllowDelete() == null || permission.isAllowDelete() == false ? TeiidIcons.INSTANCE.status_not_ok() : Icons.INSTANCE.status_good();
                return res;
            }
        };
        Column<DataPermission, ImageResource> executeColumn = new Column<DataPermission, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPermission permission) {
                ImageResource res = null;
                res = permission.isAllowExecute() == null || permission.isAllowExecute() == false ? TeiidIcons.INSTANCE.status_not_ok() : Icons.INSTANCE.status_good();
                return res;
            }
        };
        Column<DataPermission, ImageResource> alterColumn = new Column<DataPermission, ImageResource>((Cell)new ImageResourceCell()){

            public ImageResource getValue(DataPermission permission) {
                ImageResource res = null;
                res = permission.isAllowAlter() == null || permission.isAllowAlter() == false ? TeiidIcons.INSTANCE.status_not_ok() : Icons.INSTANCE.status_good();
                return res;
            }
        };
        table.setTitle("Data Permissions");
        table.addColumn((Column)nameColumn, "Resource Name");
        table.addColumn((Column)createColumn, "Create");
        table.addColumn((Column)readColumn, "Read");
        table.addColumn((Column)updateColumn, "Update");
        table.addColumn((Column)deleteColumn, "Delete");
        table.addColumn((Column)executeColumn, "Execute");
        table.addColumn((Column)alterColumn, "Alter");
        table.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        return table;
    }
}

