/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.services;

import java.util.Locale;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.i18n.I18n;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.services.ServiceAdministrator;

@ThreadSafe
public abstract class AbstractServiceAdministrator
implements ServiceAdministrator {
    private volatile ServiceAdministrator.State state;
    private final I18n serviceName;

    protected AbstractServiceAdministrator(I18n serviceName, ServiceAdministrator.State initialState) {
        assert (initialState != null);
        assert (serviceName != null);
        this.state = initialState;
        this.serviceName = serviceName;
    }

    public ServiceAdministrator.State getState() {
        return this.state;
    }

    @GuardedBy(value="this")
    public synchronized ServiceAdministrator setState(ServiceAdministrator.State state) {
        switch (state) {
            case STARTED: {
                this.start();
                break;
            }
            case PAUSED: {
                this.pause();
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                this.shutdown();
            }
        }
        return this;
    }

    public ServiceAdministrator setState(String state) {
        ServiceAdministrator.State newState;
        ServiceAdministrator.State state2 = newState = state == null ? null : ServiceAdministrator.State.valueOf(state.toUpperCase());
        if (newState == null) {
            throw new IllegalArgumentException(RepositoryI18n.invalidStateString.text(new Object[]{state}));
        }
        return this.setState(newState);
    }

    public synchronized ServiceAdministrator start() {
        switch (this.state) {
            case STARTED: {
                break;
            }
            case PAUSED: {
                this.doStart(this.state);
                this.state = ServiceAdministrator.State.STARTED;
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                throw new IllegalStateException(RepositoryI18n.serviceShutdowAndMayNotBeStarted.text(new Object[]{this.getServiceName()}));
            }
        }
        return this;
    }

    @GuardedBy(value="this")
    protected void doStart(ServiceAdministrator.State fromState) {
    }

    public synchronized ServiceAdministrator pause() {
        switch (this.state) {
            case STARTED: {
                this.doPause(this.state);
                this.state = ServiceAdministrator.State.PAUSED;
                break;
            }
            case PAUSED: {
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                throw new IllegalStateException(RepositoryI18n.serviceShutdowAndMayNotBePaused.text(new Object[]{this.getServiceName()}));
            }
        }
        return this;
    }

    @GuardedBy(value="this")
    protected void doPause(ServiceAdministrator.State fromState) {
    }

    public synchronized ServiceAdministrator shutdown() {
        switch (this.state) {
            case STARTED: 
            case PAUSED: {
                this.state = ServiceAdministrator.State.SHUTDOWN;
                this.doShutdown(this.state);
                this.isTerminated();
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                this.isTerminated();
            }
        }
        return this;
    }

    @GuardedBy(value="this")
    protected void doShutdown(ServiceAdministrator.State fromState) {
    }

    public boolean isStarted() {
        return this.state == ServiceAdministrator.State.STARTED;
    }

    public boolean isPaused() {
        return this.state == ServiceAdministrator.State.PAUSED;
    }

    public boolean isShutdown() {
        return this.state == ServiceAdministrator.State.SHUTDOWN || this.state == ServiceAdministrator.State.TERMINATED;
    }

    public boolean isTerminated() {
        switch (this.state) {
            case STARTED: 
            case PAUSED: 
            case SHUTDOWN: {
                if (this.doCheckIsTerminated()) {
                    this.state = ServiceAdministrator.State.TERMINATED;
                    return true;
                }
                return false;
            }
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    protected abstract boolean doCheckIsTerminated();

    public String getServiceName() {
        return this.serviceName.text(new Object[0]);
    }

    public String getServiceName(Locale locale) {
        return this.serviceName.text(locale, new Object[0]);
    }
}

