
CREATE INDEX XIE2PBS_MAPPING ON PBS_MAPPING
(MAIN_MULTUM_DRUG_CODE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2PCS_CRITERIA ON PCS_CRITERIA
(CRITERIA_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2PCS_HIERARCHY_QUEUE_RELTN ON PCS_HIERARCHY_QUEUE_RELTN
(QUEUE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2PW_COMP_GROUP ON PW_COMP_GROUP
(PATHWAY_COMP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RAD_TECH_FLD_FMT_R ON RAD_TECH_FLD_FMT_R
(PARENT_FIELD_ID, FORMAT_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RAD_TECH_FMT_ERPRC_R ON RAD_TECH_FMT_ERPRC_R
(FORMAT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(ACTIVITY_DT_NBR, RC_D_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_CASH ON RC_F_CASH
(ACTIVITY_DT_NBR, RC_D_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_CLAIM_EVENT ON RC_F_CLAIM_EVENT
(CLAIM_EVENT_DT_NBR, RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(ACTIVITY_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(ADMISSION_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_DAILY_CENSUS_SMRY ON RC_F_DAILY_CENSUS_SMRY
(RC_D_CENSUS_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_DAILY_CLAIM_EVENT_S ON RC_F_DAILY_CLAIM_EVENT_SMRY
(ACTIVITY_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(ACTIVITY_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_DENIAL ON RC_F_DENIAL
(DENIAL_DT_NBR, RC_D_DENIAL_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(SHR_D_MONTH_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_MONTHLY_CENSUS_SMRY ON RC_F_MONTHLY_CENSUS_SMRY
(RC_D_CENSUS_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_MONTHLY_CLAIM_EVENT_S ON RC_F_MONTHLY_CLAIM_EVENT_SMRY
(RC_D_BILL_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_MONTHLY_DENIAL_SMRY ON RC_F_MONTHLY_DENIAL_SMRY
(RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(RC_D_TRANSACTION_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, RC_D_DISCHARGE_AGE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2RC_F_REVENUE ON RC_F_REVENUE
(ACTIVITY_DT_NBR, RC_D_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2REF_RANGE_FACTOR_RULE ON REF_RANGE_FACTOR_RULE
(FROM_GESTATION_DAYS, TO_GESTATION_DAYS, FROM_WEIGHT, FROM_WEIGHT_UNIT_CD, TO_WEIGHT, 
TO_WEIGHT_UNIT_CD, FROM_HEIGHT, FROM_HEIGHT_UNIT_CD, TO_HEIGHT, TO_HEIGHT_UNIT_CD, 
LOCATION_CD, ACTIVE_IND)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2REORG_CONSTRAINTS ON REORG_CONSTRAINTS
(OWNER, CONSTRAINT_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2REORG_LOG ON REORG_LOG
(ENTRY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2REQUESTER ON REQUESTER
(NAME_FIRST_KEY)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SA_REF_EXCLUDE_ACTION ON SA_REF_EXCLUDE_ACTION
(SA_REF_DOC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SA_REF_EXCLUDE_ITEM ON SA_REF_EXCLUDE_ITEM
(SA_REF_DOC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SA_REF_EXCLUDE_PARAMETER ON SA_REF_EXCLUDE_PARAMETER
(SA_REF_DOC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SA_REF_REQUIRED_ACTION ON SA_REF_REQUIRED_ACTION
(SA_REF_DOC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SA_REF_REQUIRED_CATEGORY ON SA_REF_REQUIRED_CATEGORY
(SA_REF_DOC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SCH_FREQ ON SCH_FREQ
(PARENT_TABLE, PARENT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SCH_NOMEN_LIST ON SCH_NOMEN_LIST
(END_NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SI_COMSRV_MSG_MAP_R ON SI_COMSRV_MSG_MAP_R
(MAP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SI_OEN_ENDPOINT ON SI_OEN_ENDPOINT
(ENDPOINT_TYPE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SI_OEN_SUBSCRIPTION_STEP_R ON SI_OEN_SUBSCRIPTION_STEP_R
(SI_OEN_STEP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SN_RPT_FIELD_REF ON SN_RPT_FIELD_REF
(RPT_FIELD_GRP_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2STORAGE_CONTENT ON STORAGE_CONTENT
(CONTENT_STATUS_CD, UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2STORAGE_CONTENT_EVENT ON STORAGE_CONTENT_EVENT
(STORAGE_ITEM_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SURG_PROC_DETAIL ON SURG_PROC_DETAIL
(PROC_CNT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2TEMPLATE_KEYWORD_RELTN ON TEMPLATE_KEYWORD_RELTN
(TEMPLATE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2THERAPEUTIC_CAT_ITEM ON THERAPEUTIC_CAT_ITEM
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2TRACK_ACTION_LINK ON TRACK_ACTION_LINK
(LINK_TYPE_CD, ACTIVE_IND)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2TRACK_COMP_PREFS ON TRACK_COMP_PREFS
(TRACK_PREF_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2UCMR_CASE_STEP ON UCMR_CASE_STEP
(UCMR_CASE_WORKUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2UCMR_CASE_TRIGGER ON UCMR_CASE_TRIGGER
(UCMR_CASE_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2UCMR_POSITION_MAP ON UCMR_POSITION_MAP
(LONG_TEXT_NOTES_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XIE2WORKLOAD_CODE ON WORKLOAD_CODE
(WORKLOAD_STANDARD_ID, CODE, BEG_EFFECTIVE_DT_TM, END_EFFECTIVE_DT_TM, ACTIVE_IND, 
EVENT_CD, UNITS, ITEM_FOR_COUNT_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XIE2WORKLOAD_GROUP ON WORKLOAD_GROUP
(BOOK_CD, CHAPTER_CD, SECTION_CD, WORKLOAD_CODE_ID, WORKLOAD_STANDARD_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3ADDRESS ON ADDRESS
(POSTAL_IDENTIFIER_KEY)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3BR_DATAMART_FILTER ON BR_DATAMART_FILTER
(INACTION_REASON_VALUE_SET_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3BR_DATAMART_TEXT ON BR_DATAMART_TEXT
(BR_DATAMART_FILTER_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CCL_REPORT_AUDIT ON CCL_REPORT_AUDIT
(UPDT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CLAIM_FLD_POSITION ON CLAIM_FLD_POSITION
(DEVICE_CD, PRINT_TRAY_CD, PAPER_TYPE_FLAG)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CMT_CROSS_MAP ON CMT_CROSS_MAP
(TARGET_CONCEPT_CKI)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CODE_VALUE_ALIAS ON CODE_VALUE_ALIAS
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CQM_BMDI_RESULTS_QUE ON CQM_BMDI_RESULTS_QUE
(CONTRIBUTOR_REFNUM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CR_REPORT_SECTION ON CR_REPORT_SECTION
(SECTION_NAME_KEY)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CR_REPORT_STATIC_REGION ON CR_REPORT_STATIC_REGION
(REGION_NAME_KEY)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CR_REPORT_STYLE_PROFILE ON CR_REPORT_STYLE_PROFILE
(STYLE_PROFILE_NAME_KEY)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CV_XREF ON CV_XREF
(XREF_INTERNAL_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3DCP_PL_QUERY_VALUE ON DCP_PL_QUERY_VALUE
(PARAMETER_ID, PARAMETER_SEQ, VALUE_NAME, VALUE_SEQ)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3DEVICE ON DEVICE
(LOCAL_ADDRESS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(STRT_ASSAY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3DM_CHG_LOG ON DM_CHG_LOG
(CHG_DT_TM, TABLE_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3EEM_BENEFIT ON EEM_BENEFIT
(MNEMONIC_KEY_A_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3EEM_NETWORK ON EEM_NETWORK
(MNEMONIC_KEY_A_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3HE_SESSION ON HE_SESSION
(KNOWLEDGEBASE_NAME, STATUS_FLAG, PRIORITY, RULE_VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3HE_SESSION_CONSEQUENT ON HE_SESSION_CONSEQUENT
(KNOWLEDGEBASE_NAME, UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3IO_TOTAL_DEFINITION ON IO_TOTAL_DEFINITION
(TASK_ASSAY_CD, END_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3MIC_QC_TASK_DETAIL ON MIC_QC_TASK_DETAIL
(ACTIVE_COND_SCHEDULE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3MMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(CONTACT_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3MSG_FYI_ASSIGNMENT ON MSG_FYI_ASSIGNMENT
(POSITION_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3OMF_PVI_FOLDERS ON OMF_PVI_FOLDERS
(USER_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3OMF_PV_ITEMS ON OMF_PV_ITEMS
(PRSNL_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3OPS_SCHEDULE_PARAM ON OPS_SCHEDULE_PARAM
(ACTIVE_STATUS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3OPS_SCHEDULE_TASK ON OPS_SCHEDULE_TASK
(PARENT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3ORDER_CATALOG ON ORDER_CATALOG
(CONCEPT_CKI)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(CATALOG_TYPE_CD, MNEMONIC_KEY_CAP)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3OUTCOME_CATALOG ON OUTCOME_CATALOG
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3PATHWAY_COMP ON PATHWAY_COMP
(PARENT_ENTITY_ID, PARENT_ENTITY_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3PBS_MAPPING ON PBS_MAPPING
(DRUG_SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RAD_TECH_FLD_FMT_R ON RAD_TECH_FLD_FMT_R
(FIELD_ID, PARENT_FIELD_ID, FORMAT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(ACTIVITY_DT_NBR, RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_CASH ON RC_F_CASH
(ACTIVITY_DT_NBR, RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_CLAIM_EVENT ON RC_F_CLAIM_EVENT
(CLAIM_EVENT_DT_NBR, RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(DISCHARGE_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_DAILY_CENSUS_SMRY ON RC_F_DAILY_CENSUS_SMRY
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_DAILY_CLAIM_EVENT_S ON RC_F_DAILY_CLAIM_EVENT_SMRY
(RC_D_BILL_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(RC_D_TRANSACTION_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_DENIAL ON RC_F_DENIAL
(DENIAL_DT_NBR, RC_D_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_MONTHLY_CENSUS_SMRY ON RC_F_MONTHLY_CENSUS_SMRY
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_MONTHLY_CLAIM_EVENT_S ON RC_F_MONTHLY_CLAIM_EVENT_SMRY
(RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_MONTHLY_DENIAL_SMRY ON RC_F_MONTHLY_DENIAL_SMRY
(RC_D_BILL_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, RC_D_RESP_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3RC_F_REVENUE ON RC_F_REVENUE
(ACTIVITY_DT_NBR, RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3REQUESTER ON REQUESTER
(REQUESTER_SOURCE_CD, REQUEST_REASON_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3SCH_NOMEN_LIST ON SCH_NOMEN_LIST
(BEG_IDENT, END_IDENT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3SI_COMSRV_MSG_MAP_R ON SI_COMSRV_MSG_MAP_R
(PARAM_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3SI_OEN_ENDPOINT ON SI_OEN_ENDPOINT
(CONNECTION_TYPE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3STORAGE_CONTENT_EVENT ON STORAGE_CONTENT_EVENT
(ACTION_CD, ACTION_DT_TM, STATION_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3THERAPEUTIC_CAT_ITEM ON THERAPEUTIC_CAT_ITEM
(EXTERNAL_IDENT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3UCMR_CASE_STEP ON UCMR_CASE_STEP
(CASE_STEP_CAT_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3WORKLOAD_GROUP ON WORKLOAD_GROUP
(WORKLOAD_CODE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4ADDRESS ON ADDRESS
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4CCL_REPORT_AUDIT ON CCL_REPORT_AUDIT
(OMF_OBJECT_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4CMT_CROSS_MAP ON CMT_CROSS_MAP
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4CV_XREF ON CV_XREF
(DATASET_ID, ELEMENT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4DCP_PL_QUERY_VALUE ON DCP_PL_QUERY_VALUE
(PARENT_ENTITY_NAME, PARENT_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4DEVICE ON DEVICE
(DEVICE_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(ACTIVITY_TYPE_CD, DEFAULT_RESULT_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4HE_SESSION ON HE_SESSION
(EXPIRATION_DT_TM, KNOWLEDGEBASE_NAME, STATUS_FLAG)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4IO_TOTAL_DEFINITION ON IO_TOTAL_DEFINITION
(PREV_IO_TOTAL_DEFINITION_ID, END_EFFECTIVE_DT_TM, BEG_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4MMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(CONTACT_PERSON_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4OMF_PVI_FOLDERS ON OMF_PVI_FOLDERS
(PRSNL_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4OPS_SCHEDULE_TASK ON OPS_SCHEDULE_TASK
(STATUS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4ORDER_CATALOG ON ORDER_CATALOG
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(ACTIVITY_TYPE_CD, MNEMONIC_KEY_CAP)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4OUTCOME_CATALOG ON OUTCOME_CATALOG
(EVENT_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4PBS_MAPPING ON PBS_MAPPING
(CNUM_CKI)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(RC_D_TRANSACTION_BATCH_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_CASH ON RC_F_CASH
(RC_D_TRANSACTION_BATCH_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_CLAIM_EVENT ON RC_F_CLAIM_EVENT
(CLAIM_EVENT_DT_NBR, RC_D_BILL_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(RC_D_CENSUS_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_DAILY_CENSUS_SMRY ON RC_F_DAILY_CENSUS_SMRY
(RC_D_PRI_FIN_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_DAILY_CLAIM_EVENT_S ON RC_F_DAILY_CLAIM_EVENT_SMRY
(RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_DENIAL ON RC_F_DENIAL
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_MONTHLY_CENSUS_SMRY ON RC_F_MONTHLY_CENSUS_SMRY
(RC_D_PRI_FIN_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_MONTHLY_CLAIM_EVENT_S ON RC_F_MONTHLY_CLAIM_EVENT_SMRY
(RC_D_CLAIM_EVENT_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_MONTHLY_DENIAL_SMRY ON RC_F_MONTHLY_DENIAL_SMRY
(RC_D_DENIAL_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(SHR_D_MONTH_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, RC_D_PRI_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4RC_F_REVENUE ON RC_F_REVENUE
(SERVICE_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4REQUESTER ON REQUESTER
(PARENT_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4SI_OEN_ENDPOINT ON SI_OEN_ENDPOINT
(PROTOCOL_TYPE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4STORAGE_CONTENT_EVENT ON STORAGE_CONTENT_EVENT
(DESTINATION_CD, ACTION_DT_TM, ACTION_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE50SCH_NOMEN_LIST ON SCH_NOMEN_LIST
(CANDIDATE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5CQM_FSIESO_TR_1 ON CQM_FSIESO_TR_1
(LISTENER_ID, PROCESS_STATUS_FLAG)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(EVENT_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5DM_CHG_LOG ON DM_CHG_LOG
(TARGET_ENV_ID, LOG_TYPE, DELETE_IND, CONTEXT_NAME, TABLE_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5MMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(INITIATED_BY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5NOMENCLATURE ON NOMENCLATURE
(CONCEPT_CKI)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5OPS_SCHEDULE_TASK ON OPS_SCHEDULE_TASK
(ACTIVE_STATUS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(MNEMONIC_KEY_CAP, SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5OUTCOME_CATALOG ON OUTCOME_CATALOG
(DESCRIPTION_A_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(INTERFACE_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_CASH ON RC_F_CASH
(INTERFACE_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_CLAIM_EVENT ON RC_F_CLAIM_EVENT
(CLAIM_EVENT_DT_NBR, RC_D_HEALTH_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(RC_D_MEDICAL_SERVICE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_DAILY_CENSUS_SMRY ON RC_F_DAILY_CENSUS_SMRY
(RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_DAILY_CLAIM_EVENT_S ON RC_F_DAILY_CLAIM_EVENT_SMRY
(RC_D_CLAIM_EVENT_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(RC_D_MEDICAL_SERVICE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(RC_D_MEDICAL_SERVICE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_MONTHLY_CENSUS_SMRY ON RC_F_MONTHLY_CENSUS_SMRY
(RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_MONTHLY_CLAIM_EVENT_S ON RC_F_MONTHLY_CLAIM_EVENT_SMRY
(RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(RC_D_MEDICAL_SERVICE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, RC_D_AGE_BY_BILL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, RC_D_RESP_FIN_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5RC_F_REVENUE ON RC_F_REVENUE
(GL_INTERFACE_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5REQUESTER ON REQUESTER
(NAME_LAST_KEY_A_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6CQM_FSIESO_TR_1 ON CQM_FSIESO_TR_1
(QUEUE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6DEVICE ON DEVICE
(DMS_SERVICE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(CONCEPT_CKI)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6MMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(ACTIVITY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6NOMENCLATURE ON NOMENCLATURE
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(MNEMONIC_KEY_CAP, MNEMONIC_TYPE_CD, CATALOG_TYPE_CD, ORDERABLE_TYPE_FLAG)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6OUTCOME_CATALOG ON OUTCOME_CATALOG
(EXPECTATION_A_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(POST_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_CASH ON RC_F_CASH
(POST_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_CLAIM_EVENT ON RC_F_CLAIM_EVENT
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(SHR_D_PERSON_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_DAILY_CLAIM_EVENT_S ON RC_F_DAILY_CLAIM_EVENT_SMRY
(RC_D_BILLING_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, RC_D_AGE_BY_DISCHARGE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, RC_D_DUNNING_LEVEL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6RC_F_REVENUE ON RC_F_REVENUE
(ACTIVITY_DT_NBR, RC_D_FINANCIAL_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6REQUESTER ON REQUESTER
(NAME_FIRST_KEY_A_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(HLA_LOCI_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7DM_CHG_LOG ON DM_CHG_LOG
(DM_CHG_LOG_EXCEPTION_ID, TARGET_ENV_ID, CONTEXT_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7MMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(REASON_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7NOMENCLATURE ON NOMENCLATURE
(SOURCE_STRING_KEYCAP_A_NLS, BEG_EFFECTIVE_DT_TM, END_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(MNEMONIC_KEY_CAP_NLS, MNEMONIC_TYPE_CD, CATALOG_TYPE_CD, ORDERABLE_TYPE_FLAG)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7OUTCOME_CATALOG ON OUTCOME_CATALOG
(DESCRIPTION_A_NLS, EXPECTATION_A_NLS, OUTCOME_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(BATCH_CREATED_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_CASH ON RC_F_CASH
(BATCH_CREATED_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(RC_D_TIER_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(RC_D_PRI_FIN_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(RC_D_TIER_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(RC_D_TIER_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(RC_D_TIER_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, SHR_D_PERSON_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, RC_D_BALANCE_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7RC_F_REVENUE ON RC_F_REVENUE
(ACTIVITY_DT_NBR, RC_D_GL_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(MNEMONIC_KEY_CAP)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8DM_CHG_LOG ON DM_CHG_LOG
(PTAM_MATCH_RESULT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8MMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(CASE_ST_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8NOMENCLATURE ON NOMENCLATURE
(SOURCE_STRING_KEYCAP, BEG_EFFECTIVE_DT_TM, END_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(CKI, MNEMONIC_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_CASH ON RC_F_CASH
(PAYMENT_METHOD_DT_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(RC_D_GL_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(RC_D_GL_ALIAS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, SHR_D_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(ACTIVITY_DT_NBR, RC_D_MEDICAL_SERVICE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE8RC_F_REVENUE ON RC_F_REVENUE
(SHR_D_PATIENT_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE90ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(CONCEPT_CKI)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9DISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(MNEMONIC_KEY_CAP_NLS)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9DM_CHG_LOG ON DM_CHG_LOG
(CONTEXT_NAME, SINGLE_PASS_LOG_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9NOMENCLATURE ON NOMENCLATURE
(SOURCE_IDENTIFIER_KEYCAP, BEG_EFFECTIVE_DT_TM, END_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9RC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9RC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(RC_D_ACCOMMODATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9RC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9RC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(ACTIVITY_DT_NBR, RC_D_ENCNTR_TYPE_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE9RC_F_REVENUE ON RC_F_REVENUE
(SHR_D_PERFORMING_LOCATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE_ORDER_CATALOG ON ORDER_CATALOG
(CATALOG_TYPE_CD, ACTIVITY_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF001BT_CONDITION ON BT_CONDITION
(BT_CONDITION_TREE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF001BT_CRITERIA_LIMIT ON BT_CRITERIA_LIMIT
(BT_COND_CRIT_R_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF001NOMEN_GROUP_RELTN ON NOMEN_GROUP_RELTN
(BT_COND_CRIT_R_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF001SELECTED_TASK ON SELECTED_TASK
(PFT_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF002BT_CONDITION ON BT_CONDITION
(PARENT_BT_COND_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF002NOMEN_GROUP_RELTN ON NOMEN_GROUP_RELTN
(NOMEN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF003BT_CONDITION ON BT_CONDITION
(ACTIVE_IND)
LOGGING
NOPARALLEL;


CREATE INDEX XIF004BT_CONDITION ON BT_CONDITION
(CONDITION_NAME_KEY)
LOGGING
NOPARALLEL;


CREATE INDEX XIF11DEPENDENCY ON DEPENDENCY
(QUESTION_CD, PROCESS_CD, MODULE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF12PM_RPT_HEADER ON PM_RPT_HEADER
(FIELD_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF12TL_MASTER_TAB_SET_XREF ON TL_MASTER_TAB_SET_XREF
(MASTER_TAB_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF13CONCEPT_HNAM_ADMIN ON CONCEPT_PROPERTY
(SEMANTIC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF13DEPENDENCY ON DEPENDENCY
(QUESTION_CD, RESPONSE_CD, MODULE_CD, PROCESS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF14PM_RPT_FILTER ON PM_RPT_FILTER
(FIELD_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF14REPORT_HISTORY_GROUPING_R ON REPORT_HISTORY_GROUPING_R
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF156PHASE_GROUP ON PHASE_GROUP
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF15PM_RPT_HEADER ON PM_RPT_HEADER
(REPORT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF16ORDER_TASK_XREF ON ORDER_TASK_XREF
(REFERENCE_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF1ATTRIB_FIELD_RELTN ON ATTRIB_FIELD_RELTN
(ATTRIB_CATALOG_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF1BT_COND_CRIT_RELTN ON BT_COND_CRIT_RELTN
(BT_CONDITION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF1BT_FIELD_RELTN ON BT_FIELD_RELTN
(UDV_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF1NOMENCLATURE ON NOMENCLATURE
(NOM_VER_GRP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF207CONTROL_LOT ON CONTROL_LOT
(CONTROL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF20CODE_SET_FIELD_DOMAIN ON CODE_SET_FIELD_DOMAIN
(REFERENCE)
LOGGING
NOPARALLEL;


CREATE INDEX XIF225QC_STAT_PERIOD ON QC_STAT_PERIOD
(LOT_ID, SERVICE_RESOURCE_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF242EQUATION ON EQUATION
(SERVICE_RESOURCE_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF248DEPENDENCY_DOMAIN ON DEPENDENCY_DOMAIN
(OE_FORMAT_ID, DEPENDENCY_FIELD_ID, DEPENDENCY_SEQ, OE_FIELD_ID, ACTION_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF24PM_RPT_FILTER_VALUES ON PM_RPT_FILTER_VALUES
(FILTER_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF261OE_FORMAT_FIELDS ON OE_FORMAT_FIELDS
(OE_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF27PM_RPT_DISPLAY ON PM_RPT_DISPLAY
(REPORT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF2ATTRIB_FIELD_RELTN ON ATTRIB_FIELD_RELTN
(FIELD_CATALOG_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF2BT_COND_CRIT_RELTN ON BT_COND_CRIT_RELTN
(BT_CRITERIA_CAT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF2BT_FIELD_RELTN ON BT_FIELD_RELTN
(BILL_TEMPL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF2MIC_QC_NODE ON MIC_QC_NODE
(SCHEDULE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF2NOMENCLATURE ON NOMENCLATURE
(CONCEPT_IDENTIFIER, CONCEPT_SOURCE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF30CONCEPT_CONCEPT_R ON CONCEPT_CONCEPT_R
(RELATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF31CODE_DOMAIN_FILTER_DISPLA ON CODE_DOMAIN_FILTER_DISPLAY
(DOMAIN_ID, CODE_SET)
LOGGING
NOPARALLEL;


CREATE INDEX XIF32CONCEPT_CONCEPT_R ON CONCEPT_CONCEPT_R
(INVERSE_RELATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF35CODE_DOMAIN_FILTER_DISPLA ON CODE_DOMAIN_FILTER_DISPLAY
(CODE_VALUE)
LOGGING
NOPARALLEL;


CREATE INDEX XIF3BT_FIELD_RELTN ON BT_FIELD_RELTN
(ATTRIB_FIELD_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF411ORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(ORDER_SENTENCE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF48CODE_VALUE_EXTENSION ON CODE_VALUE_EXTENSION
(FIELD_NAME, CODE_SET)
LOGGING
NOPARALLEL;


CREATE INDEX XIF48CONCEPT_PROPERTY ON CONCEPT_PROPERTY
(LONG_TEXT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF4SEMANTIC_NETWORK ON SEMANTIC_NETWORK
(SEMANTIC_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF5ANSWER ON ANSWER
(QUESTION_CD, MODULE_CD, PROCESS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF5BT_CONDITION ON BT_CONDITION
(END_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIF5SEMANTIC_NETWORK ON SEMANTIC_NETWORK
(SEMANTIC_TYPE2_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF5_NOMENCLATURE ON NOMENCLATURE
(VOCAB_AXIS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF61STRT_MFG_MODEL_R ON STRT_MFG_MODEL_R
(STRT_MFG_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF68PRODUCT_CATEGORY ON PRODUCT_CATEGORY
(PRODUCT_CLASS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF6CONCEPT_SEMTYPE_R ON CONCEPT_SEMTYPE_R
(SEMANTIC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF6PM_RPT_FILTER ON PM_RPT_FILTER
(REPORT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKACCESSION_ASSIGNMENT ON ACCESSION_ASSIGNMENT
(ACC_ASSIGN_POOL_ID, ACC_ASSIGN_DATE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKACCESSION_EXTERNAL_SMRY ON ACCESSION_EXTERNAL_SMRY
(ACCESSION_EXTERNAL_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKADDRESS ON ADDRESS
(ADDRESS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKALIQUOTTED_PRIMER_KIT ON ALIQUOTTED_PRIMER_KIT
(LOT_NUMBER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKANSWER ON ANSWER
(QUESTION_CD, ANSWER_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAPP_TRANSLATION ON APP_TRANSLATION
(TRANSLATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_ACCN_TEMPLATE_DETAIL ON AP_ACCN_TEMPLATE_DETAIL
(TEMPLATE_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_DIAG_QUERY_PARAM ON AP_DIAG_QUERY_PARAM
(QUERY_PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_PROMPT ON AP_PROMPT
(AP_PROMPT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_PROMPT_FIELD ON AP_PROMPT_FIELD
(AP_PROMPT_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_TAG ON AP_TAG
(TAG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKATTRIB_FIELD_RELTN ON ATTRIB_FIELD_RELTN
(ATTRIB_FIELD_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_APPLICATION ON AT_APPLICATION
(AP_APPLICATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_BATCH ON AT_BATCH
(BA_BATCH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_BATCHOBJECTIVE ON AT_BATCHOBJECTIVE
(BO_OBJECTIVE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_BUCKET ON AT_BUCKET
(BK_BUCKET_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_DEVICEPRODUCT ON AT_DEVICEPRODUCT
(DP_DEVICE_ID, DP_PRODUCT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_KEYWORD ON AT_KEYWORD
(KY_KEYWORD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_LIBRARY ON AT_LIBRARY
(LB_LIBRARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_LOCK ON AT_LOCK
(LK_TYPE_ID, LK_ENTITY)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_MNEMONICTYPE ON AT_MNEMONICTYPE
(MN_MNEM_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_PARAMETER ON AT_PARAMETER
(PM_PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_PASSWORD ON AT_PASSWORD
(PW_DOMAIN_ID, PW_USERNAME)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_PLAN ON AT_PLAN
(PL_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_POPUPCOMPONENT ON AT_POPUPCOMPONENT
(PC_COMPONENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_QUERY ON AT_QUERY
(QY_QUERY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_RUN ON AT_RUN
(RN_RUN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_RUNOBJECTIVE ON AT_RUNOBJECTIVE
(RO_OBJECTIVE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_SCREENSHOT ON AT_SCREENSHOT
(SC_SCREEN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAUDIT_EVENT ON AUDIT_EVENT
(AUDIT_EVENT_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAUDIT_REQUEST ON AUDIT_REQUEST
(AUDIT_REQUEST_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBBHIST_SPECIAL_TESTING ON BBHIST_SPECIAL_TESTING
(BBHIST_SPECIAL_TESTING_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_ISBT_ADD_INFO ON BB_ISBT_ADD_INFO
(BB_ISBT_ADD_INFO_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_MOD_DEVICE ON BB_MOD_DEVICE
(OPTION_ID, DEVICE_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_QC_TROUBLESHOOTING ON BB_QC_TROUBLESHOOTING
(TROUBLESHOOTING_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBLOB_SUMMARY_REF ON BLOB_SUMMARY_REF
(BLOB_REF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBLOT_BATCH ON BLOT_BATCH
(BLOT_BATCH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBLOT_SPECIFICITY ON BLOT_SPECIFICITY
(LOT_NUMBER_ID, ALLELE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBLOT_STRIP ON BLOT_STRIP
(LOT_NUMBER_ID, STRIP_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_ADO_PROPOSED_DETAIL ON BR_ADO_PROPOSED_DETAIL
(BR_ADO_PROPOSED_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_ADO_PROPOSED_OPTION ON BR_ADO_PROPOSED_OPTION
(BR_ADO_PROPOSED_OPTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_ADO_PROPOSED_ORD_LIST ON BR_ADO_PROPOSED_ORD_LIST
(BR_ADO_PROPOSED_ORD_LIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_BP_ACTIVITY ON BR_BP_ACTIVITY
(BR_BP_ACTIVITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_BP_ACT_GROUP ON BR_BP_ACT_GROUP
(BR_BP_ACT_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_BP_ACT_GROUP_R ON BR_BP_ACT_GROUP_R
(BR_BP_ACT_GROUP_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_BP_ACT_LONG_DESC ON BR_BP_ACT_LONG_DESC
(BR_BP_ACT_LONG_DESC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_CKI_CLIENT_DATA ON BR_CKI_CLIENT_DATA
(BR_CKI_CLIENT_DATA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_CKI_CLIENT_DATA_FIELD ON BR_CKI_CLIENT_DATA_FIELD
(BR_CKI_CLIENT_DATA_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_FILTER ON BR_DATAMART_FILTER
(BR_DATAMART_FILTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_FILTER_DETAIL ON BR_DATAMART_FILTER_DETAIL
(BR_DATAMART_FILTER_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_REPORT_FILTER_R ON BR_DATAMART_REPORT_FILTER_R
(BR_DATAMART_REPORT_FILTER_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_TEXT ON BR_DATAMART_TEXT
(BR_DATAMART_TEXT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_VALUE ON BR_DATAMART_VALUE
(BR_DATAMART_VALUE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBT_CONDITION ON BT_CONDITION
(BT_CONDITION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBT_COND_CRIT_RELTN ON BT_COND_CRIT_RELTN
(BT_COND_CRIT_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBT_CRITERIA_LIMIT ON BT_CRITERIA_LIMIT
(BT_CRITERIA_LIMIT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBT_FIELD_RELTN ON BT_FIELD_RELTN
(BT_FIELD_RELTN_ID, BT_FIELD_VRSN_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCASE_SPECIMEN_TYPE_R ON CASE_SPECIMEN_TYPE_R
(CASE_TYPE_CD, SPECIMEN_MEANING)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCL_FIELD_MAP ON CCL_FIELD_MAP
(FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCL_FORMAT_DETAIL ON CCL_FORMAT_DETAIL
(OBJECT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCL_LAYOUT_SECTION ON CCL_LAYOUT_SECTION
(SECTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCL_REPORT_OBJECT_R ON CCL_REPORT_OBJECT_R
(REP_OBJ_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCR_CONTENT ON CCR_CONTENT
(CONTENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCR_CONTENT_SECTION_RELTN ON CCR_CONTENT_SECTION_RELTN
(CONTENT_SECTION_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCR_CONTENT_VIEW_FILTER ON CCR_CONTENT_VIEW_FILTER
(CONTENT_VIEW_FILTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCCR_FILTER_VALUE ON CCR_FILTER_VALUE
(FILTER_VALUE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_FORMAT ON CHART_FORMAT
(CHART_FORMAT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_FORM_MM_FLDS ON CHART_FORM_MM_FLDS
(CHART_FORMAT_ID, FIELD_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_FORM_SECTS ON CHART_FORM_SECTS
(CHART_FORMAT_ID, CHART_SECTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_GROUP ON CHART_GROUP
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_HLA_FORMAT ON CHART_HLA_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_HORZ_FORMAT ON CHART_HORZ_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_IMAGE_MM_FLDS ON CHART_IMAGE_MM_FLDS
(CHART_FORMAT_ID, FIELD_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_IMMUNIZ_FORMAT ON CHART_IMMUNIZ_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_LISTVIEW_FORMAT ON CHART_LISTVIEW_FORMAT
(CHART_LISTVIEW_FORMAT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_MAR_FORMAT ON CHART_MAR_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_MICRO_FORMAT ON CHART_MICRO_FORMAT
(CHART_GROUP_ID, OPTION_FLAG)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_NAME_HIST_FORMAT ON CHART_NAME_HIST_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_ORDERS_FORMAT ON CHART_ORDERS_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_ORD_SUM_FILTER ON CHART_ORD_SUM_FILTER
(CHART_GROUP_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_PROBLEM_FORMAT ON CHART_PROBLEM_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_PROCHIST_FORMAT ON CHART_PROCHIST_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_RAD_FORMAT ON CHART_RAD_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_REQUEST_ARCHIVE ON CHART_REQUEST_ARCHIVE
(CHART_REQUEST_ARCHIVE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_SERVER_PRINTER ON CHART_SERVER_PRINTER
(CHART_SERVER_PRINTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_VERT_FORMAT ON CHART_VERT_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_XENCNTR_FORMAT ON CHART_XENCNTR_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_ZONAL_FORMAT ON CHART_ZONAL_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCLAIM_FLD_POSITION ON CLAIM_FLD_POSITION
(CLAIM_FLD_POSITION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCLINICAL_NOTE_TEMPLATE ON CLINICAL_NOTE_TEMPLATE
(TEMPLATE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCMT_CODE_VALUE_LOAD ON CMT_CODE_VALUE_LOAD
(CODE_VALUE_UUID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCMT_IMPORT_LOG ON CMT_IMPORT_LOG
(CMT_IMPORT_LOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCMT_IMPORT_LOG_MSG ON CMT_IMPORT_LOG_MSG
(CMT_IMPORT_LOG_MSG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_ALPHA_RESPONSE ON CNT_ALPHA_RESPONSE
(CNT_ALPHA_RESPONSE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_DATA_MAP ON CNT_DATA_MAP
(CNT_DATA_MAP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_DCP_INTERP ON CNT_DCP_INTERP
(CNT_DCP_INTERP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_DCP_INTERP_COMPONENT ON CNT_DCP_INTERP_COMPONENT
(CNT_DCP_INTERP_COMPONENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_DTA ON CNT_DTA
(CNT_DTA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_INPUT_KEY ON CNT_INPUT_KEY
(CNT_INPUT_KEY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_PF_SECTION_R ON CNT_PF_SECTION_R
(CNT_PF_SECTION_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_RRF ON CNT_RRF
(CNT_RRF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_RRF_AR_R ON CNT_RRF_AR_R
(CNT_RRF_AR_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_SECTION ON CNT_SECTION
(CNT_SECTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_SECTION_DTA_R ON CNT_SECTION_DTA_R
(CNT_SECTION_DTA_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_CDF_EXT ON CODE_CDF_EXT
(CODE_SET, CDF_MEANING, FIELD_NAME)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_DOMAIN_FILTER ON CODE_DOMAIN_FILTER
(CODE_SET, DOMAIN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_DOMAIN_FILTER_DISPLAY ON CODE_DOMAIN_FILTER_DISPLAY
(CODE_SET, DOMAIN_ID, CODE_VALUE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_SET_EXTENSION ON CODE_SET_EXTENSION
(CODE_SET, FIELD_NAME)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_SET_FIELD_DOMAIN ON CODE_SET_FIELD_DOMAIN
(CODE_SET, REFERENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_VALUE_CHANGES ON CODE_VALUE_CHANGES
(CODE_VALUE_CHANGES_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_VALUE_EXTENSION ON CODE_VALUE_EXTENSION
(CODE_VALUE, FIELD_NAME, CODE_SET)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_VAL_GRP_RELTN ON CODE_VAL_GRP_RELTN
(CODE_VAL_GRP_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCONCEPT_CONCEPT_R ON CONCEPT_CONCEPT_R
(CONCEPT_CONCEPT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCONCEPT_PROPERTY ON CONCEPT_PROPERTY
(CONCEPT_PROPERTY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCONCEPT_SEMTYPE_R ON CONCEPT_SEMTYPE_R
(CONCEPT_SEMTYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCONDITIONAL_BEHAVIOR ON CONDITIONAL_BEHAVIOR
(CONDITION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCOND_REQUIRED_PROPS ON COND_REQUIRED_PROPS
(VALUE_IND, PROPERTY_ID, COND_PROPERTY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCONTROL_LOT ON CONTROL_LOT
(LOT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCOST_ADJ_FLEX ON COST_ADJ_FLEX
(COST_ADJ_FLEX_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCQM_BMDI_RESULTS_QUE ON CQM_BMDI_RESULTS_QUE
(QUEUE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCQM_FSIESO_TR_1 ON CQM_FSIESO_TR_1
(TRIGGER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCQM_MDRESULTS_LOG ON CQM_MDRESULTS_LOG
(LOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCQM_MDRESULTS_PAR ON CQM_MDRESULTS_PAR
(PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCQM_MICRESULTS_LOG ON CQM_MICRESULTS_LOG
(LOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCQM_MICRESULTS_PAR ON CQM_MICRESULTS_PAR
(PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCR_REPORT_SECTION ON CR_REPORT_SECTION
(REPORT_SECTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCR_REPORT_STATIC_REGION ON CR_REPORT_STATIC_REGION
(REPORT_STATIC_REGION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCR_REPORT_STYLE_PROFILE ON CR_REPORT_STYLE_PROFILE
(REPORT_STYLE_PROFILE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCR_REPORT_WATERMARK ON CR_REPORT_WATERMARK
(REPORT_WATERMARK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCS_CPP_RULE ON CS_CPP_RULE
(CS_CPP_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_COMPONENT ON CV_COMPONENT
(COMPONENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_OPERATOR ON CV_OPERATOR
(OPERATOR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_XREF ON CV_XREF
(XREF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_BUS_VIEW ON DA_BUS_VIEW
(DA_BUS_VIEW_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_DOMAIN ON DA_DOMAIN
(DA_DOMAIN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_DOMAIN_BV_RELTN ON DA_DOMAIN_BV_RELTN
(DA_DOMAIN_BV_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_ELEMENT ON DA_ELEMENT
(DA_ELEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_GROUP_SECURITY ON DA_GROUP_SECURITY
(DA_GROUP_SECURITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_LV_TABLE_ELEM_RELTN ON DA_LV_TABLE_ELEM_RELTN
(DA_LV_TABLE_ELEM_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_TABLE_RELTN ON DA_TABLE_RELTN
(DA_TABLE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDCP_CF_TRANS_CAT_RELTN ON DCP_CF_TRANS_CAT_RELTN
(DCP_CF_TRANS_CAT_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDCP_PL_QUERY_LIST ON DCP_PL_QUERY_LIST
(PATIENT_LIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDCP_PL_QUERY_VALUE ON DCP_PL_QUERY_VALUE
(QUERY_VALUE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDD_REF_FILTER ON DD_REF_FILTER
(DD_REF_FILTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDD_REF_FORMAT ON DD_REF_FORMAT
(DD_REF_FORMAT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDEPENDENCY ON DEPENDENCY
(QUESTION_CD, RESPONSE_CD, DEPEND_QUEST_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDEPENDENCY_DOMAIN ON DEPENDENCY_DOMAIN
(OE_FORMAT_ID, ACTION_TYPE_CD, OE_FIELD_ID, DEPENDENCY_FIELD_ID, DEPENDENCY_SEQ, 
DEP_DOMAIN_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDEVICE ON DEVICE
(DEVICE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDISCRETE_TASK_ASSAY ON DISCRETE_TASK_ASSAY
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDMS_ASSOCIATION ON DMS_ASSOCIATION
(DMS_ASSOCIATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDMS_CONTENT_TYPE ON DMS_CONTENT_TYPE
(DMS_CONTENT_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDMS_EVENT_REASON_R ON DMS_EVENT_REASON_R
(DMS_EVENT_REASON_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDMS_MEDIA_METADATA_REF ON DMS_MEDIA_METADATA_REF
(DMS_MEDIA_METADATA_REF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_ADS_CONFIG_DRIVER ON DM_ADS_CONFIG_DRIVER
(DM_ADS_CONFIG_DRIVER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_ADS_CONFIG_EXTRACT ON DM_ADS_CONFIG_EXTRACT
(DM_ADS_CONFIG_EXTRACT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_CB_ANSWERS ON DM_CB_ANSWERS
(ANSWER_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_CB_HISTORY ON DM_CB_HISTORY
(HISTORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_CB_OBJECTS ON DM_CB_OBJECTS
(OBJECT_NAME, OBJECT_TYPE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_CHG_LOG ON DM_CHG_LOG
(LOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_DS_SERVER_RELTN ON DM_DS_SERVER_RELTN
(DM_DS_SERVER_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_PURGE_HISTORY ON DM_PURGE_HISTORY
(DM_PURGE_HISTORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDM_VDATA_EXCLUDE_DTL ON DM_VDATA_EXCLUDE_DTL
(DM_VDATA_EXCLUDE_DTL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDOC_SET_ELEMENT_REF ON DOC_SET_ELEMENT_REF
(DOC_SET_ELEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDRC_DOSE_RANGE_CHECK ON DRC_DOSE_RANGE
(DRC_DOSE_RANGE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDRC_DOSE_RANGE_CHECK_VER ON DRC_DOSE_RANGE_VER
(DRC_DOSE_RANGE_ID, VER_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDRUG_CLASS_INT_CUSTOM ON DRUG_CLASS_INT_CUSTOM
(DRUG_CLASS_INT_CUSTOM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDTA_OFFSET_MIN ON DTA_OFFSET_MIN
(DTA_OFFSET_MIN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDTA_VERSION ON DTA_VERSION
(DTA_VERSION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEA_PASSWORD_HISTORY ON EA_PASSWORD_HISTORY
(EA_PASSWORD_HISTORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEA_TRANSACTION_HIST ON EA_TRANSACTION_HIST
(EA_TRANSACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEA_TRANSACTION_MAIN ON EA_TRANSACTION_MAIN
(EA_TRANSACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_BENEFIT ON EEM_BENEFIT
(EEM_BENEFIT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_BENEFIT_PLAN ON EEM_BENEFIT_PLAN
(BENEFIT_PLAN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_BENEFIT_RELTN ON EEM_BENEFIT_RELTN
(EEM_BENEFIT_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_COMMENT ON EEM_COMMENT
(EEM_COMMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_FILE ON EEM_FILE
(EEM_FILE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_FILE_CHECK ON EEM_FILE_CHECK
(EEM_FILE_ID, BEG_DT_TM)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_FILE_RELTN ON EEM_FILE_RELTN
(FILE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_NETWORK ON EEM_NETWORK
(NETWORK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_PROV_TAX_RELTN ON EEM_PROV_TAX_RELTN
(EEM_PROV_TAX_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_SERVICE_TYPE ON EEM_SERVICE_TYPE
(SERVICE_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKELIG_QUEST_LIBRARY ON ELIG_QUEST_LIBRARY
(ELIG_QUEST_LIBRARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKENCNTR_CLIN_REVIEW_ADDNDM ON ENCNTR_CLIN_REVIEW_ADDNDM
(ENCNTR_CLIN_REVIEW_ADDNDM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEQUATION ON EQUATION
(EQUATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEQUATION_COMPONENT ON EQUATION_COMPONENT
(EQUATION_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEQUIPMENT_MASTER ON EQUIPMENT_MASTER
(ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKESO_FIELD_FILTER_RELTN ON ESO_FIELD_FILTER_RELTN
(FIELD_FILTER_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKESO_FILTER_COND_RELTN ON ESO_FILTER_COND_RELTN
(FILTER_COND_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKETR_LOCATION_CHANGE_LOG ON ETR_LOCATION_CHANGE_LOG
(ETR_LOCATION_CHANGE_LOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKE_CCL_REPORT_AUDIT ON CCL_REPORT_AUDIT
(REPORT_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_AGE_LIMIT_DETAIL ON FB_AGE_LIMIT_DETAIL
(FB_AGE_LIMIT_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_ALT_DETAIL ON FB_ALT_DETAIL
(FB_ALT_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_ALT_DETAIL_ITEM ON FB_ALT_DETAIL_ITEM
(FB_ALT_DETAIL_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_COPAY_DRUG_DETAIL ON FB_COPAY_DRUG_DETAIL
(FB_COPAY_DRUG_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_COPAY_SMRY_CLASS ON FB_COPAY_SMRY_CLASS
(FB_COPAY_SMRY_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_GENDER_LIMIT_DETAIL ON FB_GENDER_LIMIT_DETAIL
(FB_GENDER_LIMIT_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_MED_NECESSITY_DETAIL ON FB_MED_NECESSITY_DETAIL
(FB_MED_NECESSITY_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_PRIOR_AUTH_CLASS ON FB_PRIOR_AUTH_CLASS
(FB_PRIOR_AUTH_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_PRIOR_AUTH_DETAIL ON FB_PRIOR_AUTH_DETAIL
(FB_PRIOR_AUTH_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_PROD_EXC_DETAIL ON FB_PROD_EXC_DETAIL
(FB_PROD_EXC_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_QTY_LIMIT_DETAIL ON FB_QTY_LIMIT_DETAIL
(FB_QTY_LIMIT_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_RSRC_DRUG_DETAIL ON FB_RSRC_DRUG_DETAIL
(FB_RSRC_DRUG_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_RSRC_SMRY_LINK ON FB_RSRC_SMRY_LINK
(FB_RSRC_SMRY_LINK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_STATUS_CLASS ON FB_STATUS_CLASS
(FB_STATUS_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_STATUS_DETAIL ON FB_STATUS_DETAIL
(FB_STATUS_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_STEP_MEDS_DETAIL ON FB_STEP_MEDS_DETAIL
(FB_STEP_MEDS_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_STEP_MEDS_DETAIL_ITEM ON FB_STEP_MEDS_DETAIL_ITEM
(FB_STEP_MEDS_DETAIL_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_STEP_THERAPY_DETAIL ON FB_STEP_THERAPY_DETAIL
(FB_STEP_THERAPY_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_TEXT_MSG_CLASS ON FB_TXT_MSG_CLASS
(FB_TXT_MSG_CLASS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFB_TEXT_MSG_DETAIL ON FB_TXT_MSG_DETAIL
(FB_TXT_MSG_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHANDHELD_CONTAINER ON HANDHELD_CONTAINER
(COLLECTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHE_KNOWLEDGEBASE ON HE_KNOWLEDGEBASE
(KNOWLEDGEBASE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHE_RULE_GROUP ON HE_RULE_GROUP
(RULE_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHE_SESSION ON HE_SESSION
(SESSION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHE_SESSION_CONSEQUENT ON HE_SESSION_CONSEQUENT
(SESSION_CONSEQUENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_AB_SCREEN_BATCH ON HLA_AB_SCREEN_BATCH
(BATCH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_AB_SCREEN_TRAY_MAP ON HLA_AB_SCREEN_TRAY_MAP
(LOT_NUMBER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_AB_SCRN_WELL ON HLA_AB_SCRN_WELL
(LOT_NUMBER_ID, TRAY_NUMBER, X_POS, Y_POS)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_DISPLAY_PRECEDENCE ON HLA_DISPLAY_PRECEDENCE
(HLA_DISPLAY_PRECEDENCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_DTA_EVENT_MAPPING ON HLA_DTA_EVENT_MAPPING
(DTA_CD, EVENT_MNEMONIC)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_SERA_QUERY_QUERIES ON HLA_SERA_QUERY_QUERIES
(SERA_QUERY_QUERIES_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_TYP_TRAY_MAP ON HLA_TYP_TRAY_MAP
(LOT_NUMBER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_TYP_TRAY_WELL ON HLA_TYP_TRAY_WELL
(LOT_NUMBER_ID, X_POS, Y_POS)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_XM_TRAY_MAP ON HLA_XM_TRAY_MAP
(LOT_NUMBER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHM_EXPECT ON HM_EXPECT
(EXPECT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHM_EXPECT_STEP ON HM_EXPECT_STEP
(EXPECT_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKIM_IMAGE ON IM_IMAGE
(IM_IMAGE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKINFOSCAN_PRODUCT ON INFOSCAN_PRODUCT
(FORMULARY_IDENTIFIER, MULTUM_IDENTIFIER, MULTUM_NAME_CODE, THERAP_CLASS_IDENTIFIER, THERAP_SUB_CLASS_IDENTIFIER, 
NOTE_IDENTIFIER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKINPUT_FORM_BEHAVIOR ON INPUT_FORM_BEHAVIOR
(BEHAVIOR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKIO_DEF_ELEMENT_RELTN ON IO_DEF_ELEMENT_RELTN
(IO_DEF_ELEMENT_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKIO_TOTAL_DEFINITION ON IO_TOTAL_DEFINITION
(IO_TOTAL_DEFINITION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_ABS_ANSWER ON LH_ABS_ANSWER
(LH_ABS_ANSWER_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_ABS_LAYOUT ON LH_ABS_LAYOUT
(LH_ABS_LAYOUT_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_CNT_IC_ANTIBGRM_ORG_DSC ON LH_CNT_IC_ANTIBGRM_ORG_DSC
(LH_CNT_IC_ANTIBGRM_ORG_DSC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_D_BUILDING ON LH_D_BUILDING
(D_BUILDING_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_D_NURSE_UNIT ON LH_D_NURSE_UNIT
(D_NURSE_UNIT_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_F_ED_METRICS ON LH_F_ED_METRICS
(F_ED_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_F_FALLS_METRICS ON LH_F_FALLS_METRICS
(F_FALLS_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_F_HAPU_METRICS ON LH_F_HAPU_METRICS
(F_HAPU_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_F_NHIQM_VTE_METRICS ON LH_F_NHIQM_VTE_METRICS
(F_NHIQM_VTE_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_F_STROKE_METRICS ON LH_F_STROKE_METRICS
(F_STROKE_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_MU_FX_METRICS ON LH_MU_FX_METRICS
(LH_MU_FX_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMAMMO_LETTER ON MAMMO_LETTER
(LETTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMESSAGE_TYPE_TEMPLATE_RELTN ON MESSAGE_TYPE_TEMPLATE_RELTN
(MESSAGE_TYPE_TEMPLATE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMFA_IDENTITY_TYPE ON MFA_IDENTITY_TYPE
(MFA_IDENTITY_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMFA_METHOD_CHAIN ON MFA_METHOD_CHAIN
(MFA_METHOD_CHAIN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_BIO_BLOCK_PROFILE ON MIC_BIO_BLOCK_PROFILE
(GROUP_BIOCHEMICAL_CD, DETAIL_BIOCHEMICAL_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_BPA_INTERP_PLATE_RESULT ON MIC_BPA_INTERP_PLATE_RESULT
(INTERP_ID, SEQUENCE, ANTIBIOTIC_PLATE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_INTERP ON MIC_INTERP
(INTERP_RANGE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_INTERP_DATA ON MIC_INTERP_DATA
(INTERP_RANGE_ID, SUS_RESULT_CD, LOW_VALUE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_BIO_TEST_RESULT ON MIC_QC_BIO_TEST_RESULT
(QC_ORGANISM_ID, GROUP_BIOCHEMICAL_CD, DETAIL_BIOCHEMICAL_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_ITEM ON MIC_QC_ITEM
(QC_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_NODE ON MIC_QC_NODE
(NODE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_NODE_RULE_RELTN ON MIC_QC_NODE_RULE_RELTN
(NODE_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_TASK ON MIC_QC_TASK
(TASK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_TASK_DETAIL ON MIC_QC_TASK_DETAIL
(TASK_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_TASK_RESULT ON MIC_QC_TASK_RESULT
(TASK_RESULT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_SEQ_PRINTER ON MIC_SEQ_PRINTER
(SEQUENCE_ID, OUTPUT_DEST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_STAT_SUS_CROSS_REF ON MIC_STAT_SUS_CROSS_REF
(SUS_DC_PARAM_ID, SUS_DETAIL1_CD, SUS_DETAIL2_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_STAT_SUS_DC_AB ON MIC_STAT_SUS_DC_AB
(SUS_DC_VALUE_ID, ANTIBIOTIC_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_STAT_SUS_DC_NUMERIC ON MIC_STAT_SUS_DC_NUMERIC
(SUS_DC_VALUE_ID, ANTIBIOTIC_CD, BEGIN_RANGE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_STAT_SUS_DC_RESULT ON MIC_STAT_SUS_DC_RESULT
(SUS_DC_VALUE_ID, ANTIBIOTIC_CD, RESULT_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_SUS_DELTA_NUMERIC_RESUL ON MIC_SUS_DELTA_NUMERIC_RESULT
(SUS_DELTA_VALUE_ID, ANTIBIOTIC_CD, BEGIN_RANGE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_SUS_DELTA_PARAMETER ON MIC_SUS_DELTA_PARAMETER
(SUS_DELTA_PARAM_ID, ANTIBIOTIC_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_SUS_DELTA_PARAM_XREF ON MIC_SUS_DELTA_XREF
(SUS_DELTA_PARAM_ID, ANTIBIOTIC_CD, SUS_DETAIL1_CD, SUS_DETAIL2_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_SUS_DELTA_RESULT ON MIC_SUS_DELTA_RESULT
(SUS_DELTA_VALUE_ID, ANTIBIOTIC_CD, RESULT_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLLD_BCB_DRC_UNITS ON MLLD_BCB_DRC_UNITS
(GLOBAL_TXT, GLOBAL_TYPE_ID, UNIT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLLD_DMD_NAME_MAP ON MLLD_DMD_NAME_MAP
(DRUG_SYNONYM_ID, FUNCTION_ID, APID, APPID, VPID, 
VPPID, VTMID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLLD_DRUG_NAME_GLOBAL_TYPE ON MLLD_DRUG_NAME_GLOBAL_TYPE
(DRUG_SYNONYM_ID, GLOBAL_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLLD_RXB_DISP_RULE_ORDMAP ON MLLD_RXB_CALC_DISP_RULE_ORDMAP
(DRUG_IDENTIFIER, ORDER_ID, DOSE_DISPENSE_RULE_ID, FREQUENCY_DURATION_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLLD_RXB_DUR_RULE_ORD_MAP ON MLLD_RXB_CALC_DUR_RULE_ORD_MAP
(DRUG_IDENTIFIER, ORDER_ID, DOSE_DISPENSE_RULE_ID, FREQUENCY_DURATION_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_ALR_CATEGORY_CLASS_MAP ON MLTM_ALR_CATEGORY_CLASS_MAP
(CLASS_ID, ALR_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_ALT_DRUG_CAT_NAME ON MLTM_ALT_DRUG_CAT_NAME
(ALTERNATE_DRUG_CAT_NAME_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_BCB_DRC_UNITS ON MLTM_BCB_DRC_UNITS
(GLOBAL_TXT, GLOBAL_TYPE_ID, UNIT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_CATEGORY_SUB_XREF ON MLTM_CATEGORY_SUB_XREF
(MULTUM_CATEGORY_ID, SUB_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DDI_COND_CATEGORY ON MLTM_DDI_COND_CATEGORY
(CHILD_COND_DDI_ID, PARENT_COND_DDI_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DMD_NAME_MAP ON MLTM_DMD_NAME_MAP
(DRUG_SYNONYM_ID, FUNCTION_ID, APID, APPID, VPID, 
VPPID, VTMID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DRUG_ID ON MLTM_DRUG_ID
(DRUG_IDENTIFIER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DRUG_MODIFIER_MAP ON MLTM_DRUG_MODIFIER_MAP
(DRUG_IDENTIFIER, MODIFIER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DRUG_NAME_GLOBAL_TYPE ON MLTM_DRUG_NAME_GLOBAL_TYPE
(DRUG_SYNONYM_ID, GLOBAL_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DUPLICATION_DRUG_XREF ON MLTM_DUPLICATION_DRUG_XREF
(MULTUM_CATEGORY_ID, DRUG_IDENTIFIER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_FTD_TEXT ON MLTM_FTD_TEXT
(DRUG_IDENTIFIER, HEADING_ID, SEQUENCE_NUMBER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_FTD_TEXT_CONDITION ON MLTM_FTD_TEXT_CONDITION
(DRUG_IDENTIFIER, HEADING_ID, SEQUENCE_NUMBER, CONDITION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_INT_DRUG_INTERACTIONS ON MLTM_INT_DRUG_INTERACTIONS
(DRUG_IDENTIFIER_1, DRUG_IDENTIFIER_2)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_INT_HEADER_SEV_MAP ON MLTM_INT_HEADER_SEVERITY_MAP
(HEADER_ID, SEVERITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_INT_INTERACT_SEV_MAP ON MLTM_INT_INTERACT_SEVERITY_MAP
(INT_ID, HEADER_ID, SEVERITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_NDC_IMAGE ON MLTM_NDC_IMAGE
(NDC_LEFT_9)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_NDC_MAIN_DRUG_CODE ON MLTM_NDC_MAIN_DRUG_CODE
(MAIN_MULTUM_DRUG_CODE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_DISP_RULE_ORDMAP ON MLTM_RXB_CALC_DISP_RULE_ORDMAP
(DRUG_IDENTIFIER, ORDER_ID, DOSE_DISPENSE_RULE_ID, FREQUENCY_DURATION_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_DUR_RULE_ORD_MAP ON MLTM_RXB_CALC_DUR_RULE_ORD_MAP
(DRUG_IDENTIFIER, ORDER_ID, DOSE_DISPENSE_RULE_ID, FREQUENCY_DURATION_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER ON MLTM_RXB_ORDER
(DRUG_IDENTIFIER, ORDER_ID_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER_DISPENSE_MAP ON MLTM_RXB_ORDER_DISPENSE_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, DISPENSE_AMOUNT, DISPENSE_DICTIONARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER_DURATION_MAP ON MLTM_RXB_ORDER_DURATION_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, DURATION_AMOUNT, DURATION_DICTIONARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER_FREQ_MAP ON MLTM_RXB_ORDER_FREQUENCY_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, FREQUENCY_DICTIONARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER_INST_MAP ON MLTM_RXB_ORDER_INSTRUCTION_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, INSTRUCTION_DICTIONARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER_PRN_MAP ON MLTM_RXB_ORDER_PRN_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, PRN_DICTIONARY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORDER_REFILL_MAP ON MLTM_RXB_ORDER_REFILL_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, REFILL_AMOUNT)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORD_CLIN_RTE_MAP ON MLTM_RXB_ORD_CLINICAL_RTE_MAP
(DRUG_IDENTIFIER, ORDER_ID_NBR, CLINICAL_ROUTE_DICTIONARY_ID, MOST_COMMON_IND)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORD_DOSE_AMOUNT2 ON MLTM_RXB_ORD_DOSE_AMOUNT
(DRUG_IDENTIFIER, ORDER_ID_NBR, DOSE_AMOUNT, DOSE_UNIT_DICTIONARY_ID, DOSE_QTY_AMOUNT)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_RXB_ORD_DOSE_RATE ON MLTM_RXB_ORD_DOSE_RATE
(DRUG_IDENTIFIER, ORDER_ID_NBR, RATE_AMOUNT)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_XP_CLIN_TEXT_XREF ON MLTM_XP_CLIN_TEXT_XREF
(DRUG_IDENTIFIER, FUNCTION_ID, LEVEL_ID, SYST_ID, TEXT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMMC_ACTIVITY_ST ON MMC_ACTIVITY_ST
(ACTIVITY_ST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMMR_QUESTION_ITEM ON MMR_QUESTION_ITEM
(QUESTION_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMODEM_COMMANDS ON MODEM_COMMANDS
(MODEM_TYPE_ID, COMMAND_TYPE_CD, REMOTE_DEV_TYPE_ID, QUALIFIER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMP_VIEWPOINT_ENCNTR ON MP_VIEWPOINT_ENCNTR
(MP_VIEWPOINT_ENCNTR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMRU_LOOKUP_FOLLOWUP ON MRU_LOOKUP_FOLLOWUP
(MRU_LOOKUP_FOLLOWUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMSG_CATEGORY ON MSG_CATEGORY
(MSG_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMSG_CFG_CAT_RELTN ON MSG_CFG_CAT_RELTN
(MSG_CFG_CAT_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMSG_FYI_ASSIGNMENT ON MSG_FYI_ASSIGNMENT
(MSG_FYI_ASSIGNMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMSG_ITM_GRP_CAT_RELTN ON MSG_ITM_GRP_CAT_RELTN
(MSG_ITM_GRP_CAT_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNMDP_CODE ON NMDP_CODE
(NMDP_CODE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNMDP_SUBTYPE ON NMDP_SUBTYPE
(NMDP_SUFFIX_ID, SUBTYPE_SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNOMENCLATURE ON NOMENCLATURE
(NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNOMENCLATURE_OUTBOUND ON NOMENCLATURE_OUTBOUND
(NOMENCLATURE_ID, SOURCE_VOCABULARY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNOMEN_GROUP_RELTN ON NOMEN_GROUP_RELTN
(NOMEN_GROUP_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNOTE_TYPE_TEMPLATE_RELTN ON NOTE_TYPE_TEMPLATE_RELTN
(NOTE_TYPE_TEMPLATE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_ERROR ON OEN_ERROR
(ERROR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_ERROR_SEQ_R ON OEN_ERROR_SEQ_R
(ERROR_SEQ_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_EXPRESSION ON OEN_EXPRESSION
(RULE_ID, PUBLICATION_ID, SEQUENCE_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_INTERFACE_ERR_R ON OEN_INTERFACE_ERR_R
(INTERFACE_ID, ERROR_ID, SEQUENCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_INTERFACE_SCR_R ON OEN_INTERFACE_SCR_R
(INTERFACE_ID, SCRIPT_ID, VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_SCRIPT_BODY ON OEN_SCRIPT_BODY
(SCRIPT_ID, LINE_NBR, VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOEN_SEQ_STEP_R ON OEN_SEQ_STEP_R
(SEQUENCE_ID, STEP_ID, ORDER_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOE_FORMAT_FIELDS ON OE_FORMAT_FIELDS
(OE_FORMAT_ID, ACTION_TYPE_CD, OE_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_ACC_FACT ON OMF_ACC_FACT
(OMF_ACC_FACT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_ACR_FACT ON OMF_ACR_FACT
(OMF_ACR_FACT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_AUDIT_CAT ON OMF_AUDIT_CAT
(AUDIT_CAT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_AUDIT_CAT_GRID_RELTN ON OMF_AUDIT_CAT_GRID_RELTN
(OMF_AUDIT_CAT_GRID_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_AUDIT_CAT_IND_RELTN ON OMF_AUDIT_CAT_IND_RELTN
(OMF_AUDIT_CAT_IND_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_AUTH_ATTR ON OMF_AUTH_ATTR
(OMF_AUTH_ATTR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_AUTH_LOGON_ATTR_RELTN ON OMF_AUTH_LOGON_ATTR_RELTN
(OMF_AUTH_LOGON_ATTR_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_AUTH_PRSNL_GROUP ON OMF_AUTH_PRSNL_GROUP
(OMF_AUTH_PRSNL_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_BLS_FACT ON OMF_BLS_FACT
(OMF_BLS_FACT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_CFGRN_ITEM ON OMF_CFGRN_ITEM
(CFGRN_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_CFGRN_ITEM_ACTN ON OMF_CFGRN_ITEM_ACTN
(CFGRN_ITEM_ACTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_CFGRN_ITEM_SETNG ON OMF_CFGRN_ITEM_SETNG
(CFGRN_ITEM_SETNG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_PVI_FOLDERS ON OMF_PVI_FOLDERS
(FOLDER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOMF_PV_ITEMS ON OMF_PV_ITEMS
(OMF_PV_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKONC_DOCSET_ELEM_DECORATOR ON ONC_DOCSET_ELEM_DECORATOR
(ONC_DOCSET_ELEM_DECORATOR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKONC_FS_VIEW_RX_SET_RELTN ON ONC_FS_VIEW_RX_SET_RELTN
(ONC_FS_VIEW_RX_SET_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKONC_NOMEN_DOCSETREF_R ON ONC_NOMEN_DOCSETREF_R
(ONC_NOMEN_DOCSETREF_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKONC_TOKEN_ELEMENT_R ON ONC_TOKEN_ELEMENT_R
(ONC_TOKEN_ELEMENT_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKONLINE_ITEM_DEFINITION ON ONLINE_ITEM_DEFINITION
(TASK_ASSAY_CD, ONLINE_ITEM_VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_JOB_VERIFY ON OPS_JOB_VERIFY
(OPS_JOB_VERIFY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_MONTH_OF_YEAR ON OPS_MONTH_OF_YEAR
(OPS_MONTH_OF_YEAR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_SCHEDULE_PARAM ON OPS_SCHEDULE_PARAM
(OPS_SCHEDULE_PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_SCHEDULE_TASK ON OPS_SCHEDULE_TASK
(OPS_SCHEDULE_TASK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_WEEK_OF_MONTH ON OPS_WEEK_OF_MONTH
(OPS_WEEK_OF_MONTH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORDER_CATALOG ON ORDER_CATALOG
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORDER_CATALOG_REVIEW ON ORDER_CATALOG_REVIEW
(CATALOG_CD, ACTION_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORDER_CATALOG_SYNONYM ON ORDER_CATALOG_SYNONYM
(SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORDER_CATALOG_TEXT ON ORDER_CATALOG_TEXT
(CATALOG_CD, TEXT_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORDER_TASK_XREF ON ORDER_TASK_XREF
(CATALOG_CD, REFERENCE_TASK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOS_RBLD_MSG ON OS_RBLD_MSG
(OS_RBLD_MSG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOUTCOME_CATALOG ON OUTCOME_CATALOG
(OUTCOME_CATALOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOUTCOME_CAT_CRITERIA ON OUTCOME_CAT_CRITERIA
(OUTCOME_CAT_CRITERIA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPATHWAY_COMP ON PATHWAY_COMP
(PATHWAY_COMP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_INDICATION ON PBS_INDICATION
(PBS_INDICATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_ITEM ON PBS_ITEM
(PBS_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_NOTE_RELTN ON PBS_NOTE_RELTN
(PBS_NOTE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_OUTCOME ON PCA_OUTCOME
(PCA_OUTCOME_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_QUALITY_MEASURE ON PCA_QUALITY_MEASURE
(PCA_QUALITY_MEASURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_QUALITY_TOPIC ON PCA_QUALITY_TOPIC
(PCA_QUALITY_TOPIC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_QUALITY_TOPIC_CONTROL ON PCA_QUALITY_TOPIC_CONTROL
(PCA_QUALITY_TOPIC_CONTROL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_TOPIC_MEASURE_RELTN ON PCA_TOPIC_MEASURE_RELTN
(PCA_TOPIC_MEASURE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_TOPIC_MEASURE_TARGET ON PCA_TOPIC_MEASURE_TARGET
(PCA_TOPIC_MEASURE_TARGET_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCS_CRITERIA ON PCS_CRITERIA
(CRITERIA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCS_FRMT_VRSN_ELEMENT ON PCS_FRMT_VRSN_ELEMENT
(PCS_FRMT_VRSN_ELEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCS_HIERARCHY_QUEUE_RELTN ON PCS_HIERARCHY_QUEUE_RELTN
(HIERARCHY_QUEUE_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCS_LAYOUT_GROUP ON PCS_LAYOUT_GROUP
(PCS_LAYOUT_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCS_LAYOUT_GROUP_EVENT ON PCS_LAYOUT_GROUP_EVENT
(PCS_LAYOUT_GROUP_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCS_SUB_CRITERIA ON PCS_SUB_CRITERIA
(SUB_CRITERIA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPC_ATTRIBUTE_VALUE ON PC_ATTRIBUTE_VALUE
(ATTRIBUTE_VALUE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPC_REF_ENC_LOC ON PC_REF_ENC_LOC
(REF_ENC_LOC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPC_REF_ENC_STATUS ON PC_REF_ENC_STATUS
(REF_ENC_STATUS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPC_REF_ENC_TYPE ON PC_REF_ENC_TYPE
(REF_ENC_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPFT_REPORT_OPTION ON PFT_REPORT_OPTION
(PFT_REPORT_OPTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPG_QUESTION ON PG_QUESTION
(PG_QUESTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPG_RESULT_STAGE ON PG_RESULT_STAGE
(PG_RESULT_STAGE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPHASE_GROUP ON PHASE_GROUP
(PHASE_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPHA_SWITCH_CONN_R ON PHA_SWITCH_CONN_R
(RX_CONNECTION_ID, SWITCH_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPI_LEAFLET ON PI_LEAFLET
(PI_LEAFLET_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_CONV_RELTN ON PM_CONV_RELTN
(PM_CONV_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_DOC_DESTINATION ON PM_DOC_DESTINATION
(DESTINATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_INFO ON PM_INFO
(PM_CD, INSTANCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_BATCH_PARAMS ON PM_RPT_BATCH_PARAMS
(BATCH_PARAMS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_DISPLAY ON PM_RPT_DISPLAY
(DISPLAY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_FILTER ON PM_RPT_FILTER
(FILTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_FILTER_VALUES ON PM_RPT_FILTER_VALUES
(FILTER_VALUES_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_HEADER ON PM_RPT_HEADER
(HEADER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_ORDER ON PM_RPT_ORDER
(ORDER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPOSITIVE_PROBES ON POSITIVE_PROBES
(LOT_NUMBER_ID, ALLELE_CD, PROBE_NUMBER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPO_BATCH ON PO_BATCH
(PO_BATCH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPREFDIR_ACL ON PREFDIR_ACL
(ENTRY_ID, VALUE_UPPER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPRIMER_KIT_SPECIFICITY ON PRIMER_KIT_SPECIFICITY
(LOT_NUMBER_ID, ALLELE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPRODUCT_CATEGORY ON PRODUCT_CATEGORY
(PRODUCT_CAT_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPRODUCT_DEFAULT_ADDRESS ON PRODUCT_DEFAULT_ADDRESS
(PRODUCT_DEFAULT_ADDRESS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPRSNL_ROLE_TYPE ON PRSNL_ROLE_TYPE
(PRSNL_ROLE_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPW_COMP_CAT_RELTN ON PW_COMP_CAT_RELTN
(PW_COMP_CAT_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPW_COMP_GROUP ON PW_COMP_GROUP
(PW_COMP_GROUP_ID, PATHWAY_COMP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPW_COMP_OS_RELTN ON PW_COMP_OS_RELTN
(PATHWAY_COMP_ID, ORDER_SENTENCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPW_COMP_RELTN ON PW_COMP_RELTN
(PATHWAY_COMP_S_ID, PATHWAY_COMP_T_ID, TYPE_MEAN, PATHWAY_CATALOG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKQC_RULE ON QC_RULE
(RULE_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKQC_SCHEDULE_CTRL ON QC_SCHEDULE_CTRL
(QC_SCHEDULE_ID, STEP_NBR, CONTROL_ID, ERROR_STEP_IND)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKQC_STAT_PERIOD ON QC_STAT_PERIOD
(QC_STAT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_BILL_CATEGORIES ON RAD_BILL_CATEGORIES
(BILL_CAT_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_ENCNTR_PATH_R ON RAD_ENCNTR_PATH_R
(RAD_ENCNTR_PATH_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_FOLLOW_UP_CONTROL ON RAD_FOLLOW_UP_CONTROL
(FOLLOW_UP_CONTROL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_FOLLOW_UP_RECALL ON RAD_FOLLOW_UP_RECALL
(CATALOG_CD, BEGINNING_AGE_RANGE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_MED_CAT_LIST ON RAD_MED_CAT_LIST
(RAD_MED_CATEGORY_ID, SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_OMF_TC_INDICATOR ON RAD_OMF_TC_INDICATOR
(INDICATOR_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_OMF_TC_IND_R ON RAD_OMF_TC_IND_R
(INDICATOR_CD, PARENT_FIELD_ID, FIELD_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_PROCEDURE_ASSOC ON RAD_PROCEDURE_ASSOC
(PROC_GROUP_ID, CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_PROCEDURE_TIMES ON RAD_PROCEDURE_TIMES
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_PROC_FIELD_RELTN ON RAD_PROC_FIELD_RELTN
(CATALOG_CD, EXPOSURE_FIELD_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_RELEVANT_PRIOR_RELTN ON RAD_RELEVANT_PRIOR_RELTN
(RAD_RELEVANT_PRIOR_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_TECH_FLD_FMT_R ON RAD_TECH_FLD_FMT_R
(FIELD_FORMAT_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_TECH_FMT_ERPRC_R ON RAD_TECH_FMT_ERPRC_R
(FORMAT_ERPRC_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_ADJUSTMENT ON RC_F_ADJUSTMENT
(RC_F_ADJUSTMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_CASH ON RC_F_CASH
(RC_F_CASH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_CLAIM_EVENT ON RC_F_CLAIM_EVENT
(RC_F_CLAIM_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DAILY_CDM_SMRY ON RC_F_DAILY_CDM_SMRY
(RC_F_DAILY_CDM_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DAILY_CENSUS ON RC_F_DAILY_CENSUS
(RC_F_DAILY_CENSUS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DAILY_CENSUS_SMRY ON RC_F_DAILY_CENSUS_SMRY
(RC_F_DAILY_CENSUS_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DAILY_CLAIM_EVENT_SMRY ON RC_F_DAILY_CLAIM_EVENT_SMRY
(RC_F_DAILY_CLAIM_EVENT_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DAILY_TRANS_SMRY ON RC_F_DAILY_TRANS_SMRY
(RC_F_DAILY_TRANS_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DENIAL ON RC_F_DENIAL
(RC_F_DENIAL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_DLY_ENCNTR_VISIT_SMRY ON RC_F_DAILY_ENCNTR_VISIT_SMRY
(DAILY_ENCNTR_VISIT_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_MONTHLY_CDM_SMRY ON RC_F_MONTHLY_CDM_SMRY
(RC_F_MONTHLY_CDM_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_MONTHLY_CENSUS_SMRY ON RC_F_MONTHLY_CENSUS_SMRY
(RC_F_MONTHLY_CENSUS_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_MONTHLY_CLAIM_EVENT_S ON RC_F_MONTHLY_CLAIM_EVENT_SMRY
(MONTHLY_CLAIM_EVENT_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_MONTHLY_DENIAL_SMRY ON RC_F_MONTHLY_DENIAL_SMRY
(RC_F_MONTHLY_DENIAL_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_MONTHLY_ENCNTR_VISIT_S ON RC_F_MONTHLY_ENCNTR_VISIT_SMRY
(MONTHLY_ENCNTR_VISIT_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_MONTHLY_TRANS_SMRY ON RC_F_MONTHLY_TRANS_SMRY
(RC_F_MONTHLY_TRANS_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_PATIENT_AR_BALANCE ON RC_F_PATIENT_AR_BALANCE
(RC_F_PATIENT_AR_BALANCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_PATIENT_AR_BAL_SMRY ON RC_F_PATIENT_AR_BAL_SMRY
(RC_F_PATIENT_AR_BAL_SMRY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRC_F_REVENUE ON RC_F_REVENUE
(RC_F_REVENUE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREFERENCE_RANGE_FACTOR ON REFERENCE_RANGE_FACTOR
(REFERENCE_RANGE_FACTOR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREF_DATAPOINT ON REF_DATAPOINT
(REF_DATAPOINT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREF_DATAPOINT_HIST ON REF_DATAPOINT_HIST
(REF_DATAPOINT_ID, ACTION_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREF_RANGE_FACTOR_RULE ON REF_RANGE_FACTOR_RULE
(REF_RANGE_FACTOR_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREF_RANGE_NOTIFY_TRIG ON REF_RANGE_NOTIFY_TRIG
(REF_RANGE_NOTIFY_TRIG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREF_TEXT_FACILITY_R ON REF_TEXT_FACILITY_R
(REF_TEXT_VARIATION_ID, FACILITY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRELATED_ASSAY ON RELATED_ASSAY
(RELATED_ENTITY_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREPORT_HISTORY_GROUPING_R ON REPORT_HISTORY_GROUPING_R
(GROUPING_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREQUESTER ON REQUESTER
(REQUESTER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRR_ACCESSION_R ON RR_ACCESSION_R
(ROUND_ROBIN_REF_ID, ACCESSION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRR_RESULT ON RR_RESULT
(RR_RESULT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRXS_WORKLIST ON RXS_WORKLIST
(RXS_WORKLIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRXS_WORKLIST_LEGAL_STATUS ON RXS_WORKLIST_LEGAL_STATUS
(RXS_WORKLIST_LEGAL_STATUS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRX_PRINTER_LOCATION_R ON RX_PRINTER_LOCATION_R
(LOCATION_CD, DISPENSE_CATEGORY_CD, DEVICE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRX_PRODUCT_ASSIGN_ITEM_AUDI ON RX_PRODUCT_ASSIGN_ITEM_AUDIT
(CATALOG_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_ACTION ON SA_REF_ACTION
(SA_REF_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_ACTION_GROUP_R ON SA_REF_ACTION_GROUP_R
(SA_REF_ACTION_GROUP_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_ACTION_ITEM_CHILD_GR ON SA_REF_ACTION_ITEM_CHILD_GROUP
(SA_REF_ACTN_ITEM_CHILD_GRP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CATEGORY ON SA_REF_CATEGORY
(SA_REF_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CAT_ACTION ON SA_REF_CAT_ACTION
(SA_REF_CAT_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CAT_ITEM ON SA_REF_CAT_ITEM
(SA_REF_CAT_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CAT_PARAMETER ON SA_REF_CAT_PARAMETER
(SA_REF_CAT_PARAMETER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CAT_PRSNL ON SA_REF_CAT_PRSNL
(SA_REF_CAT_PRSNL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CAT_PRSNL_POSITION ON SA_REF_CAT_PRSNL_POSITION
(SA_REF_CAT_PRSNL_POSITION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_CAT_PRSNL_PROVIDER ON SA_REF_CAT_PRSNL_PROVIDER
(SA_REF_CAT_PRSNL_PROVIDER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_EXCLUDE_ACTION ON SA_REF_EXCLUDE_ACTION
(SA_REF_EXCLUDE_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_EXCLUDE_ITEM ON SA_REF_EXCLUDE_ITEM
(SA_REF_EXCLUDE_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_EXCLUDE_PARAMETER ON SA_REF_EXCLUDE_PARAMETER
(SA_REF_EXCLUDE_PARAMETER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_REQUIRED_ACTION ON SA_REF_REQUIRED_ACTION
(SA_REF_REQUIRED_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSA_REF_REQUIRED_CATEGORY ON SA_REF_REQUIRED_CATEGORY
(SA_REF_REQUIRED_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSCH_ABN_CROSS ON SCH_ABN_CROSS
(ABN_CROSS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSCH_FREQ ON SCH_FREQ
(FREQUENCY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSCH_NOMEN_LIST ON SCH_NOMEN_LIST
(APPT_TYPE_CD, APPT_NOMEN_CD, SEQ_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSCR_PARAGRAPH_TYPE ON SCR_PARAGRAPH_TYPE
(SCR_PARAGRAPH_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSELECTED_TASK ON SELECTED_TASK
(SELECTED_TASK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSEMANTIC_NETWORK ON SEMANTIC_NETWORK
(SEMANTIC_NETWORK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSERVICE_DESCRIPTION ON SERVICE_DESCRIPTION
(SERVICE_REQUEST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSERVICE_DIRECTORY ON SERVICE_DIRECTORY
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSHX_CATEGORY_DEF ON SHX_CATEGORY_DEF
(SHX_CATEGORY_DEF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSHX_ELEMENT ON SHX_ELEMENT
(SHX_ELEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSIGN_LINE_DTA_R ON SIGN_LINE_DTA_R
(ACTIVITY_SUBTYPE_CD, TASK_ASSAY_CD, STATUS_FLAG)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_COMSRV_MSG_MAP_R ON SI_COMSRV_MSG_MAP_R
(MESSAGE_ID, MAP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_ENTITY_TEMPLATE_GROUP_R ON SI_ENTITY_TEMPLATE_GROUP_R
(SI_ENTITY_TEMPLATE_GROUP_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_ERROR_RELTN ON SI_ERROR_RELTN
(SI_ERROR_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_OEN_COMCHANNEL ON SI_OEN_COMCHANNEL
(SI_OEN_COMCHANNEL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_OEN_ENDPOINT ON SI_OEN_ENDPOINT
(SI_OEN_ENDPOINT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_OEN_SUBSCRIPTION_STEP_R ON SI_OEN_SUBSCRIPTION_STEP_R
(SI_OEN_SUBSCRIPTION_STEP_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_CT_DISPLAY_ROW ON SN_CT_DISPLAY_ROW
(SN_CT_DISPLAY_ROW_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_PROC_CPT_R ON SN_PROC_CPT_R
(PROC_CPT_ASSOC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_RPT_FIELD ON SN_RPT_FIELD
(RPT_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_RPT_FIELD_REF ON SN_RPT_FIELD_REF
(RPT_FIELD_REF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_RPT_FIELD_SETTING ON SN_RPT_FIELD_SETTING
(RPT_FIELD_SETTING_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_SUP_CAB_PREF_FIELD ON SN_SUP_CAB_PREF_FIELD
(SN_SUP_CAB_PREF_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTANDARDIZED_ORDER_DOSE ON STANDARDIZED_ORDER_DOSE
(STANDARDIZED_ORDER_DOSE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTORAGE_CONTENT ON STORAGE_CONTENT
(STORAGE_CONTENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTORAGE_CONTENT_EVENT ON STORAGE_CONTENT_EVENT
(STORAGE_CONTENT_EVENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTRT_BMDI_MODEL_PARAMETER ON STRT_BMDI_MODEL_PARAMETER
(STRT_MODEL_PARAMETER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTRT_MFG_MODEL_R ON STRT_MFG_MODEL_R
(STRT_MODEL_ID, STRT_MFG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTRT_MODEL_ASSAY_ALPHA_RESP ON STRT_MODEL_ASSAY_ALPHA_RESP
(STRT_ASSAY_CD, RANGE_SEQ, STRT_MODEL_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSURGICAL_PROCEDURE ON SURGICAL_PROCEDURE
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSURG_PROC_DETAIL ON SURG_PROC_DETAIL
(SURG_PROC_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTAG_FOUNDATION ON TAG_FOUNDATION
(TAG_GROUP_ID, TAG_SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTASK_DISCRETE_R ON TASK_DISCRETE_R
(REFERENCE_TASK_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTEMPLATE_KEYWORD_RELTN ON TEMPLATE_KEYWORD_RELTN
(TEMPLATE_KEYWORD_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTEXT_DATA ON TEXT_DATA
(TASK_ASSAY_CD, RESULT_TEMPLATE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTHERAPEUTIC_CAT_ITEM ON THERAPEUTIC_CAT_ITEM
(THERAPEUTIC_CAT_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTHERMOCYCLER_RACK ON THERMOCYCLER_RACK
(RACK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTHERMO_RACK_PLACEMENT ON THERMO_RACK_PLACEMENT
(ORDER_ID, GEL_BATCH_ID, RACK_ID, X_POS, Y_POS)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTL_COLUMN_CONTENT ON TL_COLUMN_CONTENT
(TL_TAB_ID, COLUMN_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTL_ELIGIBLE_TASK_CODE ON TL_ELIGIBLE_TASK_CODE
(TL_TAB_ID, TASK_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTL_MASTER_TAB_SET_XREF ON TL_MASTER_TAB_SET_XREF
(TL_TAB_ID, MASTER_TAB_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTL_TF_POSITION_XREF ON TL_TF_POSITION_XREF
(TL_TIME_FRAME_ID, POSITION_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTPL_APPL ON TPL_APPL
(APPL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTPL_APPL_CTX_PARAM ON TPL_APPL_CTX_PARAM
(APPL_CTX_PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTPL_APPL_TASK_RELTN ON TPL_APPL_TASK_RELTN
(APPL_TASK_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_ACTION_LINK ON TRACK_ACTION_LINK
(TRACK_ACTION_LINK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_COMP_PREFS ON TRACK_COMP_PREFS
(TRACK_PREF_COMP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_FIELD_SPEC ON TRACK_FIELD_SPEC
(TRACK_FIELD_SPEC_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_FIELD_SPEC_BEHAVIOR ON TRACK_FIELD_SPEC_BEHAVIOR
(TRACK_FIELD_SPEC_BEHAVIOR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_FIELD_SPEC_REFINEMENT ON TRACK_FIELD_SPEC_REFINEMENT
(TRACK_FIELD_SPEC_REFINEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_LIST ON TRACK_LIST
(TRACK_LIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_LIST_ASSIGNMENT ON TRACK_LIST_ASSIGNMENT
(TRACK_LIST_ASSIGNMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTRACK_LIST_FILTER_RELTN ON TRACK_LIST_FILTER_RELTN
(TRACK_LIST_FILTER_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTUBE_INFORMATION ON TUBE_INFORMATION
(LOT_NUMBER_ID, TUBE_NUMBER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_CASE_CHARGE_ORDRBL_R ON UCMR_CASE_CHARGE_ORDRBL_R
(UCMR_CASE_CHARGE_ORDRBL_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_CASE_STEP ON UCMR_CASE_STEP
(UCMR_CASE_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_CASE_TRIGGER ON UCMR_CASE_TRIGGER
(UCMR_CASE_TRIGGER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_EQUIVALENT_STEP ON UCMR_EQUIVALENT_STEP
(UCMR_EQUIVALENT_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_KARYOTYPE_CONCEPT ON UCMR_KARYOTYPE_CONCEPT
(UCMR_KARYOTYPE_CONCEPT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_LAYOUT_FIELD ON UCMR_LAYOUT_FIELD
(UCMR_LAYOUT_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_POSITION_MAP ON UCMR_POSITION_MAP
(UCMR_POSITION_MAP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_POSITION_MAP_CELL ON UCMR_POSITION_MAP_CELL
(UCMR_POSITION_MAP_CELL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_REQUIRED_STEP ON UCMR_REQUIRED_STEP
(UCMR_REQUIRED_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKWORKING_VIEW_ITEM ON WORKING_VIEW_ITEM
(WORKING_VIEW_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKWORKLIST_POS_ORDER_R ON WORKLIST_POS_ORDER_R
(WORKLIST_POS_ORDER_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKWORKLOAD_CODE ON WORKLOAD_CODE
(WORKLOAD_CODE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKWORKLOAD_GROUP ON WORKLOAD_GROUP
(WORKLOAD_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPK_C00155272 ON CV_XREF_FIELD
(XREF_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPK_EKS_NOTIFICATION_BLOB ON EKS_NOTIFICATION_BLOB_R
(NOTIFICATION_ID, LONG_BLOB_ID, DATA_SEQ)
LOGGING
NOPARALLEL;


CREATE TABLE ADVANCED_DELTA
(
  ADVANCED_DELTA_ID          NUMBER             DEFAULT 0                     NOT NULL,
  REFERENCE_RANGE_FACTOR_ID  NUMBER             DEFAULT 0                     NOT NULL,
  DELTA_IND                  NUMBER             DEFAULT 0                     NOT NULL,
  DELTA_LOW                  FLOAT(126),
  DELTA_HIGH                 FLOAT(126),
  DELTA_CHECK_TYPE_CD        NUMBER             DEFAULT 0                     NOT NULL,
  DELTA_MINUTES              NUMBER,
  DELTA_VALUE                NUMBER,
  ACTIVE_IND                 NUMBER,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID     NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALPHA_RESPONSES_CATEGORY
(
  ALPHA_RESPONSES_CATEGORY_ID  NUMBER           DEFAULT 0                     NOT NULL,
  REFERENCE_RANGE_FACTOR_ID    NUMBER           DEFAULT 0                     NOT NULL,
  CATEGORY_NAME                VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL,
  DISPLAY_SEQ                  NUMBER           DEFAULT 0                     NOT NULL,
  EXPAND_FLAG                  NUMBER           DEFAULT 1                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALT_SEL_CAT
(
  ALT_SEL_CATEGORY_ID             NUMBER        DEFAULT 0                     NOT NULL,
  SHORT_DESCRIPTION               VARCHAR2(500 BYTE),
  LONG_DESCRIPTION                VARCHAR2(1000 BYTE),
  OWNER_ID                        NUMBER        DEFAULT 0                     NOT NULL,
  SECURITY_FLAG                   NUMBER,
  UPDT_CNT                        NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                      DATE          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                         NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_TASK                       NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                    NUMBER        DEFAULT 0                     NOT NULL,
  CHILD_CAT_IND                   NUMBER,
  LONG_DESCRIPTION_KEY_CAP        VARCHAR2(1000 BYTE),
  AHFS_IND                        NUMBER,
  ADHOC_IND                       NUMBER,
  SOURCE_COMPONENT_FLAG           NUMBER        DEFAULT 0                     NOT NULL,
  FOLDER_FLAG                     NUMBER,
  LONG_DESCRIPTION_KEY_CAP_A_NLS  VARCHAR2(4000 BYTE),
  LONG_DESCRIPTION_KEY_CAP_NLS    VARCHAR2(2002 BYTE),
  IV_SET_SYNONYM_ID               NUMBER        DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALT_SEL_LIST
(
  ALT_SEL_CATEGORY_ID     NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE                NUMBER                DEFAULT 0                     NOT NULL,
  SYNONYM_ID              NUMBER                DEFAULT 0                     NOT NULL,
  LIST_TYPE               NUMBER,
  CHILD_ALT_SEL_CAT_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  REFERENCE_TASK_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_SENTENCE_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PATHWAY_CATALOG_ID      NUMBER                DEFAULT 0                     NOT NULL,
  REGIMEN_CAT_SYNONYM_ID  NUMBER                DEFAULT 0,
  PW_CAT_SYNONYM_ID       NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_DC_STUDY_RPT_PROC
(
  STUDY_ID       NUMBER                         DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD  NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_DIAG_AUTO_CODE
(
  CATALOG_CD     NUMBER                         DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD  NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PROCESSING_GRP_R
(
  GROUPER_CD          NUMBER                    DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD       NUMBER                    DEFAULT 0                     NOT NULL,
  BEGIN_SECTION       NUMBER,
  END_SECTION         NUMBER,
  BEGIN_LEVEL         NUMBER,
  END_LEVEL           NUMBER,
  MULTIPLIER          NUMBER,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  NO_CHARGE_IND       NUMBER,
  SEQUENCE            NUMBER                    DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME  VARCHAR2(32 BYTE)         DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID    NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PROMPT_TEST
(
  ACCESSION_ID   NUMBER                         DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD  NUMBER                         DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID   NUMBER                         DEFAULT 0                     NOT NULL,
  ACTIVE_IND     NUMBER                         DEFAULT 0,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_SYNOPTIC_RPT_SECTION_R
(
  CATALOG_CD      NUMBER                        DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD   NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  CKI_SOURCE      CHAR(12 BYTE)                 DEFAULT ' '                   NOT NULL,
  CKI_IDENTIFIER  VARCHAR2(50 BYTE)             DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_TASK_ASSAY_ADDL
(
  TASK_ASSAY_CD          NUMBER                 DEFAULT 0                     NOT NULL,
  HALF_SLIDE_IND         NUMBER,
  STAIN_IND              NUMBER,
  TASK_TYPE_FLAG         NUMBER,
  SLIDE_ORIGIN_FLAG      NUMBER,
  CREATE_INVENTORY_FLAG  NUMBER,
  PRINT_LABEL_IND        NUMBER,
  PRINT_WORKLIST_IND     NUMBER,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  DATE_OF_SERVICE_CD     NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSAY_TAT
(
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  PRIORITY_CD             NUMBER                DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD     NUMBER                DEFAULT 0                     NOT NULL,
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  TAT_CD                  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' )
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_ACTION
(
  AC_ACTION_ID              NUMBER              DEFAULT 0                     NOT NULL,
  AC_APPLICATION_ID         NUMBER              DEFAULT 0                     NOT NULL,
  AC_DISPLAY                VARCHAR2(50 BYTE),
  AC_MNEM_TYPE_ID           NUMBER              DEFAULT 0                     NOT NULL,
  AC_MNEM_TYPE_PARAM        VARCHAR2(50 BYTE),
  AC_PARAM_TYPE_ID          NUMBER              DEFAULT 0                     NOT NULL,
  AC_DEFAULT_MODEL_NAME     VARCHAR2(100 BYTE),
  AC_DEFAULT_VERIFY_PARAMS  VARCHAR2(255 BYTE),
  AC_PREREQS                VARCHAR2(255 BYTE),
  AC_BEGIN_STATE_ID         NUMBER              DEFAULT 0                     NOT NULL,
  AC_END_STATE_ID           NUMBER              DEFAULT 0                     NOT NULL,
  AC_STATE_FLAG             NUMBER,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  AC_COMPONENT_ID           NUMBER              DEFAULT 0,
  AC_ALT_MNEM_TYPE_ID       NUMBER              DEFAULT 0,
  AC_MNEM_LABEL             VARCHAR2(50 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_ACTIONPARAMETER
(
  ACP_ACTION_PARAM_ID       NUMBER              DEFAULT 0                     NOT NULL,
  ACP_ACTION_ID             NUMBER              DEFAULT 0                     NOT NULL,
  ACP_SEQ                   NUMBER,
  ACP_PARAM_ID              NUMBER              DEFAULT 0                     NOT NULL,
  ACP_DEFAULT               VARCHAR2(50 BYTE),
  ACP_VALUE_TYPE_ID         NUMBER              DEFAULT 0                     NOT NULL,
  ACP_STATE_FLAG            NUMBER,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  ACP_DISPLAY               VARCHAR2(50 BYTE),
  ACP_QUERY_TEXT_ID         NUMBER              DEFAULT 0,
  ACP_OTHER_VALUES_TEXT_ID  NUMBER              DEFAULT 0,
  ACP_LIST_SET              NUMBER,
  ACP_PARENT_ID             NUMBER              DEFAULT 0,
  ACP_PARAMETER_TYPE_FLAG   NUMBER,
  ACP_PARAMETER_OPTIONS     NUMBER              DEFAULT 0,
  ACP_FIELD_TYPE_ID         NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_ACTIONSCREEN
(
  AS_ACTION_SCREEN_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  AS_ACTION_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  AS_SEQ               NUMBER,
  AS_DISPLAY           VARCHAR2(50 BYTE),
  AS_DESCRIPTION_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_ALT_ACTION_NAME
(
  AN_ALT_ACTION_NAME_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  AN_ACTION_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  AN_RELEASE_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  AN_NAME                VARCHAR2(50 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  AN_STATE_FLAG          NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_APPACTION
(
  AA_APPLICATION_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  AA_END_STATE_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  AA_OPEN_STATE      VARCHAR2(255 BYTE),
  AA_CLOSE_STATE     VARCHAR2(255 BYTE),
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_BATCHDETAIL
(
  BD_BATCH_DETAIL_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  BD_BATCH_ID         NUMBER                    DEFAULT 0                     NOT NULL,
  BD_SEQ              NUMBER,
  BD_PLAN_DOMAIN_ID   NUMBER                    DEFAULT 0                     NOT NULL,
  BD_PLAN_ID          NUMBER                    DEFAULT 0                     NOT NULL,
  BD_MIN_SUCC_EXES    NUMBER,
  BD_MAX_EXES         NUMBER,
  BD_SUCCESSES        NUMBER,
  BD_COMPLETIONS      NUMBER,
  BD_STATUS_FLAG      NUMBER                    DEFAULT 0                     NOT NULL,
  BD_DISPLAY          VARCHAR2(50 BYTE),
  BD_DESCRIPTION_ID   NUMBER                    DEFAULT 0                     NOT NULL,
  BD_CATEGORY_ID      NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_BATCHSTEP
(
  BS_STEP_ID              NUMBER                DEFAULT 0                     NOT NULL,
  BS_BATCH_DETAIL_ID      NUMBER                DEFAULT 0                     NOT NULL,
  BS_SEQ                  NUMBER,
  BS_ACTION_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BS_DISPLAY              VARCHAR2(255 BYTE),
  BS_REF_STEP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  BS_SPECIFIED_PARAMS_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BS_VERIFY_PARAMS_ID     NUMBER                DEFAULT 0                     NOT NULL,
  BS_BATCH_OBJECTIVE_ID   NUMBER                DEFAULT 0                     NOT NULL,
  BS_REF_MNEM             VARCHAR2(255 BYTE),
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  BS_ALT_REF_MNEM         VARCHAR2(255 BYTE),
  BS_ALT_REF_STEP_ID      NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_LOG
(
  LG_DEVICE_ID      NUMBER                      DEFAULT 0                     NOT NULL,
  LG_LOG_DT_TM      DATE                        DEFAULT sysdate               NOT NULL,
  LG_SEQ            NUMBER                      DEFAULT 0                     NOT NULL,
  LG_DETAIL_DT_TM   DATE,
  LG_DEFAULT_LEVEL  VARCHAR2(1 BYTE),
  LG_MESSAGE        VARCHAR2(255 BYTE),
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  LG_RUN_ID         NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_OBJECTIVE
(
  OB_OBJECTIVE_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  OB_PLAN_ID         NUMBER                     DEFAULT 0                     NOT NULL,
  OB_SEQ             NUMBER,
  OB_DISPLAY         VARCHAR2(50 BYTE),
  OB_DESCRIPTION_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  OB_STEP_COUNT      NUMBER,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_POSTCONDITION
(
  POS_ACTION_ID         NUMBER                  DEFAULT 0                     NOT NULL,
  POS_KEYWORD_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  POS_DELETE_IND        NUMBER,
  POS_STATE_FLAG        NUMBER,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  POS_ACTIONDETAIL_IND  NUMBER,
  DM2_MIG_SEQ_ID        NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_PRECONDITION
(
  PRE_KEYWORD_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  PRE_ACTION_ID         NUMBER                  DEFAULT 0                     NOT NULL,
  PRE_STATE_FLAG        NUMBER,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  PRE_ACTIONDETAIL_IND  NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_RUNSTEP
(
  RS_RUN_STEP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  RS_RUN_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RS_SEQ                  NUMBER,
  RS_STEP_ID              NUMBER                DEFAULT 0                     NOT NULL,
  RS_ACTION_ID            NUMBER                DEFAULT 0                     NOT NULL,
  RS_DISPLAY              VARCHAR2(255 BYTE),
  RS_ACTION_DETAIL        VARCHAR2(255 BYTE),
  RS_SPECIFIED_PARAMS_ID  NUMBER                DEFAULT 0                     NOT NULL,
  RS_VERIFY_PARAMS_ID     NUMBER                DEFAULT 0                     NOT NULL,
  RS_RUN_DT_TM            DATE,
  RS_STATUS_FLAG          NUMBER,
  RS_ACTUAL_PARAMS_ID     NUMBER                DEFAULT 0                     NOT NULL,
  RS_PROC_ERRORS_ID       NUMBER                DEFAULT 0                     NOT NULL,
  RS_INFO_MESSAGES_ID     NUMBER                DEFAULT 0                     NOT NULL,
  RS_RUN_OBJECTIVE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  RS_COMMENT_ID           NUMBER                DEFAULT 0,
  RS_ERROR_REFERENCE      VARCHAR2(25 BYTE)     DEFAULT ' ',
  RS_ERROR_CODE_ID        NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_STEP
(
  ST_STEP_ID              NUMBER                DEFAULT 0                     NOT NULL,
  ST_PLAN_ID              NUMBER                DEFAULT 0                     NOT NULL,
  ST_SEQ                  NUMBER,
  ST_SKIP_IND             NUMBER,
  ST_ACTION_ID            NUMBER                DEFAULT 0                     NOT NULL,
  ST_DISPLAY              VARCHAR2(255 BYTE),
  ST_REF_STEP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ST_REF_MNEM             VARCHAR2(255 BYTE),
  ST_SPECIFIED_PARAMS_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ST_VERIFY_PARAMS_ID     NUMBER                DEFAULT 0                     NOT NULL,
  ST_OBJECTIVE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ST_ALT_REF_MNEM         VARCHAR2(255 BYTE),
  ST_ALT_REF_STEP_ID      NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_SUBACTION
(
  SA_SUBACTION_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  SA_ACTION_ID     NUMBER                       DEFAULT 0                     NOT NULL,
  SA_SEQ           NUMBER,
  SA_TYPE_ID       NUMBER                       DEFAULT 0                     NOT NULL,
  SA_SUBACTION     VARCHAR2(255 BYTE),
  SA_BATCH_IND     NUMBER,
  SA_STATE_FLAG    NUMBER,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_SYNONYMTYPE
(
  SY_SYNONYM_ID      NUMBER                     DEFAULT 0                     NOT NULL,
  SY_ACTION_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  SY_SYNONYMTYPE_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  SY_MEANING         VARCHAR2(50 BYTE),
  SY_STATE_FLAG      NUMBER,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_TIMER
(
  TM_RUN_ID          NUMBER                     DEFAULT 0                     NOT NULL,
  TM_SEQ             NUMBER                     DEFAULT 0                     NOT NULL,
  TM_EVENT_DT_TM     DATE,
  TM_TYPE            NUMBER,
  TM_NAME            VARCHAR2(255 BYTE),
  TM_APPLICATION_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  TM_ACTION_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  TM_USER            VARCHAR2(50 BYTE),
  TM_PATIENT         VARCHAR2(50 BYTE),
  TM_VALUE           VARCHAR2(50 BYTE),
  TM_PASS_IND        NUMBER,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_GROUP_COMPONENT
(
  BB_GROUP_COMPONENT_ID   NUMBER                DEFAULT 0                     NOT NULL,
  BB_TEST_GROUP_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_QC_EXPECTED_RESULT_R
(
  EXPECTED_RESULT_ID         NUMBER             DEFAULT 0                     NOT NULL,
  RELATED_REAGENT_DETAIL_ID  NUMBER             DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  PREV_EXPECTED_RESULT_ID    NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_RH_PHENOTYPE
(
  RH_PHENOTYPE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  FR_NOMENCLATURE_ID      NUMBER                DEFAULT 0                     NOT NULL,
  W_NOMENCLATURE_ID       NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_RH_PHENO_TESTING
(
  RH_PHENO_TESTING_ID     NUMBER                DEFAULT 0                     NOT NULL,
  RH_PHENOTYPE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SPECIAL_TESTING_CD      NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT TO_DATE ( '01/01/190000:00:00' , 'MM/DD/YYYYHH24:MI:SS' ) NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_ONLY_PROC_RELTN
(
  CATALOG_CD    NUMBER                          DEFAULT 0                     NOT NULL,
  ENTITY_NAME   VARCHAR2(40 BYTE)               DEFAULT ' '                   NOT NULL,
  ENTITY_ID     NUMBER                          DEFAULT 0                     NOT NULL,
  STANDARD_QTY  NUMBER                          DEFAULT 0,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_DATAMART_DEFAULT
(
  BR_DATAMART_DEFAULT_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BR_DATAMART_FILTER_ID   NUMBER                DEFAULT 0                     NOT NULL,
  UNIQUE_IDENTIFIER       VARCHAR2(255 BYTE)    DEFAULT ' '                   NOT NULL,
  CV_DISPLAY              VARCHAR2(100 BYTE)    DEFAULT ' '                   NOT NULL,
  CV_DESCRIPTION          VARCHAR2(255 BYTE)    DEFAULT ' '                   NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  CODE_SET                NUMBER,
  RESULT_TYPE_FLAG        NUMBER,
  QUALIFIER_FLAG          NUMBER,
  RESULT_VALUE            VARCHAR2(255 BYTE),
  ORDER_DETAIL_IND        NUMBER,
  GROUP_NAME              VARCHAR2(100 BYTE),
  GROUP_CE_NAME           VARCHAR2(100 BYTE),
  GROUP_CE_CONCEPT_CKI    VARCHAR2(255 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_DATAMART_DEFAULT_DETAIL
(
  BR_DATAMART_DEFAULT_DETAIL_ID  NUMBER         DEFAULT 0                     NOT NULL,
  BR_DATAMART_DEFAULT_ID         NUMBER         DEFAULT 0                     NOT NULL,
  OE_FIELD_MEANING               VARCHAR2(25 BYTE) DEFAULT ' ' NOT NULL,
  DETAIL_VALUE                   VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  DETAIL_CKI                     VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_OF_PARENT_RELTN
(
  BR_CLIENT_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  ALT_SEL_CATEGORY_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  SOURCE_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  SOURCE_NAME          VARCHAR2(32 BYTE)        DEFAULT ' '                   NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CATALOG_EVENT_SETS
(
  CATALOG_CD      NUMBER                        DEFAULT 0                     NOT NULL,
  SEQUENCE        NUMBER                        DEFAULT 0                     NOT NULL,
  EVENT_SET_NAME  VARCHAR2(100 BYTE)            DEFAULT ' '                   NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CATALOG_TAT
(
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  PRIORITY_CD             NUMBER                DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD     NUMBER                DEFAULT 0                     NOT NULL,
  TAT_CD                  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_STRING_RESULT
(
  EVENT_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM        DATE                 DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  VALID_FROM_DT_TM         DATE                 DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  STRING_RESULT_TEXT       VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  STRING_RESULT_FORMAT_CD  NUMBER               DEFAULT 0                     NOT NULL,
  EQUATION_ID              NUMBER               DEFAULT 0                     NOT NULL,
  LAST_NORM_DT_TM          DATE,
  UNIT_OF_MEASURE_CD       NUMBER               DEFAULT 0                     NOT NULL,
  FEASIBLE_IND             NUMBER,
  NORMAL_HIGH              VARCHAR2(20 BYTE),
  NORMAL_LOW               VARCHAR2(20 BYTE),
  CRITICAL_HIGH            VARCHAR2(20 BYTE),
  CRITICAL_LOW             VARCHAR2(20 BYTE),
  INACCURATE_IND           NUMBER,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  MODIFY_FLAG              NUMBER               DEFAULT 0,
  CALCULATION_EQUATION     VARCHAR2(512 BYTE),
  STRING_LONG_TEXT_ID      NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_ALLERGY_FORMAT
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  SUBSTANCE_LBL           VARCHAR2(32 BYTE),
  REACTION_STAT_LBL       VARCHAR2(32 BYTE),
  SEVERITY_LBL            VARCHAR2(32 BYTE),
  ONSET_DT_LBL            VARCHAR2(32 BYTE),
  CREATED_PRSN_LBL        VARCHAR2(32 BYTE),
  SUBSTANCE_ODR           NUMBER,
  REACTION_STAT_ODR       NUMBER                DEFAULT 0                     NOT NULL,
  SEVERITY_ODR            NUMBER                DEFAULT 0                     NOT NULL,
  ONSET_DT_ODR            NUMBER                DEFAULT 0                     NOT NULL,
  CREATED_PRSN_ODR        NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_LBL             VARCHAR2(32 BYTE),
  UPDT_BY_LBL             VARCHAR2(32 BYTE),
  REACTION_LBL            VARCHAR2(32 BYTE),
  SOURCE_LBL              VARCHAR2(32 BYTE),
  TYPE_LBL                VARCHAR2(32 BYTE),
  CANCEL_LBL              VARCHAR2(32 BYTE),
  CATEGORY_LBL            VARCHAR2(32 BYTE),
  COMMENT_LBL             VARCHAR2(32 BYTE),
  REACTION_ODR            NUMBER                DEFAULT 0                     NOT NULL,
  SOURCE_ODR              NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_ODR                NUMBER                DEFAULT 0                     NOT NULL,
  CANCEL_ODR              NUMBER                DEFAULT 0                     NOT NULL,
  CATEGORY_ODR            NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SEQUENCE_IND     NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_AP_FORMAT
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  GROUP_STYLE             VARCHAR2(255 BYTE),
  RESULT_SEQUENCE         NUMBER,
  SNOMED_CODES_IND        NUMBER,
  SNOMED_DESC_IND         NUMBER,
  SNOMED_CODES_LBL        VARCHAR2(100 BYTE),
  SNOMED_CD_LBL_STYLE     VARCHAR2(255 BYTE),
  TCC_CODES_IND           NUMBER,
  TCC_DESC_IND            NUMBER,
  TCC_CODES_LBL           VARCHAR2(100 BYTE),
  TCC_CD_LBL_STYLE        VARCHAR2(255 BYTE),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  AP_HISTORY_FLAG         NUMBER,
  IMAGE_FLAG              NUMBER,
  AP_CPT_LONG_TEXT_ID     NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_DOC_FORMAT
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SEQ_FLAG         NUMBER,
  PAGE_BRK_IND            NUMBER,
  EXCLUDE_IMG_MDOC_IND    NUMBER                DEFAULT 0,
  INCLUDE_IMG_HEADER_IND  NUMBER                DEFAULT 0,
  INCLUDE_IMG_FOOTER_IND  NUMBER                DEFAULT 0,
  DOC_TYPE_FLAG           NUMBER                DEFAULT 0,
  INCLUDE_ECG_IMG_IND     NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_DYN_ZONE_FORM
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ZONE_SEQ                NUMBER                DEFAULT 0                     NOT NULL,
  PROC_LBL                VARCHAR2(32 BYTE),
  UNITS_LBL               VARCHAR2(32 BYTE),
  REF_RANGE_LBL           VARCHAR2(32 BYTE),
  PROC_COL                NUMBER,
  UNITS_COL               NUMBER,
  REF_RANGE_COL           NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_FLEX_FORMAT
(
  CHART_GROUP_ID           NUMBER               DEFAULT 0                     NOT NULL,
  FLEX_TYPE                NUMBER,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  ABO_RH_LBL               VARCHAR2(32 BYTE),
  ABO_RH_ORDER             NUMBER,
  COLLECTED_DT_TM_LBL      VARCHAR2(32 BYTE),
  COLLECTED_DT_TM_ORDER    NUMBER,
  CROSSMATCH_RESULT_LBL    VARCHAR2(32 BYTE),
  CROSSMATCH_RESULT_ORDER  NUMBER,
  DESCRIPTION_LBL          VARCHAR2(32 BYTE),
  DESCRIPTION_ORDER        NUMBER,
  DISPLAY_LBL              VARCHAR2(32 BYTE),
  DISPLAY_ORDER            NUMBER,
  ORDER_SEQ_FLAG           NUMBER,
  PRODUCT_NBR_LBL          VARCHAR2(32 BYTE),
  PRODUCT_NBR_ORDER        NUMBER,
  VERIFIED_DT_TM_LBL       VARCHAR2(32 BYTE),
  VERIFIED_DT_TM_ORDER     NUMBER,
  RECEIVED_DT_TM_LBL       VARCHAR2(32 BYTE),
  RECEIVED_DT_TM_ORDER     NUMBER,
  PRODUCT_STATUS_LBL       VARCHAR2(32 BYTE),
  PRODUCT_STATUS_ORDER     NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_FORMAT_CODES
(
  CF_CODE_ID              NUMBER                DEFAULT 0                     NOT NULL,
  CHART_FORMAT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CHART_SECTION_ID        NUMBER                DEFAULT 0                     NOT NULL,
  SECTION_TYPE_FLAG       NUMBER,
  AP_HISTORY_FLAG         NUMBER,
  CS_SEQUENCE_NUM         NUMBER,
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CG_SEQUENCE_NUM         NUMBER,
  ZONE                    NUMBER,
  EVENT_SET_SEQ           NUMBER,
  PROCEDURE_TYPE_FLAG     NUMBER,
  EVENT_SET_NAME          VARCHAR2(40 BYTE),
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_CATALOG_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  FLEX_TYPE_FLAG          NUMBER,
  HLA_TYPE_FLAG           NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_GENERIC_FORMAT
(
  CHART_GROUP_ID            NUMBER              DEFAULT 0                     NOT NULL,
  PARAM_LONG_TEXT_ID        NUMBER              DEFAULT 0                     NOT NULL,
  INCLUDE_IMG_HEADER_IND    NUMBER              DEFAULT 0                     NOT NULL,
  INCLUDE_IMG_FOOTER_IND    NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  CHART_DISCERN_REQUEST_ID  NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_GL_FORMAT
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SEQ_FLAG         NUMBER,
  GROUP_STYLE             VARCHAR2(255 BYTE),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_GRP_EVNT_SET
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_SET_NAME          VARCHAR2(40 BYTE)     DEFAULT ' '                   NOT NULL,
  ZONE                    NUMBER,
  EVENT_SET_SEQ           NUMBER,
  DISPLAY_NAME            VARCHAR2(32 BYTE),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  PROCEDURE_TYPE_FLAG     NUMBER,
  ORDER_CATALOG_CD        NUMBER                DEFAULT 0                     NOT NULL,
  SYNONYM_ID              NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_GRP_EVNT_SUPPRESS
(
  CHART_EVNT_SUPPRESS_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_SET_NAME          VARCHAR2(40 BYTE)     DEFAULT ' '                   NOT NULL,
  ORDER_CATALOG_CD        NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_ZN_RESULT_COL
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ZONE_SEQ                NUMBER                DEFAULT 0                     NOT NULL,
  COLUMN_SEQ              NUMBER                DEFAULT 0                     NOT NULL,
  DESCRIPTION             VARCHAR2(32 BYTE),
  COL_INDEX               NUMBER                DEFAULT 0,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_ZN_RESULT_COL_CDS
(
  CHART_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ZONE_SEQ                NUMBER                DEFAULT 0                     NOT NULL,
  COLUMN_SEQ              NUMBER                DEFAULT 0                     NOT NULL,
  NORMALCY_CD             NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CNT_DCP_INTERP_STATE
(
  CNT_DCP_INTERP_STATE_ID    NUMBER             DEFAULT 0                     NOT NULL,
  CNT_DCP_INTERP_ID          NUMBER             DEFAULT 0                     NOT NULL,
  DCP_INTERP_UID             VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL,
  FLAGS                      NUMBER             DEFAULT 0                     NOT NULL,
  INPUT_ASSAY_UID            VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL,
  AR_UID                     VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL,
  NOMENCLATURE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  NUMERIC_HIGH               NUMBER             DEFAULT 0                     NOT NULL,
  NUMERIC_LOW                NUMBER             DEFAULT 0                     NOT NULL,
  RESULTING_STATE            NUMBER             DEFAULT 0                     NOT NULL,
  RESULT_AR_UID              VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL,
  RESULT_NOMENCLATURE_ID     NUMBER             DEFAULT 0                     NOT NULL,
  RESULT_VALUE               NUMBER             DEFAULT 0                     NOT NULL,
  INTERP_STATE               NUMBER             DEFAULT 0                     NOT NULL,
  CNT_ALPHA_RESPONSE_KEY_ID  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CNT_DTA_RRF_R
(
  CNT_DTA_RRF_R_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  RRF_UID           VARCHAR2(100 BYTE)          DEFAULT ' '                   NOT NULL,
  TASK_ASSAY_UID    VARCHAR2(100 BYTE)          DEFAULT ' '                   NOT NULL,
  CNT_RRF_ID        NUMBER                      DEFAULT 0                     NOT NULL,
  CNT_DTA_ID        NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CNT_GRID
(
  CNT_GRID_ID         NUMBER                    DEFAULT 0                     NOT NULL,
  ROW_TASK_ASSAY_UID  VARCHAR2(100 BYTE)        DEFAULT ' '                   NOT NULL,
  COL_TASK_ASSAY_UID  VARCHAR2(100 BYTE)        DEFAULT ' '                   NOT NULL,
  INT_EVENT_CDUID     VARCHAR2(100 BYTE)        DEFAULT ' '                   NOT NULL,
  CNT_DTA_KEY_ID      NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  INPUT_DESCRIPTION   VARCHAR2(200 BYTE),
  INPUT_REF_SEQ       NUMBER,
  INT_EVENT_CD        NUMBER                    DEFAULT 0                     NOT NULL,
  CNT_INPUT_KEY_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  SECTION_UID         VARCHAR2(100 BYTE)        DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CNT_INPUT
(
  CNT_INPUT_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  SECTION_UID          VARCHAR2(100 BYTE)       DEFAULT ' '                   NOT NULL,
  INPUT_DESCRIPTION    VARCHAR2(200 BYTE)       DEFAULT ' '                   NOT NULL,
  INPUT_REF_SEQ        NUMBER                   DEFAULT 0                     NOT NULL,
  PVC_NAME             VARCHAR2(32 BYTE)        DEFAULT ' '                   NOT NULL,
  NAME_VALUE_PREFS_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  DCP_INPUT_REF_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  PVC_VALUE            VARCHAR2(255 BYTE),
  MERGE_NAME           VARCHAR2(100 BYTE)       DEFAULT ' '                   NOT NULL,
  INPUT_SEQUENCE       NUMBER,
  TASK_ASSAY_UID       VARCHAR2(100 BYTE)       DEFAULT ' '                   NOT NULL,
  DTA_ACT_DISP         VARCHAR2(40 BYTE),
  EVENT_CDUID          VARCHAR2(100 BYTE)       DEFAULT ' '                   NOT NULL,
  EVENT_CD             NUMBER                   DEFAULT 0                     NOT NULL,
  CODE_VALUE_DISP      VARCHAR2(40 BYTE),
  COND_SECT_UID        VARCHAR2(100 BYTE)       DEFAULT ' '                   NOT NULL,
  CNT_SECTION_KEY2_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  CNT_INPUT_KEY_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  MERGE_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  MERGE_UID            VARCHAR2(100 BYTE)       DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CODE_SET_DOMAIN
(
  REFERENCE       NUMBER                        DEFAULT 0                     NOT NULL,
  CODE_SET        NUMBER                        DEFAULT 0                     NOT NULL,
  FIELD_SEQUENCE  NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMMON_ALPHA_RESPONSES
(
  ACTIVITY_TYPE_CD        NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  DISPLAY_SEQUENCE        NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_PROCESS_CD       NUMBER                DEFAULT 0,
  DISPLAY_TYPE_FLAG       NUMBER,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONDITIONAL_DTA
(
  CONDITIONAL_DTA_ID       NUMBER               DEFAULT 0                     NOT NULL,
  PREV_CONDITIONAL_DTA_ID  NUMBER               DEFAULT 0                     NOT NULL,
  COND_EXPRESSION_ID       NUMBER               DEFAULT 0                     NOT NULL,
  CONDITIONAL_ASSAY_CD     NUMBER               DEFAULT 0                     NOT NULL,
  POSITION_CD              NUMBER               DEFAULT 0                     NOT NULL,
  LOCATION_CD              NUMBER               DEFAULT 0                     NOT NULL,
  GENDER_CD                NUMBER               DEFAULT 0                     NOT NULL,
  AGE_FROM_UNIT_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AGE_FROM_NBR             NUMBER               DEFAULT 0                     NOT NULL,
  AGE_TO_UNIT_CD           NUMBER               DEFAULT 0                     NOT NULL,
  AGE_TO_NBR               NUMBER               DEFAULT 0                     NOT NULL,
  REQUIRED_IND             NUMBER               DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM      DATE                 DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM      DATE                 DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UNKNOWN_AGE_IND          NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COND_EXPRESSION_COMP
(
  COND_EXPRESSION_COMP_ID       NUMBER          DEFAULT 0                     NOT NULL,
  PREV_COND_EXPRESSION_COMP_ID  NUMBER          DEFAULT 0                     NOT NULL,
  COND_EXPRESSION_ID            NUMBER          DEFAULT 0                     NOT NULL,
  TRIGGER_ASSAY_CD              NUMBER          DEFAULT 0                     NOT NULL,
  COND_COMP_NAME                VARCHAR2(30 BYTE) DEFAULT ' ' NOT NULL,
  RESULT_VALUE                  NUMBER          DEFAULT 0                     NOT NULL,
  OPERATOR_CD                   NUMBER          DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME            VARCHAR2(60 BYTE) DEFAULT ' ' NOT NULL,
  PARENT_ENTITY_ID              NUMBER          DEFAULT 0                     NOT NULL,
  REQUIRED_IND                  NUMBER          DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM           DATE            DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM           DATE            DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COST_ADJ
(
  COST_ADJ_ID           NUMBER                  DEFAULT 0                     NOT NULL,
  COST_ADJ_FLEX_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  LOWER_THRESHOLD       FLOAT(126)              DEFAULT 0                     NOT NULL,
  UPPER_THRESHOLD       FLOAT(126)              DEFAULT 0                     NOT NULL,
  ADJUSTMENT_TYPE_FLAG  NUMBER                  DEFAULT 0                     NOT NULL,
  ADJUSTMENT_AMT        FLOAT(126)              DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CS_COMPONENT
(
  CATALOG_CD                     NUMBER         DEFAULT 0                     NOT NULL,
  COMP_SEQ                       NUMBER         DEFAULT 0                     NOT NULL,
  COMP_TYPE_CD                   NUMBER         DEFAULT 0                     NOT NULL,
  COMP_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID                   NUMBER         DEFAULT 0                     NOT NULL,
  REQUIRED_IND                   NUMBER,
  INCLUDE_EXCLUDE_IND            NUMBER,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  COMP_LABEL                     VARCHAR2(255 BYTE),
  ORDER_SENTENCE_ID              NUMBER         DEFAULT 0                     NOT NULL,
  LINKED_DATE_COMP_SEQ           NUMBER,
  VARIANCE_FORMAT_ID             NUMBER         DEFAULT 0                     NOT NULL,
  PARENT_COMP_SEQ                NUMBER,
  CP_ROW_CAT_CD                  NUMBER         DEFAULT 0                     NOT NULL,
  CP_COL_CAT_CD                  NUMBER         DEFAULT 0                     NOT NULL,
  OUTCOME_PAR_COMP_SEQ           NUMBER,
  COMP_TYPE_MEAN                 VARCHAR2(15 BYTE),
  INDEX_TYPE_CD                  NUMBER         DEFAULT 0,
  ORD_COM_TEMPLATE_LONG_TEXT_ID  NUMBER         DEFAULT 0,
  COMP_MASK                      NUMBER,
  COMP_REFERENCE                 VARCHAR2(255 BYTE),
  LOCKDOWN_DETAILS_FLAG          NUMBER         DEFAULT 0,
  AV_OPTIONAL_INGREDIENT_IND     NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_ORDER_CATEGORY_R
(
  CV_ORDER_CATEGORY_R_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CV_ORDER_CATEGORY_ID    NUMBER                DEFAULT 0                     NOT NULL,
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  DETAIL_TXT              VARCHAR2(255 BYTE),
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_RESPONSE
(
  RESPONSE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  FIELD_TYPE              VARCHAR2(1 BYTE),
  RESPONSE_INTERNAL_NAME  VARCHAR2(255 BYTE),
  A1                      VARCHAR2(100 BYTE),
  A2                      VARCHAR2(50 BYTE),
  A3                      VARCHAR2(50 BYTE),
  A4                      VARCHAR2(50 BYTE),
  A5                      VARCHAR2(50 BYTE),
  XREF_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_REQ                NUMBER,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  FIELD_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_STEP_REF
(
  TASK_ASSAY_CD        NUMBER                   DEFAULT 0                     NOT NULL,
  STEP_LEVEL_FLAG      NUMBER                   DEFAULT 0                     NOT NULL,
  DOC_TYPE_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  DOC_ID_STR           VARCHAR2(255 BYTE),
  ACTIVITY_SUBTYPE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  SCHEDULE_IND         NUMBER,
  PROC_STATUS_CD       NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  STUDY_RELTN_FLAG     NUMBER,
  STEP_TYPE_CD         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_XREF_VALIDATION
(
  XREF_VALIDATION_ID      NUMBER                DEFAULT 0                     NOT NULL,
  XREF_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  RESPONSE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  CHILD_XREF_ID           NUMBER                DEFAULT 0                     NOT NULL,
  RLTNSHIP_FLAG           NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  CHILD_RESPONSE_ID       NUMBER                DEFAULT 0                     NOT NULL,
  REQD_FLAG               NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  OFFSET_NBR              FLOAT(126)            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_REPORT_CONTROL
(
  CATALOG_CD                 NUMBER             DEFAULT 0                     NOT NULL,
  REPORT_TYPE_FLAG           NUMBER,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  ENDOCERV_TASK_ASSAY_CD     NUMBER             DEFAULT 0                     NOT NULL,
  DIAGNOSIS_TASK_ASSAY_CD    NUMBER             DEFAULT 0                     NOT NULL,
  ADEQUACY_TASK_ASSAY_CD     NUMBER             DEFAULT 0                     NOT NULL,
  CLIN_INFO_TASK_ASSAY_CD    NUMBER             DEFAULT 0                     NOT NULL,
  ADEQ_REASON_TASK_ASSAY_CD  NUMBER             DEFAULT 0                     NOT NULL,
  ACTION_TASK_ASSAY_CD       NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_STANDARD_RPT
(
  STANDARD_RPT_ID   NUMBER                      DEFAULT 0                     NOT NULL,
  CATALOG_CD        NUMBER                      DEFAULT 0                     NOT NULL,
  SHORT_DESC        CHAR(5 BYTE),
  DESCRIPTION       VARCHAR2(40 BYTE),
  HOT_KEY_SEQUENCE  NUMBER,
  ACTIVE_IND        NUMBER,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_STANDARD_RPT_R
(
  STANDARD_RPT_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD    NUMBER                       DEFAULT 0                     NOT NULL,
  RESULT_CD        NUMBER                       DEFAULT 0                     NOT NULL,
  RESULT_TEXT      LONG,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID  NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DATA_MAP
(
  SERVICE_RESOURCE_CD     NUMBER                DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  DATA_MAP_TYPE_FLAG      NUMBER,
  RESULT_ENTRY_FORMAT     NUMBER,
  MAX_DIGITS              NUMBER,
  MIN_DIGITS              NUMBER,
  MIN_DECIMAL_PLACES      NUMBER,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  DM2_MIG_SEQ_ID          NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DA_BV_LV_ELEM_RELTN
(
  DA_BV_LV_ELEM_RELTN_ID  NUMBER                DEFAULT 0                     NOT NULL,
  DA_BUS_VIEW_ID          NUMBER                DEFAULT 0                     NOT NULL,
  DA_LOGICAL_VIEW_ID      NUMBER                DEFAULT 0                     NOT NULL,
  DA_ELEMENT_ID           NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DA_CALC_ELEM_RELTN
(
  DA_CALC_ELEM_RELTN_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  PARENT_ELEMENT_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  CHILD_ELEMENT_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DD_REF_EMR_CONTENT
(
  DD_REF_EMR_CONTENT_ID       NUMBER            DEFAULT 0                     NOT NULL,
  DD_REF_FILTER_ID            NUMBER            DEFAULT 0                     NOT NULL,
  DD_REF_FORMAT_ID            NUMBER            DEFAULT 0                     NOT NULL,
  EMR_CONTENT_TYPE_CD         NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  DESCRIPTION_TXT             VARCHAR2(255 BYTE),
  TITLE_TXT                   VARCHAR2(255 BYTE),
  ACTIVE_IND                  NUMBER            DEFAULT 0                     NOT NULL,
  REF_CONTENT_INSTANCE_IDENT  VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  SOURCE_TXT                  VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DEPT_DUP_CHECK
(
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  DUP_CATALOG_CD          NUMBER                DEFAULT 0                     NOT NULL,
  PRIORITY_CD             NUMBER                DEFAULT 0                     NOT NULL,
  MINUTES_AHEAD           NUMBER,
  MINUTES_BEHIND          NUMBER,
  DUP_QUANTITY            NUMBER,
  ACTIVE_IND              NUMBER,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  MNEMONIC_TYPE_CD        NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DIFFERENTIAL_REF
(
  DIF_REF_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  CATALOG_CD             NUMBER                 DEFAULT 0                     NOT NULL,
  OPT                    VARCHAR2(20 BYTE),
  OPT_KEY                VARCHAR2(20 BYTE),
  DEFAULT_COUNT          NUMBER,
  NORMALIZE_IND          NUMBER,
  SUBTRACT_KEY           CHAR(1 BYTE),
  AUTO_CORRECT_IND       NUMBER,
  AUTO_CORRECT_VALUE     NUMBER,
  AUTO_CORRECT_ASSAY_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  COUNT_LABEL            VARCHAR2(30 BYTE),
  MORPH_LABEL            VARCHAR2(30 BYTE),
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  AUTO_CRCT_CMT          VARCHAR2(200 BYTE),
  AUTO_CRCT_CMT_IND      NUMBER,
  AUTO_CORRECT_VERF_IND  NUMBER                 DEFAULT 0                     NOT NULL,
  INSTR_LABEL            VARCHAR2(30 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DIFFERENTIAL_REF_ASSAY
(
  DIF_REF_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD          NUMBER                 DEFAULT 0                     NOT NULL,
  DISPLAY_NAME           VARCHAR2(10 BYTE),
  PROC_TYPE_FLAG         NUMBER,
  COUNT_KEY              CHAR(1 BYTE),
  ZERO_IND               NUMBER,
  NON_TOTAL_IND          NUMBER,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  POSITION_SEQ           NUMBER,
  NON_TOTAL_TRIGGER_IND  NUMBER                 DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DRUG_CLASS_INT_CSTM_ENTITY_R
(
  DRUG_CLASS_INT_CSTM_ENT_R_ID  NUMBER          DEFAULT 0                     NOT NULL,
  DCP_ENTITY_RELTN_ID           NUMBER          DEFAULT 0                     NOT NULL,
  DRUG_CLASS_INT_CUSTOM_ID      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DUP_CHECKING
(
  CATALOG_CD                   NUMBER           DEFAULT 0                     NOT NULL,
  DUP_CHECK_SEQ                NUMBER           DEFAULT 0                     NOT NULL,
  MIN_BEHIND                   NUMBER,
  MIN_BEHIND_ACTION_CD         NUMBER           DEFAULT 0                     NOT NULL,
  MIN_AHEAD                    NUMBER,
  MIN_AHEAD_ACTION_CD          NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  EXACT_HIT_ACTION_CD          NUMBER           DEFAULT 0                     NOT NULL,
  OUTPAT_EXACT_HIT_ACTION_CD   NUMBER           DEFAULT 0,
  OUTPAT_FLEX_IND              NUMBER           DEFAULT 0,
  OUTPAT_MIN_AHEAD             NUMBER           DEFAULT 0,
  OUTPAT_MIN_AHEAD_ACTION_CD   NUMBER           DEFAULT 0,
  OUTPAT_MIN_BEHIND            NUMBER           DEFAULT 0,
  OUTPAT_MIN_BEHIND_ACTION_CD  NUMBER           DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EEM_ABN_DATA
(
  ABN_ATTR_ID             NUMBER                DEFAULT 0                     NOT NULL,
  EEM_FILE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  KEY_FIELD               NUMBER                DEFAULT 0                     NOT NULL,
  ATTR_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  ATTR_TYPE_MEANING       VARCHAR2(12 BYTE),
  SEQ_NBR                 NUMBER                DEFAULT 0                     NOT NULL,
  STRING_VALUE            VARCHAR2(255 BYTE),
  DOUBLE_VALUE            NUMBER                DEFAULT 0,
  DATE_VALUE              DATE,
  UNITS_CD                NUMBER                DEFAULT 0                     NOT NULL,
  UNITS_MEANING           VARCHAR2(12 BYTE),
  PARENT_TABLE            VARCHAR2(30 BYTE),
  PARENT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_MEANING          VARCHAR2(12 BYTE),
  COMP_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  COMP_TYPE_MEANING       VARCHAR2(12 BYTE),
  DATA_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  DATA_TYPE_MEANING       VARCHAR2(12 BYTE),
  VOCABULARY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  VOCABULARY_MEANING      VARCHAR2(12 BYTE),
  BEG_SEQ                 NUMBER                DEFAULT 1                     NOT NULL,
  END_SEQ                 NUMBER                DEFAULT 1                     NOT NULL,
  BEG_IDENTIFIER          VARCHAR2(50 BYTE),
  END_IDENTIFIER          VARCHAR2(50 BYTE),
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EEM_ABN_RULE
(
  ABN_RULE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  EEM_FILE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  PROC_IDENT              VARCHAR2(50 BYTE)     DEFAULT ' '                   NOT NULL,
  DIAG_BEG_IDENT          VARCHAR2(50 BYTE)     DEFAULT ' '                   NOT NULL,
  DIAG_END_IDENT          VARCHAR2(50 BYTE)     DEFAULT ' '                   NOT NULL,
  PROC_VOCABULARY_CD      NUMBER                DEFAULT 0                     NOT NULL,
  DIAG_VOCABULARY_CD      NUMBER                DEFAULT 0                     NOT NULL,
  KEY_FIELD               NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  BEG_SEQ                 NUMBER                DEFAULT 0                     NOT NULL,
  END_SEQ                 NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EEM_BENEFIT_QUAL
(
  BENEFIT_QUAL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BENEFIT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  QUALIFIER_CD            NUMBER                DEFAULT 0                     NOT NULL,
  SEQ_NBR                 NUMBER                DEFAULT 0                     NOT NULL,
  DATA_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  DOUBLE_VALUE            NUMBER                DEFAULT 0                     NOT NULL,
  STRING_VALUE            VARCHAR2(255 BYTE),
  DATE_VALUE              DATE,
  PARENT_ENTITY_NAME      VARCHAR2(30 BYTE),
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  FROM_UNITS              NUMBER                DEFAULT 0                     NOT NULL,
  FROM_UNITS_CD           NUMBER                DEFAULT 0                     NOT NULL,
  TO_UNITS                NUMBER                DEFAULT 0                     NOT NULL,
  TO_UNITS_CD             NUMBER                DEFAULT 0                     NOT NULL,
  INC_EXC_CD              NUMBER                DEFAULT 0                     NOT NULL,
  INC_EXC_MEANING         VARCHAR2(12 BYTE),
  VOCABULARY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  BEG_IDENT               VARCHAR2(50 BYTE),
  BEG_NOMEN_ID            NUMBER                DEFAULT 0                     NOT NULL,
  END_IDENT               VARCHAR2(50 BYTE),
  END_NOMEN_ID            NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EEM_ENTITY_NTWK_RELTN
(
  ENTITY_NTWK_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  NETWORK_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE)     DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EEM_ENTITY_PROV_TAX_RELTN
(
  EEM_ENTITY_PROV_TAX_RELTN_ID  NUMBER          DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME            VARCHAR2(32 BYTE),
  PARENT_ENTITY_ID              NUMBER          DEFAULT 0                     NOT NULL,
  EEM_PROV_TAX_RELTN_ID         NUMBER          DEFAULT 0                     NOT NULL,
  SEQ_NBR                       NUMBER          DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM           DATE,
  END_EFFECTIVE_DT_TM           DATE,
  LONG_TEXT_ID                  NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_IND                    NUMBER,
  ACTIVE_STATUS_CD              NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM           DATE,
  ACTIVE_STATUS_PRSNL_ID        NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EEM_SERVICE_LIST
(
  SERVICE_LIST_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SERVICE_TYPE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SEQ_NBR                 NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_INC_EXC_CD         NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_INC_EXC_MEANING    VARCHAR2(12 BYTE),
  TYPE_VOCAB_CD           NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_BEG_NOMEN_ID       NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_BEG_IDENT          VARCHAR2(50 BYTE),
  TYPE_END_NOMEN_ID       NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_END_IDENT          VARCHAR2(50 BYTE),
  CAUSE_INC_EXC_CD        NUMBER                DEFAULT 0                     NOT NULL,
  CAUSE_INC_EXC_MEANING   VARCHAR2(12 BYTE),
  CAUSE_VOCAB_CD          NUMBER                DEFAULT 0                     NOT NULL,
  CAUSE_BEG_NOMEN_ID      NUMBER                DEFAULT 0                     NOT NULL,
  CAUSE_BEG_IDENT         VARCHAR2(50 BYTE),
  CAUSE_END_NOMEN_ID      NUMBER                DEFAULT 0                     NOT NULL,
  CAUSE_END_IDENT         VARCHAR2(50 BYTE),
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE EXAM_REASON
(
  CATALOG_CD      NUMBER                        DEFAULT 0                     NOT NULL,
  EXAM_REASON_ID  NUMBER                        DEFAULT 0                     NOT NULL,
  SEQUENCE        NUMBER                        DEFAULT 0                     NOT NULL,
  ICD9_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE FILM_USAGE
(
  CATALOG_CD    NUMBER                          DEFAULT 0                     NOT NULL,
  FILM_TYPE_CD  NUMBER                          DEFAULT 0                     NOT NULL,
  FILM_SIZE_CD  NUMBER                          DEFAULT 0                     NOT NULL,
  STANDARD_QTY  NUMBER,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE FORM_ASSOCIATION
(
  FORM_ASSOCIATION_ID    NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR           NUMBER                 DEFAULT 0                     NOT NULL,
  REFERENCE_TASK_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  CATALOG_CD             NUMBER                 DEFAULT 0                     NOT NULL,
  INPUT_FORM_CD          NUMBER                 DEFAULT 0                     NOT NULL,
  ASSOCIATION_TYPE_FLAG  NUMBER,
  ORDER_TYPE_FLAG        NUMBER,
  LOCATION_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE GROUP_DEFINITION
(
  GROUP_CD                   NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_VERSION_NBR          NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_DEF_SEQ              NUMBER             DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD              NUMBER             DEFAULT 0                     NOT NULL,
  ONLINE_ITEM_VERSION_NBR    NUMBER             DEFAULT 0                     NOT NULL,
  REQUIRED_FLAG              NUMBER,
  FIELD_PROMPT               VARCHAR2(100 BYTE),
  REPEAT_IND                 NUMBER,
  COLUMN_HEADING             VARCHAR2(100 BYTE),
  GROUP_CMPNT_LEFT           NUMBER,
  GROUP_CMPNT_TOP            NUMBER,
  CREATE_DT_TM               DATE,
  CREATE_ID                  NUMBER             DEFAULT 0,
  CREATE_TASK                NUMBER,
  CREATE_APPLCTX             NUMBER,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  ONLINE_ITEM_DEFINITION_ID  NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_REFERENCE_ID         NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HIM_HAC_CRITERIA
(
  HIM_HAC_CRITERIA_ID          NUMBER           DEFAULT 0                     NOT NULL,
  HAC_NOMENCLATURE_ID          NUMBER           DEFAULT 0                     NOT NULL,
  HAC_PRIMARY_ONLY_IND         NUMBER           DEFAULT 0                     NOT NULL,
  COMPARE_PX_PRIMARY_ONLY_IND  NUMBER           DEFAULT 0                     NOT NULL,
  COMPARE_PX_NOMEN_ID          NUMBER           DEFAULT 0                     NOT NULL,
  COMPARE_DX_PRIMARY_ONLY_IND  NUMBER           DEFAULT 0                     NOT NULL,
  COMPARE_DX_NOMEN_ID          NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE             DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM          DATE             DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HLA_AB_SCREEN_HISTORY_MAP
(
  CATALOG_CD          NUMBER                    DEFAULT 0                     NOT NULL,
  SEQ_NUMBER          NUMBER                    DEFAULT 0                     NOT NULL,
  T_CELL_PRA_DTA_CD   NUMBER                    DEFAULT 0                     NOT NULL,
  B_CELL_PRA_DTA_CD   NUMBER                    DEFAULT 0                     NOT NULL,
  METHODOLOGY_DTA_CD  NUMBER                    DEFAULT 0                     NOT NULL,
  DILUTION_DTA_CD     NUMBER                    DEFAULT 0                     NOT NULL,
  METHODOLOGY_NOM_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  DILUTION_NOM_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  REACTION_DTA_CD     NUMBER                    DEFAULT 0                     NOT NULL,
  OD_DTA_CD           NUMBER                    DEFAULT 0                     NOT NULL,
  OD_RATIO_DTA_CD     NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HLA_AB_SPEC_MAP
(
  CATALOG_CD       NUMBER                       DEFAULT 0                     NOT NULL,
  AB_DTA_CD        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  AB_HIST_SEQ_NBR  NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HLA_NOMEN_CODE_R
(
  NOMENCLATURE_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  RELATED_CD       NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HLA_XM_HISTORY_MAP
(
  CATALOG_CD               NUMBER               DEFAULT 0                     NOT NULL,
  XM_TYPE_DTA_CD           NUMBER               DEFAULT 0                     NOT NULL,
  XM_TYPE_NOM_ID           NUMBER               DEFAULT 0                     NOT NULL,
  T_CELL_RESULT_DTA_CD     NUMBER               DEFAULT 0                     NOT NULL,
  B_CELL_RESULT_DTA_CD     NUMBER               DEFAULT 0                     NOT NULL,
  TB_CELL_RESULT_DTA_CD    NUMBER               DEFAULT 0                     NOT NULL,
  MONO_CELL_RESULT_DTA_CD  NUMBER               DEFAULT 0                     NOT NULL,
  INTERPRETATION_DTA_CD    NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HM_EXPECT_SAT
(
  EXPECT_SAT_ID           NUMBER                DEFAULT 0                     NOT NULL,
  EXPECT_SAT_NAME         VARCHAR2(250 BYTE),
  EXPECT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_TYPE_FLAG        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_NBR              FLOAT(126)            DEFAULT 0                     NOT NULL,
  SEQ_NBR                 NUMBER                DEFAULT 0                     NOT NULL,
  ENTRY_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  ENTRY_NBR               FLOAT(126)            DEFAULT 0                     NOT NULL,
  LAST_ACTION_SEQ         NUMBER                DEFAULT 0                     NOT NULL,
  SATISFIER_MEANING       VARCHAR2(250 BYTE),
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  PENDING_DURATION        NUMBER                DEFAULT 0                     NOT NULL,
  SATISFIED_DURATION      NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_VALUE            VARCHAR2(255 BYTE),
  ENTRY_VALUE             VARCHAR2(255 BYTE),
  NOMENCLATURE_ID         NUMBER                DEFAULT 0,
  ENTRY_ID                NUMBER                DEFAULT 0,
  PARENT_ENTITY_NAME      VARCHAR2(30 BYTE)     DEFAULT ' ',
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0,
  ENTRY_NAME              VARCHAR2(30 BYTE)     DEFAULT ' '
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE HM_EXPECT_SAT_HIST
(
  EXPECT_SAT_ID           NUMBER                DEFAULT 0                     NOT NULL,
  ACTION_SEQ              NUMBER                DEFAULT 0                     NOT NULL,
  ACTION_TYPE_FLAG        NUMBER                DEFAULT 1                     NOT NULL,
  ACTION_DT_TM            DATE                  DEFAULT SYSDATE               NOT NULL,
  EXPECT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  EXPECT_SAT_NAME         VARCHAR2(250 BYTE),
  PARENT_TYPE_FLAG        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_NBR              FLOAT(126)            DEFAULT 0                     NOT NULL,
  SEQ_NBR                 NUMBER                DEFAULT 0                     NOT NULL,
  ENTRY_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  ENTRY_NBR               FLOAT(126)            DEFAULT 0                     NOT NULL,
  SATISFIER_MEANING       VARCHAR2(250 BYTE),
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  PENDING_DURATION        NUMBER                DEFAULT 0                     NOT NULL,
  SATISFIED_DURATION      NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  SAT_STATUS_IND          NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_VALUE            VARCHAR2(255 BYTE),
  ENTRY_VALUE             VARCHAR2(255 BYTE),
  NOMENCLATURE_ID         NUMBER                DEFAULT 0,
  EXPECT_SAT_HIST_ID      NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0,
  ENTRY_NAME              VARCHAR2(30 BYTE)     DEFAULT ' ',
  ENTRY_ID                NUMBER                DEFAULT 0,
  PARENT_ENTITY_NAME      VARCHAR2(30 BYTE)     DEFAULT ' '
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE INPUT_FORM_DEFINITION
(
  INPUT_FORM_CD              NUMBER             DEFAULT 0                     NOT NULL,
  INPUT_FORM_VERSION_NBR     NUMBER             DEFAULT 0                     NOT NULL,
  INPUT_FORM_DEF_SEQ         NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_CD                   NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_VERSION_NBR          NUMBER,
  TASK_ASSAY_CD              NUMBER             DEFAULT 0                     NOT NULL,
  ONLINE_ITEM_VERSION_NBR    NUMBER,
  COLUMN_HEADING             VARCHAR2(100 BYTE),
  REQUIRED_FLAG              NUMBER,
  FIELD_PROMPT               VARCHAR2(100 BYTE),
  CMPNT_REPEAT_IND           NUMBER,
  CMPNT_LEFT                 NUMBER,
  CMPNT_TOP                  NUMBER,
  CMPNT_HEIGHT               NUMBER,
  CMPNT_WIDTH                NUMBER,
  CREATE_DT_TM               DATE,
  CREATE_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  CREATE_TASK                NUMBER,
  CREATE_APPLCTX             NUMBER,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  PROMPT_LEFT                NUMBER,
  PROMPT_TOP                 NUMBER,
  ONLINE_ITEM_DEFINITION_ID  NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_REFERENCE_ID         NUMBER             DEFAULT 0                     NOT NULL,
  INPUT_FORM_REFERENCE_ID    NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE LH_ABS_ED_METRICS
(
  LH_ABS_ED_METRICS_ID       NUMBER             DEFAULT 0                     NOT NULL,
  HEALTH_SYSTEM_ID           NUMBER             DEFAULT 0                     NOT NULL,
  HEALTH_SYSTEM_SOURCE_ID    NUMBER             DEFAULT 0                     NOT NULL,
  ENCNTR_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  ORG_MRN_TXT                VARCHAR2(50 BYTE),
  COMM_MRN_TXT               VARCHAR2(50 BYTE),
  FINANCIAL_NBR_TXT          VARCHAR2(50 BYTE),
  D_PERSON_ID                NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_FACILITY_ID        NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_BUILDING_ID        NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_NURSE_UNIT_ID      NUMBER             DEFAULT 0                     NOT NULL,
  D_DISCHARGE_FACILITY_ID    NUMBER             DEFAULT 0                     NOT NULL,
  D_DISCHARGE_BUILDING_ID    NUMBER             DEFAULT 0                     NOT NULL,
  D_DISCHARGE_NURSE_UNIT_ID  NUMBER             DEFAULT 0                     NOT NULL,
  D_ENCNTR_TYPE_ID           NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_SRC_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_TYPE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  D_MED_SERVICE_ID           NUMBER             DEFAULT 0                     NOT NULL,
  D_ATTEND_PRSNL_ID          NUMBER             DEFAULT 0                     NOT NULL,
  ADMIT_DT_TM                DATE,
  ADMIT_UTC_DT_TM            DATE,
  DISCHARGE_DT_TM            DATE,
  DISCHARGE_UTC_DT_TM        DATE,
  PARTITION_DT_TM            DATE,
  FIRST_PROCESS_DT_TM        DATE,
  LAST_PROCESS_DT_TM         DATE,
  UPDT_DT_TM                 DATE,
  UPDT_CNT                   NUMBER,
  UPDT_TASK                  VARCHAR2(50 BYTE),
  UPDT_SOURCE                VARCHAR2(50 BYTE),
  EXTRACT_DT_TM              DATE,
  ACTIVE_IND                 NUMBER,
  D_METRIC_1_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_2_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_3_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_4_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_5_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_6_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_7_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_8_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_9_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_10_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_11_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_12_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_13_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_14_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_15_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_16_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_17_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_18_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_19_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_20_ID             NUMBER             DEFAULT 0                     NOT NULL,
  PRIN_DIAGNOSIS             VARCHAR2(10 BYTE),
  PRIN_PROCEDURE             VARCHAR2(10 BYTE),
  PRIN_PROCEDURE_DATE_TXT    VARCHAR2(10 BYTE),
  PRIN_PROCEDURE_DT_TM       DATE,
  PRIN_PROCEDURE_UTC_DT_TM   DATE,
  OTH_DIAGNOSIS_LIST         VARCHAR2(250 BYTE),
  OTH_PROCEDURE_LIST         VARCHAR2(250 BYTE),
  OTH_PROCEDURE_DATES_LIST   VARCHAR2(275 BYTE),
  PAYMENT_SOURCE_FLAG        NUMBER,
  ED_PATIENT_IND             NUMBER,
  ED_OBSERVATION_IND         NUMBER,
  ED_DEPART_DATE_TXT         VARCHAR2(10 BYTE),
  ED_DEPART_TIME_TXT         VARCHAR2(5 BYTE),
  ED_DEPART_DT_TM            DATE,
  ED_DEPART_UTC_DT_TM        DATE,
  SAMPLE_IND                 NUMBER,
  PHYSICIAN_1_TXT            VARCHAR2(50 BYTE),
  PHYSICIAN_2_TXT            VARCHAR2(50 BYTE),
  ARRIVAL_DATE_TXT           VARCHAR2(10 BYTE),
  ARRIVAL_TIME_TXT           VARCHAR2(5 BYTE),
  ARRIVAL_DT_TM              DATE,
  ARRIVAL_UTC_DT_TM          DATE,
  DECISION_ADMIT_DATE_TXT    VARCHAR2(10 BYTE),
  DECISION_ADMIT_TIME_TXT    VARCHAR2(5 BYTE),
  DECISION_ADMIT_DT_TM       DATE,
  DECISION_ADMIT_UTC_DT_TM   DATE,
  MENTAL_DISORDER_IND        NUMBER,
  LOGICAL_DOMAIN_ID          NUMBER             DEFAULT 0                     NOT NULL,
  REJECT_1_IND               NUMBER,
  REJECT_2_IND               NUMBER,
  EXCLUDE_1_IND              NUMBER,
  EXCLUDE_2_IND              NUMBER,
  ED1A_IND                   NUMBER,
  ED1B_IND                   NUMBER,
  ED1C_IND                   NUMBER,
  ED1D_IND                   NUMBER,
  ED2A_IND                   NUMBER,
  ED2B_IND                   NUMBER,
  ED2C_IND                   NUMBER,
  ED1_MEASUREMENT_VALUE      NUMBER,
  ED2_MEASUREMENT_VALUE      NUMBER,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE LH_ABS_STROKE_METRICS
(
  LH_ABS_STROKE_METRICS_ID   NUMBER             DEFAULT 0                     NOT NULL,
  HEALTH_SYSTEM_ID           NUMBER             DEFAULT 0                     NOT NULL,
  HEALTH_SYSTEM_SOURCE_ID    NUMBER             DEFAULT 0                     NOT NULL,
  ENCNTR_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  ORG_MRN_TXT                VARCHAR2(50 BYTE),
  COMM_MRN_TXT               VARCHAR2(50 BYTE),
  FINANCIAL_NBR_TXT          VARCHAR2(50 BYTE),
  D_PERSON_ID                NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_FACILITY_ID        NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_BUILDING_ID        NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_NURSE_UNIT_ID      NUMBER             DEFAULT 0                     NOT NULL,
  D_DISCHARGE_FACILITY_ID    NUMBER             DEFAULT 0                     NOT NULL,
  D_DISCHARGE_BUILDING_ID    NUMBER             DEFAULT 0                     NOT NULL,
  D_DISCHARGE_NURSE_UNIT_ID  NUMBER             DEFAULT 0                     NOT NULL,
  D_ENCNTR_TYPE_ID           NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_SRC_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_ADMIT_TYPE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  D_MED_SERVICE_ID           NUMBER             DEFAULT 0                     NOT NULL,
  D_ATTEND_PRSNL_ID          NUMBER             DEFAULT 0                     NOT NULL,
  ADMIT_DT_TM                DATE,
  ADMIT_UTC_DT_TM            DATE,
  DISCHARGE_DT_TM            DATE,
  DISCHARGE_UTC_DT_TM        DATE,
  PARTITION_DT_TM            DATE,
  FIRST_PROCESS_DT_TM        DATE,
  LAST_PROCESS_DT_TM         DATE,
  UPDT_DT_TM                 DATE,
  UPDT_CNT                   NUMBER,
  UPDT_TASK                  VARCHAR2(50 BYTE),
  UPDT_SOURCE                VARCHAR2(50 BYTE),
  EXTRACT_DT_TM              DATE,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_1_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_2_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_3_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_4_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_5_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_6_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_7_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_8_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_9_ID              NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_10_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_11_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_12_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_13_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_14_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_15_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_16_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_17_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_18_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_19_ID             NUMBER             DEFAULT 0                     NOT NULL,
  D_METRIC_20_ID             NUMBER             DEFAULT 0                     NOT NULL,
  PRIN_DIAGNOSIS             VARCHAR2(10 BYTE),
  PRIN_PROCEDURE             VARCHAR2(10 BYTE),
  PRIN_PROCEDURE_DATE_TXT    VARCHAR2(10 BYTE),
  PRIN_PROCEDURE_DT_TM       DATE,
  PRIN_PROCEDURE_UTC_DT_TM   DATE,
  OTH_DIAGNOSIS_LIST         VARCHAR2(250 BYTE),
  OTH_PROCEDURE_LIST         VARCHAR2(250 BYTE),
  OTH_PROCEDURE_DATES_LIST   VARCHAR2(275 BYTE),
  PAYMENT_SOURCE_FLAG        NUMBER,
  CLINICAL_TRIAL_IND         NUMBER,
  CMO_FLAG                   NUMBER,
  ARRIVAL_DATE_TXT           VARCHAR2(10 BYTE),
  ARRIVAL_TIME_TXT           VARCHAR2(5 BYTE),
  ARRIVAL_DT_TM              DATE,
  ARRIVAL_UTC_DT_TM          DATE,
  DISC_DISP_FLAG             NUMBER,
  ELECTIVE_CAROTID_IND       NUMBER,
  SAMPLE_IND                 NUMBER,
  PHYSICIAN_1_TXT            VARCHAR2(50 BYTE),
  PHYSICIAN_2_TXT            VARCHAR2(50 BYTE),
  VTE_PROPHYLAXIS_MASK       NUMBER,
  VTE_PROPHYLAXIS_DATE_TXT   VARCHAR2(10 BYTE),
  VTE_PROPHYLAXIS_DT_TM      DATE,
  VTE_PROPHYLAXIS_UTC_DT_TM  DATE,
  NO_VTE_PROPH_REASON_IND    NUMBER,
  ED_PATIENT_IND             NUMBER,
  LAST_KNOWN_WELL_IND        NUMBER,
  LAST_KNOWN_WELL_DATE_TXT   VARCHAR2(10 BYTE),
  LAST_KNOWN_WELL_TIME_TXT   VARCHAR2(5 BYTE),
  LAST_KNOWN_WELL_DT_TM      DATE,
  LAST_KNOWN_WELL_UTC_DT_TM  DATE,
  IV_THROM_IND               NUMBER,
  IV_THROM_DATE_TXT          VARCHAR2(10 BYTE),
  IV_THROM_TIME_TXT          VARCHAR2(5 BYTE),
  IV_THROM_DT_TM             DATE,
  IV_THROM_UTC_DT_TM         DATE,
  NO_IV_THROM_REASON_IND     NUMBER,
  TPA_ADMIN_IND              NUMBER,
  TPA_EOD2_IND               NUMBER,
  NO_TPA_EOD2_REASON_IND     NUMBER,
  ANTICOAG_DISC_IND          NUMBER,
  ATRIAL_FIB_FLUTTER_IND     NUMBER,
  NO_ANTICOAG_REASON_IND     NUMBER,
  ANTITHR_DISC_IND           NUMBER,
  NO_ANTITHR_REASON_IND      NUMBER,
  LIPID_LOWER_PRE_ARR_IND    NUMBER,
  STATIN_DISC_IND            NUMBER,
  NO_STATIN_REASON_IND       NUMBER,
  LDL_C_MEASURED_IND         NUMBER,
  LDL_C_GTE_100_IND          NUMBER,
  EDU_SIGNS_SYM_IND          NUMBER,
  EDU_RISK_IND               NUMBER,
  EDU_EMS_IND                NUMBER,
  EDU_FOLLOWUP_IND           NUMBER,
  EDU_DISCH_MEDS_IND         NUMBER,
  ASSESS_REHAB_IND           NUMBER,
  REJECT_1_IND               NUMBER,
  REJECT_2_IND               NUMBER,
  REJECT_3_IND               NUMBER,
  REJECT_4_IND               NUMBER,
  REJECT_5_IND               NUMBER,
  REJECT_6_IND               NUMBER,
  REJECT_8_IND               NUMBER,
  REJECT_10_IND              NUMBER,
  EXCLUDE_1_IND              NUMBER,
  EXCLUDE_2_IND              NUMBER,
  EXCLUDE_3_IND              NUMBER,
  EXCLUDE_4_IND              NUMBER,
  EXCLUDE_5_IND              NUMBER,
  EXCLUDE_6_IND              NUMBER,
  EXCLUDE_8_IND              NUMBER,
  EXCLUDE_10_IND             NUMBER,
  NUMERATOR_1_IND            NUMBER,
  NUMERATOR_2_IND            NUMBER,
  NUMERATOR_3_IND            NUMBER,
  NUMERATOR_4_IND            NUMBER,
  NUMERATOR_5_IND            NUMBER,
  NUMERATOR_6_IND            NUMBER,
  NUMERATOR_8_IND            NUMBER,
  NUMERATOR_10_IND           NUMBER,
  LOGICAL_DOMAIN_ID          NUMBER             DEFAULT 0                     NOT NULL,
  NUMERATOR_1_MU_IND         NUMBER,
  NUMERATOR_2_MU_IND         NUMBER,
  NUMERATOR_3_MU_IND         NUMBER,
  NUMERATOR_4_MU_IND         NUMBER,
  NUMERATOR_5_MU_IND         NUMBER,
  NUMERATOR_6_MU_IND         NUMBER,
  NUMERATOR_8_MU_IND         NUMBER,
  NUMERATOR_10_MU_IND        NUMBER,
  EXCLUDE_1_MU_IND           NUMBER,
  EXCLUDE_2_MU_IND           NUMBER,
  EXCLUDE_3_MU_IND           NUMBER,
  EXCLUDE_4_MU_IND           NUMBER,
  EXCLUDE_5_MU_IND           NUMBER,
  EXCLUDE_6_MU_IND           NUMBER,
  EXCLUDE_8_MU_IND           NUMBER,
  EXCLUDE_10_MU_IND          NUMBER,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE LH_ABS_VTE_METRICS
(
  LH_ABS_VTE_METRICS_ID          NUMBER         DEFAULT 0                     NOT NULL,
  HEALTH_SYSTEM_ID               NUMBER         DEFAULT 0                     NOT NULL,
  HEALTH_SYSTEM_SOURCE_ID        NUMBER         DEFAULT 0                     NOT NULL,
  ENCNTR_ID                      NUMBER         DEFAULT 0                     NOT NULL,
  ORG_MRN_TXT                    VARCHAR2(50 BYTE),
  COMM_MRN_TXT                   VARCHAR2(50 BYTE),
  FINANCIAL_NBR_TXT              VARCHAR2(50 BYTE),
  D_PERSON_ID                    NUMBER         DEFAULT 0                     NOT NULL,
  D_ADMIT_FACILITY_ID            NUMBER         DEFAULT 0                     NOT NULL,
  D_ADMIT_BUILDING_ID            NUMBER         DEFAULT 0                     NOT NULL,
  D_ADMIT_NURSE_UNIT_ID          NUMBER         DEFAULT 0                     NOT NULL,
  D_DISCHARGE_FACILITY_ID        NUMBER         DEFAULT 0                     NOT NULL,
  D_DISCHARGE_BUILDING_ID        NUMBER         DEFAULT 0                     NOT NULL,
  D_DISCHARGE_NURSE_UNIT_ID      NUMBER         DEFAULT 0                     NOT NULL,
  D_ENCNTR_TYPE_ID               NUMBER         DEFAULT 0                     NOT NULL,
  D_ADMIT_SRC_ID                 NUMBER         DEFAULT 0                     NOT NULL,
  D_ADMIT_TYPE_ID                NUMBER         DEFAULT 0                     NOT NULL,
  D_MED_SERVICE_ID               NUMBER         DEFAULT 0                     NOT NULL,
  D_ATTEND_PRSNL_ID              NUMBER         DEFAULT 0                     NOT NULL,
  ADMIT_DT_TM                    DATE,
  ADMIT_UTC_DT_TM                DATE,
  DISCHARGE_DT_TM                DATE,
  DISCHARGE_UTC_DT_TM            DATE,
  PARTITION_DT_TM                DATE,
  FIRST_PROCESS_DT_TM            DATE,
  LAST_PROCESS_DT_TM             DATE,
  UPDT_DT_TM                     DATE,
  UPDT_CNT                       NUMBER,
  UPDT_TASK                      VARCHAR2(50 BYTE),
  UPDT_SOURCE                    VARCHAR2(50 BYTE),
  EXTRACT_DT_TM                  DATE,
  ACTIVE_IND                     NUMBER,
  D_METRIC_1_ID                  NUMBER,
  D_METRIC_2_ID                  NUMBER,
  D_METRIC_3_ID                  NUMBER,
  D_METRIC_4_ID                  NUMBER,
  D_METRIC_5_ID                  NUMBER,
  D_METRIC_6_ID                  NUMBER,
  D_METRIC_7_ID                  NUMBER,
  D_METRIC_8_ID                  NUMBER,
  D_METRIC_9_ID                  NUMBER,
  D_METRIC_10_ID                 NUMBER,
  D_METRIC_11_ID                 NUMBER,
  D_METRIC_12_ID                 NUMBER,
  D_METRIC_13_ID                 NUMBER,
  D_METRIC_14_ID                 NUMBER,
  D_METRIC_15_ID                 NUMBER,
  D_METRIC_16_ID                 NUMBER,
  D_METRIC_17_ID                 NUMBER,
  D_METRIC_18_ID                 NUMBER,
  D_METRIC_19_ID                 NUMBER,
  D_METRIC_20_ID                 NUMBER,
  PRIN_DIAGNOSIS                 VARCHAR2(10 BYTE),
  PRIN_PROCEDURE                 VARCHAR2(10 BYTE),
  PRIN_PROCEDURE_DATE_TXT        VARCHAR2(10 BYTE),
  PRIN_PROCEDURE_DT_TM           DATE,
  PRIN_PROCEDURE_UTC_DT_TM       DATE,
  OTH_DIAGNOSIS_LIST             VARCHAR2(250 BYTE),
  OTH_PROCEDURE_LIST             VARCHAR2(250 BYTE),
  OTH_PROCEDURE_DATES_LIST       VARCHAR2(275 BYTE),
  PAYMENT_SOURCE_FLAG            NUMBER,
  CLINICAL_TRIAL_IND             NUMBER,
  CMO_FLAG                       NUMBER,
  DISC_DISP_FLAG                 NUMBER,
  SAMPLE_IND                     NUMBER,
  ICU_PATIENT_IND                NUMBER,
  INIT_ICU_ADMIT_DATE_TXT        VARCHAR2(10 BYTE),
  INIT_ICU_ADMIT_DT_TM           DATE,
  INIT_ICU_ADMIT_UTC_DT_TM       DATE,
  INIT_ICU_DISC_DATE_TXT         VARCHAR2(10 BYTE),
  INIT_ICU_DISC_DT_TM            DATE,
  INIT_ICU_DISC_UTC_DT_TM        DATE,
  ANES_TYPE_FLAG                 NUMBER,
  VTE_DIAGNOSTIC_IND             NUMBER,
  VTE_CONFIRMED_IND              NUMBER,
  PHYSICIAN_1_TXT                VARCHAR2(50 BYTE),
  PHYSICIAN_2_TXT                VARCHAR2(50 BYTE),
  VTE_PROPHYLAXIS_MASK           NUMBER,
  VTE_PROPHYLAXIS_DATE_TXT       VARCHAR2(10 BYTE),
  VTE_PROPHYLAXIS_DT_TM          DATE,
  VTE_PROPHYLAXIS_UTC_DT_TM      DATE,
  NO_VTE_PROPH_REASON_IND        NUMBER,
  SURGICAL_IND                   NUMBER,
  SURG_END_DATE_TXT              VARCHAR2(10 BYTE),
  SURG_END_DT_TM                 DATE,
  SURG_END_UTC_DT_TM             DATE,
  ICU_SURGICAL_IND               NUMBER,
  ICU_SURG_END_DATE_TXT          VARCHAR2(10 BYTE),
  ICU_SURG_END_DT_TM             DATE,
  ICU_SURG_END_UTC_DT_TM         DATE,
  ANES_START_DATE_TXT            VARCHAR2(10 BYTE),
  ANES_START_DT_TM               DATE,
  ANES_START_UTC_DT_TM           DATE,
  ICU_VTE_PROPHYLAXIS_MASK       NUMBER,
  ICU_VTE_PROPHYLAXIS_DATE_TXT   VARCHAR2(10 BYTE),
  ICU_VTE_PROPHYLAXIS_DT_TM      DATE,
  ICU_VTE_PROPHYLAXIS_UTC_DT_TM  DATE,
  NO_ICU_VTE_PROPH_REASON_IND    NUMBER,
  ANTICOAG_ADMIN_IND             NUMBER,
  ANTICOAG_END_DATE_TXT          VARCHAR2(10 BYTE),
  ANTICOAG_END_DT_TM             DATE,
  ANTICOAG_END_UTC_DT_TM         DATE,
  ANTICOAG_DISC_IND              NUMBER,
  WARFARIN_ADMIN_IND             NUMBER,
  INR_RESULT_IND                 NUMBER,
  OVERLAP_START_DATE_TXT         VARCHAR2(10 BYTE),
  OVERLAP_START_DT_TM            DATE,
  OVERLAP_START_UTC_DT_TM        DATE,
  DISC_OVERLAP_REASON_IND        NUMBER,
  UFH_PLATELET_MONITOR_IND       NUMBER,
  UFH_ADMIN_IND                  NUMBER,
  VTE_POA_IND                    NUMBER,
  VTE_PROPH_STATUS_FLAG          NUMBER,
  WARFARIN_DISC_IND              NUMBER,
  DISCH_INSTR_COMPLIANCE_IND     NUMBER,
  DISCH_INSTR_DIETARY_IND        NUMBER,
  DISCH_INSTR_FOLLOWUP_IND       NUMBER,
  DISCH_INSTR_ADVERSE_REACT_IND  NUMBER,
  REJECT_1_IND                   NUMBER,
  REJECT_2_IND                   NUMBER,
  REJECT_3_IND                   NUMBER,
  REJECT_4_IND                   NUMBER,
  REJECT_5_IND                   NUMBER,
  REJECT_6_IND                   NUMBER,
  EXCLUDE_1_IND                  NUMBER,
  EXCLUDE_2_IND                  NUMBER,
  EXCLUDE_3_IND                  NUMBER,
  EXCLUDE_4_IND                  NUMBER,
  EXCLUDE_5_IND                  NUMBER,
  EXCLUDE_6_IND                  NUMBER,
  NUMERATOR_1_IND                NUMBER,
  NUMERATOR_2_IND                NUMBER,
  NUMERATOR_3_IND                NUMBER,
  NUMERATOR_4_IND                NUMBER,
  NUMERATOR_5_IND                NUMBER,
  NUMERATOR_6_IND                NUMBER,
  LOGICAL_DOMAIN_ID              NUMBER,
  NUMERATOR_1_MU_IND             NUMBER,
  NUMERATOR_2_MU_IND             NUMBER,
  NUMERATOR_3_MU_IND             NUMBER,
  NUMERATOR_4_MU_IND             NUMBER,
  NUMERATOR_5_MU_IND             NUMBER,
  NUMERATOR_6_MU_IND             NUMBER,
  EXCLUDE_1_MU_IND               NUMBER,
  EXCLUDE_2_MU_IND               NUMBER,
  EXCLUDE_3_MU_IND               NUMBER,
  EXCLUDE_4_MU_IND               NUMBER,
  EXCLUDE_5_MU_IND               NUMBER,
  EXCLUDE_6_MU_IND               NUMBER,
  OVERLAY_THERAPY_FLAG           NUMBER,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MED_ADMIN_MED_EVENT_INGRDNT
(
  MED_EVENT_INGREDIENT_ID    NUMBER             DEFAULT 0                     NOT NULL,
  SYNONYM_ID                 NUMBER             DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID           NUMBER             DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME         VARCHAR2(30 BYTE)  DEFAULT ' '                   NOT NULL,
  IDENTIFICATION_PROCESS_CD  NUMBER             DEFAULT 0                     NOT NULL,
  STRENGTH                   FLOAT(126)         DEFAULT 0                     NOT NULL,
  STRENGTH_UNIT_CD           NUMBER             DEFAULT 0                     NOT NULL,
  VOLUME                     FLOAT(126)         DEFAULT 0                     NOT NULL,
  VOLUME_UNIT_CD             NUMBER             DEFAULT 0                     NOT NULL,
  DRUG_FORM_CD               NUMBER             DEFAULT 0                     NOT NULL,
  CATALOG_CD                 NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MIC_QC_NUMERIC_TASK_DETAIL
(
  NUMERIC_TASK_DETAIL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  MEAN_NBR                FLOAT(126)            DEFAULT 0.0                   NOT NULL,
  STD_DEV_NBR             FLOAT(126)            DEFAULT 0.0                   NOT NULL,
  NUM_OF_STD_DEV_NBR      NUMBER                DEFAULT 0                     NOT NULL,
  HIGH_NBR                FLOAT(126)            DEFAULT 0.0                   NOT NULL,
  LOW_NBR                 FLOAT(126)            DEFAULT 0.0                   NOT NULL,
  RANGE_NBR               NUMBER                DEFAULT 0                     NOT NULL,
  TASK_DETAIL_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MLTM_ADDITIONAL_TEXT
(
  DRUG_IDENTIFIER  VARCHAR2(6 BYTE)             DEFAULT ' '                   NOT NULL,
  TEXT_TYPE_ID     NUMBER                       DEFAULT 0                     NOT NULL,
  TEXT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MLTM_ALR_CATEGORY_DRUG_MAP
(
  DRUG_IDENTIFIER  VARCHAR2(6 BYTE)             DEFAULT ' '                   NOT NULL,
  ALR_CATEGORY_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MLTM_CATEGORY_DRUG_XREF
(
  MULTUM_CATEGORY_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  DRUG_IDENTIFIER     VARCHAR2(6 BYTE)          DEFAULT ' '                   NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MLTM_DDM_GROUP_MMDC_MAP
(
  GROUP_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  MAIN_MULTUM_DRUG_CODE  NUMBER                 DEFAULT 0                     NOT NULL,
  MULTUM_CATEGORY_ID     NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MLTM_DRC_GROUP_RELTN
(
  GROUPER_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  GROUPER_NAME           VARCHAR2(250 BYTE),
  SYNONYM_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  MAIN_MULTUM_DRUG_CODE  NUMBER                 DEFAULT 0                     NOT NULL,
  VERSION                VARCHAR2(25 BYTE),
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MLTM_MMDC_ATTRIBUTE
(
  MAIN_MULTUM_DRUG_CODE  NUMBER                 DEFAULT 0                     NOT NULL,
  AVAILABLE_IND          NUMBER,
  OTC_STATUS             NUMBER,
  GENERIC_FORM_IND       NUMBER,
  GENERIC_SYNONYM_ID     NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MMR_QI_QUESTION_NUM_RSLT
(
  RESULT_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER,
  UPDT_CNT                   NUMBER,
  UPDT_DT_TM                 DATE,
  UPDT_ID                    NUMBER,
  UPDT_TASK                  NUMBER,
  ACTIVE_IND                 NUMBER,
  ACTIVE_STATUS_CD           NUMBER,
  ACTIVE_STATUS_DT_TM        DATE,
  ACTIVE_STATUS_PRSNL_ID     NUMBER,
  BEG_EFFECTIVE_DT_TM        DATE,
  END_EFFECTIVE_DT_TM        DATE,
  QUESTION_GROUP_ID          NUMBER,
  QUALITY_ITEM_ID            NUMBER,
  QUESTION_ID                NUMBER,
  COMMENTS_ID                NUMBER,
  GRID_ID                    NUMBER,
  RESULT_NBR                 FLOAT(126),
  QUALITY_ITEM_DATA_ID       NUMBER             DEFAULT 0                     NOT NULL,
  QUESTION_NUM_RSLT_UPD_IND  NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE MRU_LOOKUP_ORDER
(
  MRU_LOOKUP_ORDER_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  SYNONYM_ID           NUMBER                   DEFAULT 0                     NOT NULL,
  ORDER_SENTENCE_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  ORD_AS_FLAG          NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE NMDP_ALLELE_XREF
(
  NMDP_CD       NUMBER                          DEFAULT 0                     NOT NULL,
  ALLELE_CD     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL,
  NMDP_CODE_ID  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OCS_ATTR_XCPTN
(
  OCS_ATTR_XCPTN_ID        NUMBER               DEFAULT 0                     NOT NULL,
  OCS_ATTR_XCPTN_GROUP_ID  NUMBER               DEFAULT 0                     NOT NULL,
  SYNONYM_ID               NUMBER               DEFAULT 0                     NOT NULL,
  OCS_COL_NAME_CD          NUMBER               DEFAULT 0                     NOT NULL,
  FLEX_OBJ_TYPE_CD         NUMBER               DEFAULT 0                     NOT NULL,
  FLEX_OBJ_CD              NUMBER               DEFAULT 0                     NOT NULL,
  FLEX_NBR_VALUE           NUMBER,
  FLEX_STR_VALUE_TXT       VARCHAR2(100 BYTE),
  FACILITY_CD              NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OCS_FACILITY_FORMULARY_R
(
  OCS_FACILITY_FORMULARY_R_ID     NUMBER        DEFAULT 0                     NOT NULL,
  FACILITY_CD                     NUMBER        DEFAULT 0                     NOT NULL,
  SYNONYM_ID                      NUMBER        DEFAULT 0                     NOT NULL,
  INPATIENT_FORMULARY_STATUS_CD   NUMBER        DEFAULT 0                     NOT NULL,
  OUTPATIENT_FORMULARY_STATUS_CD  NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_CNT                        NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_ID                         NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_TASK                       NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                    NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                      DATE          DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OCS_FACILITY_R
(
  SYNONYM_ID    NUMBER                          DEFAULT 0                     NOT NULL,
  FACILITY_CD   NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OPS_DAY_OF_MONTH
(
  OPS_DAY_OF_MONTH_ID     NUMBER                DEFAULT 0                     NOT NULL,
  OPS_TASK_ID             NUMBER                DEFAULT 0                     NOT NULL,
  DAY_OF_MONTH            NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  OPS_JOB_VERIFY_ID       NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OPS_DAY_OF_WEEK
(
  OPS_DAY_OF_WEEK_ID      NUMBER                DEFAULT 0                     NOT NULL,
  OPS_TASK_ID             NUMBER                DEFAULT 0                     NOT NULL,
  DAY_OF_WEEK             NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  OPS_JOB_VERIFY_ID       NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OPS_SCHEDULE_JOB_STEP
(
  OPS_SCHEDULE_JOB_STEP_ID  NUMBER              DEFAULT 0                     NOT NULL,
  OPS_SCHEDULE_TASK_ID      NUMBER              DEFAULT 0                     NOT NULL,
  OPS_JOB_STEP_ID           NUMBER              DEFAULT 0                     NOT NULL,
  STATUS_CD                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  BEG_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM       DATE                DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  OPS_EVENT                 VARCHAR2(100 BYTE),
  AVG_FLAG                  NUMBER,
  AVG_DT_TM                 DATE,
  THRESH_DT_TM              DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE OPS_SCHED_DEP
(
  OPS_SCHED_DEP_ID        NUMBER                DEFAULT 0                     NOT NULL,
  OPS_JOB_VERIFY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  T_SCHED_TASK_ID         NUMBER                DEFAULT 0                     NOT NULL,
  T_SCHED_STEP_ID         NUMBER                DEFAULT 0                     NOT NULL,
  D_SCHED_TASK_ID         NUMBER                DEFAULT 0                     NOT NULL,
  D_SCHED_STEP_ID         NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ORC_CUSTOM_SEL
(
  ORC_CUSTOM_SEL_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  SYNONYM_ID         NUMBER                     DEFAULT 0                     NOT NULL,
  ORDER_SENTENCE_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ORC_CUSTOM_SEL_RELTN
(
  ORC_CUSTOM_SEL_RELTN_ID  NUMBER               DEFAULT 0                     NOT NULL,
  ORC_CUSTOM_SEL_TYPE_CD   NUMBER               DEFAULT 0                     NOT NULL,
  CATALOG_CD               NUMBER               DEFAULT 0                     NOT NULL,
  ORC_CUSTOM_SEL_ID        NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ORC_RESOURCE_LIST
(
  SERVICE_RESOURCE_CD     NUMBER                DEFAULT 0                     NOT NULL,
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE                NUMBER,
  PRIMARY_IND             NUMBER,
  SCRIPT_NAME             VARCHAR2(50 BYTE),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PBS_AUTHORITY
(
  PBS_AUTHORITY_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  PBS_INDICATION_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  AUTHORITY_CD       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PBS_CAUTION_RELTN
(
  PBS_CAUTION_RELTN_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  PBS_CAUTION_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  PBS_ITEM_ID           NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PBS_DRUG
(
  PBS_DRUG_ID          NUMBER                   DEFAULT 0                     NOT NULL,
  BRAND_NAME           VARCHAR2(45 BYTE)        DEFAULT ' '                   NOT NULL,
  BRAND_IDENT          VARCHAR2(45 BYTE)        DEFAULT ' '                   NOT NULL,
  PBS_MANUFACTURER_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PBS_ITEM_ID          NUMBER                   DEFAULT 0                     NOT NULL,
  PACK_SIZE            NUMBER                   DEFAULT 0                     NOT NULL,
  FORM_STRENGTH        VARCHAR2(400 BYTE)       DEFAULT ' '                   NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE                     DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  FORM_PACK            VARCHAR2(100 BYTE),
  FORM_LEGAL           VARCHAR2(400 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PBS_OCS_MAPPING
(
  PBS_OCS_MAPPING_ID   NUMBER                   DEFAULT 0                     NOT NULL,
  PBS_DRUG_ID          NUMBER                   DEFAULT 0                     NOT NULL,
  SYNONYM_ID           NUMBER                   DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE                     DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PCA_MEASURE_OUTCOME_RELTN
(
  PCA_MEASURE_OUTCOME_RELTN_ID  NUMBER          DEFAULT 0                     NOT NULL,
  PCA_QUALITY_MEASURE_ID        NUMBER          DEFAULT 0                     NOT NULL,
  PCA_OUTCOME_ID                NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PFT_SEL_TASK_R
(
  PFT_SEL_TASK_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE)     DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  SELECTED_TASK_ID        NUMBER                DEFAULT 0                     NOT NULL,
  TASK_OWNER_AUTH_FLAG    NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PFT_SUB_TYPE_SECURITY
(
  PFT_SUB_TYPE_SECURITY_ID  NUMBER              DEFAULT 0                     NOT NULL,
  PRSNL_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  TRANS_SUB_TYPE_CD         NUMBER              DEFAULT 0                     NOT NULL,
  AMOUNT                    FLOAT(126),
  SELECTED_TASK_ID          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM       DATE                DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PG_AVAIL_RESPONSE
(
  PG_AVAIL_RESPONSE_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  PG_QUESTION_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME    VARCHAR2(30 BYTE)       DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  DISPLAY_SEQ_NBR       NUMBER                  DEFAULT 0                     NOT NULL,
  ACTIVE_IND            NUMBER                  DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM   DATE                    DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM   DATE                    DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  DISPLAY_TXT           VARCHAR2(255 BYTE)      DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PG_AVAIL_RESPONSE_LIST
(
  PG_AVAIL_RESPONSE_LIST_ID  NUMBER             DEFAULT 0                     NOT NULL,
  PG_AVAIL_RESPONSE_ID       NUMBER             DEFAULT 0                     NOT NULL,
  PG_AVAIL_RESPONSE_GRP_ID   NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PG_AVAIL_RESPONSE_R
(
  PG_AVAIL_RESPONSE_R_ID     NUMBER             DEFAULT 0                     NOT NULL,
  PG_AVAIL_RESPONSE_ID       NUMBER             DEFAULT 0                     NOT NULL,
  RELATED_AVAIL_RESPONSE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PG_RESULT_LIST
(
  PG_RESULT_LIST_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  PG_RESULT_STAGE_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  PG_AVAIL_RESPONSE_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID          NUMBER                  DEFAULT 0                     NOT NULL,
  RESPONSE_TYPE_FLAG    NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  PG_QUESTION_ID        NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PM_RPT_GROUP
(
  GROUP_ID                NUMBER                DEFAULT 0                     NOT NULL,
  REPORT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  HEADER_ID               NUMBER                DEFAULT 0                     NOT NULL,
  FIELD_ID                NUMBER                DEFAULT 0                     NOT NULL,
  GROUP_SEQUENCE          NUMBER,
  GROUP_TOTAL_IND         NUMBER,
  DATA_STATUS_CD          NUMBER                DEFAULT 0,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0,
  ACTIVE_STATUS_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE POSITIVE_TUBES
(
  LOT_NUMBER_ID       NUMBER                    DEFAULT 0                     NOT NULL,
  ALLELE_CD           NUMBER                    DEFAULT 0                     NOT NULL,
  TUBE_NUMBER         NUMBER                    DEFAULT 0                     NOT NULL,
  REACTION_SYMBOL_CD  NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE PROFILE_TASK_R
(
  CATALOG_CD              NUMBER                DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  VERSION_NBR             NUMBER,
  GROUP_CD                NUMBER                DEFAULT 0                     NOT NULL,
  ITEM_TYPE_FLAG          NUMBER,
  PENDING_IND             NUMBER,
  REPEAT_IND              NUMBER,
  SEQUENCE                NUMBER,
  DUP_CHK_MIN             NUMBER,
  DUP_CHK_ACTION_CD       NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  POST_PROMPT_IND         NUMBER,
  PROMPT_RESOURCE_CD      NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  REFERENCE_TASK_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PROMPT_LONG_TEXT_ID     NUMBER                DEFAULT 0                     NOT NULL,
  RESTRICT_DISPLAY_IND    NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE QC_SCHD_STEP_CTRL_ASSAY
(
  QC_SCHD_STEP_CTRL_ASSAY_ID  NUMBER            DEFAULT 0                     NOT NULL,
  QC_SCHEDULE_ID              NUMBER            DEFAULT 0                     NOT NULL,
  STEP_NBR                    NUMBER            DEFAULT 0                     NOT NULL,
  CONTROL_ID                  NUMBER            DEFAULT 0                     NOT NULL,
  ERROR_STEP_IND              NUMBER            DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD               NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE RAD_TECH_FMT_ERPRC_OVRD
(
  FORMAT_OVRD_ID          NUMBER                DEFAULT 0                     NOT NULL,
  FIELD_FORMAT_RELTN_ID   NUMBER                DEFAULT 0                     NOT NULL,
  FORMAT_ERPRC_RELTN_ID   NUMBER                DEFAULT 0                     NOT NULL,
  CHARTABLE_IND           NUMBER                DEFAULT 0                     NOT NULL,
  REQUIRED_IND            NUMBER                DEFAULT 0                     NOT NULL,
  DEFAULT_NBR             FLOAT(126),
  DEFAULT_TEXT            VARCHAR2(255 BYTE),
  DEFAULT_DT_TM           DATE,
  DEFAULT_CHOICE_IND      NUMBER,
  MIN_NBR                 FLOAT(126),
  MAX_NBR                 FLOAT(126),
  ACTIVE_IND              NUMBER                DEFAULT 1                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE REPLACE_GROUPING
(
  CATALOG_CD          NUMBER                    DEFAULT 0                     NOT NULL,
  REPLACE_CATALOG_CD  NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE REPORT_INPROC_STATUS
(
  CATALOG_CD             NUMBER                 DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD          NUMBER                 DEFAULT 0                     NOT NULL,
  PROCESSING_SEQUENCE    NUMBER,
  TRANSCRIBED_STATUS_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  DICTATED_STATUS_CD     NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  CANCELABLE_IND         NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ROUND_ROBIN_COMMENT
(
  ROUND_ROBIN_REF_ID   NUMBER                   DEFAULT 0                     NOT NULL,
  ACCESSION_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  SEQUENCE             NUMBER                   DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVE_IND           NUMBER                   DEFAULT 0,
  BEG_EFFECTIVE_DT_TM  DATE,
  END_EFFECTIVE_DT_TM  DATE,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE SCH_APPT_ORD
(
  APPT_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  REQUIRED_IND            NUMBER                DEFAULT 0                     NOT NULL,
  SEQ_NBR                 NUMBER                DEFAULT 0                     NOT NULL,
  VERSION_DT_TM           DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  SYNONYM_ID              NUMBER                DEFAULT 0                     NOT NULL,
  ALT_SEL_CATEGORY_ID     NUMBER                DEFAULT 0                     NOT NULL,
  NULL_DT_TM              DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  CANDIDATE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE SCR_PARAGRAPH
(
  SCR_PATTERN_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  SCR_PARAGRAPH_TYPE_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE_NUMBER        NUMBER,
  SCR_PARAGRAPH_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE SELECTED_CRITERIA
(
  SELECTED_CRITERIA_ID    NUMBER                DEFAULT 0                     NOT NULL,
  SELECTED_TASK_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PFT_TASK_CRITERIA_ID    NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_SEQ               NUMBER,
  EVALUATOR_TXT           VARCHAR2(250 BYTE),
  EVALUATOR_TYPE          FLOAT(126),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE SIGN_LINE_LAYOUT_FIELD_R
(
  SIGN_LINE_LAYOUT_FIELD_R_ID  NUMBER           DEFAULT 0                     NOT NULL,
  FORMAT_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  UCMR_LAYOUT_FIELD_ID         NUMBER           DEFAULT 0                     NOT NULL,
  STATUS_FLAG                  NUMBER,
  ACTIVE_IND                   NUMBER,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE SI_OEN_CHANN_ENDPOINT_R
(
  SI_OEN_CHANN_ENDPOINT_R_ID  NUMBER            DEFAULT 0                     NOT NULL,
  SI_OEN_COMCHANNEL_ID        NUMBER            DEFAULT 0                     NOT NULL,
  SI_OEN_ENDPOINT_ID          NUMBER            DEFAULT 0                     NOT NULL,
  RELATION_TYPE               VARCHAR2(31 BYTE) DEFAULT ' ' NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE SN_CT_DISPLAY_FIELD
(
  SN_CT_DISPLAY_FIELD_ID  NUMBER                DEFAULT 0                     NOT NULL,
  SN_CT_DISPLAY_ROW_ID    NUMBER                DEFAULT 0                     NOT NULL,
  FIELD_SEQUENCE          NUMBER                DEFAULT 0                     NOT NULL,
  FIELD_PROMPT            VARCHAR2(50 BYTE),
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE),
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE STRT_BMDI_MODEL_NOMENCLATURE
(
  STRT_MODEL_NOMENCLATURE_ID  NUMBER            DEFAULT 0                     NOT NULL,
  STRT_MODEL_PARAMETER_ID     NUMBER            DEFAULT 0                     NOT NULL,
  STRT_MODEL_ID               NUMBER            DEFAULT 0                     NOT NULL,
  DEFAULT_VALUE               VARCHAR2(50 BYTE) DEFAULT ' ' NOT NULL,
  ALPHA_TRANSLATION           VARCHAR2(50 BYTE) DEFAULT ' ' NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE TPL_APPL_DETAIL
(
  APPL_DETAIL_ID            NUMBER              DEFAULT 0                     NOT NULL,
  APPL_TASK_RELTN_ID        NUMBER              DEFAULT 0                     NOT NULL,
  TITLE_TXT                 VARCHAR2(255 BYTE)  DEFAULT ' '                   NOT NULL,
  APPL_TYPE_FLAG            NUMBER              DEFAULT 0                     NOT NULL,
  HTTP_POST_IND             NUMBER              DEFAULT 0                     NOT NULL,
  REUSE_PRCS_IND            NUMBER              DEFAULT 0                     NOT NULL,
  CMD_PATH_TXT              VARCHAR2(512 BYTE),
  CTX_PARAM_TXT             VARCHAR2(2048 BYTE),
  FILE_PATH_TXT             VARCHAR2(512 BYTE),
  FILE_TMPLT_LONG_TEXT_ID   NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER              DEFAULT 0                     NOT NULL,
  TEST_MODE_IND             NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  RAD_SEND_LINKED_ACCN_IND  NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE UCMR_CASE_GRP_STEP_R
(
  UCMR_CASE_GRP_STEP_R_ID       NUMBER          DEFAULT 0                     NOT NULL,
  PREV_UCMR_CASE_GRP_STEP_R_ID  NUMBER          DEFAULT 0                     NOT NULL,
  UCMR_CASE_GROUP_ID            NUMBER          DEFAULT 0                     NOT NULL,
  UCMR_CASE_STEP_ID             NUMBER          DEFAULT 0                     NOT NULL,
  REPEAT_CAT_CD                 NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD              NUMBER          DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM           DATE            DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM           DATE            DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE UNIQUE INDEX XAK1ALPHA_RESPONSES_CATEGORY ON ALPHA_RESPONSES_CATEGORY
(REFERENCE_RANGE_FACTOR_ID, CATEGORY_NAME)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1BB_RH_PHENOTYPE ON BB_RH_PHENOTYPE
(FR_NOMENCLATURE_ID, W_NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1CNT_DCP_INTERP_STATE ON CNT_DCP_INTERP_STATE
(DCP_INTERP_UID, RESULTING_STATE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1CNT_DTA_RRF_R ON CNT_DTA_RRF_R
(RRF_UID, TASK_ASSAY_UID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1CNT_GRID ON CNT_GRID
(ROW_TASK_ASSAY_UID, COL_TASK_ASSAY_UID, INT_EVENT_CDUID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1CNT_INPUT ON CNT_INPUT
(SECTION_UID, INPUT_DESCRIPTION, PVC_NAME, INPUT_REF_SEQ, INPUT_SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1CV_ORDER_CATEGORY_R ON CV_ORDER_CATEGORY_R
(CV_ORDER_CATEGORY_ID, CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1CYTO_STANDARD_REPORT ON CYTO_STANDARD_RPT
(CATALOG_CD, SHORT_DESC)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1DA_BV_LV_ELEM_RELTN ON DA_BV_LV_ELEM_RELTN
(DA_BUS_VIEW_ID, DA_LOGICAL_VIEW_ID, DA_ELEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1DA_CALC_ELEM_RELTN ON DA_CALC_ELEM_RELTN
(CHILD_ELEMENT_ID, PARENT_ELEMENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1DD_REF_EMR_CONTENT ON DD_REF_EMR_CONTENT
(REF_CONTENT_INSTANCE_IDENT)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1DIFFERENTIAL_REF ON DIFFERENTIAL_REF
(OPT_KEY, CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1DRUG_CLASS_INT_CSTM_ENT_R ON DRUG_CLASS_INT_CSTM_ENTITY_R
(DCP_ENTITY_RELTN_ID, DRUG_CLASS_INT_CUSTOM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1HIM_HAC_CRITERIA ON HIM_HAC_CRITERIA
(HAC_NOMENCLATURE_ID, COMPARE_PX_NOMEN_ID, COMPARE_DX_NOMEN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1HLA_AB_SCREEN_HISTORY_M ON HLA_AB_SCREEN_HISTORY_MAP
(CATALOG_CD, REACTION_DTA_CD, T_CELL_PRA_DTA_CD, B_CELL_PRA_DTA_CD, METHODOLOGY_DTA_CD, 
DILUTION_DTA_CD, METHODOLOGY_NOM_ID, DILUTION_NOM_ID, OD_DTA_CD, OD_RATIO_DTA_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1HLA_AB_SPEC_MAP ON HLA_AB_SPEC_MAP
(CATALOG_CD, AB_DTA_CD, AB_HIST_SEQ_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1HM_EXPECT_SAT ON HM_EXPECT_SAT
(EXPECT_ID, SATISFIER_MEANING)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1HM_EXPECT_SAT_HIST ON HM_EXPECT_SAT_HIST
(EXPECT_SAT_HIST_ID, EXPECT_SAT_ID, ACTION_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1MIC_QC_NUMERIC_TASK_DETAIL ON MIC_QC_NUMERIC_TASK_DETAIL
(MEAN_NBR, STD_DEV_NBR, NUM_OF_STD_DEV_NBR, HIGH_NBR, LOW_NBR, 
RANGE_NBR, TASK_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1MRU_LOOKUP_ORDER ON MRU_LOOKUP_ORDER
(SYNONYM_ID, ORDER_SENTENCE_ID, ORD_AS_FLAG)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1OCS_ATTR_XCPTN ON OCS_ATTR_XCPTN
(SYNONYM_ID, FACILITY_CD, OCS_COL_NAME_CD, FLEX_OBJ_TYPE_CD, FLEX_OBJ_CD, 
OCS_ATTR_XCPTN_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1OCS_FACILITY_FORMULARY_R ON OCS_FACILITY_FORMULARY_R
(SYNONYM_ID, FACILITY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1OPS_SCHEDULE_JOB_STEP ON OPS_SCHEDULE_JOB_STEP
(OPS_SCHEDULE_TASK_ID, OPS_JOB_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1PBS_CAUTION_RELTN ON PBS_CAUTION_RELTN
(PBS_CAUTION_ID, PBS_ITEM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1PBS_OCS_MAPPING ON PBS_OCS_MAPPING
(PBS_DRUG_ID, SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1PCA_MEASURE_OUTCOME_RELTN ON PCA_MEASURE_OUTCOME_RELTN
(PCA_QUALITY_MEASURE_ID, PCA_OUTCOME_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1PG_AVAIL_RESPONSE ON PG_AVAIL_RESPONSE
(PG_QUESTION_ID, PARENT_ENTITY_NAME, PARENT_ENTITY_ID, DISPLAY_TXT)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1PG_AVAIL_RESPONSE_LIST ON PG_AVAIL_RESPONSE_LIST
(PG_AVAIL_RESPONSE_ID, PG_AVAIL_RESPONSE_GRP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1PG_AVAIL_RESPONSE_R ON PG_AVAIL_RESPONSE_R
(PG_AVAIL_RESPONSE_ID, RELATED_AVAIL_RESPONSE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1SIGN_LINE_LAYOUT_FIELD_R ON SIGN_LINE_LAYOUT_FIELD_R
(FORMAT_ID, UCMR_LAYOUT_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1SI_OEN_CHANN_ENDPOINT_R ON SI_OEN_CHANN_ENDPOINT_R
(SI_OEN_COMCHANNEL_ID, SI_OEN_ENDPOINT_ID, RELATION_TYPE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1SN_CT_DISPLAY_FIELD ON SN_CT_DISPLAY_FIELD
(SN_CT_DISPLAY_ROW_ID, FIELD_SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XAK1TPL_APPL_DETAIL ON TPL_APPL_DETAIL
(APPL_TASK_RELTN_ID, TITLE_TXT)
LOGGING
NOPARALLEL;


CREATE INDEX XFK1CHART_GRP_EVNT_SET ON CHART_GRP_EVNT_SET
(EVENT_SET_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIDX2BB_GROUP_COMPONENT ON BB_GROUP_COMPONENT
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIDX2BB_RH_PHENOTYPE ON BB_RH_PHENOTYPE
(W_NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE01LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(ADMIT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE01LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(ADMIT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE01LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(ADMIT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE02LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(DISCHARGE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE02LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(DISCHARGE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE02LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(DISCHARGE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE03LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(PARTITION_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE03LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(PARTITION_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE03LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(PARTITION_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE04LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(EXTRACT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE04LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(EXTRACT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE04LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(EXTRACT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE05LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE05LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE05LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(UPDT_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE06LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(ENCNTR_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE06LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(ENCNTR_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE06LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(ENCNTR_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE07LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(ADMIT_UTC_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE07LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(ADMIT_UTC_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE07LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(ADMIT_UTC_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE08LH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(DISCHARGE_UTC_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE08LH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(DISCHARGE_UTC_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE08LH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(DISCHARGE_UTC_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1ADVANCED_DELTA ON ADVANCED_DELTA
(REFERENCE_RANGE_FACTOR_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1ALT_SEL_CAT ON ALT_SEL_CAT
(AHFS_IND)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1ALT_SEL_LIST ON ALT_SEL_LIST
(CHILD_ALT_SEL_CAT_ID, ALT_SEL_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1BB_GROUP_COMPONENT ON BB_GROUP_COMPONENT
(BB_TEST_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1BB_QC_EXPECTED_RESULT_R ON BB_QC_EXPECTED_RESULT_R
(NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1BB_RH_PHENO_TESTING ON BB_RH_PHENO_TESTING
(RH_PHENOTYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1BR_DATAMART_DEFAULT ON BR_DATAMART_DEFAULT
(BR_DATAMART_FILTER_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1BR_DATAMART_DEFAULT_DETAIL ON BR_DATAMART_DEFAULT_DETAIL
(BR_DATAMART_DEFAULT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CATALOG_EVENT_SETS ON CATALOG_EVENT_SETS
(EVENT_SET_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CHART_FORMAT_CODES ON CHART_FORMAT_CODES
(CHART_FORMAT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CHART_GRP_EVNT_SUPPRESS ON CHART_GRP_EVNT_SUPPRESS
(CHART_GROUP_ID, ORDER_CATALOG_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CONDITIONAL_DTA ON CONDITIONAL_DTA
(CONDITIONAL_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1COND_EXPRESSION_COMP ON COND_EXPRESSION_COMP
(TRIGGER_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CV_RESPONSE ON CV_RESPONSE
(A1)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CV_STEP_REF ON CV_STEP_REF
(ACTIVITY_SUBTYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1CV_XREF_VALIDATION ON CV_XREF_VALIDATION
(RLTNSHIP_FLAG)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1DD_REF_EMR_CONTENT ON DD_REF_EMR_CONTENT
(EMR_CONTENT_TYPE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1EEM_ABN_DATA ON EEM_ABN_DATA
(KEY_FIELD, EEM_FILE_ID, ATTR_TYPE_CD, SEQ_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1EEM_ABN_RULE ON EEM_ABN_RULE
(PROC_IDENT, EEM_FILE_ID, DIAG_BEG_IDENT, DIAG_END_IDENT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1EEM_BENEFIT_QUAL ON EEM_BENEFIT_QUAL
(BENEFIT_ID, QUALIFIER_CD, BEG_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1EEM_ENTITY_NTWK_RELTN ON EEM_ENTITY_NTWK_RELTN
(NETWORK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1EEM_ENTITY_PROV_TAX_RELTN ON EEM_ENTITY_PROV_TAX_RELTN
(PARENT_ENTITY_ID, PARENT_ENTITY_NAME, EEM_PROV_TAX_RELTN_ID, BEG_EFFECTIVE_DT_TM)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1EEM_SERVICE_LIST ON EEM_SERVICE_LIST
(SERVICE_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1GROUP_DEFINITION ON GROUP_DEFINITION
(GROUP_REFERENCE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1HLA_AB_SCREEN_HISTORY_M ON HLA_AB_SCREEN_HISTORY_MAP
(CATALOG_CD, REACTION_DTA_CD, T_CELL_PRA_DTA_CD, B_CELL_PRA_DTA_CD, METHODOLOGY_DTA_CD, 
DILUTION_DTA_CD, METHODOLOGY_NOM_ID, DILUTION_NOM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1INPUT_FORM_DEFINITION ON INPUT_FORM_DEFINITION
(INPUT_FORM_REFERENCE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1MED_ADMIN_MED_EVENT_INGRDT ON MED_ADMIN_MED_EVENT_INGRDNT
(PARENT_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1MIC_QC_NUMERIC_TASK_DETAIL ON MIC_QC_NUMERIC_TASK_DETAIL
(TASK_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1MLTM_CATEGORY_DRUG_XREF ON MLTM_CATEGORY_DRUG_XREF
(DRUG_IDENTIFIER)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1MLTM_DRC_GROUP_RELTN ON MLTM_DRC_GROUP_RELTN
(MAIN_MULTUM_DRUG_CODE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1OCS_ATTR_XCPTN ON OCS_ATTR_XCPTN
(OCS_ATTR_XCPTN_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1OCS_FACILITY_FORMULARY_R ON OCS_FACILITY_FORMULARY_R
(FACILITY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1OPS_DAY_OF_MONTH ON OPS_DAY_OF_MONTH
(OPS_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1OPS_DAY_OF_WEEK ON OPS_DAY_OF_WEEK
(OPS_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1OPS_SCHED_DEP ON OPS_SCHED_DEP
(T_SCHED_TASK_ID, T_SCHED_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XIE1ORC_CUSTOM_SEL ON ORC_CUSTOM_SEL
(SYNONYM_ID, ORDER_SENTENCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XIE1ORC_CUSTOM_SEL_RELTN ON ORC_CUSTOM_SEL_RELTN
(CATALOG_CD, ORC_CUSTOM_SEL_TYPE_CD, ORC_CUSTOM_SEL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1PBS_AUTHORITY ON PBS_AUTHORITY
(PBS_INDICATION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1PBS_DRUG ON PBS_DRUG
(PBS_ITEM_ID, PBS_MANUFACTURER_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1PBS_OCS_MAPPING ON PBS_OCS_MAPPING
(SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1PFT_SEL_TASK_R ON PFT_SEL_TASK_R
(PARENT_ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1PFT_SUB_TYPE_SECURITY ON PFT_SUB_TYPE_SECURITY
(PRSNL_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1PG_RESULT_LIST ON PG_RESULT_LIST
(PG_RESULT_STAGE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1QC_SCHD_STEP_CTRL_ASSAY ON QC_SCHD_STEP_CTRL_ASSAY
(STEP_NBR, CONTROL_ID, ERROR_STEP_IND, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1RAD_TECH_FMT_ERPRC_OVRD ON RAD_TECH_FMT_ERPRC_OVRD
(FORMAT_ERPRC_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1SCH_APPT_ORD ON SCH_APPT_ORD
(SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1UCMR_CASE_GRP_STEP_R ON UCMR_CASE_GRP_STEP_R
(UCMR_CASE_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1_NMDP_ALLELE_XREF ON NMDP_ALLELE_XREF
(ALLELE_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2ALT_SEL_CAT ON ALT_SEL_CAT
(SHORT_DESCRIPTION)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2ALT_SEL_LIST ON ALT_SEL_LIST
(ALT_SEL_CATEGORY_ID, LIST_TYPE)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2BB_QC_EXPECTED_RESULT_R ON BB_QC_EXPECTED_RESULT_R
(RELATED_REAGENT_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XIE2CATALOG_EVENT_SETS ON CATALOG_EVENT_SETS
(CATALOG_CD, EVENT_SET_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2CHART_FORMAT_CODES ON CHART_FORMAT_CODES
(EVENT_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2CV_RESPONSE ON CV_RESPONSE
(A2)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2DD_REF_EMR_CONTENT ON DD_REF_EMR_CONTENT
(TITLE_TXT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2EEM_ENTITY_NTWK_RELTN ON EEM_ENTITY_NTWK_RELTN
(LONG_TEXT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2EEM_ENTITY_PROV_TAX_RELTN ON EEM_ENTITY_PROV_TAX_RELTN
(EEM_PROV_TAX_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2GROUP_DEFINITION ON GROUP_DEFINITION
(ONLINE_ITEM_DEFINITION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2INPUT_FORM_DEFINITION ON INPUT_FORM_DEFINITION
(GROUP_REFERENCE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2MED_ADMIN_MED_EVENT_INGRDT ON MED_ADMIN_MED_EVENT_INGRDNT
(SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2MLTM_DRC_GROUP_RELTN ON MLTM_DRC_GROUP_RELTN
(SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2OPS_SCHEDULE_JOB_STEP ON OPS_SCHEDULE_JOB_STEP
(OPS_JOB_STEP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2OPS_SCHED_DEP ON OPS_SCHED_DEP
(D_SCHED_TASK_ID, D_SCHED_STEP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2PBS_DRUG ON PBS_DRUG
(BRAND_IDENT)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2PFT_SEL_TASK_R ON PFT_SEL_TASK_R
(SELECTED_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2PFT_SUB_TYPE_SECURITY ON PFT_SUB_TYPE_SECURITY
(SELECTED_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2QC_SCHD_STEP_CTRL_ASSAY ON QC_SCHD_STEP_CTRL_ASSAY
(QC_SCHEDULE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2SCH_APPT_ORD ON SCH_APPT_ORD
(ALT_SEL_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2UCMR_CASE_GRP_STEP_R ON UCMR_CASE_GRP_STEP_R
(UCMR_CASE_STEP_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3ALT_SEL_CAT ON ALT_SEL_CAT
(LONG_DESCRIPTION_KEY_CAP)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3ALT_SEL_LIST ON ALT_SEL_LIST
(PATHWAY_CATALOG_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CHART_FORMAT_CODES ON CHART_FORMAT_CODES
(ORDER_CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3CV_RESPONSE ON CV_RESPONSE
(A3)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3EEM_ENTITY_NTWK_RELTN ON EEM_ENTITY_NTWK_RELTN
(PARENT_ENTITY_ID, PARENT_ENTITY_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3INPUT_FORM_DEFINITION ON INPUT_FORM_DEFINITION
(ONLINE_ITEM_DEFINITION_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3MED_ADMIN_MED_EVENT_INGRDT ON MED_ADMIN_MED_EVENT_INGRDNT
(IDENTIFICATION_PROCESS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE3OPS_SCHEDULE_JOB_STEP ON OPS_SCHEDULE_JOB_STEP
(STATUS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4ALT_SEL_CAT ON ALT_SEL_CAT
(OWNER_ID, LONG_DESCRIPTION_KEY_CAP)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4CV_RESPONSE ON CV_RESPONSE
(A4)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4MED_ADMIN_MED_EVENT_INGRDT ON MED_ADMIN_MED_EVENT_INGRDNT
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE4OPS_SCHEDULE_JOB_STEP ON OPS_SCHEDULE_JOB_STEP
(ACTIVE_STATUS_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIE50SCH_APPT_ORD ON SCH_APPT_ORD
(CANDIDATE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE5CV_RESPONSE ON CV_RESPONSE
(A5)
LOGGING
NOPARALLEL;


CREATE INDEX XIE6CV_RESPONSE ON CV_RESPONSE
(XREF_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE7CV_RESPONSE ON CV_RESPONSE
(RESPONSE_INTERNAL_NAME)
LOGGING
NOPARALLEL;


CREATE INDEX XIF002SELECTED_CRITERIA ON SELECTED_CRITERIA
(SELECTED_TASK_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF003SELECTED_CRITERIA ON SELECTED_CRITERIA
(PFT_TASK_CRITERIA_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF18PM_RPT_GROUP ON PM_RPT_GROUP
(FIELD_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF214ALT_SEL_LIST ON ALT_SEL_LIST
(SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF23PM_RPT_GROUP ON PM_RPT_GROUP
(HEADER_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF246ASSAY_TAT ON ASSAY_TAT
(SERVICE_RESOURCE_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF247CATALOG_TAT ON CATALOG_TAT
(SERVICE_RESOURCE_CD, CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF251REPLACE_GROUPING ON REPLACE_GROUPING
(REPLACE_CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF260DATA_MAP ON DATA_MAP
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF28PM_RPT_GROUP ON PM_RPT_GROUP
(REPORT_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF346PROFILE_TASK_R ON PROFILE_TASK_R
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF431PROFILE_TASK_R ON PROFILE_TASK_R
(GROUP_CD, VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIF460GROUP_DEFINITION ON GROUP_DEFINITION
(TASK_ASSAY_CD, ONLINE_ITEM_VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIF461INPUT_FORM_DEFINITION ON INPUT_FORM_DEFINITION
(TASK_ASSAY_CD, ONLINE_ITEM_VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIF462INPUT_FORM_DEFINITION ON INPUT_FORM_DEFINITION
(GROUP_CD, GROUP_VERSION_NBR)
LOGGING
NOPARALLEL;


CREATE INDEX XIF560ORC_RESOURCE_LIST ON ORC_RESOURCE_LIST
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF58AP_PROCESSING_GRP_R ON AP_PROCESSING_GRP_R
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF628DATA_MAP ON DATA_MAP
(SERVICE_RESOURCE_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF69CYTO_STANDARD_REPORT_R ON CYTO_STANDARD_RPT_R
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF725DIFFERENTIAL_REF_ASSAY ON DIFFERENTIAL_REF_ASSAY
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF76PROFILE_TASK_R ON PROFILE_TASK_R
(VERSION_NBR, GROUP_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKADVANCED_DELTA ON ADVANCED_DELTA
(ADVANCED_DELTA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKALPHA_RESPONSES_CATEGORY ON ALPHA_RESPONSES_CATEGORY
(ALPHA_RESPONSES_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKALT_SEL_CAT ON ALT_SEL_CAT
(ALT_SEL_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKALT_SEL_LIST ON ALT_SEL_LIST
(ALT_SEL_CATEGORY_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_DC_STUDY_RPT_PROC ON AP_DC_STUDY_RPT_PROC
(STUDY_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_DIAG_AUTO_CODE ON AP_DIAG_AUTO_CODE
(CATALOG_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_PROCESSING_GRP_R ON AP_PROCESSING_GRP_R
(PARENT_ENTITY_NAME, PARENT_ENTITY_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_PROMPT_TEST ON AP_PROMPT_TEST
(ACCESSION_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_SYNOPTIC_RPT_SECTION_R ON AP_SYNOPTIC_RPT_SECTION_R
(CKI_SOURCE, CKI_IDENTIFIER, CATALOG_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAP_TASK_ASSAY_ADDL ON AP_TASK_ASSAY_ADDL
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKASSAY_TAT ON ASSAY_TAT
(TASK_ASSAY_CD, PRIORITY_CD, SERVICE_RESOURCE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_ACTION ON AT_ACTION
(AC_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_ACTIONPARAMETER ON AT_ACTIONPARAMETER
(ACP_ACTION_PARAM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_ACTIONSCREEN ON AT_ACTIONSCREEN
(AS_ACTION_SCREEN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_ALT_ACTION_NAME ON AT_ALT_ACTION_NAME
(AN_ALT_ACTION_NAME_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_APPACTION ON AT_APPACTION
(AA_APPLICATION_ID, AA_END_STATE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_BATCHDETAIL ON AT_BATCHDETAIL
(BD_BATCH_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_BATCHSTEP ON AT_BATCHSTEP
(BS_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_LOG ON AT_LOG
(LG_DEVICE_ID, LG_LOG_DT_TM, LG_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_OBJECTIVE ON AT_OBJECTIVE
(OB_OBJECTIVE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_PRECONDITION ON AT_PRECONDITION
(PRE_KEYWORD_ID, PRE_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_RUNSTEP ON AT_RUNSTEP
(RS_RUN_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_STEP ON AT_STEP
(ST_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_SUBACTION ON AT_SUBACTION
(SA_SUBACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_SYNONYMTYPE ON AT_SYNONYMTYPE
(SY_SYNONYM_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_TIMER ON AT_TIMER
(TM_RUN_ID, TM_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_GROUP_COMPONENT ON BB_GROUP_COMPONENT
(BB_GROUP_COMPONENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_QC_EXPECTED_RESULT_R ON BB_QC_EXPECTED_RESULT_R
(EXPECTED_RESULT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_RH_PHENOTYPE ON BB_RH_PHENOTYPE
(RH_PHENOTYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBB_RH_PHENO_TESTING ON BB_RH_PHENO_TESTING
(RH_PHENO_TESTING_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBILL_ONLY_PROC_RELTN ON BILL_ONLY_PROC_RELTN
(CATALOG_CD, ENTITY_NAME, ENTITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_DEFAULT ON BR_DATAMART_DEFAULT
(BR_DATAMART_DEFAULT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_DATAMART_DEFAULT_DETAIL ON BR_DATAMART_DEFAULT_DETAIL
(BR_DATAMART_DEFAULT_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKBR_OF_PARENT_RELTN ON BR_OF_PARENT_RELTN
(BR_CLIENT_ID, ALT_SEL_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCATALOG_EVENT_SETS ON CATALOG_EVENT_SETS
(CATALOG_CD, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCATALOG_TAT ON CATALOG_TAT
(CATALOG_CD, PRIORITY_CD, SERVICE_RESOURCE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCE_STRING_RESULT ON CE_STRING_RESULT
(EVENT_ID, VALID_UNTIL_DT_TM)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_ALLERGY_FORMAT ON CHART_ALLERGY_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_AP_FORMAT ON CHART_AP_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_DOC_FORMAT ON CHART_DOC_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_DYN_ZONE_FORM ON CHART_DYN_ZONE_FORM
(CHART_GROUP_ID, ZONE_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_FLEX_FORMAT ON CHART_FLEX_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_FORMAT_CODES ON CHART_FORMAT_CODES
(CF_CODE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_GENERIC_FORMAT ON CHART_GENERIC_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_GL_FORMAT ON CHART_GL_FORMAT
(CHART_GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_GRP_EVNT_SET ON CHART_GRP_EVNT_SET
(CHART_GROUP_ID, EVENT_SET_NAME, ORDER_CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_GRP_EVNT_SUPPRESS ON CHART_GRP_EVNT_SUPPRESS
(CHART_EVNT_SUPPRESS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_ZN_RESULT_COL ON CHART_ZN_RESULT_COL
(COLUMN_SEQ, CHART_GROUP_ID, ZONE_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCHART_ZN_RESULT_COL_CDS ON CHART_ZN_RESULT_COL_CDS
(NORMALCY_CD, COLUMN_SEQ, CHART_GROUP_ID, ZONE_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_DCP_INTERP_STATE ON CNT_DCP_INTERP_STATE
(CNT_DCP_INTERP_STATE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_DTA_RRF_R ON CNT_DTA_RRF_R
(CNT_DTA_RRF_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_GRID ON CNT_GRID
(CNT_GRID_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCNT_INPUT ON CNT_INPUT
(CNT_INPUT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCODE_SET_DOMAIN ON CODE_SET_DOMAIN
(REFERENCE, CODE_SET, FIELD_SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCOMMON_ALPHA_RESPONSES ON COMMON_ALPHA_RESPONSES
(ACTIVITY_TYPE_CD, NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCONDITIONAL_DTA ON CONDITIONAL_DTA
(CONDITIONAL_DTA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCOND_EXPRESSION_COMP ON COND_EXPRESSION_COMP
(COND_EXPRESSION_COMP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCOST_ADJ ON COST_ADJ
(COST_ADJ_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCS_COMPONENT ON CS_COMPONENT
(CATALOG_CD, COMP_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_ORDER_CATEGORY_R ON CV_ORDER_CATEGORY_R
(CV_ORDER_CATEGORY_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_RESPONSE ON CV_RESPONSE
(RESPONSE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_STEP_REF ON CV_STEP_REF
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCV_XREF_VALIDATION ON CV_XREF_VALIDATION
(XREF_VALIDATION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCYTO_REPORT_CONTROL ON CYTO_REPORT_CONTROL
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCYTO_STANDARD_RPT ON CYTO_STANDARD_RPT
(STANDARD_RPT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCYTO_STANDARD_RPT_R ON CYTO_STANDARD_RPT_R
(STANDARD_RPT_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_BV_LV_ELEM_RELTN ON DA_BV_LV_ELEM_RELTN
(DA_BV_LV_ELEM_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDA_CALC_ELEM_RELTN ON DA_CALC_ELEM_RELTN
(DA_CALC_ELEM_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDD_REF_EMR_CONTENT ON DD_REF_EMR_CONTENT
(DD_REF_EMR_CONTENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDEPT_DUP_CHECK ON DEPT_DUP_CHECK
(CATALOG_CD, DUP_CATALOG_CD, PRIORITY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDIFFERENTIAL_REF ON DIFFERENTIAL_REF
(DIF_REF_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDIFFERENTIAL_REF_ASSAY ON DIFFERENTIAL_REF_ASSAY
(DIF_REF_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDRUG_CLASS_INT_CSTM_ENT_R ON DRUG_CLASS_INT_CSTM_ENTITY_R
(DRUG_CLASS_INT_CSTM_ENT_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKDUP_CHECKING ON DUP_CHECKING
(CATALOG_CD, DUP_CHECK_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_ABN_DATA ON EEM_ABN_DATA
(ABN_ATTR_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_ABN_RULE ON EEM_ABN_RULE
(ABN_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_BENEFIT_QUAL ON EEM_BENEFIT_QUAL
(BENEFIT_QUAL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_ENTITY_NTWK_RELTN ON EEM_ENTITY_NTWK_RELTN
(ENTITY_NTWK_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_ENTITY_PROV_TAX_RELTN ON EEM_ENTITY_PROV_TAX_RELTN
(EEM_ENTITY_PROV_TAX_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEEM_SERVICE_LIST ON EEM_SERVICE_LIST
(SERVICE_LIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKEXAM_REASON ON EXAM_REASON
(CATALOG_CD, EXAM_REASON_ID, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFILM_USAGE ON FILM_USAGE
(CATALOG_CD, FILM_TYPE_CD, FILM_SIZE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKFORM_ASSOCIATION ON FORM_ASSOCIATION
(FORM_ASSOCIATION_ID, SEQUENCE_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKGROUP_DEFINITION ON GROUP_DEFINITION
(GROUP_CD, GROUP_VERSION_NBR, GROUP_DEF_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHIM_HAC_CRITERIA ON HIM_HAC_CRITERIA
(HIM_HAC_CRITERIA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_AB_SCREEN_HISTORY_MAP ON HLA_AB_SCREEN_HISTORY_MAP
(CATALOG_CD, SEQ_NUMBER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_NOMEN_CODE_R ON HLA_NOMEN_CODE_R
(NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHLA_XM_HISTORY_MAP ON HLA_XM_HISTORY_MAP
(CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKHM_EXPECT_SAT ON HM_EXPECT_SAT
(EXPECT_SAT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKINPUT_FORM_DEFINITION ON INPUT_FORM_DEFINITION
(INPUT_FORM_CD, INPUT_FORM_VERSION_NBR, INPUT_FORM_DEF_SEQ)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_ABS_ED_METRICS ON LH_ABS_ED_METRICS
(LH_ABS_ED_METRICS_ID, HEALTH_SYSTEM_SOURCE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_ABS_STROKE_METRICS ON LH_ABS_STROKE_METRICS
(LH_ABS_STROKE_METRICS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKLH_ABS_VTE_METRICS ON LH_ABS_VTE_METRICS
(LH_ABS_VTE_METRICS_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMED_ADMIN_MED_EVENT_INGRDNT ON MED_ADMIN_MED_EVENT_INGRDNT
(MED_EVENT_INGREDIENT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMIC_QC_NUMERIC_TASK_DETAIL ON MIC_QC_NUMERIC_TASK_DETAIL
(NUMERIC_TASK_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_ADDITIONAL_TEXT ON MLTM_ADDITIONAL_TEXT
(DRUG_IDENTIFIER, TEXT_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_ALR_CATEGORY_DRUG_MAP ON MLTM_ALR_CATEGORY_DRUG_MAP
(DRUG_IDENTIFIER, ALR_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_CATEGORY_DRUG_XREF ON MLTM_CATEGORY_DRUG_XREF
(MULTUM_CATEGORY_ID, DRUG_IDENTIFIER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DDM_GROUP_MMDC_MAP ON MLTM_DDM_GROUP_MMDC_MAP
(GROUP_ID, MAIN_MULTUM_DRUG_CODE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_DRC_GROUP_RELTN ON MLTM_DRC_GROUP_RELTN
(GROUPER_ID, SYNONYM_ID, MAIN_MULTUM_DRUG_CODE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMLTM_MMDC_ATTRIBUTE ON MLTM_MMDC_ATTRIBUTE
(MAIN_MULTUM_DRUG_CODE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMMR_QI_QUESTION_NUM_RSLT ON MMR_QI_QUESTION_NUM_RSLT
(RESULT_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKMRU_LOOKUP_ORDER ON MRU_LOOKUP_ORDER
(MRU_LOOKUP_ORDER_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKNMDP_ALLELE_XREF ON NMDP_ALLELE_XREF
(NMDP_CODE_ID, ALLELE_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOCS_ATTR_XCPTN ON OCS_ATTR_XCPTN
(OCS_ATTR_XCPTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOCS_FACILITY_FORMULARY_R ON OCS_FACILITY_FORMULARY_R
(OCS_FACILITY_FORMULARY_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOCS_FACILITY_R ON OCS_FACILITY_R
(SYNONYM_ID, FACILITY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_DAY_OF_MONTH ON OPS_DAY_OF_MONTH
(OPS_DAY_OF_MONTH_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_DAY_OF_WEEK ON OPS_DAY_OF_WEEK
(OPS_DAY_OF_WEEK_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_SCHEDULE_JOB_STEP ON OPS_SCHEDULE_JOB_STEP
(OPS_SCHEDULE_JOB_STEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKOPS_SCHED_DEP ON OPS_SCHED_DEP
(OPS_SCHED_DEP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORC_CUSTOM_SEL ON ORC_CUSTOM_SEL
(ORC_CUSTOM_SEL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORC_CUSTOM_SEL_RELTN ON ORC_CUSTOM_SEL_RELTN
(ORC_CUSTOM_SEL_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORC_RESOURCE_LIST ON ORC_RESOURCE_LIST
(SERVICE_RESOURCE_CD, CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_AUTHORITY ON PBS_AUTHORITY
(PBS_AUTHORITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_CAUTION_RELTN ON PBS_CAUTION_RELTN
(PBS_CAUTION_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_DRUG ON PBS_DRUG
(PBS_DRUG_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPBS_OCS_MAPPING ON PBS_OCS_MAPPING
(PBS_OCS_MAPPING_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPCA_MEASURE_OUTCOME_RELTN ON PCA_MEASURE_OUTCOME_RELTN
(PCA_MEASURE_OUTCOME_RELTN_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPFT_SEL_TASK_R ON PFT_SEL_TASK_R
(PFT_SEL_TASK_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPFT_SUB_TYPE_SECURITY ON PFT_SUB_TYPE_SECURITY
(PFT_SUB_TYPE_SECURITY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPG_AVAIL_RESPONSE ON PG_AVAIL_RESPONSE
(PG_AVAIL_RESPONSE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPG_AVAIL_RESPONSE_LIST ON PG_AVAIL_RESPONSE_LIST
(PG_AVAIL_RESPONSE_LIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPG_AVAIL_RESPONSE_R ON PG_AVAIL_RESPONSE_R
(PG_AVAIL_RESPONSE_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPG_RESULT_LIST ON PG_RESULT_LIST
(PG_RESULT_LIST_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPM_RPT_GROUP ON PM_RPT_GROUP
(GROUP_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPOSITIVE_TUBES ON POSITIVE_TUBES
(LOT_NUMBER_ID, ALLELE_CD, TUBE_NUMBER)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKPROFILE_TASK_R ON PROFILE_TASK_R
(CATALOG_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKQC_SCHD_STEP_CTRL_ASSAY ON QC_SCHD_STEP_CTRL_ASSAY
(QC_SCHD_STEP_CTRL_ASSAY_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKRAD_TECH_FMT_ERPRC_OVRD ON RAD_TECH_FMT_ERPRC_OVRD
(FORMAT_OVRD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREPLACE_GROUPING ON REPLACE_GROUPING
(CATALOG_CD, REPLACE_CATALOG_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKREPORT_INPROC_STATUS ON REPORT_INPROC_STATUS
(CATALOG_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKROUND_ROBIN_COMMENT ON ROUND_ROBIN_COMMENT
(ROUND_ROBIN_REF_ID, ACCESSION_ID, SERVICE_RESOURCE_CD, SEQUENCE)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSCH_APPT_ORD ON SCH_APPT_ORD
(APPT_TYPE_CD, REQUIRED_IND, SEQ_NBR)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSCR_PARAGRAPH ON SCR_PARAGRAPH
(SCR_PATTERN_ID, SCR_PARAGRAPH_TYPE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSELECTED_CRITERIA ON SELECTED_CRITERIA
(SELECTED_CRITERIA_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSIGN_LINE_LAYOUT_FIELD_R ON SIGN_LINE_LAYOUT_FIELD_R
(SIGN_LINE_LAYOUT_FIELD_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSI_OEN_CHANN_ENDPOINT_R ON SI_OEN_CHANN_ENDPOINT_R
(SI_OEN_CHANN_ENDPOINT_R_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSN_CT_DISPLAY_FIELD ON SN_CT_DISPLAY_FIELD
(SN_CT_DISPLAY_FIELD_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKSTRT_BMDI_MODEL_NOMENCLA ON STRT_BMDI_MODEL_NOMENCLATURE
(STRT_MODEL_NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKTPL_APPL_DETAIL ON TPL_APPL_DETAIL
(APPL_DETAIL_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKUCMR_CASE_GRP_STEP_R ON UCMR_CASE_GRP_STEP_R
(UCMR_CASE_GRP_STEP_R_ID)
LOGGING
NOPARALLEL;


CREATE TABLE ALPHA_RESPONSES
(
  REFERENCE_RANGE_FACTOR_ID    NUMBER           DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID              NUMBER           DEFAULT 0                     NOT NULL,
  SEQUENCE                     NUMBER           DEFAULT 0                     NOT NULL,
  USE_UNITS_IND                NUMBER,
  RESULT_PROCESS_CD            NUMBER           DEFAULT 0                     NOT NULL,
  DEFAULT_IND                  NUMBER,
  DESCRIPTION                  VARCHAR2(100 BYTE),
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER,
  ACTIVE_STATUS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM          DATE,
  ACTIVE_STATUS_PRSNL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE             DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM          DATE             DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  RESULT_VALUE                 NUMBER,
  REFERENCE_IND                NUMBER,
  MULTI_ALPHA_SORT_ORDER       NUMBER,
  ALPHA_RESPONSES_CATEGORY_ID  NUMBER           DEFAULT 0                     NOT NULL,
  CONCEPT_CKI                  VARCHAR2(255 BYTE) DEFAULT ' ',
  TRUTH_STATE_CD               NUMBER           DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALPHA_RESPONSE_RULE
(
  ALPHA_RESPONSE_RULE_ID     NUMBER             DEFAULT 0                     NOT NULL,
  REF_RANGE_FACTOR_RULE_ID   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID     NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM        DATE,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  REFERENCE_RANGE_FACTOR_ID  NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_POPUPACTIVITY
(
  PA_WINDOW_ID     NUMBER                       DEFAULT 0                     NOT NULL,
  PA_ACTION_ID     NUMBER                       DEFAULT 0                     NOT NULL,
  PA_NUM_MATCHS    NUMBER,
  PA_NUM_SUCCESS   NUMBER,
  PA_LAST_RUN_ID   NUMBER                       DEFAULT 0                     NOT NULL,
  PA_LAST_STEP_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_ADEQUACY_ALPHA_R
(
  TASK_ASSAY_CD        NUMBER                   DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  ADEQUACY_FLAG        NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  REASON_REQUIRED_IND  NUMBER,
  CATALOG_CD           NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_DIAG_DISCREPANCY
(
  REFERENCE_RANGE_FACTOR_ID  NUMBER             DEFAULT 0                     NOT NULL,
  NOMENCLATURE_X_ID          NUMBER             DEFAULT 0                     NOT NULL,
  NOMENCLATURE_Y_ID          NUMBER             DEFAULT 0                     NOT NULL,
  HCFA_FLAG                  NUMBER,
  INTERNAL_FLAG              NUMBER,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_ENDOCERV_ALPHA_R
(
  TASK_ASSAY_CD    NUMBER                       DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  ENDOCERV_IND     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  CATALOG_CD       NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ORDER_TASK_PROFILE_XREF
(
  CATALOG_CD         NUMBER                     DEFAULT 0                     NOT NULL,
  REFERENCE_TASK_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD      NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE INDEX XIE1ALPHA_RESPONSES ON ALPHA_RESPONSES
(NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE1ALPHA_RESPONSE_RULE ON ALPHA_RESPONSE_RULE
(REF_RANGE_FACTOR_RULE_ID, REFERENCE_RANGE_FACTOR_ID, NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIE2ALPHA_RESPONSES ON ALPHA_RESPONSES
(ALPHA_RESPONSES_CATEGORY_ID)
LOGGING
NOPARALLEL;


CREATE INDEX XIF29ORDER_TASK_PROFILE_XREF ON ORDER_TASK_PROFILE_XREF
(CATALOG_CD, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF74CYTO_ENDOCERV_ALPHA_R ON CYTO_ENDOCERV_ALPHA_R
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE INDEX XIF75CYTO_ADEQUACY_ALPHA_R ON CYTO_ADEQUACY_ALPHA_R
(TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKALPHA_RESPONSES ON ALPHA_RESPONSES
(REFERENCE_RANGE_FACTOR_ID, NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKALPHA_RESPONSE_RULE ON ALPHA_RESPONSE_RULE
(ALPHA_RESPONSE_RULE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKAT_POPUPACTIVITY ON AT_POPUPACTIVITY
(PA_WINDOW_ID, PA_ACTION_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCYTO_ADEQUACY_ALPHA_R ON CYTO_ADEQUACY_ALPHA_R
(CATALOG_CD, TASK_ASSAY_CD, NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCYTO_DIAG_DISCREPANCY ON CYTO_DIAG_DISCREPANCY
(REFERENCE_RANGE_FACTOR_ID, NOMENCLATURE_X_ID, NOMENCLATURE_Y_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKCYTO_ENDOCERV_ALPHA_R ON CYTO_ENDOCERV_ALPHA_R
(CATALOG_CD, TASK_ASSAY_CD, NOMENCLATURE_ID)
LOGGING
NOPARALLEL;


CREATE UNIQUE INDEX XPKORDER_TASK_PROFILE_XREF ON ORDER_TASK_PROFILE_XREF
(CATALOG_CD, REFERENCE_TASK_ID, TASK_ASSAY_CD)
LOGGING
NOPARALLEL;


CREATE TABLE ABN_RULE
(
  ABN_RULE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  FIN_CLASS_CD            NUMBER                DEFAULT 0                     NOT NULL,
  CARRIER_ID              NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_TYPE_CD          NUMBER                DEFAULT 0                     NOT NULL,
  CPT_NOMEN_ID            NUMBER                DEFAULT 0                     NOT NULL,
  ICD9_NOMEN_ID           NUMBER                DEFAULT 0                     NOT NULL,
  VALID_DIAG_FLG          NUMBER                DEFAULT 0,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  URL                     VARCHAR2(100 BYTE),
  AGE_RESTRICTION_CODE    VARCHAR2(50 BYTE),
  SEX_RESTRICTION_CODE    VARCHAR2(10 BYTE),
  ACTION_CD               NUMBER                DEFAULT 0                     NOT NULL,
  ACTION_CD_DT_TM         DATE,
  HEALTH_PLAN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  POLICY_NUMBER           NUMBER,
  POLICY_NAME             VARCHAR2(100 BYTE),
  POLICY_DISCRIPTION      VARCHAR2(200 BYTE),
  TYPE_CD                 NUMBER                DEFAULT 0                     NOT NULL,
  PARAMETER_CD            NUMBER                DEFAULT 0                     NOT NULL,
  FREQUENCY_REST_CODE     VARCHAR2(50 BYTE),
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  INFOX_POLICY_NUMBER     VARCHAR2(100 BYTE),
  MEDICARE_POLICY_NUMBER  VARCHAR2(100 BYTE),
  FIN_GROUP_CD            NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_GROUP_CD         NUMBER                DEFAULT 0                     NOT NULL,
  ACTION_CODE             VARCHAR2(200 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ABO_TESTING
(
  ABO_TESTING_ID          NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ABO_GROUP_CD            NUMBER                DEFAULT 0                     NOT NULL,
  RH_TYPE_CD              NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CURRENT_UPDATED_IND     NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ABSTRACTING
(
  ABSTRACTING_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  COMPLETED_DT_TM         DATE,
  CREATE_DT_TM            DATE,
  CREATE_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  SVC_CAT_HIST_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_SLICE_ID         NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ABSTRACT_DATA
(
  ABSTRACT_DATA_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ABSTRACT_FIELD_DEF_CD   NUMBER                DEFAULT 0                     NOT NULL,
  ABSTRACT_FIELD_TYPE_CD  NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  VALUE_FREE_TEXT         VARCHAR2(255 BYTE),
  VALUE_CD                NUMBER                DEFAULT 0                     NOT NULL,
  VALUE_DT_TM             DATE,
  VALUE_NUMBER            NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  SVC_CAT_HIST_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_SLICE_ID         NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ABST_CODING_RELTN
(
  ABST_CODING_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  ABSTRACT_FIELD_DEF_CD   NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(255 BYTE),
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  SVC_CAT_HIST_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_SLICE_ID         NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCEPT_QUAR_PROD_R
(
  ACCEPT_QUAR_PROD_ID     NUMBER                DEFAULT 0                     NOT NULL,
  ACCEPT_QUAR_REASON_ID   NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_CD              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCEPT_QUAR_REASON
(
  ACCEPT_QUAR_REASON_ID   NUMBER                DEFAULT 0                     NOT NULL,
  ORG_SHIPMENT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  QUAR_REASON_CD          NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCESSION_ORDER_R
(
  ACCESSION_ID      NUMBER                      DEFAULT 0                     NOT NULL,
  ORDER_ID          NUMBER                      DEFAULT 0                     NOT NULL,
  ACCESSION         VARCHAR2(20 BYTE),
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  PRIMARY_IND       NUMBER,
  ACTIVITY_TYPE_CD  NUMBER                      DEFAULT 0                     NOT NULL,
  PRIMARY_FLAG      NUMBER                      DEFAULT 0                     NOT NULL,
  RESTRICT_AV_IND   NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCOUNT
(
  ACCT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  ACCT_TEMPL_ID              NUMBER             DEFAULT 0                     NOT NULL,
  ACCT_TYPE_CD               NUMBER             DEFAULT 0                     NOT NULL,
  EXT_ACCT_ID_TXT            CHAR(50 BYTE),
  ACCT_DESC                  VARCHAR2(250 BYTE),
  ACCT_STATUS_CD             NUMBER             DEFAULT 0                     NOT NULL,
  ACCT_BALANCE               FLOAT(126),
  HI_ACCT_BALANCE            FLOAT(126),
  CONSOLIDATION_IND          NUMBER,
  STATUS_REASON_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_IND                 NUMBER,
  ACTIVE_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM        DATE,
  ACTIVE_STATUS_PRSNL_ID     NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  DR_CR_FLAG                 NUMBER,
  COL_LETTER_IND             NUMBER,
  DUNNING_IND                NUMBER,
  EXT_ACCT_ID_TXT_KEY        VARCHAR2(250 BYTE),
  PENDING_ACCT_BAL           FLOAT(126),
  PEND_DR_CR_FLAG            NUMBER,
  PRSNL_SEC_IND              NUMBER,
  SEND_COL_IND               NUMBER,
  ACCT_SUB_TYPE_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ADJUSTMENT_BALANCE         FLOAT(126),
  ADJ_BAL_DR_CR_FLAG         NUMBER,
  APPLIED_PAYMENT_BALANCE    FLOAT(126),
  CHARGE_BALANCE             FLOAT(126),
  CHRG_BAL_DR_CR_FLAG        NUMBER,
  UNAPPLIED_PAYMENT_BALANCE  FLOAT(126),
  CREATED_DT_TM              DATE               DEFAULT SYSDATE,
  CREATED_PRSNL_ID           NUMBER             DEFAULT 0                     NOT NULL,
  LAST_CHARGE_DT_TM          DATE,
  LAST_PAYMENT_DT_TM         DATE,
  PAYMENT_PLAN_IND           NUMBER,
  BAD_DEBT_BALANCE           FLOAT(126)         DEFAULT 0.0                   NOT NULL,
  BAD_DEBT_BAL_DR_CR_FLAG    NUMBER             DEFAULT 0                     NOT NULL,
  SUPPRESS_FLAG              NUMBER             DEFAULT 0                     NOT NULL,
  GLOBAL_OVERRIDE_IND        NUMBER             DEFAULT 0                     NOT NULL,
  SUPPRESS_IND               NUMBER             DEFAULT 0                     NOT NULL,
  LAST_ADJUSTMENT_DT_TM      DATE,
  LAST_CLAIM_DT_TM           DATE,
  LAST_STMT_DT_TM            DATE,
  LAST_PATIENT_PAY_DT_TM     DATE,
  BILLING_ENTITY_ID          NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCRED_SYSTEM
(
  ACCRED_SYSTEM_ID          NUMBER              DEFAULT 0                     NOT NULL,
  ACCRED_SYSTEM_IDENT       VARCHAR2(250 BYTE)  DEFAULT ' '                   NOT NULL,
  ORGANIZATION_ID           NUMBER              DEFAULT 0                     NOT NULL,
  SERVICE_NAME              VARCHAR2(250 BYTE)  DEFAULT ' '                   NOT NULL,
  INTERACTION_NAME          VARCHAR2(250 BYTE)  DEFAULT ' '                   NOT NULL,
  INTERACTION_VERSION_TEXT  VARCHAR2(250 BYTE)  DEFAULT ' '                   NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  PARTY_KEY_TXT             VARCHAR2(250 BYTE)  DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCT_BALANCE
(
  ACCOUNT_SUB_TYPE_CD     NUMBER                DEFAULT 0                     NOT NULL,
  ACCOUNT_TYPE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_BALANCE            FLOAT(126),
  ACCT_BALANCE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_BAL_DR_CR_FLAG     NUMBER,
  ACCT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ADJUSTMENTS             FLOAT(126),
  ADJ_DR_CR_FLAG          NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CHARGES                 FLOAT(126),
  CHRG_DR_CR_FLAG         NUMBER,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  EXT_ACCT_ID_TXT         CHAR(50 BYTE),
  PAYMENTS                FLOAT(126),
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PMTS_DR_CR_FLAG         NUMBER,
  PREVIOUS_BALANCE        FLOAT(126),
  PREVIOUS_DR_CR_FLAG     NUMBER,
  RAW_ACCT_BALANCE        FLOAT(126),
  RAW_ACCT_BALANCE_FLAG   NUMBER,
  UPDATE_IND              NUMBER,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  TRANSFER_AMOUNT         FLOAT(126),
  TRANSFER_DR_CR_FLAG     NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCT_GROUP_RELTN
(
  ACCT_GROUP_R_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  BT_COND_CRIT_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCT_PRSNL_GROUP_R
(
  ACCT_PRSNL_GROUP_R_ID   NUMBER                DEFAULT 0                     NOT NULL,
  PFT_PRSNL_GROUP_ID      NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACCT_TYPE_GL_ALIAS_RELTN
(
  ACCT_TYPE_GL_ALIAS_RELTN_ID  NUMBER           DEFAULT 0                     NOT NULL,
  ACCT_TYPE_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  GL_ALIAS_ID                  NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER,
  ACTIVE_STATUS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM          DATE,
  ACTIVE_STATUS_PRSNL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE             DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM          DATE             DEFAULT TO_DATE ( '12/31/210000:00:00' , 'MM/DD/YYYYHH24:MI:SS' ),
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACQUIREMENT_INFO
(
  LOCATION_CD               NUMBER              DEFAULT 0                     NOT NULL,
  ITEM_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  PRIMARY_VENDOR_ITEM_ID    NUMBER              DEFAULT 0                     NOT NULL,
  REORDER_PACKAGE_TYPE_ID   NUMBER              DEFAULT 0                     NOT NULL,
  FILL_LOCATION_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ECONOMIC_ORDER_QTY        NUMBER,
  AVERAGE_LEAD_TIME         NUMBER,
  AVERAGE_LEAD_TIME_UOM_CD  NUMBER              DEFAULT 0                     NOT NULL,
  PRODUCT_ORIGIN_CD         NUMBER              DEFAULT 0                     NOT NULL,
  SYSCALC_EOQ_IND           NUMBER,
  PRIMARY_VENDOR_CD         NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  VENDOR_SITE_ID            NUMBER              DEFAULT 0                     NOT NULL,
  CONSIGNMENT_IND           NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACTIVITY_DATA_RELTN
(
  ACTIVITY_DATA_RELTN_ID   NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVITY_ENTITY_NAME     VARCHAR2(30 BYTE)    DEFAULT ' '                   NOT NULL,
  ACTIVITY_ENTITY_ID       NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVITY_ENTITY_INST_ID  NUMBER               DEFAULT 0                     NOT NULL,
  RELTN_ENTITY_NAME        VARCHAR2(30 BYTE)    DEFAULT ' '                   NOT NULL,
  RELTN_ENTITY_ID          NUMBER               DEFAULT 0                     NOT NULL,
  RELTN_ENTITY_ALL_IND     NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACTIVITY_LOG
(
  ACTIVITY_ID             NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVITY_TYPE_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVITY_DT_TM          DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CREATED_DT_TM           DATE                  DEFAULT SYSDATE,
  CREATED_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ACTION_CODE             VARCHAR2(20 BYTE),
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCTIVITY_FLAG       NUMBER,
  PRODUCTIVITY_WEIGHT     FLOAT(126)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACTIVITY_PRIVILEGE_RELTN
(
  ACTIVITY_PRIVILEGE_RELTN_ID  NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVITY_PRIVILEGE_DEF_ID    NUMBER           DEFAULT 0                     NOT NULL,
  PRIVILEGE_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM          DATE             DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_CARE_CAT
(
  ACT_CARE_CAT_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  CARE_CATEGORY_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  CARE_CATEGORY_CD       NUMBER                 DEFAULT 0                     NOT NULL,
  PATHWAY_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE               NUMBER                 DEFAULT 0                     NOT NULL,
  DESCRIPTION            VARCHAR2(100 BYTE)     DEFAULT ' '                   NOT NULL,
  ACTIVE_IND             NUMBER,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  RESTRICT_COMP_ADD_IND  NUMBER,
  COMP_ADD_VARIANCE_IND  NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_PW_COMP
(
  ACT_PW_COMP_ID                  NUMBER        DEFAULT 0                     NOT NULL,
  ACT_TIME_FRAME_ID               NUMBER        DEFAULT 0                     NOT NULL,
  ACT_CARE_CAT_ID                 NUMBER        DEFAULT 0                     NOT NULL,
  SEQUENCE                        NUMBER        DEFAULT 0                     NOT NULL,
  PATHWAY_ID                      NUMBER        DEFAULT 0                     NOT NULL,
  PATHWAY_COMP_ID                 NUMBER        DEFAULT 0                     NOT NULL,
  COMP_TYPE_CD                    NUMBER        DEFAULT 0                     NOT NULL,
  REF_PRNT_ENT_NAME               VARCHAR2(32 BYTE),
  REF_PRNT_ENT_ID                 NUMBER        DEFAULT 0                     NOT NULL,
  REPEAT_IND                      NUMBER,
  REQUIRED_IND                    NUMBER,
  COMP_STATUS_CD                  NUMBER        DEFAULT 0                     NOT NULL,
  ENCNTR_ID                       NUMBER        DEFAULT 0                     NOT NULL,
  PERSON_ID                       NUMBER        DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME              VARCHAR2(32 BYTE),
  PARENT_ENTITY_ID                NUMBER        DEFAULT 0                     NOT NULL,
  ORIG_PRNT_ENT_ID                NUMBER        DEFAULT 0                     NOT NULL,
  EXISTING_IND                    NUMBER,
  COMP_LABEL                      VARCHAR2(255 BYTE),
  RELATED_COMP_ID                 NUMBER        DEFAULT 0                     NOT NULL,
  AFTER_QTY                       NUMBER,
  AGE_UNITS_CD                    NUMBER        DEFAULT 0                     NOT NULL,
  CREATED_DT_TM                   DATE,
  INCLUDED_IND                    NUMBER,
  INCLUDED_DT_TM                  DATE,
  CANCELED_IND                    NUMBER,
  CANCELED_DT_TM                  DATE,
  ACTIVATED_IND                   NUMBER,
  ACTIVATED_PRSNL_ID              NUMBER        DEFAULT 0                     NOT NULL,
  ACTIVATED_DT_TM                 DATE,
  ACTIVE_IND                      NUMBER,
  LAST_ACTION_SEQ                 NUMBER,
  UPDT_DT_TM                      DATE          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                         NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_TASK                       NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_CNT                        NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                    NUMBER        DEFAULT 0                     NOT NULL,
  DURATION_QTY                    NUMBER,
  DURATION_UNIT_CD                NUMBER        DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD                   NUMBER        DEFAULT 0                     NOT NULL,
  EVENT_CD                        NUMBER        DEFAULT 0                     NOT NULL,
  RESULT_TYPE_CD                  NUMBER        DEFAULT 0                     NOT NULL,
  OUTCOME_OPERATOR_CD             NUMBER        DEFAULT 0                     NOT NULL,
  RESULT_VALUE                    FLOAT(126),
  RESULT_UNITS_CD                 NUMBER        DEFAULT 0                     NOT NULL,
  CAPTURE_VARIANCE_IND            NUMBER,
  VARIANCE_REQUIRED_IND           NUMBER,
  DCP_FORMS_REF_ID                NUMBER        DEFAULT 0                     NOT NULL,
  START_DT_TM                     DATE,
  END_DT_TM                       DATE,
  COND_IND                        NUMBER,
  COND_DESC                       VARCHAR2(100 BYTE),
  COND_NOTE_ID                    NUMBER        DEFAULT 0                     NOT NULL,
  COND_MODULE_NAME                VARCHAR2(30 BYTE),
  COND_FALSE_IND                  NUMBER,
  COND_EVAL_DT_TM                 DATE,
  COND_EVAL_IND                   NUMBER,
  COND_EVAL_RESULT_IND            NUMBER,
  RRF_AGE_QTY                     NUMBER,
  RRF_AGE_UNITS_CD                NUMBER        DEFAULT 0                     NOT NULL,
  RRF_SEX_CD                      NUMBER        DEFAULT 0                     NOT NULL,
  COND_SYS_EVAL_IND               NUMBER,
  COND_EVAL_PRSNL_ID              NUMBER        DEFAULT 0                     NOT NULL,
  REFERENCE_TASK_ID               NUMBER        DEFAULT 0                     NOT NULL,
  LINKED_TO_TF_IND                NUMBER,
  OUTCOME_FORMS_REF_ID            NUMBER        DEFAULT 0                     NOT NULL,
  DCP_CLIN_CAT_CD                 NUMBER        DEFAULT 0                     NOT NULL,
  DCP_CLIN_SUB_CAT_CD             NUMBER        DEFAULT 0                     NOT NULL,
  PERSISTENT_IND                  NUMBER,
  ORDER_SENTENCE_ID               NUMBER        DEFAULT 0                     NOT NULL,
  OFFSET_QUANTITY                 FLOAT(126),
  OFFSET_UNIT_CD                  NUMBER,
  DEFAULT_ORD_SENT_DISP           VARCHAR2(255 BYTE),
  CHEMO_RELATED_IND               NUMBER        DEFAULT 0,
  CHEMO_IND                       NUMBER        DEFAULT 0,
  CROSS_PHASE_GROUP_IND           NUMBER        DEFAULT 0,
  CROSS_PHASE_GROUP_NBR           FLOAT(126)    DEFAULT 0,
  LONG_BLOB_ID                    NUMBER        DEFAULT 0,
  CREATED_TZ                      NUMBER,
  ACTIVATED_TZ                    NUMBER,
  INCLUDED_TZ                     NUMBER,
  DOSE_INFO_HIST_BLOB_ID          NUMBER        DEFAULT 0,
  DEFAULT_OS_IND                  NUMBER        DEFAULT 1,
  MISSING_REQUIRED_IND            NUMBER        DEFAULT 0,
  ACT_PW_COMP_GROUP_NBR           FLOAT(126)    DEFAULT 0,
  REJECT_PROTOCOL_REVIEW_IND      NUMBER        DEFAULT 0,
  MIN_TOLERANCE_INTERVAL_UNIT_CD  NUMBER        DEFAULT 0,
  MIN_TOLERANCE_INTERVAL          NUMBER        DEFAULT 0,
  DISPLAY_FORMAT_XML              VARCHAR2(1000 BYTE) DEFAULT ' ',
  UNLINK_START_DT_TM_IND          NUMBER        DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_PW_COMP_FOCUS_R
(
  ACT_PW_COMP_FOCUS_R_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACT_PW_COMP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PRIMARY_IND             NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_PW_COMP_G
(
  ACT_PW_COMP_G_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  PATHWAY_ID        NUMBER                      DEFAULT 0                     NOT NULL,
  ACT_PW_COMP_ID    NUMBER                      DEFAULT 0                     NOT NULL,
  TYPE_MEAN         VARCHAR2(12 BYTE)           DEFAULT ' '                   NOT NULL,
  PW_COMP_SEQ       NUMBER,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  INCLUDED_IND      NUMBER                      DEFAULT 0,
  DESCRIPTION       VARCHAR2(99 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_PW_COMP_R
(
  ACT_PW_COMP_S_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ACT_PW_COMP_T_ID        NUMBER                DEFAULT 0                     NOT NULL,
  TYPE_MEAN               VARCHAR2(12 BYTE)     DEFAULT ' '                   NOT NULL,
  OFFSET_QTY              NUMBER,
  OFFSET_UNIT_CD          NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  OFFSET_QUANTITY         FLOAT(126),
  PATHWAY_ID              NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_PW_FOCUS
(
  ACT_PW_FOCUS_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  PATHWAY_ID         NUMBER                     DEFAULT 0                     NOT NULL,
  PATHWAY_LEVEL_IND  NUMBER                     DEFAULT 0                     NOT NULL,
  STATUS_CD          NUMBER                     DEFAULT 0                     NOT NULL,
  STATUS_DT_TM       DATE                       DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  STATUS_PRSNL_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  LAST_ACTION_SEQ    NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  ACTIVE_IND         NUMBER                     DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  SEQUENCE           NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACT_PW_FOCUS_ACTION
(
  ACT_PW_FOCUS_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  ACTION_SEQ       NUMBER                       DEFAULT 0                     NOT NULL,
  STATUS_CD        NUMBER                       DEFAULT 0                     NOT NULL,
  ACTION_DT_TM     DATE                         DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTION_PRSNL_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ACUTE_CARE_AUDIT_INFO
(
  ACUTE_CARE_AUDIT_INFO_ID  NUMBER              DEFAULT 0                     NOT NULL,
  AUDIT_PATIENT_ID          NUMBER              DEFAULT 0                     NOT NULL,
  AUDIT_PRSNL_ID            NUMBER              DEFAULT 0                     NOT NULL,
  POSITION_CD               NUMBER              DEFAULT 0                     NOT NULL,
  AUDIT_SOLUTION_CD         NUMBER              DEFAULT 0                     NOT NULL,
  AUDIT_EVENT_TYPE_CD       NUMBER              DEFAULT 0                     NOT NULL,
  AUDIT_EVENT_DT_TM         DATE                DEFAULT SYSDATE               NOT NULL,
  AUDIT_FACILITY_CD         NUMBER              DEFAULT 0                     NOT NULL,
  AUDIT_INFORMATION_TEXT    VARCHAR2(255 BYTE),
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AC_CLASS_DEF
(
  AC_CLASS_DEF_ID               NUMBER          DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID             NUMBER          DEFAULT 0                     NOT NULL,
  CLASS_TYPE_FLAG               NUMBER          DEFAULT 0                     NOT NULL,
  CLASS_DISPLAY_NAME            VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  CLASS_DISPLAY_NAME_KEY        VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  BEGIN_EFFECTIVE_DT_TM         DATE            DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM           DATE            DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  CLASS_DISPLAY_NAME_KEY_A_NLS  VARCHAR2(1020 BYTE) DEFAULT ' ' NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AC_CLASS_HE_RULE
(
  AC_CLASS_HE_RULE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  AC_CLASS_DEF_ID         NUMBER                DEFAULT 0                     NOT NULL,
  HEALTH_EXPERT_RULE_TXT  VARCHAR2(255 BYTE)    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AC_CLASS_PERSON_RELTN
(
  AC_CLASS_PERSON_RELTN_ID      NUMBER          DEFAULT 0                     NOT NULL,
  PARENT_CLASS_PERSON_RELTN_ID  NUMBER          DEFAULT 0                     NOT NULL,
  PERSON_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  AC_CLASS_DEF_ID               NUMBER          DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID               NUMBER          DEFAULT 0                     NOT NULL,
  LOCATION_CD                   NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  BEGIN_EFFECTIVE_DT_TM         DATE            DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM           DATE            DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  INDEPENDENT_PARENT_IND        NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ADDITIONAL_AMOUNT_DEF
(
  ADDITIONAL_AMOUNT_DEF_ID  NUMBER              DEFAULT 0                     NOT NULL,
  ITEM_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  LOCATION_CD               NUMBER              DEFAULT 0                     NOT NULL,
  ADDITIONAL_AMOUNT_CD      NUMBER              DEFAULT 0                     NOT NULL,
  INCLUDE_EXCLUDE_IND       NUMBER              DEFAULT 0                     NOT NULL,
  COST_CENTER_CD            NUMBER              DEFAULT 0                     NOT NULL,
  SUB_ACCOUNT_CD            NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID           NUMBER              DEFAULT 0                     NOT NULL,
  TAX_TYPE_CD               NUMBER              DEFAULT 0,
  TAX_OVERRIDE_IND          NUMBER              DEFAULT 0,
  TAX_VALUE                 FLOAT(126)          DEFAULT 0,
  TAX_VALUE_FLAG            NUMBER              DEFAULT 0,
  LOGICAL_DOMAIN_ID         NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ADDRESS_HIST
(
  ADDRESS_HIST_ID             NUMBER            DEFAULT 0                     NOT NULL,
  PM_HIST_TRACKING_ID         NUMBER            DEFAULT 0                     NOT NULL,
  TRANSACTION_DT_TM           DATE,
  CHANGE_BIT                  NUMBER            DEFAULT 0                     NOT NULL,
  TRACKING_BIT                NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID            NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME          VARCHAR2(30 BYTE),
  ADDRESS_ID                  NUMBER            DEFAULT 0                     NOT NULL,
  ADDRESS_TYPE_CD             NUMBER            DEFAULT 0                     NOT NULL,
  RESIDENCE_TYPE_CD           NUMBER            DEFAULT 0                     NOT NULL,
  COMMENT_TXT                 VARCHAR2(200 BYTE),
  STREET_ADDR                 VARCHAR2(100 BYTE),
  STREET_ADDR2                VARCHAR2(100 BYTE),
  STREET_ADDR3                VARCHAR2(100 BYTE),
  STREET_ADDR4                VARCHAR2(100 BYTE),
  CITY                        VARCHAR2(100 BYTE),
  STATE                       VARCHAR2(100 BYTE),
  STATE_CD                    NUMBER            DEFAULT 0                     NOT NULL,
  ZIPCODE                     VARCHAR2(25 BYTE),
  COUNTY                      VARCHAR2(100 BYTE),
  COUNTY_CD                   NUMBER            DEFAULT 0                     NOT NULL,
  COUNTRY                     VARCHAR2(100 BYTE),
  COUNTRY_CD                  NUMBER            DEFAULT 0                     NOT NULL,
  RESIDENCE_CD                NUMBER            DEFAULT 0                     NOT NULL,
  MAIL_STOP                   VARCHAR2(100 BYTE),
  ADDRESS_INFO_STATUS_CD      NUMBER            DEFAULT 0                     NOT NULL,
  CONTACT_NAME                VARCHAR2(200 BYTE),
  ACTIVE_IND                  NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE              DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  OPERATION_HOURS             VARCHAR2(255 BYTE),
  POSTAL_IDENTIFIER           VARCHAR2(100 BYTE),
  PARENT_BEG_EFFECTIVE_DT_TM  DATE              DEFAULT SYSDATE,
  PARENT_END_EFFECTIVE_DT_TM  DATE              DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  CITY_CD                     NUMBER            DEFAULT 0,
  VALIDATION_EXPIRE_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_BENEFIT_LEVEL_DATA
(
  AGS_BENEFIT_LEVEL_DATA_ID  NUMBER             DEFAULT 0                     NOT NULL,
  AGS_JOB_ID                 NUMBER             DEFAULT 0                     NOT NULL,
  RUN_NBR                    NUMBER,
  RUN_DT_TM                  DATE,
  FILE_ROW_NBR               NUMBER,
  SENDING_FACILITY           VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD      NUMBER             DEFAULT 0                     NOT NULL,
  PERSON_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  EXT_ALIAS                  VARCHAR2(100 BYTE),
  SSN_ALIAS                  VARCHAR2(100 BYTE),
  NAME_LAST                  VARCHAR2(100 BYTE),
  NAME_FIRST                 VARCHAR2(100 BYTE),
  BIRTH_DATE                 VARCHAR2(20 BYTE),
  GENDER                     VARCHAR2(20 BYTE),
  BENEFIT_LEVEL              VARCHAR2(20 BYTE),
  BENEFIT_START_DATE_TXT     VARCHAR2(20 BYTE),
  INPATIENT_HOSP_COUNT_TXT   VARCHAR2(20 BYTE),
  OUTPATIENT_COUNT_TXT       VARCHAR2(20 BYTE),
  PHYSICIAN_COUNT_TXT        VARCHAR2(20 BYTE),
  INPATIENT_PHYS_COUNT_TXT   VARCHAR2(20 BYTE),
  LAB_XRAY_COUNT_TXT         VARCHAR2(20 BYTE),
  HEALTH_COUNT_TXT           VARCHAR2(20 BYTE),
  STATUS                     VARCHAR2(12 BYTE),
  STATUS_DT_TM               DATE,
  STAT_MSG                   VARCHAR2(40 BYTE),
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  BENEFIT_END_DATE_TXT       VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_CLAIM_DATA
(
  AGS_CLAIM_DATA_ID       NUMBER                DEFAULT 0                     NOT NULL,
  AGS_JOB_ID              NUMBER                DEFAULT 0                     NOT NULL,
  RUN_NBR                 NUMBER,
  RUN_DT_TM               DATE,
  FILE_ROW_NBR            NUMBER,
  SENDING_FACILITY        VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  HEA_CLAIM_VISIT_ID      NUMBER                DEFAULT 0                     NOT NULL,
  CLAIM_IDENTIFIER        VARCHAR2(100 BYTE),
  PREV_CLAIM_IDENTIFIER   VARCHAR2(100 BYTE),
  ACTION                  VARCHAR2(20 BYTE),
  EXT_ALIAS               VARCHAR2(100 BYTE),
  SSN_ALIAS               VARCHAR2(100 BYTE),
  NAME_LAST               VARCHAR2(100 BYTE),
  NAME_FIRST              VARCHAR2(100 BYTE),
  BIRTH_DATE              VARCHAR2(20 BYTE),
  GENDER                  VARCHAR2(20 BYTE),
  START_SERVICE_DATE      VARCHAR2(20 BYTE),
  END_SERVICE_DATE        VARCHAR2(20 BYTE),
  VISIT_TYPE              VARCHAR2(20 BYTE),
  BILLING_EXT_ALIAS       VARCHAR2(100 BYTE),
  ADMITTING_EXT_ALIAS     VARCHAR2(100 BYTE),
  ATTENDING_EXT_ALIAS     VARCHAR2(100 BYTE),
  PROCEDURE1              VARCHAR2(50 BYTE),
  PROCEDURE2              VARCHAR2(50 BYTE),
  PROCEDURE3              VARCHAR2(50 BYTE),
  PROCEDURE4              VARCHAR2(50 BYTE),
  PROCEDURE5              VARCHAR2(50 BYTE),
  PROCEDURE6              VARCHAR2(50 BYTE),
  PROCEDURE7              VARCHAR2(50 BYTE),
  PROCEDURE8              VARCHAR2(50 BYTE),
  PROCEDURE9              VARCHAR2(50 BYTE),
  PROCEDURE10             VARCHAR2(50 BYTE),
  DIAGNOSIS1              VARCHAR2(50 BYTE),
  DIAGNOSIS2              VARCHAR2(50 BYTE),
  DIAGNOSIS3              VARCHAR2(50 BYTE),
  DIAGNOSIS4              VARCHAR2(50 BYTE),
  DIAGNOSIS5              VARCHAR2(50 BYTE),
  DIAGNOSIS6              VARCHAR2(50 BYTE),
  DIAGNOSIS7              VARCHAR2(50 BYTE),
  DIAGNOSIS8              VARCHAR2(50 BYTE),
  DIAGNOSIS9              VARCHAR2(50 BYTE),
  DIAGNOSIS10             VARCHAR2(50 BYTE),
  DIAGNOSIS11             VARCHAR2(50 BYTE),
  DIAGNOSIS12             VARCHAR2(50 BYTE),
  DIAGNOSIS13             VARCHAR2(50 BYTE),
  DIAGNOSIS14             VARCHAR2(50 BYTE),
  DIAGNOSIS15             VARCHAR2(50 BYTE),
  STATUS                  VARCHAR2(12 BYTE),
  STATUS_DT_TM            DATE,
  STAT_MSG                VARCHAR2(40 BYTE),
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ACCESS_IDENTIFIER_TYPE  VARCHAR2(20 BYTE),
  ACCESS_IDENTIFIER       VARCHAR2(100 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_CLAIM_DETAIL_DATA
(
  AGS_CLAIM_DETAIL_DATA_ID   NUMBER             DEFAULT 0                     NOT NULL,
  AGS_JOB_ID                 NUMBER             DEFAULT 0                     NOT NULL,
  RUN_NBR                    NUMBER,
  RUN_DT_TM                  DATE,
  FILE_ROW_NBR               NUMBER,
  SENDING_FACILITY           VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD      NUMBER             DEFAULT 0                     NOT NULL,
  PERSON_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  HEA_CLAIM_VISIT_ID         NUMBER             DEFAULT 0                     NOT NULL,
  HEA_CLAIM_VISIT_DETAIL_ID  NUMBER             DEFAULT 0                     NOT NULL,
  CLAIM_IDENTIFIER           VARCHAR2(100 BYTE),
  CLAIM_ACTION               VARCHAR2(20 BYTE),
  NAME_LAST                  VARCHAR2(100 BYTE),
  NAME_FIRST                 VARCHAR2(100 BYTE),
  SERVICE_DATE               VARCHAR2(20 BYTE),
  SEQ_NUM_TXT                VARCHAR2(20 BYTE),
  REVENUE_CODE               VARCHAR2(4 BYTE),
  HCPCS_CPT                  VARCHAR2(50 BYTE),
  STATUS                     VARCHAR2(12 BYTE),
  STATUS_DT_TM               DATE,
  STAT_MSG                   VARCHAR2(40 BYTE),
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_IMMUN_DATA
(
  AGS_IMMUN_DATA_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  AGS_JOB_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  RUN_NBR                NUMBER,
  RUN_DT_TM              DATE,
  FILE_ROW_NBR           NUMBER,
  SENDING_FACILITY       VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  EVENT_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  EVENT_CD               NUMBER                 DEFAULT 0                     NOT NULL,
  EXT_ALIAS              VARCHAR2(100 BYTE),
  SSN_ALIAS              VARCHAR2(100 BYTE),
  NAME_LAST              VARCHAR2(100 BYTE),
  NAME_FIRST             VARCHAR2(100 BYTE),
  BIRTH_DATE             VARCHAR2(20 BYTE),
  GENDER                 VARCHAR2(20 BYTE),
  CLAIM_IDENTIFIER       VARCHAR2(100 BYTE),
  PREV_CLAIM_IDENTIFIER  VARCHAR2(100 BYTE),
  LINE_ITEM_NUMBER_TXT   VARCHAR2(20 BYTE),
  ACTION                 VARCHAR2(20 BYTE),
  SERVICE_DATE           VARCHAR2(20 BYTE),
  EVENT_CODE             VARCHAR2(20 BYTE),
  STATUS                 VARCHAR2(12 BYTE),
  STATUS_DT_TM           DATE,
  STAT_MSG               VARCHAR2(40 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_MEDS_DATA
(
  AGS_MEDS_DATA_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  AGS_JOB_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  RUN_NBR                NUMBER,
  RUN_DT_TM              DATE,
  FILE_ROW_NBR           NUMBER,
  SENDING_FACILITY       VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  ACTION                 VARCHAR2(20 BYTE),
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  GS_MED_CLAIM_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  CATALOG_CD             NUMBER                 DEFAULT 0                     NOT NULL,
  PRODUCT_SYNONYM_CKI    VARCHAR2(250 BYTE),
  PRESCRIBER_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  CLAIM_IDENTIFIER       VARCHAR2(100 BYTE),
  PREV_CLAIM_IDENTIFIER  VARCHAR2(100 BYTE),
  EXT_ALIAS              VARCHAR2(100 BYTE),
  SSN_ALIAS              VARCHAR2(100 BYTE),
  NAME_LAST              VARCHAR2(100 BYTE),
  NAME_FIRST             VARCHAR2(100 BYTE),
  BIRTH_DATE             VARCHAR2(20 BYTE),
  GENDER                 VARCHAR2(20 BYTE),
  DRUG_CODE              VARCHAR2(100 BYTE),
  PRODUCT_DESCRIPTION    VARCHAR2(250 BYTE),
  SERVICE_DATE           VARCHAR2(20 BYTE),
  DISPENSE_QTY_TXT       VARCHAR2(20 BYTE),
  STRENGTH_QTY_TXT       VARCHAR2(20 BYTE),
  REFILL_NBR_TXT         VARCHAR2(20 BYTE),
  PRESCRIBER_EXT_ALIAS   VARCHAR2(100 BYTE),
  PHARMACY_EXT_ALIAS     VARCHAR2(100 BYTE),
  STATUS                 VARCHAR2(12 BYTE),
  STATUS_DT_TM           DATE,
  STAT_MSG               VARCHAR2(40 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  PAYER_ALIAS            VARCHAR2(100 BYTE),
  HEALTH_PLAN_ALIAS      VARCHAR2(100 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_MRG_DATA
(
  AGS_MRG_DATA_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  AGS_JOB_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  RUN_NBR                NUMBER,
  RUN_DT_TM              DATE                   DEFAULT SYSDATE               NOT NULL,
  FILE_ROW_NBR           NUMBER,
  SENDING_FACILITY       VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  HIST_PERSON_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  ACTION                 VARCHAR2(20 BYTE),
  ACTION_PERFORMED       VARCHAR2(20 BYTE),
  EXT_ALIAS              VARCHAR2(100 BYTE),
  SSN_ALIAS              VARCHAR2(100 BYTE),
  NAME_LAST              VARCHAR2(100 BYTE),
  NAME_FIRST             VARCHAR2(100 BYTE),
  NAME_MIDDLE            VARCHAR2(100 BYTE),
  BIRTH_DATE             VARCHAR2(20 BYTE),
  GENDER                 VARCHAR2(20 BYTE),
  HIST_EXT_ALIAS         VARCHAR2(100 BYTE),
  HIST_SSN_ALIAS         VARCHAR2(100 BYTE),
  HIST_NAME_LAST         VARCHAR2(100 BYTE),
  HIST_NAME_FIRST        VARCHAR2(100 BYTE),
  HIST_NAME_MIDDLE       VARCHAR2(100 BYTE),
  HIST_BIRTH_DATE        VARCHAR2(20 BYTE),
  HIST_GENDER            VARCHAR2(20 BYTE),
  STATUS                 VARCHAR2(12 BYTE),
  STATUS_DT_TM           DATE                   DEFAULT SYSDATE               NOT NULL,
  STAT_MSG               VARCHAR2(40 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  END_DATE_TXT           VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_ORG_DATA
(
  AGS_ORG_DATA_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  AGS_JOB_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  RUN_NBR                NUMBER,
  RUN_DT_TM              DATE,
  FILE_ROW_NBR           NUMBER,
  SENDING_FACILITY       VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  LOCATION_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  EXT_ALIAS              VARCHAR2(100 BYTE),
  NAME                   VARCHAR2(100 BYTE),
  STREET_ADDR            VARCHAR2(100 BYTE),
  STREET_ADDR2           VARCHAR2(100 BYTE),
  CITY                   VARCHAR2(100 BYTE),
  COUNTY                 VARCHAR2(100 BYTE),
  STATE                  VARCHAR2(100 BYTE),
  COUNTRY                VARCHAR2(100 BYTE),
  ZIPCODE                VARCHAR2(25 BYTE),
  PHONE1                 VARCHAR2(100 BYTE),
  PHONE_FAX              VARCHAR2(100 BYTE),
  ALT_ALIAS1             VARCHAR2(100 BYTE),
  ALT_ALIAS1_TYPE        VARCHAR2(20 BYTE),
  ALT_ALIAS2             VARCHAR2(100 BYTE),
  ALT_ALIAS2_TYPE        VARCHAR2(20 BYTE),
  ALT_ALIAS3             VARCHAR2(100 BYTE),
  ALT_ALIAS3_TYPE        VARCHAR2(20 BYTE),
  SPECIALTY_CODE         VARCHAR2(20 BYTE),
  SPECIALTY_DESC         VARCHAR2(100 BYTE),
  STATUS                 VARCHAR2(12 BYTE),
  STATUS_DT_TM           DATE,
  STAT_MSG               VARCHAR2(40 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  PROVDIR_LINK_ALIAS     VARCHAR2(100 BYTE),
  PROVDIR_ALIAS          VARCHAR2(100 BYTE),
  ADDRESS_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  BUS_PHONE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  FAX_PHONE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  PRIMARY_IND            NUMBER                 DEFAULT 0                     NOT NULL,
  EXT_LINK_ALIAS         VARCHAR2(100 BYTE)     DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_PERSON_DATA
(
  AGS_PERSON_DATA_ID     NUMBER                 DEFAULT 0                     NOT NULL,
  AGS_JOB_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  RUN_NBR                NUMBER,
  RUN_DT_TM              DATE,
  FILE_ROW_NBR           NUMBER,
  SENDING_FACILITY       VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  PCP_PERSON_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  EXT_ALIAS              VARCHAR2(100 BYTE),
  SSN_ALIAS              VARCHAR2(100 BYTE),
  NAME_LAST              VARCHAR2(100 BYTE),
  NAME_FIRST             VARCHAR2(100 BYTE),
  NAME_MIDDLE            VARCHAR2(100 BYTE),
  BIRTH_DATE             VARCHAR2(20 BYTE),
  GENDER                 VARCHAR2(20 BYTE),
  STREET_ADDR            VARCHAR2(100 BYTE),
  STREET_ADDR2           VARCHAR2(100 BYTE),
  CITY                   VARCHAR2(100 BYTE),
  COUNTY                 VARCHAR2(100 BYTE),
  STATE                  VARCHAR2(100 BYTE),
  COUNTRY                VARCHAR2(100 BYTE),
  ZIPCODE                VARCHAR2(25 BYTE),
  PHONE_HOME             VARCHAR2(100 BYTE),
  PHONE_ALT              VARCHAR2(100 BYTE),
  PCP_EXT_ALIAS          VARCHAR2(100 BYTE),
  ELIG_START_DATE        VARCHAR2(20 BYTE),
  ELIG_END_DATE          VARCHAR2(20 BYTE),
  CMRN_ALIAS             VARCHAR2(100 BYTE),
  STATUS                 VARCHAR2(12 BYTE),
  STATUS_DT_TM           DATE,
  STAT_MSG               VARCHAR2(40 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  LANG_CODE              VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_PLAN_DATA
(
  AGS_PLAN_DATA_ID         NUMBER               DEFAULT 0                     NOT NULL,
  AGS_JOB_ID               NUMBER               DEFAULT 0                     NOT NULL,
  RUN_NBR                  NUMBER               DEFAULT 0                     NOT NULL,
  RUN_DT_TM                DATE                 DEFAULT SYSDATE               NOT NULL,
  FILE_ROW_NBR             NUMBER               DEFAULT 0                     NOT NULL,
  SENDING_FACILITY         VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID           NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_RX_PLAN_RELTN_ID  NUMBER               DEFAULT 0                     NOT NULL,
  EXT_ALIAS                VARCHAR2(100 BYTE),
  SSN_ALIAS                VARCHAR2(100 BYTE),
  NAME_LAST                VARCHAR2(100 BYTE),
  NAME_FIRST               VARCHAR2(100 BYTE),
  GENDER                   VARCHAR2(20 BYTE),
  BIRTH_DATE               VARCHAR2(20 BYTE),
  PLAN_TYPE                VARCHAR2(100 BYTE),
  PLAN_ALIAS               VARCHAR2(100 BYTE),
  ELIG_START_DATE          VARCHAR2(20 BYTE),
  ELIG_END_DATE            VARCHAR2(20 BYTE),
  STATUS                   VARCHAR2(12 BYTE),
  STATUS_DT_TM             DATE,
  STAT_MSG                 VARCHAR2(40 BYTE),
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_PRSNL_DATA
(
  AGS_PRSNL_DATA_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  AGS_JOB_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  RUN_NBR                NUMBER,
  RUN_DT_TM              DATE,
  FILE_ROW_NBR           NUMBER,
  SENDING_FACILITY       VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  EXT_ALIAS              VARCHAR2(100 BYTE),
  BEG_DATE               VARCHAR2(20 BYTE),
  END_DATE               VARCHAR2(20 BYTE),
  DEA_ALIAS              VARCHAR2(100 BYTE),
  UPIN_ALIAS             VARCHAR2(100 BYTE),
  MED_ALIAS              VARCHAR2(100 BYTE),
  EXT_LINK_ALIAS         VARCHAR2(100 BYTE),
  SSN_ALIAS              VARCHAR2(100 BYTE),
  NAME_RAW               VARCHAR2(100 BYTE),
  NAME_LAST              VARCHAR2(100 BYTE),
  NAME_FIRST             VARCHAR2(100 BYTE),
  NAME_MIDDLE            VARCHAR2(100 BYTE),
  NAME_FULL              VARCHAR2(100 BYTE),
  NAME_DEGREE            VARCHAR2(100 BYTE),
  NAME_TITLE             VARCHAR2(100 BYTE),
  BIRTH_DATE             VARCHAR2(20 BYTE),
  GENDER                 VARCHAR2(20 BYTE),
  STREET_ADDR            VARCHAR2(100 BYTE),
  STREET_ADDR2           VARCHAR2(100 BYTE),
  CITY                   VARCHAR2(100 BYTE),
  COUNTY                 VARCHAR2(100 BYTE),
  STATE                  VARCHAR2(100 BYTE),
  COUNTRY                VARCHAR2(100 BYTE),
  ZIPCODE                VARCHAR2(25 BYTE),
  PHONE_BUSINESS         VARCHAR2(100 BYTE),
  PHONE_FAX              VARCHAR2(100 BYTE),
  ALT_ALIAS1             VARCHAR2(100 BYTE),
  ALT_ALIAS1_TYPE        VARCHAR2(20 BYTE),
  ALT_ALIAS2             VARCHAR2(100 BYTE),
  ALT_ALIAS2_TYPE        VARCHAR2(20 BYTE),
  EXT_ORG_ALIAS          VARCHAR2(100 BYTE),
  SPECIALTY_CODE         VARCHAR2(20 BYTE),
  SPECIALTY_DESC         VARCHAR2(100 BYTE),
  STATUS                 VARCHAR2(12 BYTE),
  STATUS_DT_TM           DATE,
  STAT_MSG               VARCHAR2(40 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  PROVDIR_LINK_ALIAS     VARCHAR2(100 BYTE),
  PROVDIR_ALIAS          VARCHAR2(100 BYTE),
  ADDRESS_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  BUS_PHONE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  FAX_PHONE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  PRIMARY_IND            NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AGS_RESULT_DATA
(
  AGS_RESULT_DATA_ID       NUMBER               DEFAULT 0                     NOT NULL,
  AGS_JOB_ID               NUMBER               DEFAULT 0                     NOT NULL,
  RUN_NBR                  NUMBER,
  RUN_DT_TM                DATE,
  FILE_ROW_NBR             NUMBER,
  SENDING_FACILITY         VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0                     NOT NULL,
  ACTION                   VARCHAR2(20 BYTE),
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  CLINICAL_EVENT_ID        NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  ORDERING_PERSON_ID       NUMBER               DEFAULT 0                     NOT NULL,
  EXT_ALIAS                VARCHAR2(100 BYTE),
  SSN_ALIAS                VARCHAR2(100 BYTE),
  NAME_LAST                VARCHAR2(100 BYTE),
  NAME_FIRST               VARCHAR2(100 BYTE),
  BIRTH_DATE               VARCHAR2(20 BYTE),
  GENDER                   VARCHAR2(20 BYTE),
  EVENT_DATE               VARCHAR2(20 BYTE),
  EVENT_CODE               VARCHAR2(20 BYTE),
  EVENT_TITLE_TEXT         VARCHAR2(255 BYTE),
  RESULT_VAL               VARCHAR2(255 BYTE),
  RESULT_REMARK_DESC       VARCHAR2(255 BYTE),
  RESULT_IDENTIFIER        VARCHAR2(100 BYTE),
  PERFORMING_NAME          VARCHAR2(100 BYTE),
  PERFORMING_EXT_ALIAS     VARCHAR2(100 BYTE),
  ORDERING_EXT_ALIAS       VARCHAR2(100 BYTE),
  REF_RANGE                VARCHAR2(50 BYTE),
  NORMAL_HIGH              VARCHAR2(20 BYTE),
  NORMAL_LOW               VARCHAR2(20 BYTE),
  NORMALCY                 VARCHAR2(100 BYTE),
  UNIT_OF_MEAS             VARCHAR2(20 BYTE),
  STATUS                   VARCHAR2(12 BYTE),
  STATUS_DT_TM             DATE,
  STAT_MSG                 VARCHAR2(40 BYTE),
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  RESULT_FORMAT            VARCHAR2(20 BYTE),
  PERFORMING_ENTITY_ALIAS  VARCHAR2(100 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_ALLERGY
(
  ALERT_AUDIT_ALLERGY_ID      NUMBER            DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_TRANSACTION_ID  NUMBER            DEFAULT 0                     NOT NULL,
  DRUG_ALLERGY_IND            NUMBER            DEFAULT 0                     NOT NULL,
  DRUG_IDENTIFIER             VARCHAR2(6 BYTE)  DEFAULT ' '                   NOT NULL,
  DRUG_ALR_CATEGORY_ID        NUMBER            DEFAULT 0                     NOT NULL,
  ALLERGY_IDENTIFIER          VARCHAR2(6 BYTE)  DEFAULT ' '                   NOT NULL,
  ALLERGY_ALR_CATEGORY_ID     NUMBER            DEFAULT 0                     NOT NULL,
  CLASS_ID                    NUMBER            DEFAULT 0                     NOT NULL,
  INTERACTION_LEVEL_FLAG      NUMBER            DEFAULT 0                     NOT NULL,
  INTERACTION_TYPE_ID         NUMBER            DEFAULT 0                     NOT NULL,
  DESC_LONG_TEXT_ID           NUMBER            DEFAULT 0                     NOT NULL,
  DCP_ENTITY_RELTN_ID         NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_ALLERGY_DOM
(
  ALERT_AUDIT_ALLERGY_DOM_ID    NUMBER          DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_ALLERGY_ID        NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  ORDER_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  CATALOG_CD                    NUMBER          DEFAULT 0                     NOT NULL,
  ALLERGY_ID                    NUMBER          DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID               NUMBER          DEFAULT 0                     NOT NULL,
  NO_OVERRIDE_REASON_IND        NUMBER          DEFAULT 0                     NOT NULL,
  FREETEXT_OVERRIDE_REASON_IND  NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD            NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_LONG_TEXT_ID  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  DRUG_ALLERGY_IND              NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_DRUG
(
  ALERT_AUDIT_DRUG_ID            NUMBER         DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_TRANSACTION_ID     NUMBER         DEFAULT 0                     NOT NULL,
  DRUG_IDENTIFIER_1              VARCHAR2(6 BYTE) DEFAULT ' ' NOT NULL,
  DRUG_IDENTIFIER_2              VARCHAR2(6 BYTE) DEFAULT ' ' NOT NULL,
  DRUG_IDENTIFIER_1_SUBJECT_IND  NUMBER         DEFAULT 0                     NOT NULL,
  SEVERITY_FLAG                  NUMBER         DEFAULT 0                     NOT NULL,
  SEVERITY_DETAILS_BIT           NUMBER         DEFAULT 0                     NOT NULL,
  DESC_LONG_TEXT_ID              NUMBER         DEFAULT 0                     NOT NULL,
  DCP_ENTITY_RELTN_ID            NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_DRUG_DOM
(
  ALERT_AUDIT_DRUG_DOM_ID       NUMBER          DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_DRUG_ID           NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  SUBJECT_ORDER_ID              NUMBER          DEFAULT 0                     NOT NULL,
  SUBJECT_CATALOG_CD            NUMBER          DEFAULT 0                     NOT NULL,
  CAUSING_ORDER_ID              NUMBER          DEFAULT 0                     NOT NULL,
  CAUSING_CATALOG_CD            NUMBER          DEFAULT 0                     NOT NULL,
  NO_OVERRIDE_REASON_IND        NUMBER          DEFAULT 0                     NOT NULL,
  FREETEXT_OVERRIDE_REASON_IND  NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD            NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_LONG_TEXT_ID  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  SEVERITY_FLAG                 NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_DUP
(
  ALERT_AUDIT_DUP_ID          NUMBER            DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_TRANSACTION_ID  NUMBER            DEFAULT 0                     NOT NULL,
  DRUG_IDENTIFIER             VARCHAR2(6 BYTE)  DEFAULT ' '                   NOT NULL,
  CATEGORY_DUPLICATION_IND    NUMBER            DEFAULT 0                     NOT NULL,
  MULTUM_CATEGORY_ID          NUMBER            DEFAULT 0                     NOT NULL,
  CATEGORY_LEVEL_FLAG         NUMBER            DEFAULT 0                     NOT NULL,
  MAXIMUM_OCCURRENCES_NBR     NUMBER            DEFAULT 0                     NOT NULL,
  OBSERVED_OCCURRENCES_NBR    NUMBER            DEFAULT 0                     NOT NULL,
  DCP_ENTITY_RELTN_ID         NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_DUP_CAT_CAUSE
(
  ALERT_AUDIT_DUP_CAT_CAUSE_ID  NUMBER          DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_DUP_ID            NUMBER          DEFAULT 0                     NOT NULL,
  DRUG_IDENTIFIER               VARCHAR2(6 BYTE) DEFAULT ' ' NOT NULL,
  OBSERVED_OCCURRENCES_NBR      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_DUP_DOM
(
  ALERT_AUDIT_DUP_DOM_ID        NUMBER          DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_DUP_ID            NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  SUBJECT_ORDER_ID              NUMBER          DEFAULT 0                     NOT NULL,
  SUBJECT_CATALOG_CD            NUMBER          DEFAULT 0                     NOT NULL,
  CAUSING_ORDER_ID              NUMBER          DEFAULT 0                     NOT NULL,
  CAUSING_CATALOG_CD            NUMBER          DEFAULT 0                     NOT NULL,
  NO_OVERRIDE_REASON_IND        NUMBER          DEFAULT 0                     NOT NULL,
  FREETEXT_OVERRIDE_REASON_IND  NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD            NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_LONG_TEXT_ID  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_FOOD
(
  ALERT_AUDIT_FOOD_ID         NUMBER            DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_TRANSACTION_ID  NUMBER            DEFAULT 0                     NOT NULL,
  DRUG_IDENTIFIER             VARCHAR2(6 BYTE)  DEFAULT ' '                   NOT NULL,
  SEVERITY_FLAG               NUMBER            DEFAULT 0                     NOT NULL,
  SEVERITY_DETAILS_BIT        NUMBER            DEFAULT 0                     NOT NULL,
  DESC_LONG_TEXT_ID           NUMBER            DEFAULT 0                     NOT NULL,
  DCP_ENTITY_RELTN_ID         NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_FOOD_DOM
(
  ALERT_AUDIT_FOOD_DOM_ID       NUMBER          DEFAULT 0                     NOT NULL,
  ALERT_AUDIT_FOOD_ID           NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  ORDER_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  CATALOG_CD                    NUMBER          DEFAULT 0                     NOT NULL,
  NO_OVERRIDE_REASON_IND        NUMBER          DEFAULT 0                     NOT NULL,
  FREETEXT_OVERRIDE_REASON_IND  NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD            NUMBER          DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_LONG_TEXT_ID  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  SEVERITY_FLAG                 NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALERT_AUDIT_TRANSACTION
(
  ALERT_AUDIT_TRANSACTION_ID  NUMBER            DEFAULT 0                     NOT NULL,
  PRSNL_ID                    NUMBER            DEFAULT 0                     NOT NULL,
  PERSON_ID                   NUMBER            DEFAULT 0                     NOT NULL,
  TRANSACTION_DT_TM           DATE              DEFAULT SYSDATE               NOT NULL,
  DOMAIN_DATA_IND             NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALIAS_POOL
(
  ALIAS_POOL_CD           NUMBER                DEFAULT 0                     NOT NULL,
  DESCRIPTION             VARCHAR2(200 BYTE)    DEFAULT ' '                   NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UNIQUE_IND              NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  FORMAT_MASK             VARCHAR2(100 BYTE),
  CHECK_DIGIT_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DUP_ALLOWED_FLAG        NUMBER,
  SYS_ASSIGN_FLAG         NUMBER,
  CMB_INACTIVE_IND        NUMBER,
  ALIAS_METHOD_CD         NUMBER                DEFAULT 0,
  ALIAS_POOL_EXT_CD       NUMBER                DEFAULT 0,
  EFFECTIVE_ALIAS_IND     NUMBER                DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID       NUMBER                DEFAULT 0,
  UNSECURED_CHAR_COUNT    NUMBER                DEFAULT 0,
  SECURITY_CHAR           VARCHAR2(1 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALIAS_POOL_SEQ
(
  ALIAS_POOL_CD   NUMBER                        DEFAULT 0                     NOT NULL,
  AP_SEQ_TYPE_CD  NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL,
  START_NBR       FLOAT(126)                    DEFAULT 0                     NOT NULL,
  MAX_NBR         FLOAT(126)                    DEFAULT 0                     NOT NULL,
  NEXT_NBR        FLOAT(126)                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALLELE_PATTERN_MATCH
(
  ORDER_ID      NUMBER                          DEFAULT 0                     NOT NULL,
  GEL_NUMBER    NUMBER                          DEFAULT 0                     NOT NULL,
  LOCI_SEQ      NUMBER                          DEFAULT 0                     NOT NULL,
  LOCI_CD       NUMBER                          DEFAULT 0                     NOT NULL,
  ALLELE_CD     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL,
  GEL_BATCH_ID  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALLERGY
(
  ALLERGY_INSTANCE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  ALLERGY_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  SUBSTANCE_NOM_ID        NUMBER                DEFAULT 0                     NOT NULL,
  SUBSTANCE_FTDESC        VARCHAR2(255 BYTE),
  SUBSTANCE_TYPE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  REACTION_CLASS_CD       NUMBER                DEFAULT 0                     NOT NULL,
  SEVERITY_CD             NUMBER                DEFAULT 0                     NOT NULL,
  SOURCE_OF_INFO_CD       NUMBER                DEFAULT 0                     NOT NULL,
  SOURCE_OF_INFO_FT       VARCHAR2(50 BYTE),
  ONSET_DT_TM             DATE,
  REACTION_STATUS_CD      NUMBER                DEFAULT 0                     NOT NULL,
  CREATED_DT_TM           DATE,
  CREATED_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CANCEL_REASON_CD        NUMBER                DEFAULT 0                     NOT NULL,
  CANCEL_DT_TM            DATE,
  CANCEL_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  VERIFIED_STATUS_FLAG    NUMBER,
  REC_SRC_VOCAB_CD        NUMBER                DEFAULT 0                     NOT NULL,
  REC_SRC_IDENTIFER       VARCHAR2(50 BYTE),
  REC_SRC_STRING          VARCHAR2(255 BYTE),
  ONSET_PRECISION_CD      NUMBER                DEFAULT 0                     NOT NULL,
  ONSET_PRECISION_FLAG    NUMBER                DEFAULT 0,
  REVIEWED_DT_TM          DATE,
  REVIEWED_PRSNL_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ORIG_PRSNL_ID           NUMBER                DEFAULT 0                     NOT NULL,
  REACTION_STATUS_DT_TM   DATE,
  ONSET_TZ                NUMBER                DEFAULT 0,
  BEG_EFFECTIVE_TZ        NUMBER                DEFAULT 0,
  REVIEWED_TZ             NUMBER                DEFAULT 0,
  CMB_INSTANCE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CMB_FLAG                NUMBER                DEFAULT 0                     NOT NULL,
  CMB_PRSNL_ID            NUMBER                DEFAULT 0                     NOT NULL,
  CMB_PERSON_ID           NUMBER                DEFAULT 0                     NOT NULL,
  CMB_DT_TM               DATE,
  CMB_TZ                  NUMBER                DEFAULT 0,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALLERGY_COMMENT
(
  ALLERGY_COMMENT_ID      NUMBER                DEFAULT 0                     NOT NULL,
  ALLERGY_INSTANCE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  ALLERGY_ID              NUMBER                DEFAULT 0                     NOT NULL,
  COMMENT_DT_TM           DATE,
  COMMENT_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ALLERGY_COMMENT         LONG,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  COMMENT_TZ              NUMBER                DEFAULT 0,
  BEG_EFFECTIVE_TZ        NUMBER                DEFAULT 0,
  CMB_COMMENT_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CMB_PRSNL_ID            NUMBER                DEFAULT 0                     NOT NULL,
  CMB_PERSON_ID           NUMBER                DEFAULT 0                     NOT NULL,
  CMB_DT_TM               DATE,
  CMB_TZ                  NUMBER                DEFAULT 0,
  CMB_FLAG                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ALLERGY_REVIEW_HIST
(
  ALLERGY_REVIEW_HIST_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ALLERGY_INSTANCE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  REVIEWED_DT_TM          DATE                  DEFAULT SYSDATE               NOT NULL,
  REVIEWED_TZ             NUMBER,
  REVIEWED_PRSNL_ID       NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AMENDMENT_REASON
(
  AMENDMENT_REASON_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PROT_AMENDMENT_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  AMENDMENT_REASON_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE APPLICATION_GROUP
(
  APPLICATION_GROUP_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  POSITION_CD           NUMBER                  DEFAULT 0                     NOT NULL,
  PERSON_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  APP_GROUP_CD          NUMBER                  DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM   DATE                    DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM   DATE                    DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE APPL_DISEASE
(
  APPL_DISEASE_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  DISEASE_TYPE_CD        NUMBER                 DEFAULT 0                     NOT NULL,
  DISEASE_SUB_TYPE_CD    NUMBER                 DEFAULT 0                     NOT NULL,
  PROT_AMENDMENT_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  APPL_DISEASE_DESC_OTR  VARCHAR2(255 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_APP_FOLDERS
(
  APP_FOLDER_ID       NUMBER                    DEFAULT 0                     NOT NULL,
  APPLICATION_NUMBER  NUMBER                    DEFAULT 0                     NOT NULL,
  USER_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_APP_FOLDER_DETAILS
(
  APP_FOLDER_ID  NUMBER                         DEFAULT 0                     NOT NULL,
  FOLDER_ID      NUMBER                         DEFAULT 0                     NOT NULL,
  ACCESS_CNT     NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_CASE_QUERY
(
  CASE_QUERY_ID      NUMBER                     DEFAULT 0                     NOT NULL,
  OUTPUT_DEST_ID     NUMBER                     DEFAULT 0                     NOT NULL,
  NBR_COPIES         NUMBER                     DEFAULT 0,
  REPORT_TYPE_FLAG   NUMBER                     DEFAULT 0,
  SEARCH_TYPE_FLAG   NUMBER                     DEFAULT 0,
  REPORT_HISTORY_CD  NUMBER                     DEFAULT 0                     NOT NULL,
  QUERY_START_DT_TM  DATE,
  STARTED_PRSNL_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  STATUS_FLAG        NUMBER                     DEFAULT 0,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  RESULT_NAME        VARCHAR2(100 BYTE),
  RESULT_NAME_KEY    VARCHAR2(100 BYTE),
  ACTIVITY_TYPE_CD   NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_CASE_QUERY_DETAILS
(
  CASE_QUERY_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE               NUMBER                 DEFAULT 0                     NOT NULL,
  PARAM_NAME             VARCHAR2(20 BYTE),
  CRITERIA_TYPE_FLAG     NUMBER,
  DATE_TYPE_FLAG         NUMBER                 DEFAULT 0,
  BEG_VALUE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  BEG_VALUE_DT_TM        DATE,
  BEG_VALUE_DISP         VARCHAR2(40 BYTE),
  END_VALUE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  END_VALUE_DT_TM        DATE,
  END_VALUE_DISP         VARCHAR2(40 BYTE),
  NEGATION_IND           NUMBER                 DEFAULT 0,
  SOURCE_VOCABULARY_CD   NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  FREETEXT_LONG_TEXT_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  FREETEXT_QUERY_FLAG    NUMBER                 DEFAULT 0,
  QUERY_DETAIL_ID        NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_CASE_SYNOPTIC_WS
(
  CASE_WORKSHEET_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  CASE_SPECIMEN_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  SEQUENCE           NUMBER                     DEFAULT 0                     NOT NULL,
  SCR_PATTERN_ID     NUMBER                     DEFAULT 0                     NOT NULL,
  SCD_STORY_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD      NUMBER                     DEFAULT 0                     NOT NULL,
  REPORT_ID          NUMBER                     DEFAULT 0                     NOT NULL,
  STATUS_FLAG        NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  CAP_CHECKLIST_CKI  VARCHAR2(255 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_DC_EVENT
(
  EVENT_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  STUDY_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  CASE_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  CORRELATE_CASE_ID          NUMBER             DEFAULT 0                     NOT NULL,
  INIT_EVAL_TERM_ID          NUMBER             DEFAULT 0                     NOT NULL,
  INIT_DISCREP_TERM_ID       NUMBER             DEFAULT 0                     NOT NULL,
  DISAGREE_REASON_CD         NUMBER             DEFAULT 0                     NOT NULL,
  INVESTIGATION_CD           NUMBER             DEFAULT 0                     NOT NULL,
  RESOLUTION_CD              NUMBER             DEFAULT 0                     NOT NULL,
  FINAL_EVAL_TERM_ID         NUMBER             DEFAULT 0                     NOT NULL,
  FINAL_DISCREP_TERM_ID      NUMBER             DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID               NUMBER             DEFAULT 0                     NOT NULL,
  PRSNL_GROUP_ID             NUMBER             DEFAULT 0                     NOT NULL,
  INITIATED_PRSNL_ID         NUMBER             DEFAULT 0                     NOT NULL,
  INITIATED_DT_TM            DATE,
  CANCEL_PRSNL_ID            NUMBER             DEFAULT 0                     NOT NULL,
  CANCEL_DT_TM               DATE,
  COMPLETE_PRSNL_ID          NUMBER             DEFAULT 0                     NOT NULL,
  COMPLETE_DT_TM             DATE,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  SYS_CORR_ID                NUMBER             DEFAULT 0                     NOT NULL,
  REPORT_ISSUED_BY_PRSNL_ID  NUMBER             DEFAULT 0                     NOT NULL,
  ASSIGN_TO_GROUP_IND        NUMBER             DEFAULT 0,
  SLIDE_COUNTS               FLOAT(126)         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_DC_EVENT_PRSNL
(
  EVENT_ID        NUMBER                        DEFAULT 0                     NOT NULL,
  PRSNL_GROUP_ID  NUMBER                        DEFAULT 0                     NOT NULL,
  PRSNL_ID        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_DIAG_RPT_REVIEW
(
  EVENT_ID           NUMBER                     DEFAULT 0                     NOT NULL,
  PREFIX_ID          NUMBER                     DEFAULT 0                     NOT NULL,
  VERIFIED_PRSNL_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  VERIFIED_DT_TM     DATE                       DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_FOLDER
(
  FOLDER_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  FOLDER_NAME            VARCHAR2(100 BYTE),
  FOLDER_NAME_KEY        VARCHAR2(100 BYTE)     DEFAULT ' '                   NOT NULL,
  FOLDER_NAME_KEY_NLS    VARCHAR2(202 BYTE),
  PARENT_FOLDER_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  CREATE_PRSNL_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  COMMENT_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  PUBLIC_IND             NUMBER                 DEFAULT 0,
  DEFAULT_BITMAP         NUMBER                 DEFAULT 0,
  ANONYMOUS_BITMAP       NUMBER                 DEFAULT 0,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  FOLDER_NAME_KEY_A_NLS  VARCHAR2(400 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_FOLDER_ENTITY
(
  ENTITY_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME  VARCHAR2(32 BYTE)         DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  FOLDER_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  ENTITY_TYPE_FLAG    NUMBER                    DEFAULT 0,
  DISPLAY             VARCHAR2(255 BYTE),
  COMMENT_ID          NUMBER                    DEFAULT 0                     NOT NULL,
  ACCESSION_NBR       CHAR(21 BYTE),
  SEQUENCE            NUMBER                    DEFAULT 0,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  CREATE_PRSNL_ID     NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_FT_EVENT
(
  FOLLOWUP_EVENT_ID         NUMBER              DEFAULT 0                     NOT NULL,
  CASE_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  FOLLOWUP_TYPE_CD          NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  ORIGIN_FLAG               NUMBER,
  ORIGIN_DT_TM              DATE,
  ORIGIN_PRSNL_ID           NUMBER              DEFAULT 0                     NOT NULL,
  EXPECTED_TERM_DT          DATE,
  INITIAL_NOTIF_DT_TM       DATE,
  INITIAL_NOTIF_PRINT_FLAG  NUMBER,
  FIRST_OVERDUE_DT_TM       DATE,
  FIRST_OVERDUE_PRINT_FLAG  NUMBER,
  FINAL_OVERDUE_DT_TM       DATE,
  FINAL_OVERDUE_PRINT_FLAG  NUMBER,
  TERM_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  TERM_DT_TM                DATE,
  TERM_REASON_CD            NUMBER              DEFAULT 0                     NOT NULL,
  TERM_ACCESSION_NBR        CHAR(21 BYTE),
  TERM_COMMENT              VARCHAR2(100 BYTE),
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  TERM_LONG_TEXT_ID         NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_FT_REPORT_PROC
(
  FOLLOWUP_TRACKING_TYPE_CD  NUMBER             DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD              NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_FT_TERM_PROC
(
  FOLLOWUP_TRACKING_TYPE_CD   NUMBER            DEFAULT 0                     NOT NULL,
  CATALOG_CD                  NUMBER            DEFAULT 0                     NOT NULL,
  AUTO_TERMINATION_IND        NUMBER,
  AUTO_TERMINATION_REASON_CD  NUMBER            DEFAULT 0                     NOT NULL,
  LOOK_BACK_DAYS              NUMBER,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_FT_TYPE
(
  FOLLOWUP_TRACKING_TYPE_CD  NUMBER             DEFAULT 0                     NOT NULL,
  PATIENT_NOTIFICATION_IND   NUMBER,
  SHORT_DESC                 VARCHAR2(25 BYTE),
  DESCRIPTION                VARCHAR2(60 BYTE),
  ACTIVE_IND                 NUMBER,
  PATIENT_NOTIF_TEMPLATE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  PATIENT_FIRST_OVERDUE_IND  NUMBER,
  PATIENT_FIRST_TEMPLATE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  PATIENT_FINAL_OVERDUE_IND  NUMBER,
  PATIENT_FINAL_TEMPLATE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  DOCTOR_NOTIFICATION_IND    NUMBER,
  DOCTOR_NOTIF_TEMPLATE_ID   NUMBER             DEFAULT 0                     NOT NULL,
  DOCTOR_FIRST_OVERDUE_IND   NUMBER,
  DOCTOR_FIRST_TEMPLATE_ID   NUMBER             DEFAULT 0                     NOT NULL,
  DOCTOR_FINAL_OVERDUE_IND   NUMBER,
  DOCTOR_FINAL_TEMPLATE_ID   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_IMAGE_GROUP_INI
(
  PERSON_ID     NUMBER                          DEFAULT 0                     NOT NULL,
  NAME          VARCHAR2(255 BYTE)              DEFAULT ' '                   NOT NULL,
  SEQUENCE      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_IMAGE_ITEM_INI
(
  PERSON_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  PARENT_SEQUENCE     NUMBER                    DEFAULT 0                     NOT NULL,
  SEQUENCE            NUMBER                    DEFAULT 0                     NOT NULL,
  NAME                VARCHAR2(255 BYTE)        DEFAULT ' '                   NOT NULL,
  TYPE_FLAG           NUMBER                    DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME  VARCHAR2(32 BYTE)         DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_IMAGE_MIGRATED
(
  AP_IMAGE_MIGRATED_ID     NUMBER               DEFAULT 0                     NOT NULL,
  DICOM_BLOB_HANDLE_IDENT  VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  MMF_BLOB_HANDLE_IDENT    VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  CASE_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  ENTITY_ID                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_INV_RETENTION
(
  AP_INV_RETENTION_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PREFIX_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  INVENTORY_TYPE_CD    NUMBER                   DEFAULT 0                     NOT NULL,
  NORMALCY_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  RETENTION_TM_VALUE   NUMBER                   DEFAULT 0                     NOT NULL,
  RETENTION_UNITS_CD   NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_LOGIN_ORDER_LIST
(
  ORDER_ID      NUMBER                          DEFAULT 0                     NOT NULL,
  ACCESSION_ID  NUMBER                          DEFAULT 0                     NOT NULL,
  ENCNTR_ID     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX
(
  PREFIX_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  SITE_CD                    NUMBER             DEFAULT 0                     NOT NULL,
  ACCESSION_FORMAT_CD        NUMBER             DEFAULT 0                     NOT NULL,
  PREFIX_NAME                CHAR(2 BYTE),
  PREFIX_DESC                VARCHAR2(40 BYTE),
  CASE_TYPE_CD               NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  ORDER_CATALOG_CD           NUMBER             DEFAULT 0                     NOT NULL,
  GROSS_TASK_ASSAY_CD        NUMBER             DEFAULT 0                     NOT NULL,
  DEFAULT_PROC_CATALOG_CD    NUMBER             DEFAULT 0                     NOT NULL,
  SPECIMEN_GROUPING_CD       NUMBER             DEFAULT 0                     NOT NULL,
  WORKSHEET_TEMPLATE_ID      NUMBER             DEFAULT 0                     NOT NULL,
  DIAG_CODING_VOCABULARY_CD  NUMBER             DEFAULT 0                     NOT NULL,
  INITIATE_PROTOCOL_IND      NUMBER,
  CONSULT_IND                NUMBER,
  ACTIVE_IND                 NUMBER,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD        NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_ACCN_TEMPLATE_R
(
  PREFIX_ID     NUMBER                          DEFAULT 0                     NOT NULL,
  TEMPLATE_CD   NUMBER                          DEFAULT 0                     NOT NULL,
  DEFAULT_IND   NUMBER,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_AUTO_TASK
(
  PREFIX_ID     NUMBER                          DEFAULT 0                     NOT NULL,
  CATALOG_CD    NUMBER                          DEFAULT 0                     NOT NULL,
  SPECIMEN_IND  NUMBER,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_DIAG_AXIS
(
  PREFIX_ID        NUMBER                       DEFAULT 0                     NOT NULL,
  EXCLUDE_AXIS_CD  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_DIAG_SMRY
(
  PREFIX_DIAG_SMRY_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PREFIX_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD        NUMBER                   DEFAULT 0                     NOT NULL,
  COMMENT_LENGTH_QTY   NUMBER                   DEFAULT 0                     NOT NULL,
  REQUIRED_IND         NUMBER                   DEFAULT 0                     NOT NULL,
  COMMENT_IND          NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVE_IND           NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_STATION_R
(
  STATION_ID     NUMBER                         DEFAULT 0                     NOT NULL,
  PREFIX_ID      NUMBER                         DEFAULT 0                     NOT NULL,
  CATALOG_CD     NUMBER                         DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD  NUMBER                         DEFAULT 0                     NOT NULL,
  PUBLISH_FLAG   NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_TAG_GROUP_R
(
  PREFIX_ID      NUMBER                         DEFAULT 0                     NOT NULL,
  TAG_TYPE_FLAG  NUMBER                         DEFAULT 0                     NOT NULL,
  TAG_GROUP_ID   NUMBER                         DEFAULT 0                     NOT NULL,
  PRIMARY_IND    NUMBER,
  TAG_SEPARATOR  CHAR(1 BYTE),
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PREFIX_TASK_R
(
  AP_PREFIX_TASK_R_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PREFIX_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  CATALOG_CD           NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_PRSNL_PRIV
(
  PRIVILEGE_ID  NUMBER                          DEFAULT 0                     NOT NULL,
  PRSNL_ID      NUMBER                          DEFAULT 0                     NOT NULL,
  PRIVILEGE_CD  NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_QA_INFO
(
  QA_FLAG_ID       NUMBER                       DEFAULT 0                     NOT NULL,
  CASE_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  FLAG_TYPE_CD     NUMBER                       DEFAULT 0                     NOT NULL,
  ACTIVATED_ID     NUMBER                       DEFAULT 0                     NOT NULL,
  ACTIVATED_DT_TM  DATE,
  PERSON_ID        NUMBER                       DEFAULT 0                     NOT NULL,
  COMPLETE_ID      NUMBER                       DEFAULT 0                     NOT NULL,
  COMPLETE_DT_TM   DATE,
  SUSPEND_ID       NUMBER                       DEFAULT 0                     NOT NULL,
  SUSPEND_DT_TM    DATE,
  CANCEL_CD        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  ACTIVE_IND       NUMBER                       DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_QUERY_RESULT
(
  QUERY_RESULT_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  CASE_QUERY_ID    NUMBER                       DEFAULT 0                     NOT NULL,
  ACCESSION_NBR    CHAR(21 BYTE),
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  EVENT_ID         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_QUERY_RESULT_OFFSET
(
  QUERY_RESULT_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  SEQUENCE         NUMBER                       DEFAULT 0                     NOT NULL,
  EVENT_ID         NUMBER                       DEFAULT 0                     NOT NULL,
  OFFSET           NUMBER                       DEFAULT 0,
  LENGTH           NUMBER                       DEFAULT 0,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_SPECIMEN_PROTOCOL
(
  PROTOCOL_ID     NUMBER                        DEFAULT 0                     NOT NULL,
  SPECIMEN_CD     NUMBER                        DEFAULT 0                     NOT NULL,
  PREFIX_ID       NUMBER                        DEFAULT 0                     NOT NULL,
  PATHOLOGIST_ID  NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_SYNOPTIC_SPEC_PREFIX_R
(
  SPECIMEN_CD     NUMBER                        DEFAULT 0                     NOT NULL,
  PREFIX_ID       NUMBER                        DEFAULT 0                     NOT NULL,
  SEQUENCE        NUMBER                        DEFAULT 0                     NOT NULL,
  SUGGESTED_FLAG  NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  CKI_SOURCE      CHAR(12 BYTE)                 DEFAULT ' '                   NOT NULL,
  CKI_IDENTIFIER  VARCHAR2(50 BYTE)             DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_SYS_CORR
(
  SYS_CORR_ID              NUMBER               DEFAULT 0                     NOT NULL,
  STUDY_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  CASE_PERCENTAGE          NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 0                     NOT NULL,
  EXECUTE_ON_RESCREEN_IND  NUMBER               DEFAULT 0                     NOT NULL,
  LOOKBACK_CASE_TYPE_CD    NUMBER               DEFAULT 0                     NOT NULL,
  LOOKBACK_MONTHS          NUMBER               DEFAULT 0                     NOT NULL,
  LOOKBACK_ALL_CASES_IND   NUMBER               DEFAULT 0                     NOT NULL,
  NOTIFY_USER_ONLINE_IND   NUMBER               DEFAULT 0                     NOT NULL,
  ASSIGN_TO_GROUP_IND      NUMBER               DEFAULT 0                     NOT NULL,
  ASSIGN_TO_PRSNL_ID       NUMBER               DEFAULT 0                     NOT NULL,
  ASSIGN_TO_GROUP_ID       NUMBER               DEFAULT 0                     NOT NULL,
  ASSIGN_TO_VERIFYING_IND  NUMBER               DEFAULT 0,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  STUDY_SEQUENCE           NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_SYS_CORR_COUNTS
(
  SYS_CORR_ID      NUMBER                       DEFAULT 0                     NOT NULL,
  TOTAL_CASES      NUMBER                       DEFAULT 0                     NOT NULL,
  QUALIFIED_CASES  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_SYS_CORR_DETAIL
(
  SYS_CORR_DETAIL_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  SYS_CORR_ID         NUMBER                    DEFAULT 0                     NOT NULL,
  PARAM_NAME          VARCHAR2(20 BYTE)         DEFAULT ' '                   NOT NULL,
  PARAM_SEQUENCE      NUMBER                    DEFAULT 0                     NOT NULL,
  LOOKBACK_IND        NUMBER                    DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME  VARCHAR2(32 BYTE)         DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AP_TRANS_STAT
(
  AP_TRANS_STAT_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  REPORT_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  CASE_TYPE_CD         NUMBER                   DEFAULT 0                     NOT NULL,
  PATHOLOGIST_ID       NUMBER                   DEFAULT 0                     NOT NULL,
  TRANSCRIPTIONIST_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  TRANSCRIBED_DT_TM    DATE,
  NBR_WORDS            NUMBER,
  NBR_CHARACTERS       NUMBER,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSAY_PROCESSING_R
(
  TASK_ASSAY_CD               NUMBER            DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD         NUMBER            DEFAULT 0                     NOT NULL,
  UPLD_ASSAY_ALIAS            VARCHAR2(25 BYTE),
  PROCESS_SEQUENCE            NUMBER,
  ACTIVE_IND                  NUMBER,
  DEFAULT_RESULT_TYPE_CD      NUMBER            DEFAULT 0                     NOT NULL,
  DEFAULT_RESULT_TEMPLATE_ID  NUMBER            DEFAULT 0                     NOT NULL,
  QC_RESULT_TYPE_CD           NUMBER            DEFAULT 0                     NOT NULL,
  QC_SEQUENCE                 NUMBER,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  DOWNLD_IND                  NUMBER,
  POST_ZERO_RESULT_IND        NUMBER,
  DISPLAY_SEQUENCE            NUMBER,
  DNLD_ASSAY_ALIAS            VARCHAR2(100 BYTE),
  CODE_SET                    NUMBER,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  LOADED_SERVICE_RESOURCE_CD  NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSAY_RESOURCE_LIST
(
  SERVICE_RESOURCE_CD     NUMBER                DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  RESOURCE_GROUP_CD       NUMBER                DEFAULT 0                     NOT NULL,
  RESOURCE_ROUTE_FLAG     NUMBER,
  PRIMARY_IND             NUMBER,
  SEQUENCE                NUMBER,
  SCRIPT_NAME             VARCHAR2(50 BYTE),
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSAY_RESOURCE_LOT
(
  LOT_ID               NUMBER                   DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD        NUMBER                   DEFAULT 0                     NOT NULL,
  MEAN                 FLOAT(126),
  CLINICAL_STD_DEV     FLOAT(126),
  STATISTICAL_STD_DEV  FLOAT(126),
  ABS_LOW              FLOAT(126),
  ABS_HIGH             FLOAT(126),
  RULE_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVE_IND           NUMBER,
  BEG_EFFECTIVE_DT_TM  DATE,
  END_EFFECTIVE_DT_TM  DATE,
  ARL_ID               NUMBER                   DEFAULT 0                     NOT NULL,
  MANF_LOW             FLOAT(126)               DEFAULT 0,
  MANF_HIGH            FLOAT(126)               DEFAULT 0,
  MANF_STD_DEV         FLOAT(126),
  MANF_MEAN            FLOAT(126)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSAY_RESOURCE_TRANSLATION
(
  TASK_ASSAY_CD               NUMBER            DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD         NUMBER            DEFAULT 0                     NOT NULL,
  UPLD_ASSAY_ALIAS            VARCHAR2(25 BYTE) DEFAULT ' ' NOT NULL,
  ACTIVE_IND                  NUMBER,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  POST_ZERO_RESULT_IND        NUMBER,
  PROCESS_SEQUENCE            NUMBER,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  LOADED_SERVICE_RESOURCE_CD  NUMBER            DEFAULT 0                     NOT NULL,
  DECIMAL_MOVEMENT_NBR        NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSIGN
(
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ASSIGN_REASON_CD        NUMBER                DEFAULT 0                     NOT NULL,
  PROV_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ORIG_ASSIGN_QTY         NUMBER,
  CUR_ASSIGN_QTY          NUMBER,
  ORIG_ASSIGN_INTL_UNITS  NUMBER                DEFAULT 0,
  CUR_ASSIGN_INTL_UNITS   NUMBER                DEFAULT 0,
  BB_ID_NBR               VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSIGN_ELIG_RELTN
(
  ASSIGN_ELIG_RELTN_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  COHORT_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  PT_ELIG_TRACKING_ID   NUMBER                  DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM   DATE                    DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM   DATE                    DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSIGN_REG_RELTN
(
  ASSIGN_REG_RELTN_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  COHORT_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  REG_ID               NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE                     DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE ASSIGN_RELEASE
(
  ASSIGN_RELEASE_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  RELEASE_DT_TM           DATE,
  RELEASE_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  RELEASE_REASON_CD       NUMBER                DEFAULT 0                     NOT NULL,
  RELEASE_QTY             NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  RELEASE_INTL_UNITS      NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AT_ACCT_RELTN
(
  AT_ACCT_RELTN_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_TEMPL_ID           NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CREATED_DT_TM           DATE                  DEFAULT SYSDATE,
  CREATED_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTH
(
  AUTH_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(100 BYTE),
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ACCIDENT_DT_TM          DATE,
  LAST_PERIOD_DATE        DATE,
  ESTIMATED_DOB           DATE,
  ILLNESS_DT_TM           DATE,
  AUTH_NUMBER             NUMBER,
  AUTH_ISSUE_DT_TM        DATE,
  CLAIM_NUMBER            NUMBER,
  STATUS_CD               NUMBER                DEFAULT 0                     NOT NULL,
  STATUS_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  STATUS_DT_TM            DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTHORIZATION
(
  AUTHORIZATION_ID         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID           NUMBER               DEFAULT 0                     NOT NULL,
  CERT_NBR                 VARCHAR2(50 BYTE),
  AUTH_NBR                 VARCHAR2(50 BYTE),
  CERT_PRSNL_ID            NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_TYPE_CD             NUMBER               DEFAULT 0                     NOT NULL,
  DESCRIPTION              VARCHAR2(200 BYTE),
  CERT_STATUS_CD           NUMBER               DEFAULT 0                     NOT NULL,
  APPEAL_REASON            VARCHAR2(100 BYTE),
  TOTAL_SERVICE_NBR        NUMBER,
  SERVICE_TYPE_CD          NUMBER               DEFAULT 0                     NOT NULL,
  CERT_COMPANY             VARCHAR2(100 BYTE),
  BNFT_TYPE_CD             NUMBER               DEFAULT 0                     NOT NULL,
  LAST_UPDATE_DT_TM        DATE,
  BEG_EFFECTIVE_DT_TM      DATE,
  END_EFFECTIVE_DT_TM      DATE,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0                     NOT NULL,
  DATA_STATUS_CD           NUMBER               DEFAULT 0                     NOT NULL,
  DATA_STATUS_PRSNL_ID     NUMBER               DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM        DATE,
  AUTH_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_REMAIN_CNT          NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_QUAL_CD             NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_REQUIRED_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_OBTAINED_DT_TM      DATE,
  COMMENT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  INTERCHANGE_ID           NUMBER               DEFAULT 0                     NOT NULL,
  CERT_TYPE_CD             NUMBER               DEFAULT 0                     NOT NULL,
  DELAY_REASON_CD          NUMBER               DEFAULT 0                     NOT NULL,
  REJECT_REASON_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ADMISSION_BEG_DT_TM      DATE,
  ADMISSION_END_DT_TM      DATE,
  SERVICE_BEG_DT_TM        DATE,
  SERVICE_END_DT_TM        DATE,
  AUTH_CNT_UNIT_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_CNT_TIME_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_TRANS_STATE_FLAG    NUMBER               DEFAULT 0                     NOT NULL,
  DISCHARGE_DT_TM          DATE,
  SURGICAL_DT_TM           DATE,
  TAXONOMY_ID              NUMBER               DEFAULT 0                     NOT NULL,
  PROVIDER_PRSNL_ID        NUMBER               DEFAULT 0                     NOT NULL,
  X12SERVICE_TYPE_CD       NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_CNT_TIME            FLOAT(126)           DEFAULT 0                     NOT NULL,
  AUTH_CNT_UNIT            FLOAT(126)           DEFAULT 0                     NOT NULL,
  AUTH_EXPIRE_DT_TM        DATE,
  FACILITY_CD              NUMBER               DEFAULT 0                     NOT NULL,
  X12PROVIDER_CD           NUMBER               DEFAULT 0                     NOT NULL,
  REFERENCE_NBR_TXT        VARCHAR2(100 BYTE),
  DELAY_REASON_COMMENT_ID  NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTHORIZATION_HIST
(
  AUTHORIZATION_HIST_ID    NUMBER               DEFAULT 0                     NOT NULL,
  AUTHORIZATION_ID         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID           NUMBER               DEFAULT 0                     NOT NULL,
  CERT_NBR                 VARCHAR2(50 BYTE),
  AUTH_NBR                 VARCHAR2(50 BYTE),
  CERT_PRSNL_ID            NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_TYPE_CD             NUMBER               DEFAULT 0                     NOT NULL,
  DESCRIPTION              VARCHAR2(200 BYTE),
  CERT_STATUS_CD           NUMBER               DEFAULT 0                     NOT NULL,
  APPEAL_REASON            VARCHAR2(100 BYTE),
  TOTAL_SERVICE_NBR        NUMBER,
  SERVICE_TYPE_CD          NUMBER               DEFAULT 0                     NOT NULL,
  CERT_COMPANY             VARCHAR2(100 BYTE),
  BNFT_TYPE_CD             NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0                     NOT NULL,
  DATA_STATUS_CD           NUMBER               DEFAULT 0                     NOT NULL,
  DATA_STATUS_PRSNL_ID     NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_REMAIN_CNT          NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_QUAL_CD             NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_REQUIRED_CD         NUMBER               DEFAULT 0                     NOT NULL,
  COMMENT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  INTERCHANGE_ID           NUMBER               DEFAULT 0                     NOT NULL,
  CERT_TYPE_CD             NUMBER               DEFAULT 0                     NOT NULL,
  DELAY_REASON_CD          NUMBER               DEFAULT 0                     NOT NULL,
  REJECT_REASON_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_CNT_UNIT_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_CNT_TIME_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_TRANS_STATE_FLAG    NUMBER               DEFAULT 0                     NOT NULL,
  TAXONOMY_ID              NUMBER               DEFAULT 0                     NOT NULL,
  PROVIDER_PRSNL_ID        NUMBER               DEFAULT 0                     NOT NULL,
  X12SERVICE_TYPE_CD       NUMBER               DEFAULT 0                     NOT NULL,
  AUTH_CNT_TIME            FLOAT(126)           DEFAULT 0                     NOT NULL,
  AUTH_CNT_UNIT            FLOAT(126)           DEFAULT 0                     NOT NULL,
  FACILITY_CD              NUMBER               DEFAULT 0                     NOT NULL,
  X12PROVIDER_CD           NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  AUTH_EXPIRE_DT_TM        DATE,
  AUTH_OBTAINED_DT_TM      DATE,
  BEG_EFFECTIVE_DT_TM      DATE,
  DATA_STATUS_DT_TM        DATE,
  DISCHARGE_DT_TM          DATE,
  LAST_UPDATE_DT_TM        DATE,
  SERVICE_END_DT_TM        DATE,
  SURGICAL_DT_TM           DATE,
  ADMISSION_BEG_DT_TM      DATE,
  ADMISSION_END_DT_TM      DATE,
  END_EFFECTIVE_DT_TM      DATE,
  SERVICE_BEG_DT_TM        DATE,
  REFERENCE_NBR_TXT        VARCHAR2(100 BYTE),
  TRANSACTION_DT_TM        DATE,
  DELAY_REASON_COMMENT_ID  NUMBER               DEFAULT 0                     NOT NULL,
  CHANGE_BIT               NUMBER               DEFAULT 0                     NOT NULL,
  PM_HIST_TRACKING_ID      NUMBER               DEFAULT 0                     NOT NULL,
  TRACKING_BIT             NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTHORIZATION_PROFILE
(
  AUTHORIZATION_PROFILE_ID  NUMBER              DEFAULT 0                     NOT NULL,
  PROFILE_PRSNL_ID          NUMBER              DEFAULT 0                     NOT NULL,
  PROFILE_TYPE_CD           NUMBER              DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID         NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTH_DETAIL
(
  AUTH_DETAIL_ID          NUMBER                DEFAULT 0                     NOT NULL,
  AUTHORIZATION_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  AUTH_COMPANY            VARCHAR2(100 BYTE),
  AUTH_PHONE_NUM          VARCHAR2(100 BYTE),
  AUTH_CONTACT            VARCHAR2(100 BYTE),
  AUTH_DT_TM              DATE,
  PLAN_CONTACT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTH_DETAIL_HIST
(
  AUTH_DETAIL_HIST_ID     NUMBER                DEFAULT 0                     NOT NULL,
  AUTH_DETAIL_ID          NUMBER                DEFAULT 0                     NOT NULL,
  AUTHORIZATION_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  AUTH_COMPANY            VARCHAR2(100 BYTE),
  AUTH_PHONE_NUM          VARCHAR2(100 BYTE),
  AUTH_CONTACT            VARCHAR2(100 BYTE),
  AUTH_DT_TM              DATE,
  PLAN_CONTACT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  TRANSACTION_DT_TM       DATE,
  CHANGE_BIT              NUMBER                DEFAULT 0                     NOT NULL,
  PM_HIST_TRACKING_ID     NUMBER                DEFAULT 0                     NOT NULL,
  TRACKING_BIT            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTH_ERROR
(
  AUTH_ERROR_ID       NUMBER                    DEFAULT 0                     NOT NULL,
  APPLICATION_NUMBER  NUMBER                    DEFAULT 0                     NOT NULL,
  TASK_NUMBER         NUMBER                    DEFAULT 0                     NOT NULL,
  PERSON_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  ERROR_DT_TM         DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTH_ERROR_DETAIL
(
  AUTH_ERROR_ID  NUMBER                         DEFAULT 0                     NOT NULL,
  SEQUENCE       NUMBER                         DEFAULT 0                     NOT NULL,
  DISPLAY_LABEL  VARCHAR2(20 BYTE),
  DISPLAY_VALUE  VARCHAR2(40 BYTE),
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTO_DIRECTED
(
  PRODUCT_EVENT_ID         NUMBER               DEFAULT 0                     NOT NULL,
  PRODUCT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ASSOCIATED_DT_TM         DATE,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  EXPECTED_USAGE_DT_TM     DATE,
  DONATED_BY_RELATIVE_IND  NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTO_MATCH_DEFINITION
(
  AUTO_MATCH_DEF_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVITY_SUBTYPE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  IM_DEVICE_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  RIS_TAG              VARCHAR2(11 BYTE)        DEFAULT ' '                   NOT NULL,
  IMAGE_TAG            VARCHAR2(11 BYTE)        DEFAULT ' '                   NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  HISTORICAL_IND       NUMBER,
  DISCIPLINE_CD        NUMBER                   DEFAULT 0                     NOT NULL,
  VALUE_TYPE           VARCHAR2(16 BYTE)        DEFAULT ' '
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AUTO_VERIFY
(
  AV_REF_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD       NUMBER              DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD             NUMBER              DEFAULT 0                     NOT NULL,
  PREV_VERF_IND             NUMBER              DEFAULT 0                     NOT NULL,
  DELTA_CHK_IND             NUMBER              DEFAULT 0                     NOT NULL,
  DUP_ASSAY_IND             NUMBER              DEFAULT 0                     NOT NULL,
  PREV_RSLT_IND             NUMBER              DEFAULT 0                     NOT NULL,
  UNVERF_PREV_RSLT_IND      NUMBER              DEFAULT 0                     NOT NULL,
  REF_RANGE_IND             NUMBER              DEFAULT 0                     NOT NULL,
  REV_RANGE_IND             NUMBER              DEFAULT 0                     NOT NULL,
  CRIT_RANGE_IND            NUMBER              DEFAULT 0                     NOT NULL,
  FEAS_RANGE_IND            NUMBER              DEFAULT 0                     NOT NULL,
  LIN_RANGE_IND             NUMBER              DEFAULT 0                     NOT NULL,
  REPEAT_FLAG               NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  SCRIPT                    CHAR(20 BYTE),
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  CONSISTENT_MAP            CHAR(50 BYTE),
  REPEAT_MAP                CHAR(50 BYTE),
  CONS_NBR_HRS              NUMBER,
  DEST_CODES                VARCHAR2(50 BYTE),
  DELTA_CHK_FLAG            NUMBER              DEFAULT 0                     NOT NULL,
  AV_STATUS_FLAG            NUMBER              DEFAULT 0                     NOT NULL,
  INSTR_ERROR_CODE_IND      NUMBER              DEFAULT 0                     NOT NULL,
  VALIDATE_QC_SCHEDULE_IND  NUMBER              DEFAULT 0                     NOT NULL,
  QC_INSTR_ERROR_CODE_IND   NUMBER              DEFAULT 0                     NOT NULL,
  NOTIFY_RANGE_IND          NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AV_CONSISTENCY
(
  AV_REF_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  AV_CONSISTENCY_FLAG    NUMBER                 DEFAULT 0                     NOT NULL,
  CONSISTENCY_IND        NUMBER                 DEFAULT 0                     NOT NULL,
  CONSISTENCY_MINUTES    NUMBER                 DEFAULT 0                     NOT NULL,
  CONSISTENCY_UNITS_CD   NUMBER                 DEFAULT 0                     NOT NULL,
  CONSISTENCY_TYPE_FLAG  NUMBER                 DEFAULT 0                     NOT NULL,
  CONSISTENCY_VARIANCE   FLOAT(126)             DEFAULT 0.0                   NOT NULL,
  ACTIVE_IND             NUMBER                 DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM    DATE                   DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM    DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AV_RES_CAT
(
  AV_RES_CAT_ID        NUMBER                   DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  CATALOG_CD           NUMBER                   DEFAULT 0                     NOT NULL,
  AV_RES_CAT_FLAG      NUMBER,
  ASSOC_CATALOG_CD     NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVE_IND           NUMBER,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE AV_STATUS_EVENT
(
  AV_EVENT_ID          NUMBER                   DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  ACCESSION_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  PERSON_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  AV_IND               NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD        NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_DENIAL_FILE_DETAIL_R
(
  BATCH_DENIAL_FILE_DETAIL_R_ID  NUMBER         DEFAULT 0                     NOT NULL,
  BATCH_DENIAL_FILE_R_ID         NUMBER         DEFAULT 0                     NOT NULL,
  REMARK_CODE_ATTRIB_CD          NUMBER         DEFAULT 0                     NOT NULL,
  REMARK_CODE_ATTRIB_VALUE       VARCHAR2(50 BYTE),
  ACTIVE_IND                     NUMBER,
  ACTIVE_STATUS_CD               NUMBER         DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM            DATE,
  ACTIVE_STATUS_PRSNL_ID         NUMBER         DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM            DATE           DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM            DATE           DEFAULT TO_DATE ( '12/31/210000:00:00' , 'MM/DD/YYYYHH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_DENIAL_FILE_R
(
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BATCH_DENIAL_FILE_R_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BATCH_TRANS_FILE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  DENIAL_CD               NUMBER                DEFAULT 0                     NOT NULL,
  DENIAL_TEXT             VARCHAR2(255 BYTE)    DEFAULT ' '                   NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  DENIAL_CODE_TXT         VARCHAR2(50 BYTE),
  DENIAL_TYPE_CD          NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_LABEL
(
  BATCH_LABEL_ID          NUMBER                DEFAULT 0                     NOT NULL,
  MEDIA_MASTER_ID         NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_DT_TM             DATE,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ALIAS_SORT_STRING       VARCHAR2(40 BYTE),
  HIM_PRINTER_FORMATS_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_TRANS
(
  BATCH_TRANS_ID              NUMBER            DEFAULT 0                     NOT NULL,
  PFT_EVENT_OCCUR_LOG_ID      NUMBER            DEFAULT 0                     NOT NULL,
  EXT_BATCH_ID_TXT            VARCHAR2(100 BYTE),
  BATCH_STATUS_CD             NUMBER            DEFAULT 0                     NOT NULL,
  SESSION_ID                  NUMBER            DEFAULT 0                     NOT NULL,
  PAY_STATED_TOTAL            FLOAT(126),
  DR_CR_PAY_STATED_FLAG       NUMBER,
  ADJ_STATED_TOTAL            FLOAT(126),
  DR_CR_ADJ_STATED_FLAG       NUMBER,
  FC_STATED_TOTAL             FLOAT(126),
  DR_CR_FC_STATED_FLAG        NUMBER,
  PAY_RESTATED_TOTAL          FLOAT(126),
  DR_CR_PAY_RESTATED_FLAG     NUMBER,
  ADJ_RESTATED_TOTAL          FLOAT(126),
  DR_CR_ADJ_RESTATED_FLAG     NUMBER,
  FC_RESTATED_TOTAL           FLOAT(126),
  DR_CR_FC_RESTATED_FLAG      NUMBER,
  PAY_COMPUTED_TOTAL          FLOAT(126),
  DR_CR_PAY_COMPUTED_FLAG     NUMBER,
  ADJ_COMPUTED_TOTAL          FLOAT(126),
  DR_CR_ADJ_COMPUTED_FLAG     NUMBER,
  FC_COMPUTED_TOTAL           FLOAT(126),
  DR_CR_FC_COMPUTED_FLAG      NUMBER,
  BATCHJOB_IND                NUMBER,
  SUBMITTED_IND               NUMBER,
  SUBMITTED_DT_TM             DATE,
  DEPOSIT_RECORD_ID           NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_IND                  NUMBER,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM         DATE              DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM         DATE              DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  PURGED_IND                  NUMBER,
  ONEPAYMENT_IND              NUMBER            DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID           NUMBER            DEFAULT 0                     NOT NULL,
  POST_DT_TM                  DATE,
  BATCH_TYPE_FLAG             NUMBER,
  CREATED_DT_TM               DATE              DEFAULT SYSDATE,
  CREATED_PRSNL_ID            NUMBER            DEFAULT 0                     NOT NULL,
  BATCH_CONTROL_NBR           VARCHAR2(20 BYTE),
  EXT_BATCH_ID_TXT_KEY        VARCHAR2(100 BYTE),
  EXT_BATCH_ID_TXT_KEY_NLS    VARCHAR2(100 BYTE),
  BATCH_ALIAS                 VARCHAR2(25 BYTE),
  BATCH_ALIAS_KEY             VARCHAR2(25 BYTE),
  BATCH_ALIAS_KEY_NLS         VARCHAR2(52 BYTE),
  RAW_BATCH_TRANS_ID          NUMBER            DEFAULT 0,
  EXT_BATCH_ID_TXT_KEY_A_NLS  VARCHAR2(400 BYTE),
  BATCH_ALIAS_KEY_A_NLS       VARCHAR2(100 BYTE),
  LOGICAL_DOMAIN_ID           NUMBER            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_TRANS_EXT
(
  BATCH_TRANS_EXT_ID       NUMBER               DEFAULT 0                     NOT NULL,
  BATCH_TRANS_ID           NUMBER               DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME       VARCHAR2(20 BYTE),
  PARENT_ENTITY_ID         NUMBER               DEFAULT 0                     NOT NULL,
  EDI_ADJ_REASON_CD        NUMBER               DEFAULT 0                     NOT NULL,
  EDI_ADJ_QUANTITY         NUMBER               DEFAULT 0                     NOT NULL,
  EDI_ADJ_AMOUNT           FLOAT(126)           DEFAULT 0.0                   NOT NULL,
  EDI_ADJ_DR_CR_FLAG       NUMBER               DEFAULT 0                     NOT NULL,
  INPAT_PROF_COMP_AMT      FLOAT(126)           DEFAULT 0.0                   NOT NULL,
  NON_INPAT_PROF_COMP_AMT  FLOAT(126)           DEFAULT 0.0                   NOT NULL,
  ESRD_PAYMENT_AMOUNT      FLOAT(126)           DEFAULT 0.0                   NOT NULL,
  POSTED_IND               NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVITY_ID              NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM      DATE                 DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM      DATE                 DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR             NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_TRANS_FILE
(
  BATCH_TRANS_FILE_ID       NUMBER              DEFAULT 0                     NOT NULL,
  BATCH_TRANS_ID            NUMBER              DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR              NUMBER,
  TRANS_TYPE_CD             NUMBER              DEFAULT 0                     NOT NULL,
  TRANS_SUBTYPE_CD          NUMBER              DEFAULT 0                     NOT NULL,
  TRANS_REASON_CD           NUMBER              DEFAULT 0                     NOT NULL,
  DR_CR_AR_FLAG             NUMBER,
  TRANS_TOTAL_AMOUNT        FLOAT(126),
  AR_ACCOUNT_ID             NUMBER              DEFAULT 0                     NOT NULL,
  FINANCE_CHRG_ID           NUMBER              DEFAULT 0                     NOT NULL,
  PAYMENT_METHOD_CD         NUMBER              DEFAULT 0                     NOT NULL,
  PAYMENT_NUM_DESC          VARCHAR2(250 BYTE),
  POST_DT_TM                DATE,
  CC_BEG_EFF_DT_TM          DATE,
  CC_END_EFF_DT_TM          DATE,
  CURRENT_CUR_CD            NUMBER              DEFAULT 0                     NOT NULL,
  ORIG_CUR_CD               NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM       DATE                DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  PURGED_IND                NUMBER,
  BENEFIT_ORDER_ID          NUMBER              DEFAULT 0                     NOT NULL,
  BILL_NBR_DISP             VARCHAR2(50 BYTE),
  BILL_VRSN_NBR             NUMBER,
  CC_AUTH_NBR               VARCHAR2(50 BYTE),
  CHECK_DATE                DATE,
  CHRG_ACTIVITY_ID          NUMBER              DEFAULT 0                     NOT NULL,
  CORSP_ACTIVITY_ID         NUMBER              DEFAULT 0                     NOT NULL,
  DR_CR_FLAG                NUMBER,
  ENCNTR_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  ERROR_IND                 NUMBER,
  ERROR_STATUS_CD           NUMBER              DEFAULT 0                     NOT NULL,
  NONTRANS_FLAG             NUMBER,
  PARENT_ENTITY_ID          NUMBER              DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME        VARCHAR2(255 BYTE),
  PAYOR_CNTRL_NBR_TXT       VARCHAR2(255 BYTE),
  PAYOR_NAME                VARCHAR2(60 BYTE),
  PFT_ENCNTR_ID             NUMBER              DEFAULT 0                     NOT NULL,
  POSTING_METHOD_CD         NUMBER              DEFAULT 0                     NOT NULL,
  RELATED_SEQ_NBR           NUMBER,
  ROLL_BO_IND               NUMBER,
  CREATED_DT_TM             DATE                DEFAULT SYSDATE,
  CREATED_PRSNL_ID          NUMBER              DEFAULT 0                     NOT NULL,
  TRANS_ALIAS_ID            NUMBER              DEFAULT 0                     NOT NULL,
  PATIENT_RESPONSIBILITY    FLOAT(126),
  CLAIM_STATUS_CD           NUMBER              DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID            NUMBER              DEFAULT 0                     NOT NULL,
  EDI_ADJ_GROUP_CD          NUMBER              DEFAULT 0                     NOT NULL,
  EDI_ADJ_QUANTITY          NUMBER              DEFAULT 0                     NOT NULL,
  INPAT_PROF_COMP_AMT       FLOAT(126)          DEFAULT 0.0                   NOT NULL,
  NON_INPAT_PROF_COMP_AMT   FLOAT(126)          DEFAULT 0.0                   NOT NULL,
  ESRD_PAYMENT_AMOUNT       FLOAT(126)          DEFAULT 0.0                   NOT NULL,
  CLAIM_FILE_CD             NUMBER              DEFAULT 0                     NOT NULL,
  POST_CLAIM_DEFAULT_IND    NUMBER              DEFAULT 0                     NOT NULL,
  TENDERED_AMOUNT           FLOAT(126),
  PFT_LINE_ITEM_ID          NUMBER              DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID              NUMBER              DEFAULT 0                     NOT NULL,
  CHANGE_DUE_AMT            FLOAT(126)          DEFAULT 0                     NOT NULL,
  RAW_BATCH_TRANS_FILE_ID   NUMBER              DEFAULT 0,
  TRANS_GROUP_NBR           NUMBER              DEFAULT 0,
  ERROR_STATUS_REASON_DESC  VARCHAR2(250 BYTE),
  EXTERNAL_IDENT            VARCHAR2(250 BYTE),
  GUARANTOR_PERSON_ID       NUMBER              DEFAULT 0,
  CC_TOKEN_TXT              VARCHAR2(250 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BATCH_TRANS_RELTN
(
  BATCH_TRANS_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  BATCH_TRANS_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVITY_ID             NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR            NUMBER,
  DISABLED_IND            NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BBHIST_PRODUCT
(
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_NBR             VARCHAR2(20 BYTE)     DEFAULT ' '                   NOT NULL,
  PRODUCT_SUB_NBR         CHAR(5 BYTE),
  ALTERNATE_NBR           VARCHAR2(20 BYTE),
  PRODUCT_CD              NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_CLASS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  SUPPLIER_ID             NUMBER                DEFAULT 0                     NOT NULL,
  SUPPLIER_PREFIX         CHAR(5 BYTE),
  ABO_CD                  NUMBER                DEFAULT 0                     NOT NULL,
  RH_CD                   NUMBER                DEFAULT 0                     NOT NULL,
  EXPIRE_DT_TM            DATE                  DEFAULT SYSDATE               NOT NULL,
  VOLUME                  NUMBER                DEFAULT 0,
  UNIT_MEAS_CD            NUMBER                DEFAULT 0                     NOT NULL,
  OWNER_AREA_CD           NUMBER                DEFAULT 0                     NOT NULL,
  INV_AREA_CD             NUMBER                DEFAULT 0                     NOT NULL,
  POOLED_PRODUCT_ID       NUMBER                DEFAULT 0                     NOT NULL,
  MODIFIED_PRODUCT_ID     NUMBER                DEFAULT 0                     NOT NULL,
  POOLED_PRODUCT_IND      NUMBER,
  MODIFIED_PRODUCT_IND    NUMBER,
  CROSS_REFERENCE         VARCHAR2(40 BYTE),
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPLOAD_DT_TM            DATE                  DEFAULT SYSDATE               NOT NULL,
  FLAG_CHARS              CHAR(2 BYTE),
  PRODUCT_NBR_FORMAT_CD   NUMBER                DEFAULT 0                     NOT NULL,
  DONOR_XREF_TXT          VARCHAR2(40 BYTE)     DEFAULT ' '
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BBHIST_PRODUCT_EVENT
(
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_DT_TM             DATE                  DEFAULT SYSDATE               NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  REASON_CD               NUMBER                DEFAULT 0                     NOT NULL,
  VOLUME                  NUMBER                DEFAULT 0,
  BAG_RETURNED_IND        NUMBER                DEFAULT 0,
  TAG_RETURNED_IND        NUMBER                DEFAULT 0,
  QTY                     NUMBER                DEFAULT 0,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  INTERNATIONAL_UNIT      NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_AUTODIR_EXCEPTION
(
  BB_AUTODIR_EXC_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BB_EXCEPTION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_DEVICE_TRANSFER
(
  PRODUCT_EVENT_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  PRODUCT_ID        NUMBER                      DEFAULT 0                     NOT NULL,
  FROM_DEVICE_ID    NUMBER                      DEFAULT 0                     NOT NULL,
  TO_DEVICE_ID      NUMBER                      DEFAULT 0                     NOT NULL,
  REASON_CD         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_DSPNS_BLOCK
(
  DISPENSE_BLOCK_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_CD              NUMBER                DEFAULT 0                     NOT NULL,
  ALLOW_OVERRIDE_IND      NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_DSPNS_BLOCK_PRODUCT
(
  BLOCK_PRODUCT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  DISPENSE_BLOCK_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_CD              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EDN_ADMIN
(
  BB_EDN_ADMIN_ID          NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_NBR_IDENT          VARCHAR2(12 BYTE)    DEFAULT ' '                   NOT NULL,
  DISPATCH_NBR_TXT         VARCHAR2(12 BYTE)    DEFAULT ' '                   NOT NULL,
  ADMIN_DT_TM              DATE                 DEFAULT SYSDATE               NOT NULL,
  SOURCE_ORG_ID            NUMBER               DEFAULT 0                     NOT NULL,
  DESTINATION_LOC_CD       NUMBER               DEFAULT 0                     NOT NULL,
  PROTOCOL_NBR             NUMBER               DEFAULT 0                     NOT NULL,
  EDN_COMPLETE_IND         NUMBER               DEFAULT 0                     NOT NULL,
  LONG_BLOB_ID             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  DESTINATION_INV_AREA_CD  NUMBER               DEFAULT 0,
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EDN_DSCRPNCY_OVRD
(
  BB_EDN_DSCRPNCY_OVRD_ID  NUMBER               DEFAULT 0                     NOT NULL,
  BB_EDN_ADMIN_ID          NUMBER               DEFAULT 0                     NOT NULL,
  BB_EDN_PRODUCT_ID        NUMBER               DEFAULT 0                     NOT NULL,
  PRODUCT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  EXCEPTION_ID             NUMBER               DEFAULT 0                     NOT NULL,
  EDN_PRODUCT_NBR_IDENT    VARCHAR2(20 BYTE)    DEFAULT ' '                   NOT NULL,
  PRODUCT_CD               NUMBER               DEFAULT 0                     NOT NULL,
  OVRD_REASON_CD           NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EDN_PROBLEM
(
  BB_EDN_PROBLEM_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  BB_EDN_PRODUCT_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  PROBLEM_TYPE_CD    NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EDN_PRODUCT
(
  BB_EDN_PRODUCT_ID            NUMBER           DEFAULT 0                     NOT NULL,
  BB_EDN_ADMIN_ID              NUMBER           DEFAULT 0                     NOT NULL,
  EDN_PRODUCT_NBR_IDENT        VARCHAR2(20 BYTE) DEFAULT ' ' NOT NULL,
  PRODUCT_TYPE_TXT             VARCHAR2(50 BYTE) DEFAULT ' ' NOT NULL,
  ABO_CD                       NUMBER           DEFAULT 0                     NOT NULL,
  RH_CD                        NUMBER           DEFAULT 0                     NOT NULL,
  DONATION_DT_TM               DATE,
  EXPIRATION_DT_TM             DATE             DEFAULT SYSDATE,
  VOLUME_CNT                   NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_COMMENT_TXT          VARCHAR2(30 BYTE) DEFAULT ' ' NOT NULL,
  DELIVERY_TYPE_CD             NUMBER           DEFAULT 0                     NOT NULL,
  CLINICAL_USE_IND             NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_ID                   NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_COMPLETE_IND         NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  FLAG_CHAR_TXT                VARCHAR2(2 BYTE),
  PRODUCT_CD                   NUMBER           DEFAULT 0,
  ISBT_BLOOD_TYPE_BARCODE      VARCHAR2(200 BYTE),
  SUPPLIER_PRODUCT_ALIAS_NAME  VARCHAR2(40 BYTE),
  LONG_TEXT_ID                 NUMBER           DEFAULT 0,
  PRODUCT_SUB_NBR_TXT          VARCHAR2(5 BYTE),
  EVENT_DT_TM                  DATE,
  EVENT_PRSNL_ID               NUMBER           DEFAULT 0,
  PERSON_ID                    NUMBER           DEFAULT 0,
  ALIAS                        VARCHAR2(100 BYTE),
  STATUS_CD                    NUMBER           DEFAULT 0,
  UNIT_CONDITION_CD            NUMBER           DEFAULT 0,
  DEVICE_TXT                   VARCHAR2(40 BYTE),
  SUB_STATUS_CD                NUMBER           DEFAULT 0,
  ALIAS_POOL_CD                NUMBER           DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EDN_SPCL_TESTING
(
  BB_EDN_SPCL_TESTING_ID          NUMBER        DEFAULT 0                     NOT NULL,
  BB_EDN_PRODUCT_ID               NUMBER        DEFAULT 0                     NOT NULL,
  SPCL_TESTING_CD                 NUMBER        DEFAULT 0                     NOT NULL,
  CONFIRMED_IND                   NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                      DATE          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                         NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_TASK                       NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                    NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_CNT                        NUMBER        DEFAULT 0                     NOT NULL,
  ISBT_SPCL_TEST_BARCODE          VARCHAR2(200 BYTE),
  ISBT_SPCL_TEST_BARCODE_TYP_TXT  VARCHAR2(2 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EXCEPTION
(
  EXCEPTION_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  EXCEPTION_TYPE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD      NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  FROM_ABO_CD             NUMBER                DEFAULT 0                     NOT NULL,
  FROM_RH_CD              NUMBER                DEFAULT 0                     NOT NULL,
  TO_ABO_CD               NUMBER                DEFAULT 0                     NOT NULL,
  TO_RH_CD                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  PERFORM_RESULT_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  DONOR_CONTACT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  DONOR_CONTACT_TYPE_CD   NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_BY_PRSNL_ID      NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_DT_TM            DATE,
  REVIEW_DOC_ID           NUMBER                DEFAULT 0                     NOT NULL,
  EXCEPTION_DT_TM         DATE,
  EXCEPTION_PRSNL_ID      NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_ID                NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ABO_CD           NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_RH_CD            NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ABO_CD          NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_RH_CD           NUMBER                DEFAULT 0                     NOT NULL,
  DEFAULT_EXPIRE_DT_TM    DATE,
  DONATION_IDENT          VARCHAR2(20 BYTE),
  PROCEDURE_CD            NUMBER                DEFAULT 0,
  INELIGIBLE_UNTIL_DT_TM  DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EXCEPT_CXM
(
  BB_EXCEPT_CXM_ID        NUMBER                DEFAULT 0                     NOT NULL,
  BB_EXCEPTION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  MESSAGE_CD              NUMBER                DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD      NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_EXC_CXM_PRODUCT
(
  BB_EXC_CXM_PRODUCT_ID    NUMBER               DEFAULT 0                     NOT NULL,
  BB_EXCEPTION_ID          NUMBER               DEFAULT 0                     NOT NULL,
  PRODUCT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  PRODUCT_CD               NUMBER               DEFAULT 0                     NOT NULL,
  ABO_CD                   NUMBER               DEFAULT 0                     NOT NULL,
  RH_CD                    NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_DT_TM              DATE,
  CROSSMATCH_EXPIRE_DT_TM  DATE,
  PRODUCT_EVENT_ID         NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_FACILITY_PRINTER_R
(
  BB_FACILITY_PRINTER_R_ID  NUMBER              DEFAULT 0                     NOT NULL,
  BB_ORGANIZATION_ID        NUMBER              DEFAULT 0                     NOT NULL,
  BB_PRINTER_ID             NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_INVENTORY_AREA
(
  SERVICE_RESOURCE_CD   NUMBER                  DEFAULT 0                     NOT NULL,
  BB_DEVICE_TYPE_CD     NUMBER                  DEFAULT 0                     NOT NULL,
  BB_PROD_IND           NUMBER,
  BB_MONITORED_TEMP_HI  FLOAT(126),
  BB_MONITORED_TEMP_LO  FLOAT(126),
  BB_BARCODE_ID         NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_INVENTORY_TRANSFER
(
  PRODUCT_EVENT_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  FROM_OWNER_AREA_CD     NUMBER                 DEFAULT 0                     NOT NULL,
  FROM_INV_AREA_CD       NUMBER                 DEFAULT 0                     NOT NULL,
  TRANSFER_REASON_CD     NUMBER                 DEFAULT 0                     NOT NULL,
  TO_OWNER_AREA_CD       NUMBER                 DEFAULT 0                     NOT NULL,
  TO_INV_AREA_CD         NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  TRANSFERRED_QTY        NUMBER,
  TRANSFERRED_INTL_UNIT  NUMBER,
  TO_PRODUCT_EVENT_ID    NUMBER                 DEFAULT 0,
  EVENT_TYPE_CD          NUMBER                 DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_ISBT_SUPPLIER
(
  BB_ISBT_SUPPLIER_ID     NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ISBT_SUPPLIER_FIN       VARCHAR2(5 BYTE),
  INVENTORY_AREA_CD       NUMBER                DEFAULT 0                     NOT NULL,
  LICENSE_NBR_TXT         VARCHAR2(15 BYTE),
  REGISTRATION_NBR_TXT    VARCHAR2(15 BYTE),
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_LABEL_VERIFY
(
  BB_LABEL_VERIFY_ID      NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  LABEL_VERF_DT_TM        DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  PERSONNEL_ID            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_MOD_NEW_PRODUCT
(
  MOD_NEW_PROD_ID          NUMBER               DEFAULT 0                     NOT NULL,
  OPTION_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ORIG_PRODUCT_CD          NUMBER               DEFAULT 0                     NOT NULL,
  NEW_PRODUCT_CD           NUMBER               DEFAULT 0                     NOT NULL,
  QUANTITY                 FLOAT(126),
  DEFAULT_SUB_ID_FLAG      NUMBER,
  MAX_PREP_HRS             FLOAT(126),
  DEFAULT_ORIG_EXP_IND     NUMBER,
  CALC_EXP_DRAWN_IND       NUMBER,
  DEFAULT_EXP_DAYS         FLOAT(126),
  DEFAULT_EXP_HRS          FLOAT(126),
  ALLOW_EXTEND_EXP_IND     NUMBER,
  DEFAULT_ORIG_VOL_IND     NUMBER,
  DEFAULT_VOLUME           FLOAT(126),
  CALC_VOL_IND             NUMBER,
  PROMPT_VOL_IND           NUMBER,
  VALIDATE_VOL_IND         NUMBER,
  DEFAULT_UNIT_OF_MEAS_CD  NUMBER               DEFAULT 0                     NOT NULL,
  SYNONYM_ID               NUMBER               DEFAULT 0                     NOT NULL,
  REQUIRE_ASSIGN_IND       NUMBER,
  BAG_TYPE_CD              NUMBER               DEFAULT 0                     NOT NULL,
  CROSSOVER_REASON_CD      NUMBER               DEFAULT 0                     NOT NULL,
  ALLOW_NO_ABORH_IND       NUMBER,
  DEFAULT_SUPPLIER_ID      NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  ORIG_PLASMA_PROD_CD      NUMBER               DEFAULT 0,
  ISBT_BARCODE             VARCHAR2(20 BYTE),
  CODABAR_BARCODE          VARCHAR2(20 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_MOD_POOL_NBR
(
  MOD_POOL_NBR_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  OPTION_ID          NUMBER                     DEFAULT 0                     NOT NULL,
  PREFIX             VARCHAR2(10 BYTE)          DEFAULT ' '                   NOT NULL,
  YEAR               NUMBER                     DEFAULT 0                     NOT NULL,
  SEQ_NBR            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  ORGANIZATION_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  ISBT_SUPPLIER_FIN  VARCHAR2(5 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_MOD_SPECIAL_TESTING
(
  MOD_NEW_PROD_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  SPECIAL_TESTING_CD  NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_ORDER_CELL
(
  ORDER_ID        NUMBER                        DEFAULT 0                     NOT NULL,
  ORDER_CELL_ID   NUMBER                        DEFAULT 0                     NOT NULL,
  CELL_CD         NUMBER                        DEFAULT 0                     NOT NULL,
  PRODUCT_ID      NUMBER                        DEFAULT 0                     NOT NULL,
  PHASE_GROUP_CD  NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL,
  BB_RESULT_ID    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_ORDER_PHASE
(
  ORDER_ID        NUMBER                        DEFAULT 0                     NOT NULL,
  ORDER_PHASE_ID  NUMBER                        DEFAULT 0                     NOT NULL,
  PHASE_GRP_CD    NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_QC_GROUP_ACTIVITY
(
  GROUP_ACTIVITY_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  GROUP_ID           NUMBER                     DEFAULT 0                     NOT NULL,
  RELATED_GROUP_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  LOCK_PRSNL_ID      NUMBER                     DEFAULT 0                     NOT NULL,
  SCHEDULED_DT_TM    DATE                       DEFAULT SYSDATE               NOT NULL,
  LOCK_DT_TM         DATE                       DEFAULT SYSDATE,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_QC_GRP_REAGENT_ACTIVITY
(
  GROUP_REAGENT_ACTIVITY_ID  NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_REAGENT_LOT_ID       NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_ACTIVITY_ID          NUMBER             DEFAULT 0                     NOT NULL,
  VISUAL_INSPECTION_CD       NUMBER             DEFAULT 0                     NOT NULL,
  INTERPRETATION_CD          NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVITY_DT_TM             DATE               DEFAULT SYSDATE               NOT NULL,
  ACTIVITY_PRSNL_ID          NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_QC_GRP_REAGENT_LOT
(
  GROUP_REAGENT_LOT_ID       NUMBER             DEFAULT 0                     NOT NULL,
  PREV_GROUP_REAGENT_LOT_ID  NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  LOT_INFORMATION_ID         NUMBER             DEFAULT 0                     NOT NULL,
  RELATED_REAGENT_ID         NUMBER             DEFAULT 0                     NOT NULL,
  CURRENT_IND                NUMBER             DEFAULT 0                     NOT NULL,
  DISPLAY_ORDER_SEQ          NUMBER             DEFAULT 0                     NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_QC_RESULT
(
  QC_RESULT_ID               NUMBER             DEFAULT 0                     NOT NULL,
  GROUP_REAGENT_ACTIVITY_ID  NUMBER             DEFAULT 0                     NOT NULL,
  ENHANCEMENT_ACTIVITY_ID    NUMBER             DEFAULT 0                     NOT NULL,
  CONTROL_ACTIVITY_ID        NUMBER             DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  RESULT_DT_TM               DATE               DEFAULT SYSDATE               NOT NULL,
  RESULT_PRSNL_ID            NUMBER             DEFAULT 0                     NOT NULL,
  ABNORMAL_IND               NUMBER             DEFAULT 0                     NOT NULL,
  REASON_CD                  NUMBER             DEFAULT 0                     NOT NULL,
  STATUS_CD                  NUMBER             DEFAULT 0                     NOT NULL,
  PHASE_CD                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  PRIMARY_REVIEW_DT_TM       DATE               DEFAULT SYSDATE               NOT NULL,
  PRIMARY_REVIEW_PRSNL_ID    NUMBER             DEFAULT 0                     NOT NULL,
  SECONDARY_REVIEW_DT_TM     DATE               DEFAULT SYSDATE               NOT NULL,
  SECONDARY_REVIEW_PRSNL_ID  NUMBER             DEFAULT 0                     NOT NULL,
  COMMENT_TEXT_ID            NUMBER             DEFAULT 0                     NOT NULL,
  ACTION_PRSNL_ID            NUMBER             DEFAULT 0                     NOT NULL,
  ACTION_DT_TM               DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_QC_RESULT_TROUBLESHOOTING_R
(
  RESULT_TROUBLESHOOTING_ID  NUMBER             DEFAULT 0                     NOT NULL,
  QC_RESULT_ID               NUMBER             DEFAULT 0                     NOT NULL,
  TROUBLESHOOTING_ID         NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_REQS_EXCEPTION
(
  REQS_EXCEPTION_ID       NUMBER                DEFAULT 0                     NOT NULL,
  EXCEPTION_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SPECIAL_TESTING_CD      NUMBER                DEFAULT 0                     NOT NULL,
  REQUIREMENT_CD          NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_REVIEW_QUEUE
(
  BB_REVIEW_QUEUE_ID      NUMBER                DEFAULT 0                     NOT NULL,
  FROM_PERSON_ID          NUMBER                DEFAULT 0                     NOT NULL,
  TO_PERSON_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE),
  FROM_PARENT_ENTITY_ID   NUMBER                DEFAULT 0                     NOT NULL,
  TO_PARENT_ENTITY_ID     NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_OUTCOME_CD       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UNCOMBINE_IND           NUMBER,
  FROM_ENCNTR_ID          NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_DOC_ID           NUMBER                DEFAULT 0                     NOT NULL,
  REVIEW_DT_TM            DATE,
  TO_ENCNTR_ID            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_SHIPMENT
(
  SHIPMENT_ID             NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  SHIPMENT_NBR            NUMBER                DEFAULT 0                     NOT NULL,
  SHIPMENT_DT_TM          DATE,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SHIPMENT_STATUS_FLAG    NUMBER                DEFAULT 0                     NOT NULL,
  NEEDED_DT_TM            DATE,
  COURIER_CD              NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_PLACED_BY         VARCHAR2(100 BYTE),
  RECORDED_BY_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  OWNER_AREA_CD           NUMBER                DEFAULT 0                     NOT NULL,
  INVENTORY_AREA_CD       NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_DT_TM             DATE,
  ORDER_PRIORITY_CD       NUMBER                DEFAULT 0,
  FROM_FACILITY_CD        NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_SHIP_CONTAINER
(
  CONTAINER_ID            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  CONTAINER_NBR           NUMBER                DEFAULT 0                     NOT NULL,
  SHIPMENT_ID             NUMBER                DEFAULT 0                     NOT NULL,
  CONTAINER_TYPE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  CONTAINER_CONDITION_CD  NUMBER                DEFAULT 0                     NOT NULL,
  TOTAL_WEIGHT            NUMBER                DEFAULT 0                     NOT NULL,
  UNIT_OF_MEAS_CD         NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  TEMPERATURE_DEGREE_CD   NUMBER                DEFAULT 0,
  TEMPERATURE_VALUE       NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_SHIP_EVENT
(
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CONTAINER_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  SHIPMENT_ID             NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  RETURN_VIS_INSP_CD      NUMBER                DEFAULT 0                     NOT NULL,
  RETURN_DT_TM            DATE,
  RETURN_CONDITION_CD     NUMBER                DEFAULT 0                     NOT NULL,
  FROM_OWNER_AREA_CD      NUMBER                DEFAULT 0                     NOT NULL,
  FROM_INVENTORY_AREA_CD  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  VIS_INSP_CD             NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_SPEC_EXPIRE_OVRD
(
  BB_SPEC_EXPIRE_OVRD_ID  NUMBER                DEFAULT 0                     NOT NULL,
  EXCEPTION_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SPECIMEN_ID             NUMBER                DEFAULT 0                     NOT NULL,
  OVERRIDE_REASON_CD      NUMBER                DEFAULT 0                     NOT NULL,
  NEW_SPEC_EXPIRE_DT_TM   DATE,
  PREV_SPEC_EXPIRE_DT_TM  DATE,
  OVERRIDE_DT_TM          DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_SPEC_EXP_OVRD_PROD
(
  BB_SPEC_EXP_OVRD_PROD_ID  NUMBER              DEFAULT 0                     NOT NULL,
  BB_SPEC_EXPIRE_OVRD_ID    NUMBER              DEFAULT 0                     NOT NULL,
  PRODUCT_ID                NUMBER              DEFAULT 0                     NOT NULL,
  NEW_XM_EXPIRE_DT_TM       DATE,
  PREV_XM_EXPIRE_DT_TM      DATE,
  PRODUCT_EVENT_ID          NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_SUPPLIER
(
  BB_SUPPLIER_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BARCODE_VALUE           CHAR(20 BYTE),
  PREFIX_IND              NUMBER,
  PREFIX_VALUE            CHAR(5 BYTE),
  DEFAULT_PREFIX_IND      NUMBER,
  ALPHA_TRANSLATION_IND   NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ISBT_BARCODE            VARCHAR2(15 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_UPLOAD_LONG_TEXT_R
(
  BB_UPLOAD_LONG_TEXT_R_ID  NUMBER              DEFAULT 0                     NOT NULL,
  BB_UPLOAD_REVIEW_ID       NUMBER              DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID              NUMBER              DEFAULT 0                     NOT NULL,
  ACTION_CD                 NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_UPLOAD_PERSON_ABORH_R
(
  BB_UPLOAD_PERSON_ABORH_R_ID  NUMBER           DEFAULT 0                     NOT NULL,
  BB_UPLOAD_REVIEW_ID          NUMBER           DEFAULT 0                     NOT NULL,
  PERSON_ABORH_ID              NUMBER           DEFAULT 0                     NOT NULL,
  DEMOG_ABORH_DT_TM            DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_UPLOAD_REVIEW
(
  BB_UPLOAD_REVIEW_ID     NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  UPLOAD_PERSON_ABORH_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPLOAD_DT_TM            DATE                  DEFAULT SYSDATE               NOT NULL,
  DEMOG_PERSON_ABORH_ID   NUMBER                DEFAULT 0                     NOT NULL,
  DEMOG_ABORH_DT_TM       DATE,
  REVIEWED_IND            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_WORKLIST
(
  WORKLIST_ID              NUMBER               DEFAULT 0                     NOT NULL,
  WORKLIST_NAME            VARCHAR2(40 BYTE)    DEFAULT ' '                   NOT NULL,
  WORKLIST_NAME_KEY        VARCHAR2(40 BYTE)    DEFAULT ' '                   NOT NULL,
  WORKLIST_NAME_KEY_NLS    VARCHAR2(82 BYTE)    DEFAULT ' '                   NOT NULL,
  CREATE_PRSNL_ID          NUMBER               DEFAULT 0                     NOT NULL,
  CREATE_DT_TM             DATE                 DEFAULT SYSDATE               NOT NULL,
  QC_GROUP_ID              NUMBER               DEFAULT 0                     NOT NULL,
  TEST_GROUP_ID            NUMBER               DEFAULT 0                     NOT NULL,
  DOWNLOAD_IND             NUMBER               DEFAULT 0                     NOT NULL,
  LAST_DOWNLOAD_DT_TM      DATE,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  WORKLIST_NAME_KEY_A_NLS  VARCHAR2(160 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BB_WORKLIST_DETAIL
(
  WORKLIST_DETAIL_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  WORKLIST_ID         NUMBER                    DEFAULT 0                     NOT NULL,
  ORDER_ID            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BCE_EVENT_BILL_MOD_RELTN
(
  BCE_EVENT_BILL_MOD_RELTN_ID  NUMBER           DEFAULT 0                     NOT NULL,
  BCE_EVENT_LOG_ID             NUMBER           DEFAULT 0                     NOT NULL,
  BILL_ITEM_MOD_ID             NUMBER           DEFAULT 0                     NOT NULL,
  PROMPT_VALUE                 VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BCE_EVENT_LOG
(
  BCE_EVENT_LOG_ID        NUMBER                DEFAULT 0                     NOT NULL,
  BATCH_NUM               FLOAT(126),
  EXT_MASTER_EVENT_ID     NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERF_LOC_CD             NUMBER                DEFAULT 0                     NOT NULL,
  REN_PHYS_ID             NUMBER                DEFAULT 0                     NOT NULL,
  ORD_PHYS_ID             NUMBER                DEFAULT 0                     NOT NULL,
  REF_PHYS_ID             NUMBER                DEFAULT 0                     NOT NULL,
  ACCESSION               VARCHAR2(200 BYTE),
  BILL_ITEM_ID            NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_DESCRIPTION      VARCHAR2(200 BYTE),
  SERVICE_DT_TM           DATE,
  QUANTITY                FLOAT(126),
  DIAG_CODE1              VARCHAR2(200 BYTE),
  DIAG_CODE1_DESC         VARCHAR2(200 BYTE),
  DIAG_CODE2              VARCHAR2(200 BYTE),
  DIAG_CODE2_DESC         VARCHAR2(200 BYTE),
  DIAG_CODE3              VARCHAR2(200 BYTE),
  DIAG_CODE3_DESC         VARCHAR2(200 BYTE),
  DIAG_CODE4              VARCHAR2(200 BYTE),
  DIAG_CODE4_DESC         VARCHAR2(200 BYTE),
  DIAG_CODE5              VARCHAR2(200 BYTE),
  DIAG_CODE5_DESC         VARCHAR2(200 BYTE),
  DIAG_CODE6              VARCHAR2(200 BYTE),
  DIAG_CODE6_DESC         VARCHAR2(200 BYTE),
  DIAG_CODE7              VARCHAR2(200 BYTE),
  DIAG_CODE7_DESC         VARCHAR2(200 BYTE),
  ABN_STATUS_CD           NUMBER                DEFAULT 0                     NOT NULL,
  PRICE                   FLOAT(126),
  EPSDT_IND               NUMBER,
  CODE_MODIFIER1_CD       NUMBER                DEFAULT 0                     NOT NULL,
  CODE_MODIFIER2_CD       NUMBER                DEFAULT 0                     NOT NULL,
  CODE_MODIFIER3_CD       NUMBER                DEFAULT 0                     NOT NULL,
  CODE_MODIFIER4_CD       NUMBER                DEFAULT 0                     NOT NULL,
  REASON_COMMENT          VARCHAR2(200 BYTE),
  REASON_CD               NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_TYPE_CD          NUMBER                DEFAULT 0                     NOT NULL,
  INSTITUTION_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DEPARTMENT_CD           NUMBER                DEFAULT 0                     NOT NULL,
  SECTION_CD              NUMBER                DEFAULT 0                     NOT NULL,
  SUBSECTION_CD           NUMBER                DEFAULT 0                     NOT NULL,
  LEVEL5_CD               NUMBER                DEFAULT 0                     NOT NULL,
  SUBMIT_IND              NUMBER,
  MISC_IND                NUMBER,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  MODE_IND                NUMBER,
  BILL_CODE_TXT           VARCHAR2(200 BYTE),
  BATCH_ALIAS             VARCHAR2(200 BYTE)    DEFAULT ' '                   NOT NULL,
  BATCH_DESCRIPTION       VARCHAR2(200 BYTE)    DEFAULT ' '                   NOT NULL,
  BATCH_DT_TM             DATE                  DEFAULT SYSDATE               NOT NULL,
  PAYMENT_AMT             FLOAT(126)            DEFAULT 0.0                   NOT NULL,
  ADJUSTMENT_AMT          FLOAT(126)            DEFAULT 0.0                   NOT NULL,
  BATCH_ALIAS_KEY         VARCHAR2(200 BYTE)    DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BED
(
  LOCATION_CD             NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  LOC_ROOM_CD             NUMBER                DEFAULT 0                     NOT NULL,
  BED_STATUS_CD           NUMBER                DEFAULT 0,
  DUP_BED_IND             NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BENEFIT_ORDER
(
  BENEFIT_ORDER_ID             NUMBER           DEFAULT 0                     NOT NULL,
  ENCNTR_PLAN_RELTN_ID         NUMBER           DEFAULT 0                     NOT NULL,
  EPR_UPT_CNT                  NUMBER,
  HEALTH_PLAN_ID               NUMBER           DEFAULT 0                     NOT NULL,
  PARENT_BO_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  FIN_CLASS_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  PRIORITY_SEQ                 NUMBER,
  PRI_CONCURRENT_IND           NUMBER,
  SEC_CONCURRENT_IND           NUMBER,
  PAT_CONCURRENT_IND           NUMBER,
  CROSS_OVER_IND               NUMBER,
  DISP_NONCOVERED_IND          NUMBER,
  MAN_EDIT_IND                 NUMBER,
  ACTIVE_IND                   NUMBER,
  ACTIVE_STATUS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM          DATE,
  ACTIVE_STATUS_PRSNL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE,
  END_EFFECTIVE_DT_TM          DATE,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  PAT_BILL_PREF_FLAG           NUMBER,
  BO_STATUS_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  BO_STATUS_REASON_CD          NUMBER           DEFAULT 0                     NOT NULL,
  SUBSCRIBER_ID                NUMBER           DEFAULT 0                     NOT NULL,
  CONS_BO_SCHED_ID             NUMBER           DEFAULT 0                     NOT NULL,
  ORIG_BILL_DT_TM              DATE,
  ORIG_DUE_DT_TM               DATE,
  UB_BILL_CLASS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  UB_BILL_FREQ_CD              NUMBER           DEFAULT 0                     NOT NULL,
  UB_FACILITY_TYPE_CD          NUMBER           DEFAULT 0                     NOT NULL,
  PFT_ENCNTR_ID                NUMBER           DEFAULT 0                     NOT NULL,
  BT_CONDITION_ID              NUMBER           DEFAULT 0                     NOT NULL,
  TOTAL_CHARGE_AMT             FLOAT(126)       DEFAULT 0.0                   NOT NULL,
  TOTAL_CHARGE_AMT_DR_CR_FLAG  NUMBER,
  EOP_DT_TM                    DATE,
  PRORATION_FLAG               NUMBER           DEFAULT 0,
  PREVIOUS_PFT_ENCNTR_ID       NUMBER           DEFAULT 0                     NOT NULL,
  END_SERVICE_DT_TM            DATE,
  BEG_SERVICE_DT_TM            DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_AT_RELTN
(
  BE_AT_RELTN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ACCT_TEMPL_ID           NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACCESS_CD               NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_CUSTOM_OBJ_RELTN
(
  BE_CUSTOM_OBJ_RELTN_ID       NUMBER           DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID            NUMBER           DEFAULT 0                     NOT NULL,
  BILL_TYPE_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  MEDIA_TYPE_CD                NUMBER           DEFAULT 0                     NOT NULL,
  CUSTOM_OBJ_NAME              VARCHAR2(32 BYTE),
  ACTIVE_IND                   NUMBER,
  ACTIVE_STATUS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM          DATE,
  ACTIVE_STATUS_PRSNL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE             DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM          DATE             DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  CUSTOM_IMAGE1                VARCHAR2(250 BYTE),
  CUSTOM_IMAGE2                VARCHAR2(250 BYTE),
  TRANSFORMATION_OBJ_NAME_TXT  VARCHAR2(30 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_DOMAIN
(
  BE_DOMAIN_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  DOMAIN_TYPE_CD          NUMBER                DEFAULT 0                     NOT NULL,
  LIFETIME_ENCNTR_IND     NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_GL_ALIAS_RELTN
(
  BE_GL_ALIAS_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  GL_ALIAS_ID             NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  LOCATION_CD             NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_GROUP_RELTN
(
  BE_GROUP_RELTN_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BT_COND_CRIT_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_HISTORY
(
  BE_HISTORY_ID             NUMBER              DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID           NUMBER              DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID         NUMBER              DEFAULT 0                     NOT NULL,
  BE_NAME                   VARCHAR2(50 BYTE),
  BE_DESC                   VARCHAR2(250 BYTE),
  BE_VRSN_NBR               NUMBER              DEFAULT 0                     NOT NULL,
  PARENT_BE_ID              NUMBER              DEFAULT 0                     NOT NULL,
  DEF_POST_METHOD_CD        NUMBER              DEFAULT 0                     NOT NULL,
  CURRENCY_TYPE_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE,
  END_EFFECTIVE_DT_TM       DATE,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  BE_NAME_KEY               VARCHAR2(250 BYTE),
  STD_DELAY                 NUMBER,
  PLACE_OF_SERVICE          VARCHAR2(2 BYTE),
  RECUR_BILL_OPT_FLAG       NUMBER,
  RECUR_BILL_WHAT_DAY       NUMBER,
  RECUR_WAIT_CODE_FLAG      NUMBER,
  RECUR_GEN_DELAY_IND       NUMBER,
  RECUR_GEN_DELAY           NUMBER,
  RUG_CD_ORDER_FLAG         NUMBER,
  QCF_ROUNDING_FLAG         NUMBER              DEFAULT 0                     NOT NULL,
  HCFA_1500_DX_FLAG         NUMBER,
  RECLASS_RECEIVE_IND       NUMBER              DEFAULT 0                     NOT NULL,
  PROC_CODE_IND             NUMBER              DEFAULT 0                     NOT NULL,
  PROGRAM_CD                NUMBER              DEFAULT 0                     NOT NULL,
  SEQ_START_NBR             FLOAT(126)          DEFAULT 0                     NOT NULL,
  CURRENT_SEQ_NBR           FLOAT(126)          DEFAULT 0                     NOT NULL,
  DAYS_TO_EVAL              NUMBER              DEFAULT 0                     NOT NULL,
  ZERO_BALANCE_WAIT         NUMBER              DEFAULT 0                     NOT NULL,
  BAD_DEBT_CHECK_IND        NUMBER              DEFAULT 0                     NOT NULL,
  ENCNTR_LIFE_IND           NUMBER              DEFAULT 0                     NOT NULL,
  CALCULATED_BALANCE_IND    NUMBER              DEFAULT 0                     NOT NULL,
  SUPPRESS_OFFSET_DRCR_IND  NUMBER              DEFAULT 0                     NOT NULL,
  FEE_SCHED_FLAG            NUMBER,
  AR_ACCT_ID                NUMBER              DEFAULT 0                     NOT NULL,
  DEFAULT_SELFPAY_HP_ID     NUMBER              DEFAULT 0                     NOT NULL,
  POST_CD                   NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_ORG_RELTN
(
  BE_ORG_RELTN_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_PRSNL_GROUP_R
(
  BE_PRSNL_GROUP_R_ID     NUMBER                DEFAULT 0                     NOT NULL,
  PFT_PRSNL_GROUP_ID      NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_SECURITY_RELTN
(
  BE_SECURITY_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE)     DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BE_SUPPRESS_RELTN
(
  BE_SUPPRESS_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE),
  PARENT_ENTITY_VALUE     NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILLING_ENTITY
(
  BILLING_ENTITY_ID         NUMBER              DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID           NUMBER              DEFAULT 0                     NOT NULL,
  DEF_PAT_TEMPL_ID          NUMBER              DEFAULT 0                     NOT NULL,
  PARENT_BE_ID              NUMBER              DEFAULT 0                     NOT NULL,
  DEF_POST_METHOD_CD        NUMBER              DEFAULT 0                     NOT NULL,
  CURRENCY_TYPE_CD          NUMBER              DEFAULT 0                     NOT NULL,
  BE_NAME                   VARCHAR2(50 BYTE),
  BE_DESC                   VARCHAR2(250 BYTE),
  COST_CENTER_CD            NUMBER              DEFAULT 0                     NOT NULL,
  BILLING_START_CD          NUMBER              DEFAULT 0                     NOT NULL,
  PRODUCE_BILL_CD           NUMBER              DEFAULT 0                     NOT NULL,
  FREQ_DUR_ID               NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE,
  END_EFFECTIVE_DT_TM       DATE,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  BE_NAME_KEY               VARCHAR2(250 BYTE),
  STD_DELAY                 NUMBER,
  PLACE_OF_SERVICE          VARCHAR2(2 BYTE),
  RECUR_BILL_OPT_FLAG       NUMBER,
  RECUR_BILL_WHAT_DAY       NUMBER,
  RECUR_WAIT_CODE_FLAG      NUMBER,
  RECUR_GEN_DELAY_IND       NUMBER,
  RECUR_GEN_DELAY           NUMBER,
  RUG_CD_ORDER_FLAG         NUMBER,
  POST_CD                   NUMBER              DEFAULT 0                     NOT NULL,
  AR_ACCT_ID                NUMBER              DEFAULT 0                     NOT NULL,
  DEFAULT_SELFPAY_HP_ID     NUMBER              DEFAULT 0                     NOT NULL,
  QCF_ROUNDING_FLAG         NUMBER              DEFAULT 0                     NOT NULL,
  HCFA_1500_DX_FLAG         NUMBER,
  PROC_CODE_IND             NUMBER,
  RECLASS_RECEIVE_IND       NUMBER              DEFAULT 0                     NOT NULL,
  DAYS_TO_EVAL              NUMBER              DEFAULT 0                     NOT NULL,
  PROGRAM_CD                NUMBER              DEFAULT 0                     NOT NULL,
  SEQ_START_NBR             FLOAT(126)          DEFAULT 0                     NOT NULL,
  CURRENT_SEQ_NBR           FLOAT(126)          DEFAULT 0                     NOT NULL,
  ZERO_BALANCE_WAIT         NUMBER              DEFAULT 0                     NOT NULL,
  BAD_DEBT_CHECK_IND        NUMBER              DEFAULT 0                     NOT NULL,
  ENCNTR_LIFE_IND           NUMBER              DEFAULT 0                     NOT NULL,
  CALCULATED_BALANCE_IND    NUMBER              DEFAULT 0                     NOT NULL,
  SUPPRESS_OFFSET_DRCR_IND  NUMBER              DEFAULT 0                     NOT NULL,
  FEE_SCHED_FLAG            NUMBER,
  FISCAL_REPORTING_FLAG     NUMBER              DEFAULT 0                     NOT NULL,
  BE_NAME_KEY_NLS           VARCHAR2(502 BYTE),
  BE_NAME_KEY_A_NLS         VARCHAR2(1000 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_ITEM
(
  BILL_ITEM_ID                NUMBER            DEFAULT 0                     NOT NULL,
  EXT_PARENT_REFERENCE_ID     NUMBER            DEFAULT 0                     NOT NULL,
  EXT_PARENT_CONTRIBUTOR_CD   NUMBER            DEFAULT 0                     NOT NULL,
  EXT_CHILD_REFERENCE_ID      NUMBER            DEFAULT 0                     NOT NULL,
  EXT_CHILD_CONTRIBUTOR_CD    NUMBER            DEFAULT 0                     NOT NULL,
  EXT_DESCRIPTION             VARCHAR2(200 BYTE),
  EXT_OWNER_CD                NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_QUAL_CD              NUMBER            DEFAULT 0                     NOT NULL,
  CHARGE_POINT_CD             NUMBER            DEFAULT 0                     NOT NULL,
  PHYSICIAN_QUAL_CD           NUMBER            DEFAULT 0                     NOT NULL,
  CALC_TYPE_CD                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_IND                  NUMBER            DEFAULT 0,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM         DATE              DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM         DATE              DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  EXT_SHORT_DESC              VARCHAR2(50 BYTE),
  EXT_PARENT_ENTITY_NAME      VARCHAR2(32 BYTE),
  EXT_CHILD_ENTITY_NAME       VARCHAR2(32 BYTE),
  CARESET_IND                 NUMBER            DEFAULT 0,
  WORKLOAD_ONLY_IND           NUMBER            DEFAULT 0,
  CHILD_SEQ                   NUMBER            DEFAULT 0,
  MISC_IND                    NUMBER            DEFAULT 0,
  PARENT_QUAL_IND             NUMBER            DEFAULT 0,
  STATS_ONLY_IND              NUMBER            DEFAULT 0,
  NUM_HITS                    FLOAT(126)        DEFAULT 0,
  LATE_CHRG_EXCL_IND          NUMBER            DEFAULT 0,
  COST_BASIS_AMT              FLOAT(126)        DEFAULT 0                     NOT NULL,
  TAX_IND                     NUMBER            DEFAULT 0,
  LOGICAL_DOMAIN_ID           NUMBER            DEFAULT 0,
  LOGICAL_DOMAIN_ENABLED_IND  NUMBER            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_ITEM_GROUP_RELTN
(
  BILL_ITEM_GROUP_RELTN_ID  NUMBER              DEFAULT 0                     NOT NULL,
  BILL_ITEM_GROUP_ID        NUMBER              DEFAULT 0                     NOT NULL,
  BILL_ITEM_ID              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER              DEFAULT 0,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_ITEM_MODIFIER
(
  BILL_ITEM_MOD_ID        NUMBER                DEFAULT 0                     NOT NULL,
  BILL_ITEM_ID            NUMBER                DEFAULT 0                     NOT NULL,
  BILL_ITEM_TYPE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  KEY1                    VARCHAR2(200 BYTE),
  KEY2                    VARCHAR2(200 BYTE),
  KEY3                    VARCHAR2(200 BYTE),
  KEY4                    VARCHAR2(200 BYTE),
  KEY5                    VARCHAR2(200 BYTE),
  KEY6                    VARCHAR2(200 BYTE),
  KEY7                    VARCHAR2(200 BYTE),
  KEY8                    VARCHAR2(200 BYTE),
  KEY9                    VARCHAR2(200 BYTE),
  KEY10                   VARCHAR2(200 BYTE),
  KEY11                   VARCHAR2(200 BYTE),
  KEY12                   VARCHAR2(200 BYTE),
  KEY13                   VARCHAR2(200 BYTE),
  KEY14                   VARCHAR2(200 BYTE),
  KEY15                   VARCHAR2(200 BYTE),
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  KEY2_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  KEY3_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  KEY4_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  KEY5_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  KEY1_ENTITY_NAME        VARCHAR2(32 BYTE),
  KEY2_ENTITY_NAME        VARCHAR2(32 BYTE),
  KEY3_ENTITY_NAME        VARCHAR2(32 BYTE),
  KEY4_ENTITY_NAME        VARCHAR2(32 BYTE),
  KEY5_ENTITY_NAME        VARCHAR2(32 BYTE),
  KEY1_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  KEY11_ID                NUMBER                DEFAULT 0                     NOT NULL,
  KEY12_ID                NUMBER                DEFAULT 0                     NOT NULL,
  KEY13_ID                NUMBER                DEFAULT 0                     NOT NULL,
  KEY14_ID                NUMBER                DEFAULT 0                     NOT NULL,
  KEY15_ID                NUMBER                DEFAULT 0                     NOT NULL,
  BIM1_IND                NUMBER                DEFAULT 0,
  BIM1_INT                FLOAT(126)            DEFAULT 0,
  BIM1_NBR                FLOAT(126)            DEFAULT 0,
  BIM2_INT                FLOAT(126)            DEFAULT 0,
  BIM_IND                 NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_ONLY_SUBSECT_RELTN
(
  SERVICE_RESOURCE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  ENTITY_NAME          VARCHAR2(40 BYTE)        DEFAULT ' '                   NOT NULL,
  ENTITY_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  STANDARD_QTY         NUMBER                   DEFAULT 0,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_REC
(
  CORSP_ACTIVITY_ID           NUMBER            DEFAULT 0                     NOT NULL,
  BILL_VRSN_NBR               NUMBER            DEFAULT 0                     NOT NULL,
  BILL_TEMPL_ID               NUMBER            DEFAULT 0                     NOT NULL,
  BILL_SUBMIT_SCHED_ID        NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_BILL_REC_ID          NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_BILL_VRSN_NBR        NUMBER,
  BILL_NBR_DISP               VARCHAR2(40 BYTE),
  BILL_STATUS_CD              NUMBER            DEFAULT 0                     NOT NULL,
  BILL_STATUS_REASON_CD       NUMBER            DEFAULT 0                     NOT NULL,
  MEDIA_TYPE_CD               NUMBER            DEFAULT 0                     NOT NULL,
  MEDIA_SUB_TYPE_CD           NUMBER            DEFAULT 0                     NOT NULL,
  GEN_REASON_CD               NUMBER            DEFAULT 0                     NOT NULL,
  MAN_REVIEW_IND              NUMBER,
  AUTO_SUBMIT_IND             NUMBER,
  AUTO_SUBMIT_CD              NUMBER            DEFAULT 0                     NOT NULL,
  AUTO_SUBMIT_VALUE           NUMBER,
  ACTIVE_IND                  NUMBER,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM         DATE,
  END_EFFECTIVE_DT_TM         DATE,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  BILL_NBR_DISP_KEY           VARCHAR2(250 BYTE),
  BALANCE                     FLOAT(126),
  BILLING_ENTITY_ID           NUMBER            DEFAULT 0                     NOT NULL,
  BILL_CLASS_CD               NUMBER            DEFAULT 0                     NOT NULL,
  BT_COND_RESULT_ID           NUMBER            DEFAULT 0                     NOT NULL,
  GEN_DT_TM                   DATE,
  PAYOR_CTRL_NBR_TXT          VARCHAR2(40 BYTE),
  PAGE_CNT                    NUMBER,
  SORT_FIELD_1                VARCHAR2(250 BYTE),
  SORT_FIELD_1_CD             NUMBER            DEFAULT 0                     NOT NULL,
  SORT_FIELD_2                VARCHAR2(250 BYTE),
  SORT_FIELD_2_CD             NUMBER            DEFAULT 0                     NOT NULL,
  SORT_FIELD_3                VARCHAR2(250 BYTE),
  SORT_FIELD_3_CD             NUMBER            DEFAULT 0                     NOT NULL,
  ZIP_CODE_KEY                VARCHAR2(40 BYTE),
  DUNNING_LEVEL_CD            NUMBER            DEFAULT 0                     NOT NULL,
  BILL_TYPE_CD                NUMBER            DEFAULT 0                     NOT NULL,
  RA_CLAIM_STATUS_CD          NUMBER            DEFAULT 0                     NOT NULL,
  RA_CLAIM_FIELD_CD           NUMBER            DEFAULT 0                     NOT NULL,
  BALANCE_DR_CR_FLAG          NUMBER            DEFAULT 0                     NOT NULL,
  BALANCE_FWD                 FLOAT(126)        DEFAULT 0.0                   NOT NULL,
  BALANCE_FWD_DR_CR_FLAG      NUMBER            DEFAULT 0                     NOT NULL,
  BALANCE_DUE                 FLOAT(126)        DEFAULT 0.0                   NOT NULL,
  BALANCE_DUE_DR_CR_FLAG      NUMBER            DEFAULT 0                     NOT NULL,
  NEW_AMOUNT                  FLOAT(126)        DEFAULT 0.0                   NOT NULL,
  NEW_AMOUNT_DR_CR_FLAG       NUMBER            DEFAULT 0                     NOT NULL,
  INTERIM_BILL_FLAG           NUMBER            DEFAULT 0                     NOT NULL,
  DUNNING_LEVEL_CNT           NUMBER            DEFAULT 0                     NOT NULL,
  CLAIM_STATUS_CD             NUMBER            DEFAULT 0                     NOT NULL,
  CLAIM_FILE_CD               NUMBER            DEFAULT 0                     NOT NULL,
  CM_STATUS_CD                NUMBER            DEFAULT 0                     NOT NULL,
  PAY_ADJ_TO_CM_DT_TM         DATE,
  SUBMISSION_ROUTE_CD         NUMBER            DEFAULT 0                     NOT NULL,
  ROUTE_USER_NAME             VARCHAR2(40 BYTE),
  BATCH_EVENT_ID              NUMBER            DEFAULT 0                     NOT NULL,
  DEMAND_IND                  NUMBER            DEFAULT 0                     NOT NULL,
  E_SORT_FIELD_1              VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  E_SORT_FIELD_1_CD           NUMBER            DEFAULT 0                     NOT NULL,
  E_SORT_FIELD_2              VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  E_SORT_FIELD_2_CD           NUMBER            DEFAULT 0                     NOT NULL,
  E_SORT_FIELD_3              VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  E_SORT_FIELD_3_CD           NUMBER            DEFAULT 0                     NOT NULL,
  SUBMIT_DT_TM                DATE,
  LAST_PAYMENT_DT_TM          DATE,
  LAST_ADJUSTMENT_DT_TM       DATE,
  CLAIM_SERIAL_NBR            FLOAT(126)        DEFAULT 0                     NOT NULL,
  TRANSMISSION_DT_TM          DATE,
  IMAGE_FLAG                  NUMBER            DEFAULT 0                     NOT NULL,
  FROM_SERVICE_DT_TM          DATE,
  TO_SERVICE_DT_TM            DATE,
  CLAIM_STATUS_CONTROL_DT_TM  DATE,
  RESPONSIBILITY_CD           NUMBER            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_RELTN
(
  BILL_RELTN_ID           NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      CHAR(32 BYTE)         DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_ACTIVITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BILL_VRSN_NBR           NUMBER                DEFAULT 0                     NOT NULL,
  RELTN_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BILL_STRUCT
(
  BILL_STRUCT_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_ACTIVITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BILL_VRSN_NBR           NUMBER                DEFAULT 0                     NOT NULL,
  BR_SEQ                  NUMBER,
  BR_STRING               LONG RAW,
  BR_SIZE                 NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  ORIG_SIZE               NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOB_REFERENCE
(
  BLOB_REF_ID            NUMBER                 DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM      DATE                   DEFAULT SYSDATE               NOT NULL,
  VALID_FROM_DT_TM       DATE                   DEFAULT SYSDATE               NOT NULL,
  PARENT_ENTITY_NAME     VARCHAR2(32 BYTE),
  PARENT_ENTITY_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR           NUMBER                 DEFAULT 0                     NOT NULL,
  OWNER_CD               NUMBER                 DEFAULT 0                     NOT NULL,
  STORAGE_CD             NUMBER                 DEFAULT 0                     NOT NULL,
  FORMAT_CD              NUMBER                 DEFAULT 0                     NOT NULL,
  BLOB_HANDLE            VARCHAR2(255 BYTE),
  BLOB_TITLE             VARCHAR2(60 BYTE),
  CREATE_PRSNL_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  SOURCE_DEVICE_CD       NUMBER                 DEFAULT 0                     NOT NULL,
  CHARTABLE_NOTE_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  NON_CHARTABLE_NOTE_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  PUBLISH_FLAG           NUMBER                 DEFAULT 0                     NOT NULL,
  BLOB_TYPE_CD           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  BLOB_DT_TM             DATE,
  DOCUMENT_ID            NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOOD_BANK_COMMENT
(
  BB_COMMENT_ID           NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOOD_PRODUCT
(
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_CD              NUMBER                DEFAULT 0                     NOT NULL,
  SUPPLIER_PREFIX         CHAR(5 BYTE),
  CUR_VOLUME              NUMBER,
  ORIG_LABEL_ABO_CD       NUMBER                DEFAULT 0                     NOT NULL,
  ORIG_LABEL_RH_CD        NUMBER                DEFAULT 0                     NOT NULL,
  CUR_ABO_CD              NUMBER                DEFAULT 0                     NOT NULL,
  CUR_RH_CD               NUMBER                DEFAULT 0                     NOT NULL,
  SEGMENT_NBR             VARCHAR2(25 BYTE),
  ORIG_EXPIRE_DT_TM       DATE,
  ORIG_VOLUME             NUMBER,
  LOT_NBR                 VARCHAR2(25 BYTE),
  AUTOLOGOUS_IND          NUMBER,
  DIRECTED_IND            NUMBER,
  DRAWN_DT_TM             DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  DONOR_PERSON_ID         NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOT_ALLELE_PATTERN_MATCH
(
  ORDER_ID       NUMBER                         DEFAULT 0                     NOT NULL,
  BLOT_BATCH_ID  NUMBER                         DEFAULT 0                     NOT NULL,
  X_POS          NUMBER                         DEFAULT 0                     NOT NULL,
  Y_POS          NUMBER                         DEFAULT 0                     NOT NULL,
  ALLELE_CD      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOT_BATCH_RESULT
(
  ORDER_ID           NUMBER                     DEFAULT 0                     NOT NULL,
  BLOT_BATCH_ID      NUMBER                     DEFAULT 0                     NOT NULL,
  X_POS              NUMBER                     DEFAULT 0                     NOT NULL,
  Y_POS              NUMBER                     DEFAULT 0                     NOT NULL,
  AMPLIFICATION_GEL  VARCHAR2(20 BYTE),
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOT_POSITIVE_PROBE
(
  ORDER_ID       NUMBER                         DEFAULT 0                     NOT NULL,
  BLOT_BATCH_ID  NUMBER                         DEFAULT 0                     NOT NULL,
  X_POS          NUMBER                         DEFAULT 0                     NOT NULL,
  Y_POS          NUMBER                         DEFAULT 0                     NOT NULL,
  PROBE_NUMBER   NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM     DATE                           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID        NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_TASK      NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_CNT       NUMBER                         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX   NUMBER                         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BLOT_SPEC_PATTERN_MATCH
(
  ORDER_ID        NUMBER                        DEFAULT 0                     NOT NULL,
  BLOT_BATCH_ID   NUMBER                        DEFAULT 0                     NOT NULL,
  X_POS           NUMBER                        DEFAULT 0                     NOT NULL,
  Y_POS           NUMBER                        DEFAULT 0                     NOT NULL,
  SPECIFICITY_CD  NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM      DATE                          DEFAULT SYSDATE               NOT NULL,
  UPDT_ID         NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_TASK       NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_CNT        NUMBER                        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX    NUMBER                        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_ACQUIRED_DATA_TRACK
(
  ASSOCIATION_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  DEVICE_CD              NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  LOCATION_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  ACTIVE_IND             NUMBER                 DEFAULT 0                     NOT NULL,
  ASSOCIATION_DT_TM      DATE                   DEFAULT SYSDATE               NOT NULL,
  DIS_ASSOCIATION_DT_TM  DATE,
  PARENT_ENTITY_NAME     VARCHAR2(32 BYTE)      DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  ASSOC_PRSNL_ID         NUMBER                 DEFAULT 0,
  HINT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  RESOURCE_LOC_CD        NUMBER                 DEFAULT 0                     NOT NULL,
  UPD_STATUS_CD          NUMBER                 DEFAULT 0,
  DISSOC_PRSNL_ID        NUMBER                 DEFAULT 0,
  MONITORED_DEVICE_ID    NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_ACQUIRED_RESULTS
(
  RESULT_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  DEVICE_PARAMETER_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PERSON_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  DEVICE_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  RESULT_VAL           VARCHAR2(50 BYTE),
  ACQUIRED_DT_TM       DATE                     DEFAULT SYSDATE               NOT NULL,
  NOMENCLATURE_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  VERIFIED_DT_TM       DATE,
  VERIFIED_IND         NUMBER                   DEFAULT 0                     NOT NULL,
  CLINICAL_DT_TM       DATE                     DEFAULT SYSDATE               NOT NULL,
  LAB_TYPE_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  RESULT_FORMAT_CD     NUMBER                   DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME   VARCHAR2(32 BYTE)        DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  MONITORED_DEVICE_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  EVENT_ID             NUMBER                   DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_ADT_PERSON_R
(
  BMDI_ADT_PERSON_R_ID      NUMBER              DEFAULT 0                     NOT NULL,
  ASSOCIATION_ID            NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_ALIAS_TYPE_CD      NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_ALIAS              VARCHAR2(200 BYTE),
  PERSON_NAME               VARCHAR2(100 BYTE)  DEFAULT ' '                   NOT NULL,
  ENCNTR_ALIAS_TYPE_CD      NUMBER              DEFAULT 0                     NOT NULL,
  ENCNTR_ALIAS              VARCHAR2(200 BYTE),
  ENCNTR_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_WEIGHT             VARCHAR2(255 BYTE),
  WEIGHT_UNITS_CD           NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_HEIGHT             VARCHAR2(255 BYTE),
  HEIGHT_UNITS_CD           NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_GENDER_CD          NUMBER              DEFAULT 0                     NOT NULL,
  STATUS_FLAG               NUMBER              DEFAULT 0                     NOT NULL,
  STATUS_MESSAGE            VARCHAR2(255 BYTE),
  ASSOCIATION_PRSNL_ID      NUMBER              DEFAULT 0                     NOT NULL,
  DIS_ASSOCIATION_PRSNL_ID  NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_BIRTH_DT_TM        DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_ASSOCIATION_HINTS
(
  HINT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  LOCATION_CD         NUMBER                    DEFAULT 0                     NOT NULL,
  PERSON_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  HINT_PROCESSING_CD  NUMBER                    DEFAULT 0                     NOT NULL,
  HINT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  HINT_TYPE_CD        NUMBER                    DEFAULT 0                     NOT NULL,
  UPD_PRSNL_ID        NUMBER                    DEFAULT 0                     NOT NULL,
  ACTIVE_IND          NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_DEVICE_NOMENCLATURE
(
  DEVICE_NOMENCLATURE_ID  NUMBER                DEFAULT 0                     NOT NULL,
  DEVICE_CD               NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  DEVICE_PARAMETER_ID     NUMBER                DEFAULT 0                     NOT NULL,
  DEVICE_VALUE            VARCHAR2(50 BYTE)     DEFAULT ' '                   NOT NULL,
  ALPHA_TRANSLATION       VARCHAR2(50 BYTE)     DEFAULT ' '                   NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_DEVICE_PARAMETER
(
  DEVICE_PARAMETER_ID      NUMBER               DEFAULT 0                     NOT NULL,
  DEVICE_CD                NUMBER               DEFAULT 0                     NOT NULL,
  STRT_MODEL_PARAMETER_ID  NUMBER               DEFAULT 0                     NOT NULL,
  RESULT_TYPE_CD           NUMBER               DEFAULT 0                     NOT NULL,
  PARAMETER_ALIAS          VARCHAR2(50 BYTE)    DEFAULT ' '                   NOT NULL,
  UNITS_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD            NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 0                     NOT NULL,
  DECIMAL_PRECISION        NUMBER,
  ALARM_HIGH               VARCHAR2(20 BYTE),
  ALARM_LOW                VARCHAR2(20 BYTE),
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR             NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BMDI_MONITORED_DEVICE
(
  MONITORED_DEVICE_ID    NUMBER                 DEFAULT 0                     NOT NULL,
  DEVICE_CD              NUMBER                 DEFAULT 0                     NOT NULL,
  STRT_MODEL_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  DEVICE_ALIAS           VARCHAR2(40 BYTE)      DEFAULT ' '                   NOT NULL,
  MOBILE_IND             NUMBER                 DEFAULT 0                     NOT NULL,
  LOCATION_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  DEVICE_IND             NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  STRT_MODEL_CHILD_ID    NUMBER                 DEFAULT 0                     NOT NULL,
  ASSOCIATION_LIMIT_CNT  NUMBER                 DEFAULT 1                     NOT NULL,
  ALTERNATE_DEVICE_CD    NUMBER                 DEFAULT 0                     NOT NULL,
  RESOURCE_LOC_CD        NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BO_HISTORY
(
  BO_HISTORY_ID           NUMBER                DEFAULT 0                     NOT NULL,
  BENEFIT_ORDER_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_PLAN_RELTN_ID    NUMBER                DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  EPR_UPT_CNT             NUMBER,
  PRIORITY_SEQ            NUMBER,
  FIN_CLASS_CD            NUMBER                DEFAULT 0                     NOT NULL,
  PRI_CONCURRENT_IND      NUMBER,
  SEC_CONCURRENT_IND      NUMBER,
  PAT_BILL_PREF_FLAG      NUMBER,
  CROSS_OVER_IND          NUMBER,
  DISP_NONCOVD_IND        NUMBER,
  MAN_EDIT_IND            NUMBER,
  BO_STATUS_CD            NUMBER                DEFAULT 0                     NOT NULL,
  BO_STATUS_REASON_CD     NUMBER                DEFAULT 0                     NOT NULL,
  SUBSCRIBER_ID           NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CONS_BO_SCHED_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ORIG_BILL_DT_TM         DATE,
  ORIG_DUE_DT_TM          DATE,
  PARENT_BO_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PAT_CONCURRENT_IND      NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BO_HP_RELTN
(
  BO_HP_RELTN_ID            NUMBER              DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID            NUMBER              DEFAULT 0                     NOT NULL,
  BENEFIT_ORDER_ID          NUMBER              DEFAULT 0                     NOT NULL,
  PRIORITY_SEQ              NUMBER              DEFAULT 0                     NOT NULL,
  TOTAL_BILLED_AMOUNT       FLOAT(126)          DEFAULT 0                     NOT NULL,
  TOTAL_BILLED_DR_CR_FLAG   NUMBER              DEFAULT 0                     NOT NULL,
  TOTAL_PAID_AMOUNT         FLOAT(126)          DEFAULT 0                     NOT NULL,
  TOTAL_PAID_DR_CR_FLAG     NUMBER              DEFAULT 0                     NOT NULL,
  ROLL_DT_TM                DATE,
  BO_HP_STATUS_CD           NUMBER              DEFAULT 0                     NOT NULL,
  ROLL_USER_ID              NUMBER              DEFAULT 0                     NOT NULL,
  ROLL_TASK_ID              NUMBER              DEFAULT 0                     NOT NULL,
  LAST_BILLED_DT_TM         DATE,
  TOTAL_ADJ_AMOUNT          FLOAT(126)          DEFAULT 0                     NOT NULL,
  TOTAL_ADJ_DR_CR_FLAG      NUMBER              DEFAULT 0                     NOT NULL,
  ROLL_REASON_CD            NUMBER              DEFAULT 0                     NOT NULL,
  RESUBMISSION_CNT          NUMBER              DEFAULT 0                     NOT NULL,
  STMT_STATUS_CD            NUMBER              DEFAULT 0                     NOT NULL,
  LAST_PAYMENT_DT_TM        DATE,
  LAST_ADJUST_DT_TM         DATE,
  FIN_CLASS_CD              NUMBER              DEFAULT 0                     NOT NULL,
  PAYOR_ORG_ID              NUMBER              DEFAULT 0                     NOT NULL,
  BILL_TEMPL_ID             NUMBER              DEFAULT 0                     NOT NULL,
  ENCNTR_PLAN_RELTN_ID      NUMBER              DEFAULT 0                     NOT NULL,
  ORIG_BILL_DT_TM           DATE,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM       DATE                DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  AMOUNT_OWED               FLOAT(126)          DEFAULT 0                     NOT NULL,
  AMOUNT_OWED_DR_CR_FLAG    NUMBER,
  ROLL_REVIEW_IND           NUMBER              DEFAULT 0                     NOT NULL,
  ORIG_BILL_SUBMIT_DT_TM    DATE,
  ORIG_BILL_TRANSMIT_DT_TM  DATE,
  RELTN_TYPE_CD             NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_ADO_DETAIL
(
  BR_ADO_DETAIL_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  FACILITY_CD         NUMBER                    DEFAULT 0                     NOT NULL,
  BR_ADO_CATEGORY_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  SCENARIO_MEAN       VARCHAR2(50 BYTE)         DEFAULT 0                     NOT NULL,
  SELECT_IND          NUMBER                    DEFAULT 0                     NOT NULL,
  NOTE_TXT            VARCHAR2(255 BYTE),
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_ADO_OPTION
(
  BR_ADO_OPTION_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  BR_ADO_DETAIL_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  OPTION_SEQ        NUMBER                      DEFAULT 0                     NOT NULL,
  PRESELECT_IND     NUMBER                      DEFAULT 0                     NOT NULL,
  NOTE_TXT          VARCHAR2(255 BYTE),
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_ADO_ORD_LIST
(
  BR_ADO_ORD_LIST_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  BR_ADO_OPTION_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  SYNONYM_ID          NUMBER                    DEFAULT 0                     NOT NULL,
  SENTENCE_ID         NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  BR_ADO_DETAIL_ID    NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_CAT_EVENT_NORMALCY
(
  BR_CAT_EVENT_NORMALCY_ID  NUMBER              DEFAULT 0                     NOT NULL,
  BR_MDRO_CAT_EVENT_ID      NUMBER              DEFAULT 0                     NOT NULL,
  NORMALCY_CD               NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_CCN
(
  BR_CCN_ID          NUMBER                     DEFAULT 0                     NOT NULL,
  CCN_NBR            FLOAT(126)                 DEFAULT 0                     NOT NULL,
  CCN_NAME           VARCHAR2(150 BYTE)         DEFAULT ' '                   NOT NULL,
  TAX_ID_NBR_TXT     VARCHAR2(50 BYTE)          DEFAULT ' '                   NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  CCN_NBR_TXT        VARCHAR2(150 BYTE)         DEFAULT ' '                   NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_CCN_LOC_PTSVC_RELTN
(
  BR_CCN_LOC_PTSVC_RELTN_ID  NUMBER             DEFAULT 0                     NOT NULL,
  BR_CCN_LOC_RELTN_ID        NUMBER             DEFAULT 0                     NOT NULL,
  PTSVC_CODE_NBR             NUMBER             DEFAULT 0                     NOT NULL,
  ENCNTR_TYPE_CD             NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_CCN_LOC_RELTN
(
  BR_CCN_LOC_RELTN_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  BR_CCN_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  LOCATION_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_DRUG_GROUP_ORGANISM
(
  BR_DRUG_GROUP_ORGANISM_ID  NUMBER             DEFAULT 0                     NOT NULL,
  BR_DRUG_GROUP_ID           NUMBER             DEFAULT 0                     NOT NULL,
  DRUG_RESISTANT_CNT         NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  BR_MDRO_CAT_ORGANISM_ID    NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_ELIGIBLE_PROVIDER
(
  BR_ELIGIBLE_PROVIDER_ID    NUMBER             DEFAULT 0                     NOT NULL,
  PROVIDER_ID                NUMBER             DEFAULT 0                     NOT NULL,
  NATIONAL_PROVIDER_NBR_TXT  VARCHAR2(200 BYTE) DEFAULT ' ' NOT NULL,
  TAX_ID_NBR_TXT             VARCHAR2(50 BYTE)  DEFAULT ' '                   NOT NULL,
  HEALTH_PLAN_TXT            VARCHAR2(20 BYTE)  DEFAULT ' '                   NOT NULL,
  HEALTH_PLAN_TXT_DT_TM      DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  SPECIALTY_ID               NUMBER             DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID          NUMBER             DEFAULT 0                     NOT NULL,
  ERX_SUBMISSION_IND         NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_ELIG_PROV_MEAS_RELTN
(
  BR_ELIG_PROV_MEAS_RELTN_ID  NUMBER            DEFAULT 0                     NOT NULL,
  BR_ELIGIBLE_PROVIDER_ID     NUMBER            DEFAULT 0                     NOT NULL,
  PCA_QUALITY_MEASURE_ID      NUMBER            DEFAULT 0                     NOT NULL,
  MEASURE_SEQ                 NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_FIELD_ERRORS
(
  BR_FIELD_ERRORS_ID      NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_ACTIVITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BILL_VRSN_NBR           NUMBER                DEFAULT 0                     NOT NULL,
  FIELD_CATALOG_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ELEMENT_NAME            VARCHAR2(40 BYTE),
  LIST_NAME               VARCHAR2(40 BYTE),
  LIST_INDEX              NUMBER                DEFAULT 0                     NOT NULL,
  ERROR_CD                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_GEN_EVENT_LOG
(
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  BENEFIT_ORDER_ID        NUMBER                DEFAULT 0                     NOT NULL,
  BILL_REC_ID             NUMBER                DEFAULT 0                     NOT NULL,
  BR_GEN_EVENT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  LOG_LEVEL_CD            NUMBER                DEFAULT 0                     NOT NULL,
  LOG_MESSAGE             VARCHAR2(250 BYTE),
  PFT_EVENT_OCCUR_LOG_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_HCO_LOC_RELTN
(
  BR_HCO_LOC_RELTN_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  BR_HCO_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  LOCATION_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_LONG_BLOB_RELTN
(
  BR_LONG_BLOB_RELTN_ID   NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_ACTIVITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  BILL_VRSN_NBR           NUMBER,
  LONG_BLOB_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE                NUMBER,
  BILL_SIZE               NUMBER,
  ORIG_SIZE               NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  DATA_TYPE_FLAG          NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_MDRO_CAT_EVENT
(
  BR_MDRO_CAT_EVENT_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  BR_MDRO_CAT_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  EVENT_CD              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  LOCATION_CD           NUMBER                  DEFAULT 0,
  BR_MDRO_ID            NUMBER                  DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_MDRO_CAT_ORGANISM
(
  BR_MDRO_CAT_ORGANISM_ID  NUMBER               DEFAULT 0                     NOT NULL,
  BR_MDRO_CAT_ID           NUMBER               DEFAULT 0                     NOT NULL,
  ORGANISM_CD              NUMBER               DEFAULT 0                     NOT NULL,
  GROUP_RESISTANT_CNT      NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  LOCATION_CD              NUMBER               DEFAULT 0,
  BR_MDRO_ID               NUMBER               DEFAULT 0,
  ANTIBIOTICS_TXT          VARCHAR2(500 BYTE)   DEFAULT ' '
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_MDRO_OUTBREAK
(
  BR_MDRO_OUTBREAK_ID         NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME          VARCHAR2(32 BYTE) DEFAULT ' ' NOT NULL,
  PARENT_ENTITY_ID            NUMBER            DEFAULT 0                     NOT NULL,
  FACILITY_OCCURRENCE_CNT     NUMBER            DEFAULT 0                     NOT NULL,
  FACILITY_TIME_SPAN_NBR      NUMBER            DEFAULT 0                     NOT NULL,
  FACILITY_TIME_SPAN_UNIT_CD  NUMBER            DEFAULT 0                     NOT NULL,
  UNIT_OCCURRENCE_CNT         NUMBER            DEFAULT 0                     NOT NULL,
  UNIT_TIME_SPAN_NBR          NUMBER            DEFAULT 0                     NOT NULL,
  UNIT_TIME_SPAN_UNIT_CD      NUMBER            DEFAULT 0                     NOT NULL,
  LOCATION_CD                 NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_ORGANISM_DRUG_RESULT
(
  BR_ORGANISM_DRUG_RESULT_ID   NUMBER           DEFAULT 0                     NOT NULL,
  BR_DRUG_GROUP_ORGANISM_ID    NUMBER           DEFAULT 0                     NOT NULL,
  BR_DRUG_GROUP_ANTIBIOTIC_ID  NUMBER           DEFAULT 0                     NOT NULL,
  RESULT_CD                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_PQRS_MEAS_PROVIDER_RELTN
(
  BR_PQRS_MEAS_PROVIDER_RELTN_ID  NUMBER        DEFAULT 0                     NOT NULL,
  BR_ELIGIBLE_PROVIDER_ID         NUMBER        DEFAULT 0                     NOT NULL,
  BR_PQRS_MEAS_ID                 NUMBER        DEFAULT 0                     NOT NULL,
  PILOT_ELIGIBLE_IND              NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                    NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_CNT                        NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                      DATE          DEFAULT sysdate               NOT NULL,
  UPDT_ID                         NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_TASK                       NUMBER        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_SCH_TEMP_SLOT_RELEASE_R
(
  BR_SCH_TEMP_SLOT_RELEASE_R_ID  NUMBER         DEFAULT 0                     NOT NULL,
  BR_SCH_TEMP_SLOT_R_ID          NUMBER         DEFAULT 0                     NOT NULL,
  RELEASE_TYPE_ID                NUMBER         DEFAULT 0                     NOT NULL,
  RELEASE_NAME                   VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL,
  RELEASE_START_TIME_STR         VARCHAR2(40 BYTE) DEFAULT ' ' NOT NULL,
  RELEASE_END_TIME_STR           VARCHAR2(40 BYTE) DEFAULT ' ' NOT NULL,
  RELEASE_UNIT                   VARCHAR2(10 BYTE) DEFAULT ' ' NOT NULL,
  RELEASE_UNIT_VALUE_STR         VARCHAR2(10 BYTE) DEFAULT ' ' NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BR_WIZARD_HIST
(
  BR_WIZARD_HIST_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  SOLUTION_MEAN      VARCHAR2(100 BYTE),
  WIZARD_MEAN        VARCHAR2(100 BYTE),
  PRSNL_ID           NUMBER                     DEFAULT 0                     NOT NULL,
  LOG_DT_TM          DATE,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BT_HP_RELTN
(
  BT_HP_RELTN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  BILL_TEMPL_ID           NUMBER                DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  MAN_REVIEW_IND          NUMBER                DEFAULT 0                     NOT NULL,
  BILL_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BT_PRSNL_GRP_RELTN
(
  BT_PRSNL_GRP_RELTN_ID   NUMBER                DEFAULT 0                     NOT NULL,
  BT_COND_CRIT_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  CODE_VALUE              NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE BUSINESS_SERVICE
(
  BUSINESS_SERVICE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  SERVICE_IDENT           VARCHAR2(250 BYTE)    DEFAULT ' ',
  SERVICE_NAME            VARCHAR2(250 BYTE)    DEFAULT ' '                   NOT NULL,
  PARTY_IDENT             VARCHAR2(250 BYTE)    DEFAULT ' '                   NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CALENDAR_EXCEPTION
(
  SERVICE_RESOURCE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  EXCEPTION_SEQ        NUMBER                   DEFAULT 0                     NOT NULL,
  EXC_DATE             DATE                     DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  OPEN_TIME            NUMBER,
  CLOSE_TIME           NUMBER,
  AVAIL_IND            NUMBER,
  TEXT_DESCRIPTION     VARCHAR2(200 BYTE),
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_ATTENDANCE
(
  CASE_ATTENDANCE_ID       NUMBER               DEFAULT 0                     NOT NULL,
  CASE_ATTEND_STATIC_ID    NUMBER               DEFAULT 0                     NOT NULL,
  SEGMENT_HEADER_ID        NUMBER               DEFAULT 0                     NOT NULL,
  SURG_AREA_CD             NUMBER               DEFAULT 0                     NOT NULL,
  CASE_ATTENDEE_ID         NUMBER               DEFAULT 0                     NOT NULL,
  ATTENDEE_FREE_TEXT_NAME  VARCHAR2(100 BYTE),
  ROLE_PERF_CD             NUMBER               DEFAULT 0                     NOT NULL,
  RESULT_STATUS_FLAG       NUMBER,
  DISPLAY_SEQ              NUMBER,
  SIGNING_ATTENDEE_IND     NUMBER,
  REASON_FOR_RELIEF_CD     NUMBER               DEFAULT 0                     NOT NULL,
  PROC_SPECIFIED_IND       NUMBER,
  SURG_START_DT_TM         DATE,
  DEF_IND                  NUMBER,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM      DATE,
  END_EFFECTIVE_DT_TM      DATE,
  CREATE_DT_TM             DATE,
  CREATE_PRSNL_ID          NUMBER               DEFAULT 0                     NOT NULL,
  CREATE_TASK              NUMBER,
  CREATE_APPLCTX           NUMBER,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  IN_DT_TM                 DATE,
  OUT_DT_TM                DATE,
  SURG_CASE_ID             NUMBER               DEFAULT 0                     NOT NULL,
  IN_TZ                    NUMBER               DEFAULT 0,
  OUT_TZ                   NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_CART
(
  CASE_CART_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SURG_CASE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PREF_CARD_TYPE_FLAG     NUMBER,
  SURG_AREA_CD            NUMBER                DEFAULT 0                     NOT NULL,
  REQUISITION_ID          NUMBER                DEFAULT 0                     NOT NULL,
  FINALIZE_DT_TM          DATE,
  MODIFIED_IND            NUMBER,
  VERIFIED_DT_TM          DATE,
  VERIFIED_BY_ID          NUMBER                DEFAULT 0                     NOT NULL,
  PRINT_DT_TM             DATE,
  COMMENT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  CREATE_DT_TM            DATE,
  CREATE_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CREATE_TASK             NUMBER,
  CREATE_APPLCTX          NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  LOCKED_APPLCTX          NUMBER                DEFAULT 0,
  DOC_TYPE_CD             NUMBER                DEFAULT 0                     NOT NULL,
  TOT_SUPPLY_COST_AVG     FLOAT(126)            DEFAULT 0,
  TOT_SUPPLY_COST_LAST    FLOAT(126)            DEFAULT 0,
  TOT_EQUIP_COST_AVG      FLOAT(126)            DEFAULT 0,
  TOT_EQUIP_COST_LAST     FLOAT(126)            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_CART_PICK_LIST
(
  CASE_CART_PICK_LIST_ID  NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE),
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  SURG_PROC_GRP_ID        NUMBER                DEFAULT 0                     NOT NULL,
  SURG_PROC_GRP_DET_ID    NUMBER                DEFAULT 0                     NOT NULL,
  CASE_CART_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SURG_CASE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PREF_CARD_TYPE_FLAG     NUMBER,
  CURRENT_IND             NUMBER,
  DUP_IND                 NUMBER,
  MERGED_ITEM_FLAG        NUMBER,
  FILL_LOCN_CD            NUMBER                DEFAULT 0                     NOT NULL,
  FILL_QTY                FLOAT(126),
  REQUEST_QTY             FLOAT(126),
  HOLD_QTY                FLOAT(126),
  OPEN_QTY                FLOAT(126),
  RETURN_LOCN_CD          NUMBER                DEFAULT 0                     NOT NULL,
  RETURN_QTY              FLOAT(126),
  QTY_USED                FLOAT(126),
  WASTED_QTY              FLOAT(126),
  WASTED_REASON_CD        NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_UNITS            NUMBER,
  CHARGE_DUR              NUMBER,
  LINE_ITEM_ID            NUMBER                DEFAULT 0                     NOT NULL,
  STATUS_FLAG             NUMBER,
  CREATE_DT_TM            DATE,
  CREATE_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CREATE_TASK             NUMBER,
  CREATE_APPLCTX          NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  FREE_TEXT_ITEM_DESC     VARCHAR2(200 BYTE),
  OBJECT_TYPE_FLAG        NUMBER,
  PARENT_PACK_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_QTY              NUMBER                DEFAULT 0,
  COST                    NUMBER                DEFAULT 0,
  COST_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  ITEM_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  SURG_CASE_PROC_ID       NUMBER                DEFAULT 0                     NOT NULL,
  AVG_COST                FLOAT(126),
  LAST_COST               FLOAT(126)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_PROVIDER
(
  CASE_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  PHYSICIAN_ID  NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_REPORT
(
  REPORT_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  CASE_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  EVENT_ID              NUMBER                  DEFAULT 0                     NOT NULL,
  CATALOG_CD            NUMBER                  DEFAULT 0                     NOT NULL,
  REPORT_SEQUENCE       NUMBER                  DEFAULT 0                     NOT NULL,
  REQUEST_DT_TM         DATE,
  REQUEST_PRSNL_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_CD             NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_PRSNL_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_DT_TM          DATE,
  CANCEL_CD             NUMBER                  DEFAULT 0                     NOT NULL,
  CANCEL_PRSNL_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  CANCEL_DT_TM          DATE,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  BLOB_BITMAP           NUMBER                  DEFAULT 0,
  SYNOPTIC_STALE_DT_TM  DATE,
  SIGNING_LOCATION_CD   NUMBER                  DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_SPECIMEN
(
  CASE_SPECIMEN_ID            NUMBER            DEFAULT 0                     NOT NULL,
  CASE_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  SPECIMEN_TAG_ID             NUMBER            DEFAULT 0                     NOT NULL,
  FIXATIVE_ADDED_CD           NUMBER            DEFAULT 0                     NOT NULL,
  STORAGE_LOCN_CD             NUMBER            DEFAULT 0                     NOT NULL,
  ON_LOAN_LOCN_CD             NUMBER            DEFAULT 0                     NOT NULL,
  DISCARD_DT_TM               DATE,
  FROZEN_REPORT_ID            NUMBER            DEFAULT 0                     NOT NULL,
  COLLECT_DT_TM               DATE,
  CANCEL_CD                   NUMBER            DEFAULT 0                     NOT NULL,
  SPECIMEN_CD                 NUMBER            DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID             NUMBER            DEFAULT 0                     NOT NULL,
  SPECIMEN_DESCRIPTION        VARCHAR2(100 BYTE),
  SPECIAL_COMMENTS            VARCHAR2(200 BYTE),
  ADEQUACY_IND                NUMBER,
  INADEQUACY_REASON_CD        NUMBER            DEFAULT 0                     NOT NULL,
  RECEIVED_DT_TM              DATE,
  RECEIVED_ID                 NUMBER            DEFAULT 0                     NOT NULL,
  RECEIVED_FIXATIVE_CD        NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  SPEC_COMMENTS_LONG_TEXT_ID  NUMBER            DEFAULT 0                     NOT NULL,
  ORIGINAL_STORAGE_DT_TM      DATE              DEFAULT NULL,
  DISCARD_REASON_CD           NUMBER            DEFAULT 0,
  LABEL_CREATE_DT_TM          DATE,
  LABEL_CREATE_TYPE_FLAG      NUMBER            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASE_TIMES
(
  CASE_TIMES_ID           NUMBER                DEFAULT 0                     NOT NULL,
  CASE_TIMES_STATIC_ID    NUMBER                DEFAULT 0                     NOT NULL,
  SEGMENT_HEADER_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CASE_TIME_MEANING       CHAR(12 BYTE),
  CASE_TIME_DT_TM         DATE,
  RESULT_STATUS_FLAG      NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  CREATE_DT_TM            DATE,
  CREATE_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CREATE_TASK             NUMBER,
  CREATE_APPLCTX          NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  SURG_CASE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  STAGE_CD                NUMBER                DEFAULT 0                     NOT NULL,
  CASE_TIME_TZ            NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CASSETTE
(
  CASSETTE_ID             NUMBER                DEFAULT 0                     NOT NULL,
  CASE_SPECIMEN_ID        NUMBER                DEFAULT 0                     NOT NULL,
  OWNER_ID                NUMBER                DEFAULT 0                     NOT NULL,
  CASSETTE_TAG_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SUPPLEMENTAL_TAG        CHAR(2 BYTE),
  TASK_ASSAY_CD           NUMBER                DEFAULT 0                     NOT NULL,
  ON_LOAN_LOCN_CD         NUMBER                DEFAULT 0                     NOT NULL,
  FIXATIVE_CD             NUMBER                DEFAULT 0                     NOT NULL,
  ORIGIN_MODIFIER         CHAR(7 BYTE),
  PIECES                  CHAR(3 BYTE),
  SECTIONABLE_IND         NUMBER,
  DISCARD_DT_TM           DATE,
  STORAGE_LOCATION_CD     NUMBER                DEFAULT 0                     NOT NULL,
  FROZEN_IND              NUMBER,
  EMBEDDING_MEDIA_CD      NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ORIGINAL_STORAGE_DT_TM  DATE                  DEFAULT NULL,
  DISCARD_REASON_CD       NUMBER                DEFAULT 0,
  LABEL_CREATE_DT_TM      DATE,
  LABEL_CREATE_TYPE_FLAG  NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CCO_ENCOUNTER
(
  CCO_ENCOUNTER_ID              NUMBER          DEFAULT 0                     NOT NULL,
  ADM_DOC_ID                    NUMBER          DEFAULT 0                     NOT NULL,
  ADMIT_AGE                     NUMBER,
  ADMIT_DIAGNOSIS               NUMBER,
  ADMIT_ICU_CD                  NUMBER          DEFAULT 0                     NOT NULL,
  ADMIT_SOURCE                  NUMBER,
  ADMITSOURCE_FLAG              NUMBER,
  AIDS_IND                      NUMBER,
  AMI_LOCATION                  NUMBER,
  BED_COUNT                     NUMBER,
  BODY_SYSTEM                   NUMBER,
  CC_DURING_STAY_IND            NUMBER,
  CHRONIC_HEALTH_NONE_IND       NUMBER,
  CHRONIC_HEALTH_UNAVAIL_IND    NUMBER,
  CIRRHOSIS_IND                 NUMBER,
  COPD_FLAG                     NUMBER,
  COPD_IND                      NUMBER,
  DIABETES_IND                  NUMBER,
  DIALYSIS_IND                  NUMBER,
  DIEDINHOSPITAL_IND            NUMBER,
  DIEDINICU_IND                 NUMBER,
  DISEASE_CATEGORY_CD           NUMBER          DEFAULT 0                     NOT NULL,
  EJECTFX_FRACTION              NUMBER,
  ELECTIVESURGERY_IND           NUMBER,
  GENDER_FLAG                   NUMBER,
  HEPATICFAILURE_IND            NUMBER,
  HOSP_ADMIT_DT_TM              DATE,
  HRS_AT_SOURCE                 NUMBER,
  ICU_ADMIT_DT_TM               DATE,
  ICU_DISCH_DT_TM               DATE,
  IMA_IND                       NUMBER,
  IMMUNOSUPPRESSION_IND         NUMBER,
  LEUKEMIA_IND                  NUMBER,
  LYMPHOMA_IND                  NUMBER,
  MED_SERVICE_CD                NUMBER          DEFAULT 0                     NOT NULL,
  METASTATICCANCER_IND          NUMBER,
  MI_WITHIN_6MO_IND             NUMBER,
  MIDUR_IND                     NUMBER,
  NBR_GRAFTS_PERFORMED          NUMBER,
  PERSON_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  PTCA_DEVICE                   NUMBER,
  READMIT_IND                   NUMBER,
  READMIT_WITHIN_24HR_IND       NUMBER,
  REGION_FLAG                   NUMBER,
  SV_GRAFT_IND                  NUMBER,
  TEACH_TYPE_FLAG               NUMBER,
  THERAPY_LEVEL                 NUMBER,
  THROMBOLYTICS_IND             NUMBER,
  VALID_FROM_DT_TM              DATE,
  VALID_UNTIL_DT_TM             DATE,
  VAR03HSPXLOS_VALUE            NUMBER,
  XFER_WITHIN_48HR_IND          NUMBER,
  DIEDINDELROOM_IND             NUMBER,
  PATIENT_IDENTIFIER            FLOAT(126),
  MOTHERS_NAME                  VARCHAR2(50 BYTE),
  MOTHERS_ETHNICITY             NUMBER,
  MOTHERS_RACE                  NUMBER,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM           DATE            DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID        NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD              NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  RISK_ADJUSTMENT_IDENT         FLOAT(126)      DEFAULT 0                     NOT NULL,
  INITIAL_DISCH_DT_TM           DATE,
  FINAL_DISCH_DT_TM             DATE,
  CCO_SOURCE_APP_CD             NUMBER          DEFAULT 0                     NOT NULL,
  VON_TRANSFER_FLAG             NUMBER,
  READMISSION_DISPOSITION_FLAG  NUMBER,
  FINAL_DISPOSITION_FLAG        NUMBER,
  RECORD_STATUS_FLAG            NUMBER          DEFAULT 0                     NOT NULL,
  EXTRACT_FLAG                  NUMBER          DEFAULT 0                     NOT NULL,
  EXTRACT_DT_TM                 DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CCO_EVENT
(
  CCO_EVENT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CLINICAL_EVENT_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CLINICAL_SEQ            NUMBER,
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_END_DT_TM         DATE,
  EVENT_END_TZ            NUMBER,
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_START_DT_TM       DATE,
  EVENT_START_TZ          NUMBER,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PUBLISH_FLAG            NUMBER,
  RESULT_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM        DATE,
  VALID_UNTIL_DT_TM       DATE,
  VIEW_LEVEL              NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_TAG               VARCHAR2(255 BYTE)    DEFAULT ' '                   NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  CRITICAL_LOW            VARCHAR2(20 BYTE),
  CRITICAL_HIGH           VARCHAR2(20 BYTE),
  NORMAL_LOW              VARCHAR2(20 BYTE),
  NORMAL_HIGH             VARCHAR2(20 BYTE),
  EVENT_CLASS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  NORMALCY_CD             NUMBER                DEFAULT 0                     NOT NULL,
  PERFORMED_DT_TM         DATE,
  PERFORMED_TZ            NUMBER                DEFAULT 0,
  REFERENCE_NBR           VARCHAR2(100 BYTE)    DEFAULT ' '                   NOT NULL,
  RESULT_UNITS_CD         NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_TIME_UNITS_CD    NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_VAL              VARCHAR2(255 BYTE),
  SOURCE_CD               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CCR_USER_FILTER
(
  CONTENT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  CONTENT_VIEW_FILTER_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_AC_BATCHCLASS
(
  CDI_AC_BATCHCLASS_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  BATCHCLASS_NAME       VARCHAR2(32 BYTE)       DEFAULT ' '                   NOT NULL,
  SINGLE_ENCNTR         NUMBER                  DEFAULT 0                     NOT NULL,
  AUTO_COMP_NOTIFY      NUMBER                  DEFAULT 0                     NOT NULL,
  AUTO_CLOSE            NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  AUDITING_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  ALIAS_CONTRIB_SRC_CD  NUMBER                  DEFAULT 0,
  CPDI_BATCH_CLASS_IND  NUMBER                  DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_AC_USER
(
  CDI_AC_USER_ID   NUMBER                       DEFAULT 0                     NOT NULL,
  AC_USERNAME      VARCHAR2(32 BYTE)            DEFAULT ' '                   NOT NULL,
  AUDITING_IND     NUMBER                       DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_CLIPBOARD
(
  CDI_CLIPBOARD_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  OBJECT_FILE       VARCHAR2(255 BYTE)          DEFAULT ' '                   NOT NULL,
  ANNO_FILE         VARCHAR2(255 BYTE)          DEFAULT ' '                   NOT NULL,
  COPY_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  COPY_USER_ID      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_CM_LOGIN
(
  CDI_CM_LOGIN_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  CM_USERNAME      VARCHAR2(64 BYTE)            DEFAULT ' '                   NOT NULL,
  CM_PASSWORD      VARCHAR2(64 BYTE)            DEFAULT ' '                   NOT NULL,
  ORGANIZATION_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  ORG_DEFAULT_IND  NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_CM_LOGIN_POSITION
(
  CDI_CM_LOGIN_POSITION_ID  NUMBER              DEFAULT 0                     NOT NULL,
  CDI_CM_LOGIN_ID           NUMBER              DEFAULT 0                     NOT NULL,
  POSITION_CD               NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_DOCUMENT_SUBTYPE
(
  CDI_DOCUMENT_SUBTYPE_ID       NUMBER          DEFAULT 0                     NOT NULL,
  CDI_DOCUMENT_TYPE_ID          NUMBER          DEFAULT 0                     NOT NULL,
  DOCUMENT_TYPE_ALIAS           VARCHAR2(255 BYTE),
  SUBJECT                       VARCHAR2(255 BYTE),
  COMBINE_IND                   NUMBER          DEFAULT 0                     NOT NULL,
  COMBINE_ALL_IND               NUMBER          DEFAULT 0                     NOT NULL,
  MAX_PAGE_CNT                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  DEFAULT_DATE_OF_SERVICE_FLAG  NUMBER          DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SOURCE_CD         NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_DOCUMENT_TYPE
(
  CDI_DOCUMENT_TYPE_ID          NUMBER          DEFAULT 0                     NOT NULL,
  EVENT_CD                      NUMBER          DEFAULT 0                     NOT NULL,
  CDI_AC_BATCHCLASS_ID          NUMBER          DEFAULT 0                     NOT NULL,
  COMBINE_IND                   NUMBER          DEFAULT 0                     NOT NULL,
  MAX_PAGE_CNT                  NUMBER          DEFAULT 0                     NOT NULL,
  DELETE_FIRST_IND              NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  COMBINE_ALL_IND               NUMBER          DEFAULT 0,
  DEFAULT_DATE_OF_SERVICE_FLAG  NUMBER          DEFAULT 0,
  CODE_SET                      NUMBER          DEFAULT 0,
  CATEGORY_CD                   NUMBER          DEFAULT 0,
  SEND_TO_MANUAL_IND            NUMBER          DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_DOC_DYN_METADATA
(
  CDI_DOC_DYN_METADATA_ID  NUMBER               DEFAULT 0                     NOT NULL,
  CDI_PENDING_DOCUMENT_ID  NUMBER               DEFAULT 0                     NOT NULL,
  ALIAS_TYPE_CD            NUMBER               DEFAULT 0                     NOT NULL,
  ALIAS_TYPE_CODESET       NUMBER               DEFAULT 0                     NOT NULL,
  FIELD_VALUE              VARCHAR2(200 BYTE),
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_FORM
(
  CDI_FORM_ID              NUMBER               DEFAULT 0                     NOT NULL,
  FORM_NAME                VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  SOURCE_FORM_IDENT        VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  EVENT_CODE_SET           NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  CDI_DOCUMENT_SUBTYPE_ID  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  LOGICAL_DOMAIN_ID        NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_FORM_CRITERIA
(
  CDI_FORM_CRITERIA_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  CDI_FORM_RULE_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  VARIABLE_CD           NUMBER                  DEFAULT 0                     NOT NULL,
  COMPARISON_FLAG       NUMBER                  DEFAULT 0                     NOT NULL,
  VALUE_CD              NUMBER,
  VALUE_NBR             NUMBER,
  VALUE_DT_TM           DATE,
  VALUE_TEXT            VARCHAR2(30 BYTE),
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_FORM_FIELD
(
  CDI_FORM_FIELD_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  CDI_FORM_ID           NUMBER                  DEFAULT 0                     NOT NULL,
  PAGE_NBR              NUMBER                  DEFAULT 0                     NOT NULL,
  X_COORD               NUMBER                  DEFAULT 0                     NOT NULL,
  Y_COORD               NUMBER                  DEFAULT 0                     NOT NULL,
  FIELD_WIDTH           NUMBER                  DEFAULT 0                     NOT NULL,
  FIELD_HEIGHT          NUMBER                  DEFAULT 0                     NOT NULL,
  FIELD_TYPE_FLAG       NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  FIELD_NAME            VARCHAR2(40 BYTE)       DEFAULT ' '                   NOT NULL,
  VALUE_FORMAT_TEXT     VARCHAR2(150 BYTE),
  PARENT_FORM_FIELD_ID  NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_FORM_RULE
(
  CDI_FORM_RULE_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  CDI_FORM_ID       NUMBER                      DEFAULT 0                     NOT NULL,
  REQUIRED_IND      NUMBER                      DEFAULT 0                     NOT NULL,
  CRITERIA_CNT      NUMBER                      DEFAULT 0                     NOT NULL,
  RULE_NAME         VARCHAR2(40 BYTE)           DEFAULT ' '                   NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_PENDING_BATCH
(
  CDI_PENDING_BATCH_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  BATCH_NAME            VARCHAR2(255 BYTE)      DEFAULT ' '                   NOT NULL,
  BATCH_CREATE_DT_TM    DATE                    DEFAULT SYSDATE               NOT NULL,
  CDI_AC_BATCHCLASS_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  EXTERNAL_BATCH_IDENT  NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_PENDING_DOCUMENT
(
  CDI_PENDING_DOCUMENT_ID    NUMBER             DEFAULT 0                     NOT NULL,
  BLOB_HANDLE                VARCHAR2(128 BYTE) DEFAULT ' ' NOT NULL,
  AX_APP_IDENT               FLOAT(126)         DEFAULT 0                     NOT NULL,
  AX_DOC_IDENT               FLOAT(126)         DEFAULT 0                     NOT NULL,
  ENCNTR_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  PERSON_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  EVENT_CD                   NUMBER             DEFAULT 0                     NOT NULL,
  EVENT_CODESET              NUMBER             DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID           NUMBER             DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME         VARCHAR2(30 BYTE)  DEFAULT ' '                   NOT NULL,
  PATIENT_NAME               VARCHAR2(100 BYTE),
  DOC_TYPE_NAME              VARCHAR2(50 BYTE),
  SUBJECT_TEXT               VARCHAR2(255 BYTE),
  DOC_TYPE_ALIAS             VARCHAR2(255 BYTE),
  SERVICE_DT_TM              DATE,
  SCAN_DT_TM                 DATE,
  BIRTH_DT_TM                DATE,
  TRACKING_NBR_TEXT          VARCHAR2(50 BYTE),
  PERFORMING_PROVIDER_ALIAS  VARCHAR2(200 BYTE),
  RX_PRIORITY_TEXT           VARCHAR2(40 BYTE),
  CAPTURE_LOC_NAME           VARCHAR2(50 BYTE),
  REFERENCE_NBR_TEXT         VARCHAR2(100 BYTE),
  CONTRIBUTOR_SYSTEM_ALIAS   VARCHAR2(50 BYTE),
  RESULT_STATUS_ALIAS        VARCHAR2(50 BYTE),
  DOC_UPDT_DT_TM             DATE,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  CDI_PENDING_BATCH_ID       NUMBER             DEFAULT 0                     NOT NULL,
  PROCESS_LOCATION_FLAG      NUMBER             DEFAULT 0                     NOT NULL,
  SUBMIT_DT_TM               DATE               DEFAULT SYSDATE,
  PAGE_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  STATUS_FLAG                NUMBER             DEFAULT 0                     NOT NULL,
  RESULT_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  PERFORMING_PROVIDER_ID     NUMBER             DEFAULT 0                     NOT NULL,
  PARENT_LEVEL_FLAG          NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_REJECT_LOG
(
  CDI_REJECT_LOG_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  REFERENCE_NBR          VARCHAR2(100 BYTE),
  REJECT_USER_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  REJECT_DT_TM           DATE,
  MATCH_EVENT_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  MATCH_UPDT_DT_TM       DATE,
  MATCH_STATUS_CD        NUMBER                 DEFAULT 0                     NOT NULL,
  REJECT_FIN             VARCHAR2(200 BYTE),
  REJECT_PATIENT_NAME    VARCHAR2(100 BYTE),
  REJECT_BIRTH_DT_TM     DATE,
  REJECT_MRN             VARCHAR2(200 BYTE),
  REJECT_DOC_TYPE        VARCHAR2(50 BYTE),
  REJECT_SUBJECT         VARCHAR2(255 BYTE),
  REJECT_UPDT_DT_TM      DATE,
  REJECT_STATUS          VARCHAR2(255 BYTE),
  REJECT_SERVICE_DT_TM   DATE,
  REJECT_PROVIDER        VARCHAR2(200 BYTE),
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_TRANS_LOG
(
  CDI_TRANS_LOG_ID         NUMBER               DEFAULT 0                     NOT NULL,
  PATIENT_NAME             VARCHAR2(255 BYTE),
  MRN                      VARCHAR2(200 BYTE),
  FINANCIAL_NBR            VARCHAR2(200 BYTE),
  BLOB_HANDLE              VARCHAR2(255 BYTE),
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  BATCH_NAME               VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  ACTION_TYPE_FLAG         NUMBER               DEFAULT 0                     NOT NULL,
  ACTION_DT_TM             DATE                 DEFAULT SYSDATE               NOT NULL,
  PAGE_DELETED_CNT         NUMBER               DEFAULT 0                     NOT NULL,
  PAGE_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  PERF_PRSNL_ID            NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  BLOB_REF_ID              NUMBER               DEFAULT 0                     NOT NULL,
  BLOB_TYPE_FLAG           NUMBER               DEFAULT 0                     NOT NULL,
  AX_DOCID                 NUMBER               DEFAULT 0                     NOT NULL,
  AX_APPID                 NUMBER               DEFAULT 0                     NOT NULL,
  CREATE_DT_TM             DATE                 DEFAULT SYSDATE               NOT NULL,
  EXTERNAL_BATCH_IDENT     NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 0                     NOT NULL,
  SUBJECT                  VARCHAR2(255 BYTE),
  DOC_TYPE                 VARCHAR2(40 BYTE),
  REASON_CD                NUMBER               DEFAULT 0,
  CDI_QUEUE_CD             NUMBER               DEFAULT 0,
  PARENT_ENTITY_ID         NUMBER               DEFAULT 0,
  PARENT_ENTITY_NAME       VARCHAR2(32 BYTE)    DEFAULT ' ',
  PARENT_ENTITY_ALIAS      VARCHAR2(200 BYTE)   DEFAULT ' ',
  DOCUMENT_TYPE_ALIAS      VARCHAR2(255 BYTE),
  CDI_PENDING_DOCUMENT_ID  NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_TRANS_MOD_DETAIL
(
  CDI_TRANS_MOD_DETAIL_ID  NUMBER               DEFAULT 0                     NOT NULL,
  CDI_TRANS_LOG_ID         NUMBER               DEFAULT 0                     NOT NULL,
  ACTION_TYPE_FLAG         NUMBER               DEFAULT 0                     NOT NULL,
  ACTION_SEQUENCE          NUMBER               DEFAULT 0                     NOT NULL,
  START_PAGE               NUMBER               DEFAULT 0                     NOT NULL,
  END_PAGE                 NUMBER               DEFAULT 0                     NOT NULL,
  POSITION                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_USER_FILTER
(
  CDI_USER_FILTER_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  FILTER_NAME         VARCHAR2(100 BYTE)        DEFAULT ' '                   NOT NULL,
  PERSON_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  BEGIN_DT_TM         DATE                      DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  END_DT_TM           DATE                      DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  DOCUMENT_COUNT      NUMBER                    DEFAULT 0                     NOT NULL,
  DATE_RANGE_MONTHS   NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_WORK_ITEM
(
  CDI_WORK_ITEM_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  CLARIFY_REASON_CD      NUMBER                 DEFAULT 0                     NOT NULL,
  COMMENT_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  CREATE_DT_TM           DATE                   DEFAULT SYSDATE               NOT NULL,
  OWNER_PRSNL_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  PRIORITY_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  STATUS_CD              NUMBER                 DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME     VARCHAR2(30 BYTE)      DEFAULT ' '                   NOT NULL,
  PARENT_ENTITY_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  PREV_CDI_WORK_ITEM_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM    DATE,
  END_EFFECTIVE_DT_TM    DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_WORK_QUEUE_ITEM_RELTN
(
  CDI_WORK_QUEUE_ITEM_RELTN_ID  NUMBER          DEFAULT 0                     NOT NULL,
  CDI_WORK_ITEM_ID              NUMBER          DEFAULT 0                     NOT NULL,
  CDI_WORK_QUEUE_ID             NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CDI_WORK_QUEUE_PRSNL_RELTN
(
  CDI_WORK_QUEUE_PRSNL_RELTN_ID  NUMBER         DEFAULT 0                     NOT NULL,
  CDI_WORK_QUEUE_ID              NUMBER         DEFAULT 0                     NOT NULL,
  PERSON_ID                      NUMBER         DEFAULT 0                     NOT NULL,
  EXCEPTION_IND                  NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_AUDIT_LOG
(
  CE_AUDIT_LOG_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  EVENT_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  PERSON_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  OPERATION_TYPE_CD    NUMBER                   DEFAULT 0                     NOT NULL,
  OPERATION_DT_TM      DATE                     DEFAULT SYSDATE               NOT NULL,
  OPERATION_PRSNL_ID   NUMBER                   DEFAULT 0                     NOT NULL,
  ERROR_MSG_TXT        VARCHAR2(255 BYTE),
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  OPERATION_STATUS_CD  NUMBER                   DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_DYNAMIC_LABEL
(
  CE_DYNAMIC_LABEL_ID    NUMBER                 DEFAULT 0                     NOT NULL,
  PREV_DYNAMIC_LABEL_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  LABEL_TEMPLATE_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  LABEL_NAME             VARCHAR2(100 BYTE),
  LABEL_PRSNL_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  LABEL_STATUS_CD        NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  RESULT_SET_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM       DATE,
  VALID_UNTIL_DT_TM      DATE,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  LABEL_SEQ_NBR          NUMBER                 DEFAULT 0                     NOT NULL,
  CREATE_DT_TM           DATE                   DEFAULT SYSDATE               NOT NULL,
  LONG_TEXT_ID           NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_EVENT_ACTION
(
  CE_EVENT_ACTION_ID          NUMBER            DEFAULT 0                     NOT NULL,
  EVENT_ID                    NUMBER            DEFAULT 0                     NOT NULL,
  ACTION_TYPE_CD              NUMBER            DEFAULT 0                     NOT NULL,
  ACTION_PRSNL_ID             NUMBER            DEFAULT 0                     NOT NULL,
  ACTION_DT_TM                DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  ASSIGN_PRSNL_ID             NUMBER            DEFAULT 0                     NOT NULL,
  ACTION_PRSNL_GROUP_ID       NUMBER            DEFAULT 0                     NOT NULL,
  ENCNTR_ID                   NUMBER            DEFAULT 0                     NOT NULL,
  PARENT_EVENT_CLASS_CD       NUMBER            DEFAULT 0,
  EVENT_TAG                   VARCHAR2(255 BYTE) DEFAULT ' ',
  PERSON_ID                   NUMBER            DEFAULT 0                     NOT NULL,
  EVENT_CLASS_CD              NUMBER            DEFAULT 0,
  RESULT_STATUS_CD            NUMBER            DEFAULT 0,
  PARENT_EVENT_ID             NUMBER            DEFAULT 0                     NOT NULL,
  EVENT_TITLE_TEXT            VARCHAR2(255 BYTE),
  NORMALCY_CD                 NUMBER            DEFAULT 0,
  EVENT_CD                    NUMBER            DEFAULT 0,
  CLINSIG_UPDT_DT_TM          DATE,
  ENDORSE_STATUS_CD           NUMBER            DEFAULT 0,
  LAST_COMMENT_TXT            VARCHAR2(255 BYTE),
  MULTIPLE_COMMENT_IND        NUMBER            DEFAULT 0,
  MULTIPLE_COMMENT_PRSNL_IND  NUMBER            DEFAULT 0,
  LAST_SAVED_PRSNL_ID         NUMBER            DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_EVENT_MODIFIER
(
  EVENT_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  MODIFIER_CD               NUMBER              DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM          DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  VALID_UNTIL_DT_TM         DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  MODIFIER_VALUE_CD         NUMBER              DEFAULT 0                     NOT NULL,
  MODIFIER_VALUE_FT         NUMBER,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  MODIFIER_VAL_FT           VARCHAR2(100 BYTE),
  MODIFIER_VALUE_PERSON_ID  NUMBER              DEFAULT 0                     NOT NULL,
  GROUP_SEQUENCE            NUMBER,
  ITEM_SEQUENCE             NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_EVENT_NOTE
(
  CE_EVENT_NOTE_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM   DATE                      DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  EVENT_NOTE_ID       NUMBER                    DEFAULT 0                     NOT NULL,
  EVENT_ID            NUMBER                    DEFAULT 0                     NOT NULL,
  NOTE_TYPE_CD        NUMBER                    DEFAULT 0                     NOT NULL,
  NOTE_FORMAT_CD      NUMBER                    DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM    DATE                      DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ENTRY_METHOD_CD     NUMBER                    DEFAULT 0                     NOT NULL,
  NOTE_PRSNL_ID       NUMBER                    DEFAULT 0                     NOT NULL,
  NOTE_DT_TM          DATE                      DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  RECORD_STATUS_CD    NUMBER                    DEFAULT 0                     NOT NULL,
  COMPRESSION_CD      NUMBER                    DEFAULT 0                     NOT NULL,
  CHECKSUM            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID        NUMBER                    DEFAULT 0,
  NON_CHARTABLE_FLAG  NUMBER                    DEFAULT 0,
  IMPORTANCE_FLAG     NUMBER                    DEFAULT 0,
  NOTE_TZ             NUMBER                    DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_EVENT_ORDER_LINK
(
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_ACTION_SEQUENCE   NUMBER,
  VALID_UNTIL_DT_TM       DATE                  DEFAULT SYSDATE               NOT NULL,
  VALID_FROM_DT_TM        DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_END_DT_TM         DATE                  DEFAULT SYSDATE               NOT NULL,
  PARENT_ORDER_IDENT      FLOAT(126)            DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CATALOG_TYPE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  CE_EVENT_ORDER_LINK_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_EVENT_PRSNL
(
  CE_EVENT_PRSNL_ID         NUMBER              DEFAULT 0                     NOT NULL,
  EVENT_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM         DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  EVENT_PRSNL_ID            NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM          DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ACTION_TYPE_CD            NUMBER              DEFAULT 0                     NOT NULL,
  REQUEST_DT_TM             DATE,
  REQUEST_PRSNL_ID          NUMBER              DEFAULT 0                     NOT NULL,
  REQUEST_PRSNL_FT          VARCHAR2(100 BYTE),
  REQUEST_COMMENT           VARCHAR2(255 BYTE),
  ACTION_DT_TM              DATE,
  ACTION_PRSNL_ID           NUMBER              DEFAULT 0                     NOT NULL,
  ACTION_PRSNL_FT           VARCHAR2(100 BYTE),
  PROXY_PRSNL_ID            NUMBER              DEFAULT 0                     NOT NULL,
  PROXY_PRSNL_FT            VARCHAR2(100 BYTE),
  ACTION_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTION_COMMENT            VARCHAR2(255 BYTE),
  CHANGE_SINCE_ACTION_FLAG  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID              NUMBER              DEFAULT 0                     NOT NULL,
  ACTION_TZ                 NUMBER              DEFAULT 0,
  REQUEST_TZ                NUMBER              DEFAULT 0,
  LINKED_EVENT_ID           NUMBER              DEFAULT 0,
  SYSTEM_COMMENT            VARCHAR2(255 BYTE),
  DIGITAL_SIGNATURE_IDENT   VARCHAR2(60 BYTE),
  ACTION_PRSNL_GROUP_ID     NUMBER              DEFAULT 0,
  REQUEST_PRSNL_GROUP_ID    NUMBER              DEFAULT 0,
  RECEIVING_PERSON_FT       VARCHAR2(100 BYTE),
  RECEIVING_PERSON_ID       NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_FLAGGED_RESULT
(
  CE_FLAGGED_RESULT_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  EVENT_ID              NUMBER                  DEFAULT 0                     NOT NULL,
  ENCNTR_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  PERSON_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  EVENT_CD              NUMBER                  DEFAULT 0                     NOT NULL,
  EVENT_END_DT_TM       DATE,
  FLAGGED_DT_TM         DATE,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_FLAGGED_RESULT_ROLE
(
  CE_FLAGGED_RESULT_ROLE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  EVENT_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  CE_FLAGGED_RESULT_ID       NUMBER             DEFAULT 0                     NOT NULL,
  ROLE_TYPE_CD               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_INTAKE_OUTPUT_RESULT
(
  CE_IO_RESULT_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  EVENT_ID            NUMBER                    DEFAULT 0                     NOT NULL,
  PERSON_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  IO_TYPE_FLAG        NUMBER                    DEFAULT 0                     NOT NULL,
  IO_VOLUME           FLOAT(126),
  IO_STATUS_CD        NUMBER                    DEFAULT 0                     NOT NULL,
  IO_RESULT_ID        NUMBER                    DEFAULT 0                     NOT NULL,
  REFERENCE_EVENT_CD  NUMBER                    DEFAULT 0                     NOT NULL,
  REFERENCE_EVENT_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  ENCNTR_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  IO_END_DT_TM        DATE,
  IO_START_DT_TM      DATE                      DEFAULT SYSDATE               NOT NULL,
  VALID_FROM_DT_TM    DATE                      DEFAULT SYSDATE               NOT NULL,
  VALID_UNTIL_DT_TM   DATE                      DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_INVENTORY_RESULT
(
  EVENT_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  ITEM_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  SERIAL_NBR             VARCHAR2(30 BYTE),
  SERIAL_MNEMONIC        VARCHAR2(30 BYTE),
  DESCRIPTION            VARCHAR2(255 BYTE),
  ITEM_NBR               VARCHAR2(30 BYTE),
  QUANTITY               FLOAT(126),
  BODY_SITE              VARCHAR2(50 BYTE),
  REFERENCE_ENTITY_ID    NUMBER                 DEFAULT 0                     NOT NULL,
  REFERENCE_ENTITY_NAME  VARCHAR2(32 BYTE),
  VALID_FROM_DT_TM       DATE                   DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  VALID_UNTIL_DT_TM      DATE                   DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_IO_TOTAL_RESULT
(
  CE_IO_TOTAL_RESULT_ID         NUMBER          DEFAULT 0                     NOT NULL,
  IO_TOTAL_DEFINITION_ID        NUMBER          DEFAULT 0                     NOT NULL,
  EVENT_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_FOCUSED_IND            NUMBER          DEFAULT 0                     NOT NULL,
  PERSON_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  IO_TOTAL_START_DT_TM          DATE,
  IO_TOTAL_END_DT_TM            DATE,
  IO_TOTAL_VALUE                FLOAT(126)      DEFAULT 0                     NOT NULL,
  IO_TOTAL_UNIT_CD              NUMBER          DEFAULT 0                     NOT NULL,
  SUSPECT_FLAG                  NUMBER          DEFAULT 0                     NOT NULL,
  LAST_IO_RESULT_CLINSIG_DT_TM  DATE,
  VALID_FROM_DT_TM              DATE,
  VALID_UNTIL_DT_TM             DATE,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  IO_TOTAL_RESULT_VAL           VARCHAR2(255 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_LINKED_RESULT
(
  EVENT_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  LINKED_EVENT_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM      DATE                   DEFAULT SYSDATE               NOT NULL,
  VALID_FROM_DT_TM       DATE                   DEFAULT SYSDATE               NOT NULL,
  ORDER_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  ENCNTR_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  ACCESSION_NBR          VARCHAR2(20 BYTE),
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  REFERENCE_NBR          VARCHAR2(100 BYTE)     DEFAULT ' '                   NOT NULL,
  EVENT_CLASS_CD         NUMBER                 DEFAULT 0                     NOT NULL,
  SERIES_REF_NBR         VARCHAR2(100 BYTE),
  SUB_SERIES_REF_NBR     VARCHAR2(60 BYTE),
  SUCCESSION_TYPE_CD     NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_MED_ADMIN_IDENT
(
  CE_MED_ADMIN_IDENT_ID       NUMBER            DEFAULT 0                     NOT NULL,
  PREV_CE_MED_ADMIN_IDENT_ID  NUMBER            DEFAULT 0                     NOT NULL,
  DISPENSE_HX_ID              NUMBER            DEFAULT 0                     NOT NULL,
  MED_ADMIN_BARCODE           VARCHAR2(200 BYTE) DEFAULT ' ' NOT NULL,
  BARCODE_SOURCE_CD           NUMBER            DEFAULT 0                     NOT NULL,
  ITEM_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  MED_PRODUCT_ID              NUMBER            DEFAULT 0                     NOT NULL,
  SCAN_QTY                    FLOAT(126)        DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM            DATE              DEFAULT SYSDATE               NOT NULL,
  VALID_UNTIL_DT_TM           DATE              DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_MED_ADMIN_IDENT_RELTN
(
  CE_MED_IDENT_RELTN_ID       NUMBER            DEFAULT 0                     NOT NULL,
  PREV_CE_MED_IDENT_RELTN_ID  NUMBER            DEFAULT 0                     NOT NULL,
  EVENT_ID                    NUMBER            DEFAULT 0                     NOT NULL,
  CE_MED_ADMIN_IDENT_ID       NUMBER            DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM            DATE              DEFAULT SYSDATE               NOT NULL,
  VALID_UNTIL_DT_TM           DATE              DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_MED_RESULT
(
  EVENT_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM          DATE               DEFAULT SYSDATE               NOT NULL,
  ADMIN_START_DT_TM          DATE               DEFAULT SYSDATE               NOT NULL,
  VALID_FROM_DT_TM           DATE               DEFAULT SYSDATE               NOT NULL,
  ADMIN_NOTE                 VARCHAR2(120 BYTE),
  ADMIN_PROV_ID              NUMBER             DEFAULT 0                     NOT NULL,
  ADMIN_END_DT_TM            DATE,
  ADMIN_ROUTE_CD             NUMBER             DEFAULT 0                     NOT NULL,
  ADMIN_SITE_CD              NUMBER             DEFAULT 0                     NOT NULL,
  ADMIN_METHOD_CD            NUMBER             DEFAULT 0                     NOT NULL,
  ADMIN_PT_LOC_CD            NUMBER             DEFAULT 0                     NOT NULL,
  INITIAL_DOSAGE             FLOAT(126)         DEFAULT 0                     NOT NULL,
  ADMIN_DOSAGE               FLOAT(126)         DEFAULT 0                     NOT NULL,
  DOSAGE_UNIT_CD             NUMBER             DEFAULT 0                     NOT NULL,
  INITIAL_VOLUME             FLOAT(126),
  TOTAL_INTAKE_VOLUME        FLOAT(126),
  DILUENT_TYPE_CD            NUMBER             DEFAULT 0                     NOT NULL,
  PH_DISPENSE_ID             NUMBER             DEFAULT 0                     NOT NULL,
  INFUSION_RATE              FLOAT(126),
  INFUSION_UNIT_CD           NUMBER             DEFAULT 0                     NOT NULL,
  INFUSION_TIME_CD           NUMBER             DEFAULT 0                     NOT NULL,
  MEDICATION_FORM_CD         NUMBER             DEFAULT 0                     NOT NULL,
  REASON_REQUIRED_FLAG       NUMBER,
  RESPONSE_REQUIRED_FLAG     NUMBER,
  ADMIN_STRENGTH             NUMBER,
  ADMIN_STRENGTH_UNIT_CD     NUMBER             DEFAULT 0                     NOT NULL,
  SUBSTANCE_LOT_NUMBER       VARCHAR2(20 BYTE),
  SUBSTANCE_EXP_DT_TM        DATE,
  SUBSTANCE_MANUFACTURER_CD  NUMBER             DEFAULT 0                     NOT NULL,
  REFUSAL_CD                 NUMBER             DEFAULT 0                     NOT NULL,
  SYSTEM_ENTRY_DT_TM         DATE,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  IV_EVENT_CD                NUMBER             DEFAULT 0                     NOT NULL,
  INFUSED_VOLUME             FLOAT(126),
  INFUSED_VOLUME_UNIT_CD     NUMBER             DEFAULT 0                     NOT NULL,
  REMAINING_VOLUME           FLOAT(126),
  REMAINING_VOLUME_UNIT_CD   NUMBER             DEFAULT 0                     NOT NULL,
  SYNONYM_ID                 NUMBER             DEFAULT 0                     NOT NULL,
  IMMUNIZATION_TYPE_CD       NUMBER             DEFAULT 0                     NOT NULL,
  ADMIN_END_TZ               NUMBER             DEFAULT 0,
  ADMIN_START_TZ             NUMBER             DEFAULT 0,
  WEIGHT_UNIT_CD             NUMBER             DEFAULT 0,
  WEIGHT_VALUE               FLOAT(126)         DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_PRCS_QUEUE
(
  CE_PRCS_QUEUE_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  CE_EVENT_ACTION_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  EVENT_ID            NUMBER                    DEFAULT 0                     NOT NULL,
  QUEUE_TYPE_CD       NUMBER                    DEFAULT 0                     NOT NULL,
  CREATE_DT_TM        DATE,
  PRCS_DT_TM          DATE,
  QUEUE_STATUS_CD     NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_PRODUCT
(
  EVENT_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM         DATE                DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  VALID_FROM_DT_TM          DATE                DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  PRODUCT_ID                NUMBER              DEFAULT 0                     NOT NULL,
  PRODUCT_NBR               VARCHAR2(40 BYTE)   DEFAULT ' '                   NOT NULL,
  PRODUCT_CD                NUMBER              DEFAULT 0                     NOT NULL,
  PRODUCT_STATUS_CD         NUMBER              DEFAULT 0                     NOT NULL,
  ABO_CD                    NUMBER              DEFAULT 0                     NOT NULL,
  RH_CD                     NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  PRODUCT_VOLUME            FLOAT(126),
  PRODUCT_VOLUME_UNIT_CD    NUMBER              DEFAULT 0,
  PRODUCT_QUANTITY          FLOAT(126),
  PRODUCT_QUANTITY_UNIT_CD  NUMBER              DEFAULT 0,
  PRODUCT_STRENGTH_UNIT_CD  NUMBER              DEFAULT 0,
  PRODUCT_STRENGTH          FLOAT(126)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_SPECIMEN_COLL
(
  EVENT_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM    DATE                     DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  VALID_FROM_DT_TM     DATE                     DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  SPECIMEN_ID          NUMBER                   DEFAULT 0                     NOT NULL,
  CONTAINER_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  CONTAINER_TYPE_CD    NUMBER                   DEFAULT 0                     NOT NULL,
  SPECIMEN_STATUS_CD   NUMBER                   DEFAULT 0                     NOT NULL,
  COLLECT_DT_TM        DATE                     DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  COLLECT_METHOD_CD    NUMBER                   DEFAULT 0                     NOT NULL,
  COLLECT_LOC_CD       NUMBER                   DEFAULT 0                     NOT NULL,
  COLLECT_PRSNL_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  COLLECT_VOLUME       FLOAT(126)               DEFAULT 0                     NOT NULL,
  COLLECT_UNIT_CD      NUMBER                   DEFAULT 0                     NOT NULL,
  COLLECT_PRIORITY_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  SOURCE_TYPE_CD       NUMBER                   DEFAULT 0                     NOT NULL,
  SOURCE_TEXT          VARCHAR2(255 BYTE),
  BODY_SITE_CD         NUMBER                   DEFAULT 0                     NOT NULL,
  DANGER_CD            NUMBER                   DEFAULT 0                     NOT NULL,
  POSITIVE_IND         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  COLLECT_TZ           NUMBER                   DEFAULT 0,
  RECVD_DT_TM          DATE,
  RECVD_TZ             NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CE_SUSCEPTIBILITY
(
  EVENT_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM         DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  MICRO_SEQ_NBR             NUMBER              DEFAULT 0                     NOT NULL,
  SUSCEP_SEQ_NBR            NUMBER              DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM          DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  SUSCEPTIBILITY_TEST_CD    NUMBER              DEFAULT 0                     NOT NULL,
  DETAIL_SUSCEPTIBILITY_CD  NUMBER              DEFAULT 0                     NOT NULL,
  PANEL_ANTIBIOTIC_CD       NUMBER              DEFAULT 0                     NOT NULL,
  ANTIBIOTIC_CD             NUMBER              DEFAULT 0                     NOT NULL,
  DILUENT_VOLUME            FLOAT(126)          DEFAULT 0                     NOT NULL,
  RESULT_CD                 NUMBER              DEFAULT 0                     NOT NULL,
  RESULT_TEXT_VALUE         VARCHAR2(100 BYTE),
  RESULT_NUMERIC_VALUE      FLOAT(126),
  RESULT_UNIT_CD            NUMBER              DEFAULT 0                     NOT NULL,
  RESULT_DT_TM              DATE                DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  RESULT_PRSNL_ID           NUMBER              DEFAULT 0                     NOT NULL,
  SUSCEPTIBILITY_STATUS_CD  NUMBER              DEFAULT 0                     NOT NULL,
  ABNORMAL_FLAG             NUMBER              DEFAULT 0                     NOT NULL,
  CHARTABLE_FLAG            NUMBER              DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID           NUMBER              DEFAULT 0                     NOT NULL,
  ANTIBIOTIC_NOTE           VARCHAR2(255 BYTE),
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  RESULT_TZ                 NUMBER              DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE
(
  CHARGE_ITEM_ID               NUMBER           DEFAULT 0                     NOT NULL,
  CHARGE_EVENT_ID              NUMBER           DEFAULT 0                     NOT NULL,
  BILL_ITEM_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  PAYOR_ID                     NUMBER           DEFAULT 0                     NOT NULL,
  CHARGE_DESCRIPTION           VARCHAR2(200 BYTE),
  PRICE_SCHED_ID               NUMBER           DEFAULT 0                     NOT NULL,
  ITEM_QUANTITY                FLOAT(126),
  ITEM_PRICE                   FLOAT(126),
  ITEM_EXTENDED_PRICE          FLOAT(126),
  PARENT_CHARGE_ITEM_ID        NUMBER           DEFAULT 0                     NOT NULL,
  CHARGE_TYPE_CD               NUMBER           DEFAULT 0                     NOT NULL,
  SUSPENSE_RSN_CD              NUMBER           DEFAULT 0                     NOT NULL,
  REASON_COMMENT               VARCHAR2(200 BYTE),
  POSTED_CD                    NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVITY_DT_TM               DATE,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER,
  ACTIVE_STATUS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM          DATE,
  ACTIVE_STATUS_PRSNL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE,
  END_EFFECTIVE_DT_TM          DATE,
  CHARGE_EVENT_ACT_ID          NUMBER           DEFAULT 0                     NOT NULL,
  ORDER_ID                     NUMBER           DEFAULT 0                     NOT NULL,
  ENCNTR_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  PERSON_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  ORD_LOC_CD                   NUMBER           DEFAULT 0                     NOT NULL,
  PERF_LOC_CD                  NUMBER           DEFAULT 0                     NOT NULL,
  ORD_PHYS_ID                  NUMBER           DEFAULT 0                     NOT NULL,
  PERF_PHYS_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  ITEM_ALLOWABLE               FLOAT(126),
  ITEM_COPAY                   FLOAT(126),
  RESEARCH_ACCT_ID             NUMBER           DEFAULT 0                     NOT NULL,
  POSTED_DT_TM                 DATE,
  PROCESS_FLG                  NUMBER,
  SERVICE_DT_TM                DATE,
  CREDITED_DT_TM               DATE,
  ADJUSTED_DT_TM               DATE,
  INTERFACE_FILE_ID            NUMBER           DEFAULT 0                     NOT NULL,
  TIER_GROUP_CD                NUMBER           DEFAULT 0                     NOT NULL,
  DEF_BILL_ITEM_ID             NUMBER           DEFAULT 0                     NOT NULL,
  DISCOUNT_AMOUNT              FLOAT(126),
  VERIFY_PHYS_ID               NUMBER           DEFAULT 0                     NOT NULL,
  GROSS_PRICE                  FLOAT(126),
  MANUAL_IND                   NUMBER           DEFAULT 0,
  COMBINE_IND                  NUMBER,
  ABN_STATUS_CD                NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVITY_TYPE_CD             NUMBER           DEFAULT 0                     NOT NULL,
  ADMIT_TYPE_CD                NUMBER           DEFAULT 0                     NOT NULL,
  BUNDLE_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  COST_CENTER_CD               NUMBER           DEFAULT 0                     NOT NULL,
  DEPARTMENT_CD                NUMBER           DEFAULT 0                     NOT NULL,
  INSTITUTION_CD               NUMBER           DEFAULT 0                     NOT NULL,
  INST_FIN_NBR                 VARCHAR2(50 BYTE),
  LEVEL5_CD                    NUMBER           DEFAULT 0                     NOT NULL,
  MED_SERVICE_CD               NUMBER           DEFAULT 0                     NOT NULL,
  SECTION_CD                   NUMBER           DEFAULT 0                     NOT NULL,
  SUBSECTION_CD                NUMBER           DEFAULT 0                     NOT NULL,
  FIN_CLASS_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID               NUMBER           DEFAULT 0                     NOT NULL,
  ITEM_INTERVAL_ID             NUMBER           DEFAULT 0                     NOT NULL,
  ITEM_LIST_PRICE              FLOAT(126)       DEFAULT 0,
  ITEM_REIMBURSEMENT           FLOAT(126)       DEFAULT 0,
  LIST_PRICE_SCHED_ID          NUMBER           DEFAULT 0                     NOT NULL,
  PAYOR_TYPE_CD                NUMBER           DEFAULT 0                     NOT NULL,
  EPSDT_IND                    NUMBER,
  REF_PHYS_ID                  NUMBER           DEFAULT 0                     NOT NULL,
  START_DT_TM                  DATE,
  STOP_DT_TM                   DATE,
  ALPHA_NOMEN_ID               NUMBER           DEFAULT 0                     NOT NULL,
  SERVER_PROCESS_FLAG          NUMBER,
  OFFSET_CHARGE_ITEM_ID        NUMBER           DEFAULT 0                     NOT NULL,
  ITEM_DEDUCTIBLE_AMT          FLOAT(126),
  PATIENT_RESPONSIBILITY_FLAG  NUMBER           DEFAULT 0                     NOT NULL,
  CS_CPP_UNDO_ID               NUMBER           DEFAULT 0                     NOT NULL,
  CS_CPP_UNDO_QUAL_ID          NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_BATCH
(
  CHARGE_BATCH_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  CREATED_PRSNL_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  ASSIGNED_PRSNL_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  USER_DEFINED_IND   NUMBER                     DEFAULT 0                     NOT NULL,
  ACTIVE_IND         NUMBER                     DEFAULT 0                     NOT NULL,
  STATUS_CD          NUMBER                     DEFAULT 0                     NOT NULL,
  STATUS_DT_TM       DATE,
  CREATED_DT_TM      DATE,
  ACCESSED_DT_TM     DATE,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  BATCH_ALIAS        VARCHAR2(50 BYTE)          DEFAULT ' '                   NOT NULL,
  BATCH_DT_TM        DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_BATCH_DETAIL
(
  CHARGE_BATCH_DETAIL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  CHARGE_BATCH_ID              NUMBER           DEFAULT 0                     NOT NULL,
  ENCNTR_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  ORDERING_PHYS_ID             NUMBER           DEFAULT 0                     NOT NULL,
  BILL_ITEM_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SERVICE_ITEM_IDENT           VARCHAR2(50 BYTE) DEFAULT ' ' NOT NULL,
  SERVICE_ITEM_IDENT_TYPE_CD   NUMBER           DEFAULT 0                     NOT NULL,
  SERVICE_ITEM_QTY             FLOAT(126)       DEFAULT 0                     NOT NULL,
  SERVICE_ITEM_PRICE_AMT       FLOAT(126)       DEFAULT 0                     NOT NULL,
  SERVICE_ITEM_DESC            VARCHAR2(200 BYTE) DEFAULT ' ' NOT NULL,
  SERVICE_DT_TM                DATE,
  PERF_LOC_CD                  NUMBER           DEFAULT 0                     NOT NULL,
  STATUS_CD                    NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  DIAGNOSIS_POINTER_NBR        NUMBER           DEFAULT 0                     NOT NULL,
  RENDERING_PHYS_ID            NUMBER           DEFAULT 0                     NOT NULL,
  CREATED_DT_TM                DATE             DEFAULT SYSDATE,
  PATIENT_RESPONSIBILITY_FLAG  NUMBER           DEFAULT 0,
  ITEM_COPAY_AMT               FLOAT(126)       DEFAULT 0,
  ITEM_DEDUCTIBLE_AMT          FLOAT(126)       DEFAULT 0,
  DIAGNOSIS_POINTER_TXT        VARCHAR2(50 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_BATCH_DETAIL_CODE
(
  CHARGE_BATCH_DETAIL_CODE_ID  NUMBER           DEFAULT 0                     NOT NULL,
  CHARGE_BATCH_DETAIL_ID       NUMBER           DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME           VARCHAR2(30 BYTE) DEFAULT ' ' NOT NULL,
  PARENT_ENTITY_ID             NUMBER           DEFAULT 0                     NOT NULL,
  TYPE_IDENT                   VARCHAR2(50 BYTE) DEFAULT ' ' NOT NULL,
  PRIORITY_SEQ                 NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  TYPE_CD                      NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_BATCH_DETAIL_FIELD
(
  CHARGE_BATCH_DETAIL_FIELD_ID  NUMBER          DEFAULT 0                     NOT NULL,
  CHARGE_BATCH_DETAIL_ID        NUMBER          DEFAULT 0                     NOT NULL,
  FIELD_TYPE_CD                 NUMBER          DEFAULT 0                     NOT NULL,
  FIELD_VALUE_DT_TM             DATE,
  FIELD_VALUE_CHAR              VARCHAR2(200 BYTE) DEFAULT ' ' NOT NULL,
  FIELD_VALUE_NBR               FLOAT(126)      DEFAULT 0                     NOT NULL,
  FIELD_VALUE_IND               NUMBER          DEFAULT 0                     NOT NULL,
  FIELD_VALUE_CD                NUMBER          DEFAULT 0                     NOT NULL,
  ACTIVE_IND                    NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_EVENT
(
  CHARGE_EVENT_ID          NUMBER               DEFAULT 0                     NOT NULL,
  EXT_M_EVENT_ID           NUMBER               DEFAULT 0                     NOT NULL,
  EXT_M_EVENT_CONT_CD      NUMBER               DEFAULT 0                     NOT NULL,
  EXT_M_REFERENCE_ID       NUMBER               DEFAULT 0                     NOT NULL,
  EXT_M_REFERENCE_CONT_CD  NUMBER               DEFAULT 0                     NOT NULL,
  EXT_P_EVENT_ID           NUMBER               DEFAULT 0                     NOT NULL,
  EXT_P_EVENT_CONT_CD      NUMBER               DEFAULT 0                     NOT NULL,
  EXT_P_REFERENCE_ID       NUMBER               DEFAULT 0                     NOT NULL,
  EXT_P_REFERENCE_CONT_CD  NUMBER               DEFAULT 0                     NOT NULL,
  EXT_I_EVENT_ID           NUMBER               DEFAULT 0                     NOT NULL,
  EXT_I_EVENT_CONT_CD      NUMBER               DEFAULT 0                     NOT NULL,
  EXT_I_REFERENCE_ID       NUMBER               DEFAULT 0                     NOT NULL,
  EXT_I_REFERENCE_CONT_CD  NUMBER               DEFAULT 0                     NOT NULL,
  BILL_ITEM_ID             NUMBER               DEFAULT 0                     NOT NULL,
  P_BILL_ITEM_ID           NUMBER               DEFAULT 0                     NOT NULL,
  M_BILL_ITEM_ID           NUMBER               DEFAULT 0                     NOT NULL,
  P_CHARGE_EVENT_ID        NUMBER               DEFAULT 0                     NOT NULL,
  M_CHARGE_EVENT_ID        NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0                     NOT NULL,
  REFERENCE_NBR            VARCHAR2(60 BYTE),
  CANCELLED_IND            NUMBER,
  CANCELLED_DT_TM          DATE,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  COLLECTION_PRIORITY_CD   NUMBER               DEFAULT 0                     NOT NULL,
  REPORT_PRIORITY_CD       NUMBER               DEFAULT 0                     NOT NULL,
  ACCESSION                VARCHAR2(50 BYTE),
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_DT_TM      DATE,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  RESEARCH_ACCOUNT_ID      NUMBER               DEFAULT 0                     NOT NULL,
  ABN_STATUS_CD            NUMBER               DEFAULT 0                     NOT NULL,
  PERF_LOC_CD              NUMBER               DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID           NUMBER               DEFAULT 0                     NOT NULL,
  EPSDT_IND                NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_EVENT_ACT
(
  CHARGE_EVENT_ACT_ID          NUMBER           DEFAULT 0                     NOT NULL,
  CHARGE_EVENT_ID              NUMBER           DEFAULT 0                     NOT NULL,
  CEA_TYPE_CD                  NUMBER           DEFAULT 0                     NOT NULL,
  CEA_PRSNL_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD          NUMBER           DEFAULT 0                     NOT NULL,
  SERVICE_DT_TM                DATE,
  CHARGE_DT_TM                 DATE,
  CHARGE_TYPE_CD               NUMBER           DEFAULT 0                     NOT NULL,
  REFERENCE_RANGE_FACTOR_ID    NUMBER           DEFAULT 0                     NOT NULL,
  ALPHA_NOMEN_ID               NUMBER           DEFAULT 0                     NOT NULL,
  QUANTITY                     FLOAT(126)       DEFAULT 0                     NOT NULL,
  UNITS                        NUMBER           DEFAULT 0                     NOT NULL,
  UNIT_TYPE_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  PATIENT_LOC_CD               NUMBER           DEFAULT 0                     NOT NULL,
  SERVICE_LOC_CD               NUMBER           DEFAULT 0                     NOT NULL,
  REASON_CD                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVE_IND                   NUMBER,
  INSERT_DT_TM                 DATE,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  IN_LAB_DT_TM                 DATE,
  ACCESSION_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  REPEAT_IND                   NUMBER           DEFAULT 0,
  RESULT                       VARCHAR2(200 BYTE),
  CEA_MISC1                    VARCHAR2(200 BYTE),
  CEA_MISC1_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  CEA_MISC2                    VARCHAR2(200 BYTE),
  CEA_MISC2_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  CEA_MISC3                    VARCHAR2(200 BYTE),
  CEA_MISC3_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  CEA_MISC4_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SRV_DIAG1_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SRV_DIAG2_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SRV_DIAG3_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SRV_DIAG4_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  SRV_DIAG_CD                  NUMBER           DEFAULT 0                     NOT NULL,
  MISC_IND                     NUMBER           DEFAULT 0,
  CEA_MISC5_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  CEA_MISC6_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  CEA_MISC7_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  ACTIVITY_DT_TM               DATE,
  PRIORITY_CD                  NUMBER           DEFAULT 0                     NOT NULL,
  ITEM_PRICE                   FLOAT(126)       DEFAULT 0                     NOT NULL,
  ITEM_EXT_PRICE               FLOAT(126)       DEFAULT 0                     NOT NULL,
  ITEM_COPAY                   FLOAT(126)       DEFAULT 0                     NOT NULL,
  DISCOUNT_AMOUNT              FLOAT(126)       DEFAULT 0                     NOT NULL,
  ITEM_REIMBURSEMENT           FLOAT(126)       DEFAULT 0                     NOT NULL,
  ITEM_DEDUCTIBLE_AMT          FLOAT(126),
  PATIENT_RESPONSIBILITY_FLAG  NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_EVENT_ACT_PRSNL
(
  CHARGE_EVENT_ACT_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PRSNL_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  PRSNL_TYPE_CD        NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVE_IND           NUMBER,
  DM2_MIG_SEQ_ID       NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_EVENT_MOD
(
  CHARGE_EVENT_MOD_ID       NUMBER              DEFAULT 0                     NOT NULL,
  CHARGE_EVENT_ID           NUMBER              DEFAULT 0                     NOT NULL,
  CHARGE_EVENT_MOD_TYPE_CD  NUMBER              DEFAULT 0                     NOT NULL,
  FIELD1                    VARCHAR2(200 BYTE),
  FIELD2                    VARCHAR2(200 BYTE),
  FIELD3                    VARCHAR2(200 BYTE),
  FIELD4                    VARCHAR2(200 BYTE),
  FIELD5                    VARCHAR2(200 BYTE),
  FIELD6                    VARCHAR2(200 BYTE),
  FIELD7                    VARCHAR2(200 BYTE),
  FIELD8                    VARCHAR2(200 BYTE),
  FIELD9                    VARCHAR2(200 BYTE),
  FIELD10                   VARCHAR2(200 BYTE),
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_IND                NUMBER,
  ACTIVE_STATUS_CD          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM       DATE,
  ACTIVE_STATUS_PRSNL_ID    NUMBER              DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM       DATE                DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM       DATE                DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  CODE1_CD                  NUMBER              DEFAULT 0                     NOT NULL,
  NOMEN_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  FIELD1_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  FIELD2_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  FIELD3_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  FIELD4_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  FIELD5_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  CM1_NBR                   FLOAT(126)          DEFAULT 0                     NOT NULL,
  ACTIVITY_DT_TM            DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARGE_MOD
(
  CHARGE_MOD_ID           NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_ITEM_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_MOD_TYPE_CD      NUMBER                DEFAULT 0                     NOT NULL,
  FIELD1                  VARCHAR2(200 BYTE),
  FIELD2                  VARCHAR2(200 BYTE),
  FIELD3                  VARCHAR2(200 BYTE),
  FIELD4                  VARCHAR2(200 BYTE),
  FIELD5                  VARCHAR2(200 BYTE),
  FIELD6                  VARCHAR2(200 BYTE),
  FIELD7                  VARCHAR2(200 BYTE),
  FIELD8                  VARCHAR2(200 BYTE),
  FIELD9                  VARCHAR2(200 BYTE),
  FIELD10                 VARCHAR2(200 BYTE),
  ACTIVITY_DT_TM          DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  CODE1_CD                NUMBER                DEFAULT 0                     NOT NULL,
  NOMEN_ID                NUMBER                DEFAULT 0                     NOT NULL,
  FIELD1_ID               NUMBER                DEFAULT 0                     NOT NULL,
  FIELD2_ID               NUMBER                DEFAULT 0                     NOT NULL,
  FIELD3_ID               NUMBER                DEFAULT 0                     NOT NULL,
  FIELD4_ID               NUMBER                DEFAULT 0                     NOT NULL,
  FIELD5_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CM1_NBR                 FLOAT(126)            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHARTING_OPERATIONS_PRSNL
(
  CHARTING_OPERATIONS_PRSNL_ID  NUMBER          DEFAULT 0                     NOT NULL,
  CHARTING_OPERATIONS_ID        NUMBER          DEFAULT 0                     NOT NULL,
  PRSNL_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_DEFINED_SEQUENCE
(
  DEFINED_SEQ_ID          NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_ENCNTR_DISCHARGE
(
  CHART_ENCNTR_DISCHARGE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  ENCNTR_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  TRANSACT_DT_TM             DATE               DEFAULT SYSDATE               NOT NULL,
  PERSON_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  DISCHARGE_DT_TM            DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_OF_ACCOUNT
(
  ORGANIZATION_ID  NUMBER                       DEFAULT 0                     NOT NULL,
  COST_CENTER_CD   NUMBER                       DEFAULT 0                     NOT NULL,
  SUB_ACCOUNT_CD   NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_PRINTED_SECTIONS
(
  PRINTED_SECTION_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  CHART_REQUEST_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  RESUBMIT_NBR        NUMBER                    DEFAULT 0                     NOT NULL,
  RESUBMIT_DT_TM      DATE                      DEFAULT SYSDATE,
  CHART_SECTION_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_PRINT_QUEUE
(
  CHART_QUEUE_ID       NUMBER                   DEFAULT 0                     NOT NULL,
  BATCH_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  REQUEST_ID           NUMBER                   DEFAULT 0                     NOT NULL,
  QUEUE_STATUS_CD      NUMBER                   DEFAULT 0                     NOT NULL,
  CHART_PATH           VARCHAR2(150 BYTE)       DEFAULT ' '                   NOT NULL,
  NUM_COPIES           NUMBER                   DEFAULT 0,
  BEGIN_PAGE           NUMBER,
  END_PAGE             NUMBER,
  PRINT_PATH           VARCHAR2(75 BYTE)        DEFAULT ' '                   NOT NULL,
  DISTRIBUTION_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  DIST_RUN_DT_TM       DATE,
  DIST_TERMINATOR_IND  NUMBER                   DEFAULT 0,
  QUEUED_DT_TM         DATE,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_PROCESS
(
  CHART_PROCESS_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ALLOCATION_DT_TM        DATE,
  ENCNTR_ID               NUMBER                DEFAULT 0,
  PERSON_ID               NUMBER                DEFAULT 0,
  CHART_STATUS_CD         NUMBER                DEFAULT 0,
  CHART_STATUS_DT_TM      DATE,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0,
  ABSTRACT_COMPLETE_IND   NUMBER,
  ALLOCATION_DT_FLAG      NUMBER,
  ALLOCATION_DT_MODIFIER  NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_REQUEST
(
  CHART_REQUEST_ID        NUMBER                DEFAULT 0                     NOT NULL,
  REQUEST_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  REQUEST_TYPE            NUMBER,
  SCOPE_FLAG              NUMBER,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ACCESSION_NBR           VARCHAR2(20 BYTE),
  CHART_FORMAT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  DISTRIBUTION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  DIST_RUN_TYPE_CD        NUMBER                DEFAULT 0                     NOT NULL,
  DIST_RUN_DT_TM          DATE,
  DIST_INITIATOR_IND      NUMBER,
  DIST_TERMINATOR_IND     NUMBER,
  DATE_RANGE_IND          NUMBER,
  BEGIN_DT_TM             DATE,
  END_DT_TM               DATE,
  PAGE_RANGE_IND          NUMBER,
  BEGIN_PAGE              NUMBER,
  END_PAGE                NUMBER,
  PRINT_COMPLETE_FLAG     NUMBER,
  CHART_PENDING_FLAG      NUMBER,
  ADDL_COPIES             NUMBER,
  OUTPUT_DEST_CD          NUMBER                DEFAULT 0                     NOT NULL,
  OUTPUT_DEVICE_CD        NUMBER                DEFAULT 0                     NOT NULL,
  HANDLE_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RRD_DELIVER_DT_TM       DATE,
  RRD_COUNTRY_ACCESS      VARCHAR2(3 BYTE),
  RRD_AREA_CODE           VARCHAR2(10 BYTE),
  RRD_EXCHANGE            VARCHAR2(10 BYTE),
  RRD_PHONE_SUFFIX        VARCHAR2(50 BYTE),
  STATUS_FLAG             NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  READER_GROUP            VARCHAR2(15 BYTE),
  RESUBMIT_DT_TM          DATE,
  RESUBMIT_CNT            NUMBER,
  REQUEST_DT_TM           DATE,
  MCIS_IND                NUMBER,
  CHART_STATUS_CD         NUMBER                DEFAULT 0                     NOT NULL,
  TRIGGER_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PROCESS_TIME            FLOAT(126),
  PRSNL_PERSON_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_PERSON_R_CD       NUMBER                DEFAULT 0                     NOT NULL,
  RECOVER_CNT             NUMBER,
  RECOVER_DT_TM           DATE,
  SERVER_NAME             VARCHAR2(20 BYTE),
  TOTAL_PAGES             NUMBER,
  TRIGGER_TYPE            VARCHAR2(15 BYTE),
  EVENT_IND               NUMBER,
  FILE_STORAGE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  FILE_STORAGE_LOCATION   VARCHAR2(100 BYTE),
  TRIGGER_NAME            VARCHAR2(100 BYTE),
  PRSNL_RELTN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  SUPPRESS_MRPNODATA_IND  NUMBER                DEFAULT 0,
  CHART_BATCH_ID          NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE_GROUP_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CHART_ROUTE_ID          NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_LOOKUP_IND       NUMBER                DEFAULT 0,
  GROUP_ORDER_ID          NUMBER                DEFAULT 0,
  ORDER_GROUP_FLAG        NUMBER                DEFAULT 0,
  CR_MASK_ID              NUMBER                DEFAULT 0,
  USER_ROLE_PROFILE       VARCHAR2(255 BYTE),
  CHART_TRIGGER_ID        NUMBER                DEFAULT 0                     NOT NULL,
  NON_CE_BEGIN_DT_TM      DATE,
  NON_CE_END_DT_TM        DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_REQUEST_ENCNTR
(
  CHART_REQUEST_ENCNTR_ID  NUMBER               DEFAULT 0                     NOT NULL,
  CHART_REQUEST_ID         NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  CR_ENCNTR_SEQ            NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_REQUEST_EVENT
(
  CR_EVENT_ID       NUMBER                      DEFAULT 0                     NOT NULL,
  CHART_REQUEST_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  EVENT_ID          NUMBER                      DEFAULT 0                     NOT NULL,
  CR_EVENT_SEQ      NUMBER,
  RESULT_STATUS_CD  NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_REQUEST_ORDER
(
  CHART_REQUEST_ORDER_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CHART_REQUEST_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ORDER_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_REQUEST_SECTION
(
  CHART_REQUEST_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CHART_SECTION_ID        NUMBER                DEFAULT 0                     NOT NULL,
  CR_SECT_SEQ             NUMBER,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_REQ_INERR_EVENT
(
  CHART_REQ_INERR_EVENT_ID  NUMBER              DEFAULT 0                     NOT NULL,
  CHART_REQUEST_ID          NUMBER              DEFAULT 0                     NOT NULL,
  EVENT_ID                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_SEQ_GROUP_RELTN
(
  GROUP_RELTN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE_GROUP_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  LOCATION_CD             NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_SERV_LOG
(
  CHART_LOG_NUM     NUMBER                      DEFAULT 0                     NOT NULL,
  LOG_DT_TM         DATE,
  LOG_LEVEL         NUMBER,
  CHART_REQUEST_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  MESSAGE_TEXT      VARCHAR2(150 BYTE),
  SERVER_NAME       VARCHAR2(30 BYTE),
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_TEMP
(
  CREATE_DT_TM        DATE,
  DISTRIBUTION_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  ENCNTR_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  ENCNTR_TYPE_CD      NUMBER                    DEFAULT 0                     NOT NULL,
  LOC_BED_CD          NUMBER                    DEFAULT 0                     NOT NULL,
  LOC_BUILDING_CD     NUMBER                    DEFAULT 0                     NOT NULL,
  LOC_FACILITY_CD     NUMBER                    DEFAULT 0                     NOT NULL,
  LOC_NURSE_UNIT_CD   NUMBER                    DEFAULT 0                     NOT NULL,
  LOC_ROOM_CD         NUMBER                    DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  PERSON_ID           NUMBER                    DEFAULT 0                     NOT NULL,
  USE_IND             NUMBER,
  DONT_USE_IND        NUMBER,
  BEGIN_DT_TM         DATE,
  LOOKBACK_DT_TM      DATE,
  DM2_MIG_SEQ_ID      NUMBER,
  NON_CE_BEGIN_DT_TM  DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_TRIGGER
(
  CHART_TRIGGER_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PREV_CHART_TRIGGER_ID   NUMBER                DEFAULT 0                     NOT NULL,
  TRIGGER_TYPE_FLAG       NUMBER                DEFAULT 0                     NOT NULL,
  TRIGGER_NAME            VARCHAR2(150 BYTE)    DEFAULT ' '                   NOT NULL,
  TRIGGER_NAME_KEY        VARCHAR2(150 BYTE)    DEFAULT ' '                   NOT NULL,
  COMPLETE_FLAG           NUMBER                DEFAULT 0                     NOT NULL,
  DISCHARGE_TYPE_FLAG     NUMBER                DEFAULT 0                     NOT NULL,
  SCOPE_FLAG              NUMBER                DEFAULT 0                     NOT NULL,
  PENDING_FLAG            NUMBER                DEFAULT 0                     NOT NULL,
  REPORT_TEMPLATE_ID      NUMBER                DEFAULT 0                     NOT NULL,
  CHART_FORMAT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PRINT_RANGE_FLAG        NUMBER                DEFAULT 0                     NOT NULL,
  ROUTE_LOCATION_BIT_MAP  NUMBER                DEFAULT 0                     NOT NULL,
  DEFAULT_OUTPUT_DEST_CD  NUMBER                DEFAULT 0                     NOT NULL,
  EXPIRED_RELTN_IND       NUMBER                DEFAULT 0                     NOT NULL,
  FILE_STORAGE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  FILE_STORAGE_LOCATION   VARCHAR2(225 BYTE),
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  NAME_IDENT              VARCHAR2(167 BYTE)    DEFAULT ' '                   NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  DAYS_NBR                NUMBER                DEFAULT 0                     NOT NULL,
  DMS_SERVICE_NAME        VARCHAR2(64 BYTE),
  DATE_DT_TM              DATE,
  ADDITIONAL_COPY_NBR     NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHART_TRIGGER_PARAM
(
  CHART_TRIGGER_PARAM_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CHART_TRIGGER_ID        NUMBER                DEFAULT 0                     NOT NULL,
  INCLUDE_IND             NUMBER                DEFAULT 0                     NOT NULL,
  PARAM_TYPE_FLAG         NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(30 BYTE)     DEFAULT ' '                   NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CHRG_GRP_EXCEPTION
(
  CHRG_GRP_EXCEPTION_ID   NUMBER                DEFAULT 0                     NOT NULL,
  PRIMARY_HP_ID           NUMBER                DEFAULT 0                     NOT NULL,
  PRIMARY_INS_ORG_ID      NUMBER                DEFAULT 0                     NOT NULL,
  SECONDARY_HP_ID         NUMBER                DEFAULT 0                     NOT NULL,
  SECONDARY_INS_ORG_ID    NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CLASS_GROUP
(
  CLASS_GROUP_ID          NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_CLASS_NODE_ID    NUMBER                DEFAULT 0                     NOT NULL,
  CHILD_CLASS_NODE_ID     NUMBER                DEFAULT 0                     NOT NULL,
  CLASS_INSTANCE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CREATE_APPLCTX          NUMBER,
  CREATE_DT_TM            DATE,
  CREATE_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CREATE_TASK             NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CLASS_NODE
(
  CLASS_NODE_ID           NUMBER                DEFAULT 0                     NOT NULL,
  CLASS_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  CLASS_INSTANCE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  DESCRIPTION             VARCHAR2(60 BYTE),
  SHORT_DESCRIPTION       VARCHAR2(40 BYTE),
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CREATE_APPLCTX          NUMBER,
  CREATE_DT_TM            DATE,
  CREATE_ID               NUMBER                DEFAULT 0,
  CREATE_TASK             NUMBER,
  LOGICAL_DOMAIN_ID       NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CLINICAL_EVENT
(
  CLINICAL_EVENT_ID        NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_START_DT_TM        DATE,
  ENCNTR_FINANCIAL_ID      NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  VALID_UNTIL_DT_TM        DATE                 DEFAULT SYSDATE               NOT NULL,
  EVENT_TITLE_TEXT         VARCHAR2(255 BYTE),
  VIEW_LEVEL               NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  CATALOG_CD               NUMBER               DEFAULT 0                     NOT NULL,
  SERIES_REF_NBR           VARCHAR2(100 BYTE),
  ACCESSION_NBR            VARCHAR2(20 BYTE),
  CONTRIBUTOR_SYSTEM_CD    NUMBER               DEFAULT 0                     NOT NULL,
  REFERENCE_NBR            VARCHAR2(100 BYTE)   DEFAULT ' '                   NOT NULL,
  PARENT_EVENT_ID          NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_RELTN_CD           NUMBER               DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM         DATE                 DEFAULT SYSDATE               NOT NULL,
  EVENT_CLASS_CD           NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_TAG                VARCHAR2(255 BYTE)   DEFAULT ' '                   NOT NULL,
  EVENT_END_DT_TM          DATE                 DEFAULT SYSDATE               NOT NULL,
  EVENT_END_DT_TM_OS       FLOAT(126),
  RESULT_VAL               VARCHAR2(255 BYTE),
  RESULT_UNITS_CD          NUMBER               DEFAULT 0                     NOT NULL,
  RESULT_TIME_UNITS_CD     NUMBER               DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD            NUMBER               DEFAULT 0                     NOT NULL,
  RECORD_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  RESULT_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  AUTHENTIC_FLAG           NUMBER               DEFAULT 0                     NOT NULL,
  PUBLISH_FLAG             NUMBER               DEFAULT 0                     NOT NULL,
  QC_REVIEW_CD             NUMBER               DEFAULT 0                     NOT NULL,
  NORMALCY_CD              NUMBER               DEFAULT 0                     NOT NULL,
  NORMALCY_METHOD_CD       NUMBER               DEFAULT 0                     NOT NULL,
  INQUIRE_SECURITY_CD      NUMBER               DEFAULT 0                     NOT NULL,
  RESOURCE_GROUP_CD        NUMBER               DEFAULT 0                     NOT NULL,
  RESOURCE_CD              NUMBER               DEFAULT 0                     NOT NULL,
  SUBTABLE_BIT_MAP         NUMBER,
  COLLATING_SEQ            VARCHAR2(40 BYTE),
  VERIFIED_DT_TM           DATE,
  VERIFIED_PRSNL_ID        NUMBER               DEFAULT 0                     NOT NULL,
  PERFORMED_DT_TM          DATE,
  PERFORMED_PRSNL_ID       NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  NORMAL_LOW               VARCHAR2(20 BYTE),
  NORMAL_HIGH              VARCHAR2(20 BYTE),
  CRITICAL_LOW             VARCHAR2(20 BYTE),
  CRITICAL_HIGH            VARCHAR2(20 BYTE),
  EXPIRATION_DT_TM         DATE,
  NOTE_IMPORTANCE_BIT_MAP  NUMBER               DEFAULT 0,
  EVENT_TAG_SET_FLAG       NUMBER,
  CLINSIG_UPDT_DT_TM       DATE,
  ORDER_ACTION_SEQUENCE    NUMBER               DEFAULT 0                     NOT NULL,
  ENTRY_MODE_CD            NUMBER               DEFAULT 0                     NOT NULL,
  SOURCE_CD                NUMBER               DEFAULT 0                     NOT NULL,
  CLINICAL_SEQ             VARCHAR2(40 BYTE),
  EVENT_END_TZ             NUMBER               DEFAULT 0,
  EVENT_START_TZ           NUMBER               DEFAULT 0,
  PERFORMED_TZ             NUMBER               DEFAULT 0,
  VERIFIED_TZ              NUMBER               DEFAULT 0,
  TASK_ASSAY_VERSION_NBR   FLOAT(126),
  MODIFIER_LONG_TEXT_ID    NUMBER               DEFAULT 0                     NOT NULL,
  NOMEN_STRING_FLAG        NUMBER               DEFAULT 0,
  SRC_CLINSIG_UPDT_DT_TM   DATE,
  SRC_EVENT_ID             NUMBER               DEFAULT 0                     NOT NULL,
  CE_DYNAMIC_LABEL_ID      NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CMS_CRITICAL_CATEGORY
(
  CMS_CRITICAL_CATEGORY_ID  NUMBER              DEFAULT 0                     NOT NULL,
  MULTUM_CATEGORY_ID        NUMBER              DEFAULT 0                     NOT NULL,
  CMS_CRITICAL_LOCATION_ID  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CMS_CRITICAL_LOCATION
(
  CMS_CRITICAL_LOCATION_ID  NUMBER              DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID           NUMBER              DEFAULT 0                     NOT NULL,
  LOCATION_CD               NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_DCP_SHIFT_ASSIGNMENT_ST
(
  CN_DCP_SHIFT_ASSIGNMENT_ST_ID  NUMBER         DEFAULT 0                     NOT NULL,
  CARETEAM_NAME                  VARCHAR2(100 BYTE),
  PRSNL_ID                       NUMBER         DEFAULT 0                     NOT NULL,
  PRSNL_POS_CD                   NUMBER         DEFAULT 0                     NOT NULL,
  ASSIGNMENT_GROUP_CD            NUMBER         DEFAULT 0                     NOT NULL,
  LOC_BUILDING_CD                NUMBER         DEFAULT 0                     NOT NULL,
  LOC_FACILITY_CD                NUMBER         DEFAULT 0                     NOT NULL,
  LOC_UNIT_CD                    NUMBER         DEFAULT 0                     NOT NULL,
  LOC_ROOM_CD                    NUMBER         DEFAULT 0                     NOT NULL,
  LOC_BED_CD                     NUMBER         DEFAULT 0                     NOT NULL,
  PERSON_ID                      NUMBER         DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM            DATE,
  END_EFFECTIVE_DT_TM            DATE,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  ENCNTR_ID                      NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_OUTCOME_ST
(
  OUTCOME_ACTIVITY_ID      NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_CATALOG_ID       NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_CLASS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_TYPE_CD          NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_STATUS_CD        NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_STATUS_DT_TM     DATE                 DEFAULT SYSDATE               NOT NULL,
  OUTCOME_STATUS_DT_NBR    NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_STATUS_MIN_NBR   NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_STATUS_PRSNL_ID  NUMBER               DEFAULT 0                     NOT NULL,
  DESCRIPTION              VARCHAR2(310 BYTE)   DEFAULT ' '                   NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_CD                 NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_IND              NUMBER               DEFAULT 0                     NOT NULL,
  START_DT_TM              DATE,
  START_DT_NBR             NUMBER               DEFAULT 0                     NOT NULL,
  START_MIN_NBR            NUMBER               DEFAULT 0                     NOT NULL,
  END_DT_TM                DATE,
  END_DT_NBR               NUMBER               DEFAULT 0                     NOT NULL,
  END_MIN_NBR              NUMBER               DEFAULT 0                     NOT NULL,
  RESULT_SEARCH_END_DT_TM  DATE,
  TARGET_DURATION_QTY      NUMBER               DEFAULT 0,
  TARGET_DURATION_UNIT_CD  NUMBER               DEFAULT 0                     NOT NULL,
  TARGET_TYPE_CD           NUMBER               DEFAULT 0                     NOT NULL,
  TARGET_DURATION_MIN_NBR  NUMBER               DEFAULT 0                     NOT NULL,
  ACTUAL_DURATION_MIN_NBR  NUMBER               DEFAULT 0                     NOT NULL,
  PLANNED_IND              NUMBER               DEFAULT 0                     NOT NULL,
  PLANNED_DT_TM            DATE,
  PLANNED_DT_NBR           NUMBER               DEFAULT 0                     NOT NULL,
  PLANNED_MIN_NBR          NUMBER               DEFAULT 0                     NOT NULL,
  PLANNED_PRSNL_ID         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVATED_IND            NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVATED_DT_TM          DATE,
  ACTIVATED_DT_NBR         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVATED_MIN_NBR        NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVATED_PRSNL_ID       NUMBER               DEFAULT 0                     NOT NULL,
  STOPPED_IND              NUMBER               DEFAULT 0                     NOT NULL,
  STOPPED_DT_TM            DATE,
  STOPPED_DT_NBR           NUMBER               DEFAULT 0                     NOT NULL,
  STOPPED_MIN_NBR          NUMBER               DEFAULT 0                     NOT NULL,
  STOPPED_PRSNL_ID         NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_PATHWAY_ST
(
  PATHWAY_ID               NUMBER               DEFAULT 0                     NOT NULL,
  PATHWAY_CATALOG_ID       NUMBER               DEFAULT 0                     NOT NULL,
  VERSION                  NUMBER,
  DESCRIPTION              VARCHAR2(100 BYTE)   DEFAULT ' '                   NOT NULL,
  PW_STATUS_CD             NUMBER               DEFAULT 0                     NOT NULL,
  PATHWAY_IND              NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  STATUS_DT_TM             DATE                 DEFAULT SYSDATE               NOT NULL,
  STATUS_DT_NBR            NUMBER,
  STATUS_MIN_NBR           NUMBER,
  STATUS_PRSNL_ID          NUMBER               DEFAULT 0                     NOT NULL,
  STATUS_LOC_FAC_CD        NUMBER               DEFAULT 0                     NOT NULL,
  STATUS_LOC_BLD_CD        NUMBER               DEFAULT 0                     NOT NULL,
  STATUS_LOC_NU_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ORDERED_IND              NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_DT_TM              DATE                 DEFAULT SYSDATE               NOT NULL,
  ORDER_DT_NBR             NUMBER,
  ORDER_MIN_NBR            NUMBER,
  ORDER_PRSNL_ID           NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_LOC_FAC_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_LOC_BLD_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ORDER_LOC_NU_CD          NUMBER               DEFAULT 0                     NOT NULL,
  STARTED_IND              NUMBER,
  START_DT_TM              DATE,
  START_DT_NBR             NUMBER,
  START_MIN_NBR            NUMBER,
  START_PRSNL_ID           NUMBER               DEFAULT 0                     NOT NULL,
  START_LOC_FAC_CD         NUMBER               DEFAULT 0                     NOT NULL,
  START_LOC_BLD_CD         NUMBER               DEFAULT 0                     NOT NULL,
  START_LOC_NU_CD          NUMBER               DEFAULT 0                     NOT NULL,
  COMPLETE_IND             NUMBER,
  DISCONTINUED_IND         NUMBER,
  DISCONTINUED_DT_TM       DATE,
  DISCONTINUED_DT_NBR      NUMBER,
  DISCONTINUED_MIN_NBR     NUMBER,
  DC_PRSNL_ID              NUMBER               DEFAULT 0                     NOT NULL,
  DC_LOC_FAC_CD            NUMBER               DEFAULT 0                     NOT NULL,
  DC_LOC_BLD_CD            NUMBER               DEFAULT 0                     NOT NULL,
  DC_LOC_NU_CD             NUMBER               DEFAULT 0                     NOT NULL,
  DC_REASON_CD             NUMBER               DEFAULT 0                     NOT NULL,
  DC_TEXT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  PW_DURATION_MIN_NBR      NUMBER,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  PW_PHASE_DESC            VARCHAR2(200 BYTE),
  TYPE_MEAN                VARCHAR2(12 BYTE),
  DURATION_QTY             NUMBER,
  DURATION_UNIT_CD         NUMBER               DEFAULT 0                     NOT NULL,
  PW_GROUP_NBR             FLOAT(126)           DEFAULT 0                     NOT NULL,
  PW_CAT_GROUP_ID          NUMBER               DEFAULT 0                     NOT NULL,
  PW_GROUP_DESC            VARCHAR2(100 BYTE),
  TF_DESC                  VARCHAR2(100 BYTE),
  ACT_TIME_FRAME_ID        NUMBER               DEFAULT 0                     NOT NULL,
  CALC_END_DT_TM           DATE,
  CALC_END_MIN_NBR         NUMBER,
  ACTUAL_DURATION_MIN_NBR  NUMBER,
  DURATION_DELTA_MIN_NBR   NUMBER,
  CALC_END_DT_NBR          NUMBER,
  PATHWAY_TYPE_CD          NUMBER               DEFAULT 0                     NOT NULL,
  PATHWAY_CLASS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  REF_OWNER_PERSON_ID      NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_PW_FOCUS_ST
(
  FOCUS_ID            NUMBER                    DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  PATHWAY_ID          NUMBER                    DEFAULT 0                     NOT NULL,
  PATHWAY_LEVEL_IND   NUMBER                    DEFAULT 0                     NOT NULL,
  DESCRIPTION         VARCHAR2(255 BYTE)        DEFAULT ' '                   NOT NULL,
  SEQUENCE            NUMBER                    DEFAULT 0                     NOT NULL,
  STATUS_CD           NUMBER                    DEFAULT 0                     NOT NULL,
  STATUS_DT_TM        DATE                      DEFAULT SYSDATE               NOT NULL,
  STATUS_DT_NBR       NUMBER                    DEFAULT 0                     NOT NULL,
  STATUS_MIN_NBR      NUMBER                    DEFAULT 0                     NOT NULL,
  STATUS_PRSNL_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  POTENTIAL_DT_TM     DATE,
  POTENTIAL_DT_NBR    NUMBER,
  POTENTIAL_MIN_NBR   NUMBER,
  POTENTIAL_CNT       NUMBER                    DEFAULT 0                     NOT NULL,
  POTENTIAL_PRSNL_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  PRESENT_DT_TM       DATE,
  PRESENT_DT_NBR      NUMBER,
  PRESENT_MIN_NBR     NUMBER,
  PRESENT_CNT         NUMBER                    DEFAULT 0                     NOT NULL,
  PRESENT_PRSNL_ID    NUMBER                    DEFAULT 0                     NOT NULL,
  RESOLVED_DT_TM      DATE,
  RESOLVED_DT_NBR     NUMBER,
  RESOLVED_MIN_NBR    NUMBER,
  RESOLVED_CNT        NUMBER                    DEFAULT 0                     NOT NULL,
  RESOLVED_PRSNL_ID   NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_PW_ORDER_ST
(
  PW_ORD_COMP_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_COMP_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  ORD_COMP_DESCRIPTION  VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  PW_ORD_COMP_IND       NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_ID            NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_CATALOG_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  VERSION               NUMBER                  DEFAULT 0                     NOT NULL,
  PW_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  ACT_TIME_FRAME_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  TIME_FRAME_ID         NUMBER                  DEFAULT 0                     NOT NULL,
  TF_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  ACT_CARE_CAT_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  CARE_CATEGORY_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  CC_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  FOCUS_ID              NUMBER                  DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  F_DESCRIPTION         VARCHAR2(255 BYTE)      DEFAULT ' '                   NOT NULL,
  ENCNTR_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  PERSON_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  ORDER_ID              NUMBER                  DEFAULT 0                     NOT NULL,
  ORDER_CATALOG_CD      NUMBER                  DEFAULT 0                     NOT NULL,
  ORDER_SYNONYM_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  ORDER_SEQUENCE        NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_CD             NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_DT_TM          DATE                    DEFAULT SYSDATE               NOT NULL,
  STATUS_DT_NBR         NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_MIN_NBR        NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_PRSNL_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  INCLUDED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  INCLUDED_DT_TM        DATE,
  INCLUDED_DT_NBR       NUMBER,
  INCLUDED_MIN_NBR      NUMBER,
  INCLUDED_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  EXCLUDED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  EXCLUDED_DT_TM        DATE,
  EXCLUDED_DT_NBR       NUMBER,
  EXCLUDED_MIN_NBR      NUMBER,
  EXCLUDED_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  CANCELED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  CANCELED_DT_TM        DATE,
  CANCELED_DT_NBR       NUMBER,
  CANCELED_MIN_NBR      NUMBER,
  CANCELED_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  ACTIVATED_IND         NUMBER                  DEFAULT 0                     NOT NULL,
  ACTIVATED_DT_TM       DATE,
  ACTIVATED_DT_NBR      NUMBER,
  ACTIVATED_MIN_NBR     NUMBER,
  ACTIVATED_PRSNL_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  REQUIRED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  COND_IND              NUMBER                  DEFAULT 0                     NOT NULL,
  COND_EVAL_IND         NUMBER                  DEFAULT 0                     NOT NULL,
  COND_SYS_EVAL_IND     NUMBER                  DEFAULT 0                     NOT NULL,
  COND_EVAL_PRSNL_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  COND_FALSE_IND        NUMBER                  DEFAULT 0                     NOT NULL,
  COND_EVAL_DT_TM       DATE,
  COND_EVAL_DT_NBR      NUMBER,
  COND_EVAL_MIN_NBR     NUMBER,
  ADDED_IND             NUMBER                  DEFAULT 0                     NOT NULL,
  REMOVED_IND           NUMBER                  DEFAULT 0                     NOT NULL,
  DEFAULT_INCL_IND      NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  PW_PHASE_DESC         VARCHAR2(200 BYTE),
  TYPE_MEAN             VARCHAR2(12 BYTE),
  PW_GROUP_NBR          FLOAT(126)              DEFAULT 0                     NOT NULL,
  PW_CAT_GROUP_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  PW_GROUP_DESC         VARCHAR2(100 BYTE),
  CATEGORY_DISPLAY      VARCHAR2(100 BYTE),
  CATEGORY_CD           NUMBER                  DEFAULT 0                     NOT NULL,
  SUB_CATEGORY_DISPLAY  VARCHAR2(100 BYTE),
  SUB_CATEGORY_CD       NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_PW_OUTCOME_ST
(
  PW_OUT_COMP_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_COMP_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  OUT_COMP_DESCRIPTION  VARCHAR2(310 BYTE)      DEFAULT ' '                   NOT NULL,
  PW_OUT_COMP_IND       NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_ID            NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_CATALOG_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  VERSION               NUMBER                  DEFAULT 0                     NOT NULL,
  PW_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  ACT_TIME_FRAME_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  TIME_FRAME_ID         NUMBER                  DEFAULT 0                     NOT NULL,
  TF_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  ACT_CARE_CAT_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  CARE_CATEGORY_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  CC_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  FOCUS_ID              NUMBER                  DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  F_DESCRIPTION         VARCHAR2(255 BYTE)      DEFAULT ' '                   NOT NULL,
  ENCNTR_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  PERSON_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  EVENT_CD              NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_CD             NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_DT_TM          DATE                    DEFAULT SYSDATE               NOT NULL,
  STATUS_DT_NBR         NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_MIN_NBR        NUMBER                  DEFAULT 0                     NOT NULL,
  STATUS_PRSNL_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  INCLUDED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  INCLUDED_DT_TM        DATE,
  INCLUDED_DT_NBR       NUMBER,
  INCLUDED_MIN_NBR      NUMBER,
  INCLUDED_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  EXCLUDED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  EXCLUDED_DT_TM        DATE,
  EXCLUDED_DT_NBR       NUMBER,
  EXCLUDED_MIN_NBR      NUMBER,
  EXCLUDED_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  CANCELED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  CANCELED_DT_TM        DATE,
  CANCELED_DT_NBR       NUMBER,
  CANCELED_MIN_NBR      NUMBER,
  CANCELED_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  ACTIVATED_IND         NUMBER                  DEFAULT 0                     NOT NULL,
  ACTIVATED_DT_TM       DATE,
  ACTIVATED_DT_NBR      NUMBER,
  ACTIVATED_MIN_NBR     NUMBER,
  ACTIVATED_PRSNL_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  REQUIRED_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  START_DT_TM           DATE,
  START_DT_NBR          NUMBER,
  START_MIN_NBR         NUMBER,
  END_DT_TM             DATE,
  END_DT_NBR            NUMBER,
  END_MIN_NBR           NUMBER,
  COND_IND              NUMBER                  DEFAULT 0                     NOT NULL,
  COND_EVAL_IND         NUMBER                  DEFAULT 0                     NOT NULL,
  COND_SYS_EVAL_IND     NUMBER                  DEFAULT 0                     NOT NULL,
  COND_EVAL_PRSNL_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  COND_FALSE_IND        NUMBER                  DEFAULT 0                     NOT NULL,
  COND_EVAL_DT_TM       DATE,
  COND_EVAL_DT_NBR      NUMBER,
  COND_EVAL_MIN_NBR     NUMBER,
  ADDED_IND             NUMBER                  DEFAULT 0                     NOT NULL,
  REMOVED_IND           NUMBER                  DEFAULT 0                     NOT NULL,
  DEFAULT_INCL_IND      NUMBER                  DEFAULT 0                     NOT NULL,
  LAST_MET_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  LAST_NOT_MET_IND      NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  PW_PHASE_DESC         VARCHAR2(200 BYTE),
  TYPE_MEAN             VARCHAR2(12 BYTE),
  PW_GROUP_NBR          FLOAT(126)              DEFAULT 0                     NOT NULL,
  PW_CAT_GROUP_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  PW_GROUP_DESC         VARCHAR2(100 BYTE),
  CATEGORY_DISPLAY      VARCHAR2(100 BYTE),
  CATEGORY_CD           NUMBER                  DEFAULT 0                     NOT NULL,
  SUB_CATEGORY_DISPLAY  VARCHAR2(100 BYTE),
  SUB_CATEGORY_CD       NUMBER                  DEFAULT 0                     NOT NULL,
  OUTCOME_ACTIVITY_ID   NUMBER                  DEFAULT 0                     NOT NULL,
  OUTCOME_CATALOG_ID    NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CN_PW_VARIANCE_ST
(
  PW_VARIANCE_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_ID            NUMBER                  DEFAULT 0                     NOT NULL,
  PATHWAY_CATALOG_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  VERSION               NUMBER                  DEFAULT 0                     NOT NULL,
  PW_DESCRIPTION        VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  PW_ORD_COMP_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  ORD_COMP_REF_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  ORD_COMP_DESCRIPTION  VARCHAR2(100 BYTE),
  ACT_TIME_FRAME_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  TIME_FRAME_ID         NUMBER                  DEFAULT 0                     NOT NULL,
  TF_DESCRIPTION        VARCHAR2(100 BYTE),
  ACT_CARE_CAT_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  CARE_CATEGORY_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  CC_DESCRIPTION        VARCHAR2(100 BYTE),
  PW_OUTCOME_COMP_ID    NUMBER                  DEFAULT 0                     NOT NULL,
  OUT_COMP_REF_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  OUT_COMP_DESCRIPTION  VARCHAR2(100 BYTE),
  VARIANCE_TYPE_CD      NUMBER                  DEFAULT 0                     NOT NULL,
  VARIANCE_DT_TM        DATE                    DEFAULT SYSDATE               NOT NULL,
  VARIANCE_DT_NBR       NUMBER                  DEFAULT 0                     NOT NULL,
  VARIANCE_MIN_NBR      NUMBER                  DEFAULT 0                     NOT NULL,
  VARIANCE_IND          NUMBER                  DEFAULT 0                     NOT NULL,
  REASON_CD             NUMBER                  DEFAULT 0                     NOT NULL,
  REASON_TEXT_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  ACTION_CD             NUMBER                  DEFAULT 0                     NOT NULL,
  ACTION_TEXT_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  VARIANCE_PRSNL_ID     NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CODE_VALUE_LOG_DOMAIN_R
(
  CODE_VALUE_LOG_DOMAIN_R_ID  NUMBER            DEFAULT 0                     NOT NULL,
  CODE_VALUE                  NUMBER            DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID           NUMBER            DEFAULT 0                     NOT NULL,
  DISPLAY                     VARCHAR2(40 BYTE),
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CODING
(
  CODING_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  LENGTH_OF_STAY          NUMBER,
  BIRTH_WEIGHT            NUMBER,
  ASCPAY                  NUMBER,
  COMPLETED_DT_TM         DATE,
  CREATE_DT_TM            DATE,
  CREATE_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD   NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  MERGED_ENCNTR_ID        NUMBER                DEFAULT 0                     NOT NULL,
  SVC_CAT_HIST_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CODING_DT_TM            DATE,
  CODING_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CANCER_CODE_CNT         NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_ID                NUMBER                DEFAULT 0,
  ENCNTR_SLICE_ID         NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CODING_AUDIT
(
  CODING_AUDIT_ID          NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_ID                NUMBER               DEFAULT 0                     NOT NULL,
  SVC_CAT_HIST_ID          NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_SLICE_ID          NUMBER               DEFAULT 0                     NOT NULL,
  CODING_PRSNL_ID          NUMBER               DEFAULT 0                     NOT NULL,
  AUDIT_PRSNL_ID           NUMBER               DEFAULT 0                     NOT NULL,
  CODING_AUDIT_TRIGGER_ID  NUMBER               DEFAULT 0                     NOT NULL,
  TASK_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  OUTCOME_CD               NUMBER               DEFAULT 0                     NOT NULL,
  EXTERNAL_AUDIT_MSG       VARCHAR2(500 BYTE)   DEFAULT ' '                   NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM      DATE,
  END_EFFECTIVE_DT_TM      DATE,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CODING_FLEX_SUMMARY
(
  CODING_FLEX_SUMMARY_ID   NUMBER               DEFAULT 0                     NOT NULL,
  ENCNTR_TYPE_CD           NUMBER               DEFAULT 0                     NOT NULL,
  FINANCIAL_CLASS_CD       NUMBER               DEFAULT 0                     NOT NULL,
  CODING_REPORT_NAME       VARCHAR2(255 BYTE),
  BEG_EFFECTIVE_DT_TM      DATE,
  END_EFFECTIVE_DT_TM      DATE,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  DEFNCY_REPORT_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ELECTRONIC_DOC_IND       NUMBER,
  GROUP_PRINCIPLE_TYPE_CD  NUMBER               DEFAULT 0                     NOT NULL,
  REQUEST_SIGN_IND         NUMBER,
  ORGANIZATION_ID          NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CODING_HIST
(
  CODING_HIST_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  ENCNTR_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  LENGTH_OF_STAY         NUMBER,
  BIRTH_WEIGHT           NUMBER,
  ASCPAY                 NUMBER,
  COMPLETED_DT_TM        DATE,
  CREATE_DT_TM           DATE,
  CREATE_PRSNL_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SYSTEM_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM    DATE,
  END_EFFECTIVE_DT_TM    DATE,
  MERGED_ENCNTR_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  SVC_CAT_HIST_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  CODING_DT_TM           DATE,
  CODING_PRSNL_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  CANCER_CODE_CNT        NUMBER                 DEFAULT 0                     NOT NULL,
  EVENT_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  ENCNTR_SLICE_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  ACTIVE_IND             NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COLLECTION_LETTER
(
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  COLLECTION_GEN_DT_TM    DATE,
  COLLECTION_LETTER_ID    NUMBER                DEFAULT 0                     NOT NULL,
  DUNNING_LEVEL_CD        NUMBER                DEFAULT 0                     NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  LETTER_LINE1            VARCHAR2(80 BYTE),
  LETTER_LINE10           VARCHAR2(80 BYTE),
  LETTER_LINE11           VARCHAR2(80 BYTE),
  LETTER_LINE12           VARCHAR2(80 BYTE),
  LETTER_LINE13           VARCHAR2(80 BYTE),
  LETTER_LINE14           VARCHAR2(80 BYTE),
  LETTER_LINE15           VARCHAR2(80 BYTE),
  LETTER_LINE2            VARCHAR2(80 BYTE),
  LETTER_LINE3            VARCHAR2(80 BYTE),
  LETTER_LINE4            VARCHAR2(80 BYTE),
  LETTER_LINE5            VARCHAR2(80 BYTE),
  LETTER_LINE6            VARCHAR2(80 BYTE),
  LETTER_LINE7            VARCHAR2(80 BYTE),
  LETTER_LINE8            VARCHAR2(80 BYTE),
  LETTER_LINE9            VARCHAR2(80 BYTE),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMMITTEE
(
  COMMITTEE_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  SPONSORING_ORG_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  COMMITTEE_NAME       VARCHAR2(255 BYTE)       DEFAULT ' '                   NOT NULL,
  EMAIL_ADDRESS        VARCHAR2(255 BYTE),
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE                     DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  COMMITTEE_TYPE_CD    NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMMITTEE_MEMBER
(
  COMMITTEE_MEMBER_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  COMMITTEE_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  PERSON_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  ROLE_CD              NUMBER                   DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE                     DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMPLETION_HOLD
(
  COMPLETION_HOLD_ID      NUMBER                DEFAULT 0                     NOT NULL,
  HOLD_TYPE_CD            NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL,
  PROVIDER_ID             NUMBER                DEFAULT 0                     NOT NULL,
  REQUEST_ID              NUMBER                DEFAULT 0                     NOT NULL,
  HOLD_START_DT_TM        DATE,
  HOLD_STOP_DT_TM         DATE,
  HOLD_REASON_CD          NUMBER                DEFAULT 0                     NOT NULL,
  MEDIA_MASTER_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMPONENT
(
  OPTION_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_CD              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMP_FILTER_GROUP
(
  COMP_FILTER_GROUP_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  PERSON_ID             NUMBER                  DEFAULT 0                     NOT NULL,
  FILTER_NAME           VARCHAR2(100 BYTE)      DEFAULT ' '                   NOT NULL,
  COMPONENT_CD          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COMP_FILTER_GROUP_ITEM
(
  COMP_FILTER_GROUP_ITEM_ID  NUMBER             DEFAULT 0                     NOT NULL,
  COMP_FILTER_GROUP_ID       NUMBER             DEFAULT 0                     NOT NULL,
  COMPONENT_FILTER_TYPE_CD   NUMBER             DEFAULT 0                     NOT NULL,
  FILTER_ITEM_VALUE_TXT      VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONCEPT_IDENTIFIER_DTA
(
  CONCEPT_IDENTIFIER_DTA_ID  NUMBER             DEFAULT 0                     NOT NULL,
  CONCEPT_CKI                VARCHAR2(255 BYTE),
  TASK_ASSAY_CD              NUMBER             DEFAULT 0                     NOT NULL,
  SPECIMEN_TYPE_CD           NUMBER             DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD        NUMBER             DEFAULT 0                     NOT NULL,
  CONCEPT_TYPE_FLAG          NUMBER             DEFAULT 0                     NOT NULL,
  IGNORE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID     NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONCEPT_PRSNL_CROSSMAP
(
  CONCEPT_PRSNL_CROSSMAP_ID  NUMBER             DEFAULT 0                     NOT NULL,
  PRSNL_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  MAP_TYPE_MEAN              VARCHAR2(12 BYTE),
  MAP_SCOPE_MEAN             VARCHAR2(12 BYTE),
  SOURCE_CONCEPT_CKI         VARCHAR2(255 BYTE),
  SOURCE_NOMEN_ID            NUMBER             DEFAULT 0                     NOT NULL,
  SOURCE_VOCAB_CD            NUMBER             DEFAULT 0                     NOT NULL,
  TARGET_CONCEPT_CKI         VARCHAR2(255 BYTE),
  TARGET_NOMEN_ID            NUMBER             DEFAULT 0                     NOT NULL,
  TARGET_VOCAB_CD            NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_IND                 NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  PERSON_ID                  NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE,
  END_EFFECTIVE_DT_TM        DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONS_BO_SCHED
(
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CONS_BO_SCHED_ID        NUMBER                DEFAULT 0                     NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  NEXT_BILL_DT_TM         DATE,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  LAST_BILL_DT_TM         DATE,
  PROC_IND                NUMBER,
  STATEMENT_CYCLE_ID      NUMBER                DEFAULT 0                     NOT NULL,
  GUARANTOR_ACCESS_CODE   VARCHAR2(250 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTACT_TEXT
(
  CONTACT_TEXT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BILLING_ENTITY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CONTACT_TYPE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  CONTACT_TEXT            VARCHAR2(250 BYTE)    DEFAULT ' '                   NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTAINER
(
  CONTAINER_ID               NUMBER             DEFAULT 0                     NOT NULL,
  PARENT_CONTAINER_ID        NUMBER             DEFAULT 0                     NOT NULL,
  ADDITIONAL_LABELS          NUMBER,
  LABEL_DT_TM                DATE,
  SPECIMEN_ID                NUMBER             DEFAULT 0                     NOT NULL,
  STORAGE_RACK_CELL_ID       NUMBER             DEFAULT 0                     NOT NULL,
  COLLECTION_LIST_ID         NUMBER             DEFAULT 0                     NOT NULL,
  TRANSFER_LIST_ID           NUMBER             DEFAULT 0                     NOT NULL,
  SPECIMEN_TYPE_CD           NUMBER             DEFAULT 0                     NOT NULL,
  SPEC_CNTNR_CD              NUMBER             DEFAULT 0                     NOT NULL,
  COLL_CLASS_CD              NUMBER             DEFAULT 0                     NOT NULL,
  SPEC_HNDL_CD               NUMBER             DEFAULT 0                     NOT NULL,
  CURRENT_LOCATION_CD        NUMBER             DEFAULT 0                     NOT NULL,
  REMAINING_VOLUME           FLOAT(126),
  VOLUME                     FLOAT(126),
  VOLUME_UNIT                CHAR(15 BYTE),
  DRAWN_DT_TM                DATE,
  DRAWN_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  FIXATIVE_CD                NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  RECEIVED_DT_TM             DATE,
  RECEIVED_ID                NUMBER             DEFAULT 0                     NOT NULL,
  COLLECTION_METHOD_CD       NUMBER             DEFAULT 0                     NOT NULL,
  UNITS_CD                   NUMBER             DEFAULT 0                     NOT NULL,
  ORIGINAL_STORAGE_DT_TM     DATE,
  SUGGESTED_DISCARD_DT_TM    DATE,
  DISCARD_DT_TM              DATE,
  TASK_LOG_ID                NUMBER             DEFAULT 0                     NOT NULL,
  COLL_COMMENT_ID            NUMBER             DEFAULT 0                     NOT NULL,
  ON_ROBOTICS_LINE_FLAG      NUMBER             DEFAULT 0                     NOT NULL,
  INSTR_LOGIN_IND            NUMBER,
  AUTO_PRINT_ALIQUOT_IND     NUMBER,
  STORAGE_STATUS_CD          NUMBER             DEFAULT 0                     NOT NULL,
  DISCARD_REASON_CD          NUMBER             DEFAULT 0,
  COLLECTION_TASK_ELIG_FLAG  NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTAINER_EVENT
(
  CONTAINER_ID               NUMBER             DEFAULT 0                     NOT NULL,
  EVENT_SEQUENCE             NUMBER             DEFAULT 0                     NOT NULL,
  EVENT_TYPE_CD              NUMBER             DEFAULT 0                     NOT NULL,
  SPECIMEN_TYPE_CD           NUMBER             DEFAULT 0                     NOT NULL,
  SPEC_CNTNTR_CD             NUMBER             DEFAULT 0                     NOT NULL,
  COLL_CLASS_CD              NUMBER             DEFAULT 0                     NOT NULL,
  SPEC_HNDL_CD               NUMBER             DEFAULT 0                     NOT NULL,
  CURRENT_LOCATION_CD        NUMBER             DEFAULT 0                     NOT NULL,
  REMAINING_VOLUME           NUMBER,
  VOLUME                     NUMBER,
  VOLUME_UNITS               CHAR(15 BYTE),
  DRAWN_DT_TM                DATE,
  DRAWN_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  LABEL_DT_TM                DATE,
  COLLECTION_LIST_ID         NUMBER             DEFAULT 0                     NOT NULL,
  RECEIVED_DT_TM             DATE,
  RECEIVED_ID                NUMBER             DEFAULT 0                     NOT NULL,
  FIXATIVE_CD                NUMBER             DEFAULT 0                     NOT NULL,
  ADDITIONAL_LABELS          NUMBER,
  PARENT_CONTAINER_ID        NUMBER             DEFAULT 0                     NOT NULL,
  COLLECTION_METHOD_CD       NUMBER             DEFAULT 0                     NOT NULL,
  SPECIMEN_ID                NUMBER             DEFAULT 0                     NOT NULL,
  STORAGE_RACK_CELL_ID       NUMBER             DEFAULT 0                     NOT NULL,
  TRANSFER_LIST_ID           NUMBER             DEFAULT 0                     NOT NULL,
  UNITS_CD                   NUMBER             DEFAULT 0                     NOT NULL,
  TASK_LOG_ID                NUMBER             DEFAULT 0                     NOT NULL,
  ORIGINAL_STORAGE_DT_TM     DATE,
  SUGGESTED_DISCARD_DT_TM    DATE,
  DISCARD_DT_TM              DATE,
  REASON_MISSED_CD           NUMBER             DEFAULT 0                     NOT NULL,
  REASON_MISSED_ID           NUMBER             DEFAULT 0                     NOT NULL,
  REASON_MISSED_DT_TM        DATE,
  COLL_COMMENT_ID            NUMBER             DEFAULT 0                     NOT NULL,
  REMAINING_VOLUME_NBR       FLOAT(126)         DEFAULT 0                     NOT NULL,
  VOLUME_NBR                 FLOAT(126)         DEFAULT 0                     NOT NULL,
  DISCARD_REASON_CD          NUMBER             DEFAULT 0,
  CONVERSATION_ID            NUMBER             DEFAULT 0                     NOT NULL,
  PROCESSING_FLAG            NUMBER             DEFAULT 0                     NOT NULL,
  COLLECTION_TASK_ELIG_FLAG  NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTAINER_ORG_R
(
  CONTAINER_ORG_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CONTAINER_TYPE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  INVENTORY_AREA_CD       NUMBER                DEFAULT 0                     NOT NULL,
  OWNER_AREA_CD           NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTRACT_PROPERTY
(
  CONTRACT_PROPERTY_ID        NUMBER            DEFAULT 0                     NOT NULL,
  CPA_IDENT                   VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  ACTION_NAME                 VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  ACTION_VERSION_TXT          VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  AUTHENTICATION_FLAG         NUMBER            DEFAULT 0                     NOT NULL,
  SERVICE_NAME                VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  PERSIST_DURATION_NBR        NUMBER            DEFAULT 0                     NOT NULL,
  RETRIES_NBR                 NUMBER            DEFAULT 0                     NOT NULL,
  RETRY_INTERVAL_NBR          NUMBER            DEFAULT 0                     NOT NULL,
  SYNC_REPLY_MODE_FLAG        NUMBER            DEFAULT 0                     NOT NULL,
  ACK_REQUESTED_FLAG          NUMBER            DEFAULT 0                     NOT NULL,
  DUPLICATE_ELIMINATION_IND   NUMBER            DEFAULT 0                     NOT NULL,
  ACK_ACTOR1_NAME             VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  ACK_ACTOR2_NAME             VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  SEND_URL                    VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  SLA_IND                     NUMBER            DEFAULT 0                     NOT NULL,
  SCHEMA_LOCATION_TXT         VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE              DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM         DATE              DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM         DATE              DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_IND                  NUMBER            DEFAULT 0                     NOT NULL,
  TIMEOUT_NBR                 NUMBER            DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID             NUMBER            DEFAULT 0                     NOT NULL,
  PARTY_KEY_TXT               VARCHAR2(250 BYTE) DEFAULT ' ' NOT NULL,
  DUPLICATE_ELIMINATION_FLAG  NUMBER            DEFAULT 0,
  PAYLOAD_VER_TXT             VARCHAR2(250 BYTE),
  PAYLOAD_ENCODING_TXT        VARCHAR2(250 BYTE),
  PAYLOAD_STYLE_TXT           VARCHAR2(250 BYTE),
  XLINK_HREF_TXT              VARCHAR2(250 BYTE),
  TO_PARTYID_TXT              VARCHAR2(250 BYTE),
  FROM_PARTYID_TXT            VARCHAR2(250 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTRIBUTING_DEPT
(
  CONTRIBUTING_DEPT_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID       NUMBER                  DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID        NUMBER                  DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM   DATE                    DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM   DATE                    DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  DEPT_CD               NUMBER                  DEFAULT 0                     NOT NULL,
  DEPT_DESC             VARCHAR2(255 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONTRIBUTOR_SYSTEM
(
  CONTRIBUTOR_SYSTEM_CD      NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_IND                 NUMBER,
  ACTIVE_STATUS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM        DATE,
  ACTIVE_STATUS_PRSNL_ID     NUMBER             DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  ORGANIZATION_ID            NUMBER             DEFAULT 0                     NOT NULL,
  LOC_FACILITY_CD            NUMBER             DEFAULT 0                     NOT NULL,
  CONTRIBUTOR_SOURCE_CD      NUMBER             DEFAULT 0                     NOT NULL,
  CONTR_SYS_TYPE_CD          NUMBER             DEFAULT 0                     NOT NULL,
  ACT_CONTRIBUTOR_SYSTEM_CD  NUMBER             DEFAULT 0                     NOT NULL,
  AUTO_COMBINE_IND           NUMBER,
  DISPLAY                    VARCHAR2(40 BYTE),
  ESI_ORG_ALIAS_CD           NUMBER             DEFAULT 0                     NOT NULL,
  PRSNL_PERSON_ID            NUMBER             DEFAULT 0                     NOT NULL,
  SYS_DIRECTION_CD           NUMBER             DEFAULT 0                     NOT NULL,
  ALT_CONTRIB_SRC_CD         NUMBER             DEFAULT 0                     NOT NULL,
  RESULT_ALIAS_IND           NUMBER,
  EVENT_CLASS_SOURCE_FLAG    NUMBER,
  DOC_EVENT_CLASS_CD         NUMBER             DEFAULT 0                     NOT NULL,
  OPF_MATCH_THRESHOLD        VARCHAR2(3 BYTE),
  OPF_REPORT_THRESHOLD       VARCHAR2(3 BYTE),
  MICRO_LIST_REPLACE_FLAG    NUMBER             DEFAULT 0,
  MICRO_MULTI_INTERP_IND     NUMBER             DEFAULT 0,
  TIME_ZONE_FLAG             NUMBER             DEFAULT 0,
  TIME_ZONE                  VARCHAR2(100 BYTE),
  MESSAGE_FORMAT_CD          NUMBER             DEFAULT 0                     NOT NULL,
  GROUPER_HOLD_TIME          NUMBER             DEFAULT 0                     NOT NULL,
  MAX_GROUPER_ORDERS         NUMBER             DEFAULT 0                     NOT NULL,
  GROUPER_MULTI_ORDS_IND     NUMBER             DEFAULT 0                     NOT NULL,
  ESO_SPECIAL_SOURCE_FLAG    NUMBER             DEFAULT 0,
  ESI_SPECIAL_SOURCE_FLAG    NUMBER             DEFAULT 0,
  AOF_ENABLED_IND            NUMBER             DEFAULT 0,
  ESI_LOG_BITMAP             NUMBER             DEFAULT 0,
  LISTENER_ALIAS             VARCHAR2(48 BYTE)  DEFAULT ' ',
  AUTHORIZATION_TYPE_CD      NUMBER             DEFAULT 0,
  AUTHORIZATION_URL          VARCHAR2(255 BYTE) DEFAULT ' ',
  ENHANCED_PROCESSING_CD     NUMBER             DEFAULT 0,
  IO_RESULT_IND              NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONVERT_AUDIT_BEST_MATCH
(
  CONVERT_AUDIT_BEST_MATCH_ID  NUMBER           DEFAULT 0                     NOT NULL,
  CONVERT_AUDIT_SYNONYM_ID     NUMBER           DEFAULT 0                     NOT NULL,
  SYNONYM_ID                   NUMBER           DEFAULT 0                     NOT NULL,
  FORM_CD                      NUMBER           DEFAULT 0                     NOT NULL,
  PER_UNIT_STRENGTH            VARCHAR2(255 BYTE),
  PER_UNIT_STRENGTH_UNIT_CKI   VARCHAR2(255 BYTE),
  TOTAL_VOLUME_DOSE            VARCHAR2(255 BYTE),
  TOTAL_VOLUME_DOSE_UNIT_CKI   VARCHAR2(255 BYTE),
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONVERT_AUDIT_SYNONYM
(
  CONVERT_AUDIT_SYNONYM_ID      NUMBER          DEFAULT 0                     NOT NULL,
  CONVERT_AUDIT_TRANSACTION_ID  NUMBER          DEFAULT 0                     NOT NULL,
  SYNONYM_ID                    NUMBER          DEFAULT 0                     NOT NULL,
  ORDER_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  SUPPLIED_FORM_CD              NUMBER          DEFAULT 0                     NOT NULL,
  INFERRED_FORM_CD              NUMBER          DEFAULT 0                     NOT NULL,
  ROUTE_CD                      NUMBER          DEFAULT 0                     NOT NULL,
  TOTAL_STRENGTH_DOSE           VARCHAR2(255 BYTE),
  TOTAL_STRENGTH_DOSE_UNIT_CKI  VARCHAR2(255 BYTE),
  TOTAL_VOLUME_DOSE             VARCHAR2(255 BYTE),
  TOTAL_VOLUME_DOSE_UNIT_CKI    VARCHAR2(255 BYTE),
  FREETEXT_DOSE_IND             NUMBER          DEFAULT 0                     NOT NULL,
  DOSE_VALIDATION_ERROR_IND     NUMBER          DEFAULT 0                     NOT NULL,
  FORM_VALIDATION_ERROR_IND     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CONVERT_AUDIT_TRANSACTION
(
  CONVERT_AUDIT_TRANSACTION_ID  NUMBER          DEFAULT 0                     NOT NULL,
  PRSNL_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  PPR_CD                        NUMBER          DEFAULT 0                     NOT NULL,
  FACILITY_CD                   NUMBER          DEFAULT 0                     NOT NULL,
  VENUE_FLAG                    NUMBER          DEFAULT 1                     NOT NULL,
  PHARMACY_TYPE_BIT             NUMBER          DEFAULT 0                     NOT NULL,
  RETRIEVE_NO_RX_MASK_IND       NUMBER          DEFAULT 0                     NOT NULL,
  RETRIEVE_PRODUCTS_ONLY_IND    NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COOP_HP_RELTN
(
  COOP_HP_RELTN_ID        NUMBER                DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  SEC_HEALTH_PLAN_ID      NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CORRECTED_PRODUCT
(
  CORRECTION_ID                NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_ID                   NUMBER           DEFAULT 0                     NOT NULL,
  CORRECTION_TYPE_CD           NUMBER           DEFAULT 0                     NOT NULL,
  CORRECTION_REASON_CD         NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_NBR                  VARCHAR2(20 BYTE),
  PRODUCT_SUB_NBR              CHAR(5 BYTE),
  ALTERNATE_NBR                VARCHAR2(20 BYTE),
  PRODUCT_CD                   NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_CAT_CD               NUMBER           DEFAULT 0                     NOT NULL,
  PRODUCT_CLASS_CD             NUMBER           DEFAULT 0                     NOT NULL,
  SUPPLIER_ID                  NUMBER           DEFAULT 0                     NOT NULL,
  RECV_DT_TM                   DATE,
  VOLUME                       NUMBER,
  UNIT_MEAS_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  EXPIRE_DT_TM                 DATE,
  ABO_CD                       NUMBER           DEFAULT 0                     NOT NULL,
  RH_CD                        NUMBER           DEFAULT 0                     NOT NULL,
  SEGMENT_NBR                  VARCHAR2(25 BYTE),
  ORIG_UPDT_CNT                NUMBER,
  ORIG_UPDT_DT_TM              DATE,
  ORIG_UPDT_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  ORIG_UPDT_TASK               NUMBER,
  ORIG_UPDT_APPLCTX            NUMBER,
  CORRECTION_NOTE              VARCHAR2(255 BYTE),
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UNKNOWN_PATIENT_TEXT         VARCHAR2(50 BYTE),
  PRODUCT_EVENT_ID             NUMBER           DEFAULT 0                     NOT NULL,
  EVENT_DT_TM                  DATE,
  REASON_CD                    NUMBER           DEFAULT 0                     NOT NULL,
  AUTOCLAVE_IND                NUMBER,
  DESTRUCTION_METHOD_CD        NUMBER           DEFAULT 0                     NOT NULL,
  DESTRUCTION_ORG_ID           NUMBER           DEFAULT 0                     NOT NULL,
  MANIFEST_NBR                 VARCHAR2(50 BYTE),
  PERSON_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  ENCNTR_ID                    NUMBER           DEFAULT 0                     NOT NULL,
  EXPECTED_USAGE_DT_TM         DATE,
  POOLED_PRODUCT_ID            NUMBER           DEFAULT 0                     NOT NULL,
  CUR_OWNER_AREA_CD            NUMBER           DEFAULT 0                     NOT NULL,
  CUR_INV_AREA_CD              NUMBER           DEFAULT 0                     NOT NULL,
  CORRECTION_FLAG              NUMBER,
  RELATED_CORRECTION_ID        NUMBER           DEFAULT 0                     NOT NULL,
  SUPPLIER_PREFIX              CHAR(5 BYTE),
  BARCODE_NBR                  CHAR(20 BYTE),
  MANUFACTURER_ID              NUMBER           DEFAULT 0                     NOT NULL,
  CUR_AVAIL_QTY                NUMBER           DEFAULT 0,
  CUR_INTL_UNITS               NUMBER           DEFAULT 0,
  DRAWN_DT_TM                  DATE,
  SHIP_COND_CD                 NUMBER           DEFAULT 0                     NOT NULL,
  VIS_INSP_CD                  NUMBER           DEFAULT 0                     NOT NULL,
  FLAG_CHARS                   CHAR(2 BYTE),
  ORIG_LOT_NBR                 VARCHAR2(25 BYTE) DEFAULT ' ',
  DISEASE_CD                   NUMBER           DEFAULT 0,
  DONATION_TYPE_CD             NUMBER           DEFAULT 0,
  DONATED_BY_RELATIVE_IND      NUMBER,
  INTENDED_USE_PRINT_PARM_TXT  VARCHAR2(1 BYTE),
  PRODUCT_TYPE_BARCODE         VARCHAR2(15 BYTE),
  UNITS_PER_VIAL_CNT           NUMBER           DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CORRECTED_SPECIAL_TESTS
(
  CORRECT_SPEC_TESTS_ID    NUMBER               DEFAULT 0                     NOT NULL,
  CORRECTION_ID            NUMBER               DEFAULT 0                     NOT NULL,
  ORIG_SPECIAL_TESTING_ID  NUMBER               DEFAULT 0                     NOT NULL,
  SPECIAL_TESTING_CD       NUMBER               DEFAULT 0                     NOT NULL,
  NEW_SPEC_TEST_IND        NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CORSP_BR_RELTN
(
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVITY_ID             NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  BILL_REC_ID             NUMBER                DEFAULT 0                     NOT NULL,
  BILL_VRSN_NBR           NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_BR_RELTN_ID       NUMBER                DEFAULT 0                     NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CORSP_KEYWORD_RELTN
(
  CORSP_KEYWORD_ID        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVITY_ID             NUMBER                DEFAULT 0                     NOT NULL,
  KEYWORD_TXT             VARCHAR2(50 BYTE),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CORSP_LOG
(
  ACTIVITY_ID             NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_SUB_TYPE_CD       NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_SUBJECT           VARCHAR2(100 BYTE),
  CORSP_DESC              VARCHAR2(250 BYTE),
  STORAGE_TYPE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  STORAGE_LOC             VARCHAR2(100 BYTE),
  ACCT_IND                NUMBER,
  PERSON_IND              NUMBER,
  PRSNL_IND               NUMBER,
  ORGANIZATION_IND        NUMBER,
  HEALTH_PLAN_IND         NUMBER,
  ENCNTR_IND              NUMBER,
  ACTIVITY_IND            NUMBER,
  ACTIVE_IND              NUMBER,
  BILLING_ENTITY_IND      NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_IND               NUMBER,
  CORSP_SUBJECT_KEY       VARCHAR2(250 BYTE),
  SESSION_IND             NUMBER,
  TRANS_IND               NUMBER,
  BATCH_IND               NUMBER,
  BILL_REC_IND            NUMBER,
  CREATED_DT_TM           DATE                  DEFAULT SYSDATE,
  CREATED_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  IMPORTANCE_FLAG         NUMBER,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SUBMITTED_DT_TM         DATE,
  CORSP_STATUS_CD         NUMBER                DEFAULT 0,
  DELIVERED_DT_TM         DATE,
  EXTERNAL_IDENT          VARCHAR2(250 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CORSP_LOG_RELTN
(
  ACCT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVITY_ID             NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  BILL_VRSN_NBR           NUMBER,
  END_EFFECTIVE_DT_TM     DATE,
  KEYWORD_TXT             VARCHAR2(50 BYTE),
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(32 BYTE)     DEFAULT ' '                   NOT NULL,
  PFT_ENCNTR_ID           NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  CORSP_LOG_RELTN_ID      NUMBER                DEFAULT 0                     NOT NULL,
  RECIPIENT_TYPE_CD       NUMBER                DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE COST_CENTER_TRANS_ACCOUNT
(
  COST_CENTER_TRANS_ACCOUNT_ID  NUMBER          DEFAULT 0                     NOT NULL,
  LOCATION_CD                   NUMBER          DEFAULT 0                     NOT NULL,
  TRANS_TYPE_CD                 NUMBER          DEFAULT 0                     NOT NULL,
  TRANS_SUB_TYPE_CD             NUMBER          DEFAULT 0                     NOT NULL,
  TRANS_COST_CENTER_CD          NUMBER          DEFAULT 0                     NOT NULL,
  TRANS_SUB_ACCOUNT_CD          NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  LOGICAL_DOMAIN_ID             NUMBER          DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CREDENTIAL
(
  CREDENTIAL_ID           NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME      VARCHAR2(30 BYTE),
  NOTIFY_TYPE_CD          NUMBER                DEFAULT 0                     NOT NULL,
  NOTIFY_PRSNL_ID         NUMBER                DEFAULT 0                     NOT NULL,
  DISPLAY_SEQ             NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT sysdate               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT sysdate               NOT NULL,
  CREDENTIAL_CD           NUMBER                DEFAULT 0                     NOT NULL,
  CREDENTIAL_TYPE_CD      NUMBER                DEFAULT 0                     NOT NULL,
  STATE_CD                NUMBER                DEFAULT 0                     NOT NULL,
  ID_NUMBER               VARCHAR2(50 BYTE),
  RENEWAL_DT_TM           DATE                  DEFAULT sysdate               NOT NULL,
  VALID_FOR_CD            NUMBER                DEFAULT 0                     NOT NULL,
  NOTIFIED_DT_TM          DATE,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT sysdate               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 1                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT sysdate               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  PRSNL_ID                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CRIMINAL_CHARGES_DISP_R
(
  CRIMINAL_CHARGES_DISP_R_ID  NUMBER            DEFAULT 0                     NOT NULL,
  OUTSTANDING_CHARGES_R_ID    NUMBER            DEFAULT 0                     NOT NULL,
  COURT_DISPOSITION_CD        NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_IND                  NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD            NUMBER            DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM         DATE              DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID      NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_CNT                    NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                  DATE              DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                     NUMBER            DEFAULT 0                     NOT NULL,
  UPDT_TASK                   NUMBER            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CRIMINAL_CHRGS_DISP_HIST
(
  CRIMINAL_CHRGS_DISP_HIST_ID  NUMBER           DEFAULT 0                     NOT NULL,
  CRIMINAL_CHARGES_DISP_R_ID   NUMBER           DEFAULT 0                     NOT NULL,
  COURT_DISPOSITION_CD         NUMBER           DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM          DATE             DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM          DATE             DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CRITIQUE_CODE_ASSIGNMENTS
(
  CRITIQUE_INFO_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  CRITIQUE_TYPE_CD   NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  CRITIQUE_PRSNL_ID  NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CRITIQUE_PRSNL
(
  CRITIQUE_INFO_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  CRITIQUED_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  COMMENTS             VARCHAR2(255 BYTE),
  CRITIQUE_PRSNL_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  CRITIQUE_RELTN_FLAG  NUMBER,
  READ_IND             NUMBER                   DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CROSSMATCH
(
  PRODUCT_EVENT_ID        NUMBER                DEFAULT 0                     NOT NULL,
  PRODUCT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CROSSMATCH_QTY          NUMBER,
  RELEASE_DT_TM           DATE,
  RELEASE_PRSNL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  RELEASE_REASON_CD       NUMBER                DEFAULT 0                     NOT NULL,
  RELEASE_QTY             NUMBER,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  CROSSMATCH_EXP_DT_TM    DATE,
  REINSTATE_REASON_CD     NUMBER                DEFAULT 0                     NOT NULL,
  BB_ID_NBR               VARCHAR2(20 BYTE),
  XM_REASON_CD            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_OUTPUT_DESTINATION
(
  CR_OUTPUT_DESTINATION_ID  NUMBER              DEFAULT 0                     NOT NULL,
  REPORT_REQUEST_ID         NUMBER              DEFAULT 0                     NOT NULL,
  OUTPUT_DEST_CD            NUMBER              DEFAULT 0                     NOT NULL,
  DMS_SERVICE_IDENT         VARCHAR2(110 BYTE),
  DMS_FAX_DISTRIBUTE_DT_TM  DATE,
  DMS_ADHOC_FAX_NUMBER_TXT  VARCHAR2(40 BYTE),
  DISK_LABEL                VARCHAR2(128 BYTE),
  COPIES_NBR                NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  DISTRIBUTED_STATUS_IND    NUMBER              DEFAULT 0                     NOT NULL,
  DISK_TYPE_FLAG            NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_PRINTED_SECTIONS
(
  PRINTED_SECTION_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  REPORT_REQUEST_ID   NUMBER                    DEFAULT 0                     NOT NULL,
  SECTION_ID          NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  CONTENT_TYPE_CD     NUMBER                    DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_REPORT_REQUEST
(
  REPORT_REQUEST_ID             NUMBER          DEFAULT 0                     NOT NULL,
  REQUEST_XML_ID                NUMBER          DEFAULT 0                     NOT NULL,
  SUMMARY_REPORT_XML_ID         NUMBER          DEFAULT 0                     NOT NULL,
  PARENT_REQUEST_ID             NUMBER          DEFAULT 0                     NOT NULL,
  PERSON_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  ENCNTR_ID                     NUMBER          DEFAULT 0                     NOT NULL,
  ACCESSION_NBR                 VARCHAR2(20 BYTE),
  REQUEST_PRSNL_ID              NUMBER          DEFAULT 0                     NOT NULL,
  PROVIDER_PRSNL_ID             NUMBER          DEFAULT 0                     NOT NULL,
  PROVIDER_RELTN_CD             NUMBER          DEFAULT 0                     NOT NULL,
  REQUEST_DT_TM                 DATE            DEFAULT SYSDATE               NOT NULL,
  REQUEST_TYPE_FLAG             NUMBER          DEFAULT 0                     NOT NULL,
  SCOPE_FLAG                    NUMBER          DEFAULT 0                     NOT NULL,
  REPORT_STATUS_CD              NUMBER          DEFAULT 0                     NOT NULL,
  TOTAL_PAGES_NBR               FLOAT(126),
  PROCESSING_TIME               FLOAT(126),
  DISTRIBUTION_ID               NUMBER          DEFAULT 0                     NOT NULL,
  DIST_RUN_TYPE_CD              NUMBER          DEFAULT 0                     NOT NULL,
  DIST_RUN_DT_TM                DATE,
  READER_GROUP                  VARCHAR2(15 BYTE),
  TRIGGER_ID                    NUMBER          DEFAULT 0                     NOT NULL,
  TRIGGER_TYPE                  VARCHAR2(15 BYTE),
  TRIGGER_NAME                  VARCHAR2(100 BYTE),
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  ORDER_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  TEMPLATE_ID                   NUMBER          DEFAULT 0                     NOT NULL,
  DEBUG_ZIP_ID                  NUMBER          DEFAULT 0                     NOT NULL,
  CHART_TRIGGER_ID              NUMBER          DEFAULT 0                     NOT NULL,
  USE_POSTING_DATE_IND          NUMBER          DEFAULT 0,
  SEQUENCE_NBR                  NUMBER,
  COPIES_NBR                    NUMBER,
  ROUTE_STOP_ID                 NUMBER          DEFAULT 0,
  ROUTE_ID                      NUMBER          DEFAULT 0,
  RESULT_STATUS_FLAG            NUMBER          DEFAULT 0,
  END_DT_TM                     DATE,
  BEGIN_DT_TM                   DATE,
  REQUESTING_ROLE_PROFILE       VARCHAR2(255 BYTE),
  DMS_SERVICE_NAME              VARCHAR2(64 BYTE),
  OUTPUT_DEST_CD                NUMBER          DEFAULT 0,
  DESTINATION_VALUE_TXT         VARCHAR2(255 BYTE),
  DESTINATION_TYPE_FLAG         NUMBER          DEFAULT 0,
  REQUESTOR_VALUE_TXT           VARCHAR2(255 BYTE),
  REQUESTOR_TYPE_FLAG           NUMBER          DEFAULT 0,
  RELEASE_COMMENT               VARCHAR2(1000 BYTE),
  RELEASE_REASON_CD             NUMBER          DEFAULT 0,
  PATIENT_CONSENT_RECEIVED_IND  NUMBER          DEFAULT 0,
  DMS_SERVICE_IDENT             VARCHAR2(110 BYTE),
  DMS_FAX_DISTRIBUTE_DT_TM      DATE,
  DMS_ADHOC_FAX_NUMBER_TXT      VARCHAR2(40 BYTE),
  OUTPUT_CONTENT_TYPE_STR       VARCHAR2(255 BYTE),
  DISK_LABEL                    VARCHAR2(128 BYTE),
  DISK_TYPE_FLAG                NUMBER          DEFAULT 0,
  TEMPLATE_VERSION_MODE_FLAG    NUMBER,
  TEMPLATE_VERSION_DT_TM        DATE,
  FILE_NAME                     VARCHAR2(255 BYTE),
  PRSNL_RELTN_ID                NUMBER          DEFAULT 0                     NOT NULL,
  PATIENT_REQUEST_IND           NUMBER          DEFAULT 0,
  OUTPUT_CONTENT_TYPE_CD        NUMBER          DEFAULT 0,
  FILE_MASK                     VARCHAR2(255 BYTE),
  DISK_IDENTIFIER               FLOAT(126)      DEFAULT 0,
  CUSTODIAL_ORG_ID              NUMBER          DEFAULT 0,
  NON_CE_BEGIN_DT_TM            DATE,
  NON_CE_END_DT_TM              DATE,
  SERVER_FULL_NAME              VARCHAR2(250 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_REPORT_REQUEST_ARCHIVE
(
  REPORT_REQUEST_ARCHIVE_ID  NUMBER             DEFAULT 0                     NOT NULL,
  ARCHIVED_DT_TM             DATE,
  ARCHIVED_REPORT_NBR        NUMBER             DEFAULT 0                     NOT NULL,
  LONG_BLOB_ID               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  MIN_REQUEST_DT_TM          DATE               DEFAULT SYSDATE               NOT NULL,
  MAX_REQUEST_DT_TM          DATE               DEFAULT SYSDATE               NOT NULL,
  LOGICAL_DOMAIN_ID          NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_REPORT_REQUEST_ENCNTR
(
  REPORT_REQUEST_ENCNTR_ID  NUMBER              DEFAULT 0                     NOT NULL,
  REPORT_REQUEST_ID         NUMBER              DEFAULT 0                     NOT NULL,
  ENCNTR_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  ENCNTR_SEQ                NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_REPORT_REQUEST_EVENT
(
  REPORT_REQUEST_EVENT_ID  NUMBER               DEFAULT 0                     NOT NULL,
  REPORT_REQUEST_ID        NUMBER               DEFAULT 0                     NOT NULL,
  EVENT_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_REPORT_REQUEST_SECTION
(
  REPORT_REQUEST_SECTION_ID  NUMBER             DEFAULT 0                     NOT NULL,
  REPORT_REQUEST_ID          NUMBER             DEFAULT 0                     NOT NULL,
  SECTION_ID                 NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_REPORT_TEMPLATE
(
  REPORT_TEMPLATE_ID       NUMBER               DEFAULT 0                     NOT NULL,
  TEMPLATE_ID              NUMBER               DEFAULT 0                     NOT NULL,
  TEMPLATE_NAME            VARCHAR2(150 BYTE)   DEFAULT ' '                   NOT NULL,
  BEG_EFFECTIVE_DT_TM      DATE                 DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM      DATE,
  LONG_TEXT_ID             NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 0                     NOT NULL,
  TEMPLATE_NAME_KEY        VARCHAR2(150 BYTE),
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  NAME_IDENT               VARCHAR2(167 BYTE)   DEFAULT ' '                   NOT NULL,
  REPORT_STYLE_PROFILE_ID  NUMBER               DEFAULT 0                     NOT NULL,
  FACESHEET_ID             NUMBER               DEFAULT 0,
  PORTRAIT_WATERMARK_ID    NUMBER               DEFAULT 0,
  LANDSCAPE_WATERMARK_ID   NUMBER               DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_STATIC_REGION_LOC_RELTN
(
  CR_STATIC_REGION_LOC_RELTN_ID  NUMBER         DEFAULT 0                     NOT NULL,
  STATIC_REGION_ID               NUMBER         DEFAULT 0                     NOT NULL,
  LOCATION_CD                    NUMBER         DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM            DATE           DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM            DATE           DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND                     NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_STATIC_REGION_ORG_RELTN
(
  CR_STATIC_REGION_ORG_RELTN_ID  NUMBER         DEFAULT 0                     NOT NULL,
  STATIC_REGION_ID               NUMBER         DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID                NUMBER         DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM            DATE           DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM            DATE           DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ACTIVE_IND                     NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_TEMPLATE_PUBLISH
(
  TEMPLATE_PUBLISH_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  TEMPLATE_ID          NUMBER                   DEFAULT 0                     NOT NULL,
  PUBLISH_DT_TM        DATE                     DEFAULT SYSDATE               NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE,
  ACTIVE_IND           NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID         NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_TEMPLATE_SNAPSHOT
(
  TEMPLATE_SNAPSHOT_ID  NUMBER                  DEFAULT 0                     NOT NULL,
  TEMPLATE_ID           NUMBER                  DEFAULT 0                     NOT NULL,
  SECTION_ID            NUMBER                  DEFAULT 0                     NOT NULL,
  STATIC_REGION_ID      NUMBER                  DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR          NUMBER                  DEFAULT 0                     NOT NULL,
  ACTIVE_IND            NUMBER                  DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM   DATE                    DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM   DATE,
  UPDT_ID               NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_DT_TM            DATE                    DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK             NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX          NUMBER                  DEFAULT 0                     NOT NULL,
  UPDT_CNT              NUMBER                  DEFAULT 0                     NOT NULL,
  PAGE_BREAK_AFTER_IND  NUMBER                  DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CR_XML_DOC_REQUEST
(
  CR_XML_DOC_REQUEST_ID   NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  TRIGGER_DT_TM           DATE                  DEFAULT SYSDATE               NOT NULL,
  SUCCESS_IND             NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSA_USER_AGREEMENT
(
  USER_AGREEMENT_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  POSITION_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  INTERVAL_TYPE_TXT    VARCHAR2(20 BYTE),
  INTERVAL_NBR         NUMBER                   DEFAULT 0                     NOT NULL,
  AGREEMENT_TEXT_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  ACTIVE_IND           NUMBER                   DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM  DATE                     DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM  DATE                     DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSA_USER_AGREEMENT_ACK
(
  USER_AGREEMENT_ACK_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  PERSON_ID              NUMBER                 DEFAULT 0                     NOT NULL,
  USER_AGREEMENT_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  LOGINS_CNT             NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM    DATE                   DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM    DATE                   DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSI_ERROR_LOG
(
  EXLOG_ID                 NUMBER               DEFAULT 0                     NOT NULL,
  INTERFACE_ID             NUMBER               DEFAULT 0                     NOT NULL,
  PFT_CHARGE_ID            NUMBER               DEFAULT 0                     NOT NULL,
  CHARGE_ITEM_ID           NUMBER               DEFAULT 0                     NOT NULL,
  CSI_INTERFACE_CD         NUMBER               DEFAULT 0                     NOT NULL,
  CSI_INTERFACE_REASON_CD  NUMBER               DEFAULT 0                     NOT NULL,
  ERROR_DT_TM              DATE,
  CR_ACCT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  DR_ACCT_ID               NUMBER               DEFAULT 0                     NOT NULL,
  CR_GL_ACCT_ID            NUMBER               DEFAULT 0                     NOT NULL,
  DR_GL_ACCT_ID            NUMBER               DEFAULT 0                     NOT NULL,
  DEPOSIT_ACCT_ID          NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVITY_ID              NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER,
  ACTIVE_STATUS_CD         NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM      DATE,
  ACTIVE_STATUS_PRSNL_ID   NUMBER               DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM      DATE                 DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM      DATE                 DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSM_CAT_SUB_XREF
(
  CSM_CAT_ID        NUMBER                      DEFAULT 0                     NOT NULL,
  CSM_SUB_CAT_ID    NUMBER                      DEFAULT 0                     NOT NULL,
  REQ_TEMPL_ID      NUMBER                      DEFAULT 0                     NOT NULL,
  RESL_TEMPL_ID     NUMBER                      DEFAULT 0                     NOT NULL,
  REQ_SECURITY      NUMBER,
  REQ_AV_FLAG       NUMBER,
  REQ_PURGE_DAYS    NUMBER,
  ACTIVE_IND        NUMBER,
  REQ_MNEMONIC      CHAR(10 BYTE),
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  CSM_CALLBACK_IND  NUMBER,
  REQ_PHONE_FLAG    NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSM_LST_CONTACT
(
  CSM_LST_REC_ID     NUMBER                     DEFAULT 0                     NOT NULL,
  PHONE_ID           NUMBER                     DEFAULT 0                     NOT NULL,
  CSM_PHONE_STAT_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  CSM_LST_DT_TM      DATE                       DEFAULT TO_DATE( '01/01/1900 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  CSM_CONTACT_ID     NUMBER                     DEFAULT 0                     NOT NULL,
  PERSON_ID          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  ACTIVE_IND         NUMBER,
  CONTACT            VARCHAR2(100 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSM_QUEUE_PERS_XREF
(
  CSM_QUEUE_ID  NUMBER                          DEFAULT 0                     NOT NULL,
  PERSON_ID     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM    DATE                            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID       NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_TASK     NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_CNT      NUMBER                          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX  NUMBER                          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSM_Q_ORG_XREF
(
  CSM_QUEUE_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  CSM_ORG_INCL_FLAG  NUMBER,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSM_REQUESTS
(
  CSM_REQ_ID              NUMBER                DEFAULT 0                     NOT NULL,
  CSM_CAT_ID              NUMBER                DEFAULT 0                     NOT NULL,
  CSM_SUB_CAT_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  LOCATION_CD             NUMBER                DEFAULT 0                     NOT NULL,
  STATUS_CD               NUMBER                DEFAULT 0                     NOT NULL,
  CSM_PRIOR_ID            NUMBER                DEFAULT 0                     NOT NULL,
  CSM_ORD_DT_TM           DATE,
  CSM_COMPL_DT_TM         DATE,
  CSM_DUE_DT_TM           DATE,
  CSM_CURRENT_USER        CHAR(50 BYTE),
  CSM_REQ_COM_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CSM_RSLT_COM_ID         NUMBER                DEFAULT 0                     NOT NULL,
  PHONE_ID                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  PROBLEM_REQ_COMMENT_ID  NUMBER                DEFAULT 0                     NOT NULL,
  SELECTED_PHONE_ID       NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CSM_REQUESTS_ARCHIVE
(
  CSM_REQ_ID           NUMBER                   DEFAULT 0                     NOT NULL,
  CSM_CAT_ID           NUMBER                   DEFAULT 0                     NOT NULL,
  CSM_SUB_CAT_ID       NUMBER                   DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID      NUMBER                   DEFAULT 0                     NOT NULL,
  LOCATION_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  PHONE_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  PARENT_ENTITY_NAME   CHAR(32 BYTE),
  PARENT_ENTITY_ID     NUMBER                   DEFAULT 0                     NOT NULL,
  COMPL_PRSNL_ID       NUMBER                   DEFAULT 0                     NOT NULL,
  CSM_PRIOR_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  CONTACT              VARCHAR2(100 BYTE),
  CSM_PHONE_STAT_DESC  CHAR(40 BYTE),
  CSM_ORD_DT_TM        DATE,
  CSM_COMPL_DT_TM      DATE,
  CSM_DUE_DT_TM        DATE,
  PURGED_DT_TM         DATE,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  CSM_AD_HOC_PHONE     CHAR(100 BYTE),
  CSM_AD_HOC_EXT       CHAR(100 BYTE)
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CS_CPP_ERROR_LOG
(
  CS_CPP_ERROR_LOG_ID     NUMBER                DEFAULT 0                     NOT NULL,
  CS_CPP_RULESET_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CS_CPP_RULE_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ERROR_TEXT              VARCHAR2(200 BYTE)    DEFAULT ' '                   NOT NULL,
  ERROR_DT_TM             DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CS_CPP_UNDO
(
  CS_CPP_UNDO_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CS_CPP_RULE_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 1                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CS_CPP_UNDO_DETAIL
(
  CS_CPP_UNDO_DETAIL_ID   NUMBER                DEFAULT 0                     NOT NULL,
  CS_CPP_UNDO_ID          NUMBER                DEFAULT 0                     NOT NULL,
  CHARGE_ITEM_ID          NUMBER                DEFAULT 0                     NOT NULL,
  ORIGINAL_IND            NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 1                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CS_ORG_RELTN
(
  CS_ORG_RELTN_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  CS_ORG_RELTN_TYPE_CD    NUMBER                DEFAULT 0                     NOT NULL,
  KEY1_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  KEY1_ENTITY_NAME        VARCHAR2(200 BYTE),
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_DEFAULT_MILESTONES
(
  CT_DEFAULT_MILESTONES_ID  NUMBER              DEFAULT 0                     NOT NULL,
  DEFAULT_LIST_TYPE_CD      NUMBER              DEFAULT 0                     NOT NULL,
  COMMITTEE_ID              NUMBER              DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR              NUMBER              DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID           NUMBER              DEFAULT 0                     NOT NULL,
  ENTITY_TYPE_FLAG          NUMBER              DEFAULT 0                     NOT NULL,
  ACTIVITY_CD               NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  PROT_ROLE_CD              NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_DOCUMENT
(
  CT_DOCUMENT_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  PROT_AMENDMENT_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  TITLE                  VARCHAR2(40 BYTE)      DEFAULT ' '                   NOT NULL,
  DESCRIPTION            VARCHAR2(255 BYTE),
  DOCUMENT_TYPE_CD       NUMBER                 DEFAULT 0                     NOT NULL,
  BEGIN_EFFECTIVE_DT_TM  DATE                   DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  END_EFFECTIVE_DT_TM    DATE                   DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  PREV_CT_DOCUMENT_ID    NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_DOCUMENT_BLOB
(
  CT_DOCUMENT_BLOB_ID     NUMBER                DEFAULT 0                     NOT NULL,
  CT_DOCUMENT_VERSION_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BLOB_LENGTH             NUMBER                DEFAULT 0                     NOT NULL,
  LONG_BLOB               BLOB,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOB (LONG_BLOB) STORE AS (
  TABLESPACE  D_R_MEDIUM
  ENABLE      STORAGE IN ROW
  CHUNK       8192
  PCTVERSION  5
  CACHE
  LOGGING)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_DOCUMENT_VERSION
(
  CT_DOCUMENT_VERSION_ID       NUMBER           DEFAULT 0                     NOT NULL,
  CT_DOCUMENT_ID               NUMBER           DEFAULT 0                     NOT NULL,
  VERSION_DESCRIPTION          VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  FILE_NAME                    VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  VERSION_NBR                  NUMBER           DEFAULT 0                     NOT NULL,
  BEGIN_EFFECTIVE_DT_TM        DATE             DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  END_EFFECTIVE_DT_TM          DATE             DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_DT_TM                   DATE             DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                      NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_CNT                     NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_TASK                    NUMBER           DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                 NUMBER           DEFAULT 0                     NOT NULL,
  REVISION_ID                  NUMBER           DEFAULT 0                     NOT NULL,
  LONG_BLOB_ID                 NUMBER           DEFAULT 0                     NOT NULL,
  DISPLAY_IND                  NUMBER           DEFAULT 0,
  PRINT_WITH_CONSENT_IND       NUMBER           DEFAULT 0,
  ACTIVE_IND                   NUMBER           DEFAULT 0,
  PREV_CT_DOCUMENT_VERSION_ID  NUMBER           DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_EXCLUDED_CLIENTS
(
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_MILESTONES
(
  CT_MILESTONES_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR       NUMBER                     DEFAULT 0                     NOT NULL,
  COMMITTEE_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  ENTITY_TYPE_FLAG   NUMBER                     DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID    NUMBER                     DEFAULT 0                     NOT NULL,
  ACTIVITY_CD        NUMBER                     DEFAULT 0                     NOT NULL,
  PERFORMED_DT_TM    DATE                       DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  PROT_ROLE_CD       NUMBER                     DEFAULT 0                     NOT NULL,
  PROT_AMENDMENT_ID  NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PRESCREEN_JOB
(
  CT_PRESCREEN_JOB_ID  NUMBER                   DEFAULT 0                     NOT NULL,
  PRSNL_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  JOB_TYPE_FLAG        NUMBER                   DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  JOB_START_DT_TM      DATE                     DEFAULT SYSDATE               NOT NULL,
  JOB_END_DT_TM        DATE                     DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  JOB_STATUS_CD        NUMBER                   DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PROT_AMD_CUSTOM_FLD_VAL
(
  CT_PROT_AMD_CUSTOM_FLD_ID       NUMBER        DEFAULT 0                     NOT NULL,
  PREV_CT_PROT_AMD_CUSTOM_FLD_ID  NUMBER        DEFAULT 0                     NOT NULL,
  PROT_AMENDMENT_ID               NUMBER        DEFAULT 0                     NOT NULL,
  CT_CUSTOM_FIELD_ID              NUMBER        DEFAULT 0                     NOT NULL,
  VALUE_CD                        NUMBER        DEFAULT 0                     NOT NULL,
  VALUE_TEXT                      VARCHAR2(255 BYTE) DEFAULT ' ' NOT NULL,
  VALUE_DT_TM                     DATE          DEFAULT SYSDATE               NOT NULL,
  BEG_EFFECTIVE_DT_TM             DATE          DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM             DATE          DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_ID                         NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                      DATE          DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                       NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                    NUMBER        DEFAULT 0                     NOT NULL,
  UPDT_CNT                        NUMBER        DEFAULT 0                     NOT NULL,
  FIELD_POSITION                  NUMBER        DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PROT_CONFIG_VALUE
(
  CT_PROT_CONFIG_VALUE_ID       NUMBER          DEFAULT 0                     NOT NULL,
  PREV_CT_PROT_CONFIG_VALUE_ID  NUMBER          DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID                NUMBER          DEFAULT 0                     NOT NULL,
  ITEM_CD                       NUMBER          DEFAULT 0                     NOT NULL,
  CONFIG_VALUE_CD               NUMBER          DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM           DATE            DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM           DATE            DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PROT_MILESTONES
(
  CT_PROT_MILESTONES_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID         NUMBER                 DEFAULT 0                     NOT NULL,
  ORGANIZATION_ID        NUMBER                 DEFAULT 0                     NOT NULL,
  COMMITTEE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE_NBR           NUMBER                 DEFAULT 0                     NOT NULL,
  ENTITY_TYPE_FLAG       NUMBER                 DEFAULT 0                     NOT NULL,
  ACTIVITY_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  PERFORMED_DT_TM        DATE                   DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  PROT_ROLE_CD           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PROT_PRESCREEN_JOB_INFO
(
  CT_PROT_PRESCREEN_JOB_INFO_ID  NUMBER         DEFAULT 0                     NOT NULL,
  CT_PRESCREEN_JOB_ID            NUMBER         DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID                 NUMBER         DEFAULT 0                     NOT NULL,
  PT_QUALIFIED_NBR               NUMBER         DEFAULT 0                     NOT NULL,
  COMPLETED_FLAG                 NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PT_AMD_ASSIGNMENT
(
  CT_PT_AMD_ASSIGNMENT_ID        NUMBER         DEFAULT 0                     NOT NULL,
  REG_ID                         NUMBER         DEFAULT 0                     NOT NULL,
  PROT_AMENDMENT_ID              NUMBER         DEFAULT 0                     NOT NULL,
  TRANSFER_CHECKED_AMENDMENT_ID  NUMBER         DEFAULT 0                     NOT NULL,
  ASSIGN_START_DT_TM             DATE           DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  ASSIGN_END_DT_TM               DATE           DEFAULT TO_DATE('01/01/1900 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  BEG_EFFECTIVE_DT_TM            DATE           DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM            DATE           DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PT_PROT_BATCH_LIST
(
  CT_PT_PROT_BATCH_LIST_ID  NUMBER              DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID            NUMBER              DEFAULT 0                     NOT NULL,
  PERSON_ID                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_ID                   NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                DATE                DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                 NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX              NUMBER              DEFAULT 0                     NOT NULL,
  UPDT_CNT                  NUMBER              DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_PT_SETTINGS
(
  CT_PT_SETTINGS_ID        NUMBER               DEFAULT 0                     NOT NULL,
  PERSON_ID                NUMBER               DEFAULT 0                     NOT NULL,
  NOT_INTERESTED_IND       NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_ID                  NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_DT_TM               DATE                 DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX             NUMBER               DEFAULT 0                     NOT NULL,
  UPDT_CNT                 NUMBER               DEFAULT 0                     NOT NULL,
  NOT_INTERESTED_DT_TM     DATE,
  NOT_INTERESTED_PRSNL_ID  NUMBER               DEFAULT 0                     NOT NULL,
  ACTIVE_IND               NUMBER               DEFAULT 1
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_REASON_DELETED
(
  CT_REASON_DEL_ID        NUMBER                DEFAULT 0                     NOT NULL,
  REG_ID                  NUMBER                DEFAULT 0                     NOT NULL,
  DELETION_DT_TM          DATE                  DEFAULT SYSDATE               NOT NULL,
  DELETION_PRSNL_ID       NUMBER                DEFAULT 0                     NOT NULL,
  DELETION_REASON         VARCHAR2(2000 BYTE)   DEFAULT ' '                   NOT NULL,
  PT_ELIG_TRACKING_ID     NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  CONSENT_ID              NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_RN_PROT_CONFIG
(
  CT_RN_PROT_CONFIG_ID       NUMBER             DEFAULT 0                     NOT NULL,
  PREV_CT_RN_PROT_CONFIG_ID  NUMBER             DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID             NUMBER             DEFAULT 0                     NOT NULL,
  SOURCE_FILENAME            VARCHAR2(255 BYTE),
  LONG_TEXT_ID               NUMBER             DEFAULT 0                     NOT NULL,
  CONFIG_INFO                VARCHAR2(4000 BYTE),
  BEG_EFFECTIVE_DT_TM        DATE               DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM        DATE               DEFAULT TO_DATE('12/31/2100 00:00:00','MM/DD/YYYY HH24:MI:SS') NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  RN_PROTOCOL_CD             NUMBER             DEFAULT 0                     NOT NULL,
  STOP_DT_TM                 DATE,
  CONFIG_VERSION_NBR         NUMBER             DEFAULT 0                     NOT NULL,
  DATA_EXTRACT_CAP_FLAG      NUMBER             DEFAULT 0                     NOT NULL,
  PROT_PASSWORD              VARCHAR2(100 BYTE) DEFAULT ' ' NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_RN_PROT_RUN
(
  CT_RN_PROT_RUN_ID  NUMBER                     DEFAULT 0                     NOT NULL,
  PROT_MASTER_ID     NUMBER                     DEFAULT 0                     NOT NULL,
  RUN_GROUP_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  NEXT_RUN_DT_TM     DATE,
  PT_SENT_NBR        NUMBER                     DEFAULT 0                     NOT NULL,
  COMPLETED_FLAG     NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_RN_RUN_ACTIVITY
(
  CT_RN_RUN_ACTIVITY_ID  NUMBER                 DEFAULT 0                     NOT NULL,
  CT_RN_PROT_RUN_ID      NUMBER                 DEFAULT 0                     NOT NULL,
  STATUS_FLAG            NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_RULESET_TIER
(
  CT_RULESET_TIER_ID      NUMBER                DEFAULT 0                     NOT NULL,
  PRIORITY                NUMBER                DEFAULT 0,
  ORGANIZATION_ID         NUMBER                DEFAULT 0                     NOT NULL,
  HEALTH_PLAN_ID          NUMBER                DEFAULT 0                     NOT NULL,
  FIN_CLASS_CD            NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_TYPE_CD          NUMBER                DEFAULT 0                     NOT NULL,
  CT_RULESET_CD           NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  INS_ORG_ID              NUMBER                DEFAULT 0                     NOT NULL,
  EXCLUDE_ENCNTR_TYPE_CD  NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_TYPE_COMMITTEE_RELTN
(
  CT_TYPE_COMMITTEE_ID   NUMBER                 DEFAULT 0                     NOT NULL,
  PARTICIPATION_TYPE_CD  NUMBER                 DEFAULT 0                     NOT NULL,
  COMMITTEE_ID           NUMBER                 DEFAULT 0                     NOT NULL,
  EDIT_IND               NUMBER                 DEFAULT 0                     NOT NULL,
  ACTIVE_IND             NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  REV_VALIDATE_IND       NUMBER                 DEFAULT 0                     NOT NULL,
  AMD_VALIDATE_IND       NUMBER                 DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CT_USER_DOMAIN_INFO
(
  CT_USER_DOMAIN_INFO_ID  NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CT_DOMAIN_INFO_ID       NUMBER                DEFAULT 0                     NOT NULL,
  USER_TOKEN_TXT          VARCHAR2(255 BYTE)    DEFAULT ' '                   NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CUSTOM_PT_LIST
(
  CUSTOM_PT_LIST_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  LIST_NAME               VARCHAR2(100 BYTE),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ),
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CUSTOM_PT_LIST_ENTRY
(
  CUST_PTL_ENTRY_ID       NUMBER                DEFAULT 0                     NOT NULL,
  CUSTOM_PT_LIST_ID       NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  COMMENT_TEXT            VARCHAR2(200 BYTE),
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE                  DEFAULT TO_DATE( '12/31/2100 00:00:00' , 'MM/DD/YYYY HH24:MI:SS' ) NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_ACRONYM
(
  CV_ACRONYM_ID    NUMBER                       DEFAULT 0                     NOT NULL,
  PROVIDER_ID      NUMBER                       DEFAULT 0                     NOT NULL,
  ACRONYM_STR      VARCHAR2(8 BYTE)             DEFAULT ' '                   NOT NULL,
  REPLACEMENT_STR  VARCHAR2(200 BYTE)           DEFAULT ' '                   NOT NULL,
  COLLATION_SEQ    NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_CASE
(
  CV_CASE_ID              NUMBER                DEFAULT 0                     NOT NULL,
  CV_CASE_NBR             NUMBER,
  SOURCE_CD               NUMBER                DEFAULT 0                     NOT NULL,
  SEX_CD                  NUMBER                DEFAULT 0                     NOT NULL,
  PATIENT_TYPE_CD         NUMBER                DEFAULT 0                     NOT NULL,
  AGE                     NUMBER,
  AGE_GROUP_CD            NUMBER                DEFAULT 0                     NOT NULL,
  HOSPITAL_CD             NUMBER                DEFAULT 0                     NOT NULL,
  PAT_ADM_DT_TM           DATE,
  PAT_DISCH_DT_TM         DATE,
  LOS_ADM_DISCH           NUMBER,
  PAT_DISCH_IND           NUMBER,
  PAT_ADM_IND             NUMBER,
  ENCNTR_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PERSON_ID               NUMBER                DEFAULT 0                     NOT NULL,
  DEATH_IND               NUMBER,
  NUM_RFACTOR             NUMBER,
  NUM_PROC                NUMBER,
  NUM_PRESENTN            NUMBER,
  NUM_HISTORY             NUMBER,
  NUM_OOLAB_COMPL         NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  ADMT_DT_NBR             NUMBER                DEFAULT 0,
  DISCH_DT_NBR            NUMBER                DEFAULT 0,
  PROC_DT_NBR             NUMBER                DEFAULT 0,
  LOS_ADM_PROC            NUMBER                DEFAULT 0,
  LOS_PROC_DISCH          NUMBER                DEFAULT 0,
  FORM_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  CHART_DT_TM             DATE,
  CASE_DT_TM              DATE,
  FORM_TYPE_CD            NUMBER                DEFAULT 0,
  FORM_EVENT_ID           NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_CASE_ABSTR_DATA
(
  CASE_ABSTR_DATA_ID      NUMBER                DEFAULT 0                     NOT NULL,
  CV_CASE_ID              NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_VAL              VARCHAR2(255 BYTE),
  RESULT_DT_TM            DATE,
  RESULT_CD               NUMBER                DEFAULT 0                     NOT NULL,
  GROUP_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  RESULT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SOURCE           VARCHAR2(32 BYTE),
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_CASE_DATASET_R
(
  CASE_DATASET_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  DATASET_ID              NUMBER                DEFAULT 0                     NOT NULL,
  CV_CASE_ID              NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  PARTICIPANT_NBR         VARCHAR2(50 BYTE),
  STATUS_CD               NUMBER                DEFAULT 0                     NOT NULL,
  ERROR_MSG               VARCHAR2(255 BYTE),
  REGISTRY_NBR            FLOAT(126)            DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_CASE_FIELD
(
  CASE_FIELD_ID           NUMBER                DEFAULT 0                     NOT NULL,
  CASE_DATASET_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  STATUS_CD               NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  PROCEDURE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  LESION_ID               NUMBER                DEFAULT 0                     NOT NULL,
  ABSTR_DATA_ID           NUMBER                DEFAULT 0                     NOT NULL,
  ABSTR_DATA_NAME         VARCHAR2(20 BYTE),
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  XREF_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_VAL              VARCHAR2(100 BYTE),
  TRANSLATED_VAL          VARCHAR2(100 BYTE),
  LESION_IDX              NUMBER,
  DEV_IDX                 NUMBER
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_CASE_FILE_ROW
(
  CV_CASE_FILE_ROW_ID     NUMBER                DEFAULT 0                     NOT NULL,
  FILE_ID                 FLOAT(126)            DEFAULT 0                     NOT NULL,
  CASE_DATASET_R_ID       NUMBER                DEFAULT 0                     NOT NULL,
  LONG_TEXT_ID            NUMBER                DEFAULT 0                     NOT NULL,
  SEQ                     NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_DEVICE
(
  DEVICE_ID               NUMBER                DEFAULT 0                     NOT NULL,
  LESION_ID               NUMBER                DEFAULT 0                     NOT NULL,
  CV_CASE_ID              NUMBER                DEFAULT 0                     NOT NULL,
  PARENT_EVENT_ID         NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE                  DEFAULT SYSDATE               NOT NULL,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_DEV_ABSTR_DATA
(
  DEV_ABSTR_DATA_ID       NUMBER                DEFAULT 0                     NOT NULL,
  DEVICE_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_VAL              VARCHAR2(255 BYTE),
  RESULT_DT_TM            DATE,
  RESULT_CD               NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SOURCE           VARCHAR2(32 BYTE),
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  GROUP_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_ED_REVIEW
(
  CV_ED_REVIEW_ID     NUMBER                    DEFAULT 0                     NOT NULL,
  ORDER_ID            NUMBER                    DEFAULT 0                     NOT NULL,
  REQUESTOR_PRSNL_ID  NUMBER                    DEFAULT 0                     NOT NULL,
  REQUEST_DT_TM       DATE,
  REVIEWER_PRSNL_ID   NUMBER                    DEFAULT 0                     NOT NULL,
  REVIEW_DT_TM        DATE,
  VALID_UNTIL_DT_TM   DATE,
  UPDT_ID             NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_DT_TM          DATE                      DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK           NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX        NUMBER                    DEFAULT 0                     NOT NULL,
  UPDT_CNT            NUMBER                    DEFAULT 0                     NOT NULL,
  REVIEW_STATUS_CD    NUMBER                    DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_LESION
(
  LESION_ID               NUMBER                DEFAULT 0                     NOT NULL,
  PROCEDURE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  NUM_LES_COMPL           NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 1,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  PARENT_EVENT_ID         NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_LES_ABSTR_DATA
(
  LES_ABSTR_DATA_ID       NUMBER                DEFAULT 0                     NOT NULL,
  LESION_ID               NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_VAL              VARCHAR2(255 BYTE),
  RESULT_DT_TM            DATE,
  RESULT_CD               NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  GROUP_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 1,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  RESULT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SOURCE           VARCHAR2(32 BYTE),
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_PROC
(
  CV_PROC_ID           NUMBER                   DEFAULT 0                     NOT NULL,
  ORDER_ID             NUMBER                   DEFAULT 0                     NOT NULL,
  ACCESSION_ID         NUMBER                   DEFAULT 0                     NOT NULL,
  ACCESSION            VARCHAR2(20 BYTE)        DEFAULT ' '                   NOT NULL,
  CATALOG_CD           NUMBER                   DEFAULT 0                     NOT NULL,
  ORDER_PHYSICIAN_ID   NUMBER                   DEFAULT 0                     NOT NULL,
  REFER_PHYSICIAN_ID   NUMBER                   DEFAULT 0                     NOT NULL,
  PRIM_PHYSICIAN_ID    NUMBER                   DEFAULT 0                     NOT NULL,
  PERSON_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  ENCNTR_ID            NUMBER                   DEFAULT 0                     NOT NULL,
  PROC_STATUS_CD       NUMBER                   DEFAULT 0                     NOT NULL,
  PRIORITY_CD          NUMBER                   DEFAULT 0                     NOT NULL,
  REASON_FOR_PROC      VARCHAR2(255 BYTE),
  GROUP_EVENT_ID       NUMBER                   DEFAULT 0                     NOT NULL,
  SEQUENCE             NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_ID              NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_DT_TM           DATE                     DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK            NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX         NUMBER                   DEFAULT 0                     NOT NULL,
  UPDT_CNT             NUMBER                   DEFAULT 0                     NOT NULL,
  PHYS_GROUP_ID        NUMBER                   DEFAULT 0                     NOT NULL,
  ACTION_DT_TM         DATE,
  REQUEST_DT_TM        DATE,
  ACTIVITY_SUBTYPE_CD  NUMBER                   DEFAULT 0                     NOT NULL,
  ED_REVIEW_IND        NUMBER                   DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_PROCEDURE
(
  PROCEDURE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  CV_CASE_ID              NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  PROC_PHYSIC_ID          NUMBER                DEFAULT 0                     NOT NULL,
  PROC_START_DT_TM        DATE,
  PROC_END_DT_TM          DATE,
  PROC_DUR_MIN            NUMBER,
  PROC_START_MNTH         NUMBER,
  PROC_START_DAY          NUMBER,
  PROC_START_HOUR         NUMBER,
  PROC_COMPLETE_IND       NUMBER,
  LOS_ADM_PROC            NUMBER,
  LOS_PROC_DISCH          NUMBER,
  DEPT_CD                 NUMBER                DEFAULT 0                     NOT NULL,
  DOC_INLAB_DT_TM         DATE,
  DOC_PREP_MIN            NUMBER,
  PAT_DISCH_DT_TM         DATE,
  PAT_DISCH_IND           NUMBER,
  PAT_DEATH_IND           NUMBER,
  PAT_INLAB_MIN           NUMBER,
  PAT_ADM_DT_TM           DATE,
  PAT_ADM_IND             NUMBER,
  NURSE_ID                NUMBER                DEFAULT 0                     NOT NULL,
  PAT_INLAB_DT_TM         DATE,
  PAT_WAIT_MIN            NUMBER,
  PROC_NAME_CD            NUMBER                DEFAULT 0                     NOT NULL,
  NUM_PROC_IND            NUMBER,
  NUM_PROC_COMPL          NUMBER,
  NUM_LESION              NUMBER,
  TOTAL_PROC_COMPL        NUMBER,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_PROC_ABSTR_DATA
(
  PROC_ABSTR_DATA_ID      NUMBER                DEFAULT 0                     NOT NULL,
  PROCEDURE_ID            NUMBER                DEFAULT 0                     NOT NULL,
  EVENT_CD                NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_VAL              VARCHAR2(255 BYTE),
  RESULT_DT_TM            DATE,
  RESULT_CD               NUMBER                DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID         NUMBER                DEFAULT 0                     NOT NULL,
  GROUP_TYPE_CD           NUMBER                DEFAULT 0                     NOT NULL,
  BEG_EFFECTIVE_DT_TM     DATE,
  END_EFFECTIVE_DT_TM     DATE,
  DATA_STATUS_CD          NUMBER                DEFAULT 0                     NOT NULL,
  DATA_STATUS_DT_TM       DATE,
  DATA_STATUS_PRSNL_ID    NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_ID                 NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_DT_TM              DATE                  DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK               NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX            NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_CNT                NUMBER                DEFAULT 0                     NOT NULL,
  UPDT_APP                NUMBER,
  UPDT_REQ                NUMBER,
  ACTIVE_IND              NUMBER                DEFAULT 0,
  ACTIVE_STATUS_CD        NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_PRSNL_ID  NUMBER                DEFAULT 0                     NOT NULL,
  ACTIVE_STATUS_DT_TM     DATE,
  RESULT_ID               NUMBER                DEFAULT 0                     NOT NULL,
  RESULT_SOURCE           VARCHAR2(32 BYTE),
  EVENT_ID                NUMBER                DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_STEP
(
  CV_STEP_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  CV_PROC_ID             NUMBER                 DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD          NUMBER                 DEFAULT 0                     NOT NULL,
  EVENT_ID               NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_ID                NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_DT_TM             DATE                   DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK              NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX           NUMBER                 DEFAULT 0                     NOT NULL,
  UPDT_CNT               NUMBER                 DEFAULT 0                     NOT NULL,
  STEP_STATUS_CD         NUMBER                 DEFAULT 0                     NOT NULL,
  SEQUENCE               NUMBER                 DEFAULT 0                     NOT NULL,
  PERF_PROVIDER_ID       NUMBER                 DEFAULT 0                     NOT NULL,
  PERF_LOC_CD            NUMBER                 DEFAULT 0                     NOT NULL,
  PERF_START_DT_TM       DATE,
  PERF_STOP_DT_TM        DATE,
  LOCK_PRSNL_ID          NUMBER                 DEFAULT 0                     NOT NULL,
  PRELIMINARY_AUTHOR_ID  NUMBER                 DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_STEP_PRSNL
(
  CV_STEP_PRSNL_ID  NUMBER                      DEFAULT 0                     NOT NULL,
  CV_STEP_ID        NUMBER                      DEFAULT 0                     NOT NULL,
  STEP_PRSNL_ID     NUMBER                      DEFAULT 0                     NOT NULL,
  STEP_RELATION_CD  NUMBER                      DEFAULT 0                     NOT NULL,
  ACTION_TYPE_CD    NUMBER                      DEFAULT 0                     NOT NULL,
  ACTION_DT_TM      DATE,
  ACTION_SEQUENCE   NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_ID           NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_DT_TM        DATE                        DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK         NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX      NUMBER                      DEFAULT 0                     NOT NULL,
  UPDT_CNT          NUMBER                      DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CV_STEP_SCHED
(
  CV_STEP_SCHED_ID   NUMBER                     DEFAULT 0                     NOT NULL,
  CV_STEP_ID         NUMBER                     DEFAULT 0                     NOT NULL,
  CV_PROC_ID         NUMBER                     DEFAULT 0                     NOT NULL,
  TASK_ASSAY_CD      NUMBER                     DEFAULT 0                     NOT NULL,
  ARRIVE_DT_TM       DATE,
  ARRIVE_IND         NUMBER                     DEFAULT 0                     NOT NULL,
  SCHED_LOC_CD       NUMBER                     DEFAULT 0                     NOT NULL,
  SCHED_PHYS_ID      NUMBER                     DEFAULT 0                     NOT NULL,
  SCHED_START_DT_TM  DATE,
  SCHED_STOP_DT_TM   DATE,
  PERF_LOC_CD        NUMBER                     DEFAULT 0                     NOT NULL,
  PERF_PHYS_ID       NUMBER                     DEFAULT 0                     NOT NULL,
  PERF_START_DT_TM   DATE,
  PERF_STOP_DT_TM    DATE,
  UPDT_ID            NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_DT_TM         DATE                       DEFAULT SYSDATE               NOT NULL,
  UPDT_TASK          NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX       NUMBER                     DEFAULT 0                     NOT NULL,
  UPDT_CNT           NUMBER                     DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_ALPHA_SECURITY
(
  REFERENCE_RANGE_FACTOR_ID      NUMBER         DEFAULT 0                     NOT NULL,
  NOMENCLATURE_ID                NUMBER         DEFAULT 0                     NOT NULL,
  DIAGNOSTIC_CATEGORY_CD         NUMBER         DEFAULT 0                     NOT NULL,
  DEGREES_FROM_NORMAL            NUMBER,
  WORKLOAD_CD                    NUMBER         DEFAULT 0                     NOT NULL,
  REQUEUE_FLAG                   NUMBER,
  REQUEUE_SERVICE_RESOURCE_CD    NUMBER         DEFAULT 0                     NOT NULL,
  VERIFY_LEVEL_IS                NUMBER,
  VERIFY_LEVEL_RS                NUMBER,
  QA_FLAG_TYPE_CD                NUMBER         DEFAULT 0                     NOT NULL,
  FOLLOWUP_TRACKING_TYPE_CD      NUMBER         DEFAULT 0                     NOT NULL,
  FOLLOWUP_INITIAL_INTERVAL      NUMBER,
  FOLLOWUP_FIRST_INTERVAL        NUMBER,
  FOLLOWUP_FINAL_INTERVAL        NUMBER,
  FOLLOWUP_TERMINATION_INTERVAL  NUMBER,
  UPDT_CNT                       NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                     DATE           DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                        NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_TASK                      NUMBER         DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                   NUMBER         DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD            NUMBER         DEFAULT 0,
  DEFINITION_IND                 NUMBER         DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_SCREENING_EVENT
(
  CASE_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  SEQUENCE                   NUMBER             DEFAULT 0                     NOT NULL,
  SCREENER_ID                NUMBER             DEFAULT 0                     NOT NULL,
  SCREEN_DT_TM               DATE,
  INITIAL_SCREENER_IND       NUMBER,
  REFERENCE_RANGE_FACTOR_ID  NUMBER             DEFAULT 0                     NOT NULL,
  ENDOCERV_IND               NUMBER,
  ADEQUACY_FLAG              NUMBER,
  STANDARD_RPT_ID            NUMBER             DEFAULT 0                     NOT NULL,
  EVENT_ID                   NUMBER             DEFAULT 0                     NOT NULL,
  VALID_FROM_DT_TM           DATE,
  NOMENCLATURE_ID            NUMBER             DEFAULT 0                     NOT NULL,
  VERIFY_IND                 NUMBER,
  REVIEW_REASON_FLAG         NUMBER,
  ACTIVE_IND                 NUMBER,
  DIAGNOSTIC_CATEGORY_CD     NUMBER             DEFAULT 0                     NOT NULL,
  ACTION_FLAG                NUMBER,
  SPLIT_IND                  NUMBER,
  SPECIMEN_GROUPING_CD       NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_CNT                   NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                 DATE               DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                    NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_TASK                  NUMBER             DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX               NUMBER             DEFAULT 0                     NOT NULL,
  SERVICE_RESOURCE_CD        NUMBER             DEFAULT 0
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_SCREENING_LIMITS
(
  PRSNL_ID         NUMBER                       DEFAULT 0                     NOT NULL,
  SEQUENCE         NUMBER                       DEFAULT 0                     NOT NULL,
  SLIDE_LIMIT      NUMBER                       DEFAULT 0,
  SCREENING_HOURS  NUMBER                       DEFAULT 0,
  REVIEWER_ID      NUMBER                       DEFAULT 0                     NOT NULL,
  REVIEWED_DT_TM   DATE,
  COMMENTS         VARCHAR2(200 BYTE),
  ACTIVE_IND       NUMBER                       DEFAULT 0,
  UPDT_CNT         NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_DT_TM       DATE                         DEFAULT SYSDATE               NOT NULL,
  UPDT_ID          NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_TASK        NUMBER                       DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX     NUMBER                       DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE CYTO_SCREENING_SECURITY
(
  PRSNL_ID                      NUMBER          DEFAULT 0                     NOT NULL,
  SEQUENCE                      NUMBER          DEFAULT 0                     NOT NULL,
  NORMAL_PERCENTAGE             NUMBER,
  ABNORMAL_PERCENTAGE           NUMBER,
  CHR_PERCENTAGE                NUMBER,
  ATYPICAL_PERCENTAGE           NUMBER,
  VERIFY_LEVEL                  NUMBER,
  REVIEWER_ID                   NUMBER          DEFAULT 0                     NOT NULL,
  REVIEWED_DT_TM                DATE,
  COMMENTS                      VARCHAR2(200 BYTE),
  ACTIVE_IND                    NUMBER,
  AUTO_OVERSCREENER_IND         NUMBER,
  OVER_REQUEUE_FLAG             NUMBER,
  OVER_SERVICE_RESOURCE_CD      NUMBER          DEFAULT 0                     NOT NULL,
  NORMAL_REQUEUE_FLAG           NUMBER,
  NORMAL_SERVICE_RESOURCE_CD    NUMBER          DEFAULT 0                     NOT NULL,
  CHR_REQUEUE_FLAG              NUMBER,
  CHR_SERVICE_RESOURCE_CD       NUMBER          DEFAULT 0                     NOT NULL,
  ATYPICAL_REQUEUE_FLAG         NUMBER,
  ATYPICAL_SERVICE_RESOURCE_CD  NUMBER          DEFAULT 0                     NOT NULL,
  ABNORMAL_REQUEUE_FLAG         NUMBER,
  ABNORMAL_SERVICE_RESOURCE_CD  NUMBER          DEFAULT 0                     NOT NULL,
  UNSAT_PERCENTAGE              NUMBER,
  UNSAT_REQUEUE_FLAG            NUMBER,
  UNSAT_SERVICE_RESOURCE_CD     NUMBER          DEFAULT 0                     NOT NULL,
  NORMAL_REQUEUE_RANK           NUMBER,
  ABNORMAL_REQUEUE_RANK         NUMBER,
  ATYPICAL_REQUEUE_RANK         NUMBER,
  CHR_REQUEUE_RANK              NUMBER,
  UPDT_CNT                      NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_DT_TM                    DATE            DEFAULT SYSDATE               NOT NULL,
  UPDT_ID                       NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_TASK                     NUMBER          DEFAULT 0                     NOT NULL,
  UPDT_APPLCTX                  NUMBER          DEFAULT 0                     NOT NULL
)
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE TABLE DAILY_ACCT_BAL
(
 