/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.sequencers.InvalidSequencerPathExpression;

@Immutable
public class SequencerPathExpression
implements Serializable {
    private static final long serialVersionUID = 229464314137494765L;
    private static final Pattern TWO_PART_PATTERN = Pattern.compile("((?:[^=]|=(?!>))+)(?:=>(.+))?");
    protected static final String DEFAULT_OUTPUT_EXPRESSION = ".";
    private static final String REPLACEMENT_VARIABLE_PATTERN_STRING = "(?<!\\\\)\\$(\\d+)";
    private static final Pattern REPLACEMENT_VARIABLE_PATTERN = Pattern.compile("(?<!\\\\)\\$(\\d+)");
    private static final String PARENT_PATTERN_STRING = "[^/]+/\\.\\./";
    private static final Pattern PARENT_PATTERN = Pattern.compile("[^/]+/\\.\\./");
    private static final String SEQUENCE_PATTERN_STRING = "\\[(\\d+(?:,\\d+)*)\\]";
    private static final Pattern SEQUENCE_PATTERN = Pattern.compile("\\[(\\d+(?:,\\d+)*)\\]");
    private static final String UNUSABLE_PREDICATE_PATTERN_STRING = "\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(?:\\[[^\\]\\+\\-\\*=\\!><'\"\\s]+\\])$|(\\[[^\\]]+\\])";
    private static final Pattern UNUSABLE_PREDICATE_PATTERN = Pattern.compile("\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(?:\\[[^\\]\\+\\-\\*=\\!><'\"\\s]+\\])$|(\\[[^\\]]+\\])");
    private static final String NON_INDEX_PREDICATE_PATTERN_STRING = "\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(\\[[^\\]]+\\])";
    private static final Pattern NON_INDEX_PREDICATE_PATTERN = Pattern.compile("\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(\\[[^\\]]+\\])");
    private final String selectExpression;
    private final String outputExpression;
    private final Pattern matchPattern;
    private final Pattern selectPattern;
    private final int hc;

    public static final SequencerPathExpression compile(String expression) throws InvalidSequencerPathExpression {
        ArgCheck.isNotNull((Object)expression, (String)"sequencer path expression");
        expression = expression.trim();
        if (expression.length() == 0) {
            throw new InvalidSequencerPathExpression(RepositoryI18n.pathExpressionMayNotBeBlank.text(new Object[0]));
        }
        java.util.regex.Matcher matcher = TWO_PART_PATTERN.matcher(expression);
        if (!matcher.matches()) {
            throw new InvalidSequencerPathExpression(RepositoryI18n.pathExpressionIsInvalid.text(new Object[]{expression}));
        }
        String selectExpression = matcher.group(1);
        String outputExpression = matcher.group(2);
        return new SequencerPathExpression(selectExpression, outputExpression);
    }

    protected SequencerPathExpression(String selectExpression, String outputExpression) throws InvalidSequencerPathExpression {
        ArgCheck.isNotNull((Object)selectExpression, (String)"select expression");
        this.selectExpression = selectExpression.trim();
        this.outputExpression = outputExpression != null ? outputExpression.trim() : DEFAULT_OUTPUT_EXPRESSION;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectExpression, this.outputExpression});
        String matchString = this.selectExpression;
        try {
            matchString = this.removeUnusedPredicates(matchString);
            matchString = this.replaceXPathPatterns(matchString);
            this.matchPattern = Pattern.compile(matchString, 2);
        }
        catch (PatternSyntaxException e) {
            String msg = RepositoryI18n.pathExpressionHasInvalidMatch.text(new Object[]{matchString, this.selectExpression, this.outputExpression});
            throw new InvalidSequencerPathExpression(msg, e);
        }
        String selectString = this.selectExpression.trim();
        try {
            selectString = this.removeAllPredicatesExceptIndexes(selectString);
            selectString = this.replaceXPathPatterns(selectString);
            selectString = "(" + selectString + ").*";
            this.selectPattern = Pattern.compile(selectString, 2);
        }
        catch (PatternSyntaxException e) {
            String msg = RepositoryI18n.pathExpressionHasInvalidSelect.text(new Object[]{selectString, this.selectExpression, this.outputExpression});
            throw new InvalidSequencerPathExpression(msg, e);
        }
    }

    protected String removeUnusedPredicates(String expression) {
        assert (expression != null);
        java.util.regex.Matcher matcher = UNUSABLE_PREDICATE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            do {
                String predicateStr = matcher.group(0);
                String unusablePredicateStr = matcher.group(1);
                if (unusablePredicateStr != null) {
                    predicateStr = "";
                }
                matcher.appendReplacement(sb, predicateStr);
            } while (matcher.find());
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        return expression;
    }

    protected String removeAllPredicatesExceptIndexes(String expression) {
        assert (expression != null);
        java.util.regex.Matcher matcher = NON_INDEX_PREDICATE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            do {
                String predicateStr = matcher.group(0);
                String unusablePredicateStr = matcher.group(1);
                if (unusablePredicateStr != null) {
                    predicateStr = "";
                }
                matcher.appendReplacement(sb, predicateStr);
            } while (matcher.find());
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        return expression;
    }

    protected String replaceXPathPatterns(String expression) {
        assert (expression != null);
        expression = expression.replaceAll("[\\|]{2,}", "|");
        expression = expression.replaceAll("/(\\([^|]+)(\\|){2,}([^)]+\\))", "(/$1$2$3)?");
        expression = expression.replaceAll("/\\(\\|+([^)]+)\\)", "(/($1))?");
        expression = expression.replaceAll("/\\((([^|]+)(\\|[^|]+)*)\\|+\\)", "(/($1))?");
        expression = expression.replaceAll("\\[\\]", "(?:\\\\[\\\\d+\\\\])?");
        expression = expression.replaceAll("\\[[*]\\]", "(?:\\\\[\\\\d+\\\\])?");
        expression = expression.replaceAll("\\[0\\]", "(?:\\\\[0\\\\])?");
        expression = expression.replaceAll("\\[([1-9]\\d*)\\]", "\\\\[$1\\\\]");
        expression = expression.replaceAll("(?<!\\\\)\\[([^\\]]*)\\]$", "/$1");
        java.util.regex.Matcher matcher = SEQUENCE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        if (result) {
            do {
                String sequenceStr = matcher.group(1);
                boolean optional = false;
                if (sequenceStr.startsWith("0,")) {
                    sequenceStr = sequenceStr.replaceFirst("^0,", "");
                    optional = true;
                }
                if (sequenceStr.endsWith(",0")) {
                    sequenceStr = sequenceStr.replaceFirst(",0$", "");
                    optional = true;
                }
                if (sequenceStr.contains(",0,")) {
                    sequenceStr = sequenceStr.replaceAll(",0,", ",");
                    optional = true;
                }
                sequenceStr = sequenceStr.replaceAll(",", "|");
                String replacement = "\\\\[(?:" + sequenceStr + ")\\\\]";
                if (optional) {
                    replacement = "(?:" + replacement + ")?";
                }
                matcher.appendReplacement(sb, replacement);
            } while (result = matcher.find());
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        expression = expression.replaceAll("[*]([^/])", "[^/$1]*$1");
        expression = expression.replaceAll("(?<!\\[\\^/\\])[*]", "[^/]*");
        expression = expression.replaceAll("[/]{2,}", "(?:/[^/]*)*/");
        return expression;
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public String getOutputExpression() {
        return this.outputExpression;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SequencerPathExpression) {
            SequencerPathExpression that = (SequencerPathExpression)obj;
            if (!this.selectExpression.equalsIgnoreCase(that.selectExpression)) {
                return false;
            }
            return this.outputExpression.equalsIgnoreCase(that.outputExpression);
        }
        return false;
    }

    public String toString() {
        return this.selectExpression + "=>" + this.outputExpression;
    }

    public Matcher matcher(String absolutePath) {
        String originalAbsolutePath = absolutePath;
        java.util.regex.Matcher matcher = this.matchPattern.matcher(absolutePath = absolutePath.replaceAll("/+$", ""));
        if (!matcher.matches()) {
            return new Matcher(originalAbsolutePath, null, null);
        }
        HashMap<Integer, String> replacements = new HashMap<Integer, String>();
        int count = matcher.groupCount();
        for (int i = 0; i <= count; ++i) {
            replacements.put(i, matcher.group(i));
        }
        java.util.regex.Matcher selectMatcher = this.selectPattern.matcher(absolutePath);
        if (!selectMatcher.matches()) {
            return new Matcher(originalAbsolutePath, null, null);
        }
        String selectedPath = selectMatcher.group(1);
        selectedPath = selectedPath.replaceAll("/@[^/\\[\\]]+$", "");
        String outputPath = this.outputExpression;
        if (!DEFAULT_OUTPUT_EXPRESSION.equals(outputPath)) {
            java.util.regex.Matcher replacementMatcher = REPLACEMENT_VARIABLE_PATTERN.matcher(outputPath);
            StringBuffer sb = new StringBuffer();
            if (replacementMatcher.find()) {
                do {
                    String variable;
                    String replacement;
                    if ((replacement = (String)replacements.get(Integer.valueOf(variable = replacementMatcher.group(1)))) == null) {
                        replacement = replacementMatcher.group(0);
                    }
                    replacementMatcher.appendReplacement(sb, replacement);
                } while (replacementMatcher.find());
                replacementMatcher.appendTail(sb);
                outputPath = sb.toString();
            }
            if (!outputPath.endsWith("/")) {
                outputPath = outputPath + "/";
            }
            outputPath = outputPath.replaceAll("/\\./", "/");
            java.util.regex.Matcher parentMatcher = PARENT_PATTERN.matcher(outputPath);
            while (parentMatcher.find()) {
                outputPath = parentMatcher.replaceAll("");
                if (!outputPath.endsWith("/")) {
                    outputPath = outputPath + "/";
                }
                parentMatcher = PARENT_PATTERN.matcher(outputPath);
            }
            outputPath = outputPath.replaceAll("/{2,}", "/");
            outputPath = outputPath.replaceAll("/@[^/\\[\\]]+$", "");
            if ((outputPath = outputPath.replaceAll("/$", "")).length() == 0) {
                outputPath = DEFAULT_OUTPUT_EXPRESSION;
            }
        }
        if (DEFAULT_OUTPUT_EXPRESSION.equals(outputPath)) {
            outputPath = selectedPath;
        }
        return new Matcher(originalAbsolutePath, selectedPath, outputPath);
    }

    @Immutable
    public static class Matcher {
        private final String inputPath;
        private final String selectedPath;
        private final String outputPath;
        private final int hc;

        protected Matcher(String inputPath, String selectedPath, String outputPath) {
            this.inputPath = inputPath;
            this.selectedPath = selectedPath;
            this.outputPath = outputPath;
            this.hc = HashCode.compute((Object[])new Object[]{this.inputPath, this.selectedPath, this.outputPath});
        }

        public boolean matches() {
            return this.selectedPath != null && this.outputPath != null;
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public String getSelectedPath() {
            return this.selectedPath;
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Matcher) {
                Matcher that = (Matcher)obj;
                if (!this.inputPath.equalsIgnoreCase(that.inputPath)) {
                    return false;
                }
                if (!this.selectedPath.equalsIgnoreCase(that.selectedPath)) {
                    return false;
                }
                return this.outputPath.equalsIgnoreCase(that.outputPath);
            }
            return false;
        }

        public String toString() {
            return this.selectedPath + " => " + this.outputPath;
        }
    }
}

