/*
 * ModeShape (http://www.modeshape.org)
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * See the AUTHORS.txt file in the distribution for a full listing of
 * individual contributors.
 *
 * ModeShape is free software. Unless otherwise indicated, all code in ModeShape
 * is licensed to you under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * ModeShape is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

/**
 *  {@link SimpleResourceDefinition} which handles <file-binary-storage/> elements
 */
public class ModeShapeFileBinaryStorageResource extends SimpleResourceDefinition {
    protected static final ModeShapeFileBinaryStorageResource DEFAULT =  new ModeShapeFileBinaryStorageResource(PathElement.pathElement(ModelKeys.STORAGE_TYPE,
                                                                                                                                        ModelKeys.FILE_BINARY_STORAGE));
    protected static final ModeShapeFileBinaryStorageResource NESTED =  new ModeShapeFileBinaryStorageResource(PathElement.pathElement(ModelKeys.NESTED_STORAGE_TYPE_FILE,
                                                                                                                                       PathElement.WILDCARD_VALUE));
    private ModeShapeFileBinaryStorageResource(PathElement path) {
        super(path,
              ModeShapeExtension.getResourceDescriptionResolver(ModelKeys.REPOSITORY, ModelKeys.FILE_BINARY_STORAGE),
              AddFileBinaryStorage.INSTANCE, RemoveBinaryStorage.INSTANCE);
    }

    @Override
    public void registerAttributes( ManagementResourceRegistration resourceRegistration ) {
        BinaryStorageWriteAttributeHandler.FILE_BINARY_STORAGE_INSTANCE.registerAttributes(resourceRegistration);
    }

}
