/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.Comparator;
import org.jboss.as.console.client.teiid.model.KeyValuePair;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.model.VDBTranslator;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBTranslatorsTab
extends VDBProvider {
    private VDBPresenter presenter;

    public VDBTranslatorsTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        final Form form = new Form(VDBTranslator.class);
        final ListDataProvider translatorProvider = new ListDataProvider();
        final ListDataProvider propertyProvider = new ListDataProvider();
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(translatorProvider.getList());
        final DefaultCellTable<VDBTranslator> translatorsTable = this.getTranslatorsTable((ColumnSortEvent.ListHandler<VDBTranslator>)sortHandler);
        translatorProvider.addDataDisplay(translatorsTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB selection) {
                if (selection != null && !selection.getOverrideTranslators().isEmpty()) {
                    translatorProvider.getList().clear();
                    translatorProvider.getList().addAll(selection.getOverrideTranslators());
                    translatorsTable.getSelectionModel().setSelected((Object)selection.getOverrideTranslators().get(0), true);
                    VDBTranslator selected = (VDBTranslator)translatorsTable.getPreviousSelectedEntity();
                    if (selected != null) {
                        propertyProvider.getList().clear();
                        propertyProvider.getList().addAll(selected.getProperties());
                    }
                } else {
                    translatorProvider.getList().clear();
                    propertyProvider.getList().clear();
                    form.clearValues();
                }
            }
        });
        DefaultPager translatorsTablePager = new DefaultPager();
        translatorsTablePager.setDisplay(translatorsTable);
        form.setNumColumns(1);
        form.setEnabled(false);
        TextItem descriptionLabel = new TextItem("description", "Description");
        form.setFields(new FormItem[]{descriptionLabel});
        form.bind(translatorsTable);
        Label propertiesLabel = new Label("Properties");
        propertiesLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        DefaultCellTable<KeyValuePair> propertiesTable = VDBView.buildPropertiesTable();
        propertyProvider.addDataDisplay(propertiesTable);
        VDBView.onTableSectionChange(translatorsTable, new VDBView.TableSelectionCallback<VDBTranslator>(){

            @Override
            public void onSelectionChange(VDBTranslator translator) {
                propertyProvider.getList().clear();
                propertyProvider.getList().addAll(translator.getProperties());
            }
        });
        DefaultPager propertiesTablePager = new DefaultPager();
        propertiesTablePager.setDisplay(propertiesTable);
        Label descritpionsLabel = new Label("This tab shows overridden translators in a VDB");
        descritpionsLabel.getElement().setAttribute("style", "margin-top:5px;margin-bottom:5px;");
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add(descritpionsLabel.asWidget());
        formPanel.add(translatorsTable.asWidget());
        formPanel.add((Widget)translatorsTablePager);
        formPanel.add(form.asWidget());
        formPanel.add(propertiesLabel.asWidget());
        formPanel.add(propertiesTable.asWidget());
        formPanel.add((Widget)propertiesTablePager);
        return formPanel;
    }

    private DefaultCellTable<VDBTranslator> getTranslatorsTable(ColumnSortEvent.ListHandler<VDBTranslator> sortHandler) {
        ProvidesKey<VDBTranslator> keyProvider = new ProvidesKey<VDBTranslator>(){

            public Object getKey(VDBTranslator item) {
                return VDBTranslatorsTab.this.getVdbName() + "." + VDBTranslatorsTab.this.getVdbVersion() + "." + item.getName();
            }
        };
        DefaultCellTable table = new DefaultCellTable(5, (ProvidesKey)keyProvider);
        table.addColumnSortHandler(sortHandler);
        TextColumn<VDBTranslator> nameColumn = new TextColumn<VDBTranslator>(){

            public String getValue(VDBTranslator record) {
                return record.getName();
            }
        };
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new Comparator<VDBTranslator>(){

            @Override
            public int compare(VDBTranslator o1, VDBTranslator o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TextColumn<VDBTranslator> typeColumn = new TextColumn<VDBTranslator>(){

            public String getValue(VDBTranslator record) {
                return record.getType();
            }
        };
        typeColumn.setSortable(true);
        sortHandler.setComparator((Column)typeColumn, (Comparator)new Comparator<VDBTranslator>(){

            @Override
            public int compare(VDBTranslator o1, VDBTranslator o2) {
                return o1.getType().compareTo(o2.getType());
            }
        });
        TextColumn<VDBTranslator> moduleColumn = new TextColumn<VDBTranslator>(){

            public String getValue(VDBTranslator record) {
                return String.valueOf(record.getModuleName());
            }
        };
        moduleColumn.setSortable(true);
        sortHandler.setComparator((Column)moduleColumn, (Comparator)new Comparator<VDBTranslator>(){

            @Override
            public int compare(VDBTranslator o1, VDBTranslator o2) {
                return o1.getModuleName().compareTo(o2.getModuleName());
            }
        });
        table.setSelectionModel((SelectionModel)new SingleSelectionModel((ProvidesKey)keyProvider));
        table.setTitle("Translators");
        table.addColumn((Column)nameColumn, "Name");
        table.addColumn((Column)typeColumn, "Type");
        table.addColumn((Column)moduleColumn, "Module Name");
        table.getColumnSortList().push((Column)nameColumn);
        return table;
    }
}

