TEIID Connector Arche Type
================

This maven project will be created when the Teiid Connector Archetype is generated.  


-----------
Generate Project
-----------

After the arche type is installed, then to generate a connector project, do the following:

-  'cd' into the teiid/connectors directory (assuming you have checked out teiid from github) or to the
	location you want the connector project created
-  use the following template to generate the project:

***********
* TEMPLATE
***********

mvn archetype:generate       -DarchethypeRepository=https://repository.jboss.org/nexus/content/repositories/releases/                                \
  -DarchetypeGroupId=org.jboss.teiid.arche-types                \
  -DarchetypeArtifactId=connector-archetype          \
  -DarchetypeVersion=8.12.1               \
  -DgroupId=${groupId}   				\
  -DartifactId=connector-${connector-type}	\
  -Dpackage=org.teiid.resource.adapter.${connector-type}    \
  -Dversion=${version}    \
  -Dconnector-type=${connector-type}   \
  -Dconnector-name=${connector-name}   \
  -Dvendor-name=${vendor-name}    \
  -Dteiid-version=${teiid-version}


********
* where:
********

  -DarchetypeGroupId    -  is the group ID for the arche type to use to generate
  -DarchetypeArtifactId -  is the artifact ID for the arche type to use to generate
  -DarchetypeVersion	-  is the version for the arche type to use to generate
  -DgroupId		-  (user defined) group ID for the new connector project pom.xml
  -DartifactId		-  (user defined) artifact ID for the new connector project pom.xml
  -Dpackage		-  (user defined) the package structure where the java and resource files will be created
  -Dversion		-  (user defined) the version that the new connector project pom.xml will be
  -Dconnector-type	-  (user defined) the type of the new connector project, used in defining the package name
  -Dconnector-name	-  (user defined) the name of the new connector project, used as the prefix to creating the java class names
  -Dvendor-name		-  name of the Vendor for the data source, updates the rar
  -Dteiid-version   -  [optional] the Teiid version the connector will depend upon


*********
* EXAMPLE
*********

-  this is an example of the template that can be run:

mvn archetype:generate      -DarchetypeRepository=https://repository.jboss.org/nexus/content/repositories/releases/                   \
  -DarchetypeGroupId=org.jboss.teiid.arche-types   \
  -DarchetypeArtifactId=connector-archetype  \
  -DarchetypeVersion=8.12.1  \
  -DgroupId=org.jboss.teiid.connectors  \
  -Dpackage=org.teiid.resource.adapter.mytype \
  -DartifactId=connector-mytype	\
  -Dversion=0.0.1-SNAPSHOT    \
  -Dconnector-type=mytype   \
  -Dconnector-name=MyType   \
  -Dvendor-name=MyVendor	\
  -Dteiid-version=8.12.0.Final



When executed, you will be asked to confirm the package property

Confirm properties configuration:
groupId: org.jboss.teiid.connectors
artifactId: connector-mytype
version: 0.0.1-SNAPSHOT
package: org.teiid.resource.adapter.mytype
connector-type: mytype
connector-name: MyType
vendor-name: MyVendor
teiid-version: 8.12.0.Final
 Y: : 


type Y (yes) and press enter, and the creation of the translator project will be done


-------
Install Arche Type
-------

To package and install the arche type, run:

mvn clean install 



