/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Repository;
import org.jboss.dna.common.SystemFailureException;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.util.AbstractSessionFactory;

public class SimpleSessionFactory
extends AbstractSessionFactory {
    private final Map<String, Repository> repositories = new ConcurrentHashMap<String, Repository>();

    public SimpleSessionFactory() {
    }

    public SimpleSessionFactory(char ... workspaceDelimiters) {
        super(workspaceDelimiters);
    }

    protected void doRegisterRepository(String name, Repository repository) {
        this.repositories.put(name, repository);
    }

    protected void doUnregisterRepository(String name) throws SystemFailureException {
        if (this.repositories.remove(name) == null) {
            throw new SystemFailureException(RepositoryI18n.unableToRemoveRepository.text(new Object[]{name}));
        }
    }

    protected Repository findRegisteredRepository(String name) throws SystemFailureException {
        Repository repository = this.repositories.get(name);
        if (repository == null) {
            throw new SystemFailureException(RepositoryI18n.unableToFindRepositoryWithName.text(new Object[]{name}));
        }
        return repository;
    }
}

