import org.apache.maven.shared.invoker.*

File license_pomtarget = new File( project.build.directory + "/jdv-license" );

if ( ! license_pomtarget.exists())
{
    fail ("Unable to locate license pom directory to build");
}

// Now we have updated the project properties we need to be able to invoke the script.
InvocationRequest request = new DefaultInvocationRequest();
Invoker invoker = new DefaultInvoker();
InvocationResult result = null;

invoker.setLogger( new SystemOutLogger());
invoker.getLogger().setThreshold (session.getRequest().getLoggingLevel() == 0 ? 4 : 3 );

invoker.getLogger().info ("Regenerating BOM...");
invoker.getLogger().info ("Local repository " + session.getRequest().getLocalRepositoryPath());
invoker.getLogger().info ("Settings file " + session.getRequest().getUserSettingsFile());
invoker.getLogger().debug ("User properties " + session.getUserProperties());
invoker.getLogger().debug ("Project properties " + project.properties);

request.setShellEnvironmentInherited( true );
request.setBaseDirectory ( license_pomtarget );
request.setGoals( session.getGoals() );
request.setProperties (session.getUserProperties());
request.setLocalRepositoryDirectory (session.getRequest().getLocalRepositoryPath());

log.info ("Found project version ${project.version} and " )

if (session.getRequest().getUserSettingsFile().exists()){
    if ("${project.version}".endsWith("SNAPSHOT") )
    {
        log.info ("Swapping release/snapshot in settings XML");

        File tempFile = File.createTempFile("nested", session.getRequest().getUserSettingsFile().getName())

        tempFile.withWriter { file ->
            session.getRequest().getUserSettingsFile().eachLine { line ->

            if ( line.contains("altDeploymentRepository>nexus-release"))
            {
               file.writeLine( line.replace('release', 'snapshot') )
            }
            else if ( line.contains("altDeploymentRepository>nexus-snapshot"))
            {
               file.writeLine( line.replace('snapshot', 'release') )
            }
            else
            {
               file.writeLine( line )
            }
        }}

        log.debug (tempFile.text)
        request.setUserSettingsFile (tempFile);
    }
    else
    {
        request.setUserSettingsFile (session.getRequest().getUserSettingsFile());
    }
}

result = invoker.execute( request );

if (result.getExitCode())
{
    fail ("Maven execution failure");
}
