import org.jsoup.select.Elements;
import org.junit.*;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Created by jianpli on 6/13/17.
 */
public class LicenseHtmlLocalTest
{

    private static HtmlPaser htmlPaser;


    private static String dirPath;
    private static volatile int problemsCount = 0;
    private static volatile boolean isFailed = false;
    
    @BeforeClass
    public static void setup()
    {
        System.out.println("**************************************** start to test local license ****************************************");
        htmlPaser = new HtmlPaser("target/download-licenses/licenses.html");

    }

    private static boolean verifyLocalUri(String localUri, String group, String artifact, String version)
    {
        boolean flag = true;
        File localLicense = new File(dirPath + "/" + localUri);
        if(localUri.equals(""))
        {
            System.out.println("URI debug ---> " + group + ":" + artifact + ":" + version + " ---> local license ---> \"" + localUri + "\" no license path");
            problemsCount += 1;
            flag = false;
            isFailed = true;
        }else if (!localLicense.exists())
        {
            System.out.println("URI debug ---> " + group + ":" + artifact + ":" + version + " ---> local license ---> \"" + localUri + "\" license file don't exist!");
            problemsCount += 1;
            flag = false;
            isFailed = true;
        } else if (localLicense.length() == 0)
        {
            System.out.println("URI debug ---> " + group + ":" + artifact + ":" + version + " ---> local license ---> \"" + localUri + "\" license file is empty!");
            problemsCount += 1;
            flag = false;
            isFailed = true;
        }

        return flag;
    }



    @Test
    public void countTest()
    {
        int countFromHtml = htmlPaser.licensesFromTable.size();
//        Assert.assertEquals(htmlPaser.jarsCount, countFromHtml);
    }

    @Test
    public void localUriTest()
    {
        String htmlPath = htmlPaser.licensesHtmlFile.getAbsolutePath();
        if (htmlPath.lastIndexOf("/") != -1)
        {
            dirPath = htmlPath.substring(0, htmlPath.lastIndexOf("/"));
        } else
        {
            System.out.println("error ---> there is something wrong about path of local licenses");
            Assert.assertFalse(true);
            return;
        }

        if (htmlPaser.licensesFromTable.size() < 2)
        {
            return;
        }

        ExecutorService threadPool = Executors.newFixedThreadPool(10);

        File jar_list_from_html = new File("target/record/jar_list_from_html");
        FileWriter jar_list_writer;
        try
        {
            jar_list_writer = new FileWriter(jar_list_from_html);

            for (int row = 1; row < htmlPaser.licensesFromTable.size(); row++)
            {

                Elements oneLicense = htmlPaser.licensesFromTable.get(row).select("td");
                final String group = oneLicense.get(0).text();
                final String artifact = oneLicense.get(1).text();
                final String version = oneLicense.get(2).text();
                final String localLicenseUri = oneLicense.get(4).select("a").attr("href");

                jar_list_writer.write(artifact + "-" + version + ".jar\n");

                threadPool.execute(new Runnable()
                {
                    public void run()
                    {
                        boolean localFlag = verifyLocalUri(localLicenseUri,group,artifact,version);
                    }
                });


            }

            jar_list_writer.flush();
            jar_list_writer.close();
        } catch (IOException e)
        {
            e.printStackTrace();
        }
        try
        {
            Thread.sleep(1500);
            System.out.println("into ---> analysing ...");
            Thread.sleep(3000);
        } catch (InterruptedException e)
        {
            e.printStackTrace();
        }

        Assert.assertFalse(isFailed);
    }

    @AfterClass
    public static void afterTest()
    {
        System.out.println("---------------------------------------------");
// its not accounting for duplicate errors in the generated bom
 //       System.out.println("total count of dependencies: " + htmlPaser.jarsCount);
 //       System.out.println("count of dependencies from table: " + (htmlPaser.licensesFromTable.size()));
        System.out.println("count of problems: " + problemsCount);
        System.out.println("---------------------------------------------");
        System.out.println("***************************************** End of test local license *****************************************");
    }
}
