CREATE FOREIGN TABLE "vdbwebtest.ER_VISIT" (
	id long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`id`', NATIVE_TYPE 'INT'),
	patientId long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`patientId`', NATIVE_TYPE 'INT'),
	visitDate timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`visitDate`', NATIVE_TYPE 'TIMESTAMP'),
	diagnosis clob(65535) OPTIONS (ANNOTATION '', NAMEINSOURCE '`diagnosis`', NATIVE_TYPE 'TEXT'),
	CONSTRAINT "PRIMARY" PRIMARY KEY(id),
	CONSTRAINT ER_VISIT_ibfk_1 FOREIGN KEY(patientId) REFERENCES vdbwebtest.PATIENT (id)
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`vdbwebtest`.`ER_VISIT`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "vdbwebtest.PATIENT" (
	id long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`id`', NATIVE_TYPE 'INT'),
	firstName clob(65535) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`firstName`', NATIVE_TYPE 'TEXT'),
	lastName clob(65535) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`lastName`', NATIVE_TYPE 'TEXT'),
	gender clob(65535) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`gender`', NATIVE_TYPE 'TEXT'),
	birthDate timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`birthDate`', NATIVE_TYPE 'TIMESTAMP'),
	age long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`age`', NATIVE_TYPE 'INT'),
	highBpHistory boolean NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`highBpHistory`', NATIVE_TYPE 'BIT'),
	smokingHistory boolean NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`smokingHistory`', NATIVE_TYPE 'BIT'),
	currentSmoker boolean NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`currentSmoker`', NATIVE_TYPE 'BIT'),
	medication clob(65535) OPTIONS (ANNOTATION '', NAMEINSOURCE '`medication`', NATIVE_TYPE 'TEXT'),
	diagnosticCode clob(65535) OPTIONS (ANNOTATION '', NAMEINSOURCE '`diagnosticCode`', NATIVE_TYPE 'TEXT'),
	lastPrimaryCareVisit timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' OPTIONS (ANNOTATION '', NAMEINSOURCE '`lastPrimaryCareVisit`', NATIVE_TYPE 'TIMESTAMP'),
	CONSTRAINT "PRIMARY" PRIMARY KEY(id)
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`vdbwebtest`.`PATIENT`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "vdbwebtest.READING" (
	id long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`id`', NATIVE_TYPE 'INT'),
	patientId long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`patientId`', NATIVE_TYPE 'INT'),
	dateRead timestamp NOT NULL DEFAULT 'CURRENT_TIMESTAMP' OPTIONS (ANNOTATION '', NAMEINSOURCE '`dateRead`', NATIVE_TYPE 'TIMESTAMP'),
	mam boolean DEFAULT '0' OPTIONS (ANNOTATION '', NAMEINSOURCE '`mam`', NATIVE_TYPE 'BIT'),
	sys long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`sys`', NATIVE_TYPE 'INT'),
	dia long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`dia`', NATIVE_TYPE 'INT'),
	pulse long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`pulse`', NATIVE_TYPE 'INT'),
	map long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`map`', NATIVE_TYPE 'INT'),
	glucoseType clob(65535) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`glucoseType`', NATIVE_TYPE 'TEXT'),
	glucoseValue long NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`glucoseValue`', NATIVE_TYPE 'INT'),
	glucoseLabel clob(65535) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`glucoseLabel`', NATIVE_TYPE 'TEXT'),
	note clob(65535) OPTIONS (ANNOTATION '', NAMEINSOURCE '`note`', NATIVE_TYPE 'TEXT'),
	CONSTRAINT "PRIMARY" PRIMARY KEY(id),
	CONSTRAINT READING_ibfk_1 FOREIGN KEY(patientId) REFERENCES vdbwebtest.PATIENT (id)
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`vdbwebtest`.`READING`', UPDATABLE TRUE);

CREATE FOREIGN TABLE "vdbwebtest.state" (
	id long NOT NULL AUTO_INCREMENT OPTIONS (ANNOTATION '', NAMEINSOURCE '`id`', NATIVE_TYPE 'BIGINT UNSIGNED'),
	code string(2) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`code`', NATIVE_TYPE 'CHAR'),
	name string(64) NOT NULL OPTIONS (ANNOTATION '', NAMEINSOURCE '`name`', NATIVE_TYPE 'VARCHAR'),
	CONSTRAINT "PRIMARY" PRIMARY KEY(id),
	CONSTRAINT id UNIQUE(id)
) OPTIONS (ANNOTATION '', NAMEINSOURCE '`vdbwebtest`.`state`', UPDATABLE TRUE);