DROP SCHEMA PUBLIC CASCADE

CREATE MEMORY TABLE CUSTOMERS(CUSTOMERNUMBER INTEGER NOT NULL PRIMARY KEY,CUSTOMERNAME VARCHAR(50) NOT NULL,CONTACTLASTNAME VARCHAR(50) NOT NULL,CONTACTFIRSTNAME VARCHAR(50) NOT NULL,PHONE VARCHAR(50) NOT NULL,ADDRESSLINE1 VARCHAR(50) NOT NULL,ADDRESSLINE2 VARCHAR(50),CITY VARCHAR(50) NOT NULL,STATE VARCHAR(50),POSTALCODE VARCHAR(15),COUNTRY VARCHAR(50) NOT NULL,SALESREPEMPLOYEENUMBER INTEGER,CREDITLIMIT DOUBLE)
CREATE MEMORY TABLE EMPLOYEES(EMPLOYEENUMBER INTEGER NOT NULL PRIMARY KEY,LASTNAME VARCHAR(50) NOT NULL,FIRSTNAME VARCHAR(50) NOT NULL,EXTENSION VARCHAR(10) NOT NULL,EMAIL VARCHAR(100) NOT NULL,OFFICECODE VARCHAR(10) NOT NULL,REPORTSTO INTEGER,JOBTITLE VARCHAR(50) NOT NULL)
CREATE MEMORY TABLE OFFICES(OFFICECODE VARCHAR(10) NOT NULL PRIMARY KEY,CITY VARCHAR(50) NOT NULL,PHONE VARCHAR(50) NOT NULL,ADDRESSLINE1 VARCHAR(50) NOT NULL,ADDRESSLINE2 VARCHAR(50),STATE VARCHAR(50),COUNTRY VARCHAR(50) NOT NULL,POSTALCODE VARCHAR(15) NOT NULL,TERRITORY VARCHAR(10) NOT NULL)
CREATE MEMORY TABLE ORDERDETAILS(ORDERDETAILNUMBER INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,ORDERNUMBER INTEGER NOT NULL,PRODUCTCODE VARCHAR(15) NOT NULL,QUANTITYORDERED INTEGER NOT NULL,PRICEEACH DOUBLE NOT NULL,ORDERLINENUMBER SMALLINT NOT NULL)
CREATE MEMORY TABLE PRODUCTS(PRODUCTCODE VARCHAR(15) NOT NULL PRIMARY KEY,PRODUCTNAME VARCHAR(70) NOT NULL,PRODUCTLINE VARCHAR(50) NOT NULL,PRODUCTSCALE VARCHAR(10) NOT NULL,PRODUCTVENDOR VARCHAR(50) NOT NULL,PRODUCTDESCRIPTION VARCHAR(4000) NOT NULL,QUANTITYINSTOCK SMALLINT NOT NULL,BUYPRICE DOUBLE NOT NULL,MSRP DOUBLE NOT NULL)
CREATE MEMORY TABLE PRODUCTLINES(PRODUCTLINE VARCHAR(50) NOT NULL PRIMARY KEY,TEXTDESCRIPTION VARCHAR(4000),HTMLDESCRIPTION VARCHAR(4000))
CREATE MEMORY TABLE ORDERS(ORDERNUMBER INTEGER NOT NULL PRIMARY KEY,ORDERDATE DATE NOT NULL,REQUIREDDATE DATE NOT NULL,SHIPPEDDATE DATE,STATUS VARCHAR(16) NOT NULL,COMMENTS VARCHAR(255),CUSTOMERNUMBER INTEGER NOT NULL,CONSTRAINT SYS_FK_67 FOREIGN KEY(CUSTOMERNUMBER) REFERENCES CUSTOMERS(CUSTOMERNUMBER))
CREATE MEMORY TABLE PAYMENTS(PAYMENTNUMBER INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,CUSTOMERNUMBER INTEGER NOT NULL,CHECKNUMBER VARCHAR(50) NOT NULL,PAYMENTDATE DATE NOT NULL,AMOUNT DOUBLE NOT NULL,CONSTRAINT SYS_FK_70 FOREIGN KEY(CUSTOMERNUMBER) REFERENCES CUSTOMERS(CUSTOMERNUMBER))

SET WRITE_DELAY 10
SET SCHEMA PUBLIC
INSERT INTO CUSTOMERS VALUES(103,'Atelier graphique','Schmitt','Carine ','40.32.2555','54, rue Royale','','Nantes','','44000','France',1370,21000.0E0)
INSERT INTO CUSTOMERS VALUES(112,'Signal Gift Stores','King','Jean','7025551838','8489 Strong St.','','Las Vegas','NV','83030','USA',1166,71800.0E0)
INSERT INTO CUSTOMERS VALUES(114,'Australian Collectors, Co.','Ferguson','Peter','03 9520 4555','636 St Kilda Road','Level 3','Melbourne','Victoria','3004','Australia',1611,117300.0E0)
INSERT INTO CUSTOMERS VALUES(119,'La Rochelle Gifts','Labrune','Janine ','40.67.8555','67, rue des Cinquante Otages','','Nantes','','44000','France',1370,118200.0E0)
INSERT INTO CUSTOMERS VALUES(121,'Baane Mini Imports','Bergulfsen','Jonas ','07-98 9555','Erling Skakkes gate 78','','Stavern','','4110','Norway',1504,81700.0E0)
INSERT INTO CUSTOMERS VALUES(124,'Mini Gifts Distributors Ltd.','Nelson','Susan','4155551450','5677 Strong St.','','San Rafael','CA','97562','USA',1165,210500.0E0)
INSERT INTO CUSTOMERS VALUES(125,'Havel & Zbyszek Co','Piestrzeniewicz','Zbyszek ','(26) 642-7555','ul. Filtrowa 68','','Warszawa','','01-012','Poland',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(128,'Blauer See Auto, Co.','Keitel','Roland','+49 69 66 90 2555','Lyonerstr. 34','','Frankfurt','','60528','Germany',1504,59700.0E0)
INSERT INTO CUSTOMERS VALUES(129,'Mini Wheels Co.','Murphy','Julie','6505555787','5557 North Pendale Street','','San Francisco','CA','94217','USA',1165,64600.0E0)
INSERT INTO CUSTOMERS VALUES(131,'Land of Toys Inc.','Lee','Kwai','2125557818','897 Long Airport Avenue','','NYC','NY','10022','USA',1323,114900.0E0)
INSERT INTO CUSTOMERS VALUES(141,'Euro+ Shopping Channel','Freyre','Diego ','(91) 555 94 44','C/ Moralzarzal, 86','','Madrid','','28034','Spain',1370,227600.0E0)
INSERT INTO CUSTOMERS VALUES(144,'Volvo Model Replicas, Co','Berglund','Christina ','0921-12 3555','Berguvsv\u005cu005cufffdgen  8','','Lule\u005cu005cufffd','','S-958 22','Sweden',1504,53100.0E0)
INSERT INTO CUSTOMERS VALUES(145,'Danish Wholesale Imports','Petersen','Jytte ','31 12 3555','Vinb\u005cu005cufffdltet 34','','Kobenhavn','','1734','Denmark',1401,83400.0E0)
INSERT INTO CUSTOMERS VALUES(146,'Saveley & Henriot, Co.','Saveley','Mary ','78.32.5555','2, rue du Commerce','','Lyon','','69004','France',1337,123900.0E0)
INSERT INTO CUSTOMERS VALUES(148,'Dragon Souveniers, Ltd.','Natividad','Eric','+65 221 7555','Bronz Sok.','Bronz Apt. 3/6 Tesvikiye','Singapore','','079903','Singapore',1621,103800.0E0)
INSERT INTO CUSTOMERS VALUES(151,'Muscle Machine Inc','Young','Jeff','2125557413','4092 Furth Circle','Suite 400','NYC','NY','10022','USA',1286,138500.0E0)
INSERT INTO CUSTOMERS VALUES(157,'Diecast Classics Inc.','Leong','Kelvin','2155551555','7586 Pompton St.','','Allentown','PA','70267','USA',1216,100600.0E0)
INSERT INTO CUSTOMERS VALUES(161,'Technics Stores Inc.','Hashimoto','Juri','6505556809','9408 Furth Circle','','Burlingame','CA','94217','USA',1165,84600.0E0)
INSERT INTO CUSTOMERS VALUES(166,'Handji Gifts& Co','Victorino','Wendy','+65 224 1555','106 Linden Road Sandown','2nd Floor','Singapore','','069045','Singapore',1612,97900.0E0)
INSERT INTO CUSTOMERS VALUES(167,'Herkku Gifts','Oeztan','Veysel','+47 2267 3215','Brehmen St. 121','PR 334 Sentrum','Bergen','','N 5804','Norway  ',1504,96800.0E0)
INSERT INTO CUSTOMERS VALUES(168,'American Souvenirs Inc','Franco','Keith','2035557845','149 Spinnaker Dr.','Suite 101','New Haven','CT','97823','USA',1286,0.0E0)
INSERT INTO CUSTOMERS VALUES(169,'Porto Imports Co.','de Castro','Isabel ','(1) 356-5555','Estrada da sa\u005cu005cufffdde n. 58','','Lisboa','','1756','Portugal',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(171,'Daedalus Designs Imports','Ranc\u005cu005cufffd','Martine ','20.16.1555','184, chauss\u005cu005cufffde de Tournai','','Lille','','59000','France',1370,82900.0E0)
INSERT INTO CUSTOMERS VALUES(172,'La Corne Dabondance, Co.','Bertrand','Marie','(1) 42.34.2555','265, boulevard Charonne','','Paris','','75012','France',1337,84300.0E0)
INSERT INTO CUSTOMERS VALUES(173,'Cambridge Collectables Co.','Tseng','Jerry','6175555555','4658 Baden Av.','','Cambridge','MA','51247','USA',1188,43400.0E0)
INSERT INTO CUSTOMERS VALUES(175,'Gift Depot Inc.','King','Julie','2035552570','25593 South Bay Ln.','','Bridgewater','CT','97562','USA',1323,84300.0E0)
INSERT INTO CUSTOMERS VALUES(177,'Osaka Souveniers Co.','Kentary','Mory','+81 06 6342 5555','1-6-20 Dojima','','Kita-ku','Osaka',' 530-0003','Japan',1621,81200.0E0)
INSERT INTO CUSTOMERS VALUES(181,'Vitachrome Inc.','Frick','Michael','2125551500','2678 Kingston Rd.','Suite 101','NYC','NY','10022','USA',1286,76400.0E0)
INSERT INTO CUSTOMERS VALUES(186,'Toys of Finland, Co.','Karttunen','Matti','90-224 8555','Keskuskatu 45','','Helsinki','','21240','Finland',1501,96500.0E0)
INSERT INTO CUSTOMERS VALUES(187,'AV Stores, Co.','Ashworth','Rachel','(171) 555-1555','Fauntleroy Circus','','Manchester','','EC2 5NT','UK',1501,136800.0E0)
INSERT INTO CUSTOMERS VALUES(189,'Clover Collections, Co.','Cassidy','Dean','+353 1862 1555','25 Maiden Lane','Floor No. 4','Dublin','','2','Ireland',1504,69400.0E0)
INSERT INTO CUSTOMERS VALUES(198,'Auto-Moto Classics Inc.','Taylor','Leslie','6175558428','16780 Pompton St.','','Brickhaven','MA','58339','USA',1216,23000.0E0)
INSERT INTO CUSTOMERS VALUES(201,'UK Collectables, Ltd.','Devon','Elizabeth','(171) 555-2282','12, Berkeley Gardens Blvd','','Liverpool','','WX1 6LT','UK',1501,92700.0E0)
INSERT INTO CUSTOMERS VALUES(202,'Canadian Gift Exchange Network','Tamuri','Yoshi ','(604) 555-3392','1900 Oak St.','','Vancouver','BC','V3F 2K1','Canada',1323,90300.0E0)
INSERT INTO CUSTOMERS VALUES(204,'Online Mini Collectables','Barajas','Miguel','6175557555','7635 Spinnaker Dr.','','Brickhaven','MA','58339','USA',1188,68700.0E0)
INSERT INTO CUSTOMERS VALUES(205,'Toys4GrownUps.com','Young','Julie','6265557265','78934 Hillside Dr.','','Pasadena','CA','90003','USA',1166,90700.0E0)
INSERT INTO CUSTOMERS VALUES(206,'Asian Shopping Network, Co','Walker','Brydey','+612 9411 1555','Suntec Tower Three','8 Temasek','Singapore','','038988','Singapore',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(209,'Mini Caravy','Citeaux','Fr\u005cu005cufffdd\u005cu005cufffdrique ','88.60.1555','24, place Kl\u005cu005cufffdber','','Strasbourg','','67000','France',1370,53800.0E0)
INSERT INTO CUSTOMERS VALUES(211,'King Kong Collectables, Co.','Gao','Mike','+852 2251 1555','Bank of China Tower','1 Garden Road','Central Hong Kong','','','Hong Kong',1621,58600.0E0)
INSERT INTO CUSTOMERS VALUES(216,'Enaco Distributors','Saavedra','Eduardo ','(93) 203 4555','Rambla de Catalu\u005cu005cufffda, 23','','Barcelona','','08022','Spain',1702,60300.0E0)
INSERT INTO CUSTOMERS VALUES(219,'Boards & Toys Co.','Young','Mary','3105552373','4097 Douglas Av.','','Glendale','CA','92561','USA',1166,11000.0E0)
INSERT INTO CUSTOMERS VALUES(223,'Nat\u005cu005cufffdrlich Autos','Kloss','Horst ','0372-555188','Taucherstra\u005cu005cufffde 10','','Cunewalde','','01307','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(227,'Heintze Collectables','Ibsen','Palle','86 21 3555','Smagsloget 45','','\u005cu005cufffdrhus','','8200','Denmark',1401,120800.0E0)
INSERT INTO CUSTOMERS VALUES(233,'Qu\u005cu005cufffdbec Home Shopping Network','Fresni\u005cu005cufffdre','Jean ','(514) 555-8054','43 rue St. Laurent','','Montr\u005cu005cufffdal','Qu\u005cu005cufffdbec','H1J 1C3','Canada',1286,48700.0E0)
INSERT INTO CUSTOMERS VALUES(237,'ANG Resellers','Camino','Alejandra ','(91) 745 6555','Gran V\u005cu005cufffda, 1','','Madrid','','28001','Spain',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(239,'Collectable Mini Designs Co.','Thompson','Valarie','7605558146','361 Furth Circle','','San Diego','CA','91217','USA',1166,105000.0E0)
INSERT INTO CUSTOMERS VALUES(240,'giftsbymail.co.uk','Bennett','Helen ','(198) 555-8888','Garden House','Crowther Way 23','Cowes','Isle of Wight','PO31 7PJ','UK',1501,93900.0E0)
INSERT INTO CUSTOMERS VALUES(242,'Alpha Cognac','Roulet','Annette ','61.77.6555','1 rue Alsace-Lorraine','','Toulouse','','31000','France',1370,61100.0E0)
INSERT INTO CUSTOMERS VALUES(247,'Messner Shopping Network','Messner','Renate ','069-0555984','Magazinweg 7','','Frankfurt','','60528','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(249,'Amica Models & Co.','Accorti','Paolo ','011-4988555','Via Monte Bianco 34','','Torino','','10100','Italy',1401,113000.0E0)
INSERT INTO CUSTOMERS VALUES(250,'Lyon Souveniers','Da Silva','Daniel','+33 1 46 62 7555','27 rue du Colonel Pierre Avia','','Paris','','75508','France',1337,68100.0E0)
INSERT INTO CUSTOMERS VALUES(256,'Auto Associ\u005cu005cufffds & Cie.','Tonini','Daniel ','30.59.8555','67, avenue de lEurope','','Versailles','','78000','France',1370,77900.0E0)
INSERT INTO CUSTOMERS VALUES(259,'Toms Spezialit\u005cu005cufffdten, Ltd','Pfalzheim','Henriette ','0221-5554327','Mehrheimerstr. 369','','K\u005cu005cufffdln','','50739','Germany',1504,120400.0E0)
INSERT INTO CUSTOMERS VALUES(260,'Royal Canadian Collectables, Ltd.','Lincoln','Elizabeth ','(604) 555-4555','23 Tsawassen Blvd.','','Tsawassen','BC','T2F 8M4','Canada',1323,89600.0E0)
INSERT INTO CUSTOMERS VALUES(273,'Franken Gifts, Co','Franken','Peter ','089-0877555','Berliner Platz 43','','M\u005cu005cufffdnchen','','80805','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(276,'Annas Decorations, Ltd','OHara','Anna','02 9936 8555','201 Miller Street','Level 15','North Sydney','NSW','2060','Australia',1611,107800.0E0)
INSERT INTO CUSTOMERS VALUES(278,'Rovelli Gifts','Rovelli','Giovanni ','035-640555','Via Ludovico il Moro 22','','Bergamo','','24100','Italy',1401,119600.0E0)
INSERT INTO CUSTOMERS VALUES(282,'Souveniers And Things Co.','Huxley','Adrian','+61 2 9495 8555','Monitor Money Building','815 Pacific Hwy','Chatswood','NSW','2067','Australia',1611,93300.0E0)
INSERT INTO CUSTOMERS VALUES(286,'Marta Replicas Co.','Hernandez','Marta','6175558555','39323 Spinnaker Dr.','','Cambridge','MA','51247','USA',1216,123700.0E0)
INSERT INTO CUSTOMERS VALUES(293,'BG&E Collectables','Harrison','Ed','+41 26 425 50 01','Rte des Arsenaux 41 ','','Fribourg','','1700','Switzerland',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(298,'Vida Sport, Ltd','Holz','Mihael','0897-034555','Grenzacherweg 237','','Gen\u005cu005cufffdve','','1203','Switzerland',1702,141300.0E0)
INSERT INTO CUSTOMERS VALUES(299,'Norway Gifts By Mail, Co.','Klaeboe','Jan','+47 2212 1555','Drammensveien 126A','PB 211 Sentrum','Oslo','','N 0106','Norway  ',1504,95100.0E0)
INSERT INTO CUSTOMERS VALUES(303,'Schuyler Imports','Schuyler','Bradley','+31 20 491 9555','Kingsfordweg 151','','Amsterdam','','1043 GR','Netherlands',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(307,'Der Hund Imports','Andersen','Mel','030-0074555','Obere Str. 57','','Berlin','','12209','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(311,'Oulu Toy Supplies, Inc.','Koskitalo','Pirkko','981-443655','Torikatu 38','','Oulu','','90110','Finland',1501,90500.0E0)
INSERT INTO CUSTOMERS VALUES(314,'Petit Auto','Dewey','Catherine ','(02) 5554 67','Rue Joseph-Bens 532','','Bruxelles','','B-1180','Belgium',1401,79900.0E0)
INSERT INTO CUSTOMERS VALUES(319,'Mini Classics','Frick','Steve','9145554562','3758 North Pendale Street','','White Plains','NY','24067','USA',1323,102700.0E0)
INSERT INTO CUSTOMERS VALUES(320,'Mini Creations Ltd.','Huang','Wing','5085559555','4575 Hillside Dr.','','New Bedford','MA','50553','USA',1188,94500.0E0)
INSERT INTO CUSTOMERS VALUES(321,'Corporate Gift Ideas Co.','Brown','Julie','6505551386','7734 Strong St.','','San Francisco','CA','94217','USA',1165,105000.0E0)
INSERT INTO CUSTOMERS VALUES(323,'Down Under Souveniers, Inc','Graham','Mike','+64 9 312 5555','162-164 Grafton Road','Level 2','Auckland  ','','','New Zealand',1612,88000.0E0)
INSERT INTO CUSTOMERS VALUES(324,'Stylish Desk Decors, Co.','Brown','Ann ','(171) 555-0297','35 King George','','London','','WX3 6FW','UK',1501,77000.0E0)
INSERT INTO CUSTOMERS VALUES(328,'Tekni Collectables Inc.','Brown','William','2015559350','7476 Moss Rd.','','Newark','NJ','94019','USA',1323,43000.0E0)
INSERT INTO CUSTOMERS VALUES(333,'Australian Gift Network, Co','Calaghan','Ben','61-7-3844-6555','31 Duncan St. West End','','South Brisbane','Queensland','4101','Australia',1611,51600.0E0)
INSERT INTO CUSTOMERS VALUES(334,'Suominen Souveniers','Suominen','Kalle','+358 9 8045 555','Software Engineering Center','SEC Oy','Espoo','','FIN-02271','Finland',1501,98800.0E0)
INSERT INTO CUSTOMERS VALUES(335,'Cramer Spezialit\u005cu005cufffdten, Ltd','Cramer','Philip ','0555-09555','Maubelstr. 90','','Brandenburg','','14776','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(339,'Classic Gift Ideas, Inc','Cervantes','Francisca','2155554695','782 First Street','','Philadelphia','PA','71270','USA',1188,81100.0E0)
INSERT INTO CUSTOMERS VALUES(344,'CAF Imports','Fernandez','Jesus','+34 913 728 555','Merchants House','27-30 Merchants Quay','Madrid','','28023','Spain',1702,59600.0E0)
INSERT INTO CUSTOMERS VALUES(347,'Men R US Retailers, Ltd.','Chandler','Brian','2155554369','6047 Douglas Av.','','Los Angeles','CA','91003','USA',1166,57700.0E0)
INSERT INTO CUSTOMERS VALUES(348,'Asian Treasures, Inc.','McKenna','Patricia ','2967 555','8 Johnstown Road','','Cork','Co. Cork','','Ireland',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(350,'Marseille Mini Autos','Lebihan','Laurence ','91.24.4555','12, rue des Bouchers','','Marseille','','13008','France',1337,65000.0E0)
INSERT INTO CUSTOMERS VALUES(353,'Reims Collectables','Henriot','Paul ','26.47.1555','59 rue de lAbbaye','','Reims','','51100','France',1337,81100.0E0)
INSERT INTO CUSTOMERS VALUES(356,'SAR Distributors, Co','Kuger','Armand','+27 21 550 3555','1250 Pretorius Street','','Hatfield','Pretoria','0028','South Africa',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(357,'GiftsForHim.com','MacKinlay','Wales','64-9-3763555','199 Great North Road','','Auckland','','','New Zealand',1612,77700.0E0)
INSERT INTO CUSTOMERS VALUES(361,'Kommission Auto','Josephs','Karin','0251-555259','Luisenstr. 48','','M\u005cu005cufffdnster','','44087','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(362,'Gifts4AllAges.com','Yoshido','Juri','6175559555','8616 Spinnaker Dr.','','Boston','MA','51003','USA',1216,41900.0E0)
INSERT INTO CUSTOMERS VALUES(363,'Online Diecast Creations Co.','Young','Dorothy','6035558647','2304 Long Airport Avenue','','Nashua','NH','62005','USA',1216,114200.0E0)
INSERT INTO CUSTOMERS VALUES(369,'Lisboa Souveniers, Inc','Rodriguez','Lino ','(1) 354-2555','Jardim das rosas n. 32','','Lisboa','','1675','Portugal',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(376,'Precious Collectables','Urs','Braun','0452-076555','Hauptstr. 29','','Bern','','3012','Switzerland',1702,0.0E0)
INSERT INTO CUSTOMERS VALUES(379,'Collectables For Less Inc.','Nelson','Allen','6175558555','7825 Douglas Av.','','Brickhaven','MA','58339','USA',1188,70700.0E0)
INSERT INTO CUSTOMERS VALUES(381,'Royale Belge','Cartrain','Pascale ','(071) 23 67 2555','Boulevard Tirou, 255','','Charleroi','','B-6000','Belgium',1401,23500.0E0)
INSERT INTO CUSTOMERS VALUES(382,'Salzburg Collectables','Pipps','Georg ','6562-9555','Geislweg 14','','Salzburg','','5020','Austria',1401,71700.0E0)
INSERT INTO CUSTOMERS VALUES(385,'Cruz & Sons Co.','Cruz','Arnold','+63 2 555 3587','15 McCallum Street','NatWest Center #13-03','Makati City','','1227 MM','Philippines',1621,81500.0E0)
INSERT INTO CUSTOMERS VALUES(386,'Lordine Souveniers','Moroni','Maurizio ','0522-556555','Strada Provinciale 124','','Reggio Emilia','','42100','Italy',1401,121400.0E0)
INSERT INTO CUSTOMERS VALUES(398,'Tokyo Collectables, Ltd','Shimamura','Akiko','+81 3 3584 0555','2-2-8 Roppongi','','Minato-ku','Tokyo','106-0032','Japan',1621,94400.0E0)
INSERT INTO CUSTOMERS VALUES(406,'Auto Canal+ Petit','Perrier','Dominique','(1) 47.55.6555','25, rue Lauriston','','Paris','','75016','France',1337,95000.0E0)
INSERT INTO CUSTOMERS VALUES(409,'Stuttgart Collectable Exchange','M\u005cu005cufffdller','Rita ','0711-555361','Adenauerallee 900','','Stuttgart','','70563','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(412,'Extreme Desk Decorations, Ltd','McRoy','Sarah','04 499 9555','101 Lambton Quay','Level 11','Wellington','','','New Zealand',1612,86800.0E0)
INSERT INTO CUSTOMERS VALUES(415,'Bavarian Collectables Imports, Co.','Donnermeyer','Michael',' +49 89 61 08 9555','Hansastr. 15','','Munich','','80686','Germany',1504,77000.0E0)
INSERT INTO CUSTOMERS VALUES(424,'Classic Legends Inc.','Hernandez','Maria','2125558493','5905 Pompton St.','Suite 750','NYC','NY','10022','USA',1286,67500.0E0)
INSERT INTO CUSTOMERS VALUES(443,'Feuer Online Stores, Inc','Feuer','Alexander ','0342-555176','Heerstr. 22','','Leipzig','','04179','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(447,'Gift Ideas Corp.','Lewis','Dan','2035554407','2440 Pompton St.','','Glendale','CT','97561','USA',1323,49700.0E0)
INSERT INTO CUSTOMERS VALUES(448,'Scandinavian Gift Ideas','Larsson','Martha','0695-34 6555','\u005cu005cufffdkergatan 24','','Br\u005cu005cufffdcke','','S-844 67','Sweden',1504,116400.0E0)
INSERT INTO CUSTOMERS VALUES(450,'The Sharp Gifts Warehouse','Frick','Sue','4085553659','3086 Ingle Ln.','','San Jose','CA','94217','USA',1165,77600.0E0)
INSERT INTO CUSTOMERS VALUES(452,'Mini Auto Werke','Mendel','Roland ','7675-3555','Kirchgasse 6','','Graz','','8010','Austria',1401,45300.0E0)
INSERT INTO CUSTOMERS VALUES(455,'Super Scale Inc.','Murphy','Leslie','2035559545','567 North Pendale Street','','New Haven','CT','97823','USA',1286,95400.0E0)
INSERT INTO CUSTOMERS VALUES(456,'Microscale Inc.','Choi','Yu','2125551957','5290 North Pendale Street','Suite 200','NYC','NY','10022','USA',1286,39800.0E0)
INSERT INTO CUSTOMERS VALUES(458,'Corrida Auto Replicas, Ltd','Sommer','Mart\u005cu005cufffdn ','(91) 555 22 82','C/ Araquil, 67','','Madrid','','28023','Spain',1702,104600.0E0)
INSERT INTO CUSTOMERS VALUES(459,'Warburg Exchange','Ottlieb','Sven ','0241-039123','Walserweg 21','','Aachen','','52066','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(462,'FunGiftIdeas.com','Benitez','Violeta','5085552555','1785 First Street','','New Bedford','MA','50553','USA',1216,85800.0E0)
INSERT INTO CUSTOMERS VALUES(465,'Anton Designs, Ltd.','Anton','Carmen','+34 913 728555','c/ Gobelas, 19-1 Urb. La Florida','','Madrid','','28023','Spain',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(471,'Australian Collectables, Ltd','Clenahan','Sean','61-9-3844-6555','7 Allen Street','','Glen Waverly','Victoria','3150','Australia',1611,60300.0E0)
INSERT INTO CUSTOMERS VALUES(473,'Frau da Collezione','Ricotti','Franco','+39 022515555','20093 Cologno Monzese','Alessandro Volta 16','Milan','','','Italy',1401,34800.0E0)
INSERT INTO CUSTOMERS VALUES(475,'West Coast Collectables Co.','Thompson','Steve','3105553722','3675 Furth Circle','','Burbank','CA','94019','USA',1166,55400.0E0)
INSERT INTO CUSTOMERS VALUES(477,'Mit Vergn\u005cu005cufffdgen & Co.','Moos','Hanna ','0621-08555','Forsterstr. 57','','Mannheim','','68306','Germany',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(480,'Kremlin Collectables, Co.','Semenov','Alexander ','+7 812 293 0521','2 Pobedy Square','','Saint Petersburg','','196143','Russia',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(481,'Raanan Stores, Inc','Altagar,G M','Raanan','+ 972 9 959 8555','3 Hagalim Blv.','','Herzlia','','47625','Israel',NULL,0.0E0)
INSERT INTO CUSTOMERS VALUES(484,'Iberia Gift Imports, Corp.','Roel','Jos\u005cu005cufffd Pedro ','(95) 555 82 82','C/ Romero, 33','','Sevilla','','41101','Spain',1702,65700.0E0)
INSERT INTO CUSTOMERS VALUES(486,'Motor Mint Distributors Inc.','Salazar','Rosa','2155559857','11328 Douglas Av.','','Philadelphia','PA','71270','USA',1323,72600.0E0)
INSERT INTO CUSTOMERS VALUES(487,'Signal Collectibles Ltd.','Taylor','Sue','4155554312','2793 Furth Circle','','Brisbane','CA','94217','USA',1165,60300.0E0)
INSERT INTO CUSTOMERS VALUES(489,'Double Decker Gift Stores, Ltd','Smith','Thomas ','(171) 555-7555','120 Hanover Sq.','','London','','WA1 1DP','UK',1501,43300.0E0)
INSERT INTO CUSTOMERS VALUES(495,'Diecast Collectables','Franco','Valarie','6175552555','6251 Ingle Ln.','','Boston','MA','51003','USA',1188,85100.0E0)
INSERT INTO CUSTOMERS VALUES(496,'Kellys Gift Shop','Snowden','Tony','+64 9 5555500','Arenales 1938 3A','','Auckland  ','','','New Zealand',1612,110000.0E0)
INSERT INTO EMPLOYEES VALUES(1002,'Murphy','Diane','x5800','dmurphy@classicmodelcars.com','1',NULL,'President')
INSERT INTO EMPLOYEES VALUES(1056,'Patterson','Mary','x4611','mpatterso@classicmodelcars.com','1',1002,'VP Sales')
INSERT INTO EMPLOYEES VALUES(1076,'Firrelli','Jeff','x9273','jfirrelli@classicmodelcars.com','1',1002,'VP Marketing')
INSERT INTO EMPLOYEES VALUES(1088,'Patterson','William','x4871','wpatterson@classicmodelcars.com','6',1056,'Sales Manager (APAC)')
INSERT INTO EMPLOYEES VALUES(1102,'Bondur','Gerard','x5408','gbondur@classicmodelcars.com','4',1056,'Sale Manager (EMEA)')
INSERT INTO EMPLOYEES VALUES(1143,'Bow','Anthony','x5428','abow@classicmodelcars.com','1',1056,'Sales Manager (NA)')
INSERT INTO EMPLOYEES VALUES(1165,'Jennings','Leslie','x3291','ljennings@classicmodelcars.com','1',1143,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1166,'Thompson','Leslie','x4065','lthompson@classicmodelcars.com','1',1143,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1188,'Firrelli','Julie','x2173','jfirrelli@classicmodelcars.com','2',1143,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1216,'Patterson','Steve','x4334','spatterson@classicmodelcars.com','2',1143,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1286,'Tseng','Foon Yue','x2248','ftseng@classicmodelcars.com','3',1143,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1323,'Vanauf','George','x4102','gvanauf@classicmodelcars.com','3',1143,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1337,'Bondur','Loui','x6493','lbondur@classicmodelcars.com','4',1102,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1370,'Hernandez','Gerard','x2028','ghernande@classicmodelcars.com','4',1102,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1401,'Castillo','Pamela','x2759','pcastillo@classicmodelcars.com','4',1102,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1501,'Bott','Larry','x2311','lbott@classicmodelcars.com','7',1102,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1504,'Jones','Barry','x102','bjones@classicmodelcars.com','7',1102,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1611,'Fixter','Andy','x101','afixter@classicmodelcars.com','6',1088,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1612,'Marsh','Peter','x102','pmarsh@classicmodelcars.com','6',1088,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1619,'King','Tom','x103','tking@classicmodelcars.com','6',1088,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1621,'Nishi','Mami','x101','mnishi@classicmodelcars.com','5',1056,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1625,'Kato','Yoshimi','x102','ykato@classicmodelcars.com','5',1621,'Sales Rep')
INSERT INTO EMPLOYEES VALUES(1702,'Gerard','Martin','x2312','mgerard@classicmodelcars.com','4',1102,'Sales Rep')
INSERT INTO OFFICES VALUES('1','San Francisco','+1 650 219 4782','100 Market Street','Suite 300','CA','USA','94080','NA')
INSERT INTO OFFICES VALUES('2','Boston','+1 215 837 0825','1550 Court Place','Suite 102','MA','USA','02107','NA')
INSERT INTO OFFICES VALUES('3','NYC','+1 212 555 3000','523 East 53rd Street','apt. 5A','NY','USA','10022','NA')
INSERT INTO OFFICES VALUES('4','Paris','+33 14 723 4404','43 Rue Jouffroy D''abbans','','','France','75017','EMEA')
INSERT INTO OFFICES VALUES('5','Tokyo','+81 33 224 5000','4-1 Kioicho','','Chiyoda-Ku','Japan','102-8578','Japan')
INSERT INTO OFFICES VALUES('6','Sydney','+61 2 9264 2451','5-11 Wentworth Avenue','Floor #2','','Australia','NSW 2010','APAC')
INSERT INTO OFFICES VALUES('7','London','+44 20 7877 2041','25 Old Broad Street','Level 7','','UK','EC2N 1HN','EMEA')
INSERT INTO ORDERDETAILS VALUES(0,10100,'S18_1749',30,136.0E0,3)
INSERT INTO ORDERDETAILS VALUES(1,10100,'S18_2248',50,55.09E0,2)
INSERT INTO ORDERDETAILS VALUES(2,10100,'S18_4409',22,75.46E0,4)
INSERT INTO ORDERDETAILS VALUES(3,10100,'S24_3969',49,35.29E0,1)
INSERT INTO ORDERDETAILS VALUES(4,10101,'S18_2325',25,108.06E0,4)
INSERT INTO ORDERDETAILS VALUES(5,10101,'S18_2795',26,167.06E0,1)
INSERT INTO ORDERDETAILS VALUES(6,10101,'S24_1937',45,32.53E0,3)
INSERT INTO ORDERDETAILS VALUES(7,10101,'S24_2022',46,44.35E0,2)
INSERT INTO ORDERDETAILS VALUES(8,10102,'S18_1342',39,95.55E0,2)
INSERT INTO ORDERDETAILS VALUES(9,10102,'S18_1367',41,43.13E0,1)
INSERT INTO ORDERDETAILS VALUES(10,10103,'S10_1949',26,214.3E0,11)
INSERT INTO ORDERDETAILS VALUES(11,10103,'S10_4962',42,119.67E0,4)
INSERT INTO ORDERDETAILS VALUES(12,10103,'S12_1666',27,121.64E0,8)
INSERT INTO ORDERDETAILS VALUES(13,10103,'S18_1097',35,94.5E0,10)
INSERT INTO ORDERDETAILS VALUES(14,10103,'S18_2432',22,58.34E0,2)
INSERT INTO ORDERDETAILS VALUES(15,10103,'S18_2949',27,92.19E0,12)
INSERT INTO ORDERDETAILS VALUES(16,10103,'S18_2957',35,61.84E0,14)
INSERT INTO ORDERDETAILS VALUES(17,10103,'S18_3136',25,86.92E0,13)
INSERT INTO ORDERDETAILS VALUES(18,10103,'S18_3320',46,86.31E0,16)
INSERT INTO ORDERDETAILS VALUES(19,10103,'S18_4600',36,98.07E0,5)
INSERT INTO ORDERDETAILS VALUES(20,10103,'S18_4668',41,40.75E0,9)
INSERT INTO ORDERDETAILS VALUES(21,10103,'S24_2300',36,107.34E0,1)
INSERT INTO ORDERDETAILS VALUES(22,10103,'S24_4258',25,88.62E0,15)
INSERT INTO ORDERDETAILS VALUES(23,10103,'S32_1268',31,92.46E0,3)
INSERT INTO ORDERDETAILS VALUES(24,10103,'S32_3522',45,63.35E0,7)
INSERT INTO ORDERDETAILS VALUES(25,10103,'S700_2824',42,94.07E0,6)
INSERT INTO ORDERDETAILS VALUES(26,10104,'S12_3148',34,131.44E0,1)
INSERT INTO ORDERDETAILS VALUES(27,10104,'S12_4473',41,111.39E0,9)
INSERT INTO ORDERDETAILS VALUES(28,10104,'S18_2238',24,135.9E0,8)
INSERT INTO ORDERDETAILS VALUES(29,10104,'S18_2319',29,122.73E0,12)
INSERT INTO ORDERDETAILS VALUES(30,10104,'S18_3232',23,165.95E0,13)
INSERT INTO ORDERDETAILS VALUES(31,10104,'S18_4027',38,119.2E0,3)
INSERT INTO ORDERDETAILS VALUES(32,10104,'S24_1444',35,52.02E0,6)
INSERT INTO ORDERDETAILS VALUES(33,10104,'S24_2840',44,30.41E0,10)
INSERT INTO ORDERDETAILS VALUES(34,10104,'S24_4048',26,106.45E0,5)
INSERT INTO ORDERDETAILS VALUES(35,10104,'S32_2509',35,51.95E0,11)
INSERT INTO ORDERDETAILS VALUES(36,10104,'S32_3207',49,56.55E0,4)
INSERT INTO ORDERDETAILS VALUES(37,10104,'S50_1392',33,114.59E0,7)
INSERT INTO ORDERDETAILS VALUES(38,10104,'S50_1514',32,53.31E0,2)
INSERT INTO ORDERDETAILS VALUES(39,10105,'S10_4757',50,127.84E0,2)
INSERT INTO ORDERDETAILS VALUES(40,10105,'S12_1108',41,205.72E0,15)
INSERT INTO ORDERDETAILS VALUES(41,10105,'S12_3891',29,141.88E0,14)
INSERT INTO ORDERDETAILS VALUES(42,10105,'S18_3140',22,136.59E0,11)
INSERT INTO ORDERDETAILS VALUES(43,10105,'S18_3259',38,87.73E0,13)
INSERT INTO ORDERDETAILS VALUES(44,10105,'S18_4522',41,75.48E0,10)
INSERT INTO ORDERDETAILS VALUES(45,10105,'S24_2011',43,117.97E0,9)
INSERT INTO ORDERDETAILS VALUES(46,10105,'S24_3151',44,73.46E0,4)
INSERT INTO ORDERDETAILS VALUES(47,10105,'S24_3816',50,75.47E0,1)
INSERT INTO ORDERDETAILS VALUES(48,10105,'S700_1138',41,54.0E0,5)
INSERT INTO ORDERDETAILS VALUES(49,10105,'S700_1938',29,86.61E0,12)
INSERT INTO ORDERDETAILS VALUES(50,10105,'S700_2610',31,60.72E0,3)
INSERT INTO ORDERDETAILS VALUES(51,10105,'S700_3505',39,92.16E0,6)
INSERT INTO ORDERDETAILS VALUES(52,10105,'S700_3962',22,99.31E0,7)
INSERT INTO ORDERDETAILS VALUES(53,10105,'S72_3212',25,44.77E0,8)
INSERT INTO ORDERDETAILS VALUES(54,10106,'S18_1662',36,134.04E0,12)
INSERT INTO ORDERDETAILS VALUES(55,10106,'S18_2581',34,81.1E0,2)
INSERT INTO ORDERDETAILS VALUES(56,10106,'S18_3029',41,80.86E0,18)
INSERT INTO ORDERDETAILS VALUES(57,10106,'S18_3856',41,94.22E0,17)
INSERT INTO ORDERDETAILS VALUES(58,10106,'S24_1785',28,107.23E0,4)
INSERT INTO ORDERDETAILS VALUES(59,10106,'S24_2841',49,65.77E0,13)
INSERT INTO ORDERDETAILS VALUES(60,10106,'S24_3420',31,55.89E0,14)
INSERT INTO ORDERDETAILS VALUES(61,10106,'S24_3949',50,55.96E0,11)
INSERT INTO ORDERDETAILS VALUES(62,10106,'S24_4278',26,71.0E0,3)
INSERT INTO ORDERDETAILS VALUES(63,10106,'S32_4289',33,65.35E0,5)
INSERT INTO ORDERDETAILS VALUES(64,10106,'S50_1341',39,35.78E0,6)
INSERT INTO ORDERDETAILS VALUES(65,10106,'S700_1691',31,91.34E0,7)
INSERT INTO ORDERDETAILS VALUES(66,10106,'S700_2047',30,85.09E0,16)
INSERT INTO ORDERDETAILS VALUES(67,10106,'S700_2466',34,99.72E0,9)
INSERT INTO ORDERDETAILS VALUES(68,10106,'S700_2834',32,113.9E0,1)
INSERT INTO ORDERDETAILS VALUES(69,10106,'S700_3167',44,76.0E0,8)
INSERT INTO ORDERDETAILS VALUES(70,10106,'S700_4002',48,70.33E0,10)
INSERT INTO ORDERDETAILS VALUES(71,10106,'S72_1253',48,43.7E0,15)
INSERT INTO ORDERDETAILS VALUES(72,10107,'S10_1678',30,81.35E0,2)
INSERT INTO ORDERDETAILS VALUES(73,10107,'S10_2016',39,105.86E0,5)
INSERT INTO ORDERDETAILS VALUES(74,10107,'S10_4698',27,172.36E0,4)
INSERT INTO ORDERDETAILS VALUES(75,10107,'S12_2823',21,122.0E0,1)
INSERT INTO ORDERDETAILS VALUES(76,10107,'S18_2625',29,52.7E0,6)
INSERT INTO ORDERDETAILS VALUES(77,10107,'S24_1578',25,96.92E0,3)
INSERT INTO ORDERDETAILS VALUES(78,10107,'S24_2000',38,73.12E0,7)
INSERT INTO ORDERDETAILS VALUES(79,10107,'S32_1374',20,88.9E0,8)
INSERT INTO ORDERDETAILS VALUES(80,10108,'S12_1099',33,165.38E0,6)
INSERT INTO ORDERDETAILS VALUES(81,10108,'S12_3380',45,96.3E0,4)
INSERT INTO ORDERDETAILS VALUES(82,10108,'S12_3990',39,75.81E0,7)
INSERT INTO ORDERDETAILS VALUES(83,10108,'S12_4675',36,107.1E0,3)
INSERT INTO ORDERDETAILS VALUES(84,10108,'S18_1889',38,67.76E0,2)
INSERT INTO ORDERDETAILS VALUES(85,10108,'S18_3278',26,73.17E0,9)
INSERT INTO ORDERDETAILS VALUES(86,10108,'S18_3482',29,132.29E0,8)
INSERT INTO ORDERDETAILS VALUES(87,10108,'S18_3782',43,52.84E0,12)
INSERT INTO ORDERDETAILS VALUES(88,10108,'S18_4721',44,139.87E0,11)
INSERT INTO ORDERDETAILS VALUES(89,10108,'S24_2360',35,64.41E0,15)
INSERT INTO ORDERDETAILS VALUES(90,10108,'S24_3371',30,60.01E0,5)
INSERT INTO ORDERDETAILS VALUES(91,10108,'S24_3856',40,132.0E0,1)
INSERT INTO ORDERDETAILS VALUES(92,10108,'S24_4620',31,67.1E0,10)
INSERT INTO ORDERDETAILS VALUES(93,10108,'S32_2206',27,36.21E0,13)
INSERT INTO ORDERDETAILS VALUES(94,10108,'S32_4485',31,87.76E0,16)
INSERT INTO ORDERDETAILS VALUES(95,10108,'S50_4713',34,74.85E0,14)
INSERT INTO ORDERDETAILS VALUES(96,10109,'S18_1129',26,117.48E0,4)
INSERT INTO ORDERDETAILS VALUES(97,10109,'S18_1984',38,137.98E0,3)
INSERT INTO ORDERDETAILS VALUES(98,10109,'S18_2870',26,126.72E0,1)
INSERT INTO ORDERDETAILS VALUES(99,10109,'S18_3232',46,160.87E0,5)
INSERT INTO ORDERDETAILS VALUES(100,10109,'S18_3685',47,125.74E0,2)
INSERT INTO ORDERDETAILS VALUES(101,10109,'S24_2972',29,32.1E0,6)
INSERT INTO ORDERDETAILS VALUES(102,10110,'S18_1589',37,118.22E0,16)
INSERT INTO ORDERDETAILS VALUES(103,10110,'S18_1749',42,153.0E0,7)
INSERT INTO ORDERDETAILS VALUES(104,10110,'S18_2248',32,51.46E0,6)
INSERT INTO ORDERDETAILS VALUES(105,10110,'S18_2325',33,115.69E0,4)
INSERT INTO ORDERDETAILS VALUES(106,10110,'S18_2795',31,163.69E0,1)
INSERT INTO ORDERDETAILS VALUES(107,10110,'S18_4409',28,81.91E0,8)
INSERT INTO ORDERDETAILS VALUES(108,10110,'S18_4933',42,62.0E0,9)
INSERT INTO ORDERDETAILS VALUES(109,10110,'S24_1046',36,72.02E0,13)
INSERT INTO ORDERDETAILS VALUES(110,10110,'S24_1628',29,43.27E0,15)
INSERT INTO ORDERDETAILS VALUES(111,10110,'S24_1937',20,28.88E0,3)
INSERT INTO ORDERDETAILS VALUES(112,10110,'S24_2022',39,40.77E0,2)
INSERT INTO ORDERDETAILS VALUES(113,10110,'S24_2766',43,82.69E0,11)
INSERT INTO ORDERDETAILS VALUES(114,10110,'S24_2887',46,112.74E0,10)
INSERT INTO ORDERDETAILS VALUES(115,10110,'S24_3191',27,80.47E0,12)
INSERT INTO ORDERDETAILS VALUES(116,10110,'S24_3432',37,96.37E0,14)
INSERT INTO ORDERDETAILS VALUES(117,10110,'S24_3969',48,35.29E0,5)
INSERT INTO ORDERDETAILS VALUES(118,10111,'S18_1342',33,87.33E0,6)
INSERT INTO ORDERDETAILS VALUES(119,10111,'S18_1367',48,48.52E0,5)
INSERT INTO ORDERDETAILS VALUES(120,10111,'S18_2957',28,53.09E0,2)
INSERT INTO ORDERDETAILS VALUES(121,10111,'S18_3136',43,94.25E0,1)
INSERT INTO ORDERDETAILS VALUES(122,10111,'S18_3320',39,91.27E0,4)
INSERT INTO ORDERDETAILS VALUES(123,10111,'S24_4258',26,85.7E0,3)
INSERT INTO ORDERDETAILS VALUES(124,10112,'S10_1949',29,197.16E0,1)
INSERT INTO ORDERDETAILS VALUES(125,10112,'S18_2949',23,85.1E0,2)
INSERT INTO ORDERDETAILS VALUES(126,10113,'S12_1666',21,121.64E0,2)
INSERT INTO ORDERDETAILS VALUES(127,10113,'S18_1097',49,101.5E0,4)
INSERT INTO ORDERDETAILS VALUES(128,10113,'S18_4668',50,43.27E0,3)
INSERT INTO ORDERDETAILS VALUES(129,10113,'S32_3522',23,58.82E0,1)
INSERT INTO ORDERDETAILS VALUES(130,10114,'S10_4962',31,128.53E0,8)
INSERT INTO ORDERDETAILS VALUES(131,10114,'S18_2319',39,106.78E0,3)
INSERT INTO ORDERDETAILS VALUES(132,10114,'S18_2432',45,53.48E0,6)
INSERT INTO ORDERDETAILS VALUES(133,10114,'S18_3232',48,169.34E0,4)
INSERT INTO ORDERDETAILS VALUES(134,10114,'S18_4600',41,105.34E0,9)
INSERT INTO ORDERDETAILS VALUES(135,10114,'S24_2300',21,102.23E0,5)
INSERT INTO ORDERDETAILS VALUES(136,10114,'S24_2840',24,28.64E0,1)
INSERT INTO ORDERDETAILS VALUES(137,10114,'S32_1268',32,88.61E0,7)
INSERT INTO ORDERDETAILS VALUES(138,10114,'S32_2509',28,43.83E0,2)
INSERT INTO ORDERDETAILS VALUES(139,10114,'S700_2824',42,82.94E0,10)
INSERT INTO ORDERDETAILS VALUES(140,10115,'S12_4473',46,111.39E0,5)
INSERT INTO ORDERDETAILS VALUES(141,10115,'S18_2238',46,140.81E0,4)
INSERT INTO ORDERDETAILS VALUES(142,10115,'S24_1444',47,56.64E0,2)
INSERT INTO ORDERDETAILS VALUES(143,10115,'S24_4048',44,106.45E0,1)
INSERT INTO ORDERDETAILS VALUES(144,10115,'S50_1392',27,100.7E0,3)
INSERT INTO ORDERDETAILS VALUES(145,10116,'S32_3207',27,60.28E0,1)
INSERT INTO ORDERDETAILS VALUES(146,10117,'S12_1108',33,195.33E0,9)
INSERT INTO ORDERDETAILS VALUES(147,10117,'S12_3148',43,148.06E0,10)
INSERT INTO ORDERDETAILS VALUES(148,10117,'S12_3891',39,173.02E0,8)
INSERT INTO ORDERDETAILS VALUES(149,10117,'S18_3140',26,121.57E0,5)
INSERT INTO ORDERDETAILS VALUES(150,10117,'S18_3259',21,81.68E0,7)
INSERT INTO ORDERDETAILS VALUES(151,10117,'S18_4027',22,122.08E0,12)
INSERT INTO ORDERDETAILS VALUES(152,10117,'S18_4522',23,73.73E0,4)
INSERT INTO ORDERDETAILS VALUES(153,10117,'S24_2011',41,119.2E0,3)
INSERT INTO ORDERDETAILS VALUES(154,10117,'S50_1514',21,55.65E0,11)
INSERT INTO ORDERDETAILS VALUES(155,10117,'S700_1938',38,75.35E0,6)
INSERT INTO ORDERDETAILS VALUES(156,10117,'S700_3962',45,89.38E0,1)
INSERT INTO ORDERDETAILS VALUES(157,10117,'S72_3212',50,52.42E0,2)
INSERT INTO ORDERDETAILS VALUES(158,10118,'S700_3505',36,86.15E0,1)
INSERT INTO ORDERDETAILS VALUES(159,10119,'S10_4757',46,112.88E0,11)
INSERT INTO ORDERDETAILS VALUES(160,10119,'S18_1662',43,151.38E0,3)
INSERT INTO ORDERDETAILS VALUES(161,10119,'S18_3029',21,74.84E0,9)
INSERT INTO ORDERDETAILS VALUES(162,10119,'S18_3856',27,95.28E0,8)
INSERT INTO ORDERDETAILS VALUES(163,10119,'S24_2841',41,64.4E0,4)
INSERT INTO ORDERDETAILS VALUES(164,10119,'S24_3151',35,72.58E0,13)
INSERT INTO ORDERDETAILS VALUES(165,10119,'S24_3420',20,63.12E0,5)
INSERT INTO ORDERDETAILS VALUES(166,10119,'S24_3816',35,82.18E0,10)
INSERT INTO ORDERDETAILS VALUES(167,10119,'S24_3949',28,62.1E0,2)
INSERT INTO ORDERDETAILS VALUES(168,10119,'S700_1138',25,57.34E0,14)
INSERT INTO ORDERDETAILS VALUES(169,10119,'S700_2047',29,74.23E0,7)
INSERT INTO ORDERDETAILS VALUES(170,10119,'S700_2610',38,67.22E0,12)
INSERT INTO ORDERDETAILS VALUES(171,10119,'S700_4002',26,63.67E0,1)
INSERT INTO ORDERDETAILS VALUES(172,10119,'S72_1253',28,40.22E0,6)
INSERT INTO ORDERDETAILS VALUES(173,10120,'S10_2016',29,118.94E0,3)
INSERT INTO ORDERDETAILS VALUES(174,10120,'S10_4698',46,158.8E0,2)
INSERT INTO ORDERDETAILS VALUES(175,10120,'S18_2581',29,82.79E0,8)
INSERT INTO ORDERDETAILS VALUES(176,10120,'S18_2625',46,57.54E0,4)
INSERT INTO ORDERDETAILS VALUES(177,10120,'S24_1578',35,110.45E0,1)
INSERT INTO ORDERDETAILS VALUES(178,10120,'S24_1785',39,93.01E0,10)
INSERT INTO ORDERDETAILS VALUES(179,10120,'S24_2000',34,72.36E0,5)
INSERT INTO ORDERDETAILS VALUES(180,10120,'S24_4278',29,71.73E0,9)
INSERT INTO ORDERDETAILS VALUES(181,10120,'S32_1374',22,94.9E0,6)
INSERT INTO ORDERDETAILS VALUES(182,10120,'S32_4289',29,68.79E0,11)
INSERT INTO ORDERDETAILS VALUES(183,10120,'S50_1341',49,41.46E0,12)
INSERT INTO ORDERDETAILS VALUES(184,10120,'S700_1691',47,91.34E0,13)
INSERT INTO ORDERDETAILS VALUES(185,10120,'S700_2466',24,81.77E0,15)
INSERT INTO ORDERDETAILS VALUES(186,10120,'S700_2834',24,106.79E0,7)
INSERT INTO ORDERDETAILS VALUES(187,10120,'S700_3167',43,72.0E0,14)
INSERT INTO ORDERDETAILS VALUES(188,10121,'S10_1678',34,86.13E0,5)
INSERT INTO ORDERDETAILS VALUES(189,10121,'S12_2823',50,126.52E0,4)
INSERT INTO ORDERDETAILS VALUES(190,10121,'S24_2360',32,58.18E0,2)
INSERT INTO ORDERDETAILS VALUES(191,10121,'S32_4485',25,95.93E0,3)
INSERT INTO ORDERDETAILS VALUES(192,10121,'S50_4713',44,72.41E0,1)
INSERT INTO ORDERDETAILS VALUES(193,10122,'S12_1099',42,155.66E0,10)
INSERT INTO ORDERDETAILS VALUES(194,10122,'S12_3380',37,113.92E0,8)
INSERT INTO ORDERDETAILS VALUES(195,10122,'S12_3990',32,65.44E0,11)
INSERT INTO ORDERDETAILS VALUES(196,10122,'S12_4675',20,104.8E0,7)
INSERT INTO ORDERDETAILS VALUES(197,10122,'S18_1129',34,114.65E0,2)
INSERT INTO ORDERDETAILS VALUES(198,10122,'S18_1889',43,62.37E0,6)
INSERT INTO ORDERDETAILS VALUES(199,10122,'S18_1984',31,113.8E0,1)
INSERT INTO ORDERDETAILS VALUES(200,10122,'S18_3232',25,137.17E0,3)
INSERT INTO ORDERDETAILS VALUES(201,10122,'S18_3278',21,69.15E0,13)
INSERT INTO ORDERDETAILS VALUES(202,10122,'S18_3482',21,133.76E0,12)
INSERT INTO ORDERDETAILS VALUES(203,10122,'S18_3782',35,59.06E0,16)
INSERT INTO ORDERDETAILS VALUES(204,10122,'S18_4721',28,145.82E0,15)
INSERT INTO ORDERDETAILS VALUES(205,10122,'S24_2972',39,34.74E0,4)
INSERT INTO ORDERDETAILS VALUES(206,10122,'S24_3371',34,50.82E0,9)
INSERT INTO ORDERDETAILS VALUES(207,10122,'S24_3856',43,136.22E0,5)
INSERT INTO ORDERDETAILS VALUES(208,10122,'S24_4620',29,67.1E0,14)
INSERT INTO ORDERDETAILS VALUES(209,10122,'S32_2206',31,33.79E0,17)
INSERT INTO ORDERDETAILS VALUES(210,10123,'S18_1589',26,120.71E0,2)
INSERT INTO ORDERDETAILS VALUES(211,10123,'S18_2870',46,114.84E0,3)
INSERT INTO ORDERDETAILS VALUES(212,10123,'S18_3685',34,117.26E0,4)
INSERT INTO ORDERDETAILS VALUES(213,10123,'S24_1628',50,43.27E0,1)
INSERT INTO ORDERDETAILS VALUES(214,10124,'S18_1749',21,153.0E0,6)
INSERT INTO ORDERDETAILS VALUES(215,10124,'S18_2248',42,58.12E0,5)
INSERT INTO ORDERDETAILS VALUES(216,10124,'S18_2325',42,111.87E0,3)
INSERT INTO ORDERDETAILS VALUES(217,10124,'S18_4409',36,75.46E0,7)
INSERT INTO ORDERDETAILS VALUES(218,10124,'S18_4933',23,66.28E0,8)
INSERT INTO ORDERDETAILS VALUES(219,10124,'S24_1046',22,62.47E0,12)
INSERT INTO ORDERDETAILS VALUES(220,10124,'S24_1937',45,30.53E0,2)
INSERT INTO ORDERDETAILS VALUES(221,10124,'S24_2022',22,36.29E0,1)
INSERT INTO ORDERDETAILS VALUES(222,10124,'S24_2766',32,74.51E0,10)
INSERT INTO ORDERDETAILS VALUES(223,10124,'S24_2887',25,93.95E0,9)
INSERT INTO ORDERDETAILS VALUES(224,10124,'S24_3191',49,76.19E0,11)
INSERT INTO ORDERDETAILS VALUES(225,10124,'S24_3432',43,101.73E0,13)
INSERT INTO ORDERDETAILS VALUES(226,10124,'S24_3969',46,36.11E0,4)
INSERT INTO ORDERDETAILS VALUES(227,10125,'S18_1342',32,89.38E0,1)
INSERT INTO ORDERDETAILS VALUES(228,10125,'S18_2795',34,138.38E0,2)
INSERT INTO ORDERDETAILS VALUES(229,10126,'S10_1949',38,205.73E0,11)
INSERT INTO ORDERDETAILS VALUES(230,10126,'S10_4962',22,122.62E0,4)
INSERT INTO ORDERDETAILS VALUES(231,10126,'S12_1666',21,135.3E0,8)
INSERT INTO ORDERDETAILS VALUES(232,10126,'S18_1097',38,116.67E0,10)
INSERT INTO ORDERDETAILS VALUES(233,10126,'S18_1367',42,51.21E0,17)
INSERT INTO ORDERDETAILS VALUES(234,10126,'S18_2432',43,51.05E0,2)
INSERT INTO ORDERDETAILS VALUES(235,10126,'S18_2949',31,93.21E0,12)
INSERT INTO ORDERDETAILS VALUES(236,10126,'S18_2957',46,61.84E0,14)
INSERT INTO ORDERDETAILS VALUES(237,10126,'S18_3136',30,93.2E0,13)
INSERT INTO ORDERDETAILS VALUES(238,10126,'S18_3320',38,94.25E0,16)
INSERT INTO ORDERDETAILS VALUES(239,10126,'S18_4600',50,102.92E0,5)
INSERT INTO ORDERDETAILS VALUES(240,10126,'S18_4668',43,47.29E0,9)
INSERT INTO ORDERDETAILS VALUES(241,10126,'S24_2300',27,122.68E0,1)
INSERT INTO ORDERDETAILS VALUES(242,10126,'S24_4258',34,83.76E0,15)
INSERT INTO ORDERDETAILS VALUES(243,10126,'S32_1268',43,82.83E0,3)
INSERT INTO ORDERDETAILS VALUES(244,10126,'S32_3522',26,62.05E0,7)
INSERT INTO ORDERDETAILS VALUES(245,10126,'S700_2824',45,97.1E0,6)
INSERT INTO ORDERDETAILS VALUES(246,10127,'S12_1108',46,193.25E0,2)
INSERT INTO ORDERDETAILS VALUES(247,10127,'S12_3148',46,140.5E0,3)
INSERT INTO ORDERDETAILS VALUES(248,10127,'S12_3891',42,169.56E0,1)
INSERT INTO ORDERDETAILS VALUES(249,10127,'S12_4473',24,100.73E0,11)
INSERT INTO ORDERDETAILS VALUES(250,10127,'S18_2238',45,140.81E0,10)
INSERT INTO ORDERDETAILS VALUES(251,10127,'S18_2319',45,114.14E0,14)
INSERT INTO ORDERDETAILS VALUES(252,10127,'S18_3232',22,149.02E0,15)
INSERT INTO ORDERDETAILS VALUES(253,10127,'S18_4027',25,126.39E0,5)
INSERT INTO ORDERDETAILS VALUES(254,10127,'S24_1444',20,50.86E0,8)
INSERT INTO ORDERDETAILS VALUES(255,10127,'S24_2840',39,34.3E0,12)
INSERT INTO ORDERDETAILS VALUES(256,10127,'S24_4048',20,107.63E0,7)
INSERT INTO ORDERDETAILS VALUES(257,10127,'S32_2509',45,46.53E0,13)
INSERT INTO ORDERDETAILS VALUES(258,10127,'S32_3207',29,60.9E0,6)
INSERT INTO ORDERDETAILS VALUES(259,10127,'S50_1392',46,111.12E0,9)
INSERT INTO ORDERDETAILS VALUES(260,10127,'S50_1514',46,55.65E0,4)
INSERT INTO ORDERDETAILS VALUES(261,10128,'S18_3140',41,120.2E0,2)
INSERT INTO ORDERDETAILS VALUES(262,10128,'S18_3259',41,80.67E0,4)
INSERT INTO ORDERDETAILS VALUES(263,10128,'S18_4522',43,77.24E0,1)
INSERT INTO ORDERDETAILS VALUES(264,10128,'S700_1938',32,72.75E0,3)
INSERT INTO ORDERDETAILS VALUES(265,10129,'S10_4757',33,123.76E0,2)
INSERT INTO ORDERDETAILS VALUES(266,10129,'S24_2011',45,113.06E0,9)
INSERT INTO ORDERDETAILS VALUES(267,10129,'S24_3151',41,81.43E0,4)
INSERT INTO ORDERDETAILS VALUES(268,10129,'S24_3816',50,76.31E0,1)
INSERT INTO ORDERDETAILS VALUES(269,10129,'S700_1138',31,58.67E0,5)
INSERT INTO ORDERDETAILS VALUES(270,10129,'S700_2610',45,72.28E0,3)
INSERT INTO ORDERDETAILS VALUES(271,10129,'S700_3505',42,90.15E0,6)
INSERT INTO ORDERDETAILS VALUES(272,10129,'S700_3962',30,94.34E0,7)
INSERT INTO ORDERDETAILS VALUES(273,10129,'S72_3212',32,44.23E0,8)
INSERT INTO ORDERDETAILS VALUES(274,10130,'S18_3029',40,68.82E0,2)
INSERT INTO ORDERDETAILS VALUES(275,10130,'S18_3856',33,99.52E0,1)
INSERT INTO ORDERDETAILS VALUES(276,10131,'S18_1662',21,141.92E0,4)
INSERT INTO ORDERDETAILS VALUES(277,10131,'S24_2841',35,60.97E0,5)
INSERT INTO ORDERDETAILS VALUES(278,10131,'S24_3420',29,52.6E0,6)
INSERT INTO ORDERDETAILS VALUES(279,10131,'S24_3949',50,54.59E0,3)
INSERT INTO ORDERDETAILS VALUES(280,10131,'S700_2047',22,76.94E0,8)
INSERT INTO ORDERDETAILS VALUES(281,10131,'S700_2466',40,86.76E0,1)
INSERT INTO ORDERDETAILS VALUES(282,10131,'S700_4002',26,63.67E0,2)
INSERT INTO ORDERDETAILS VALUES(283,10131,'S72_1253',21,40.22E0,7)
INSERT INTO ORDERDETAILS VALUES(284,10132,'S700_3167',36,80.0E0,1)
INSERT INTO ORDERDETAILS VALUES(285,10133,'S18_2581',49,80.26E0,3)
INSERT INTO ORDERDETAILS VALUES(286,10133,'S24_1785',41,109.42E0,5)
INSERT INTO ORDERDETAILS VALUES(287,10133,'S24_4278',46,61.58E0,4)
INSERT INTO ORDERDETAILS VALUES(288,10133,'S32_1374',23,80.91E0,1)
INSERT INTO ORDERDETAILS VALUES(289,10133,'S32_4289',49,67.41E0,6)
INSERT INTO ORDERDETAILS VALUES(290,10133,'S50_1341',27,37.09E0,7)
INSERT INTO ORDERDETAILS VALUES(291,10133,'S700_1691',24,76.73E0,8)
INSERT INTO ORDERDETAILS VALUES(292,10133,'S700_2834',27,115.09E0,2)
INSERT INTO ORDERDETAILS VALUES(293,10134,'S10_1678',41,90.92E0,2)
INSERT INTO ORDERDETAILS VALUES(294,10134,'S10_2016',27,116.56E0,5)
INSERT INTO ORDERDETAILS VALUES(295,10134,'S10_4698',31,187.85E0,4)
INSERT INTO ORDERDETAILS VALUES(296,10134,'S12_2823',20,131.04E0,1)
INSERT INTO ORDERDETAILS VALUES(297,10134,'S18_2625',30,51.48E0,6)
INSERT INTO ORDERDETAILS VALUES(298,10134,'S24_1578',35,94.67E0,3)
INSERT INTO ORDERDETAILS VALUES(299,10134,'S24_2000',43,75.41E0,7)
INSERT INTO ORDERDETAILS VALUES(300,10135,'S12_1099',42,173.17E0,7)
INSERT INTO ORDERDETAILS VALUES(301,10135,'S12_3380',48,110.39E0,5)
INSERT INTO ORDERDETAILS VALUES(302,10135,'S12_3990',24,72.62E0,8)
INSERT INTO ORDERDETAILS VALUES(303,10135,'S12_4675',29,103.64E0,4)
INSERT INTO ORDERDETAILS VALUES(304,10135,'S18_1889',48,66.99E0,3)
INSERT INTO ORDERDETAILS VALUES(305,10135,'S18_3278',45,65.94E0,10)
INSERT INTO ORDERDETAILS VALUES(306,10135,'S18_3482',42,139.64E0,9)
INSERT INTO ORDERDETAILS VALUES(307,10135,'S18_3782',45,49.74E0,13)
INSERT INTO ORDERDETAILS VALUES(308,10135,'S18_4721',31,133.92E0,12)
INSERT INTO ORDERDETAILS VALUES(309,10135,'S24_2360',29,67.18E0,16)
INSERT INTO ORDERDETAILS VALUES(310,10135,'S24_2972',20,34.36E0,1)
INSERT INTO ORDERDETAILS VALUES(311,10135,'S24_3371',27,52.05E0,6)
INSERT INTO ORDERDETAILS VALUES(312,10135,'S24_3856',47,139.03E0,2)
INSERT INTO ORDERDETAILS VALUES(313,10135,'S24_4620',23,76.8E0,11)
INSERT INTO ORDERDETAILS VALUES(314,10135,'S32_2206',33,38.62E0,14)
INSERT INTO ORDERDETAILS VALUES(315,10135,'S32_4485',30,91.85E0,17)
INSERT INTO ORDERDETAILS VALUES(316,10135,'S50_4713',44,78.92E0,15)
INSERT INTO ORDERDETAILS VALUES(317,10136,'S18_1129',25,117.48E0,2)
INSERT INTO ORDERDETAILS VALUES(318,10136,'S18_1984',36,120.91E0,1)
INSERT INTO ORDERDETAILS VALUES(319,10136,'S18_3232',41,169.34E0,3)
INSERT INTO ORDERDETAILS VALUES(320,10137,'S18_1589',44,115.73E0,2)
INSERT INTO ORDERDETAILS VALUES(321,10137,'S18_2870',37,110.88E0,3)
INSERT INTO ORDERDETAILS VALUES(322,10137,'S18_3685',31,118.68E0,4)
INSERT INTO ORDERDETAILS VALUES(323,10137,'S24_1628',26,40.25E0,1)
INSERT INTO ORDERDETAILS VALUES(324,10138,'S18_1749',33,149.6E0,6)
INSERT INTO ORDERDETAILS VALUES(325,10138,'S18_2248',22,51.46E0,5)
INSERT INTO ORDERDETAILS VALUES(326,10138,'S18_2325',38,114.42E0,3)
INSERT INTO ORDERDETAILS VALUES(327,10138,'S18_4409',47,79.15E0,7)
INSERT INTO ORDERDETAILS VALUES(328,10138,'S18_4933',23,64.86E0,8)
INSERT INTO ORDERDETAILS VALUES(329,10138,'S24_1046',45,59.53E0,12)
INSERT INTO ORDERDETAILS VALUES(330,10138,'S24_1937',22,33.19E0,2)
INSERT INTO ORDERDETAILS VALUES(331,10138,'S24_2022',33,38.53E0,1)
INSERT INTO ORDERDETAILS VALUES(332,10138,'S24_2766',28,73.6E0,10)
INSERT INTO ORDERDETAILS VALUES(333,10138,'S24_2887',30,96.3E0,9)
INSERT INTO ORDERDETAILS VALUES(334,10138,'S24_3191',49,77.05E0,11)
INSERT INTO ORDERDETAILS VALUES(335,10138,'S24_3432',21,99.58E0,13)
INSERT INTO ORDERDETAILS VALUES(336,10138,'S24_3969',29,32.82E0,4)
INSERT INTO ORDERDETAILS VALUES(337,10139,'S18_1342',31,89.38E0,7)
INSERT INTO ORDERDETAILS VALUES(338,10139,'S18_1367',49,52.83E0,6)
INSERT INTO ORDERDETAILS VALUES(339,10139,'S18_2795',41,151.88E0,8)
INSERT INTO ORDERDETAILS VALUES(340,10139,'S18_2949',46,91.18E0,1)
INSERT INTO ORDERDETAILS VALUES(341,10139,'S18_2957',20,52.47E0,3)
INSERT INTO ORDERDETAILS VALUES(342,10139,'S18_3136',20,101.58E0,2)
INSERT INTO ORDERDETAILS VALUES(343,10139,'S18_3320',30,81.35E0,5)
INSERT INTO ORDERDETAILS VALUES(344,10139,'S24_4258',29,93.49E0,4)
INSERT INTO ORDERDETAILS VALUES(345,10140,'S10_1949',37,186.44E0,11)
INSERT INTO ORDERDETAILS VALUES(346,10140,'S10_4962',26,131.49E0,4)
INSERT INTO ORDERDETAILS VALUES(347,10140,'S12_1666',38,118.9E0,8)
INSERT INTO ORDERDETAILS VALUES(348,10140,'S18_1097',32,95.67E0,10)
INSERT INTO ORDERDETAILS VALUES(349,10140,'S18_2432',46,51.05E0,2)
INSERT INTO ORDERDETAILS VALUES(350,10140,'S18_4600',40,100.5E0,5)
INSERT INTO ORDERDETAILS VALUES(351,10140,'S18_4668',29,40.25E0,9)
INSERT INTO ORDERDETAILS VALUES(352,10140,'S24_2300',47,118.84E0,1)
INSERT INTO ORDERDETAILS VALUES(353,10140,'S32_1268',26,87.64E0,3)
INSERT INTO ORDERDETAILS VALUES(354,10140,'S32_3522',28,62.05E0,7)
INSERT INTO ORDERDETAILS VALUES(355,10140,'S700_2824',36,101.15E0,6)
INSERT INTO ORDERDETAILS VALUES(356,10141,'S12_4473',21,114.95E0,5)
INSERT INTO ORDERDETAILS VALUES(357,10141,'S18_2238',39,160.46E0,4)
INSERT INTO ORDERDETAILS VALUES(358,10141,'S18_2319',47,103.09E0,8)
INSERT INTO ORDERDETAILS VALUES(359,10141,'S18_3232',34,143.94E0,9)
INSERT INTO ORDERDETAILS VALUES(360,10141,'S24_1444',20,50.86E0,2)
INSERT INTO ORDERDETAILS VALUES(361,10141,'S24_2840',21,32.18E0,6)
INSERT INTO ORDERDETAILS VALUES(362,10141,'S24_4048',40,104.09E0,1)
INSERT INTO ORDERDETAILS VALUES(363,10141,'S32_2509',24,53.03E0,7)
INSERT INTO ORDERDETAILS VALUES(364,10141,'S50_1392',44,94.92E0,3)
INSERT INTO ORDERDETAILS VALUES(365,10142,'S12_1108',33,166.24E0,12)
INSERT INTO ORDERDETAILS VALUES(366,10142,'S12_3148',33,140.5E0,13)
INSERT INTO ORDERDETAILS VALUES(367,10142,'S12_3891',46,167.83E0,11)
INSERT INTO ORDERDETAILS VALUES(368,10142,'S18_3140',47,129.76E0,8)
INSERT INTO ORDERDETAILS VALUES(369,10142,'S18_3259',22,95.8E0,10)
INSERT INTO ORDERDETAILS VALUES(370,10142,'S18_4027',24,122.08E0,15)
INSERT INTO ORDERDETAILS VALUES(371,10142,'S18_4522',24,79.87E0,7)
INSERT INTO ORDERDETAILS VALUES(372,10142,'S24_2011',33,114.29E0,6)
INSERT INTO ORDERDETAILS VALUES(373,10142,'S24_3151',49,74.35E0,1)
INSERT INTO ORDERDETAILS VALUES(374,10142,'S32_3207',42,60.9E0,16)
INSERT INTO ORDERDETAILS VALUES(375,10142,'S50_1514',42,56.24E0,14)
INSERT INTO ORDERDETAILS VALUES(376,10142,'S700_1138',41,55.34E0,2)
INSERT INTO ORDERDETAILS VALUES(377,10142,'S700_1938',43,77.08E0,9)
INSERT INTO ORDERDETAILS VALUES(378,10142,'S700_3505',21,92.16E0,3)
INSERT INTO ORDERDETAILS VALUES(379,10142,'S700_3962',38,91.37E0,4)
INSERT INTO ORDERDETAILS VALUES(380,10142,'S72_3212',39,46.96E0,5)
INSERT INTO ORDERDETAILS VALUES(381,10143,'S10_4757',49,133.28E0,15)
INSERT INTO ORDERDETAILS VALUES(382,10143,'S18_1662',32,126.15E0,7)
INSERT INTO ORDERDETAILS VALUES(383,10143,'S18_3029',46,70.54E0,13)
INSERT INTO ORDERDETAILS VALUES(384,10143,'S18_3856',34,99.52E0,12)
INSERT INTO ORDERDETAILS VALUES(385,10143,'S24_2841',27,63.71E0,8)
INSERT INTO ORDERDETAILS VALUES(386,10143,'S24_3420',33,59.83E0,9)
INSERT INTO ORDERDETAILS VALUES(387,10143,'S24_3816',23,74.64E0,14)
INSERT INTO ORDERDETAILS VALUES(388,10143,'S24_3949',28,55.96E0,6)
INSERT INTO ORDERDETAILS VALUES(389,10143,'S50_1341',34,34.91E0,1)
INSERT INTO ORDERDETAILS VALUES(390,10143,'S700_1691',36,86.77E0,2)
INSERT INTO ORDERDETAILS VALUES(391,10143,'S700_2047',26,87.8E0,11)
INSERT INTO ORDERDETAILS VALUES(392,10143,'S700_2466',26,79.78E0,4)
INSERT INTO ORDERDETAILS VALUES(393,10143,'S700_2610',31,69.39E0,16)
INSERT INTO ORDERDETAILS VALUES(394,10143,'S700_3167',28,70.4E0,3)
INSERT INTO ORDERDETAILS VALUES(395,10143,'S700_4002',34,65.15E0,5)
INSERT INTO ORDERDETAILS VALUES(396,10143,'S72_1253',37,49.66E0,10)
INSERT INTO ORDERDETAILS VALUES(397,10144,'S32_4289',20,56.41E0,1)
INSERT INTO ORDERDETAILS VALUES(398,10145,'S10_1678',45,76.56E0,6)
INSERT INTO ORDERDETAILS VALUES(399,10145,'S10_2016',37,104.67E0,9)
INSERT INTO ORDERDETAILS VALUES(400,10145,'S10_4698',33,154.93E0,8)
INSERT INTO ORDERDETAILS VALUES(401,10145,'S12_2823',49,146.1E0,5)
INSERT INTO ORDERDETAILS VALUES(402,10145,'S18_2581',30,71.81E0,14)
INSERT INTO ORDERDETAILS VALUES(403,10145,'S18_2625',30,52.7E0,10)
INSERT INTO ORDERDETAILS VALUES(404,10145,'S24_1578',43,103.68E0,7)
INSERT INTO ORDERDETAILS VALUES(405,10145,'S24_1785',40,87.54E0,16)
INSERT INTO ORDERDETAILS VALUES(406,10145,'S24_2000',47,63.98E0,11)
INSERT INTO ORDERDETAILS VALUES(407,10145,'S24_2360',27,56.1E0,3)
INSERT INTO ORDERDETAILS VALUES(408,10145,'S24_4278',33,71.73E0,15)
INSERT INTO ORDERDETAILS VALUES(409,10145,'S32_1374',33,99.89E0,12)
INSERT INTO ORDERDETAILS VALUES(410,10145,'S32_2206',31,39.43E0,1)
INSERT INTO ORDERDETAILS VALUES(411,10145,'S32_4485',27,95.93E0,4)
INSERT INTO ORDERDETAILS VALUES(412,10145,'S50_4713',38,73.22E0,2)
INSERT INTO ORDERDETAILS VALUES(413,10145,'S700_2834',20,113.9E0,13)
INSERT INTO ORDERDETAILS VALUES(414,10146,'S18_3782',47,60.3E0,2)
INSERT INTO ORDERDETAILS VALUES(415,10146,'S18_4721',29,130.94E0,1)
INSERT INTO ORDERDETAILS VALUES(416,10147,'S12_1099',48,161.49E0,7)
INSERT INTO ORDERDETAILS VALUES(417,10147,'S12_3380',31,110.39E0,5)
INSERT INTO ORDERDETAILS VALUES(418,10147,'S12_3990',21,74.21E0,8)
INSERT INTO ORDERDETAILS VALUES(419,10147,'S12_4675',33,97.89E0,4)
INSERT INTO ORDERDETAILS VALUES(420,10147,'S18_1889',26,70.84E0,3)
INSERT INTO ORDERDETAILS VALUES(421,10147,'S18_3278',36,74.78E0,10)
INSERT INTO ORDERDETAILS VALUES(422,10147,'S18_3482',37,129.35E0,9)
INSERT INTO ORDERDETAILS VALUES(423,10147,'S24_2972',25,33.23E0,1)
INSERT INTO ORDERDETAILS VALUES(424,10147,'S24_3371',30,48.98E0,6)
INSERT INTO ORDERDETAILS VALUES(425,10147,'S24_3856',23,123.58E0,2)
INSERT INTO ORDERDETAILS VALUES(426,10147,'S24_4620',31,72.76E0,11)
INSERT INTO ORDERDETAILS VALUES(427,10148,'S18_1129',23,114.65E0,13)
INSERT INTO ORDERDETAILS VALUES(428,10148,'S18_1589',47,108.26E0,9)
INSERT INTO ORDERDETAILS VALUES(429,10148,'S18_1984',25,136.56E0,12)
INSERT INTO ORDERDETAILS VALUES(430,10148,'S18_2870',27,113.52E0,10)
INSERT INTO ORDERDETAILS VALUES(431,10148,'S18_3232',32,143.94E0,14)
INSERT INTO ORDERDETAILS VALUES(432,10148,'S18_3685',28,135.63E0,11)
INSERT INTO ORDERDETAILS VALUES(433,10148,'S18_4409',34,83.75E0,1)
INSERT INTO ORDERDETAILS VALUES(434,10148,'S18_4933',29,66.28E0,2)
INSERT INTO ORDERDETAILS VALUES(435,10148,'S24_1046',25,65.41E0,6)
INSERT INTO ORDERDETAILS VALUES(436,10148,'S24_1628',47,46.29E0,8)
INSERT INTO ORDERDETAILS VALUES(437,10148,'S24_2766',21,77.24E0,4)
INSERT INTO ORDERDETAILS VALUES(438,10148,'S24_2887',34,115.09E0,3)
INSERT INTO ORDERDETAILS VALUES(439,10148,'S24_3191',31,71.91E0,5)
INSERT INTO ORDERDETAILS VALUES(440,10148,'S24_3432',27,96.37E0,7)
INSERT INTO ORDERDETAILS VALUES(441,10149,'S18_1342',50,87.33E0,4)
INSERT INTO ORDERDETAILS VALUES(442,10149,'S18_1367',30,48.52E0,3)
INSERT INTO ORDERDETAILS VALUES(443,10149,'S18_1749',34,156.4E0,11)
INSERT INTO ORDERDETAILS VALUES(444,10149,'S18_2248',24,50.85E0,10)
INSERT INTO ORDERDETAILS VALUES(445,10149,'S18_2325',33,125.86E0,8)
INSERT INTO ORDERDETAILS VALUES(446,10149,'S18_2795',23,167.06E0,5)
INSERT INTO ORDERDETAILS VALUES(447,10149,'S18_3320',42,89.29E0,2)
INSERT INTO ORDERDETAILS VALUES(448,10149,'S24_1937',36,31.2E0,7)
INSERT INTO ORDERDETAILS VALUES(449,10149,'S24_2022',49,39.87E0,6)
INSERT INTO ORDERDETAILS VALUES(450,10149,'S24_3969',26,38.57E0,9)
INSERT INTO ORDERDETAILS VALUES(451,10149,'S24_4258',20,90.57E0,1)
INSERT INTO ORDERDETAILS VALUES(452,10150,'S10_1949',45,182.16E0,8)
INSERT INTO ORDERDETAILS VALUES(453,10150,'S10_4962',20,121.15E0,1)
INSERT INTO ORDERDETAILS VALUES(454,10150,'S12_1666',30,135.3E0,5)
INSERT INTO ORDERDETAILS VALUES(455,10150,'S18_1097',34,95.67E0,7)
INSERT INTO ORDERDETAILS VALUES(456,10150,'S18_2949',47,93.21E0,9)
INSERT INTO ORDERDETAILS VALUES(457,10150,'S18_2957',30,56.21E0,11)
INSERT INTO ORDERDETAILS VALUES(458,10150,'S18_3136',26,97.39E0,10)
INSERT INTO ORDERDETAILS VALUES(459,10150,'S18_4600',49,111.39E0,2)
INSERT INTO ORDERDETAILS VALUES(460,10150,'S18_4668',30,47.29E0,6)
INSERT INTO ORDERDETAILS VALUES(461,10150,'S32_3522',49,62.05E0,4)
INSERT INTO ORDERDETAILS VALUES(462,10150,'S700_2824',20,95.08E0,3)
INSERT INTO ORDERDETAILS VALUES(463,10151,'S12_4473',24,114.95E0,3)
INSERT INTO ORDERDETAILS VALUES(464,10151,'S18_2238',43,152.27E0,2)
INSERT INTO ORDERDETAILS VALUES(465,10151,'S18_2319',49,106.78E0,6)
INSERT INTO ORDERDETAILS VALUES(466,10151,'S18_2432',39,58.34E0,9)
INSERT INTO ORDERDETAILS VALUES(467,10151,'S18_3232',21,167.65E0,7)
INSERT INTO ORDERDETAILS VALUES(468,10151,'S24_2300',42,109.9E0,8)
INSERT INTO ORDERDETAILS VALUES(469,10151,'S24_2840',30,29.35E0,4)
INSERT INTO ORDERDETAILS VALUES(470,10151,'S32_1268',27,84.75E0,10)
INSERT INTO ORDERDETAILS VALUES(471,10151,'S32_2509',41,43.29E0,5)
INSERT INTO ORDERDETAILS VALUES(472,10151,'S50_1392',26,108.81E0,1)
INSERT INTO ORDERDETAILS VALUES(473,10152,'S18_4027',35,117.77E0,1)
INSERT INTO ORDERDETAILS VALUES(474,10152,'S24_1444',25,49.13E0,4)
INSERT INTO ORDERDETAILS VALUES(475,10152,'S24_4048',23,112.37E0,3)
INSERT INTO ORDERDETAILS VALUES(476,10152,'S32_3207',33,57.17E0,2)
INSERT INTO ORDERDETAILS VALUES(477,10153,'S12_1108',20,201.57E0,11)
INSERT INTO ORDERDETAILS VALUES(478,10153,'S12_3148',42,128.42E0,12)
INSERT INTO ORDERDETAILS VALUES(479,10153,'S12_3891',49,155.72E0,10)
INSERT INTO ORDERDETAILS VALUES(480,10153,'S18_3140',31,125.66E0,7)
INSERT INTO ORDERDETAILS VALUES(481,10153,'S18_3259',29,82.69E0,9)
INSERT INTO ORDERDETAILS VALUES(482,10153,'S18_4522',22,82.5E0,6)
INSERT INTO ORDERDETAILS VALUES(483,10153,'S24_2011',40,111.83E0,5)
INSERT INTO ORDERDETAILS VALUES(484,10153,'S50_1514',31,53.31E0,13)
INSERT INTO ORDERDETAILS VALUES(485,10153,'S700_1138',43,58.0E0,1)
INSERT INTO ORDERDETAILS VALUES(486,10153,'S700_1938',31,80.55E0,8)
INSERT INTO ORDERDETAILS VALUES(487,10153,'S700_3505',50,87.15E0,2)
INSERT INTO ORDERDETAILS VALUES(488,10153,'S700_3962',20,85.41E0,3)
INSERT INTO ORDERDETAILS VALUES(489,10153,'S72_3212',50,51.87E0,4)
INSERT INTO ORDERDETAILS VALUES(490,10154,'S24_3151',31,75.23E0,2)
INSERT INTO ORDERDETAILS VALUES(491,10154,'S700_2610',36,59.27E0,1)
INSERT INTO ORDERDETAILS VALUES(492,10155,'S10_4757',32,129.2E0,13)
INSERT INTO ORDERDETAILS VALUES(493,10155,'S18_1662',38,138.77E0,5)
INSERT INTO ORDERDETAILS VALUES(494,10155,'S18_3029',44,83.44E0,11)
INSERT INTO ORDERDETAILS VALUES(495,10155,'S18_3856',29,105.87E0,10)
INSERT INTO ORDERDETAILS VALUES(496,10155,'S24_2841',23,62.34E0,6)
INSERT INTO ORDERDETAILS VALUES(497,10155,'S24_3420',34,56.55E0,7)
INSERT INTO ORDERDETAILS VALUES(498,10155,'S24_3816',37,76.31E0,12)
INSERT INTO ORDERDETAILS VALUES(499,10155,'S24_3949',44,58.69E0,4)
INSERT INTO ORDERDETAILS VALUES(500,10155,'S700_2047',32,89.61E0,9)
INSERT INTO ORDERDETAILS VALUES(501,10155,'S700_2466',20,87.75E0,2)
INSERT INTO ORDERDETAILS VALUES(502,10155,'S700_3167',43,76.8E0,1)
INSERT INTO ORDERDETAILS VALUES(503,10155,'S700_4002',44,70.33E0,3)
INSERT INTO ORDERDETAILS VALUES(504,10155,'S72_1253',34,49.16E0,8)
INSERT INTO ORDERDETAILS VALUES(505,10156,'S50_1341',20,43.64E0,1)
INSERT INTO ORDERDETAILS VALUES(506,10156,'S700_1691',48,77.64E0,2)
INSERT INTO ORDERDETAILS VALUES(507,10157,'S18_2581',33,69.27E0,3)
INSERT INTO ORDERDETAILS VALUES(508,10157,'S24_1785',40,89.72E0,5)
INSERT INTO ORDERDETAILS VALUES(509,10157,'S24_4278',33,66.65E0,4)
INSERT INTO ORDERDETAILS VALUES(510,10157,'S32_1374',34,83.91E0,1)
INSERT INTO ORDERDETAILS VALUES(511,10157,'S32_4289',28,56.41E0,6)
INSERT INTO ORDERDETAILS VALUES(512,10157,'S700_2834',48,109.16E0,2)
INSERT INTO ORDERDETAILS VALUES(513,10158,'S24_2000',22,67.79E0,1)
INSERT INTO ORDERDETAILS VALUES(514,10159,'S10_1678',49,81.35E0,14)
INSERT INTO ORDERDETAILS VALUES(515,10159,'S10_2016',37,101.1E0,17)
INSERT INTO ORDERDETAILS VALUES(516,10159,'S10_4698',22,170.42E0,16)
INSERT INTO ORDERDETAILS VALUES(517,10159,'S12_1099',41,188.73E0,2)
INSERT INTO ORDERDETAILS VALUES(518,10159,'S12_2823',38,131.04E0,13)
INSERT INTO ORDERDETAILS VALUES(519,10159,'S12_3990',24,67.03E0,3)
INSERT INTO ORDERDETAILS VALUES(520,10159,'S18_2625',42,51.48E0,18)
INSERT INTO ORDERDETAILS VALUES(521,10159,'S18_3278',21,66.74E0,5)
INSERT INTO ORDERDETAILS VALUES(522,10159,'S18_3482',25,129.35E0,4)
INSERT INTO ORDERDETAILS VALUES(523,10159,'S18_3782',21,54.71E0,8)
INSERT INTO ORDERDETAILS VALUES(524,10159,'S18_4721',32,142.85E0,7)
INSERT INTO ORDERDETAILS VALUES(525,10159,'S24_1578',44,100.3E0,15)
INSERT INTO ORDERDETAILS VALUES(526,10159,'S24_2360',27,67.18E0,11)
INSERT INTO ORDERDETAILS VALUES(527,10159,'S24_3371',50,49.6E0,1)
INSERT INTO ORDERDETAILS VALUES(528,10159,'S24_4620',23,80.84E0,6)
INSERT INTO ORDERDETAILS VALUES(529,10159,'S32_2206',35,39.43E0,9)
INSERT INTO ORDERDETAILS VALUES(530,10159,'S32_4485',23,86.74E0,12)
INSERT INTO ORDERDETAILS VALUES(531,10159,'S50_4713',31,78.11E0,10)
INSERT INTO ORDERDETAILS VALUES(532,10160,'S12_3380',46,96.3E0,6)
INSERT INTO ORDERDETAILS VALUES(533,10160,'S12_4675',50,93.28E0,5)
INSERT INTO ORDERDETAILS VALUES(534,10160,'S18_1889',38,70.84E0,4)
INSERT INTO ORDERDETAILS VALUES(535,10160,'S18_3232',20,140.55E0,1)
INSERT INTO ORDERDETAILS VALUES(536,10160,'S24_2972',42,30.59E0,2)
INSERT INTO ORDERDETAILS VALUES(537,10160,'S24_3856',35,130.6E0,3)
INSERT INTO ORDERDETAILS VALUES(538,10161,'S18_1129',28,121.72E0,12)
INSERT INTO ORDERDETAILS VALUES(539,10161,'S18_1589',43,102.04E0,8)
INSERT INTO ORDERDETAILS VALUES(540,10161,'S18_1984',48,139.41E0,11)
INSERT INTO ORDERDETAILS VALUES(541,10161,'S18_2870',23,125.4E0,9)
INSERT INTO ORDERDETAILS VALUES(542,10161,'S18_3685',36,132.8E0,10)
INSERT INTO ORDERDETAILS VALUES(543,10161,'S18_4933',25,62.72E0,1)
INSERT INTO ORDERDETAILS VALUES(544,10161,'S24_1046',37,73.49E0,5)
INSERT INTO ORDERDETAILS VALUES(545,10161,'S24_1628',23,47.29E0,7)
INSERT INTO ORDERDETAILS VALUES(546,10161,'S24_2766',20,82.69E0,3)
INSERT INTO ORDERDETAILS VALUES(547,10161,'S24_2887',25,108.04E0,2)
INSERT INTO ORDERDETAILS VALUES(548,10161,'S24_3191',20,72.77E0,4)
INSERT INTO ORDERDETAILS VALUES(549,10161,'S24_3432',30,94.23E0,6)
INSERT INTO ORDERDETAILS VALUES(550,10162,'S18_1342',48,87.33E0,2)
INSERT INTO ORDERDETAILS VALUES(551,10162,'S18_1367',45,45.28E0,1)
INSERT INTO ORDERDETAILS VALUES(552,10162,'S18_1749',29,141.1E0,9)
INSERT INTO ORDERDETAILS VALUES(553,10162,'S18_2248',27,53.28E0,8)
INSERT INTO ORDERDETAILS VALUES(554,10162,'S18_2325',38,113.15E0,6)
INSERT INTO ORDERDETAILS VALUES(555,10162,'S18_2795',48,156.94E0,3)
INSERT INTO ORDERDETAILS VALUES(556,10162,'S18_4409',39,86.51E0,10)
INSERT INTO ORDERDETAILS VALUES(557,10162,'S24_1937',37,27.55E0,5)
INSERT INTO ORDERDETAILS VALUES(558,10162,'S24_2022',43,38.98E0,4)
INSERT INTO ORDERDETAILS VALUES(559,10162,'S24_3969',37,32.82E0,7)
INSERT INTO ORDERDETAILS VALUES(560,10163,'S10_1949',21,212.16E0,1)
INSERT INTO ORDERDETAILS VALUES(561,10163,'S18_2949',31,101.31E0,2)
INSERT INTO ORDERDETAILS VALUES(562,10163,'S18_2957',48,59.96E0,4)
INSERT INTO ORDERDETAILS VALUES(563,10163,'S18_3136',40,101.58E0,3)
INSERT INTO ORDERDETAILS VALUES(564,10163,'S18_3320',43,80.36E0,6)
INSERT INTO ORDERDETAILS VALUES(565,10163,'S24_4258',42,96.42E0,5)
INSERT INTO ORDERDETAILS VALUES(566,10164,'S10_4962',21,143.31E0,2)
INSERT INTO ORDERDETAILS VALUES(567,10164,'S12_1666',49,121.64E0,6)
INSERT INTO ORDERDETAILS VALUES(568,10164,'S18_1097',36,103.84E0,8)
INSERT INTO ORDERDETAILS VALUES(569,10164,'S18_4600',45,107.76E0,3)
INSERT INTO ORDERDETAILS VALUES(570,10164,'S18_4668',25,46.29E0,7)
INSERT INTO ORDERDETAILS VALUES(571,10164,'S32_1268',24,91.49E0,1)
INSERT INTO ORDERDETAILS VALUES(572,10164,'S32_3522',49,57.53E0,5)
INSERT INTO ORDERDETAILS VALUES(573,10164,'S700_2824',39,86.99E0,4)
INSERT INTO ORDERDETAILS VALUES(574,10165,'S12_1108',44,168.32E0,3)
INSERT INTO ORDERDETAILS VALUES(575,10165,'S12_3148',34,123.89E0,4)
INSERT INTO ORDERDETAILS VALUES(576,10165,'S12_3891',27,152.26E0,2)
INSERT INTO ORDERDETAILS VALUES(577,10165,'S12_4473',48,109.02E0,12)
INSERT INTO ORDERDETAILS VALUES(578,10165,'S18_2238',29,134.26E0,11)
INSERT INTO ORDERDETAILS VALUES(579,10165,'S18_2319',46,120.28E0,15)
INSERT INTO ORDERDETAILS VALUES(580,10165,'S18_2432',31,60.77E0,18)
INSERT INTO ORDERDETAILS VALUES(581,10165,'S18_3232',47,154.1E0,16)
INSERT INTO ORDERDETAILS VALUES(582,10165,'S18_3259',50,84.71E0,1)
INSERT INTO ORDERDETAILS VALUES(583,10165,'S18_4027',28,123.51E0,6)
INSERT INTO ORDERDETAILS VALUES(584,10165,'S24_1444',25,46.82E0,9)
INSERT INTO ORDERDETAILS VALUES(585,10165,'S24_2300',32,117.57E0,17)
INSERT INTO ORDERDETAILS VALUES(586,10165,'S24_2840',27,31.12E0,13)
INSERT INTO ORDERDETAILS VALUES(587,10165,'S24_4048',24,106.45E0,8)
INSERT INTO ORDERDETAILS VALUES(588,10165,'S32_2509',48,50.86E0,14)
INSERT INTO ORDERDETAILS VALUES(589,10165,'S32_3207',44,55.3E0,7)
INSERT INTO ORDERDETAILS VALUES(590,10165,'S50_1392',48,106.49E0,10)
INSERT INTO ORDERDETAILS VALUES(591,10165,'S50_1514',38,49.21E0,5)
INSERT INTO ORDERDETAILS VALUES(592,10166,'S18_3140',43,136.59E0,2)
INSERT INTO ORDERDETAILS VALUES(593,10166,'S18_4522',26,72.85E0,1)
INSERT INTO ORDERDETAILS VALUES(594,10166,'S700_1938',29,76.22E0,3)
INSERT INTO ORDERDETAILS VALUES(595,10167,'S10_4757',44,123.76E0,9)
INSERT INTO ORDERDETAILS VALUES(596,10167,'S18_1662',43,141.92E0,1)
INSERT INTO ORDERDETAILS VALUES(597,10167,'S18_3029',46,69.68E0,7)
INSERT INTO ORDERDETAILS VALUES(598,10167,'S18_3856',34,84.7E0,6)
INSERT INTO ORDERDETAILS VALUES(599,10167,'S24_2011',33,110.6E0,16)
INSERT INTO ORDERDETAILS VALUES(600,10167,'S24_2841',21,54.81E0,2)
INSERT INTO ORDERDETAILS VALUES(601,10167,'S24_3151',20,77.0E0,11)
INSERT INTO ORDERDETAILS VALUES(602,10167,'S24_3420',32,64.44E0,3)
INSERT INTO ORDERDETAILS VALUES(603,10167,'S24_3816',29,73.8E0,8)
INSERT INTO ORDERDETAILS VALUES(604,10167,'S700_1138',43,66.0E0,12)
INSERT INTO ORDERDETAILS VALUES(605,10167,'S700_2047',29,87.8E0,5)
INSERT INTO ORDERDETAILS VALUES(606,10167,'S700_2610',46,62.16E0,10)
INSERT INTO ORDERDETAILS VALUES(607,10167,'S700_3505',24,85.14E0,13)
INSERT INTO ORDERDETAILS VALUES(608,10167,'S700_3962',28,83.42E0,14)
INSERT INTO ORDERDETAILS VALUES(609,10167,'S72_1253',40,42.71E0,4)
INSERT INTO ORDERDETAILS VALUES(610,10167,'S72_3212',38,43.68E0,15)
INSERT INTO ORDERDETAILS VALUES(611,10168,'S10_1678',36,94.74E0,1)
INSERT INTO ORDERDETAILS VALUES(612,10168,'S10_2016',27,97.53E0,4)
INSERT INTO ORDERDETAILS VALUES(613,10168,'S10_4698',20,160.74E0,3)
INSERT INTO ORDERDETAILS VALUES(614,10168,'S18_2581',21,75.19E0,9)
INSERT INTO ORDERDETAILS VALUES(615,10168,'S18_2625',46,49.06E0,5)
INSERT INTO ORDERDETAILS VALUES(616,10168,'S24_1578',50,103.68E0,2)
INSERT INTO ORDERDETAILS VALUES(617,10168,'S24_1785',49,93.01E0,11)
INSERT INTO ORDERDETAILS VALUES(618,10168,'S24_2000',29,72.36E0,6)
INSERT INTO ORDERDETAILS VALUES(619,10168,'S24_3949',27,57.32E0,18)
INSERT INTO ORDERDETAILS VALUES(620,10168,'S24_4278',48,68.1E0,10)
INSERT INTO ORDERDETAILS VALUES(621,10168,'S32_1374',28,89.9E0,7)
INSERT INTO ORDERDETAILS VALUES(622,10168,'S32_4289',31,57.78E0,12)
INSERT INTO ORDERDETAILS VALUES(623,10168,'S50_1341',48,39.71E0,13)
INSERT INTO ORDERDETAILS VALUES(624,10168,'S700_1691',28,91.34E0,14)
INSERT INTO ORDERDETAILS VALUES(625,10168,'S700_2466',31,87.75E0,16)
INSERT INTO ORDERDETAILS VALUES(626,10168,'S700_2834',36,94.92E0,8)
INSERT INTO ORDERDETAILS VALUES(627,10168,'S700_3167',48,72.0E0,15)
INSERT INTO ORDERDETAILS VALUES(628,10168,'S700_4002',39,67.37E0,17)
INSERT INTO ORDERDETAILS VALUES(629,10169,'S12_1099',30,163.44E0,2)
INSERT INTO ORDERDETAILS VALUES(630,10169,'S12_2823',35,126.52E0,13)
INSERT INTO ORDERDETAILS VALUES(631,10169,'S12_3990',36,71.82E0,3)
INSERT INTO ORDERDETAILS VALUES(632,10169,'S18_3278',32,65.13E0,5)
INSERT INTO ORDERDETAILS VALUES(633,10169,'S18_3482',36,136.7E0,4)
INSERT INTO ORDERDETAILS VALUES(634,10169,'S18_3782',38,52.84E0,8)
INSERT INTO ORDERDETAILS VALUES(635,10169,'S18_4721',33,120.53E0,7)
INSERT INTO ORDERDETAILS VALUES(636,10169,'S24_2360',38,66.49E0,11)
INSERT INTO ORDERDETAILS VALUES(637,10169,'S24_3371',34,53.27E0,1)
INSERT INTO ORDERDETAILS VALUES(638,10169,'S24_4620',24,77.61E0,6)
INSERT INTO ORDERDETAILS VALUES(639,10169,'S32_2206',26,37.01E0,9)
INSERT INTO ORDERDETAILS VALUES(640,10169,'S32_4485',34,83.68E0,12)
INSERT INTO ORDERDETAILS VALUES(641,10169,'S50_4713',48,75.66E0,10)
INSERT INTO ORDERDETAILS VALUES(642,10170,'S12_3380',47,116.27E0,4)
INSERT INTO ORDERDETAILS VALUES(643,10170,'S12_4675',41,93.28E0,3)
INSERT INTO ORDERDETAILS VALUES(644,10170,'S18_1889',20,70.07E0,2)
INSERT INTO ORDERDETAILS VALUES(645,10170,'S24_3856',34,130.6E0,1)
INSERT INTO ORDERDETAILS VALUES(646,10171,'S18_1129',35,134.46E0,2)
INSERT INTO ORDERDETAILS VALUES(647,10171,'S18_1984',35,128.03E0,1)
INSERT INTO ORDERDETAILS VALUES(648,10171,'S18_3232',39,165.95E0,3)
INSERT INTO ORDERDETAILS VALUES(649,10171,'S24_2972',36,34.74E0,4)
INSERT INTO ORDERDETAILS VALUES(650,10172,'S18_1589',42,109.51E0,6)
INSERT INTO ORDERDETAILS VALUES(651,10172,'S18_2870',39,117.48E0,7)
INSERT INTO ORDERDETAILS VALUES(652,10172,'S18_3685',48,139.87E0,8)
INSERT INTO ORDERDETAILS VALUES(653,10172,'S24_1046',32,61.0E0,3)
INSERT INTO ORDERDETAILS VALUES(654,10172,'S24_1628',34,43.27E0,5)
INSERT INTO ORDERDETAILS VALUES(655,10172,'S24_2766',22,79.97E0,1)
INSERT INTO ORDERDETAILS VALUES(656,10172,'S24_3191',24,77.91E0,2)
INSERT INTO ORDERDETAILS VALUES(657,10172,'S24_3432',22,87.81E0,4)
INSERT INTO ORDERDETAILS VALUES(658,10173,'S18_1342',43,101.71E0,6)
INSERT INTO ORDERDETAILS VALUES(659,10173,'S18_1367',48,51.75E0,5)
INSERT INTO ORDERDETAILS VALUES(660,10173,'S18_1749',24,168.3E0,13)
INSERT INTO ORDERDETAILS VALUES(661,10173,'S18_2248',26,55.09E0,12)
INSERT INTO ORDERDETAILS VALUES(662,10173,'S18_2325',31,127.13E0,10)
INSERT INTO ORDERDETAILS VALUES(663,10173,'S18_2795',22,140.06E0,7)
INSERT INTO ORDERDETAILS VALUES(664,10173,'S18_2957',28,56.84E0,2)
INSERT INTO ORDERDETAILS VALUES(665,10173,'S18_3136',31,86.92E0,1)
INSERT INTO ORDERDETAILS VALUES(666,10173,'S18_3320',29,90.28E0,4)
INSERT INTO ORDERDETAILS VALUES(667,10173,'S18_4409',21,77.31E0,14)
INSERT INTO ORDERDETAILS VALUES(668,10173,'S18_4933',39,58.44E0,15)
INSERT INTO ORDERDETAILS VALUES(669,10173,'S24_1937',31,29.87E0,9)
INSERT INTO ORDERDETAILS VALUES(670,10173,'S24_2022',27,39.42E0,8)
INSERT INTO ORDERDETAILS VALUES(671,10173,'S24_2887',23,98.65E0,16)
INSERT INTO ORDERDETAILS VALUES(672,10173,'S24_3969',35,35.7E0,11)
INSERT INTO ORDERDETAILS VALUES(673,10173,'S24_4258',22,93.49E0,3)
INSERT INTO ORDERDETAILS VALUES(674,10174,'S10_1949',34,207.87E0,4)
INSERT INTO ORDERDETAILS VALUES(675,10174,'S12_1666',43,113.44E0,1)
INSERT INTO ORDERDETAILS VALUES(676,10174,'S18_1097',48,108.5E0,3)
INSERT INTO ORDERDETAILS VALUES(677,10174,'S18_2949',46,100.3E0,5)
INSERT INTO ORDERDETAILS VALUES(678,10174,'S18_4668',49,44.27E0,2)
INSERT INTO ORDERDETAILS VALUES(679,10175,'S10_4962',33,119.67E0,9)
INSERT INTO ORDERDETAILS VALUES(680,10175,'S12_4473',26,109.02E0,1)
INSERT INTO ORDERDETAILS VALUES(681,10175,'S18_2319',48,101.87E0,4)
INSERT INTO ORDERDETAILS VALUES(682,10175,'S18_2432',41,59.55E0,7)
INSERT INTO ORDERDETAILS VALUES(683,10175,'S18_3232',29,150.71E0,5)
INSERT INTO ORDERDETAILS VALUES(684,10175,'S18_4600',47,102.92E0,10)
INSERT INTO ORDERDETAILS VALUES(685,10175,'S24_2300',28,121.4E0,6)
INSERT INTO ORDERDETAILS VALUES(686,10175,'S24_2840',37,32.18E0,2)
INSERT INTO ORDERDETAILS VALUES(687,10175,'S32_1268',22,89.57E0,8)
INSERT INTO ORDERDETAILS VALUES(688,10175,'S32_2509',50,50.86E0,3)
INSERT INTO ORDERDETAILS VALUES(689,10175,'S32_3522',29,56.24E0,12)
INSERT INTO ORDERDETAILS VALUES(690,10175,'S700_2824',42,80.92E0,11)
INSERT INTO ORDERDETAILS VALUES(691,10176,'S12_1108',33,166.24E0,2)
INSERT INTO ORDERDETAILS VALUES(692,10176,'S12_3148',47,145.04E0,3)
INSERT INTO ORDERDETAILS VALUES(693,10176,'S12_3891',50,160.91E0,1)
INSERT INTO ORDERDETAILS VALUES(694,10176,'S18_2238',20,139.17E0,10)
INSERT INTO ORDERDETAILS VALUES(695,10176,'S18_4027',36,140.75E0,5)
INSERT INTO ORDERDETAILS VALUES(696,10176,'S24_1444',27,55.49E0,8)
INSERT INTO ORDERDETAILS VALUES(697,10176,'S24_4048',29,101.72E0,7)
INSERT INTO ORDERDETAILS VALUES(698,10176,'S32_3207',22,62.14E0,6)
INSERT INTO ORDERDETAILS VALUES(699,10176,'S50_1392',23,109.96E0,9)
INSERT INTO ORDERDETAILS VALUES(700,10176,'S50_1514',38,52.14E0,4)
INSERT INTO ORDERDETAILS VALUES(701,10177,'S18_3140',23,113.37E0,9)
INSERT INTO ORDERDETAILS VALUES(702,10177,'S18_3259',29,92.77E0,11)
INSERT INTO ORDERDETAILS VALUES(703,10177,'S18_4522',35,82.5E0,8)
INSERT INTO ORDERDETAILS VALUES(704,10177,'S24_2011',50,115.52E0,7)
INSERT INTO ORDERDETAILS VALUES(705,10177,'S24_3151',45,79.66E0,2)
INSERT INTO ORDERDETAILS VALUES(706,10177,'S700_1138',24,58.67E0,3)
INSERT INTO ORDERDETAILS VALUES(707,10177,'S700_1938',31,77.95E0,10)
INSERT INTO ORDERDETAILS VALUES(708,10177,'S700_2610',32,64.33E0,1)
INSERT INTO ORDERDETAILS VALUES(709,10177,'S700_3505',44,88.15E0,4)
INSERT INTO ORDERDETAILS VALUES(710,10177,'S700_3962',24,83.42E0,5)
INSERT INTO ORDERDETAILS VALUES(711,10177,'S72_3212',40,52.96E0,6)
INSERT INTO ORDERDETAILS VALUES(712,10178,'S10_4757',24,131.92E0,12)
INSERT INTO ORDERDETAILS VALUES(713,10178,'S18_1662',42,127.73E0,4)
INSERT INTO ORDERDETAILS VALUES(714,10178,'S18_3029',41,70.54E0,10)
INSERT INTO ORDERDETAILS VALUES(715,10178,'S18_3856',48,104.81E0,9)
INSERT INTO ORDERDETAILS VALUES(716,10178,'S24_2841',34,67.82E0,5)
INSERT INTO ORDERDETAILS VALUES(717,10178,'S24_3420',27,65.75E0,6)
INSERT INTO ORDERDETAILS VALUES(718,10178,'S24_3816',21,68.77E0,11)
INSERT INTO ORDERDETAILS VALUES(719,10178,'S24_3949',30,64.15E0,3)
INSERT INTO ORDERDETAILS VALUES(720,10178,'S700_2047',34,86.9E0,8)
INSERT INTO ORDERDETAILS VALUES(721,10178,'S700_2466',22,91.74E0,1)
INSERT INTO ORDERDETAILS VALUES(722,10178,'S700_4002',45,68.11E0,2)
INSERT INTO ORDERDETAILS VALUES(723,10178,'S72_1253',45,41.71E0,7)
INSERT INTO ORDERDETAILS VALUES(724,10179,'S18_2581',24,82.79E0,3)
INSERT INTO ORDERDETAILS VALUES(725,10179,'S24_1785',47,105.04E0,5)
INSERT INTO ORDERDETAILS VALUES(726,10179,'S24_4278',27,66.65E0,4)
INSERT INTO ORDERDETAILS VALUES(727,10179,'S32_1374',45,86.9E0,1)
INSERT INTO ORDERDETAILS VALUES(728,10179,'S32_4289',24,63.97E0,6)
INSERT INTO ORDERDETAILS VALUES(729,10179,'S50_1341',34,43.2E0,7)
INSERT INTO ORDERDETAILS VALUES(730,10179,'S700_1691',23,75.81E0,8)
INSERT INTO ORDERDETAILS VALUES(731,10179,'S700_2834',25,98.48E0,2)
INSERT INTO ORDERDETAILS VALUES(732,10179,'S700_3167',39,80.0E0,9)
INSERT INTO ORDERDETAILS VALUES(733,10180,'S10_1678',29,76.56E0,9)
INSERT INTO ORDERDETAILS VALUES(734,10180,'S10_2016',42,99.91E0,12)
INSERT INTO ORDERDETAILS VALUES(735,10180,'S10_4698',41,164.61E0,11)
INSERT INTO ORDERDETAILS VALUES(736,10180,'S12_2823',40,131.04E0,8)
INSERT INTO ORDERDETAILS VALUES(737,10180,'S18_2625',25,48.46E0,13)
INSERT INTO ORDERDETAILS VALUES(738,10180,'S18_3782',21,59.06E0,3)
INSERT INTO ORDERDETAILS VALUES(739,10180,'S18_4721',44,147.31E0,2)
INSERT INTO ORDERDETAILS VALUES(740,10180,'S24_1578',48,98.05E0,10)
INSERT INTO ORDERDETAILS VALUES(741,10180,'S24_2000',28,61.7E0,14)
INSERT INTO ORDERDETAILS VALUES(742,10180,'S24_2360',35,60.95E0,6)
INSERT INTO ORDERDETAILS VALUES(743,10180,'S24_4620',28,68.71E0,1)
INSERT INTO ORDERDETAILS VALUES(744,10180,'S32_2206',34,33.39E0,4)
INSERT INTO ORDERDETAILS VALUES(745,10180,'S32_4485',22,102.05E0,7)
INSERT INTO ORDERDETAILS VALUES(746,10180,'S50_4713',21,74.85E0,5)
INSERT INTO ORDERDETAILS VALUES(747,10181,'S12_1099',27,155.66E0,14)
INSERT INTO ORDERDETAILS VALUES(748,10181,'S12_3380',28,113.92E0,12)
INSERT INTO ORDERDETAILS VALUES(749,10181,'S12_3990',20,67.03E0,15)
INSERT INTO ORDERDETAILS VALUES(750,10181,'S12_4675',36,107.1E0,11)
INSERT INTO ORDERDETAILS VALUES(751,10181,'S18_1129',44,124.56E0,6)
INSERT INTO ORDERDETAILS VALUES(752,10181,'S18_1589',42,124.44E0,2)
INSERT INTO ORDERDETAILS VALUES(753,10181,'S18_1889',22,74.69E0,10)
INSERT INTO ORDERDETAILS VALUES(754,10181,'S18_1984',21,129.45E0,5)
INSERT INTO ORDERDETAILS VALUES(755,10181,'S18_2870',27,130.68E0,3)
INSERT INTO ORDERDETAILS VALUES(756,10181,'S18_3232',45,147.33E0,7)
INSERT INTO ORDERDETAILS VALUES(757,10181,'S18_3278',30,73.17E0,17)
INSERT INTO ORDERDETAILS VALUES(758,10181,'S18_3482',22,120.53E0,16)
INSERT INTO ORDERDETAILS VALUES(759,10181,'S18_3685',39,137.04E0,4)
INSERT INTO ORDERDETAILS VALUES(760,10181,'S24_1628',34,45.28E0,1)
INSERT INTO ORDERDETAILS VALUES(761,10181,'S24_2972',37,32.85E0,8)
INSERT INTO ORDERDETAILS VALUES(762,10181,'S24_3371',23,54.49E0,13)
INSERT INTO ORDERDETAILS VALUES(763,10181,'S24_3856',25,122.17E0,9)
INSERT INTO ORDERDETAILS VALUES(764,10182,'S18_1342',25,83.22E0,3)
INSERT INTO ORDERDETAILS VALUES(765,10182,'S18_1367',32,44.21E0,2)
INSERT INTO ORDERDETAILS VALUES(766,10182,'S18_1749',44,159.8E0,10)
INSERT INTO ORDERDETAILS VALUES(767,10182,'S18_2248',38,54.49E0,9)
INSERT INTO ORDERDETAILS VALUES(768,10182,'S18_2325',20,105.52E0,7)
INSERT INTO ORDERDETAILS VALUES(769,10182,'S18_2795',21,135.0E0,4)
INSERT INTO ORDERDETAILS VALUES(770,10182,'S18_3320',33,86.31E0,1)
INSERT INTO ORDERDETAILS VALUES(771,10182,'S18_4409',36,88.35E0,11)
INSERT INTO ORDERDETAILS VALUES(772,10182,'S18_4933',44,61.29E0,12)
INSERT INTO ORDERDETAILS VALUES(773,10182,'S24_1046',47,63.2E0,16)
INSERT INTO ORDERDETAILS VALUES(774,10182,'S24_1937',39,31.86E0,6)
INSERT INTO ORDERDETAILS VALUES(775,10182,'S24_2022',31,39.87E0,5)
INSERT INTO ORDERDETAILS VALUES(776,10182,'S24_2766',36,87.24E0,14)
INSERT INTO ORDERDETAILS VALUES(777,10182,'S24_2887',20,116.27E0,13)
INSERT INTO ORDERDETAILS VALUES(778,10182,'S24_3191',33,73.62E0,15)
INSERT INTO ORDERDETAILS VALUES(779,10182,'S24_3432',49,95.3E0,17)
INSERT INTO ORDERDETAILS VALUES(780,10182,'S24_3969',23,34.88E0,8)
INSERT INTO ORDERDETAILS VALUES(781,10183,'S10_1949',23,180.01E0,8)
INSERT INTO ORDERDETAILS VALUES(782,10183,'S10_4962',28,127.06E0,1)
INSERT INTO ORDERDETAILS VALUES(783,10183,'S12_1666',41,114.8E0,5)
INSERT INTO ORDERDETAILS VALUES(784,10183,'S18_1097',21,108.5E0,7)
INSERT INTO ORDERDETAILS VALUES(785,10183,'S18_2949',37,91.18E0,9)
INSERT INTO ORDERDETAILS VALUES(786,10183,'S18_2957',39,51.22E0,11)
INSERT INTO ORDERDETAILS VALUES(787,10183,'S18_3136',22,90.06E0,10)
INSERT INTO ORDERDETAILS VALUES(788,10183,'S18_4600',21,118.66E0,2)
INSERT INTO ORDERDETAILS VALUES(789,10183,'S18_4668',40,42.26E0,6)
INSERT INTO ORDERDETAILS VALUES(790,10183,'S24_4258',47,81.81E0,12)
INSERT INTO ORDERDETAILS VALUES(791,10183,'S32_3522',49,52.36E0,4)
INSERT INTO ORDERDETAILS VALUES(792,10183,'S700_2824',23,85.98E0,3)
INSERT INTO ORDERDETAILS VALUES(793,10184,'S12_4473',37,105.47E0,6)
INSERT INTO ORDERDETAILS VALUES(794,10184,'S18_2238',46,145.72E0,5)
INSERT INTO ORDERDETAILS VALUES(795,10184,'S18_2319',46,119.05E0,9)
INSERT INTO ORDERDETAILS VALUES(796,10184,'S18_2432',44,60.77E0,12)
INSERT INTO ORDERDETAILS VALUES(797,10184,'S18_3232',28,165.95E0,10)
INSERT INTO ORDERDETAILS VALUES(798,10184,'S24_1444',31,57.22E0,3)
INSERT INTO ORDERDETAILS VALUES(799,10184,'S24_2300',24,117.57E0,11)
INSERT INTO ORDERDETAILS VALUES(800,10184,'S24_2840',42,30.06E0,7)
INSERT INTO ORDERDETAILS VALUES(801,10184,'S24_4048',49,114.73E0,2)
INSERT INTO ORDERDETAILS VALUES(802,10184,'S32_1268',46,84.75E0,13)
INSERT INTO ORDERDETAILS VALUES(803,10184,'S32_2509',33,52.49E0,8)
INSERT INTO ORDERDETAILS VALUES(804,10184,'S32_3207',48,59.03E0,1)
INSERT INTO ORDERDETAILS VALUES(805,10184,'S50_1392',45,92.6E0,4)
INSERT INTO ORDERDETAILS VALUES(806,10185,'S12_1108',21,195.33E0,13)
INSERT INTO ORDERDETAILS VALUES(807,10185,'S12_3148',33,146.55E0,14)
INSERT INTO ORDERDETAILS VALUES(808,10185,'S12_3891',43,147.07E0,12)
INSERT INTO ORDERDETAILS VALUES(809,10185,'S18_3140',28,124.3E0,9)
INSERT INTO ORDERDETAILS VALUES(810,10185,'S18_3259',49,94.79E0,11)
INSERT INTO ORDERDETAILS VALUES(811,10185,'S18_4027',39,127.82E0,16)
INSERT INTO ORDERDETAILS VALUES(812,10185,'S18_4522',47,87.77E0,8)
INSERT INTO ORDERDETAILS VALUES(813,10185,'S24_2011',30,105.69E0,7)
INSERT INTO ORDERDETAILS VALUES(814,10185,'S24_3151',33,83.2E0,2)
INSERT INTO ORDERDETAILS VALUES(815,10185,'S50_1514',20,46.86E0,15)
INSERT INTO ORDERDETAILS VALUES(816,10185,'S700_1138',21,64.67E0,3)
INSERT INTO ORDERDETAILS VALUES(817,10185,'S700_1938',30,79.68E0,10)
INSERT INTO ORDERDETAILS VALUES(818,10185,'S700_2610',39,61.44E0,1)
INSERT INTO ORDERDETAILS VALUES(819,10185,'S700_3505',37,99.17E0,4)
INSERT INTO ORDERDETAILS VALUES(820,10185,'S700_3962',22,93.35E0,5)
INSERT INTO ORDERDETAILS VALUES(821,10185,'S72_3212',28,47.5E0,6)
INSERT INTO ORDERDETAILS VALUES(822,10186,'S10_4757',26,108.8E0,9)
INSERT INTO ORDERDETAILS VALUES(823,10186,'S18_1662',32,137.19E0,1)
INSERT INTO ORDERDETAILS VALUES(824,10186,'S18_3029',32,73.12E0,7)
INSERT INTO ORDERDETAILS VALUES(825,10186,'S18_3856',46,98.46E0,6)
INSERT INTO ORDERDETAILS VALUES(826,10186,'S24_2841',22,60.29E0,2)
INSERT INTO ORDERDETAILS VALUES(827,10186,'S24_3420',21,59.83E0,3)
INSERT INTO ORDERDETAILS VALUES(828,10186,'S24_3816',36,68.77E0,8)
INSERT INTO ORDERDETAILS VALUES(829,10186,'S700_2047',24,80.56E0,5)
INSERT INTO ORDERDETAILS VALUES(830,10186,'S72_1253',28,42.71E0,4)
INSERT INTO ORDERDETAILS VALUES(831,10187,'S18_2581',45,70.12E0,1)
INSERT INTO ORDERDETAILS VALUES(832,10187,'S24_1785',46,96.29E0,3)
INSERT INTO ORDERDETAILS VALUES(833,10187,'S24_3949',43,55.96E0,10)
INSERT INTO ORDERDETAILS VALUES(834,10187,'S24_4278',33,64.48E0,2)
INSERT INTO ORDERDETAILS VALUES(835,10187,'S32_4289',31,61.22E0,4)
INSERT INTO ORDERDETAILS VALUES(836,10187,'S50_1341',41,39.71E0,5)
INSERT INTO ORDERDETAILS VALUES(837,10187,'S700_1691',34,84.95E0,6)
INSERT INTO ORDERDETAILS VALUES(838,10187,'S700_2466',44,95.73E0,8)
INSERT INTO ORDERDETAILS VALUES(839,10187,'S700_3167',34,72.0E0,7)
INSERT INTO ORDERDETAILS VALUES(840,10187,'S700_4002',44,70.33E0,9)
INSERT INTO ORDERDETAILS VALUES(841,10188,'S10_1678',48,95.7E0,1)
INSERT INTO ORDERDETAILS VALUES(842,10188,'S10_2016',38,111.8E0,4)
INSERT INTO ORDERDETAILS VALUES(843,10188,'S10_4698',45,182.04E0,3)
INSERT INTO ORDERDETAILS VALUES(844,10188,'S18_2625',32,52.09E0,5)
INSERT INTO ORDERDETAILS VALUES(845,10188,'S24_1578',25,95.8E0,2)
INSERT INTO ORDERDETAILS VALUES(846,10188,'S24_2000',40,61.7E0,6)
INSERT INTO ORDERDETAILS VALUES(847,10188,'S32_1374',44,81.91E0,7)
INSERT INTO ORDERDETAILS VALUES(848,10188,'S700_2834',29,96.11E0,8)
INSERT INTO ORDERDETAILS VALUES(849,10189,'S12_2823',28,138.57E0,1)
INSERT INTO ORDERDETAILS VALUES(850,10190,'S24_2360',42,58.87E0,3)
INSERT INTO ORDERDETAILS VALUES(851,10190,'S32_2206',46,38.62E0,1)
INSERT INTO ORDERDETAILS VALUES(852,10190,'S32_4485',42,89.8E0,4)
INSERT INTO ORDERDETAILS VALUES(853,10190,'S50_4713',40,67.53E0,2)
INSERT INTO ORDERDETAILS VALUES(854,10191,'S12_1099',21,155.66E0,3)
INSERT INTO ORDERDETAILS VALUES(855,10191,'S12_3380',40,104.52E0,1)
INSERT INTO ORDERDETAILS VALUES(856,10191,'S12_3990',30,70.22E0,4)
INSERT INTO ORDERDETAILS VALUES(857,10191,'S18_3278',36,75.59E0,6)
INSERT INTO ORDERDETAILS VALUES(858,10191,'S18_3482',23,119.06E0,5)
INSERT INTO ORDERDETAILS VALUES(859,10191,'S18_3782',43,60.93E0,9)
INSERT INTO ORDERDETAILS VALUES(860,10191,'S18_4721',32,136.9E0,8)
INSERT INTO ORDERDETAILS VALUES(861,10191,'S24_3371',48,53.27E0,2)
INSERT INTO ORDERDETAILS VALUES(862,10191,'S24_4620',44,77.61E0,7)
INSERT INTO ORDERDETAILS VALUES(863,10192,'S12_4675',27,99.04E0,16)
INSERT INTO ORDERDETAILS VALUES(864,10192,'S18_1129',22,140.12E0,11)
INSERT INTO ORDERDETAILS VALUES(865,10192,'S18_1589',29,100.8E0,7)
INSERT INTO ORDERDETAILS VALUES(866,10192,'S18_1889',45,70.84E0,15)
INSERT INTO ORDERDETAILS VALUES(867,10192,'S18_1984',47,128.03E0,10)
INSERT INTO ORDERDETAILS VALUES(868,10192,'S18_2870',38,110.88E0,8)
INSERT INTO ORDERDETAILS VALUES(869,10192,'S18_3232',26,137.17E0,12)
INSERT INTO ORDERDETAILS VALUES(870,10192,'S18_3685',45,125.74E0,9)
INSERT INTO ORDERDETAILS VALUES(871,10192,'S24_1046',37,72.02E0,4)
INSERT INTO ORDERDETAILS VALUES(872,10192,'S24_1628',47,49.3E0,6)
INSERT INTO ORDERDETAILS VALUES(873,10192,'S24_2766',46,86.33E0,2)
INSERT INTO ORDERDETAILS VALUES(874,10192,'S24_2887',23,112.74E0,1)
INSERT INTO ORDERDETAILS VALUES(875,10192,'S24_2972',30,33.23E0,13)
INSERT INTO ORDERDETAILS VALUES(876,10192,'S24_3191',32,69.34E0,3)
INSERT INTO ORDERDETAILS VALUES(877,10192,'S24_3432',46,93.16E0,5)
INSERT INTO ORDERDETAILS VALUES(878,10192,'S24_3856',45,112.34E0,14)
INSERT INTO ORDERDETAILS VALUES(879,10193,'S18_1342',28,92.47E0,7)
INSERT INTO ORDERDETAILS VALUES(880,10193,'S18_1367',46,46.36E0,6)
INSERT INTO ORDERDETAILS VALUES(881,10193,'S18_1749',21,153.0E0,14)
INSERT INTO ORDERDETAILS VALUES(882,10193,'S18_2248',42,60.54E0,13)
INSERT INTO ORDERDETAILS VALUES(883,10193,'S18_2325',44,115.69E0,11)
INSERT INTO ORDERDETAILS VALUES(884,10193,'S18_2795',22,143.44E0,8)
INSERT INTO ORDERDETAILS VALUES(885,10193,'S18_2949',28,87.13E0,1)
INSERT INTO ORDERDETAILS VALUES(886,10193,'S18_2957',24,53.09E0,3)
INSERT INTO ORDERDETAILS VALUES(887,10193,'S18_3136',23,97.39E0,2)
INSERT INTO ORDERDETAILS VALUES(888,10193,'S18_3320',32,79.37E0,5)
INSERT INTO ORDERDETAILS VALUES(889,10193,'S18_4409',24,92.03E0,15)
INSERT INTO ORDERDETAILS VALUES(890,10193,'S18_4933',25,66.28E0,16)
INSERT INTO ORDERDETAILS VALUES(891,10193,'S24_1937',26,32.19E0,10)
INSERT INTO ORDERDETAILS VALUES(892,10193,'S24_2022',20,44.8E0,9)
INSERT INTO ORDERDETAILS VALUES(893,10193,'S24_3969',22,38.16E0,12)
INSERT INTO ORDERDETAILS VALUES(894,10193,'S24_4258',20,92.52E0,4)
INSERT INTO ORDERDETAILS VALUES(895,10194,'S10_1949',42,203.59E0,11)
INSERT INTO ORDERDETAILS VALUES(896,10194,'S10_4962',26,134.44E0,4)
INSERT INTO ORDERDETAILS VALUES(897,10194,'S12_1666',38,124.37E0,8)
INSERT INTO ORDERDETAILS VALUES(898,10194,'S18_1097',21,103.84E0,10)
INSERT INTO ORDERDETAILS VALUES(899,10194,'S18_2432',45,51.05E0,2)
INSERT INTO ORDERDETAILS VALUES(900,10194,'S18_4600',32,113.82E0,5)
INSERT INTO ORDERDETAILS VALUES(901,10194,'S18_4668',41,47.79E0,9)
INSERT INTO ORDERDETAILS VALUES(902,10194,'S24_2300',49,112.46E0,1)
INSERT INTO ORDERDETAILS VALUES(903,10194,'S32_1268',37,77.05E0,3)
INSERT INTO ORDERDETAILS VALUES(904,10194,'S32_3522',39,61.41E0,7)
INSERT INTO ORDERDETAILS VALUES(905,10194,'S700_2824',26,80.92E0,6)
INSERT INTO ORDERDETAILS VALUES(906,10195,'S12_4473',49,118.5E0,6)
INSERT INTO ORDERDETAILS VALUES(907,10195,'S18_2238',27,139.17E0,5)
INSERT INTO ORDERDETAILS VALUES(908,10195,'S18_2319',35,112.91E0,9)
INSERT INTO ORDERDETAILS VALUES(909,10195,'S18_3232',50,150.71E0,10)
INSERT INTO ORDERDETAILS VALUES(910,10195,'S24_1444',44,54.33E0,3)
INSERT INTO ORDERDETAILS VALUES(911,10195,'S24_2840',32,31.82E0,7)
INSERT INTO ORDERDETAILS VALUES(912,10195,'S24_4048',34,95.81E0,2)
INSERT INTO ORDERDETAILS VALUES(913,10195,'S32_2509',32,51.95E0,8)
INSERT INTO ORDERDETAILS VALUES(914,10195,'S32_3207',33,59.03E0,1)
INSERT INTO ORDERDETAILS VALUES(915,10195,'S50_1392',49,97.23E0,4)
INSERT INTO ORDERDETAILS VALUES(916,10196,'S12_1108',47,203.64E0,5)
INSERT INTO ORDERDETAILS VALUES(917,10196,'S12_3148',24,151.08E0,6)
INSERT INTO ORDERDETAILS VALUES(918,10196,'S12_3891',38,147.07E0,4)
INSERT INTO ORDERDETAILS VALUES(919,10196,'S18_3140',49,127.03E0,1)
INSERT INTO ORDERDETAILS VALUES(920,10196,'S18_3259',35,81.68E0,3)
INSERT INTO ORDERDETAILS VALUES(921,10196,'S18_4027',27,126.39E0,8)
INSERT INTO ORDERDETAILS VALUES(922,10196,'S50_1514',46,56.82E0,7)
INSERT INTO ORDERDETAILS VALUES(923,10196,'S700_1938',50,84.88E0,2)
INSERT INTO ORDERDETAILS VALUES(924,10197,'S10_4757',45,118.32E0,6)
INSERT INTO ORDERDETAILS VALUES(925,10197,'S18_3029',46,83.44E0,4)
INSERT INTO ORDERDETAILS VALUES(926,10197,'S18_3856',22,85.75E0,3)
INSERT INTO ORDERDETAILS VALUES(927,10197,'S18_4522',50,78.99E0,14)
INSERT INTO ORDERDETAILS VALUES(928,10197,'S24_2011',41,109.37E0,13)
INSERT INTO ORDERDETAILS VALUES(929,10197,'S24_3151',47,83.2E0,8)
INSERT INTO ORDERDETAILS VALUES(930,10197,'S24_3816',22,67.93E0,5)
INSERT INTO ORDERDETAILS VALUES(931,10197,'S700_1138',23,60.0E0,9)
INSERT INTO ORDERDETAILS VALUES(932,10197,'S700_2047',24,78.75E0,2)
INSERT INTO ORDERDETAILS VALUES(933,10197,'S700_2610',50,66.5E0,7)
INSERT INTO ORDERDETAILS VALUES(934,10197,'S700_3505',27,100.17E0,10)
INSERT INTO ORDERDETAILS VALUES(935,10197,'S700_3962',35,88.39E0,11)
INSERT INTO ORDERDETAILS VALUES(936,10197,'S72_1253',29,39.73E0,1)
INSERT INTO ORDERDETAILS VALUES(937,10197,'S72_3212',42,48.59E0,12)
INSERT INTO ORDERDETAILS VALUES(938,10198,'S18_1662',42,149.81E0,4)
INSERT INTO ORDERDETAILS VALUES(939,10198,'S24_2841',48,60.97E0,5)
INSERT INTO ORDERDETAILS VALUES(940,10198,'S24_3420',27,61.81E0,6)
INSERT INTO ORDERDETAILS VALUES(941,10198,'S24_3949',43,65.51E0,3)
INSERT INTO ORDERDETAILS VALUES(942,10198,'S700_2466',42,94.73E0,1)
INSERT INTO ORDERDETAILS VALUES(943,10198,'S700_4002',40,74.03E0,2)
INSERT INTO ORDERDETAILS VALUES(944,10199,'S50_1341',29,37.97E0,1)
INSERT INTO ORDERDETAILS VALUES(945,10199,'S700_1691',48,81.29E0,2)
INSERT INTO ORDERDETAILS VALUES(946,10199,'S700_3167',38,70.4E0,3)
INSERT INTO ORDERDETAILS VALUES(947,10200,'S18_2581',28,74.34E0,3)
INSERT INTO ORDERDETAILS VALUES(948,10200,'S24_1785',33,99.57E0,5)
INSERT INTO ORDERDETAILS VALUES(949,10200,'S24_4278',39,70.28E0,4)
INSERT INTO ORDERDETAILS VALUES(950,10200,'S32_1374',35,80.91E0,1)
INSERT INTO ORDERDETAILS VALUES(951,10200,'S32_4289',27,65.35E0,6)
INSERT INTO ORDERDETAILS VALUES(952,10200,'S700_2834',39,115.09E0,2)
INSERT INTO ORDERDETAILS VALUES(953,10201,'S10_1678',22,82.3E0,2)
INSERT INTO ORDERDETAILS VALUES(954,10201,'S10_2016',24,116.56E0,5)
INSERT INTO ORDERDETAILS VALUES(955,10201,'S10_4698',49,191.72E0,4)
INSERT INTO ORDERDETAILS VALUES(956,10201,'S12_2823',25,126.52E0,1)
INSERT INTO ORDERDETAILS VALUES(957,10201,'S18_2625',30,48.46E0,6)
INSERT INTO ORDERDETAILS VALUES(958,10201,'S24_1578',39,93.54E0,3)
INSERT INTO ORDERDETAILS VALUES(959,10201,'S24_2000',25,66.27E0,7)
INSERT INTO ORDERDETAILS VALUES(960,10202,'S18_3782',30,55.33E0,3)
INSERT INTO ORDERDETAILS VALUES(961,10202,'S18_4721',43,124.99E0,2)
INSERT INTO ORDERDETAILS VALUES(962,10202,'S24_2360',50,56.1E0,6)
INSERT INTO ORDERDETAILS VALUES(963,10202,'S24_4620',50,75.18E0,1)
INSERT INTO ORDERDETAILS VALUES(964,10202,'S32_2206',27,33.39E0,4)
INSERT INTO ORDERDETAILS VALUES(965,10202,'S32_4485',31,81.64E0,7)
INSERT INTO ORDERDETAILS VALUES(966,10202,'S50_4713',40,79.73E0,5)
INSERT INTO ORDERDETAILS VALUES(967,10203,'S12_1099',20,161.49E0,8)
INSERT INTO ORDERDETAILS VALUES(968,10203,'S12_3380',20,111.57E0,6)
INSERT INTO ORDERDETAILS VALUES(969,10203,'S12_3990',44,63.84E0,9)
INSERT INTO ORDERDETAILS VALUES(970,10203,'S12_4675',47,115.16E0,5)
INSERT INTO ORDERDETAILS VALUES(971,10203,'S18_1889',45,73.15E0,4)
INSERT INTO ORDERDETAILS VALUES(972,10203,'S18_3232',48,157.49E0,1)
INSERT INTO ORDERDETAILS VALUES(973,10203,'S18_3278',33,66.74E0,11)
INSERT INTO ORDERDETAILS VALUES(974,10203,'S18_3482',32,127.88E0,10)
INSERT INTO ORDERDETAILS VALUES(975,10203,'S24_2972',21,33.23E0,2)
INSERT INTO ORDERDETAILS VALUES(976,10203,'S24_3371',34,56.94E0,7)
INSERT INTO ORDERDETAILS VALUES(977,10203,'S24_3856',47,140.43E0,3)
INSERT INTO ORDERDETAILS VALUES(978,10204,'S18_1129',42,114.65E0,17)
INSERT INTO ORDERDETAILS VALUES(979,10204,'S18_1589',40,113.24E0,13)
INSERT INTO ORDERDETAILS VALUES(980,10204,'S18_1749',33,153.0E0,4)
INSERT INTO ORDERDETAILS VALUES(981,10204,'S18_1984',38,133.72E0,16)
INSERT INTO ORDERDETAILS VALUES(982,10204,'S18_2248',23,59.33E0,3)
INSERT INTO ORDERDETAILS VALUES(983,10204,'S18_2325',26,119.5E0,1)
INSERT INTO ORDERDETAILS VALUES(984,10204,'S18_2870',27,106.92E0,14)
INSERT INTO ORDERDETAILS VALUES(985,10204,'S18_3685',35,132.8E0,15)
INSERT INTO ORDERDETAILS VALUES(986,10204,'S18_4409',29,83.75E0,5)
INSERT INTO ORDERDETAILS VALUES(987,10204,'S18_4933',45,69.84E0,6)
INSERT INTO ORDERDETAILS VALUES(988,10204,'S24_1046',20,69.82E0,10)
INSERT INTO ORDERDETAILS VALUES(989,10204,'S24_1628',45,46.79E0,12)
INSERT INTO ORDERDETAILS VALUES(990,10204,'S24_2766',47,79.06E0,8)
INSERT INTO ORDERDETAILS VALUES(991,10204,'S24_2887',42,112.74E0,7)
INSERT INTO ORDERDETAILS VALUES(992,10204,'S24_3191',40,84.75E0,9)
INSERT INTO ORDERDETAILS VALUES(993,10204,'S24_3432',48,104.94E0,11)
INSERT INTO ORDERDETAILS VALUES(994,10204,'S24_3969',39,34.88E0,2)
INSERT INTO ORDERDETAILS VALUES(995,10205,'S18_1342',36,98.63E0,2)
INSERT INTO ORDERDETAILS VALUES(996,10205,'S18_1367',48,45.82E0,1)
INSERT INTO ORDERDETAILS VALUES(997,10205,'S18_2795',40,138.38E0,3)
INSERT INTO ORDERDETAILS VALUES(998,10205,'S24_1937',32,27.88E0,5)
INSERT INTO ORDERDETAILS VALUES(999,10205,'S24_2022',24,36.74E0,4)
INSERT INTO ORDERDETAILS VALUES(1000,10206,'S10_1949',47,203.59E0,6)
INSERT INTO ORDERDETAILS VALUES(1001,10206,'S12_1666',28,109.34E0,3)
INSERT INTO ORDERDETAILS VALUES(1002,10206,'S18_1097',34,115.5E0,5)
INSERT INTO ORDERDETAILS VALUES(1003,10206,'S18_2949',37,98.27E0,7)
INSERT INTO ORDERDETAILS VALUES(1004,10206,'S18_2957',28,51.84E0,9)
INSERT INTO ORDERDETAILS VALUES(1005,10206,'S18_3136',30,102.63E0,8)
INSERT INTO ORDERDETAILS VALUES(1006,10206,'S18_3320',28,99.21E0,11)
INSERT INTO ORDERDETAILS VALUES(1007,10206,'S18_4668',21,45.78E0,4)
INSERT INTO ORDERDETAILS VALUES(1008,10206,'S24_4258',33,95.44E0,10)
INSERT INTO ORDERDETAILS VALUES(1009,10206,'S32_3522',36,54.94E0,2)
INSERT INTO ORDERDETAILS VALUES(1010,10206,'S700_2824',33,89.01E0,1)
INSERT INTO ORDERDETAILS VALUES(1011,10207,'S10_4962',31,125.58E0,15)
INSERT INTO ORDERDETAILS VALUES(1012,10207,'S12_4473',34,95.99E0,7)
INSERT INTO ORDERDETAILS VALUES(1013,10207,'S18_2238',44,140.81E0,6)
INSERT INTO ORDERDETAILS VALUES(1014,10207,'S18_2319',43,109.23E0,10)
INSERT INTO ORDERDETAILS VALUES(1015,10207,'S18_2432',37,60.77E0,13)
INSERT INTO ORDERDETAILS VALUES(1016,10207,'S18_3232',25,140.55E0,11)
INSERT INTO ORDERDETAILS VALUES(1017,10207,'S18_4027',40,143.62E0,1)
INSERT INTO ORDERDETAILS VALUES(1018,10207,'S18_4600',47,119.87E0,16)
INSERT INTO ORDERDETAILS VALUES(1019,10207,'S24_1444',49,57.8E0,4)
INSERT INTO ORDERDETAILS VALUES(1020,10207,'S24_2300',46,127.79E0,12)
INSERT INTO ORDERDETAILS VALUES(1021,10207,'S24_2840',42,30.76E0,8)
INSERT INTO ORDERDETAILS VALUES(1022,10207,'S24_4048',28,108.82E0,3)
INSERT INTO ORDERDETAILS VALUES(1023,10207,'S32_1268',49,84.75E0,14)
INSERT INTO ORDERDETAILS VALUES(1024,10207,'S32_2509',27,51.95E0,9)
INSERT INTO ORDERDETAILS VALUES(1025,10207,'S32_3207',45,55.3E0,2)
INSERT INTO ORDERDETAILS VALUES(1026,10207,'S50_1392',28,106.49E0,5)
INSERT INTO ORDERDETAILS VALUES(1027,10208,'S12_1108',46,176.63E0,13)
INSERT INTO ORDERDETAILS VALUES(1028,10208,'S12_3148',26,128.42E0,14)
INSERT INTO ORDERDETAILS VALUES(1029,10208,'S12_3891',20,152.26E0,12)
INSERT INTO ORDERDETAILS VALUES(1030,10208,'S18_3140',24,117.47E0,9)
INSERT INTO ORDERDETAILS VALUES(1031,10208,'S18_3259',48,96.81E0,11)
INSERT INTO ORDERDETAILS VALUES(1032,10208,'S18_4522',45,72.85E0,8)
INSERT INTO ORDERDETAILS VALUES(1033,10208,'S24_2011',35,122.89E0,7)
INSERT INTO ORDERDETAILS VALUES(1034,10208,'S24_3151',20,80.54E0,2)
INSERT INTO ORDERDETAILS VALUES(1035,10208,'S50_1514',30,57.99E0,15)
INSERT INTO ORDERDETAILS VALUES(1036,10208,'S700_1138',38,56.67E0,3)
INSERT INTO ORDERDETAILS VALUES(1037,10208,'S700_1938',40,73.62E0,10)
INSERT INTO ORDERDETAILS VALUES(1038,10208,'S700_2610',46,63.61E0,1)
INSERT INTO ORDERDETAILS VALUES(1039,10208,'S700_3505',37,95.16E0,4)
INSERT INTO ORDERDETAILS VALUES(1040,10208,'S700_3962',33,95.34E0,5)
INSERT INTO ORDERDETAILS VALUES(1041,10208,'S72_3212',42,48.05E0,6)
INSERT INTO ORDERDETAILS VALUES(1042,10209,'S10_4757',39,129.2E0,8)
INSERT INTO ORDERDETAILS VALUES(1043,10209,'S18_3029',28,82.58E0,6)
INSERT INTO ORDERDETAILS VALUES(1044,10209,'S18_3856',20,97.4E0,5)
INSERT INTO ORDERDETAILS VALUES(1045,10209,'S24_2841',43,66.45E0,1)
INSERT INTO ORDERDETAILS VALUES(1046,10209,'S24_3420',36,56.55E0,2)
INSERT INTO ORDERDETAILS VALUES(1047,10209,'S24_3816',22,79.67E0,7)
INSERT INTO ORDERDETAILS VALUES(1048,10209,'S700_2047',33,90.52E0,4)
INSERT INTO ORDERDETAILS VALUES(1049,10209,'S72_1253',48,44.2E0,3)
INSERT INTO ORDERDETAILS VALUES(1050,10210,'S10_2016',23,112.99E0,2)
INSERT INTO ORDERDETAILS VALUES(1051,10210,'S10_4698',34,189.79E0,1)
INSERT INTO ORDERDETAILS VALUES(1052,10210,'S18_1662',31,141.92E0,17)
INSERT INTO ORDERDETAILS VALUES(1053,10210,'S18_2581',50,68.43E0,7)
INSERT INTO ORDERDETAILS VALUES(1054,10210,'S18_2625',40,51.48E0,3)
INSERT INTO ORDERDETAILS VALUES(1055,10210,'S24_1785',27,100.67E0,9)
INSERT INTO ORDERDETAILS VALUES(1056,10210,'S24_2000',30,63.22E0,4)
INSERT INTO ORDERDETAILS VALUES(1057,10210,'S24_3949',29,56.64E0,16)
INSERT INTO ORDERDETAILS VALUES(1058,10210,'S24_4278',40,68.1E0,8)
INSERT INTO ORDERDETAILS VALUES(1059,10210,'S32_1374',46,84.91E0,5)
INSERT INTO ORDERDETAILS VALUES(1060,10210,'S32_4289',39,57.1E0,10)
INSERT INTO ORDERDETAILS VALUES(1061,10210,'S50_1341',43,43.2E0,11)
INSERT INTO ORDERDETAILS VALUES(1062,10210,'S700_1691',21,87.69E0,12)
INSERT INTO ORDERDETAILS VALUES(1063,10210,'S700_2466',26,93.74E0,14)
INSERT INTO ORDERDETAILS VALUES(1064,10210,'S700_2834',25,98.48E0,6)
INSERT INTO ORDERDETAILS VALUES(1065,10210,'S700_3167',31,64.0E0,13)
INSERT INTO ORDERDETAILS VALUES(1066,10210,'S700_4002',42,60.7E0,15)
INSERT INTO ORDERDETAILS VALUES(1067,10211,'S10_1678',41,90.92E0,14)
INSERT INTO ORDERDETAILS VALUES(1068,10211,'S12_1099',41,171.22E0,2)
INSERT INTO ORDERDETAILS VALUES(1069,10211,'S12_2823',36,126.52E0,13)
INSERT INTO ORDERDETAILS VALUES(1070,10211,'S12_3990',28,79.8E0,3)
INSERT INTO ORDERDETAILS VALUES(1071,10211,'S18_3278',35,73.17E0,5)
INSERT INTO ORDERDETAILS VALUES(1072,10211,'S18_3482',28,138.17E0,4)
INSERT INTO ORDERDETAILS VALUES(1073,10211,'S18_3782',46,60.3E0,8)
INSERT INTO ORDERDETAILS VALUES(1074,10211,'S18_4721',41,148.8E0,7)
INSERT INTO ORDERDETAILS VALUES(1075,10211,'S24_1578',25,109.32E0,15)
INSERT INTO ORDERDETAILS VALUES(1076,10211,'S24_2360',21,62.33E0,11)
INSERT INTO ORDERDETAILS VALUES(1077,10211,'S24_3371',48,52.66E0,1)
INSERT INTO ORDERDETAILS VALUES(1078,10211,'S24_4620',22,80.84E0,6)
INSERT INTO ORDERDETAILS VALUES(1079,10211,'S32_2206',41,39.83E0,9)
INSERT INTO ORDERDETAILS VALUES(1080,10211,'S32_4485',37,94.91E0,12)
INSERT INTO ORDERDETAILS VALUES(1081,10211,'S50_4713',40,70.78E0,10)
INSERT INTO ORDERDETAILS VALUES(1082,10212,'S12_3380',39,99.82E0,16)
INSERT INTO ORDERDETAILS VALUES(1083,10212,'S12_4675',33,110.55E0,15)
INSERT INTO ORDERDETAILS VALUES(1084,10212,'S18_1129',29,117.48E0,10)
INSERT INTO ORDERDETAILS VALUES(1085,10212,'S18_1589',38,105.77E0,6)
INSERT INTO ORDERDETAILS VALUES(1086,10212,'S18_1889',20,64.68E0,14)
INSERT INTO ORDERDETAILS VALUES(1087,10212,'S18_1984',41,133.72E0,9)
INSERT INTO ORDERDETAILS VALUES(1088,10212,'S18_2870',40,117.48E0,7)
INSERT INTO ORDERDETAILS VALUES(1089,10212,'S18_3232',40,155.79E0,11)
INSERT INTO ORDERDETAILS VALUES(1090,10212,'S18_3685',45,115.85E0,8)
INSERT INTO ORDERDETAILS VALUES(1091,10212,'S24_1046',41,61.73E0,3)
INSERT INTO ORDERDETAILS VALUES(1092,10212,'S24_1628',45,43.27E0,5)
INSERT INTO ORDERDETAILS VALUES(1093,10212,'S24_2766',45,81.78E0,1)
INSERT INTO ORDERDETAILS VALUES(1094,10212,'S24_2972',34,37.38E0,12)
INSERT INTO ORDERDETAILS VALUES(1095,10212,'S24_3191',27,77.91E0,2)
INSERT INTO ORDERDETAILS VALUES(1096,10212,'S24_3432',46,100.66E0,4)
INSERT INTO ORDERDETAILS VALUES(1097,10212,'S24_3856',49,117.96E0,13)
INSERT INTO ORDERDETAILS VALUES(1098,10213,'S18_4409',38,84.67E0,1)
INSERT INTO ORDERDETAILS VALUES(1099,10213,'S18_4933',25,58.44E0,2)
INSERT INTO ORDERDETAILS VALUES(1100,10213,'S24_2887',27,97.48E0,3)
INSERT INTO ORDERDETAILS VALUES(1101,10214,'S18_1749',30,166.6E0,7)
INSERT INTO ORDERDETAILS VALUES(1102,10214,'S18_2248',21,53.28E0,6)
INSERT INTO ORDERDETAILS VALUES(1103,10214,'S18_2325',27,125.86E0,4)
INSERT INTO ORDERDETAILS VALUES(1104,10214,'S18_2795',50,167.06E0,1)
INSERT INTO ORDERDETAILS VALUES(1105,10214,'S24_1937',20,32.19E0,3)
INSERT INTO ORDERDETAILS VALUES(1106,10214,'S24_2022',49,39.87E0,2)
INSERT INTO ORDERDETAILS VALUES(1107,10214,'S24_3969',44,38.57E0,5)
INSERT INTO ORDERDETAILS VALUES(1108,10215,'S10_1949',35,205.73E0,3)
INSERT INTO ORDERDETAILS VALUES(1109,10215,'S18_1097',46,100.34E0,2)
INSERT INTO ORDERDETAILS VALUES(1110,10215,'S18_1342',27,92.47E0,10)
INSERT INTO ORDERDETAILS VALUES(1111,10215,'S18_1367',33,53.91E0,9)
INSERT INTO ORDERDETAILS VALUES(1112,10215,'S18_2949',49,97.26E0,4)
INSERT INTO ORDERDETAILS VALUES(1113,10215,'S18_2957',31,56.21E0,6)
INSERT INTO ORDERDETAILS VALUES(1114,10215,'S18_3136',49,89.01E0,5)
INSERT INTO ORDERDETAILS VALUES(1115,10215,'S18_3320',41,84.33E0,8)
INSERT INTO ORDERDETAILS VALUES(1116,10215,'S18_4668',46,42.76E0,1)
INSERT INTO ORDERDETAILS VALUES(1117,10215,'S24_4258',39,94.47E0,7)
INSERT INTO ORDERDETAILS VALUES(1118,10216,'S12_1666',43,133.94E0,1)
INSERT INTO ORDERDETAILS VALUES(1119,10217,'S10_4962',48,132.97E0,4)
INSERT INTO ORDERDETAILS VALUES(1120,10217,'S18_2432',35,58.34E0,2)
INSERT INTO ORDERDETAILS VALUES(1121,10217,'S18_4600',38,118.66E0,5)
INSERT INTO ORDERDETAILS VALUES(1122,10217,'S24_2300',28,103.51E0,1)
INSERT INTO ORDERDETAILS VALUES(1123,10217,'S32_1268',21,78.97E0,3)
INSERT INTO ORDERDETAILS VALUES(1124,10217,'S32_3522',39,56.24E0,7)
INSERT INTO ORDERDETAILS VALUES(1125,10217,'S700_2824',31,90.02E0,6)
INSERT INTO ORDERDETAILS VALUES(1126,10218,'S18_2319',22,110.46E0,1)
INSERT INTO ORDERDETAILS VALUES(1127,10218,'S18_3232',34,152.41E0,2)
INSERT INTO ORDERDETAILS VALUES(1128,10219,'S12_4473',48,94.8E0,2)
INSERT INTO ORDERDETAILS VALUES(1129,10219,'S18_2238',43,132.62E0,1)
INSERT INTO ORDERDETAILS VALUES(1130,10219,'S24_2840',21,31.12E0,3)
INSERT INTO ORDERDETAILS VALUES(1131,10219,'S32_2509',35,47.62E0,4)
INSERT INTO ORDERDETAILS VALUES(1132,10220,'S12_1108',32,189.1E0,2)
INSERT INTO ORDERDETAILS VALUES(1133,10220,'S12_3148',30,151.08E0,3)
INSERT INTO ORDERDETAILS VALUES(1134,10220,'S12_3891',27,166.1E0,1)
INSERT INTO ORDERDETAILS VALUES(1135,10220,'S18_4027',50,126.39E0,5)
INSERT INTO ORDERDETAILS VALUES(1136,10220,'S24_1444',26,48.55E0,8)
INSERT INTO ORDERDETAILS VALUES(1137,10220,'S24_4048',37,101.72E0,7)
INSERT INTO ORDERDETAILS VALUES(1138,10220,'S32_3207',20,49.71E0,6)
INSERT INTO ORDERDETAILS VALUES(1139,10220,'S50_1392',37,92.6E0,9)
INSERT INTO ORDERDETAILS VALUES(1140,10220,'S50_1514',30,56.82E0,4)
INSERT INTO ORDERDETAILS VALUES(1141,10221,'S18_3140',33,133.86E0,3)
INSERT INTO ORDERDETAILS VALUES(1142,10221,'S18_3259',23,89.75E0,5)
INSERT INTO ORDERDETAILS VALUES(1143,10221,'S18_4522',39,84.26E0,2)
INSERT INTO ORDERDETAILS VALUES(1144,10221,'S24_2011',49,113.06E0,1)
INSERT INTO ORDERDETAILS VALUES(1145,10221,'S700_1938',23,69.29E0,4)
INSERT INTO ORDERDETAILS VALUES(1146,10222,'S10_4757',49,133.28E0,12)
INSERT INTO ORDERDETAILS VALUES(1147,10222,'S18_1662',49,137.19E0,4)
INSERT INTO ORDERDETAILS VALUES(1148,10222,'S18_3029',49,79.14E0,10)
INSERT INTO ORDERDETAILS VALUES(1149,10222,'S18_3856',45,88.93E0,9)
INSERT INTO ORDERDETAILS VALUES(1150,10222,'S24_2841',32,56.86E0,5)
INSERT INTO ORDERDETAILS VALUES(1151,10222,'S24_3151',47,74.35E0,14)
INSERT INTO ORDERDETAILS VALUES(1152,10222,'S24_3420',43,61.15E0,6)
INSERT INTO ORDERDETAILS VALUES(1153,10222,'S24_3816',46,77.99E0,11)
INSERT INTO ORDERDETAILS VALUES(1154,10222,'S24_3949',48,55.27E0,3)
INSERT INTO ORDERDETAILS VALUES(1155,10222,'S700_1138',31,58.67E0,15)
INSERT INTO ORDERDETAILS VALUES(1156,10222,'S700_2047',26,80.56E0,8)
INSERT INTO ORDERDETAILS VALUES(1157,10222,'S700_2466',37,90.75E0,1)
INSERT INTO ORDERDETAILS VALUES(1158,10222,'S700_2610',36,69.39E0,13)
INSERT INTO ORDERDETAILS VALUES(1159,10222,'S700_3505',38,84.14E0,16)
INSERT INTO ORDERDETAILS VALUES(1160,10222,'S700_3962',31,81.43E0,17)
INSERT INTO ORDERDETAILS VALUES(1161,10222,'S700_4002',43,66.63E0,2)
INSERT INTO ORDERDETAILS VALUES(1162,10222,'S72_1253',31,45.19E0,7)
INSERT INTO ORDERDETAILS VALUES(1163,10222,'S72_3212',36,48.59E0,18)
INSERT INTO ORDERDETAILS VALUES(1164,10223,'S10_1678',37,80.39E0,1)
INSERT INTO ORDERDETAILS VALUES(1165,10223,'S10_2016',47,110.61E0,4)
INSERT INTO ORDERDETAILS VALUES(1166,10223,'S10_4698',49,189.79E0,3)
INSERT INTO ORDERDETAILS VALUES(1167,10223,'S18_2581',47,67.58E0,9)
INSERT INTO ORDERDETAILS VALUES(1168,10223,'S18_2625',28,58.75E0,5)
INSERT INTO ORDERDETAILS VALUES(1169,10223,'S24_1578',32,104.81E0,2)
INSERT INTO ORDERDETAILS VALUES(1170,10223,'S24_1785',34,87.54E0,11)
INSERT INTO ORDERDETAILS VALUES(1171,10223,'S24_2000',38,60.94E0,6)
INSERT INTO ORDERDETAILS VALUES(1172,10223,'S24_4278',23,68.1E0,10)
INSERT INTO ORDERDETAILS VALUES(1173,10223,'S32_1374',21,90.9E0,7)
INSERT INTO ORDERDETAILS VALUES(1174,10223,'S32_4289',20,66.73E0,12)
INSERT INTO ORDERDETAILS VALUES(1175,10223,'S50_1341',41,41.02E0,13)
INSERT INTO ORDERDETAILS VALUES(1176,10223,'S700_1691',25,84.03E0,14)
INSERT INTO ORDERDETAILS VALUES(1177,10223,'S700_2834',29,113.9E0,8)
INSERT INTO ORDERDETAILS VALUES(1178,10223,'S700_3167',26,79.2E0,15)
INSERT INTO ORDERDETAILS VALUES(1179,10224,'S12_2823',43,141.58E0,6)
INSERT INTO ORDERDETAILS VALUES(1180,10224,'S18_3782',38,57.2E0,1)
INSERT INTO ORDERDETAILS VALUES(1181,10224,'S24_2360',37,60.26E0,4)
INSERT INTO ORDERDETAILS VALUES(1182,10224,'S32_2206',43,37.01E0,2)
INSERT INTO ORDERDETAILS VALUES(1183,10224,'S32_4485',30,94.91E0,5)
INSERT INTO ORDERDETAILS VALUES(1184,10224,'S50_4713',50,81.36E0,3)
INSERT INTO ORDERDETAILS VALUES(1185,10225,'S12_1099',27,157.6E0,9)
INSERT INTO ORDERDETAILS VALUES(1186,10225,'S12_3380',25,101.0E0,7)
INSERT INTO ORDERDETAILS VALUES(1187,10225,'S12_3990',37,64.64E0,10)
INSERT INTO ORDERDETAILS VALUES(1188,10225,'S12_4675',21,100.19E0,6)
INSERT INTO ORDERDETAILS VALUES(1189,10225,'S18_1129',32,116.06E0,1)
INSERT INTO ORDERDETAILS VALUES(1190,10225,'S18_1889',47,71.61E0,5)
INSERT INTO ORDERDETAILS VALUES(1191,10225,'S18_3232',43,162.57E0,2)
INSERT INTO ORDERDETAILS VALUES(1192,10225,'S18_3278',37,69.96E0,12)
INSERT INTO ORDERDETAILS VALUES(1193,10225,'S18_3482',27,119.06E0,11)
INSERT INTO ORDERDETAILS VALUES(1194,10225,'S18_4721',35,135.41E0,14)
INSERT INTO ORDERDETAILS VALUES(1195,10225,'S24_2972',42,34.74E0,3)
INSERT INTO ORDERDETAILS VALUES(1196,10225,'S24_3371',24,51.43E0,8)
INSERT INTO ORDERDETAILS VALUES(1197,10225,'S24_3856',40,130.6E0,4)
INSERT INTO ORDERDETAILS VALUES(1198,10225,'S24_4620',46,77.61E0,13)
INSERT INTO ORDERDETAILS VALUES(1199,10226,'S18_1589',38,108.26E0,4)
INSERT INTO ORDERDETAILS VALUES(1200,10226,'S18_1984',24,129.45E0,7)
INSERT INTO ORDERDETAILS VALUES(1201,10226,'S18_2870',24,125.4E0,5)
INSERT INTO ORDERDETAILS VALUES(1202,10226,'S18_3685',46,122.91E0,6)
INSERT INTO ORDERDETAILS VALUES(1203,10226,'S24_1046',21,65.41E0,1)
INSERT INTO ORDERDETAILS VALUES(1204,10226,'S24_1628',36,47.79E0,3)
INSERT INTO ORDERDETAILS VALUES(1205,10226,'S24_3432',48,95.3E0,2)
INSERT INTO ORDERDETAILS VALUES(1206,10227,'S18_1342',25,85.27E0,3)
INSERT INTO ORDERDETAILS VALUES(1207,10227,'S18_1367',31,50.14E0,2)
INSERT INTO ORDERDETAILS VALUES(1208,10227,'S18_1749',26,136.0E0,10)
INSERT INTO ORDERDETAILS VALUES(1209,10227,'S18_2248',28,59.93E0,9)
INSERT INTO ORDERDETAILS VALUES(1210,10227,'S18_2325',46,118.23E0,7)
INSERT INTO ORDERDETAILS VALUES(1211,10227,'S18_2795',29,146.81E0,4)
INSERT INTO ORDERDETAILS VALUES(1212,10227,'S18_3320',33,99.21E0,1)
INSERT INTO ORDERDETAILS VALUES(1213,10227,'S18_4409',34,87.43E0,11)
INSERT INTO ORDERDETAILS VALUES(1214,10227,'S18_4933',37,70.56E0,12)
INSERT INTO ORDERDETAILS VALUES(1215,10227,'S24_1937',42,27.22E0,6)
INSERT INTO ORDERDETAILS VALUES(1216,10227,'S24_2022',24,39.42E0,5)
INSERT INTO ORDERDETAILS VALUES(1217,10227,'S24_2766',47,84.51E0,14)
INSERT INTO ORDERDETAILS VALUES(1218,10227,'S24_2887',33,102.17E0,13)
INSERT INTO ORDERDETAILS VALUES(1219,10227,'S24_3191',40,78.76E0,15)
INSERT INTO ORDERDETAILS VALUES(1220,10227,'S24_3969',27,34.88E0,8)
INSERT INTO ORDERDETAILS VALUES(1221,10228,'S10_1949',29,214.3E0,2)
INSERT INTO ORDERDETAILS VALUES(1222,10228,'S18_1097',32,100.34E0,1)
INSERT INTO ORDERDETAILS VALUES(1223,10228,'S18_2949',24,101.31E0,3)
INSERT INTO ORDERDETAILS VALUES(1224,10228,'S18_2957',45,57.46E0,5)
INSERT INTO ORDERDETAILS VALUES(1225,10228,'S18_3136',31,100.53E0,4)
INSERT INTO ORDERDETAILS VALUES(1226,10228,'S24_4258',33,84.73E0,6)
INSERT INTO ORDERDETAILS VALUES(1227,10229,'S10_4962',50,138.88E0,9)
INSERT INTO ORDERDETAILS VALUES(1228,10229,'S12_1666',25,110.7E0,13)
INSERT INTO ORDERDETAILS VALUES(1229,10229,'S12_4473',36,95.99E0,1)
INSERT INTO ORDERDETAILS VALUES(1230,10229,'S18_2319',26,104.32E0,4)
INSERT INTO ORDERDETAILS VALUES(1231,10229,'S18_2432',28,53.48E0,7)
INSERT INTO ORDERDETAILS VALUES(1232,10229,'S18_3232',22,157.49E0,5)
INSERT INTO ORDERDETAILS VALUES(1233,10229,'S18_4600',41,119.87E0,10)
INSERT INTO ORDERDETAILS VALUES(1234,10229,'S18_4668',39,43.77E0,14)
INSERT INTO ORDERDETAILS VALUES(1235,10229,'S24_2300',48,115.01E0,6)
INSERT INTO ORDERDETAILS VALUES(1236,10229,'S24_2840',33,34.65E0,2)
INSERT INTO ORDERDETAILS VALUES(1237,10229,'S32_1268',25,78.97E0,8)
INSERT INTO ORDERDETAILS VALUES(1238,10229,'S32_2509',23,49.78E0,3)
INSERT INTO ORDERDETAILS VALUES(1239,10229,'S32_3522',30,52.36E0,12)
INSERT INTO ORDERDETAILS VALUES(1240,10229,'S700_2824',50,91.04E0,11)
INSERT INTO ORDERDETAILS VALUES(1241,10230,'S12_3148',43,128.42E0,1)
INSERT INTO ORDERDETAILS VALUES(1242,10230,'S18_2238',49,153.91E0,8)
INSERT INTO ORDERDETAILS VALUES(1243,10230,'S18_4027',42,142.18E0,3)
INSERT INTO ORDERDETAILS VALUES(1244,10230,'S24_1444',36,47.4E0,6)
INSERT INTO ORDERDETAILS VALUES(1245,10230,'S24_4048',45,99.36E0,5)
INSERT INTO ORDERDETAILS VALUES(1246,10230,'S32_3207',46,59.03E0,4)
INSERT INTO ORDERDETAILS VALUES(1247,10230,'S50_1392',34,100.7E0,7)
INSERT INTO ORDERDETAILS VALUES(1248,10230,'S50_1514',43,57.41E0,2)
INSERT INTO ORDERDETAILS VALUES(1249,10231,'S12_1108',42,193.25E0,2)
INSERT INTO ORDERDETAILS VALUES(1250,10231,'S12_3891',49,147.07E0,1)
INSERT INTO ORDERDETAILS VALUES(1251,10232,'S18_3140',22,133.86E0,6)
INSERT INTO ORDERDETAILS VALUES(1252,10232,'S18_3259',48,97.81E0,8)
INSERT INTO ORDERDETAILS VALUES(1253,10232,'S18_4522',23,78.12E0,5)
INSERT INTO ORDERDETAILS VALUES(1254,10232,'S24_2011',46,113.06E0,4)
INSERT INTO ORDERDETAILS VALUES(1255,10232,'S700_1938',26,84.88E0,7)
INSERT INTO ORDERDETAILS VALUES(1256,10232,'S700_3505',48,86.15E0,1)
INSERT INTO ORDERDETAILS VALUES(1257,10232,'S700_3962',35,81.43E0,2)
INSERT INTO ORDERDETAILS VALUES(1258,10232,'S72_3212',24,48.59E0,3)
INSERT INTO ORDERDETAILS VALUES(1259,10233,'S24_3151',40,70.81E0,2)
INSERT INTO ORDERDETAILS VALUES(1260,10233,'S700_1138',36,66.0E0,3)
INSERT INTO ORDERDETAILS VALUES(1261,10233,'S700_2610',29,67.94E0,1)
INSERT INTO ORDERDETAILS VALUES(1262,10234,'S10_4757',48,118.32E0,9)
INSERT INTO ORDERDETAILS VALUES(1263,10234,'S18_1662',50,146.65E0,1)
INSERT INTO ORDERDETAILS VALUES(1264,10234,'S18_3029',48,84.3E0,7)
INSERT INTO ORDERDETAILS VALUES(1265,10234,'S18_3856',39,85.75E0,6)
INSERT INTO ORDERDETAILS VALUES(1266,10234,'S24_2841',44,67.14E0,2)
INSERT INTO ORDERDETAILS VALUES(1267,10234,'S24_3420',25,65.09E0,3)
INSERT INTO ORDERDETAILS VALUES(1268,10234,'S24_3816',31,78.83E0,8)
INSERT INTO ORDERDETAILS VALUES(1269,10234,'S700_2047',29,83.28E0,5)
INSERT INTO ORDERDETAILS VALUES(1270,10234,'S72_1253',40,45.69E0,4)
INSERT INTO ORDERDETAILS VALUES(1271,10235,'S18_2581',24,81.95E0,3)
INSERT INTO ORDERDETAILS VALUES(1272,10235,'S24_1785',23,89.72E0,5)
INSERT INTO ORDERDETAILS VALUES(1273,10235,'S24_3949',33,55.27E0,12)
INSERT INTO ORDERDETAILS VALUES(1274,10235,'S24_4278',40,63.03E0,4)
INSERT INTO ORDERDETAILS VALUES(1275,10235,'S32_1374',41,90.9E0,1)
INSERT INTO ORDERDETAILS VALUES(1276,10235,'S32_4289',34,66.73E0,6)
INSERT INTO ORDERDETAILS VALUES(1277,10235,'S50_1341',41,37.09E0,7)
INSERT INTO ORDERDETAILS VALUES(1278,10235,'S700_1691',25,88.6E0,8)
INSERT INTO ORDERDETAILS VALUES(1279,10235,'S700_2466',38,92.74E0,10)
INSERT INTO ORDERDETAILS VALUES(1280,10235,'S700_2834',25,116.28E0,2)
INSERT INTO ORDERDETAILS VALUES(1281,10235,'S700_3167',32,73.6E0,9)
INSERT INTO ORDERDETAILS VALUES(1282,10235,'S700_4002',34,70.33E0,11)
INSERT INTO ORDERDETAILS VALUES(1283,10236,'S10_2016',22,105.86E0,1)
INSERT INTO ORDERDETAILS VALUES(1284,10236,'S18_2625',23,52.7E0,2)
INSERT INTO ORDERDETAILS VALUES(1285,10236,'S24_2000',36,65.51E0,3)
INSERT INTO ORDERDETAILS VALUES(1286,10237,'S10_1678',23,91.87E0,7)
INSERT INTO ORDERDETAILS VALUES(1287,10237,'S10_4698',39,158.8E0,9)
INSERT INTO ORDERDETAILS VALUES(1288,10237,'S12_2823',32,129.53E0,6)
INSERT INTO ORDERDETAILS VALUES(1289,10237,'S18_3782',26,49.74E0,1)
INSERT INTO ORDERDETAILS VALUES(1290,10237,'S24_1578',20,109.32E0,8)
INSERT INTO ORDERDETAILS VALUES(1291,10237,'S24_2360',26,62.33E0,4)
INSERT INTO ORDERDETAILS VALUES(1292,10237,'S32_2206',26,35.0E0,2)
INSERT INTO ORDERDETAILS VALUES(1293,10237,'S32_4485',27,94.91E0,5)
INSERT INTO ORDERDETAILS VALUES(1294,10237,'S50_4713',20,78.92E0,3)
INSERT INTO ORDERDETAILS VALUES(1295,10238,'S12_1099',28,161.49E0,3)
INSERT INTO ORDERDETAILS VALUES(1296,10238,'S12_3380',29,104.52E0,1)
INSERT INTO ORDERDETAILS VALUES(1297,10238,'S12_3990',20,73.42E0,4)
INSERT INTO ORDERDETAILS VALUES(1298,10238,'S18_3278',41,68.35E0,6)
INSERT INTO ORDERDETAILS VALUES(1299,10238,'S18_3482',49,144.05E0,5)
INSERT INTO ORDERDETAILS VALUES(1300,10238,'S18_4721',44,120.53E0,8)
INSERT INTO ORDERDETAILS VALUES(1301,10238,'S24_3371',47,53.88E0,2)
INSERT INTO ORDERDETAILS VALUES(1302,10238,'S24_4620',22,67.91E0,7)
INSERT INTO ORDERDETAILS VALUES(1303,10239,'S12_4675',21,100.19E0,5)
INSERT INTO ORDERDETAILS VALUES(1304,10239,'S18_1889',46,70.07E0,4)
INSERT INTO ORDERDETAILS VALUES(1305,10239,'S18_3232',47,135.47E0,1)
INSERT INTO ORDERDETAILS VALUES(1306,10239,'S24_2972',20,32.47E0,2)
INSERT INTO ORDERDETAILS VALUES(1307,10239,'S24_3856',29,133.41E0,3)
INSERT INTO ORDERDETAILS VALUES(1308,10240,'S18_1129',41,125.97E0,3)
INSERT INTO ORDERDETAILS VALUES(1309,10240,'S18_1984',37,136.56E0,2)
INSERT INTO ORDERDETAILS VALUES(1310,10240,'S18_3685',37,134.22E0,1)
INSERT INTO ORDERDETAILS VALUES(1311,10241,'S18_1589',21,119.46E0,11)
INSERT INTO ORDERDETAILS VALUES(1312,10241,'S18_1749',41,153.0E0,2)
INSERT INTO ORDERDETAILS VALUES(1313,10241,'S18_2248',33,55.7E0,1)
INSERT INTO ORDERDETAILS VALUES(1314,10241,'S18_2870',44,126.72E0,12)
INSERT INTO ORDERDETAILS VALUES(1315,10241,'S18_4409',42,77.31E0,3)
INSERT INTO ORDERDETAILS VALUES(1316,10241,'S18_4933',30,62.72E0,4)
INSERT INTO ORDERDETAILS VALUES(1317,10241,'S24_1046',22,72.02E0,8)
INSERT INTO ORDERDETAILS VALUES(1318,10241,'S24_1628',21,47.29E0,10)
INSERT INTO ORDERDETAILS VALUES(1319,10241,'S24_2766',47,89.05E0,6)
INSERT INTO ORDERDETAILS VALUES(1320,10241,'S24_2887',28,117.44E0,5)
INSERT INTO ORDERDETAILS VALUES(1321,10241,'S24_3191',26,69.34E0,7)
INSERT INTO ORDERDETAILS VALUES(1322,10241,'S24_3432',27,107.08E0,9)
INSERT INTO ORDERDETAILS VALUES(1323,10242,'S24_3969',46,36.52E0,1)
INSERT INTO ORDERDETAILS VALUES(1324,10243,'S18_2325',47,111.87E0,2)
INSERT INTO ORDERDETAILS VALUES(1325,10243,'S24_1937',33,30.87E0,1)
INSERT INTO ORDERDETAILS VALUES(1326,10244,'S18_1342',40,99.66E0,7)
INSERT INTO ORDERDETAILS VALUES(1327,10244,'S18_1367',20,48.52E0,6)
INSERT INTO ORDERDETAILS VALUES(1328,10244,'S18_2795',43,141.75E0,8)
INSERT INTO ORDERDETAILS VALUES(1329,10244,'S18_2949',30,87.13E0,1)
INSERT INTO ORDERDETAILS VALUES(1330,10244,'S18_2957',24,54.96E0,3)
INSERT INTO ORDERDETAILS VALUES(1331,10244,'S18_3136',29,85.87E0,2)
INSERT INTO ORDERDETAILS VALUES(1332,10244,'S18_3320',36,87.3E0,5)
INSERT INTO ORDERDETAILS VALUES(1333,10244,'S24_2022',39,42.11E0,9)
INSERT INTO ORDERDETAILS VALUES(1334,10244,'S24_4258',40,97.39E0,4)
INSERT INTO ORDERDETAILS VALUES(1335,10245,'S10_1949',34,195.01E0,9)
INSERT INTO ORDERDETAILS VALUES(1336,10245,'S10_4962',28,147.74E0,2)
INSERT INTO ORDERDETAILS VALUES(1337,10245,'S12_1666',38,120.27E0,6)
INSERT INTO ORDERDETAILS VALUES(1338,10245,'S18_1097',29,114.34E0,8)
INSERT INTO ORDERDETAILS VALUES(1339,10245,'S18_4600',21,111.39E0,3)
INSERT INTO ORDERDETAILS VALUES(1340,10245,'S18_4668',45,48.8E0,7)
INSERT INTO ORDERDETAILS VALUES(1341,10245,'S32_1268',37,81.86E0,1)
INSERT INTO ORDERDETAILS VALUES(1342,10245,'S32_3522',44,54.94E0,5)
INSERT INTO ORDERDETAILS VALUES(1343,10245,'S700_2824',44,81.93E0,4)
INSERT INTO ORDERDETAILS VALUES(1344,10246,'S12_4473',46,99.54E0,5)
INSERT INTO ORDERDETAILS VALUES(1345,10246,'S18_2238',40,144.08E0,4)
INSERT INTO ORDERDETAILS VALUES(1346,10246,'S18_2319',22,100.64E0,8)
INSERT INTO ORDERDETAILS VALUES(1347,10246,'S18_2432',30,57.73E0,11)
INSERT INTO ORDERDETAILS VALUES(1348,10246,'S18_3232',36,145.63E0,9)
INSERT INTO ORDERDETAILS VALUES(1349,10246,'S24_1444',44,46.24E0,2)
INSERT INTO ORDERDETAILS VALUES(1350,10246,'S24_2300',29,118.84E0,10)
INSERT INTO ORDERDETAILS VALUES(1351,10246,'S24_2840',49,34.65E0,6)
INSERT INTO ORDERDETAILS VALUES(1352,10246,'S24_4048',46,100.54E0,1)
INSERT INTO ORDERDETAILS VALUES(1353,10246,'S32_2509',35,45.45E0,7)
INSERT INTO ORDERDETAILS VALUES(1354,10246,'S50_1392',22,113.44E0,3)
INSERT INTO ORDERDETAILS VALUES(1355,10247,'S12_1108',44,195.33E0,2)
INSERT INTO ORDERDETAILS VALUES(1356,10247,'S12_3148',25,140.5E0,3)
INSERT INTO ORDERDETAILS VALUES(1357,10247,'S12_3891',27,167.83E0,1)
INSERT INTO ORDERDETAILS VALUES(1358,10247,'S18_4027',48,143.62E0,5)
INSERT INTO ORDERDETAILS VALUES(1359,10247,'S32_3207',40,58.41E0,6)
INSERT INTO ORDERDETAILS VALUES(1360,10247,'S50_1514',49,51.55E0,4)
INSERT INTO ORDERDETAILS VALUES(1361,10248,'S10_4757',20,126.48E0,3)
INSERT INTO ORDERDETAILS VALUES(1362,10248,'S18_3029',21,80.86E0,1)
INSERT INTO ORDERDETAILS VALUES(1363,10248,'S18_3140',32,133.86E0,12)
INSERT INTO ORDERDETAILS VALUES(1364,10248,'S18_3259',42,95.8E0,14)
INSERT INTO ORDERDETAILS VALUES(1365,10248,'S18_4522',42,87.77E0,11)
INSERT INTO ORDERDETAILS VALUES(1366,10248,'S24_2011',48,122.89E0,10)
INSERT INTO ORDERDETAILS VALUES(1367,10248,'S24_3151',30,85.85E0,5)
INSERT INTO ORDERDETAILS VALUES(1368,10248,'S24_3816',23,83.02E0,2)
INSERT INTO ORDERDETAILS VALUES(1369,10248,'S700_1138',36,66.0E0,6)
INSERT INTO ORDERDETAILS VALUES(1370,10248,'S700_1938',40,81.41E0,13)
INSERT INTO ORDERDETAILS VALUES(1371,10248,'S700_2610',32,69.39E0,4)
INSERT INTO ORDERDETAILS VALUES(1372,10248,'S700_3505',30,84.14E0,7)
INSERT INTO ORDERDETAILS VALUES(1373,10248,'S700_3962',35,92.36E0,8)
INSERT INTO ORDERDETAILS VALUES(1374,10248,'S72_3212',23,53.51E0,9)
INSERT INTO ORDERDETAILS VALUES(1375,10249,'S18_3856',46,88.93E0,5)
INSERT INTO ORDERDETAILS VALUES(1376,10249,'S24_2841',20,54.81E0,1)
INSERT INTO ORDERDETAILS VALUES(1377,10249,'S24_3420',25,65.75E0,2)
INSERT INTO ORDERDETAILS VALUES(1378,10249,'S700_2047',40,85.99E0,4)
INSERT INTO ORDERDETAILS VALUES(1379,10249,'S72_1253',32,49.16E0,3)
INSERT INTO ORDERDETAILS VALUES(1380,10250,'S18_1662',45,148.23E0,14)
INSERT INTO ORDERDETAILS VALUES(1381,10250,'S18_2581',27,84.48E0,4)
INSERT INTO ORDERDETAILS VALUES(1382,10250,'S24_1785',31,95.2E0,6)
INSERT INTO ORDERDETAILS VALUES(1383,10250,'S24_2000',32,63.22E0,1)
INSERT INTO ORDERDETAILS VALUES(1384,10250,'S24_3949',40,61.42E0,13)
INSERT INTO ORDERDETAILS VALUES(1385,10250,'S24_4278',37,72.45E0,5)
INSERT INTO ORDERDETAILS VALUES(1386,10250,'S32_1374',31,99.89E0,2)
INSERT INTO ORDERDETAILS VALUES(1387,10250,'S32_4289',50,62.6E0,7)
INSERT INTO ORDERDETAILS VALUES(1388,10250,'S50_1341',36,36.66E0,8)
INSERT INTO ORDERDETAILS VALUES(1389,10250,'S700_1691',31,91.34E0,9)
INSERT INTO ORDERDETAILS VALUES(1390,10250,'S700_2466',35,90.75E0,11)
INSERT INTO ORDERDETAILS VALUES(1391,10250,'S700_2834',44,98.48E0,3)
INSERT INTO ORDERDETAILS VALUES(1392,10250,'S700_3167',44,76.0E0,10)
INSERT INTO ORDERDETAILS VALUES(1393,10250,'S700_4002',38,65.89E0,12)
INSERT INTO ORDERDETAILS VALUES(1394,10251,'S10_1678',59,93.79E0,2)
INSERT INTO ORDERDETAILS VALUES(1395,10251,'S10_2016',44,115.37E0,5)
INSERT INTO ORDERDETAILS VALUES(1396,10251,'S10_4698',43,172.36E0,4)
INSERT INTO ORDERDETAILS VALUES(1397,10251,'S12_2823',46,129.53E0,1)
INSERT INTO ORDERDETAILS VALUES(1398,10251,'S18_2625',44,58.15E0,6)
INSERT INTO ORDERDETAILS VALUES(1399,10251,'S24_1578',50,91.29E0,3)
INSERT INTO ORDERDETAILS VALUES(1400,10252,'S18_3278',20,74.78E0,2)
INSERT INTO ORDERDETAILS VALUES(1401,10252,'S18_3482',41,145.52E0,1)
INSERT INTO ORDERDETAILS VALUES(1402,10252,'S18_3782',31,50.36E0,5)
INSERT INTO ORDERDETAILS VALUES(1403,10252,'S18_4721',26,127.97E0,4)
INSERT INTO ORDERDETAILS VALUES(1404,10252,'S24_2360',47,63.03E0,8)
INSERT INTO ORDERDETAILS VALUES(1405,10252,'S24_4620',38,69.52E0,3)
INSERT INTO ORDERDETAILS VALUES(1406,10252,'S32_2206',36,36.21E0,6)
INSERT INTO ORDERDETAILS VALUES(1407,10252,'S32_4485',25,93.89E0,9)
INSERT INTO ORDERDETAILS VALUES(1408,10252,'S50_4713',48,72.41E0,7)
INSERT INTO ORDERDETAILS VALUES(1409,10253,'S12_1099',24,157.6E0,13)
INSERT INTO ORDERDETAILS VALUES(1410,10253,'S12_3380',22,102.17E0,11)
INSERT INTO ORDERDETAILS VALUES(1411,10253,'S12_3990',25,67.03E0,14)
INSERT INTO ORDERDETAILS VALUES(1412,10253,'S12_4675',41,109.4E0,10)
INSERT INTO ORDERDETAILS VALUES(1413,10253,'S18_1129',26,130.22E0,5)
INSERT INTO ORDERDETAILS VALUES(1414,10253,'S18_1589',24,103.29E0,1)
INSERT INTO ORDERDETAILS VALUES(1415,10253,'S18_1889',23,67.76E0,9)
INSERT INTO ORDERDETAILS VALUES(1416,10253,'S18_1984',33,130.87E0,4)
INSERT INTO ORDERDETAILS VALUES(1417,10253,'S18_2870',37,114.84E0,2)
INSERT INTO ORDERDETAILS VALUES(1418,10253,'S18_3232',40,145.63E0,6)
INSERT INTO ORDERDETAILS VALUES(1419,10253,'S18_3685',31,139.87E0,3)
INSERT INTO ORDERDETAILS VALUES(1420,10253,'S24_2972',40,34.74E0,7)
INSERT INTO ORDERDETAILS VALUES(1421,10253,'S24_3371',24,50.82E0,12)
INSERT INTO ORDERDETAILS VALUES(1422,10253,'S24_3856',39,115.15E0,8)
INSERT INTO ORDERDETAILS VALUES(1423,10254,'S18_1749',49,137.7E0,5)
INSERT INTO ORDERDETAILS VALUES(1424,10254,'S18_2248',36,55.09E0,4)
INSERT INTO ORDERDETAILS VALUES(1425,10254,'S18_2325',41,102.98E0,2)
INSERT INTO ORDERDETAILS VALUES(1426,10254,'S18_4409',34,80.99E0,6)
INSERT INTO ORDERDETAILS VALUES(1427,10254,'S18_4933',30,59.87E0,7)
INSERT INTO ORDERDETAILS VALUES(1428,10254,'S24_1046',34,66.88E0,11)
INSERT INTO ORDERDETAILS VALUES(1429,10254,'S24_1628',32,43.27E0,13)
INSERT INTO ORDERDETAILS VALUES(1430,10254,'S24_1937',38,28.88E0,1)
INSERT INTO ORDERDETAILS VALUES(1431,10254,'S24_2766',31,85.42E0,9)
INSERT INTO ORDERDETAILS VALUES(1432,10254,'S24_2887',33,111.57E0,8)
INSERT INTO ORDERDETAILS VALUES(1433,10254,'S24_3191',42,69.34E0,10)
INSERT INTO ORDERDETAILS VALUES(1434,10254,'S24_3432',49,101.73E0,12)
INSERT INTO ORDERDETAILS VALUES(1435,10254,'S24_3969',20,39.8E0,3)
INSERT INTO ORDERDETAILS VALUES(1436,10255,'S18_2795',24,135.0E0,1)
INSERT INTO ORDERDETAILS VALUES(1437,10255,'S24_2022',37,37.63E0,2)
INSERT INTO ORDERDETAILS VALUES(1438,10256,'S18_1342',34,93.49E0,2)
INSERT INTO ORDERDETAILS VALUES(1439,10256,'S18_1367',29,52.83E0,1)
INSERT INTO ORDERDETAILS VALUES(1440,10257,'S18_2949',50,92.19E0,1)
INSERT INTO ORDERDETAILS VALUES(1441,10257,'S18_2957',49,59.34E0,3)
INSERT INTO ORDERDETAILS VALUES(1442,10257,'S18_3136',37,83.78E0,2)
INSERT INTO ORDERDETAILS VALUES(1443,10257,'S18_3320',26,91.27E0,5)
INSERT INTO ORDERDETAILS VALUES(1444,10257,'S24_4258',46,81.81E0,4)
INSERT INTO ORDERDETAILS VALUES(1445,10258,'S10_1949',32,177.87E0,6)
INSERT INTO ORDERDETAILS VALUES(1446,10258,'S12_1666',41,133.94E0,3)
INSERT INTO ORDERDETAILS VALUES(1447,10258,'S18_1097',41,113.17E0,5)
INSERT INTO ORDERDETAILS VALUES(1448,10258,'S18_4668',21,49.81E0,4)
INSERT INTO ORDERDETAILS VALUES(1449,10258,'S32_3522',20,62.7E0,2)
INSERT INTO ORDERDETAILS VALUES(1450,10258,'S700_2824',45,86.99E0,1)
INSERT INTO ORDERDETAILS VALUES(1451,10259,'S10_4962',26,121.15E0,12)
INSERT INTO ORDERDETAILS VALUES(1452,10259,'S12_4473',46,117.32E0,4)
INSERT INTO ORDERDETAILS VALUES(1453,10259,'S18_2238',30,134.26E0,3)
INSERT INTO ORDERDETAILS VALUES(1454,10259,'S18_2319',34,120.28E0,7)
INSERT INTO ORDERDETAILS VALUES(1455,10259,'S18_2432',30,59.55E0,10)
INSERT INTO ORDERDETAILS VALUES(1456,10259,'S18_3232',27,152.41E0,8)
INSERT INTO ORDERDETAILS VALUES(1457,10259,'S18_4600',41,107.76E0,13)
INSERT INTO ORDERDETAILS VALUES(1458,10259,'S24_1444',28,46.82E0,1)
INSERT INTO ORDERDETAILS VALUES(1459,10259,'S24_2300',47,121.4E0,9)
INSERT INTO ORDERDETAILS VALUES(1460,10259,'S24_2840',31,31.47E0,5)
INSERT INTO ORDERDETAILS VALUES(1461,10259,'S32_1268',45,95.35E0,11)
INSERT INTO ORDERDETAILS VALUES(1462,10259,'S32_2509',40,45.99E0,6)
INSERT INTO ORDERDETAILS VALUES(1463,10259,'S50_1392',29,105.33E0,2)
INSERT INTO ORDERDETAILS VALUES(1464,10260,'S12_1108',46,180.79E0,5)
INSERT INTO ORDERDETAILS VALUES(1465,10260,'S12_3148',30,140.5E0,6)
INSERT INTO ORDERDETAILS VALUES(1466,10260,'S12_3891',44,169.56E0,4)
INSERT INTO ORDERDETAILS VALUES(1467,10260,'S18_3140',32,121.57E0,1)
INSERT INTO ORDERDETAILS VALUES(1468,10260,'S18_3259',29,92.77E0,3)
INSERT INTO ORDERDETAILS VALUES(1469,10260,'S18_4027',23,137.88E0,8)
INSERT INTO ORDERDETAILS VALUES(1470,10260,'S24_4048',23,117.1E0,10)
INSERT INTO ORDERDETAILS VALUES(1471,10260,'S32_3207',27,55.3E0,9)
INSERT INTO ORDERDETAILS VALUES(1472,10260,'S50_1514',21,56.24E0,7)
INSERT INTO ORDERDETAILS VALUES(1473,10260,'S700_1938',33,80.55E0,2)
INSERT INTO ORDERDETAILS VALUES(1474,10261,'S10_4757',27,116.96E0,1)
INSERT INTO ORDERDETAILS VALUES(1475,10261,'S18_4522',20,80.75E0,9)
INSERT INTO ORDERDETAILS VALUES(1476,10261,'S24_2011',36,105.69E0,8)
INSERT INTO ORDERDETAILS VALUES(1477,10261,'S24_3151',22,79.66E0,3)
INSERT INTO ORDERDETAILS VALUES(1478,10261,'S700_1138',34,64.0E0,4)
INSERT INTO ORDERDETAILS VALUES(1479,10261,'S700_2610',44,58.55E0,2)
INSERT INTO ORDERDETAILS VALUES(1480,10261,'S700_3505',25,89.15E0,5)
INSERT INTO ORDERDETAILS VALUES(1481,10261,'S700_3962',50,88.39E0,6)
INSERT INTO ORDERDETAILS VALUES(1482,10261,'S72_3212',29,43.68E0,7)
INSERT INTO ORDERDETAILS VALUES(1483,10262,'S18_1662',49,157.69E0,9)
INSERT INTO ORDERDETAILS VALUES(1484,10262,'S18_3029',32,81.72E0,15)
INSERT INTO ORDERDETAILS VALUES(1485,10262,'S18_3856',34,85.75E0,14)
INSERT INTO ORDERDETAILS VALUES(1486,10262,'S24_1785',34,98.48E0,1)
INSERT INTO ORDERDETAILS VALUES(1487,10262,'S24_2841',24,63.71E0,10)
INSERT INTO ORDERDETAILS VALUES(1488,10262,'S24_3420',46,65.75E0,11)
INSERT INTO ORDERDETAILS VALUES(1489,10262,'S24_3816',49,82.18E0,16)
INSERT INTO ORDERDETAILS VALUES(1490,10262,'S24_3949',48,58.69E0,8)
INSERT INTO ORDERDETAILS VALUES(1491,10262,'S32_4289',40,63.97E0,2)
INSERT INTO ORDERDETAILS VALUES(1492,10262,'S50_1341',49,35.78E0,3)
INSERT INTO ORDERDETAILS VALUES(1493,10262,'S700_1691',40,87.69E0,4)
INSERT INTO ORDERDETAILS VALUES(1494,10262,'S700_2047',44,83.28E0,13)
INSERT INTO ORDERDETAILS VALUES(1495,10262,'S700_2466',33,81.77E0,6)
INSERT INTO ORDERDETAILS VALUES(1496,10262,'S700_3167',27,64.8E0,5)
INSERT INTO ORDERDETAILS VALUES(1497,10262,'S700_4002',35,64.41E0,7)
INSERT INTO ORDERDETAILS VALUES(1498,10262,'S72_1253',21,41.71E0,12)
INSERT INTO ORDERDETAILS VALUES(1499,10263,'S10_1678',34,89.0E0,2)
INSERT INTO ORDERDETAILS VALUES(1500,10263,'S10_2016',40,107.05E0,5)
INSERT INTO ORDERDETAILS VALUES(1501,10263,'S10_4698',41,193.66E0,4)
INSERT INTO ORDERDETAILS VALUES(1502,10263,'S12_2823',48,123.51E0,1)
INSERT INTO ORDERDETAILS VALUES(1503,10263,'S18_2581',33,67.58E0,10)
INSERT INTO ORDERDETAILS VALUES(1504,10263,'S18_2625',34,50.27E0,6)
INSERT INTO ORDERDETAILS VALUES(1505,10263,'S24_1578',42,109.32E0,3)
INSERT INTO ORDERDETAILS VALUES(1506,10263,'S24_2000',37,67.03E0,7)
INSERT INTO ORDERDETAILS VALUES(1507,10263,'S24_4278',24,59.41E0,11)
INSERT INTO ORDERDETAILS VALUES(1508,10263,'S32_1374',31,93.9E0,8)
INSERT INTO ORDERDETAILS VALUES(1509,10263,'S700_2834',47,117.46E0,9)
INSERT INTO ORDERDETAILS VALUES(1510,10264,'S18_3782',48,58.44E0,3)
INSERT INTO ORDERDETAILS VALUES(1511,10264,'S18_4721',20,124.99E0,2)
INSERT INTO ORDERDETAILS VALUES(1512,10264,'S24_2360',37,61.64E0,6)
INSERT INTO ORDERDETAILS VALUES(1513,10264,'S24_4620',47,75.18E0,1)
INSERT INTO ORDERDETAILS VALUES(1514,10264,'S32_2206',20,39.02E0,4)
INSERT INTO ORDERDETAILS VALUES(1515,10264,'S32_4485',34,100.01E0,7)
INSERT INTO ORDERDETAILS VALUES(1516,10264,'S50_4713',47,67.53E0,5)
INSERT INTO ORDERDETAILS VALUES(1517,10265,'S18_3278',45,74.78E0,2)
INSERT INTO ORDERDETAILS VALUES(1518,10265,'S18_3482',49,123.47E0,1)
INSERT INTO ORDERDETAILS VALUES(1519,10266,'S12_1099',44,188.73E0,14)
INSERT INTO ORDERDETAILS VALUES(1520,10266,'S12_3380',22,110.39E0,12)
INSERT INTO ORDERDETAILS VALUES(1521,10266,'S12_3990',35,67.83E0,15)
INSERT INTO ORDERDETAILS VALUES(1522,10266,'S12_4675',40,112.86E0,11)
INSERT INTO ORDERDETAILS VALUES(1523,10266,'S18_1129',21,131.63E0,6)
INSERT INTO ORDERDETAILS VALUES(1524,10266,'S18_1589',36,99.55E0,2)
INSERT INTO ORDERDETAILS VALUES(1525,10266,'S18_1889',33,77.0E0,10)
INSERT INTO ORDERDETAILS VALUES(1526,10266,'S18_1984',49,139.41E0,5)
INSERT INTO ORDERDETAILS VALUES(1527,10266,'S18_2870',20,113.52E0,3)
INSERT INTO ORDERDETAILS VALUES(1528,10266,'S18_3232',29,137.17E0,7)
INSERT INTO ORDERDETAILS VALUES(1529,10266,'S18_3685',33,127.15E0,4)
INSERT INTO ORDERDETAILS VALUES(1530,10266,'S24_1628',28,40.25E0,1)
INSERT INTO ORDERDETAILS VALUES(1531,10266,'S24_2972',34,35.12E0,8)
INSERT INTO ORDERDETAILS VALUES(1532,10266,'S24_3371',47,56.33E0,13)
INSERT INTO ORDERDETAILS VALUES(1533,10266,'S24_3856',24,119.37E0,9)
INSERT INTO ORDERDETAILS VALUES(1534,10267,'S18_4933',36,71.27E0,1)
INSERT INTO ORDERDETAILS VALUES(1535,10267,'S24_1046',40,72.02E0,5)
INSERT INTO ORDERDETAILS VALUES(1536,10267,'S24_2766',38,76.33E0,3)
INSERT INTO ORDERDETAILS VALUES(1537,10267,'S24_2887',43,93.95E0,2)
INSERT INTO ORDERDETAILS VALUES(1538,10267,'S24_3191',44,83.9E0,4)
INSERT INTO ORDERDETAILS VALUES(1539,10267,'S24_3432',43,98.51E0,6)
INSERT INTO ORDERDETAILS VALUES(1540,10268,'S18_1342',49,93.49E0,3)
INSERT INTO ORDERDETAILS VALUES(1541,10268,'S18_1367',26,45.82E0,2)
INSERT INTO ORDERDETAILS VALUES(1542,10268,'S18_1749',34,164.9E0,10)
INSERT INTO ORDERDETAILS VALUES(1543,10268,'S18_2248',31,60.54E0,9)
INSERT INTO ORDERDETAILS VALUES(1544,10268,'S18_2325',50,124.59E0,7)
INSERT INTO ORDERDETAILS VALUES(1545,10268,'S18_2795',35,148.5E0,4)
INSERT INTO ORDERDETAILS VALUES(1546,10268,'S18_3320',39,96.23E0,1)
INSERT INTO ORDERDETAILS VALUES(1547,10268,'S18_4409',35,84.67E0,11)
INSERT INTO ORDERDETAILS VALUES(1548,10268,'S24_1937',33,31.86E0,6)
INSERT INTO ORDERDETAILS VALUES(1549,10268,'S24_2022',40,36.29E0,5)
INSERT INTO ORDERDETAILS VALUES(1550,10268,'S24_3969',30,37.75E0,8)
INSERT INTO ORDERDETAILS VALUES(1551,10269,'S18_2957',32,57.46E0,1)
INSERT INTO ORDERDETAILS VALUES(1552,10269,'S24_4258',48,95.44E0,2)
INSERT INTO ORDERDETAILS VALUES(1553,10270,'S10_1949',21,171.44E0,9)
INSERT INTO ORDERDETAILS VALUES(1554,10270,'S10_4962',32,124.1E0,2)
INSERT INTO ORDERDETAILS VALUES(1555,10270,'S12_1666',28,135.3E0,6)
INSERT INTO ORDERDETAILS VALUES(1556,10270,'S18_1097',43,94.5E0,8)
INSERT INTO ORDERDETAILS VALUES(1557,10270,'S18_2949',31,81.05E0,10)
INSERT INTO ORDERDETAILS VALUES(1558,10270,'S18_3136',38,85.87E0,11)
INSERT INTO ORDERDETAILS VALUES(1559,10270,'S18_4600',38,107.76E0,3)
INSERT INTO ORDERDETAILS VALUES(1560,10270,'S18_4668',44,40.25E0,7)
INSERT INTO ORDERDETAILS VALUES(1561,10270,'S32_1268',32,93.42E0,1)
INSERT INTO ORDERDETAILS VALUES(1562,10270,'S32_3522',21,52.36E0,5)
INSERT INTO ORDERDETAILS VALUES(1563,10270,'S700_2824',46,101.15E0,4)
INSERT INTO ORDERDETAILS VALUES(1564,10271,'S12_4473',31,99.54E0,5)
INSERT INTO ORDERDETAILS VALUES(1565,10271,'S18_2238',50,147.36E0,4)
INSERT INTO ORDERDETAILS VALUES(1566,10271,'S18_2319',50,121.5E0,8)
INSERT INTO ORDERDETAILS VALUES(1567,10271,'S18_2432',25,59.55E0,11)
INSERT INTO ORDERDETAILS VALUES(1568,10271,'S18_3232',20,169.34E0,9)
INSERT INTO ORDERDETAILS VALUES(1569,10271,'S24_1444',45,49.71E0,2)
INSERT INTO ORDERDETAILS VALUES(1570,10271,'S24_2300',43,122.68E0,10)
INSERT INTO ORDERDETAILS VALUES(1571,10271,'S24_2840',38,28.64E0,6)
INSERT INTO ORDERDETAILS VALUES(1572,10271,'S24_4048',22,110.0E0,1)
INSERT INTO ORDERDETAILS VALUES(1573,10271,'S32_2509',35,51.95E0,7)
INSERT INTO ORDERDETAILS VALUES(1574,10271,'S50_1392',34,93.76E0,3)
INSERT INTO ORDERDETAILS VALUES(1575,10272,'S12_1108',35,187.02E0,2)
INSERT INTO ORDERDETAILS VALUES(1576,10272,'S12_3148',27,123.89E0,3)
INSERT INTO ORDERDETAILS VALUES(1577,10272,'S12_3891',39,148.8E0,1)
INSERT INTO ORDERDETAILS VALUES(1578,10272,'S18_4027',25,126.39E0,5)
INSERT INTO ORDERDETAILS VALUES(1579,10272,'S32_3207',45,56.55E0,6)
INSERT INTO ORDERDETAILS VALUES(1580,10272,'S50_1514',43,53.89E0,4)
INSERT INTO ORDERDETAILS VALUES(1581,10273,'S10_4757',30,136.0E0,4)
INSERT INTO ORDERDETAILS VALUES(1582,10273,'S18_3029',34,84.3E0,2)
INSERT INTO ORDERDETAILS VALUES(1583,10273,'S18_3140',40,117.47E0,13)
INSERT INTO ORDERDETAILS VALUES(1584,10273,'S18_3259',47,87.73E0,15)
INSERT INTO ORDERDETAILS VALUES(1585,10273,'S18_3856',50,105.87E0,1)
INSERT INTO ORDERDETAILS VALUES(1586,10273,'S18_4522',33,72.85E0,12)
INSERT INTO ORDERDETAILS VALUES(1587,10273,'S24_2011',22,103.23E0,11)
INSERT INTO ORDERDETAILS VALUES(1588,10273,'S24_3151',27,84.08E0,6)
INSERT INTO ORDERDETAILS VALUES(1589,10273,'S24_3816',48,83.86E0,3)
INSERT INTO ORDERDETAILS VALUES(1590,10273,'S700_1138',21,66.0E0,7)
INSERT INTO ORDERDETAILS VALUES(1591,10273,'S700_1938',21,77.95E0,14)
INSERT INTO ORDERDETAILS VALUES(1592,10273,'S700_2610',42,57.82E0,5)
INSERT INTO ORDERDETAILS VALUES(1593,10273,'S700_3505',40,91.15E0,8)
INSERT INTO ORDERDETAILS VALUES(1594,10273,'S700_3962',26,89.38E0,9)
INSERT INTO ORDERDETAILS VALUES(1595,10273,'S72_3212',37,51.32E0,10)
INSERT INTO ORDERDETAILS VALUES(1596,10274,'S18_1662',41,129.31E0,1)
INSERT INTO ORDERDETAILS VALUES(1597,10274,'S24_2841',40,56.86E0,2)
INSERT INTO ORDERDETAILS VALUES(1598,10274,'S24_3420',24,65.09E0,3)
INSERT INTO ORDERDETAILS VALUES(1599,10274,'S700_2047',24,75.13E0,5)
INSERT INTO ORDERDETAILS VALUES(1600,10274,'S72_1253',32,49.66E0,4)
INSERT INTO ORDERDETAILS VALUES(1601,10275,'S10_1678',45,81.35E0,1)
INSERT INTO ORDERDETAILS VALUES(1602,10275,'S10_2016',22,115.37E0,4)
INSERT INTO ORDERDETAILS VALUES(1603,10275,'S10_4698',36,154.93E0,3)
INSERT INTO ORDERDETAILS VALUES(1604,10275,'S18_2581',35,70.12E0,9)
INSERT INTO ORDERDETAILS VALUES(1605,10275,'S18_2625',37,52.09E0,5)
INSERT INTO ORDERDETAILS VALUES(1606,10275,'S24_1578',21,105.94E0,2)
INSERT INTO ORDERDETAILS VALUES(1607,10275,'S24_1785',25,97.38E0,11)
INSERT INTO ORDERDETAILS VALUES(1608,10275,'S24_2000',30,61.7E0,6)
INSERT INTO ORDERDETAILS VALUES(1609,10275,'S24_3949',41,58.0E0,18)
INSERT INTO ORDERDETAILS VALUES(1610,10275,'S24_4278',27,67.38E0,10)
INSERT INTO ORDERDETAILS VALUES(1611,10275,'S32_1374',23,89.9E0,7)
INSERT INTO ORDERDETAILS VALUES(1612,10275,'S32_4289',28,58.47E0,12)
INSERT INTO ORDERDETAILS VALUES(1613,10275,'S50_1341',38,40.15E0,13)
INSERT INTO ORDERDETAILS VALUES(1614,10275,'S700_1691',32,85.86E0,14)
INSERT INTO ORDERDETAILS VALUES(1615,10275,'S700_2466',39,82.77E0,16)
INSERT INTO ORDERDETAILS VALUES(1616,10275,'S700_2834',48,102.04E0,8)
INSERT INTO ORDERDETAILS VALUES(1617,10275,'S700_3167',43,72.0E0,15)
INSERT INTO ORDERDETAILS VALUES(1618,10275,'S700_4002',31,59.96E0,17)
INSERT INTO ORDERDETAILS VALUES(1619,10276,'S12_1099',50,184.84E0,3)
INSERT INTO ORDERDETAILS VALUES(1620,10276,'S12_2823',43,150.62E0,14)
INSERT INTO ORDERDETAILS VALUES(1621,10276,'S12_3380',47,104.52E0,1)
INSERT INTO ORDERDETAILS VALUES(1622,10276,'S12_3990',38,67.83E0,4)
INSERT INTO ORDERDETAILS VALUES(1623,10276,'S18_3278',38,78.0E0,6)
INSERT INTO ORDERDETAILS VALUES(1624,10276,'S18_3482',30,139.64E0,5)
INSERT INTO ORDERDETAILS VALUES(1625,10276,'S18_3782',33,54.71E0,9)
INSERT INTO ORDERDETAILS VALUES(1626,10276,'S18_4721',48,120.53E0,8)
INSERT INTO ORDERDETAILS VALUES(1627,10276,'S24_2360',46,61.64E0,12)
INSERT INTO ORDERDETAILS VALUES(1628,10276,'S24_3371',20,58.17E0,2)
INSERT INTO ORDERDETAILS VALUES(1629,10276,'S24_4620',48,67.1E0,7)
INSERT INTO ORDERDETAILS VALUES(1630,10276,'S32_2206',27,35.4E0,10)
INSERT INTO ORDERDETAILS VALUES(1631,10276,'S32_4485',38,94.91E0,13)
INSERT INTO ORDERDETAILS VALUES(1632,10276,'S50_4713',21,67.53E0,11)
INSERT INTO ORDERDETAILS VALUES(1633,10277,'S12_4675',28,93.28E0,1)
INSERT INTO ORDERDETAILS VALUES(1634,10278,'S18_1129',34,114.65E0,6)
INSERT INTO ORDERDETAILS VALUES(1635,10278,'S18_1589',23,107.02E0,2)
INSERT INTO ORDERDETAILS VALUES(1636,10278,'S18_1889',29,73.15E0,10)
INSERT INTO ORDERDETAILS VALUES(1637,10278,'S18_1984',29,118.07E0,5)
INSERT INTO ORDERDETAILS VALUES(1638,10278,'S18_2870',39,117.48E0,3)
INSERT INTO ORDERDETAILS VALUES(1639,10278,'S18_3232',42,167.65E0,7)
INSERT INTO ORDERDETAILS VALUES(1640,10278,'S18_3685',31,114.44E0,4)
INSERT INTO ORDERDETAILS VALUES(1641,10278,'S24_1628',35,48.8E0,1)
INSERT INTO ORDERDETAILS VALUES(1642,10278,'S24_2972',31,37.38E0,8)
INSERT INTO ORDERDETAILS VALUES(1643,10278,'S24_3856',25,136.22E0,9)
INSERT INTO ORDERDETAILS VALUES(1644,10279,'S18_4933',26,68.42E0,1)
INSERT INTO ORDERDETAILS VALUES(1645,10279,'S24_1046',32,68.35E0,5)
INSERT INTO ORDERDETAILS VALUES(1646,10279,'S24_2766',49,76.33E0,3)
INSERT INTO ORDERDETAILS VALUES(1647,10279,'S24_2887',48,106.87E0,2)
INSERT INTO ORDERDETAILS VALUES(1648,10279,'S24_3191',33,78.76E0,4)
INSERT INTO ORDERDETAILS VALUES(1649,10279,'S24_3432',48,95.3E0,6)
INSERT INTO ORDERDETAILS VALUES(1650,10280,'S10_1949',34,205.73E0,2)
INSERT INTO ORDERDETAILS VALUES(1651,10280,'S18_1097',24,98.0E0,1)
INSERT INTO ORDERDETAILS VALUES(1652,10280,'S18_1342',50,87.33E0,9)
INSERT INTO ORDERDETAILS VALUES(1653,10280,'S18_1367',27,47.44E0,8)
INSERT INTO ORDERDETAILS VALUES(1654,10280,'S18_1749',26,161.5E0,16)
INSERT INTO ORDERDETAILS VALUES(1655,10280,'S18_2248',25,53.28E0,15)
INSERT INTO ORDERDETAILS VALUES(1656,10280,'S18_2325',37,109.33E0,13)
INSERT INTO ORDERDETAILS VALUES(1657,10280,'S18_2795',22,158.63E0,10)
INSERT INTO ORDERDETAILS VALUES(1658,10280,'S18_2949',46,82.06E0,3)
INSERT INTO ORDERDETAILS VALUES(1659,10280,'S18_2957',43,54.34E0,5)
INSERT INTO ORDERDETAILS VALUES(1660,10280,'S18_3136',29,102.63E0,4)
INSERT INTO ORDERDETAILS VALUES(1661,10280,'S18_3320',34,99.21E0,7)
INSERT INTO ORDERDETAILS VALUES(1662,10280,'S18_4409',35,77.31E0,17)
INSERT INTO ORDERDETAILS VALUES(1663,10280,'S24_1937',20,29.87E0,12)
INSERT INTO ORDERDETAILS VALUES(1664,10280,'S24_2022',45,36.29E0,11)
INSERT INTO ORDERDETAILS VALUES(1665,10280,'S24_3969',33,35.29E0,14)
INSERT INTO ORDERDETAILS VALUES(1666,10280,'S24_4258',21,79.86E0,6)
INSERT INTO ORDERDETAILS VALUES(1667,10281,'S10_4962',44,132.97E0,9)
INSERT INTO ORDERDETAILS VALUES(1668,10281,'S12_1666',25,127.1E0,13)
INSERT INTO ORDERDETAILS VALUES(1669,10281,'S12_4473',41,98.36E0,1)
INSERT INTO ORDERDETAILS VALUES(1670,10281,'S18_2319',48,114.14E0,4)
INSERT INTO ORDERDETAILS VALUES(1671,10281,'S18_2432',29,56.52E0,7)
INSERT INTO ORDERDETAILS VALUES(1672,10281,'S18_3232',25,135.47E0,5)
INSERT INTO ORDERDETAILS VALUES(1673,10281,'S18_4600',25,96.86E0,10)
INSERT INTO ORDERDETAILS VALUES(1674,10281,'S18_4668',44,42.76E0,14)
INSERT INTO ORDERDETAILS VALUES(1675,10281,'S24_2300',25,112.46E0,6)
INSERT INTO ORDERDETAILS VALUES(1676,10281,'S24_2840',20,33.95E0,2)
INSERT INTO ORDERDETAILS VALUES(1677,10281,'S32_1268',29,80.9E0,8)
INSERT INTO ORDERDETAILS VALUES(1678,10281,'S32_2509',31,44.91E0,3)
INSERT INTO ORDERDETAILS VALUES(1679,10281,'S32_3522',36,59.47E0,12)
INSERT INTO ORDERDETAILS VALUES(1680,10281,'S700_2824',27,89.01E0,11)
INSERT INTO ORDERDETAILS VALUES(1681,10282,'S12_1108',41,176.63E0,5)
INSERT INTO ORDERDETAILS VALUES(1682,10282,'S12_3148',27,142.02E0,6)
INSERT INTO ORDERDETAILS VALUES(1683,10282,'S12_3891',24,169.56E0,4)
INSERT INTO ORDERDETAILS VALUES(1684,10282,'S18_2238',23,147.36E0,13)
INSERT INTO ORDERDETAILS VALUES(1685,10282,'S18_3140',43,122.93E0,1)
INSERT INTO ORDERDETAILS VALUES(1686,10282,'S18_3259',36,88.74E0,3)
INSERT INTO ORDERDETAILS VALUES(1687,10282,'S18_4027',31,132.13E0,8)
INSERT INTO ORDERDETAILS VALUES(1688,10282,'S24_1444',29,49.71E0,11)
INSERT INTO ORDERDETAILS VALUES(1689,10282,'S24_4048',39,96.99E0,10)
INSERT INTO ORDERDETAILS VALUES(1690,10282,'S32_3207',36,51.58E0,9)
INSERT INTO ORDERDETAILS VALUES(1691,10282,'S50_1392',38,114.59E0,12)
INSERT INTO ORDERDETAILS VALUES(1692,10282,'S50_1514',37,56.24E0,7)
INSERT INTO ORDERDETAILS VALUES(1693,10282,'S700_1938',43,77.95E0,2)
INSERT INTO ORDERDETAILS VALUES(1694,10283,'S10_4757',25,130.56E0,6)
INSERT INTO ORDERDETAILS VALUES(1695,10283,'S18_3029',21,78.28E0,4)
INSERT INTO ORDERDETAILS VALUES(1696,10283,'S18_3856',46,100.58E0,3)
INSERT INTO ORDERDETAILS VALUES(1697,10283,'S18_4522',34,71.97E0,14)
INSERT INTO ORDERDETAILS VALUES(1698,10283,'S24_2011',42,99.54E0,13)
INSERT INTO ORDERDETAILS VALUES(1699,10283,'S24_3151',34,80.54E0,8)
INSERT INTO ORDERDETAILS VALUES(1700,10283,'S24_3816',33,77.15E0,5)
INSERT INTO ORDERDETAILS VALUES(1701,10283,'S700_1138',45,62.0E0,9)
INSERT INTO ORDERDETAILS VALUES(1702,10283,'S700_2047',20,74.23E0,2)
INSERT INTO ORDERDETAILS VALUES(1703,10283,'S700_2610',47,68.67E0,7)
INSERT INTO ORDERDETAILS VALUES(1704,10283,'S700_3505',22,88.15E0,10)
INSERT INTO ORDERDETAILS VALUES(1705,10283,'S700_3962',38,85.41E0,11)
INSERT INTO ORDERDETAILS VALUES(1706,10283,'S72_1253',43,41.22E0,1)
INSERT INTO ORDERDETAILS VALUES(1707,10283,'S72_3212',33,49.14E0,12)
INSERT INTO ORDERDETAILS VALUES(1708,10284,'S18_1662',45,137.19E0,11)
INSERT INTO ORDERDETAILS VALUES(1709,10284,'S18_2581',31,68.43E0,1)
INSERT INTO ORDERDETAILS VALUES(1710,10284,'S24_1785',22,101.76E0,3)
INSERT INTO ORDERDETAILS VALUES(1711,10284,'S24_2841',30,65.08E0,12)
INSERT INTO ORDERDETAILS VALUES(1712,10284,'S24_3420',39,59.83E0,13)
INSERT INTO ORDERDETAILS VALUES(1713,10284,'S24_3949',21,65.51E0,10)
INSERT INTO ORDERDETAILS VALUES(1714,10284,'S24_4278',21,66.65E0,2)
INSERT INTO ORDERDETAILS VALUES(1715,10284,'S32_4289',50,60.54E0,4)
INSERT INTO ORDERDETAILS VALUES(1716,10284,'S50_1341',33,35.78E0,5)
INSERT INTO ORDERDETAILS VALUES(1717,10284,'S700_1691',24,87.69E0,6)
INSERT INTO ORDERDETAILS VALUES(1718,10284,'S700_2466',45,95.73E0,8)
INSERT INTO ORDERDETAILS VALUES(1719,10284,'S700_3167',25,68.0E0,7)
INSERT INTO ORDERDETAILS VALUES(1720,10284,'S700_4002',32,73.29E0,9)
INSERT INTO ORDERDETAILS VALUES(1721,10285,'S10_1678',36,95.7E0,6)
INSERT INTO ORDERDETAILS VALUES(1722,10285,'S10_2016',47,110.61E0,9)
INSERT INTO ORDERDETAILS VALUES(1723,10285,'S10_4698',27,166.55E0,8)
INSERT INTO ORDERDETAILS VALUES(1724,10285,'S12_2823',49,131.04E0,5)
INSERT INTO ORDERDETAILS VALUES(1725,10285,'S18_2625',20,50.88E0,10)
INSERT INTO ORDERDETAILS VALUES(1726,10285,'S24_1578',34,91.29E0,7)
INSERT INTO ORDERDETAILS VALUES(1727,10285,'S24_2000',39,61.7E0,11)
INSERT INTO ORDERDETAILS VALUES(1728,10285,'S24_2360',38,64.41E0,3)
INSERT INTO ORDERDETAILS VALUES(1729,10285,'S32_1374',37,82.91E0,12)
INSERT INTO ORDERDETAILS VALUES(1730,10285,'S32_2206',37,36.61E0,1)
INSERT INTO ORDERDETAILS VALUES(1731,10285,'S32_4485',26,100.01E0,4)
INSERT INTO ORDERDETAILS VALUES(1732,10285,'S50_4713',39,76.48E0,2)
INSERT INTO ORDERDETAILS VALUES(1733,10285,'S700_2834',45,102.04E0,13)
INSERT INTO ORDERDETAILS VALUES(1734,10286,'S18_3782',38,51.6E0,1)
INSERT INTO ORDERDETAILS VALUES(1735,10287,'S12_1099',21,190.68E0,12)
INSERT INTO ORDERDETAILS VALUES(1736,10287,'S12_3380',45,117.44E0,10)
INSERT INTO ORDERDETAILS VALUES(1737,10287,'S12_3990',41,74.21E0,13)
INSERT INTO ORDERDETAILS VALUES(1738,10287,'S12_4675',23,107.1E0,9)
INSERT INTO ORDERDETAILS VALUES(1739,10287,'S18_1129',41,113.23E0,4)
INSERT INTO ORDERDETAILS VALUES(1740,10287,'S18_1889',44,61.6E0,8)
INSERT INTO ORDERDETAILS VALUES(1741,10287,'S18_1984',24,123.76E0,3)
INSERT INTO ORDERDETAILS VALUES(1742,10287,'S18_2870',44,114.84E0,1)
INSERT INTO ORDERDETAILS VALUES(1743,10287,'S18_3232',36,137.17E0,5)
INSERT INTO ORDERDETAILS VALUES(1744,10287,'S18_3278',43,68.35E0,15)
INSERT INTO ORDERDETAILS VALUES(1745,10287,'S18_3482',40,127.88E0,14)
INSERT INTO ORDERDETAILS VALUES(1746,10287,'S18_3685',27,139.87E0,2)
INSERT INTO ORDERDETAILS VALUES(1747,10287,'S18_4721',34,119.04E0,17)
INSERT INTO ORDERDETAILS VALUES(1748,10287,'S24_2972',36,31.34E0,6)
INSERT INTO ORDERDETAILS VALUES(1749,10287,'S24_3371',20,58.17E0,11)
INSERT INTO ORDERDETAILS VALUES(1750,10287,'S24_3856',36,137.62E0,7)
INSERT INTO ORDERDETAILS VALUES(1751,10287,'S24_4620',40,79.22E0,16)
INSERT INTO ORDERDETAILS VALUES(1752,10288,'S18_1589',20,120.71E0,14)
INSERT INTO ORDERDETAILS VALUES(1753,10288,'S18_1749',32,168.3E0,5)
INSERT INTO ORDERDETAILS VALUES(1754,10288,'S18_2248',28,50.25E0,4)
INSERT INTO ORDERDETAILS VALUES(1755,10288,'S18_2325',31,102.98E0,2)
INSERT INTO ORDERDETAILS VALUES(1756,10288,'S18_4409',35,90.19E0,6)
INSERT INTO ORDERDETAILS VALUES(1757,10288,'S18_4933',23,57.02E0,7)
INSERT INTO ORDERDETAILS VALUES(1758,10288,'S24_1046',36,66.88E0,11)
INSERT INTO ORDERDETAILS VALUES(1759,10288,'S24_1628',50,49.3E0,13)
INSERT INTO ORDERDETAILS VALUES(1760,10288,'S24_1937',29,32.19E0,1)
INSERT INTO ORDERDETAILS VALUES(1761,10288,'S24_2766',35,81.78E0,9)
INSERT INTO ORDERDETAILS VALUES(1762,10288,'S24_2887',48,109.22E0,8)
INSERT INTO ORDERDETAILS VALUES(1763,10288,'S24_3191',34,76.19E0,10)
INSERT INTO ORDERDETAILS VALUES(1764,10288,'S24_3432',41,101.73E0,12)
INSERT INTO ORDERDETAILS VALUES(1765,10288,'S24_3969',33,37.75E0,3)
INSERT INTO ORDERDETAILS VALUES(1766,10289,'S18_1342',38,92.47E0,2)
INSERT INTO ORDERDETAILS VALUES(1767,10289,'S18_1367',24,44.75E0,1)
INSERT INTO ORDERDETAILS VALUES(1768,10289,'S18_2795',43,141.75E0,3)
INSERT INTO ORDERDETAILS VALUES(1769,10289,'S24_2022',45,41.22E0,4)
INSERT INTO ORDERDETAILS VALUES(1770,10290,'S18_3320',26,80.36E0,2)
INSERT INTO ORDERDETAILS VALUES(1771,10290,'S24_4258',45,83.76E0,1)
INSERT INTO ORDERDETAILS VALUES(1772,10291,'S10_1949',37,210.01E0,11)
INSERT INTO ORDERDETAILS VALUES(1773,10291,'S10_4962',30,141.83E0,4)
INSERT INTO ORDERDETAILS VALUES(1774,10291,'S12_1666',41,123.0E0,8)
INSERT INTO ORDERDETAILS VALUES(1775,10291,'S18_1097',41,96.84E0,10)
INSERT INTO ORDERDETAILS VALUES(1776,10291,'S18_2432',26,52.26E0,2)
INSERT INTO ORDERDETAILS VALUES(1777,10291,'S18_2949',47,99.28E0,12)
INSERT INTO ORDERDETAILS VALUES(1778,10291,'S18_2957',37,56.21E0,14)
INSERT INTO ORDERDETAILS VALUES(1779,10291,'S18_3136',23,93.2E0,13)
INSERT INTO ORDERDETAILS VALUES(1780,10291,'S18_4600',48,96.86E0,5)
INSERT INTO ORDERDETAILS VALUES(1781,10291,'S18_4668',29,45.28E0,9)
INSERT INTO ORDERDETAILS VALUES(1782,10291,'S24_2300',48,109.9E0,1)
INSERT INTO ORDERDETAILS VALUES(1783,10291,'S32_1268',26,82.83E0,3)
INSERT INTO ORDERDETAILS VALUES(1784,10291,'S32_3522',32,53.0E0,7)
INSERT INTO ORDERDETAILS VALUES(1785,10291,'S700_2824',28,86.99E0,6)
INSERT INTO ORDERDETAILS VALUES(1786,10292,'S12_4473',21,94.8E0,8)
INSERT INTO ORDERDETAILS VALUES(1787,10292,'S18_2238',26,140.81E0,7)
INSERT INTO ORDERDETAILS VALUES(1788,10292,'S18_2319',41,103.09E0,11)
INSERT INTO ORDERDETAILS VALUES(1789,10292,'S18_3232',21,147.33E0,12)
INSERT INTO ORDERDETAILS VALUES(1790,10292,'S18_4027',44,114.9E0,2)
INSERT INTO ORDERDETAILS VALUES(1791,10292,'S24_1444',40,48.55E0,5)
INSERT INTO ORDERDETAILS VALUES(1792,10292,'S24_2840',39,34.3E0,9)
INSERT INTO ORDERDETAILS VALUES(1793,10292,'S24_4048',27,113.55E0,4)
INSERT INTO ORDERDETAILS VALUES(1794,10292,'S32_2509',50,54.11E0,10)
INSERT INTO ORDERDETAILS VALUES(1795,10292,'S32_3207',31,59.65E0,3)
INSERT INTO ORDERDETAILS VALUES(1796,10292,'S50_1392',41,113.44E0,6)
INSERT INTO ORDERDETAILS VALUES(1797,10292,'S50_1514',35,49.79E0,1)
INSERT INTO ORDERDETAILS VALUES(1798,10293,'S12_1108',46,187.02E0,8)
INSERT INTO ORDERDETAILS VALUES(1799,10293,'S12_3148',24,129.93E0,9)
INSERT INTO ORDERDETAILS VALUES(1800,10293,'S12_3891',45,171.29E0,7)
INSERT INTO ORDERDETAILS VALUES(1801,10293,'S18_3140',24,110.64E0,4)
INSERT INTO ORDERDETAILS VALUES(1802,10293,'S18_3259',22,91.76E0,6)
INSERT INTO ORDERDETAILS VALUES(1803,10293,'S18_4522',49,72.85E0,3)
INSERT INTO ORDERDETAILS VALUES(1804,10293,'S24_2011',21,111.83E0,2)
INSERT INTO ORDERDETAILS VALUES(1805,10293,'S700_1938',29,77.95E0,5)
INSERT INTO ORDERDETAILS VALUES(1806,10293,'S72_3212',32,51.32E0,1)
INSERT INTO ORDERDETAILS VALUES(1807,10294,'S700_3962',45,98.32E0,1)
INSERT INTO ORDERDETAILS VALUES(1808,10295,'S10_4757',24,136.0E0,1)
INSERT INTO ORDERDETAILS VALUES(1809,10295,'S24_3151',46,84.08E0,3)
INSERT INTO ORDERDETAILS VALUES(1810,10295,'S700_1138',26,62.0E0,4)
INSERT INTO ORDERDETAILS VALUES(1811,10295,'S700_2610',44,71.56E0,2)
INSERT INTO ORDERDETAILS VALUES(1812,10295,'S700_3505',34,93.16E0,5)
INSERT INTO ORDERDETAILS VALUES(1813,10296,'S18_1662',36,146.65E0,7)
INSERT INTO ORDERDETAILS VALUES(1814,10296,'S18_3029',21,69.68E0,13)
INSERT INTO ORDERDETAILS VALUES(1815,10296,'S18_3856',22,105.87E0,12)
INSERT INTO ORDERDETAILS VALUES(1816,10296,'S24_2841',21,60.97E0,8)
INSERT INTO ORDERDETAILS VALUES(1817,10296,'S24_3420',31,63.78E0,9)
INSERT INTO ORDERDETAILS VALUES(1818,10296,'S24_3816',22,83.02E0,14)
INSERT INTO ORDERDETAILS VALUES(1819,10296,'S24_3949',32,63.46E0,6)
INSERT INTO ORDERDETAILS VALUES(1820,10296,'S50_1341',26,41.02E0,1)
INSERT INTO ORDERDETAILS VALUES(1821,10296,'S700_1691',42,75.81E0,2)
INSERT INTO ORDERDETAILS VALUES(1822,10296,'S700_2047',34,89.61E0,11)
INSERT INTO ORDERDETAILS VALUES(1823,10296,'S700_2466',24,96.73E0,4)
INSERT INTO ORDERDETAILS VALUES(1824,10296,'S700_3167',22,74.4E0,3)
INSERT INTO ORDERDETAILS VALUES(1825,10296,'S700_4002',47,61.44E0,5)
INSERT INTO ORDERDETAILS VALUES(1826,10296,'S72_1253',21,46.68E0,10)
INSERT INTO ORDERDETAILS VALUES(1827,10297,'S18_2581',25,81.95E0,4)
INSERT INTO ORDERDETAILS VALUES(1828,10297,'S24_1785',32,107.23E0,6)
INSERT INTO ORDERDETAILS VALUES(1829,10297,'S24_2000',32,70.08E0,1)
INSERT INTO ORDERDETAILS VALUES(1830,10297,'S24_4278',23,71.73E0,5)
INSERT INTO ORDERDETAILS VALUES(1831,10297,'S32_1374',26,88.9E0,2)
INSERT INTO ORDERDETAILS VALUES(1832,10297,'S32_4289',28,63.29E0,7)
INSERT INTO ORDERDETAILS VALUES(1833,10297,'S700_2834',35,111.53E0,3)
INSERT INTO ORDERDETAILS VALUES(1834,10298,'S10_2016',39,105.86E0,1)
INSERT INTO ORDERDETAILS VALUES(1835,10298,'S18_2625',32,60.57E0,2)
INSERT INTO ORDERDETAILS VALUES(1836,10299,'S10_1678',23,76.56E0,9)
INSERT INTO ORDERDETAILS VALUES(1837,10299,'S10_4698',29,164.61E0,11)
INSERT INTO ORDERDETAILS VALUES(1838,10299,'S12_2823',24,123.51E0,8)
INSERT INTO ORDERDETAILS VALUES(1839,10299,'S18_3782',39,62.17E0,3)
INSERT INTO ORDERDETAILS VALUES(1840,10299,'S18_4721',49,119.04E0,2)
INSERT INTO ORDERDETAILS VALUES(1841,10299,'S24_1578',47,107.07E0,10)
INSERT INTO ORDERDETAILS VALUES(1842,10299,'S24_2360',33,58.87E0,6)
INSERT INTO ORDERDETAILS VALUES(1843,10299,'S24_4620',32,66.29E0,1)
INSERT INTO ORDERDETAILS VALUES(1844,10299,'S32_2206',24,36.21E0,4)
INSERT INTO ORDERDETAILS VALUES(1845,10299,'S32_4485',38,84.7E0,7)
INSERT INTO ORDERDETAILS VALUES(1846,10299,'S50_4713',44,77.29E0,5)
INSERT INTO ORDERDETAILS VALUES(1847,10300,'S12_1099',33,184.84E0,5)
INSERT INTO ORDERDETAILS VALUES(1848,10300,'S12_3380',29,116.27E0,3)
INSERT INTO ORDERDETAILS VALUES(1849,10300,'S12_3990',22,76.61E0,6)
INSERT INTO ORDERDETAILS VALUES(1850,10300,'S12_4675',23,95.58E0,2)
INSERT INTO ORDERDETAILS VALUES(1851,10300,'S18_1889',41,63.14E0,1)
INSERT INTO ORDERDETAILS VALUES(1852,10300,'S18_3278',49,65.94E0,8)
INSERT INTO ORDERDETAILS VALUES(1853,10300,'S18_3482',23,144.05E0,7)
INSERT INTO ORDERDETAILS VALUES(1854,10300,'S24_3371',31,52.05E0,4)
INSERT INTO ORDERDETAILS VALUES(1855,10301,'S18_1129',37,114.65E0,8)
INSERT INTO ORDERDETAILS VALUES(1856,10301,'S18_1589',32,118.22E0,4)
INSERT INTO ORDERDETAILS VALUES(1857,10301,'S18_1984',47,119.49E0,7)
INSERT INTO ORDERDETAILS VALUES(1858,10301,'S18_2870',22,113.52E0,5)
INSERT INTO ORDERDETAILS VALUES(1859,10301,'S18_3232',23,135.47E0,9)
INSERT INTO ORDERDETAILS VALUES(1860,10301,'S18_3685',39,137.04E0,6)
INSERT INTO ORDERDETAILS VALUES(1861,10301,'S24_1046',27,64.67E0,1)
INSERT INTO ORDERDETAILS VALUES(1862,10301,'S24_1628',22,40.75E0,3)
INSERT INTO ORDERDETAILS VALUES(1863,10301,'S24_2972',48,32.1E0,10)
INSERT INTO ORDERDETAILS VALUES(1864,10301,'S24_3432',22,86.73E0,2)
INSERT INTO ORDERDETAILS VALUES(1865,10301,'S24_3856',50,122.17E0,11)
INSERT INTO ORDERDETAILS VALUES(1866,10302,'S18_1749',43,166.6E0,1)
INSERT INTO ORDERDETAILS VALUES(1867,10302,'S18_4409',38,82.83E0,2)
INSERT INTO ORDERDETAILS VALUES(1868,10302,'S18_4933',23,70.56E0,3)
INSERT INTO ORDERDETAILS VALUES(1869,10302,'S24_2766',49,75.42E0,5)
INSERT INTO ORDERDETAILS VALUES(1870,10302,'S24_2887',45,104.52E0,4)
INSERT INTO ORDERDETAILS VALUES(1871,10302,'S24_3191',48,74.48E0,6)
INSERT INTO ORDERDETAILS VALUES(1872,10303,'S18_2248',46,56.91E0,2)
INSERT INTO ORDERDETAILS VALUES(1873,10303,'S24_3969',24,35.7E0,1)
INSERT INTO ORDERDETAILS VALUES(1874,10304,'S10_1949',47,201.44E0,6)
INSERT INTO ORDERDETAILS VALUES(1875,10304,'S12_1666',39,117.54E0,3)
INSERT INTO ORDERDETAILS VALUES(1876,10304,'S18_1097',46,106.17E0,5)
INSERT INTO ORDERDETAILS VALUES(1877,10304,'S18_1342',37,95.55E0,13)
INSERT INTO ORDERDETAILS VALUES(1878,10304,'S18_1367',37,46.9E0,12)
INSERT INTO ORDERDETAILS VALUES(1879,10304,'S18_2325',24,102.98E0,17)
INSERT INTO ORDERDETAILS VALUES(1880,10304,'S18_2795',20,141.75E0,14)
INSERT INTO ORDERDETAILS VALUES(1881,10304,'S18_2949',46,98.27E0,7)
INSERT INTO ORDERDETAILS VALUES(1882,10304,'S18_2957',24,54.34E0,9)
INSERT INTO ORDERDETAILS VALUES(1883,10304,'S18_3136',26,90.06E0,8)
INSERT INTO ORDERDETAILS VALUES(1884,10304,'S18_3320',38,95.24E0,11)
INSERT INTO ORDERDETAILS VALUES(1885,10304,'S18_4668',34,44.27E0,4)
INSERT INTO ORDERDETAILS VALUES(1886,10304,'S24_1937',23,29.21E0,16)
INSERT INTO ORDERDETAILS VALUES(1887,10304,'S24_2022',44,42.11E0,15)
INSERT INTO ORDERDETAILS VALUES(1888,10304,'S24_4258',33,80.83E0,10)
INSERT INTO ORDERDETAILS VALUES(1889,10304,'S32_3522',36,52.36E0,2)
INSERT INTO ORDERDETAILS VALUES(1890,10304,'S700_2824',40,80.92E0,1)
INSERT INTO ORDERDETAILS VALUES(1891,10305,'S10_4962',38,130.01E0,13)
INSERT INTO ORDERDETAILS VALUES(1892,10305,'S12_4473',38,107.84E0,5)
INSERT INTO ORDERDETAILS VALUES(1893,10305,'S18_2238',27,132.62E0,4)
INSERT INTO ORDERDETAILS VALUES(1894,10305,'S18_2319',36,117.82E0,8)
INSERT INTO ORDERDETAILS VALUES(1895,10305,'S18_2432',41,58.95E0,11)
INSERT INTO ORDERDETAILS VALUES(1896,10305,'S18_3232',37,160.87E0,9)
INSERT INTO ORDERDETAILS VALUES(1897,10305,'S18_4600',22,112.6E0,14)
INSERT INTO ORDERDETAILS VALUES(1898,10305,'S24_1444',45,48.55E0,2)
INSERT INTO ORDERDETAILS VALUES(1899,10305,'S24_2300',24,107.34E0,10)
INSERT INTO ORDERDETAILS VALUES(1900,10305,'S24_2840',48,30.76E0,6)
INSERT INTO ORDERDETAILS VALUES(1901,10305,'S24_4048',36,118.28E0,1)
INSERT INTO ORDERDETAILS VALUES(1902,10305,'S32_1268',28,94.38E0,12)
INSERT INTO ORDERDETAILS VALUES(1903,10305,'S32_2509',40,48.7E0,7)
INSERT INTO ORDERDETAILS VALUES(1904,10305,'S50_1392',42,109.96E0,3)
INSERT INTO ORDERDETAILS VALUES(1905,10306,'S12_1108',31,182.86E0,13)
INSERT INTO ORDERDETAILS VALUES(1906,10306,'S12_3148',34,145.04E0,14)
INSERT INTO ORDERDETAILS VALUES(1907,10306,'S12_3891',20,145.34E0,12)
INSERT INTO ORDERDETAILS VALUES(1908,10306,'S18_3140',32,114.74E0,9)
INSERT INTO ORDERDETAILS VALUES(1909,10306,'S18_3259',40,83.7E0,11)
INSERT INTO ORDERDETAILS VALUES(1910,10306,'S18_4027',23,126.39E0,16)
INSERT INTO ORDERDETAILS VALUES(1911,10306,'S18_4522',39,85.14E0,8)
INSERT INTO ORDERDETAILS VALUES(1912,10306,'S24_2011',29,109.37E0,7)
INSERT INTO ORDERDETAILS VALUES(1913,10306,'S24_3151',31,76.12E0,2)
INSERT INTO ORDERDETAILS VALUES(1914,10306,'S32_3207',46,60.28E0,17)
INSERT INTO ORDERDETAILS VALUES(1915,10306,'S50_1514',34,51.55E0,15)
INSERT INTO ORDERDETAILS VALUES(1916,10306,'S700_1138',50,61.34E0,3)
INSERT INTO ORDERDETAILS VALUES(1917,10306,'S700_1938',38,73.62E0,10)
INSERT INTO ORDERDETAILS VALUES(1918,10306,'S700_2610',43,62.16E0,1)
INSERT INTO ORDERDETAILS VALUES(1919,10306,'S700_3505',32,99.17E0,4)
INSERT INTO ORDERDETAILS VALUES(1920,10306,'S700_3962',30,87.39E0,5)
INSERT INTO ORDERDETAILS VALUES(1921,10306,'S72_3212',35,48.05E0,6)
INSERT INTO ORDERDETAILS VALUES(1922,10307,'S10_4757',22,118.32E0,9)
INSERT INTO ORDERDETAILS VALUES(1923,10307,'S18_1662',39,135.61E0,1)
INSERT INTO ORDERDETAILS VALUES(1924,10307,'S18_3029',31,71.4E0,7)
INSERT INTO ORDERDETAILS VALUES(1925,10307,'S18_3856',48,92.11E0,6)
INSERT INTO ORDERDETAILS VALUES(1926,10307,'S24_2841',25,58.23E0,2)
INSERT INTO ORDERDETAILS VALUES(1927,10307,'S24_3420',22,64.44E0,3)
INSERT INTO ORDERDETAILS VALUES(1928,10307,'S24_3816',22,75.47E0,8)
INSERT INTO ORDERDETAILS VALUES(1929,10307,'S700_2047',34,81.47E0,5)
INSERT INTO ORDERDETAILS VALUES(1930,10307,'S72_1253',34,44.2E0,4)
INSERT INTO ORDERDETAILS VALUES(1931,10308,'S10_2016',34,115.37E0,2)
INSERT INTO ORDERDETAILS VALUES(1932,10308,'S10_4698',20,187.85E0,1)
INSERT INTO ORDERDETAILS VALUES(1933,10308,'S18_2581',27,81.95E0,7)
INSERT INTO ORDERDETAILS VALUES(1934,10308,'S18_2625',34,48.46E0,3)
INSERT INTO ORDERDETAILS VALUES(1935,10308,'S24_1785',31,99.57E0,9)
INSERT INTO ORDERDETAILS VALUES(1936,10308,'S24_2000',47,68.55E0,4)
INSERT INTO ORDERDETAILS VALUES(1937,10308,'S24_3949',43,58.0E0,16)
INSERT INTO ORDERDETAILS VALUES(1938,10308,'S24_4278',44,71.73E0,8)
INSERT INTO ORDERDETAILS VALUES(1939,10308,'S32_1374',24,99.89E0,5)
INSERT INTO ORDERDETAILS VALUES(1940,10308,'S32_4289',46,61.22E0,10)
INSERT INTO ORDERDETAILS VALUES(1941,10308,'S50_1341',47,37.09E0,11)
INSERT INTO ORDERDETAILS VALUES(1942,10308,'S700_1691',21,73.07E0,12)
INSERT INTO ORDERDETAILS VALUES(1943,10308,'S700_2466',35,88.75E0,14)
INSERT INTO ORDERDETAILS VALUES(1944,10308,'S700_2834',31,100.85E0,6)
INSERT INTO ORDERDETAILS VALUES(1945,10308,'S700_3167',21,79.2E0,13)
INSERT INTO ORDERDETAILS VALUES(1946,10308,'S700_4002',39,62.93E0,15)
INSERT INTO ORDERDETAILS VALUES(1947,10309,'S10_1678',41,94.74E0,5)
INSERT INTO ORDERDETAILS VALUES(1948,10309,'S12_2823',26,144.6E0,4)
INSERT INTO ORDERDETAILS VALUES(1949,10309,'S24_1578',21,96.92E0,6)
INSERT INTO ORDERDETAILS VALUES(1950,10309,'S24_2360',24,59.56E0,2)
INSERT INTO ORDERDETAILS VALUES(1951,10309,'S32_4485',50,93.89E0,3)
INSERT INTO ORDERDETAILS VALUES(1952,10309,'S50_4713',28,74.04E0,1)
INSERT INTO ORDERDETAILS VALUES(1953,10310,'S12_1099',33,165.38E0,10)
INSERT INTO ORDERDETAILS VALUES(1954,10310,'S12_3380',24,105.7E0,8)
INSERT INTO ORDERDETAILS VALUES(1955,10310,'S12_3990',49,77.41E0,11)
INSERT INTO ORDERDETAILS VALUES(1956,10310,'S12_4675',25,101.34E0,7)
INSERT INTO ORDERDETAILS VALUES(1957,10310,'S18_1129',37,128.8E0,2)
INSERT INTO ORDERDETAILS VALUES(1958,10310,'S18_1889',20,66.99E0,6)
INSERT INTO ORDERDETAILS VALUES(1959,10310,'S18_1984',24,129.45E0,1)
INSERT INTO ORDERDETAILS VALUES(1960,10310,'S18_3232',48,159.18E0,3)
INSERT INTO ORDERDETAILS VALUES(1961,10310,'S18_3278',27,70.76E0,13)
INSERT INTO ORDERDETAILS VALUES(1962,10310,'S18_3482',49,122.0E0,12)
INSERT INTO ORDERDETAILS VALUES(1963,10310,'S18_3782',42,59.06E0,16)
INSERT INTO ORDERDETAILS VALUES(1964,10310,'S18_4721',40,133.92E0,15)
INSERT INTO ORDERDETAILS VALUES(1965,10310,'S24_2972',33,33.23E0,4)
INSERT INTO ORDERDETAILS VALUES(1966,10310,'S24_3371',38,50.21E0,9)
INSERT INTO ORDERDETAILS VALUES(1967,10310,'S24_3856',45,139.03E0,5)
INSERT INTO ORDERDETAILS VALUES(1968,10310,'S24_4620',49,75.18E0,14)
INSERT INTO ORDERDETAILS VALUES(1969,10310,'S32_2206',36,38.62E0,17)
INSERT INTO ORDERDETAILS VALUES(1970,10311,'S18_1589',29,124.44E0,9)
INSERT INTO ORDERDETAILS VALUES(1971,10311,'S18_2870',43,114.84E0,10)
INSERT INTO ORDERDETAILS VALUES(1972,10311,'S18_3685',32,134.22E0,11)
INSERT INTO ORDERDETAILS VALUES(1973,10311,'S18_4409',41,92.03E0,1)
INSERT INTO ORDERDETAILS VALUES(1974,10311,'S18_4933',25,66.99E0,2)
INSERT INTO ORDERDETAILS VALUES(1975,10311,'S24_1046',26,70.55E0,6)
INSERT INTO ORDERDETAILS VALUES(1976,10311,'S24_1628',45,48.8E0,8)
INSERT INTO ORDERDETAILS VALUES(1977,10311,'S24_2766',28,89.05E0,4)
INSERT INTO ORDERDETAILS VALUES(1978,10311,'S24_2887',43,116.27E0,3)
INSERT INTO ORDERDETAILS VALUES(1979,10311,'S24_3191',25,85.61E0,5)
INSERT INTO ORDERDETAILS VALUES(1980,10311,'S24_3432',46,91.02E0,7)
INSERT INTO ORDERDETAILS VALUES(1981,10312,'S10_1949',48,214.3E0,3)
INSERT INTO ORDERDETAILS VALUES(1982,10312,'S18_1097',32,101.5E0,2)
INSERT INTO ORDERDETAILS VALUES(1983,10312,'S18_1342',43,102.74E0,10)
INSERT INTO ORDERDETAILS VALUES(1984,10312,'S18_1367',25,43.67E0,9)
INSERT INTO ORDERDETAILS VALUES(1985,10312,'S18_1749',48,146.2E0,17)
INSERT INTO ORDERDETAILS VALUES(1986,10312,'S18_2248',30,48.43E0,16)
INSERT INTO ORDERDETAILS VALUES(1987,10312,'S18_2325',31,111.87E0,14)
INSERT INTO ORDERDETAILS VALUES(1988,10312,'S18_2795',25,150.19E0,11)
INSERT INTO ORDERDETAILS VALUES(1989,10312,'S18_2949',37,91.18E0,4)
INSERT INTO ORDERDETAILS VALUES(1990,10312,'S18_2957',35,54.34E0,6)
INSERT INTO ORDERDETAILS VALUES(1991,10312,'S18_3136',38,93.2E0,5)
INSERT INTO ORDERDETAILS VALUES(1992,10312,'S18_3320',33,84.33E0,8)
INSERT INTO ORDERDETAILS VALUES(1993,10312,'S18_4668',39,44.27E0,1)
INSERT INTO ORDERDETAILS VALUES(1994,10312,'S24_1937',39,27.88E0,13)
INSERT INTO ORDERDETAILS VALUES(1995,10312,'S24_2022',23,43.46E0,12)
INSERT INTO ORDERDETAILS VALUES(1996,10312,'S24_3969',31,40.21E0,15)
INSERT INTO ORDERDETAILS VALUES(1997,10312,'S24_4258',44,96.42E0,7)
INSERT INTO ORDERDETAILS VALUES(1998,10313,'S10_4962',40,141.83E0,7)
INSERT INTO ORDERDETAILS VALUES(1999,10313,'S12_1666',21,131.2E0,11)
INSERT INTO ORDERDETAILS VALUES(2000,10313,'S18_2319',29,109.23E0,2)
INSERT INTO ORDERDETAILS VALUES(2001,10313,'S18_2432',34,52.87E0,5)
INSERT INTO ORDERDETAILS VALUES(2002,10313,'S18_3232',25,143.94E0,3)
INSERT INTO ORDERDETAILS VALUES(2003,10313,'S18_4600',28,110.18E0,8)
INSERT INTO ORDERDETAILS VALUES(2004,10313,'S24_2300',42,102.23E0,4)
INSERT INTO ORDERDETAILS VALUES(2005,10313,'S32_1268',27,96.31E0,6)
INSERT INTO ORDERDETAILS VALUES(2006,10313,'S32_2509',38,48.7E0,1)
INSERT INTO ORDERDETAILS VALUES(2007,10313,'S32_3522',34,55.59E0,10)
INSERT INTO ORDERDETAILS VALUES(2008,10313,'S700_2824',30,96.09E0,9)
INSERT INTO ORDERDETAILS VALUES(2009,10314,'S12_1108',38,176.63E0,5)
INSERT INTO ORDERDETAILS VALUES(2010,10314,'S12_3148',46,125.4E0,6)
INSERT INTO ORDERDETAILS VALUES(2011,10314,'S12_3891',36,169.56E0,4)
INSERT INTO ORDERDETAILS VALUES(2012,10314,'S12_4473',45,95.99E0,14)
INSERT INTO ORDERDETAILS VALUES(2013,10314,'S18_2238',42,135.9E0,13)
INSERT INTO ORDERDETAILS VALUES(2014,10314,'S18_3140',20,129.76E0,1)
INSERT INTO ORDERDETAILS VALUES(2015,10314,'S18_3259',23,84.71E0,3)
INSERT INTO ORDERDETAILS VALUES(2016,10314,'S18_4027',29,129.26E0,8)
INSERT INTO ORDERDETAILS VALUES(2017,10314,'S24_1444',44,51.44E0,11)
INSERT INTO ORDERDETAILS VALUES(2018,10314,'S24_2840',39,31.82E0,15)
INSERT INTO ORDERDETAILS VALUES(2019,10314,'S24_4048',38,111.18E0,10)
INSERT INTO ORDERDETAILS VALUES(2020,10314,'S32_3207',35,58.41E0,9)
INSERT INTO ORDERDETAILS VALUES(2021,10314,'S50_1392',28,115.75E0,12)
INSERT INTO ORDERDETAILS VALUES(2022,10314,'S50_1514',38,50.38E0,7)
INSERT INTO ORDERDETAILS VALUES(2023,10314,'S700_1938',23,83.15E0,2)
INSERT INTO ORDERDETAILS VALUES(2024,10315,'S18_4522',36,78.12E0,7)
INSERT INTO ORDERDETAILS VALUES(2025,10315,'S24_2011',35,111.83E0,6)
INSERT INTO ORDERDETAILS VALUES(2026,10315,'S24_3151',24,78.77E0,1)
INSERT INTO ORDERDETAILS VALUES(2027,10315,'S700_1138',41,60.67E0,2)
INSERT INTO ORDERDETAILS VALUES(2028,10315,'S700_3505',31,99.17E0,3)
INSERT INTO ORDERDETAILS VALUES(2029,10315,'S700_3962',37,88.39E0,4)
INSERT INTO ORDERDETAILS VALUES(2030,10315,'S72_3212',40,51.32E0,5)
INSERT INTO ORDERDETAILS VALUES(2031,10316,'S10_4757',33,126.48E0,17)
INSERT INTO ORDERDETAILS VALUES(2032,10316,'S18_1662',27,140.34E0,9)
INSERT INTO ORDERDETAILS VALUES(2033,10316,'S18_3029',21,72.26E0,15)
INSERT INTO ORDERDETAILS VALUES(2034,10316,'S18_3856',47,89.99E0,14)
INSERT INTO ORDERDETAILS VALUES(2035,10316,'S24_1785',25,93.01E0,1)
INSERT INTO ORDERDETAILS VALUES(2036,10316,'S24_2841',34,67.14E0,10)
INSERT INTO ORDERDETAILS VALUES(2037,10316,'S24_3420',47,55.23E0,11)
INSERT INTO ORDERDETAILS VALUES(2038,10316,'S24_3816',25,77.15E0,16)
INSERT INTO ORDERDETAILS VALUES(2039,10316,'S24_3949',30,67.56E0,8)
INSERT INTO ORDERDETAILS VALUES(2040,10316,'S32_4289',24,59.16E0,2)
INSERT INTO ORDERDETAILS VALUES(2041,10316,'S50_1341',34,36.66E0,3)
INSERT INTO ORDERDETAILS VALUES(2042,10316,'S700_1691',34,74.9E0,4)
INSERT INTO ORDERDETAILS VALUES(2043,10316,'S700_2047',45,73.32E0,13)
INSERT INTO ORDERDETAILS VALUES(2044,10316,'S700_2466',23,85.76E0,6)
INSERT INTO ORDERDETAILS VALUES(2045,10316,'S700_2610',48,67.22E0,18)
INSERT INTO ORDERDETAILS VALUES(2046,10316,'S700_3167',48,77.6E0,5)
INSERT INTO ORDERDETAILS VALUES(2047,10316,'S700_4002',44,68.11E0,7)
INSERT INTO ORDERDETAILS VALUES(2048,10316,'S72_1253',34,43.7E0,12)
INSERT INTO ORDERDETAILS VALUES(2049,10317,'S24_4278',35,69.55E0,1)
INSERT INTO ORDERDETAILS VALUES(2050,10318,'S10_1678',46,84.22E0,1)
INSERT INTO ORDERDETAILS VALUES(2051,10318,'S10_2016',45,102.29E0,4)
INSERT INTO ORDERDETAILS VALUES(2052,10318,'S10_4698',37,189.79E0,3)
INSERT INTO ORDERDETAILS VALUES(2053,10318,'S18_2581',31,81.95E0,9)
INSERT INTO ORDERDETAILS VALUES(2054,10318,'S18_2625',42,49.67E0,5)
INSERT INTO ORDERDETAILS VALUES(2055,10318,'S24_1578',48,93.54E0,2)
INSERT INTO ORDERDETAILS VALUES(2056,10318,'S24_2000',26,60.94E0,6)
INSERT INTO ORDERDETAILS VALUES(2057,10318,'S32_1374',47,81.91E0,7)
INSERT INTO ORDERDETAILS VALUES(2058,10318,'S700_2834',50,102.04E0,8)
INSERT INTO ORDERDETAILS VALUES(2059,10319,'S12_2823',30,134.05E0,9)
INSERT INTO ORDERDETAILS VALUES(2060,10319,'S18_3278',46,77.19E0,1)
INSERT INTO ORDERDETAILS VALUES(2061,10319,'S18_3782',44,54.71E0,4)
INSERT INTO ORDERDETAILS VALUES(2062,10319,'S18_4721',45,120.53E0,3)
INSERT INTO ORDERDETAILS VALUES(2063,10319,'S24_2360',31,65.8E0,7)
INSERT INTO ORDERDETAILS VALUES(2064,10319,'S24_4620',43,78.41E0,2)
INSERT INTO ORDERDETAILS VALUES(2065,10319,'S32_2206',29,35.0E0,5)
INSERT INTO ORDERDETAILS VALUES(2066,10319,'S32_4485',22,96.95E0,8)
INSERT INTO ORDERDETAILS VALUES(2067,10319,'S50_4713',45,79.73E0,6)
INSERT INTO ORDERDETAILS VALUES(2068,10320,'S12_1099',31,184.84E0,3)
INSERT INTO ORDERDETAILS VALUES(2069,10320,'S12_3380',35,102.17E0,1)
INSERT INTO ORDERDETAILS VALUES(2070,10320,'S12_3990',38,63.84E0,4)
INSERT INTO ORDERDETAILS VALUES(2071,10320,'S18_3482',25,139.64E0,5)
INSERT INTO ORDERDETAILS VALUES(2072,10320,'S24_3371',26,60.62E0,2)
INSERT INTO ORDERDETAILS VALUES(2073,10321,'S12_4675',24,105.95E0,15)
INSERT INTO ORDERDETAILS VALUES(2074,10321,'S18_1129',41,123.14E0,10)
INSERT INTO ORDERDETAILS VALUES(2075,10321,'S18_1589',44,120.71E0,6)
INSERT INTO ORDERDETAILS VALUES(2076,10321,'S18_1889',37,73.92E0,14)
INSERT INTO ORDERDETAILS VALUES(2077,10321,'S18_1984',25,142.25E0,9)
INSERT INTO ORDERDETAILS VALUES(2078,10321,'S18_2870',27,126.72E0,7)
INSERT INTO ORDERDETAILS VALUES(2079,10321,'S18_3232',33,164.26E0,11)
INSERT INTO ORDERDETAILS VALUES(2080,10321,'S18_3685',28,138.45E0,8)
INSERT INTO ORDERDETAILS VALUES(2081,10321,'S24_1046',30,68.35E0,3)
INSERT INTO ORDERDETAILS VALUES(2082,10321,'S24_1628',48,42.76E0,5)
INSERT INTO ORDERDETAILS VALUES(2083,10321,'S24_2766',30,74.51E0,1)
INSERT INTO ORDERDETAILS VALUES(2084,10321,'S24_2972',37,31.72E0,12)
INSERT INTO ORDERDETAILS VALUES(2085,10321,'S24_3191',39,81.33E0,2)
INSERT INTO ORDERDETAILS VALUES(2086,10321,'S24_3432',21,103.87E0,4)
INSERT INTO ORDERDETAILS VALUES(2087,10321,'S24_3856',26,137.62E0,13)
INSERT INTO ORDERDETAILS VALUES(2088,10322,'S10_1949',40,180.01E0,1)
INSERT INTO ORDERDETAILS VALUES(2089,10322,'S10_4962',46,141.83E0,8)
INSERT INTO ORDERDETAILS VALUES(2090,10322,'S12_1666',27,136.67E0,9)
INSERT INTO ORDERDETAILS VALUES(2091,10322,'S18_1097',22,101.5E0,10)
INSERT INTO ORDERDETAILS VALUES(2092,10322,'S18_1342',43,92.47E0,14)
INSERT INTO ORDERDETAILS VALUES(2093,10322,'S18_1367',41,44.21E0,5)
INSERT INTO ORDERDETAILS VALUES(2094,10322,'S18_2325',50,120.77E0,6)
INSERT INTO ORDERDETAILS VALUES(2095,10322,'S18_2432',35,57.12E0,11)
INSERT INTO ORDERDETAILS VALUES(2096,10322,'S18_2795',36,158.63E0,2)
INSERT INTO ORDERDETAILS VALUES(2097,10322,'S18_2949',33,100.3E0,12)
INSERT INTO ORDERDETAILS VALUES(2098,10322,'S18_2957',41,54.34E0,13)
INSERT INTO ORDERDETAILS VALUES(2099,10322,'S18_3136',48,90.06E0,7)
INSERT INTO ORDERDETAILS VALUES(2100,10322,'S24_1937',20,26.55E0,3)
INSERT INTO ORDERDETAILS VALUES(2101,10322,'S24_2022',30,40.77E0,4)
INSERT INTO ORDERDETAILS VALUES(2102,10323,'S18_3320',33,88.3E0,2)
INSERT INTO ORDERDETAILS VALUES(2103,10323,'S18_4600',47,96.86E0,1)
INSERT INTO ORDERDETAILS VALUES(2104,10324,'S12_3148',27,148.06E0,1)
INSERT INTO ORDERDETAILS VALUES(2105,10324,'S12_4473',26,100.73E0,7)
INSERT INTO ORDERDETAILS VALUES(2106,10324,'S18_2238',47,142.45E0,8)
INSERT INTO ORDERDETAILS VALUES(2107,10324,'S18_2319',33,105.55E0,10)
INSERT INTO ORDERDETAILS VALUES(2108,10324,'S18_3232',27,137.17E0,12)
INSERT INTO ORDERDETAILS VALUES(2109,10324,'S18_4027',49,120.64E0,13)
INSERT INTO ORDERDETAILS VALUES(2110,10324,'S18_4668',38,49.81E0,6)
INSERT INTO ORDERDETAILS VALUES(2111,10324,'S24_1444',25,49.71E0,14)
INSERT INTO ORDERDETAILS VALUES(2112,10324,'S24_2300',31,107.34E0,2)
INSERT INTO ORDERDETAILS VALUES(2113,10324,'S24_2840',30,29.35E0,9)
INSERT INTO ORDERDETAILS VALUES(2114,10324,'S24_4258',33,95.44E0,3)
INSERT INTO ORDERDETAILS VALUES(2115,10324,'S32_1268',20,91.49E0,11)
INSERT INTO ORDERDETAILS VALUES(2116,10324,'S32_3522',48,60.76E0,4)
INSERT INTO ORDERDETAILS VALUES(2117,10324,'S700_2824',34,80.92E0,5)
INSERT INTO ORDERDETAILS VALUES(2118,10325,'S10_4757',47,111.52E0,6)
INSERT INTO ORDERDETAILS VALUES(2119,10325,'S12_1108',42,193.25E0,8)
INSERT INTO ORDERDETAILS VALUES(2120,10325,'S12_3891',24,166.1E0,1)
INSERT INTO ORDERDETAILS VALUES(2121,10325,'S18_3140',24,114.74E0,9)
INSERT INTO ORDERDETAILS VALUES(2122,10325,'S24_4048',44,114.73E0,5)
INSERT INTO ORDERDETAILS VALUES(2123,10325,'S32_2509',38,44.37E0,3)
INSERT INTO ORDERDETAILS VALUES(2124,10325,'S32_3207',28,55.3E0,2)
INSERT INTO ORDERDETAILS VALUES(2125,10325,'S50_1392',38,99.55E0,4)
INSERT INTO ORDERDETAILS VALUES(2126,10325,'S50_1514',44,56.24E0,7)
INSERT INTO ORDERDETAILS VALUES(2127,10326,'S18_3259',32,94.79E0,6)
INSERT INTO ORDERDETAILS VALUES(2128,10326,'S18_4522',50,73.73E0,5)
INSERT INTO ORDERDETAILS VALUES(2129,10326,'S24_2011',41,120.43E0,4)
INSERT INTO ORDERDETAILS VALUES(2130,10326,'S24_3151',41,86.74E0,3)
INSERT INTO ORDERDETAILS VALUES(2131,10326,'S24_3816',20,81.34E0,2)
INSERT INTO ORDERDETAILS VALUES(2132,10326,'S700_1138',39,60.67E0,1)
INSERT INTO ORDERDETAILS VALUES(2133,10327,'S18_1662',25,154.54E0,6)
INSERT INTO ORDERDETAILS VALUES(2134,10327,'S18_2581',45,74.34E0,8)
INSERT INTO ORDERDETAILS VALUES(2135,10327,'S18_3029',25,74.84E0,5)
INSERT INTO ORDERDETAILS VALUES(2136,10327,'S700_1938',20,79.68E0,7)
INSERT INTO ORDERDETAILS VALUES(2137,10327,'S700_2610',21,65.05E0,1)
INSERT INTO ORDERDETAILS VALUES(2138,10327,'S700_3505',43,85.14E0,2)
INSERT INTO ORDERDETAILS VALUES(2139,10327,'S700_3962',37,83.42E0,3)
INSERT INTO ORDERDETAILS VALUES(2140,10327,'S72_3212',37,48.05E0,4)
INSERT INTO ORDERDETAILS VALUES(2141,10328,'S18_3856',34,104.81E0,6)
INSERT INTO ORDERDETAILS VALUES(2142,10328,'S24_1785',47,87.54E0,14)
INSERT INTO ORDERDETAILS VALUES(2143,10328,'S24_2841',48,67.82E0,1)
INSERT INTO ORDERDETAILS VALUES(2144,10328,'S24_3420',20,56.55E0,2)
INSERT INTO ORDERDETAILS VALUES(2145,10328,'S24_3949',35,55.96E0,3)
INSERT INTO ORDERDETAILS VALUES(2146,10328,'S24_4278',43,69.55E0,4)
INSERT INTO ORDERDETAILS VALUES(2147,10328,'S32_4289',24,57.1E0,5)
INSERT INTO ORDERDETAILS VALUES(2148,10328,'S50_1341',34,42.33E0,7)
INSERT INTO ORDERDETAILS VALUES(2149,10328,'S700_1691',27,84.03E0,8)
INSERT INTO ORDERDETAILS VALUES(2150,10328,'S700_2047',41,75.13E0,9)
INSERT INTO ORDERDETAILS VALUES(2151,10328,'S700_2466',37,95.73E0,10)
INSERT INTO ORDERDETAILS VALUES(2152,10328,'S700_2834',33,117.46E0,11)
INSERT INTO ORDERDETAILS VALUES(2153,10328,'S700_3167',33,71.2E0,13)
INSERT INTO ORDERDETAILS VALUES(2154,10328,'S700_4002',39,69.59E0,12)
INSERT INTO ORDERDETAILS VALUES(2155,10329,'S10_1678',42,80.39E0,1)
INSERT INTO ORDERDETAILS VALUES(2156,10329,'S10_2016',20,109.42E0,2)
INSERT INTO ORDERDETAILS VALUES(2157,10329,'S10_4698',26,164.61E0,3)
INSERT INTO ORDERDETAILS VALUES(2158,10329,'S12_1099',41,182.9E0,5)
INSERT INTO ORDERDETAILS VALUES(2159,10329,'S12_2823',24,128.03E0,6)
INSERT INTO ORDERDETAILS VALUES(2160,10329,'S12_3380',46,117.44E0,13)
INSERT INTO ORDERDETAILS VALUES(2161,10329,'S12_3990',33,74.21E0,14)
INSERT INTO ORDERDETAILS VALUES(2162,10329,'S12_4675',39,102.49E0,15)
INSERT INTO ORDERDETAILS VALUES(2163,10329,'S18_1889',29,66.22E0,9)
INSERT INTO ORDERDETAILS VALUES(2164,10329,'S18_2625',38,55.72E0,12)
INSERT INTO ORDERDETAILS VALUES(2165,10329,'S18_3278',38,65.13E0,10)
INSERT INTO ORDERDETAILS VALUES(2166,10329,'S24_1578',30,104.81E0,7)
INSERT INTO ORDERDETAILS VALUES(2167,10329,'S24_2000',37,71.6E0,4)
INSERT INTO ORDERDETAILS VALUES(2168,10329,'S32_1374',45,80.91E0,11)
INSERT INTO ORDERDETAILS VALUES(2169,10329,'S72_1253',44,41.22E0,8)
INSERT INTO ORDERDETAILS VALUES(2170,10330,'S18_3482',37,136.7E0,3)
INSERT INTO ORDERDETAILS VALUES(2171,10330,'S18_3782',29,59.06E0,2)
INSERT INTO ORDERDETAILS VALUES(2172,10330,'S18_4721',50,133.92E0,4)
INSERT INTO ORDERDETAILS VALUES(2173,10330,'S24_2360',42,56.1E0,1)
INSERT INTO ORDERDETAILS VALUES(2174,10331,'S18_1129',46,120.31E0,6)
INSERT INTO ORDERDETAILS VALUES(2175,10331,'S18_1589',44,99.55E0,14)
INSERT INTO ORDERDETAILS VALUES(2176,10331,'S18_1749',44,154.7E0,7)
INSERT INTO ORDERDETAILS VALUES(2177,10331,'S18_1984',30,135.14E0,8)
INSERT INTO ORDERDETAILS VALUES(2178,10331,'S18_2870',26,130.68E0,10)
INSERT INTO ORDERDETAILS VALUES(2179,10331,'S18_3232',27,169.34E0,11)
INSERT INTO ORDERDETAILS VALUES(2180,10331,'S18_3685',26,132.8E0,12)
INSERT INTO ORDERDETAILS VALUES(2181,10331,'S24_2972',27,37.0E0,13)
INSERT INTO ORDERDETAILS VALUES(2182,10331,'S24_3371',25,55.11E0,9)
INSERT INTO ORDERDETAILS VALUES(2183,10331,'S24_3856',21,139.03E0,1)
INSERT INTO ORDERDETAILS VALUES(2184,10331,'S24_4620',41,70.33E0,2)
INSERT INTO ORDERDETAILS VALUES(2185,10331,'S32_2206',28,33.39E0,3)
INSERT INTO ORDERDETAILS VALUES(2186,10331,'S32_4485',32,100.01E0,4)
INSERT INTO ORDERDETAILS VALUES(2187,10331,'S50_4713',20,74.04E0,5)
INSERT INTO ORDERDETAILS VALUES(2188,10332,'S18_1342',46,89.38E0,15)
INSERT INTO ORDERDETAILS VALUES(2189,10332,'S18_1367',27,51.21E0,16)
INSERT INTO ORDERDETAILS VALUES(2190,10332,'S18_2248',38,53.88E0,9)
INSERT INTO ORDERDETAILS VALUES(2191,10332,'S18_2325',35,116.96E0,8)
INSERT INTO ORDERDETAILS VALUES(2192,10332,'S18_2795',24,138.38E0,1)
INSERT INTO ORDERDETAILS VALUES(2193,10332,'S18_2957',26,53.09E0,17)
INSERT INTO ORDERDETAILS VALUES(2194,10332,'S18_3136',40,100.53E0,18)
INSERT INTO ORDERDETAILS VALUES(2195,10332,'S18_4409',50,92.03E0,2)
INSERT INTO ORDERDETAILS VALUES(2196,10332,'S18_4933',21,70.56E0,3)
INSERT INTO ORDERDETAILS VALUES(2197,10332,'S24_1046',23,61.73E0,4)
INSERT INTO ORDERDETAILS VALUES(2198,10332,'S24_1628',20,47.29E0,5)
INSERT INTO ORDERDETAILS VALUES(2199,10332,'S24_1937',45,29.87E0,6)
INSERT INTO ORDERDETAILS VALUES(2200,10332,'S24_2022',26,43.01E0,10)
INSERT INTO ORDERDETAILS VALUES(2201,10332,'S24_2766',39,84.51E0,7)
INSERT INTO ORDERDETAILS VALUES(2202,10332,'S24_2887',44,108.04E0,11)
INSERT INTO ORDERDETAILS VALUES(2203,10332,'S24_3191',45,77.91E0,12)
INSERT INTO ORDERDETAILS VALUES(2204,10332,'S24_3432',31,94.23E0,13)
INSERT INTO ORDERDETAILS VALUES(2205,10332,'S24_3969',41,34.47E0,14)
INSERT INTO ORDERDETAILS VALUES(2206,10333,'S10_1949',26,188.58E0,3)
INSERT INTO ORDERDETAILS VALUES(2207,10333,'S12_1666',33,121.64E0,6)
INSERT INTO ORDERDETAILS VALUES(2208,10333,'S18_1097',29,110.84E0,7)
INSERT INTO ORDERDETAILS VALUES(2209,10333,'S18_2949',31,95.23E0,5)
INSERT INTO ORDERDETAILS VALUES(2210,10333,'S18_3320',46,95.24E0,2)
INSERT INTO ORDERDETAILS VALUES(2211,10333,'S18_4668',24,42.26E0,8)
INSERT INTO ORDERDETAILS VALUES(2212,10333,'S24_4258',39,95.44E0,1)
INSERT INTO ORDERDETAILS VALUES(2213,10333,'S32_3522',33,62.05E0,4)
INSERT INTO ORDERDETAILS VALUES(2214,10334,'S10_4962',26,130.01E0,2)
INSERT INTO ORDERDETAILS VALUES(2215,10334,'S18_2319',46,108.0E0,6)
INSERT INTO ORDERDETAILS VALUES(2216,10334,'S18_2432',34,52.87E0,1)
INSERT INTO ORDERDETAILS VALUES(2217,10334,'S18_3232',20,147.33E0,3)
INSERT INTO ORDERDETAILS VALUES(2218,10334,'S18_4600',49,101.71E0,4)
INSERT INTO ORDERDETAILS VALUES(2219,10334,'S24_2300',42,117.57E0,5)
INSERT INTO ORDERDETAILS VALUES(2220,10335,'S24_2840',33,32.88E0,2)
INSERT INTO ORDERDETAILS VALUES(2221,10335,'S32_1268',44,77.05E0,1)
INSERT INTO ORDERDETAILS VALUES(2222,10335,'S32_2509',40,49.78E0,3)
INSERT INTO ORDERDETAILS VALUES(2223,10336,'S12_1108',33,176.63E0,10)
INSERT INTO ORDERDETAILS VALUES(2224,10336,'S12_3148',33,126.91E0,11)
INSERT INTO ORDERDETAILS VALUES(2225,10336,'S12_3891',49,141.88E0,1)
INSERT INTO ORDERDETAILS VALUES(2226,10336,'S12_4473',38,95.99E0,3)
INSERT INTO ORDERDETAILS VALUES(2227,10336,'S18_2238',49,153.91E0,6)
INSERT INTO ORDERDETAILS VALUES(2228,10336,'S18_3140',48,135.22E0,12)
INSERT INTO ORDERDETAILS VALUES(2229,10336,'S18_3259',21,100.84E0,7)
INSERT INTO ORDERDETAILS VALUES(2230,10336,'S24_1444',45,49.71E0,4)
INSERT INTO ORDERDETAILS VALUES(2231,10336,'S24_4048',31,113.55E0,5)
INSERT INTO ORDERDETAILS VALUES(2232,10336,'S32_3207',31,59.03E0,9)
INSERT INTO ORDERDETAILS VALUES(2233,10336,'S50_1392',23,109.96E0,8)
INSERT INTO ORDERDETAILS VALUES(2234,10336,'S700_2824',46,94.07E0,2)
INSERT INTO ORDERDETAILS VALUES(2235,10337,'S10_4757',25,131.92E0,8)
INSERT INTO ORDERDETAILS VALUES(2236,10337,'S18_4027',36,140.75E0,3)
INSERT INTO ORDERDETAILS VALUES(2237,10337,'S18_4522',29,76.36E0,2)
INSERT INTO ORDERDETAILS VALUES(2238,10337,'S24_2011',29,119.2E0,4)
INSERT INTO ORDERDETAILS VALUES(2239,10337,'S50_1514',21,54.48E0,6)
INSERT INTO ORDERDETAILS VALUES(2240,10337,'S700_1938',36,73.62E0,9)
INSERT INTO ORDERDETAILS VALUES(2241,10337,'S700_3505',31,84.14E0,1)
INSERT INTO ORDERDETAILS VALUES(2242,10337,'S700_3962',36,83.42E0,7)
INSERT INTO ORDERDETAILS VALUES(2243,10337,'S72_3212',42,49.14E0,5)
INSERT INTO ORDERDETAILS VALUES(2244,10338,'S18_1662',41,137.19E0,1)
INSERT INTO ORDERDETAILS VALUES(2245,10338,'S18_3029',28,80.86E0,3)
INSERT INTO ORDERDETAILS VALUES(2246,10338,'S18_3856',45,93.17E0,2)
INSERT INTO ORDERDETAILS VALUES(2247,10339,'S10_2016',40,117.75E0,4)
INSERT INTO ORDERDETAILS VALUES(2248,10339,'S10_4698',39,178.17E0,3)
INSERT INTO ORDERDETAILS VALUES(2249,10339,'S18_2581',27,79.41E0,2)
INSERT INTO ORDERDETAILS VALUES(2250,10339,'S18_2625',30,48.46E0,1)
INSERT INTO ORDERDETAILS VALUES(2251,10339,'S24_1578',27,96.92E0,10)
INSERT INTO ORDERDETAILS VALUES(2252,10339,'S24_1785',21,106.14E0,7)
INSERT INTO ORDERDETAILS VALUES(2253,10339,'S24_2841',55,67.82E0,12)
INSERT INTO ORDERDETAILS VALUES(2254,10339,'S24_3151',55,73.46E0,13)
INSERT INTO ORDERDETAILS VALUES(2255,10339,'S24_3420',29,57.86E0,14)
INSERT INTO ORDERDETAILS VALUES(2256,10339,'S24_3816',42,72.96E0,16)
INSERT INTO ORDERDETAILS VALUES(2257,10339,'S24_3949',45,57.32E0,11)
INSERT INTO ORDERDETAILS VALUES(2258,10339,'S700_1138',22,53.34E0,5)
INSERT INTO ORDERDETAILS VALUES(2259,10339,'S700_2047',55,86.9E0,15)
INSERT INTO ORDERDETAILS VALUES(2260,10339,'S700_2610',50,62.16E0,9)
INSERT INTO ORDERDETAILS VALUES(2261,10339,'S700_4002',50,66.63E0,8)
INSERT INTO ORDERDETAILS VALUES(2262,10339,'S72_1253',27,49.66E0,6)
INSERT INTO ORDERDETAILS VALUES(2263,10340,'S24_2000',55,62.46E0,8)
INSERT INTO ORDERDETAILS VALUES(2264,10340,'S24_4278',40,63.76E0,1)
INSERT INTO ORDERDETAILS VALUES(2265,10340,'S32_1374',55,95.89E0,2)
INSERT INTO ORDERDETAILS VALUES(2266,10340,'S32_4289',39,67.41E0,3)
INSERT INTO ORDERDETAILS VALUES(2267,10340,'S50_1341',40,37.09E0,4)
INSERT INTO ORDERDETAILS VALUES(2268,10340,'S700_1691',30,73.99E0,5)
INSERT INTO ORDERDETAILS VALUES(2269,10340,'S700_2466',55,81.77E0,7)
INSERT INTO ORDERDETAILS VALUES(2270,10340,'S700_2834',29,98.48E0,6)
INSERT INTO ORDERDETAILS VALUES(2271,10341,'S10_1678',41,84.22E0,9)
INSERT INTO ORDERDETAILS VALUES(2272,10341,'S12_1099',45,192.62E0,2)
INSERT INTO ORDERDETAILS VALUES(2273,10341,'S12_2823',55,120.5E0,8)
INSERT INTO ORDERDETAILS VALUES(2274,10341,'S12_3380',44,111.57E0,1)
INSERT INTO ORDERDETAILS VALUES(2275,10341,'S12_3990',36,77.41E0,10)
INSERT INTO ORDERDETAILS VALUES(2276,10341,'S12_4675',55,109.4E0,7)
INSERT INTO ORDERDETAILS VALUES(2277,10341,'S24_2360',32,63.03E0,6)
INSERT INTO ORDERDETAILS VALUES(2278,10341,'S32_4485',31,95.93E0,4)
INSERT INTO ORDERDETAILS VALUES(2279,10341,'S50_4713',38,78.11E0,3)
INSERT INTO ORDERDETAILS VALUES(2280,10341,'S700_3167',34,70.4E0,5)
INSERT INTO ORDERDETAILS VALUES(2281,10342,'S18_1129',40,118.89E0,2)
INSERT INTO ORDERDETAILS VALUES(2282,10342,'S18_1889',55,63.14E0,1)
INSERT INTO ORDERDETAILS VALUES(2283,10342,'S18_1984',22,115.22E0,3)
INSERT INTO ORDERDETAILS VALUES(2284,10342,'S18_3232',30,167.65E0,4)
INSERT INTO ORDERDETAILS VALUES(2285,10342,'S18_3278',25,76.39E0,5)
INSERT INTO ORDERDETAILS VALUES(2286,10342,'S18_3482',55,136.7E0,7)
INSERT INTO ORDERDETAILS VALUES(2287,10342,'S18_3782',26,57.82E0,8)
INSERT INTO ORDERDETAILS VALUES(2288,10342,'S18_4721',38,124.99E0,11)
INSERT INTO ORDERDETAILS VALUES(2289,10342,'S24_2972',39,30.59E0,9)
INSERT INTO ORDERDETAILS VALUES(2290,10342,'S24_3371',48,60.01E0,10)
INSERT INTO ORDERDETAILS VALUES(2291,10342,'S24_3856',42,112.34E0,6)
INSERT INTO ORDERDETAILS VALUES(2292,10343,'S18_1589',36,109.51E0,4)
INSERT INTO ORDERDETAILS VALUES(2293,10343,'S18_2870',25,118.8E0,3)
INSERT INTO ORDERDETAILS VALUES(2294,10343,'S18_3685',44,127.15E0,2)
INSERT INTO ORDERDETAILS VALUES(2295,10343,'S24_1628',27,44.78E0,6)
INSERT INTO ORDERDETAILS VALUES(2296,10343,'S24_4620',30,76.8E0,1)
INSERT INTO ORDERDETAILS VALUES(2297,10343,'S32_2206',29,37.41E0,5)
INSERT INTO ORDERDETAILS VALUES(2298,10344,'S18_1749',45,168.3E0,1)
INSERT INTO ORDERDETAILS VALUES(2299,10344,'S18_2248',40,49.04E0,2)
INSERT INTO ORDERDETAILS VALUES(2300,10344,'S18_2325',30,118.23E0,3)
INSERT INTO ORDERDETAILS VALUES(2301,10344,'S18_4409',21,80.99E0,4)
INSERT INTO ORDERDETAILS VALUES(2302,10344,'S18_4933',26,68.42E0,5)
INSERT INTO ORDERDETAILS VALUES(2303,10344,'S24_1046',29,61.0E0,7)
INSERT INTO ORDERDETAILS VALUES(2304,10344,'S24_1937',20,27.88E0,6)
INSERT INTO ORDERDETAILS VALUES(2305,10345,'S24_2022',43,38.98E0,1)
INSERT INTO ORDERDETAILS VALUES(2306,10346,'S18_1342',42,88.36E0,3)
INSERT INTO ORDERDETAILS VALUES(2307,10346,'S24_2766',25,87.24E0,1)
INSERT INTO ORDERDETAILS VALUES(2308,10346,'S24_2887',24,117.44E0,5)
INSERT INTO ORDERDETAILS VALUES(2309,10346,'S24_3191',24,80.47E0,2)
INSERT INTO ORDERDETAILS VALUES(2310,10346,'S24_3432',26,103.87E0,6)
INSERT INTO ORDERDETAILS VALUES(2311,10346,'S24_3969',22,38.57E0,4)
INSERT INTO ORDERDETAILS VALUES(2312,10347,'S10_1949',30,188.58E0,1)
INSERT INTO ORDERDETAILS VALUES(2313,10347,'S10_4962',27,132.97E0,2)
INSERT INTO ORDERDETAILS VALUES(2314,10347,'S12_1666',29,132.57E0,3)
INSERT INTO ORDERDETAILS VALUES(2315,10347,'S18_1097',42,113.17E0,5)
INSERT INTO ORDERDETAILS VALUES(2316,10347,'S18_1367',21,46.36E0,7)
INSERT INTO ORDERDETAILS VALUES(2317,10347,'S18_2432',50,51.05E0,8)
INSERT INTO ORDERDETAILS VALUES(2318,10347,'S18_2795',21,136.69E0,6)
INSERT INTO ORDERDETAILS VALUES(2319,10347,'S18_2949',48,84.09E0,9)
INSERT INTO ORDERDETAILS VALUES(2320,10347,'S18_2957',34,60.59E0,10)
INSERT INTO ORDERDETAILS VALUES(2321,10347,'S18_3136',45,95.3E0,11)
INSERT INTO ORDERDETAILS VALUES(2322,10347,'S18_3320',26,84.33E0,12)
INSERT INTO ORDERDETAILS VALUES(2323,10347,'S18_4600',45,115.03E0,4)
INSERT INTO ORDERDETAILS VALUES(2324,10348,'S12_1108',48,207.8E0,8)
INSERT INTO ORDERDETAILS VALUES(2325,10348,'S12_3148',47,122.37E0,4)
INSERT INTO ORDERDETAILS VALUES(2326,10348,'S18_4668',29,43.77E0,6)
INSERT INTO ORDERDETAILS VALUES(2327,10348,'S24_2300',37,107.34E0,1)
INSERT INTO ORDERDETAILS VALUES(2328,10348,'S24_4258',39,82.78E0,2)
INSERT INTO ORDERDETAILS VALUES(2329,10348,'S32_1268',42,90.53E0,3)
INSERT INTO ORDERDETAILS VALUES(2330,10348,'S32_3522',31,62.7E0,5)
INSERT INTO ORDERDETAILS VALUES(2331,10348,'S700_2824',32,100.14E0,7)
INSERT INTO ORDERDETAILS VALUES(2332,10349,'S12_3891',26,166.1E0,10)
INSERT INTO ORDERDETAILS VALUES(2333,10349,'S12_4473',48,114.95E0,9)
INSERT INTO ORDERDETAILS VALUES(2334,10349,'S18_2238',38,142.45E0,8)
INSERT INTO ORDERDETAILS VALUES(2335,10349,'S18_2319',38,117.82E0,7)
INSERT INTO ORDERDETAILS VALUES(2336,10349,'S18_3232',48,164.26E0,6)
INSERT INTO ORDERDETAILS VALUES(2337,10349,'S18_4027',34,140.75E0,5)
INSERT INTO ORDERDETAILS VALUES(2338,10349,'S24_1444',48,50.29E0,4)
INSERT INTO ORDERDETAILS VALUES(2339,10349,'S24_2840',36,31.47E0,3)
INSERT INTO ORDERDETAILS VALUES(2340,10349,'S24_4048',23,111.18E0,2)
INSERT INTO ORDERDETAILS VALUES(2341,10349,'S32_2509',33,44.37E0,1)
INSERT INTO ORDERDETAILS VALUES(2342,10350,'S10_4757',26,110.16E0,5)
INSERT INTO ORDERDETAILS VALUES(2343,10350,'S18_3029',43,84.3E0,6)
INSERT INTO ORDERDETAILS VALUES(2344,10350,'S18_3140',44,135.22E0,1)
INSERT INTO ORDERDETAILS VALUES(2345,10350,'S18_3259',41,94.79E0,2)
INSERT INTO ORDERDETAILS VALUES(2346,10350,'S18_4522',30,70.22E0,3)
INSERT INTO ORDERDETAILS VALUES(2347,10350,'S24_2011',34,98.31E0,7)
INSERT INTO ORDERDETAILS VALUES(2348,10350,'S24_3151',30,86.74E0,9)
INSERT INTO ORDERDETAILS VALUES(2349,10350,'S24_3816',25,77.15E0,10)
INSERT INTO ORDERDETAILS VALUES(2350,10350,'S32_3207',27,61.52E0,14)
INSERT INTO ORDERDETAILS VALUES(2351,10350,'S50_1392',31,104.18E0,8)
INSERT INTO ORDERDETAILS VALUES(2352,10350,'S50_1514',44,56.82E0,17)
INSERT INTO ORDERDETAILS VALUES(2353,10350,'S700_1138',46,56.0E0,11)
INSERT INTO ORDERDETAILS VALUES(2354,10350,'S700_1938',28,76.22E0,4)
INSERT INTO ORDERDETAILS VALUES(2355,10350,'S700_2610',29,68.67E0,12)
INSERT INTO ORDERDETAILS VALUES(2356,10350,'S700_3505',31,87.15E0,13)
INSERT INTO ORDERDETAILS VALUES(2357,10350,'S700_3962',25,97.32E0,16)
INSERT INTO ORDERDETAILS VALUES(2358,10350,'S72_3212',20,48.05E0,15)
INSERT INTO ORDERDETAILS VALUES(2359,10351,'S18_1662',39,143.5E0,1)
INSERT INTO ORDERDETAILS VALUES(2360,10351,'S18_3856',20,104.81E0,2)
INSERT INTO ORDERDETAILS VALUES(2361,10351,'S24_2841',25,64.4E0,5)
INSERT INTO ORDERDETAILS VALUES(2362,10351,'S24_3420',38,53.92E0,4)
INSERT INTO ORDERDETAILS VALUES(2363,10351,'S24_3949',34,68.24E0,3)
INSERT INTO ORDERDETAILS VALUES(2364,10352,'S700_2047',23,75.13E0,3)
INSERT INTO ORDERDETAILS VALUES(2365,10352,'S700_2466',49,87.75E0,2)
INSERT INTO ORDERDETAILS VALUES(2366,10352,'S700_4002',22,62.19E0,1)
INSERT INTO ORDERDETAILS VALUES(2367,10352,'S72_1253',49,46.18E0,4)
INSERT INTO ORDERDETAILS VALUES(2368,10353,'S18_2581',27,71.81E0,1)
INSERT INTO ORDERDETAILS VALUES(2369,10353,'S24_1785',28,107.23E0,2)
INSERT INTO ORDERDETAILS VALUES(2370,10353,'S24_4278',35,69.55E0,3)
INSERT INTO ORDERDETAILS VALUES(2371,10353,'S32_1374',46,86.9E0,5)
INSERT INTO ORDERDETAILS VALUES(2372,10353,'S32_4289',40,68.1E0,7)
INSERT INTO ORDERDETAILS VALUES(2373,10353,'S50_1341',40,35.78E0,8)
INSERT INTO ORDERDETAILS VALUES(2374,10353,'S700_1691',39,73.07E0,9)
INSERT INTO ORDERDETAILS VALUES(2375,10353,'S700_2834',48,98.48E0,4)
INSERT INTO ORDERDETAILS VALUES(2376,10353,'S700_3167',43,74.4E0,6)
INSERT INTO ORDERDETAILS VALUES(2377,10354,'S10_1678',42,84.22E0,6)
INSERT INTO ORDERDETAILS VALUES(2378,10354,'S10_2016',20,95.15E0,2)
INSERT INTO ORDERDETAILS VALUES(2379,10354,'S10_4698',42,178.17E0,3)
INSERT INTO ORDERDETAILS VALUES(2380,10354,'S12_1099',31,157.6E0,9)
INSERT INTO ORDERDETAILS VALUES(2381,10354,'S12_2823',35,141.58E0,4)
INSERT INTO ORDERDETAILS VALUES(2382,10354,'S12_3380',29,98.65E0,11)
INSERT INTO ORDERDETAILS VALUES(2383,10354,'S12_3990',23,76.61E0,12)
INSERT INTO ORDERDETAILS VALUES(2384,10354,'S12_4675',28,100.19E0,13)
INSERT INTO ORDERDETAILS VALUES(2385,10354,'S18_1889',21,76.23E0,8)
INSERT INTO ORDERDETAILS VALUES(2386,10354,'S18_2625',28,49.06E0,10)
INSERT INTO ORDERDETAILS VALUES(2387,10354,'S18_3278',36,69.15E0,7)
INSERT INTO ORDERDETAILS VALUES(2388,10354,'S24_1578',21,96.92E0,5)
INSERT INTO ORDERDETAILS VALUES(2389,10354,'S24_2000',28,62.46E0,1)
INSERT INTO ORDERDETAILS VALUES(2390,10355,'S18_3482',23,117.59E0,7)
INSERT INTO ORDERDETAILS VALUES(2391,10355,'S18_3782',31,60.3E0,1)
INSERT INTO ORDERDETAILS VALUES(2392,10355,'S18_4721',25,124.99E0,2)
INSERT INTO ORDERDETAILS VALUES(2393,10355,'S24_2360',41,56.1E0,3)
INSERT INTO ORDERDETAILS VALUES(2394,10355,'S24_2972',36,37.38E0,4)
INSERT INTO ORDERDETAILS VALUES(2395,10355,'S24_3371',44,60.62E0,6)
INSERT INTO ORDERDETAILS VALUES(2396,10355,'S24_3856',32,137.62E0,8)
INSERT INTO ORDERDETAILS VALUES(2397,10355,'S24_4620',28,75.18E0,9)
INSERT INTO ORDERDETAILS VALUES(2398,10355,'S32_2206',38,32.99E0,10)
INSERT INTO ORDERDETAILS VALUES(2399,10355,'S32_4485',40,93.89E0,5)
INSERT INTO ORDERDETAILS VALUES(2400,10356,'S18_1129',43,120.31E0,8)
INSERT INTO ORDERDETAILS VALUES(2401,10356,'S18_1342',50,82.19E0,9)
INSERT INTO ORDERDETAILS VALUES(2402,10356,'S18_1367',22,44.75E0,6)
INSERT INTO ORDERDETAILS VALUES(2403,10356,'S18_1984',27,130.87E0,2)
INSERT INTO ORDERDETAILS VALUES(2404,10356,'S18_2325',29,106.79E0,3)
INSERT INTO ORDERDETAILS VALUES(2405,10356,'S18_2795',30,158.63E0,1)
INSERT INTO ORDERDETAILS VALUES(2406,10356,'S24_1937',48,31.86E0,5)
INSERT INTO ORDERDETAILS VALUES(2407,10356,'S24_2022',26,42.11E0,7)
INSERT INTO ORDERDETAILS VALUES(2408,10356,'S50_4713',26,78.11E0,4)
INSERT INTO ORDERDETAILS VALUES(2409,10357,'S10_1949',32,199.3E0,10)
INSERT INTO ORDERDETAILS VALUES(2410,10357,'S10_4962',43,135.92E0,9)
INSERT INTO ORDERDETAILS VALUES(2411,10357,'S12_1666',49,109.34E0,8)
INSERT INTO ORDERDETAILS VALUES(2412,10357,'S18_1097',39,112.0E0,1)
INSERT INTO ORDERDETAILS VALUES(2413,10357,'S18_2432',41,58.95E0,7)
INSERT INTO ORDERDETAILS VALUES(2414,10357,'S18_2949',41,91.18E0,6)
INSERT INTO ORDERDETAILS VALUES(2415,10357,'S18_2957',49,59.34E0,5)
INSERT INTO ORDERDETAILS VALUES(2416,10357,'S18_3136',44,104.72E0,4)
INSERT INTO ORDERDETAILS VALUES(2417,10357,'S18_3320',25,84.33E0,3)
INSERT INTO ORDERDETAILS VALUES(2418,10357,'S18_4600',28,105.34E0,2)
INSERT INTO ORDERDETAILS VALUES(2419,10358,'S12_3148',49,129.93E0,5)
INSERT INTO ORDERDETAILS VALUES(2420,10358,'S12_4473',42,98.36E0,9)
INSERT INTO ORDERDETAILS VALUES(2421,10358,'S18_2238',20,142.45E0,10)
INSERT INTO ORDERDETAILS VALUES(2422,10358,'S18_2319',20,99.41E0,11)
INSERT INTO ORDERDETAILS VALUES(2423,10358,'S18_3232',32,137.17E0,12)
INSERT INTO ORDERDETAILS VALUES(2424,10358,'S18_4027',25,117.77E0,13)
INSERT INTO ORDERDETAILS VALUES(2425,10358,'S18_4668',30,46.29E0,8)
INSERT INTO ORDERDETAILS VALUES(2426,10358,'S24_1444',44,56.07E0,14)
INSERT INTO ORDERDETAILS VALUES(2427,10358,'S24_2300',41,127.79E0,7)
INSERT INTO ORDERDETAILS VALUES(2428,10358,'S24_2840',36,33.59E0,4)
INSERT INTO ORDERDETAILS VALUES(2429,10358,'S24_4258',41,88.62E0,6)
INSERT INTO ORDERDETAILS VALUES(2430,10358,'S32_1268',41,82.83E0,1)
INSERT INTO ORDERDETAILS VALUES(2431,10358,'S32_3522',36,51.71E0,2)
INSERT INTO ORDERDETAILS VALUES(2432,10358,'S700_2824',27,85.98E0,3)
INSERT INTO ORDERDETAILS VALUES(2433,10359,'S10_4757',48,122.4E0,6)
INSERT INTO ORDERDETAILS VALUES(2434,10359,'S12_1108',42,180.79E0,8)
INSERT INTO ORDERDETAILS VALUES(2435,10359,'S12_3891',49,162.64E0,5)
INSERT INTO ORDERDETAILS VALUES(2436,10359,'S24_4048',22,108.82E0,7)
INSERT INTO ORDERDETAILS VALUES(2437,10359,'S32_2509',36,45.45E0,3)
INSERT INTO ORDERDETAILS VALUES(2438,10359,'S32_3207',22,62.14E0,1)
INSERT INTO ORDERDETAILS VALUES(2439,10359,'S50_1392',46,99.55E0,2)
INSERT INTO ORDERDETAILS VALUES(2440,10359,'S50_1514',25,47.45E0,4)
INSERT INTO ORDERDETAILS VALUES(2441,10360,'S18_1662',50,126.15E0,12)
INSERT INTO ORDERDETAILS VALUES(2442,10360,'S18_2581',41,68.43E0,13)
INSERT INTO ORDERDETAILS VALUES(2443,10360,'S18_3029',46,71.4E0,14)
INSERT INTO ORDERDETAILS VALUES(2444,10360,'S18_3140',29,122.93E0,8)
INSERT INTO ORDERDETAILS VALUES(2445,10360,'S18_3259',29,94.79E0,18)
INSERT INTO ORDERDETAILS VALUES(2446,10360,'S18_3856',40,101.64E0,15)
INSERT INTO ORDERDETAILS VALUES(2447,10360,'S18_4522',40,76.36E0,1)
INSERT INTO ORDERDETAILS VALUES(2448,10360,'S24_1785',22,106.14E0,17)
INSERT INTO ORDERDETAILS VALUES(2449,10360,'S24_2011',31,100.77E0,2)
INSERT INTO ORDERDETAILS VALUES(2450,10360,'S24_2841',49,55.49E0,16)
INSERT INTO ORDERDETAILS VALUES(2451,10360,'S24_3151',36,70.81E0,3)
INSERT INTO ORDERDETAILS VALUES(2452,10360,'S24_3816',22,78.83E0,4)
INSERT INTO ORDERDETAILS VALUES(2453,10360,'S700_1138',32,64.67E0,5)
INSERT INTO ORDERDETAILS VALUES(2454,10360,'S700_1938',26,86.61E0,6)
INSERT INTO ORDERDETAILS VALUES(2455,10360,'S700_2610',30,70.11E0,7)
INSERT INTO ORDERDETAILS VALUES(2456,10360,'S700_3505',35,83.14E0,9)
INSERT INTO ORDERDETAILS VALUES(2457,10360,'S700_3962',31,92.36E0,10)
INSERT INTO ORDERDETAILS VALUES(2458,10360,'S72_3212',31,54.05E0,11)
INSERT INTO ORDERDETAILS VALUES(2459,10361,'S10_1678',20,92.83E0,13)
INSERT INTO ORDERDETAILS VALUES(2460,10361,'S10_2016',26,114.18E0,8)
INSERT INTO ORDERDETAILS VALUES(2461,10361,'S24_3420',34,62.46E0,6)
INSERT INTO ORDERDETAILS VALUES(2462,10361,'S24_3949',26,61.42E0,7)
INSERT INTO ORDERDETAILS VALUES(2463,10361,'S24_4278',25,68.83E0,1)
INSERT INTO ORDERDETAILS VALUES(2464,10361,'S32_4289',49,56.41E0,2)
INSERT INTO ORDERDETAILS VALUES(2465,10361,'S50_1341',33,35.78E0,3)
INSERT INTO ORDERDETAILS VALUES(2466,10361,'S700_1691',20,88.6E0,4)
INSERT INTO ORDERDETAILS VALUES(2467,10361,'S700_2047',24,85.99E0,14)
INSERT INTO ORDERDETAILS VALUES(2468,10361,'S700_2466',26,91.74E0,9)
INSERT INTO ORDERDETAILS VALUES(2469,10361,'S700_2834',44,107.97E0,5)
INSERT INTO ORDERDETAILS VALUES(2470,10361,'S700_3167',44,76.8E0,10)
INSERT INTO ORDERDETAILS VALUES(2471,10361,'S700_4002',35,62.19E0,11)
INSERT INTO ORDERDETAILS VALUES(2472,10361,'S72_1253',23,47.67E0,12)
INSERT INTO ORDERDETAILS VALUES(2473,10362,'S10_4698',22,182.04E0,4)
INSERT INTO ORDERDETAILS VALUES(2474,10362,'S12_2823',22,131.04E0,1)
INSERT INTO ORDERDETAILS VALUES(2475,10362,'S18_2625',23,53.91E0,3)
INSERT INTO ORDERDETAILS VALUES(2476,10362,'S24_1578',50,91.29E0,2)
INSERT INTO ORDERDETAILS VALUES(2477,10363,'S12_1099',33,180.95E0,3)
INSERT INTO ORDERDETAILS VALUES(2478,10363,'S12_3380',34,106.87E0,4)
INSERT INTO ORDERDETAILS VALUES(2479,10363,'S12_3990',34,68.63E0,5)
INSERT INTO ORDERDETAILS VALUES(2480,10363,'S12_4675',46,103.64E0,6)
INSERT INTO ORDERDETAILS VALUES(2481,10363,'S18_1889',22,61.6E0,7)
INSERT INTO ORDERDETAILS VALUES(2482,10363,'S18_3278',46,69.15E0,10)
INSERT INTO ORDERDETAILS VALUES(2483,10363,'S18_3482',24,124.94E0,11)
INSERT INTO ORDERDETAILS VALUES(2484,10363,'S18_3782',32,52.22E0,12)
INSERT INTO ORDERDETAILS VALUES(2485,10363,'S18_4721',28,123.5E0,13)
INSERT INTO ORDERDETAILS VALUES(2486,10363,'S24_2000',21,70.08E0,8)
INSERT INTO ORDERDETAILS VALUES(2487,10363,'S24_2360',43,56.1E0,14)
INSERT INTO ORDERDETAILS VALUES(2488,10363,'S24_3371',21,52.05E0,15)
INSERT INTO ORDERDETAILS VALUES(2489,10363,'S24_3856',31,113.75E0,1)
INSERT INTO ORDERDETAILS VALUES(2490,10363,'S24_4620',43,75.99E0,9)
INSERT INTO ORDERDETAILS VALUES(2491,10363,'S32_1374',50,92.9E0,2)
INSERT INTO ORDERDETAILS VALUES(2492,10364,'S32_2206',48,38.22E0,1)
INSERT INTO ORDERDETAILS VALUES(2493,10365,'S18_1129',30,116.06E0,1)
INSERT INTO ORDERDETAILS VALUES(2494,10365,'S32_4485',22,82.66E0,3)
INSERT INTO ORDERDETAILS VALUES(2495,10365,'S50_4713',44,68.34E0,2)
INSERT INTO ORDERDETAILS VALUES(2496,10366,'S18_1984',34,116.65E0,3)
INSERT INTO ORDERDETAILS VALUES(2497,10366,'S18_2870',49,105.6E0,2)
INSERT INTO ORDERDETAILS VALUES(2498,10366,'S18_3232',34,154.1E0,1)
INSERT INTO ORDERDETAILS VALUES(2499,10367,'S18_1589',49,105.77E0,1)
INSERT INTO ORDERDETAILS VALUES(2500,10367,'S18_1749',37,144.5E0,3)
INSERT INTO ORDERDETAILS VALUES(2501,10367,'S18_2248',45,50.25E0,4)
INSERT INTO ORDERDETAILS VALUES(2502,10367,'S18_2325',27,124.59E0,5)
INSERT INTO ORDERDETAILS VALUES(2503,10367,'S18_2795',32,140.06E0,7)
INSERT INTO ORDERDETAILS VALUES(2504,10367,'S18_3685',46,131.39E0,6)
INSERT INTO ORDERDETAILS VALUES(2505,10367,'S18_4409',43,77.31E0,8)
INSERT INTO ORDERDETAILS VALUES(2506,10367,'S18_4933',44,66.99E0,9)
INSERT INTO ORDERDETAILS VALUES(2507,10367,'S24_1046',21,72.76E0,10)
INSERT INTO ORDERDETAILS VALUES(2508,10367,'S24_1628',38,50.31E0,11)
INSERT INTO ORDERDETAILS VALUES(2509,10367,'S24_1937',23,29.54E0,13)
INSERT INTO ORDERDETAILS VALUES(2510,10367,'S24_2022',28,43.01E0,12)
INSERT INTO ORDERDETAILS VALUES(2511,10367,'S24_2972',36,36.25E0,2)
INSERT INTO ORDERDETAILS VALUES(2512,10368,'S24_2766',40,73.6E0,2)
INSERT INTO ORDERDETAILS VALUES(2513,10368,'S24_2887',31,115.09E0,5)
INSERT INTO ORDERDETAILS VALUES(2514,10368,'S24_3191',46,83.04E0,1)
INSERT INTO ORDERDETAILS VALUES(2515,10368,'S24_3432',20,93.16E0,4)
INSERT INTO ORDERDETAILS VALUES(2516,10368,'S24_3969',46,36.52E0,3)
INSERT INTO ORDERDETAILS VALUES(2517,10369,'S10_1949',41,195.01E0,2)
INSERT INTO ORDERDETAILS VALUES(2518,10369,'S18_1342',44,89.38E0,8)
INSERT INTO ORDERDETAILS VALUES(2519,10369,'S18_1367',32,46.36E0,7)
INSERT INTO ORDERDETAILS VALUES(2520,10369,'S18_2949',42,100.3E0,1)
INSERT INTO ORDERDETAILS VALUES(2521,10369,'S18_2957',28,51.84E0,6)
INSERT INTO ORDERDETAILS VALUES(2522,10369,'S18_3136',21,90.06E0,5)
INSERT INTO ORDERDETAILS VALUES(2523,10369,'S18_3320',45,80.36E0,4)
INSERT INTO ORDERDETAILS VALUES(2524,10369,'S24_4258',40,93.49E0,3)
INSERT INTO ORDERDETAILS VALUES(2525,10370,'S10_4962',35,128.53E0,4)
INSERT INTO ORDERDETAILS VALUES(2526,10370,'S12_1666',49,128.47E0,8)
INSERT INTO ORDERDETAILS VALUES(2527,10370,'S18_1097',27,100.34E0,1)
INSERT INTO ORDERDETAILS VALUES(2528,10370,'S18_2319',22,101.87E0,5)
INSERT INTO ORDERDETAILS VALUES(2529,10370,'S18_2432',22,60.16E0,7)
INSERT INTO ORDERDETAILS VALUES(2530,10370,'S18_3232',27,167.65E0,9)
INSERT INTO ORDERDETAILS VALUES(2531,10370,'S18_4600',29,105.34E0,6)
INSERT INTO ORDERDETAILS VALUES(2532,10370,'S18_4668',20,41.76E0,2)
INSERT INTO ORDERDETAILS VALUES(2533,10370,'S32_3522',25,63.99E0,3)
INSERT INTO ORDERDETAILS VALUES(2534,10371,'S12_1108',32,178.71E0,6)
INSERT INTO ORDERDETAILS VALUES(2535,10371,'S12_4473',49,104.28E0,4)
INSERT INTO ORDERDETAILS VALUES(2536,10371,'S18_2238',25,160.46E0,7)
INSERT INTO ORDERDETAILS VALUES(2537,10371,'S24_1444',25,53.75E0,12)
INSERT INTO ORDERDETAILS VALUES(2538,10371,'S24_2300',20,126.51E0,5)
INSERT INTO ORDERDETAILS VALUES(2539,10371,'S24_2840',45,35.01E0,8)
INSERT INTO ORDERDETAILS VALUES(2540,10371,'S24_4048',28,95.81E0,9)
INSERT INTO ORDERDETAILS VALUES(2541,10371,'S32_1268',26,82.83E0,1)
INSERT INTO ORDERDETAILS VALUES(2542,10371,'S32_2509',20,44.37E0,2)
INSERT INTO ORDERDETAILS VALUES(2543,10371,'S32_3207',30,53.44E0,11)
INSERT INTO ORDERDETAILS VALUES(2544,10371,'S50_1392',48,97.23E0,10)
INSERT INTO ORDERDETAILS VALUES(2545,10371,'S700_2824',34,83.95E0,3)
INSERT INTO ORDERDETAILS VALUES(2546,10372,'S12_3148',40,146.55E0,4)
INSERT INTO ORDERDETAILS VALUES(2547,10372,'S12_3891',34,140.15E0,1)
INSERT INTO ORDERDETAILS VALUES(2548,10372,'S18_3140',28,131.13E0,3)
INSERT INTO ORDERDETAILS VALUES(2549,10372,'S18_3259',25,91.76E0,5)
INSERT INTO ORDERDETAILS VALUES(2550,10372,'S18_4027',48,119.2E0,6)
INSERT INTO ORDERDETAILS VALUES(2551,10372,'S18_4522',41,78.99E0,7)
INSERT INTO ORDERDETAILS VALUES(2552,10372,'S24_2011',37,102.0E0,8)
INSERT INTO ORDERDETAILS VALUES(2553,10372,'S50_1514',24,56.82E0,9)
INSERT INTO ORDERDETAILS VALUES(2554,10372,'S700_1938',44,74.48E0,2)
INSERT INTO ORDERDETAILS VALUES(2555,10373,'S10_4757',39,118.32E0,3)
INSERT INTO ORDERDETAILS VALUES(2556,10373,'S18_1662',28,143.5E0,4)
INSERT INTO ORDERDETAILS VALUES(2557,10373,'S18_3029',22,75.7E0,5)
INSERT INTO ORDERDETAILS VALUES(2558,10373,'S18_3856',50,99.52E0,6)
INSERT INTO ORDERDETAILS VALUES(2559,10373,'S24_2841',38,58.92E0,7)
INSERT INTO ORDERDETAILS VALUES(2560,10373,'S24_3151',33,82.31E0,12)
INSERT INTO ORDERDETAILS VALUES(2561,10373,'S24_3420',46,53.92E0,11)
INSERT INTO ORDERDETAILS VALUES(2562,10373,'S24_3816',23,83.86E0,10)
INSERT INTO ORDERDETAILS VALUES(2563,10373,'S24_3949',39,62.1E0,13)
INSERT INTO ORDERDETAILS VALUES(2564,10373,'S700_1138',44,58.0E0,14)
INSERT INTO ORDERDETAILS VALUES(2565,10373,'S700_2047',32,76.94E0,15)
INSERT INTO ORDERDETAILS VALUES(2566,10373,'S700_2610',41,69.39E0,16)
INSERT INTO ORDERDETAILS VALUES(2567,10373,'S700_3505',34,94.16E0,2)
INSERT INTO ORDERDETAILS VALUES(2568,10373,'S700_3962',37,83.42E0,8)
INSERT INTO ORDERDETAILS VALUES(2569,10373,'S700_4002',45,68.11E0,17)
INSERT INTO ORDERDETAILS VALUES(2570,10373,'S72_1253',25,44.2E0,9)
INSERT INTO ORDERDETAILS VALUES(2571,10373,'S72_3212',29,48.05E0,1)
INSERT INTO ORDERDETAILS VALUES(2572,10374,'S10_2016',39,115.37E0,5)
INSERT INTO ORDERDETAILS VALUES(2573,10374,'S10_4698',22,158.8E0,1)
INSERT INTO ORDERDETAILS VALUES(2574,10374,'S18_2581',42,75.19E0,2)
INSERT INTO ORDERDETAILS VALUES(2575,10374,'S18_2625',22,48.46E0,4)
INSERT INTO ORDERDETAILS VALUES(2576,10374,'S24_1578',38,112.7E0,6)
INSERT INTO ORDERDETAILS VALUES(2577,10374,'S24_1785',46,107.23E0,3)
INSERT INTO ORDERDETAILS VALUES(2578,10375,'S10_1678',21,76.56E0,12)
INSERT INTO ORDERDETAILS VALUES(2579,10375,'S12_1099',45,184.84E0,7)
INSERT INTO ORDERDETAILS VALUES(2580,10375,'S12_2823',49,150.62E0,13)
INSERT INTO ORDERDETAILS VALUES(2581,10375,'S24_2000',23,67.03E0,9)
INSERT INTO ORDERDETAILS VALUES(2582,10375,'S24_2360',20,60.26E0,14)
INSERT INTO ORDERDETAILS VALUES(2583,10375,'S24_4278',43,60.13E0,2)
INSERT INTO ORDERDETAILS VALUES(2584,10375,'S32_1374',37,87.9E0,3)
INSERT INTO ORDERDETAILS VALUES(2585,10375,'S32_4289',44,59.85E0,4)
INSERT INTO ORDERDETAILS VALUES(2586,10375,'S32_4485',41,96.95E0,15)
INSERT INTO ORDERDETAILS VALUES(2587,10375,'S50_1341',49,36.22E0,5)
INSERT INTO ORDERDETAILS VALUES(2588,10375,'S50_4713',49,69.16E0,8)
INSERT INTO ORDERDETAILS VALUES(2589,10375,'S700_1691',37,86.77E0,6)
INSERT INTO ORDERDETAILS VALUES(2590,10375,'S700_2466',33,94.73E0,1)
INSERT INTO ORDERDETAILS VALUES(2591,10375,'S700_2834',25,98.48E0,10)
INSERT INTO ORDERDETAILS VALUES(2592,10375,'S700_3167',44,69.6E0,11)
INSERT INTO ORDERDETAILS VALUES(2593,10376,'S12_3380',35,98.65E0,1)
INSERT INTO ORDERDETAILS VALUES(2594,10377,'S12_3990',24,65.44E0,5)
INSERT INTO ORDERDETAILS VALUES(2595,10377,'S12_4675',50,112.86E0,1)
INSERT INTO ORDERDETAILS VALUES(2596,10377,'S18_1129',35,124.56E0,2)
INSERT INTO ORDERDETAILS VALUES(2597,10377,'S18_1889',31,61.6E0,4)
INSERT INTO ORDERDETAILS VALUES(2598,10377,'S18_1984',36,125.18E0,6)
INSERT INTO ORDERDETAILS VALUES(2599,10377,'S18_3232',39,143.94E0,3)
INSERT INTO ORDERDETAILS VALUES(2600,10378,'S18_1589',34,121.95E0,5)
INSERT INTO ORDERDETAILS VALUES(2601,10378,'S18_3278',22,66.74E0,4)
INSERT INTO ORDERDETAILS VALUES(2602,10378,'S18_3482',43,146.99E0,10)
INSERT INTO ORDERDETAILS VALUES(2603,10378,'S18_3782',28,60.3E0,9)
INSERT INTO ORDERDETAILS VALUES(2604,10378,'S18_4721',49,122.02E0,8)
INSERT INTO ORDERDETAILS VALUES(2605,10378,'S24_2972',41,30.59E0,7)
INSERT INTO ORDERDETAILS VALUES(2606,10378,'S24_3371',46,52.66E0,6)
INSERT INTO ORDERDETAILS VALUES(2607,10378,'S24_3856',33,129.2E0,3)
INSERT INTO ORDERDETAILS VALUES(2608,10378,'S24_4620',41,80.84E0,2)
INSERT INTO ORDERDETAILS VALUES(2609,10378,'S32_2206',40,35.8E0,1)
INSERT INTO ORDERDETAILS VALUES(2610,10379,'S18_1749',39,156.4E0,2)
INSERT INTO ORDERDETAILS VALUES(2611,10379,'S18_2248',27,50.85E0,1)
INSERT INTO ORDERDETAILS VALUES(2612,10379,'S18_2870',29,113.52E0,5)
INSERT INTO ORDERDETAILS VALUES(2613,10379,'S18_3685',32,134.22E0,4)
INSERT INTO ORDERDETAILS VALUES(2614,10379,'S24_1628',32,48.8E0,3)
INSERT INTO ORDERDETAILS VALUES(2615,10380,'S18_1342',27,88.36E0,13)
INSERT INTO ORDERDETAILS VALUES(2616,10380,'S18_2325',40,119.5E0,10)
INSERT INTO ORDERDETAILS VALUES(2617,10380,'S18_2795',21,156.94E0,8)
INSERT INTO ORDERDETAILS VALUES(2618,10380,'S18_4409',32,78.23E0,1)
INSERT INTO ORDERDETAILS VALUES(2619,10380,'S18_4933',24,66.99E0,2)
INSERT INTO ORDERDETAILS VALUES(2620,10380,'S24_1046',34,66.88E0,3)
INSERT INTO ORDERDETAILS VALUES(2621,10380,'S24_1937',32,29.87E0,4)
INSERT INTO ORDERDETAILS VALUES(2622,10380,'S24_2022',27,37.63E0,5)
INSERT INTO ORDERDETAILS VALUES(2623,10380,'S24_2766',36,77.24E0,6)
INSERT INTO ORDERDETAILS VALUES(2624,10380,'S24_2887',44,111.57E0,7)
INSERT INTO ORDERDETAILS VALUES(2625,10380,'S24_3191',44,77.05E0,9)
INSERT INTO ORDERDETAILS VALUES(2626,10380,'S24_3432',34,91.02E0,11)
INSERT INTO ORDERDETAILS VALUES(2627,10380,'S24_3969',43,32.82E0,12)
INSERT INTO ORDERDETAILS VALUES(2628,10381,'S10_1949',36,182.16E0,3)
INSERT INTO ORDERDETAILS VALUES(2629,10381,'S10_4962',37,138.88E0,6)
INSERT INTO ORDERDETAILS VALUES(2630,10381,'S12_1666',20,132.57E0,1)
INSERT INTO ORDERDETAILS VALUES(2631,10381,'S18_1097',48,114.34E0,2)
INSERT INTO ORDERDETAILS VALUES(2632,10381,'S18_1367',25,49.6E0,9)
INSERT INTO ORDERDETAILS VALUES(2633,10381,'S18_2432',35,60.77E0,7)
INSERT INTO ORDERDETAILS VALUES(2634,10381,'S18_2949',41,100.3E0,8)
INSERT INTO ORDERDETAILS VALUES(2635,10381,'S18_2957',40,51.22E0,4)
INSERT INTO ORDERDETAILS VALUES(2636,10381,'S18_3136',35,93.2E0,5)
INSERT INTO ORDERDETAILS VALUES(2637,10382,'S12_1108',34,166.24E0,10)
INSERT INTO ORDERDETAILS VALUES(2638,10382,'S12_3148',37,145.04E0,11)
INSERT INTO ORDERDETAILS VALUES(2639,10382,'S12_3891',34,143.61E0,12)
INSERT INTO ORDERDETAILS VALUES(2640,10382,'S12_4473',32,103.1E0,13)
INSERT INTO ORDERDETAILS VALUES(2641,10382,'S18_2238',25,160.46E0,5)
INSERT INTO ORDERDETAILS VALUES(2642,10382,'S18_3320',50,84.33E0,7)
INSERT INTO ORDERDETAILS VALUES(2643,10382,'S18_4600',39,115.03E0,1)
INSERT INTO ORDERDETAILS VALUES(2644,10382,'S18_4668',39,46.29E0,2)
INSERT INTO ORDERDETAILS VALUES(2645,10382,'S24_2300',20,120.12E0,3)
INSERT INTO ORDERDETAILS VALUES(2646,10382,'S24_4258',33,97.39E0,4)
INSERT INTO ORDERDETAILS VALUES(2647,10382,'S32_1268',26,85.72E0,6)
INSERT INTO ORDERDETAILS VALUES(2648,10382,'S32_3522',48,57.53E0,8)
INSERT INTO ORDERDETAILS VALUES(2649,10382,'S700_2824',34,101.15E0,9)
INSERT INTO ORDERDETAILS VALUES(2650,10383,'S18_2319',27,119.05E0,11)
INSERT INTO ORDERDETAILS VALUES(2651,10383,'S18_3140',24,125.66E0,9)
INSERT INTO ORDERDETAILS VALUES(2652,10383,'S18_3232',47,155.79E0,6)
INSERT INTO ORDERDETAILS VALUES(2653,10383,'S18_3259',26,83.7E0,12)
INSERT INTO ORDERDETAILS VALUES(2654,10383,'S18_4027',38,137.88E0,1)
INSERT INTO ORDERDETAILS VALUES(2655,10383,'S18_4522',28,77.24E0,7)
INSERT INTO ORDERDETAILS VALUES(2656,10383,'S24_1444',22,52.6E0,2)
INSERT INTO ORDERDETAILS VALUES(2657,10383,'S24_2840',40,33.24E0,3)
INSERT INTO ORDERDETAILS VALUES(2658,10383,'S24_4048',21,117.1E0,4)
INSERT INTO ORDERDETAILS VALUES(2659,10383,'S32_2509',32,53.57E0,5)
INSERT INTO ORDERDETAILS VALUES(2660,10383,'S32_3207',44,55.93E0,8)
INSERT INTO ORDERDETAILS VALUES(2661,10383,'S50_1392',29,94.92E0,13)
INSERT INTO ORDERDETAILS VALUES(2662,10383,'S50_1514',38,48.62E0,10)
INSERT INTO ORDERDETAILS VALUES(2663,10384,'S10_4757',34,129.2E0,4)
INSERT INTO ORDERDETAILS VALUES(2664,10384,'S24_2011',28,114.29E0,3)
INSERT INTO ORDERDETAILS VALUES(2665,10384,'S24_3151',43,71.69E0,2)
INSERT INTO ORDERDETAILS VALUES(2666,10384,'S700_1938',49,71.02E0,1)
INSERT INTO ORDERDETAILS VALUES(2667,10385,'S24_3816',37,78.83E0,2)
INSERT INTO ORDERDETAILS VALUES(2668,10385,'S700_1138',25,62.0E0,1)
INSERT INTO ORDERDETAILS VALUES(2669,10386,'S18_1662',25,130.88E0,7)
INSERT INTO ORDERDETAILS VALUES(2670,10386,'S18_2581',21,72.65E0,18)
INSERT INTO ORDERDETAILS VALUES(2671,10386,'S18_3029',37,73.12E0,5)
INSERT INTO ORDERDETAILS VALUES(2672,10386,'S18_3856',22,100.58E0,6)
INSERT INTO ORDERDETAILS VALUES(2673,10386,'S24_1785',33,101.76E0,11)
INSERT INTO ORDERDETAILS VALUES(2674,10386,'S24_2841',39,56.86E0,1)
INSERT INTO ORDERDETAILS VALUES(2675,10386,'S24_3420',35,54.57E0,9)
INSERT INTO ORDERDETAILS VALUES(2676,10386,'S24_3949',41,55.96E0,12)
INSERT INTO ORDERDETAILS VALUES(2677,10386,'S24_4278',50,71.73E0,8)
INSERT INTO ORDERDETAILS VALUES(2678,10386,'S700_2047',29,85.09E0,13)
INSERT INTO ORDERDETAILS VALUES(2679,10386,'S700_2466',37,90.75E0,14)
INSERT INTO ORDERDETAILS VALUES(2680,10386,'S700_2610',37,67.22E0,10)
INSERT INTO ORDERDETAILS VALUES(2681,10386,'S700_3167',32,68.0E0,17)
INSERT INTO ORDERDETAILS VALUES(2682,10386,'S700_3505',45,83.14E0,2)
INSERT INTO ORDERDETAILS VALUES(2683,10386,'S700_3962',30,80.44E0,3)
INSERT INTO ORDERDETAILS VALUES(2684,10386,'S700_4002',44,59.22E0,15)
INSERT INTO ORDERDETAILS VALUES(2685,10386,'S72_1253',50,47.67E0,16)
INSERT INTO ORDERDETAILS VALUES(2686,10386,'S72_3212',43,52.42E0,4)
INSERT INTO ORDERDETAILS VALUES(2687,10387,'S32_1374',44,79.91E0,1)
INSERT INTO ORDERDETAILS VALUES(2688,10388,'S10_1678',42,80.39E0,4)
INSERT INTO ORDERDETAILS VALUES(2689,10388,'S10_2016',50,118.94E0,5)
INSERT INTO ORDERDETAILS VALUES(2690,10388,'S10_4698',21,156.86E0,7)
INSERT INTO ORDERDETAILS VALUES(2691,10388,'S12_2823',44,125.01E0,6)
INSERT INTO ORDERDETAILS VALUES(2692,10388,'S32_4289',35,58.47E0,8)
INSERT INTO ORDERDETAILS VALUES(2693,10388,'S50_1341',27,41.02E0,1)
INSERT INTO ORDERDETAILS VALUES(2694,10388,'S700_1691',46,74.9E0,2)
INSERT INTO ORDERDETAILS VALUES(2695,10388,'S700_2834',50,111.53E0,3)
INSERT INTO ORDERDETAILS VALUES(2696,10389,'S12_1099',26,182.9E0,4)
INSERT INTO ORDERDETAILS VALUES(2697,10389,'S12_3380',25,95.13E0,6)
INSERT INTO ORDERDETAILS VALUES(2698,10389,'S12_3990',36,76.61E0,7)
INSERT INTO ORDERDETAILS VALUES(2699,10389,'S12_4675',47,102.49E0,8)
INSERT INTO ORDERDETAILS VALUES(2700,10389,'S18_1889',49,63.91E0,3)
INSERT INTO ORDERDETAILS VALUES(2701,10389,'S18_2625',39,52.09E0,5)
INSERT INTO ORDERDETAILS VALUES(2702,10389,'S24_1578',45,112.7E0,1)
INSERT INTO ORDERDETAILS VALUES(2703,10389,'S24_2000',49,61.7E0,2)
INSERT INTO ORDERDETAILS VALUES(2704,10390,'S18_1129',36,117.48E0,14)
INSERT INTO ORDERDETAILS VALUES(2705,10390,'S18_1984',34,132.29E0,15)
INSERT INTO ORDERDETAILS VALUES(2706,10390,'S18_2325',31,102.98E0,16)
INSERT INTO ORDERDETAILS VALUES(2707,10390,'S18_2795',26,162.0E0,7)
INSERT INTO ORDERDETAILS VALUES(2708,10390,'S18_3278',40,75.59E0,9)
INSERT INTO ORDERDETAILS VALUES(2709,10390,'S18_3482',50,135.23E0,1)
INSERT INTO ORDERDETAILS VALUES(2710,10390,'S18_3782',36,54.09E0,2)
INSERT INTO ORDERDETAILS VALUES(2711,10390,'S18_4721',49,122.02E0,3)
INSERT INTO ORDERDETAILS VALUES(2712,10390,'S24_2360',35,67.87E0,4)
INSERT INTO ORDERDETAILS VALUES(2713,10390,'S24_2972',37,35.87E0,5)
INSERT INTO ORDERDETAILS VALUES(2714,10390,'S24_3371',46,51.43E0,6)
INSERT INTO ORDERDETAILS VALUES(2715,10390,'S24_3856',45,134.81E0,8)
INSERT INTO ORDERDETAILS VALUES(2716,10390,'S24_4620',30,66.29E0,10)
INSERT INTO ORDERDETAILS VALUES(2717,10390,'S32_2206',41,39.02E0,11)
INSERT INTO ORDERDETAILS VALUES(2718,10390,'S32_4485',45,101.03E0,12)
INSERT INTO ORDERDETAILS VALUES(2719,10390,'S50_4713',22,81.36E0,13)
INSERT INTO ORDERDETAILS VALUES(2720,10391,'S10_1949',24,195.01E0,4)
INSERT INTO ORDERDETAILS VALUES(2721,10391,'S10_4962',37,121.15E0,7)
INSERT INTO ORDERDETAILS VALUES(2722,10391,'S12_1666',39,110.7E0,9)
INSERT INTO ORDERDETAILS VALUES(2723,10391,'S18_1097',29,114.34E0,10)
INSERT INTO ORDERDETAILS VALUES(2724,10391,'S18_1342',35,102.74E0,2)
INSERT INTO ORDERDETAILS VALUES(2725,10391,'S18_1367',42,47.44E0,3)
INSERT INTO ORDERDETAILS VALUES(2726,10391,'S18_2432',44,57.73E0,5)
INSERT INTO ORDERDETAILS VALUES(2727,10391,'S18_2949',32,99.28E0,6)
INSERT INTO ORDERDETAILS VALUES(2728,10391,'S24_1937',33,26.55E0,8)
INSERT INTO ORDERDETAILS VALUES(2729,10391,'S24_2022',24,36.29E0,1)
INSERT INTO ORDERDETAILS VALUES(2730,10392,'S18_2957',37,61.21E0,3)
INSERT INTO ORDERDETAILS VALUES(2731,10392,'S18_3136',29,103.67E0,2)
INSERT INTO ORDERDETAILS VALUES(2732,10392,'S18_3320',36,98.22E0,1)
INSERT INTO ORDERDETAILS VALUES(2733,10393,'S12_3148',35,145.04E0,8)
INSERT INTO ORDERDETAILS VALUES(2734,10393,'S12_4473',32,99.54E0,10)
INSERT INTO ORDERDETAILS VALUES(2735,10393,'S18_2238',20,137.53E0,11)
INSERT INTO ORDERDETAILS VALUES(2736,10393,'S18_2319',38,104.32E0,7)
INSERT INTO ORDERDETAILS VALUES(2737,10393,'S18_4600',30,106.55E0,9)
INSERT INTO ORDERDETAILS VALUES(2738,10393,'S18_4668',44,41.76E0,1)
INSERT INTO ORDERDETAILS VALUES(2739,10393,'S24_2300',33,112.46E0,2)
INSERT INTO ORDERDETAILS VALUES(2740,10393,'S24_4258',33,88.62E0,3)
INSERT INTO ORDERDETAILS VALUES(2741,10393,'S32_1268',38,84.75E0,4)
INSERT INTO ORDERDETAILS VALUES(2742,10393,'S32_3522',31,63.35E0,5)
INSERT INTO ORDERDETAILS VALUES(2743,10393,'S700_2824',21,83.95E0,6)
INSERT INTO ORDERDETAILS VALUES(2744,10394,'S18_3232',22,135.47E0,5)
INSERT INTO ORDERDETAILS VALUES(2745,10394,'S18_4027',37,124.95E0,1)
INSERT INTO ORDERDETAILS VALUES(2746,10394,'S24_1444',31,53.18E0,2)
INSERT INTO ORDERDETAILS VALUES(2747,10394,'S24_2840',46,35.36E0,6)
INSERT INTO ORDERDETAILS VALUES(2748,10394,'S24_4048',37,104.09E0,7)
INSERT INTO ORDERDETAILS VALUES(2749,10394,'S32_2509',36,47.08E0,3)
INSERT INTO ORDERDETAILS VALUES(2750,10394,'S32_3207',30,55.93E0,4)
INSERT INTO ORDERDETAILS VALUES(2751,10395,'S10_4757',32,125.12E0,2)
INSERT INTO ORDERDETAILS VALUES(2752,10395,'S12_1108',33,205.72E0,1)
INSERT INTO ORDERDETAILS VALUES(2753,10395,'S50_1392',46,98.39E0,4)
INSERT INTO ORDERDETAILS VALUES(2754,10395,'S50_1514',45,57.99E0,3)
INSERT INTO ORDERDETAILS VALUES(2755,10396,'S12_3891',33,155.72E0,3)
INSERT INTO ORDERDETAILS VALUES(2756,10396,'S18_3140',33,129.76E0,2)
INSERT INTO ORDERDETAILS VALUES(2757,10396,'S18_3259',24,91.76E0,4)
INSERT INTO ORDERDETAILS VALUES(2758,10396,'S18_4522',45,83.38E0,5)
INSERT INTO ORDERDETAILS VALUES(2759,10396,'S24_2011',49,100.77E0,6)
INSERT INTO ORDERDETAILS VALUES(2760,10396,'S24_3151',27,77.0E0,7)
INSERT INTO ORDERDETAILS VALUES(2761,10396,'S24_3816',37,77.99E0,8)
INSERT INTO ORDERDETAILS VALUES(2762,10396,'S700_1138',39,62.0E0,1)
INSERT INTO ORDERDETAILS VALUES(2763,10397,'S700_1938',32,69.29E0,5)
INSERT INTO ORDERDETAILS VALUES(2764,10397,'S700_2610',22,62.88E0,4)
INSERT INTO ORDERDETAILS VALUES(2765,10397,'S700_3505',48,86.15E0,3)
INSERT INTO ORDERDETAILS VALUES(2766,10397,'S700_3962',36,80.44E0,2)
INSERT INTO ORDERDETAILS VALUES(2767,10397,'S72_3212',34,52.96E0,1)
INSERT INTO ORDERDETAILS VALUES(2768,10398,'S18_1662',33,130.88E0,11)
INSERT INTO ORDERDETAILS VALUES(2769,10398,'S18_2581',34,82.79E0,15)
INSERT INTO ORDERDETAILS VALUES(2770,10398,'S18_3029',28,70.54E0,18)
INSERT INTO ORDERDETAILS VALUES(2771,10398,'S18_3856',45,92.11E0,17)
INSERT INTO ORDERDETAILS VALUES(2772,10398,'S24_1785',43,100.67E0,16)
INSERT INTO ORDERDETAILS VALUES(2773,10398,'S24_2841',28,60.29E0,3)
INSERT INTO ORDERDETAILS VALUES(2774,10398,'S24_3420',34,61.15E0,13)
INSERT INTO ORDERDETAILS VALUES(2775,10398,'S24_3949',41,56.64E0,2)
INSERT INTO ORDERDETAILS VALUES(2776,10398,'S24_4278',45,65.93E0,14)
INSERT INTO ORDERDETAILS VALUES(2777,10398,'S32_4289',22,60.54E0,4)
INSERT INTO ORDERDETAILS VALUES(2778,10398,'S50_1341',49,38.84E0,5)
INSERT INTO ORDERDETAILS VALUES(2779,10398,'S700_1691',47,78.55E0,6)
INSERT INTO ORDERDETAILS VALUES(2780,10398,'S700_2047',36,75.13E0,7)
INSERT INTO ORDERDETAILS VALUES(2781,10398,'S700_2466',22,98.72E0,8)
INSERT INTO ORDERDETAILS VALUES(2782,10398,'S700_2834',23,102.04E0,9)
INSERT INTO ORDERDETAILS VALUES(2783,10398,'S700_3167',29,76.8E0,10)
INSERT INTO ORDERDETAILS VALUES(2784,10398,'S700_4002',36,62.19E0,12)
INSERT INTO ORDERDETAILS VALUES(2785,10398,'S72_1253',34,41.22E0,1)
INSERT INTO ORDERDETAILS VALUES(2786,10399,'S10_1678',40,77.52E0,8)
INSERT INTO ORDERDETAILS VALUES(2787,10399,'S10_2016',51,99.91E0,7)
INSERT INTO ORDERDETAILS VALUES(2788,10399,'S10_4698',22,156.86E0,6)
INSERT INTO ORDERDETAILS VALUES(2789,10399,'S12_2823',29,123.51E0,5)
INSERT INTO ORDERDETAILS VALUES(2790,10399,'S18_2625',30,51.48E0,4)
INSERT INTO ORDERDETAILS VALUES(2791,10399,'S24_1578',57,104.81E0,3)
INSERT INTO ORDERDETAILS VALUES(2792,10399,'S24_2000',58,75.41E0,2)
INSERT INTO ORDERDETAILS VALUES(2793,10399,'S32_1374',32,97.89E0,1)
INSERT INTO ORDERDETAILS VALUES(2794,10400,'S10_4757',64,134.64E0,9)
INSERT INTO ORDERDETAILS VALUES(2795,10400,'S18_1662',34,129.31E0,1)
INSERT INTO ORDERDETAILS VALUES(2796,10400,'S18_3029',30,74.84E0,7)
INSERT INTO ORDERDETAILS VALUES(2797,10400,'S18_3856',58,88.93E0,6)
INSERT INTO ORDERDETAILS VALUES(2798,10400,'S24_2841',24,55.49E0,2)
INSERT INTO ORDERDETAILS VALUES(2799,10400,'S24_3420',38,59.18E0,3)
INSERT INTO ORDERDETAILS VALUES(2800,10400,'S24_3816',42,74.64E0,8)
INSERT INTO ORDERDETAILS VALUES(2801,10400,'S700_2047',46,82.37E0,5)
INSERT INTO ORDERDETAILS VALUES(2802,10400,'S72_1253',20,41.71E0,4)
INSERT INTO ORDERDETAILS VALUES(2803,10401,'S18_2581',42,75.19E0,3)
INSERT INTO ORDERDETAILS VALUES(2804,10401,'S24_1785',38,87.54E0,5)
INSERT INTO ORDERDETAILS VALUES(2805,10401,'S24_3949',64,59.37E0,12)
INSERT INTO ORDERDETAILS VALUES(2806,10401,'S24_4278',52,65.93E0,4)
INSERT INTO ORDERDETAILS VALUES(2807,10401,'S32_1374',49,81.91E0,1)
INSERT INTO ORDERDETAILS VALUES(2808,10401,'S32_4289',62,62.6E0,6)
INSERT INTO ORDERDETAILS VALUES(2809,10401,'S50_1341',56,41.46E0,7)
INSERT INTO ORDERDETAILS VALUES(2810,10401,'S700_1691',11,77.64E0,8)
INSERT INTO ORDERDETAILS VALUES(2811,10401,'S700_2466',85,98.72E0,10)
INSERT INTO ORDERDETAILS VALUES(2812,10401,'S700_2834',21,96.11E0,2)
INSERT INTO ORDERDETAILS VALUES(2813,10401,'S700_3167',77,73.6E0,9)
INSERT INTO ORDERDETAILS VALUES(2814,10401,'S700_4002',40,66.63E0,11)
INSERT INTO ORDERDETAILS VALUES(2815,10402,'S10_2016',45,118.94E0,1)
INSERT INTO ORDERDETAILS VALUES(2816,10402,'S18_2625',55,58.15E0,2)
INSERT INTO ORDERDETAILS VALUES(2817,10402,'S24_2000',59,61.7E0,3)
INSERT INTO ORDERDETAILS VALUES(2818,10403,'S10_1678',24,85.17E0,7)
INSERT INTO ORDERDETAILS VALUES(2819,10403,'S10_4698',66,174.29E0,9)
INSERT INTO ORDERDETAILS VALUES(2820,10403,'S12_2823',66,122.0E0,6)
INSERT INTO ORDERDETAILS VALUES(2821,10403,'S18_3782',36,55.33E0,1)
INSERT INTO ORDERDETAILS VALUES(2822,10403,'S24_1578',46,109.32E0,8)
INSERT INTO ORDERDETAILS VALUES(2823,10403,'S24_2360',27,57.49E0,4)
INSERT INTO ORDERDETAILS VALUES(2824,10403,'S32_2206',30,35.8E0,2)
INSERT INTO ORDERDETAILS VALUES(2825,10403,'S32_4485',45,88.78E0,5)
INSERT INTO ORDERDETAILS VALUES(2826,10403,'S50_4713',31,65.09E0,3)
INSERT INTO ORDERDETAILS VALUES(2827,10404,'S12_1099',64,163.44E0,3)
INSERT INTO ORDERDETAILS VALUES(2828,10404,'S12_3380',43,102.17E0,1)
INSERT INTO ORDERDETAILS VALUES(2829,10404,'S12_3990',77,67.03E0,4)
INSERT INTO ORDERDETAILS VALUES(2830,10404,'S18_3278',90,67.54E0,6)
INSERT INTO ORDERDETAILS VALUES(2831,10404,'S18_3482',28,127.88E0,5)
INSERT INTO ORDERDETAILS VALUES(2832,10404,'S18_4721',48,124.99E0,8)
INSERT INTO ORDERDETAILS VALUES(2833,10404,'S24_3371',49,53.27E0,2)
INSERT INTO ORDERDETAILS VALUES(2834,10404,'S24_4620',48,65.48E0,7)
INSERT INTO ORDERDETAILS VALUES(2835,10405,'S12_4675',97,115.16E0,5)
INSERT INTO ORDERDETAILS VALUES(2836,10405,'S18_1889',61,72.38E0,4)
INSERT INTO ORDERDETAILS VALUES(2837,10405,'S18_3232',55,147.33E0,1)
INSERT INTO ORDERDETAILS VALUES(2838,10405,'S24_2972',47,37.38E0,2)
INSERT INTO ORDERDETAILS VALUES(2839,10405,'S24_3856',76,127.79E0,3)
INSERT INTO ORDERDETAILS VALUES(2840,10406,'S18_1129',61,124.56E0,3)
INSERT INTO ORDERDETAILS VALUES(2841,10406,'S18_1984',48,133.72E0,2)
INSERT INTO ORDERDETAILS VALUES(2842,10406,'S18_3685',65,117.26E0,1)
INSERT INTO ORDERDETAILS VALUES(2843,10407,'S18_1589',59,114.48E0,11)
INSERT INTO ORDERDETAILS VALUES(2844,10407,'S18_1749',76,141.1E0,2)
INSERT INTO ORDERDETAILS VALUES(2845,10407,'S18_2248',42,58.12E0,1)
INSERT INTO ORDERDETAILS VALUES(2846,10407,'S18_2870',41,132.0E0,12)
INSERT INTO ORDERDETAILS VALUES(2847,10407,'S18_4409',6,91.11E0,3)
INSERT INTO ORDERDETAILS VALUES(2848,10407,'S18_4933',66,64.14E0,4)
INSERT INTO ORDERDETAILS VALUES(2849,10407,'S24_1046',26,68.35E0,8)
INSERT INTO ORDERDETAILS VALUES(2850,10407,'S24_1628',64,45.78E0,10)
INSERT INTO ORDERDETAILS VALUES(2851,10407,'S24_2766',76,81.78E0,6)
INSERT INTO ORDERDETAILS VALUES(2852,10407,'S24_2887',59,98.65E0,5)
INSERT INTO ORDERDETAILS VALUES(2853,10407,'S24_3191',13,77.05E0,7)
INSERT INTO ORDERDETAILS VALUES(2854,10407,'S24_3432',43,101.73E0,9)
INSERT INTO ORDERDETAILS VALUES(2855,10408,'S24_3969',15,41.03E0,1)
INSERT INTO ORDERDETAILS VALUES(2856,10409,'S18_2325',6,104.25E0,2)
INSERT INTO ORDERDETAILS VALUES(2857,10409,'S24_1937',61,27.88E0,1)
INSERT INTO ORDERDETAILS VALUES(2858,10410,'S18_1342',65,99.66E0,7)
INSERT INTO ORDERDETAILS VALUES(2859,10410,'S18_1367',44,51.21E0,6)
INSERT INTO ORDERDETAILS VALUES(2860,10410,'S18_2795',56,145.13E0,8)
INSERT INTO ORDERDETAILS VALUES(2861,10410,'S18_2949',47,93.21E0,1)
INSERT INTO ORDERDETAILS VALUES(2862,10410,'S18_2957',53,49.97E0,3)
INSERT INTO ORDERDETAILS VALUES(2863,10410,'S18_3136',34,84.82E0,2)
INSERT INTO ORDERDETAILS VALUES(2864,10410,'S18_3320',44,81.35E0,5)
INSERT INTO ORDERDETAILS VALUES(2865,10410,'S24_2022',31,42.56E0,9)
INSERT INTO ORDERDETAILS VALUES(2866,10410,'S24_4258',50,95.44E0,4)
INSERT INTO ORDERDETAILS VALUES(2867,10411,'S10_1949',23,205.73E0,9)
INSERT INTO ORDERDETAILS VALUES(2868,10411,'S10_4962',27,144.79E0,2)
INSERT INTO ORDERDETAILS VALUES(2869,10411,'S12_1666',40,110.7E0,6)
INSERT INTO ORDERDETAILS VALUES(2870,10411,'S18_1097',27,109.67E0,8)
INSERT INTO ORDERDETAILS VALUES(2871,10411,'S18_4600',46,106.55E0,3)
INSERT INTO ORDERDETAILS VALUES(2872,10411,'S18_4668',35,41.25E0,7)
INSERT INTO ORDERDETAILS VALUES(2873,10411,'S32_1268',26,78.01E0,1)
INSERT INTO ORDERDETAILS VALUES(2874,10411,'S32_3522',27,60.76E0,5)
INSERT INTO ORDERDETAILS VALUES(2875,10411,'S700_2824',34,89.01E0,4)
INSERT INTO ORDERDETAILS VALUES(2876,10412,'S12_4473',54,100.73E0,5)
INSERT INTO ORDERDETAILS VALUES(2877,10412,'S18_2238',41,150.63E0,4)
INSERT INTO ORDERDETAILS VALUES(2878,10412,'S18_2319',56,120.28E0,8)
INSERT INTO ORDERDETAILS VALUES(2879,10412,'S18_2432',47,49.83E0,11)
INSERT INTO ORDERDETAILS VALUES(2880,10412,'S18_3232',60,157.49E0,9)
INSERT INTO ORDERDETAILS VALUES(2881,10412,'S24_1444',21,47.4E0,2)
INSERT INTO ORDERDETAILS VALUES(2882,10412,'S24_2300',70,109.9E0,10)
INSERT INTO ORDERDETAILS VALUES(2883,10412,'S24_2840',30,32.88E0,6)
INSERT INTO ORDERDETAILS VALUES(2884,10412,'S24_4048',31,108.82E0,1)
INSERT INTO ORDERDETAILS VALUES(2885,10412,'S32_2509',19,50.86E0,7)
INSERT INTO ORDERDETAILS VALUES(2886,10412,'S50_1392',26,105.33E0,3)
INSERT INTO ORDERDETAILS VALUES(2887,10413,'S12_1108',36,201.57E0,2)
INSERT INTO ORDERDETAILS VALUES(2888,10413,'S12_3148',47,145.04E0,3)
INSERT INTO ORDERDETAILS VALUES(2889,10413,'S12_3891',22,173.02E0,1)
INSERT INTO ORDERDETAILS VALUES(2890,10413,'S18_4027',49,133.57E0,5)
INSERT INTO ORDERDETAILS VALUES(2891,10413,'S32_3207',24,56.55E0,6)
INSERT INTO ORDERDETAILS VALUES(2892,10413,'S50_1514',51,53.31E0,4)
INSERT INTO ORDERDETAILS VALUES(2893,10414,'S10_4757',49,114.24E0,3)
INSERT INTO ORDERDETAILS VALUES(2894,10414,'S18_3029',44,77.42E0,1)
INSERT INTO ORDERDETAILS VALUES(2895,10414,'S18_3140',41,128.39E0,12)
INSERT INTO ORDERDETAILS VALUES(2896,10414,'S18_3259',48,85.71E0,14)
INSERT INTO ORDERDETAILS VALUES(2897,10414,'S18_4522',56,83.38E0,11)
INSERT INTO ORDERDETAILS VALUES(2898,10414,'S24_2011',43,108.14E0,10)
INSERT INTO ORDERDETAILS VALUES(2899,10414,'S24_3151',60,72.58E0,5)
INSERT INTO ORDERDETAILS VALUES(2900,10414,'S24_3816',51,72.96E0,2)
INSERT INTO ORDERDETAILS VALUES(2901,10414,'S700_1138',37,62.0E0,6)
INSERT INTO ORDERDETAILS VALUES(2902,10414,'S700_1938',34,74.48E0,13)
INSERT INTO ORDERDETAILS VALUES(2903,10414,'S700_2610',31,61.44E0,4)
INSERT INTO ORDERDETAILS VALUES(2904,10414,'S700_3505',28,84.14E0,7)
INSERT INTO ORDERDETAILS VALUES(2905,10414,'S700_3962',40,84.41E0,8)
INSERT INTO ORDERDETAILS VALUES(2906,10414,'S72_3212',47,54.6E0,9)
INSERT INTO ORDERDETAILS VALUES(2907,10415,'S18_3856',51,86.81E0,5)
INSERT INTO ORDERDETAILS VALUES(2908,10415,'S24_2841',21,60.97E0,1)
INSERT INTO ORDERDETAILS VALUES(2909,10415,'S24_3420',18,59.83E0,2)
INSERT INTO ORDERDETAILS VALUES(2910,10415,'S700_2047',32,73.32E0,4)
INSERT INTO ORDERDETAILS VALUES(2911,10415,'S72_1253',42,43.2E0,3)
INSERT INTO ORDERDETAILS VALUES(2912,10416,'S18_1662',24,129.31E0,14)
INSERT INTO ORDERDETAILS VALUES(2913,10416,'S18_2581',15,70.96E0,4)
INSERT INTO ORDERDETAILS VALUES(2914,10416,'S24_1785',47,90.82E0,6)
INSERT INTO ORDERDETAILS VALUES(2915,10416,'S24_2000',32,62.46E0,1)
INSERT INTO ORDERDETAILS VALUES(2916,10416,'S24_3949',18,64.83E0,13)
INSERT INTO ORDERDETAILS VALUES(2917,10416,'S24_4278',48,70.28E0,5)
INSERT INTO ORDERDETAILS VALUES(2918,10416,'S32_1374',45,86.9E0,2)
INSERT INTO ORDERDETAILS VALUES(2919,10416,'S32_4289',26,68.1E0,7)
INSERT INTO ORDERDETAILS VALUES(2920,10416,'S50_1341',37,39.71E0,8)
INSERT INTO ORDERDETAILS VALUES(2921,10416,'S700_1691',23,88.6E0,9)
INSERT INTO ORDERDETAILS VALUES(2922,10416,'S700_2466',22,84.76E0,11)
INSERT INTO ORDERDETAILS VALUES(2923,10416,'S700_2834',41,98.48E0,3)
INSERT INTO ORDERDETAILS VALUES(2924,10416,'S700_3167',39,65.6E0,10)
INSERT INTO ORDERDETAILS VALUES(2925,10416,'S700_4002',43,63.67E0,12)
INSERT INTO ORDERDETAILS VALUES(2926,10417,'S10_1678',66,79.43E0,2)
INSERT INTO ORDERDETAILS VALUES(2927,10417,'S10_2016',45,116.56E0,5)
INSERT INTO ORDERDETAILS VALUES(2928,10417,'S10_4698',56,162.67E0,4)
INSERT INTO ORDERDETAILS VALUES(2929,10417,'S12_2823',21,144.6E0,1)
INSERT INTO ORDERDETAILS VALUES(2930,10417,'S18_2625',36,58.75E0,6)
INSERT INTO ORDERDETAILS VALUES(2931,10417,'S24_1578',35,109.32E0,3)
INSERT INTO ORDERDETAILS VALUES(2932,10418,'S18_3278',16,70.76E0,2)
INSERT INTO ORDERDETAILS VALUES(2933,10418,'S18_3482',27,139.64E0,1)
INSERT INTO ORDERDETAILS VALUES(2934,10418,'S18_3782',33,56.57E0,5)
INSERT INTO ORDERDETAILS VALUES(2935,10418,'S18_4721',28,120.53E0,4)
INSERT INTO ORDERDETAILS VALUES(2936,10418,'S24_2360',52,64.41E0,8)
INSERT INTO ORDERDETAILS VALUES(2937,10418,'S24_4620',10,66.29E0,3)
INSERT INTO ORDERDETAILS VALUES(2938,10418,'S32_2206',43,36.61E0,6)
INSERT INTO ORDERDETAILS VALUES(2939,10418,'S32_4485',50,100.01E0,9)
INSERT INTO ORDERDETAILS VALUES(2940,10418,'S50_4713',40,72.41E0,7)
INSERT INTO ORDERDETAILS VALUES(2941,10419,'S12_1099',12,182.9E0,13)
INSERT INTO ORDERDETAILS VALUES(2942,10419,'S12_3380',10,111.57E0,11)
INSERT INTO ORDERDETAILS VALUES(2943,10419,'S12_3990',34,64.64E0,14)
INSERT INTO ORDERDETAILS VALUES(2944,10419,'S12_4675',32,99.04E0,10)
INSERT INTO ORDERDETAILS VALUES(2945,10419,'S18_1129',38,117.48E0,5)
INSERT INTO ORDERDETAILS VALUES(2946,10419,'S18_1589',37,100.8E0,1)
INSERT INTO ORDERDETAILS VALUES(2947,10419,'S18_1889',39,67.76E0,9)
INSERT INTO ORDERDETAILS VALUES(2948,10419,'S18_1984',34,133.72E0,4)
INSERT INTO ORDERDETAILS VALUES(2949,10419,'S18_2870',55,116.16E0,2)
INSERT INTO ORDERDETAILS VALUES(2950,10419,'S18_3232',35,165.95E0,6)
INSERT INTO ORDERDETAILS VALUES(2951,10419,'S18_3685',43,114.44E0,3)
INSERT INTO ORDERDETAILS VALUES(2952,10419,'S24_2972',15,32.1E0,7)
INSERT INTO ORDERDETAILS VALUES(2953,10419,'S24_3371',55,52.66E0,12)
INSERT INTO ORDERDETAILS VALUES(2954,10419,'S24_3856',70,112.34E0,8)
INSERT INTO ORDERDETAILS VALUES(2955,10420,'S18_1749',37,153.0E0,5)
INSERT INTO ORDERDETAILS VALUES(2956,10420,'S18_2248',36,52.06E0,4)
INSERT INTO ORDERDETAILS VALUES(2957,10420,'S18_2325',45,116.96E0,2)
INSERT INTO ORDERDETAILS VALUES(2958,10420,'S18_4409',66,73.62E0,6)
INSERT INTO ORDERDETAILS VALUES(2959,10420,'S18_4933',36,68.42E0,7)
INSERT INTO ORDERDETAILS VALUES(2960,10420,'S24_1046',60,60.26E0,11)
INSERT INTO ORDERDETAILS VALUES(2961,10420,'S24_1628',37,48.8E0,13)
INSERT INTO ORDERDETAILS VALUES(2962,10420,'S24_1937',45,32.19E0,1)
INSERT INTO ORDERDETAILS VALUES(2963,10420,'S24_2766',39,76.33E0,9)
INSERT INTO ORDERDETAILS VALUES(2964,10420,'S24_2887',55,115.09E0,8)
INSERT INTO ORDERDETAILS VALUES(2965,10420,'S24_3191',35,77.05E0,10)
INSERT INTO ORDERDETAILS VALUES(2966,10420,'S24_3432',26,104.94E0,12)
INSERT INTO ORDERDETAILS VALUES(2967,10420,'S24_3969',15,35.29E0,3)
INSERT INTO ORDERDETAILS VALUES(2968,10421,'S18_2795',35,167.06E0,1)
INSERT INTO ORDERDETAILS VALUES(2969,10421,'S24_2022',40,44.8E0,2)
INSERT INTO ORDERDETAILS VALUES(2970,10422,'S18_1342',51,91.44E0,2)
INSERT INTO ORDERDETAILS VALUES(2971,10422,'S18_1367',25,47.44E0,1)
INSERT INTO ORDERDETAILS VALUES(2972,10423,'S18_2949',10,89.15E0,1)
INSERT INTO ORDERDETAILS VALUES(2973,10423,'S18_2957',31,56.21E0,3)
INSERT INTO ORDERDETAILS VALUES(2974,10423,'S18_3136',21,98.44E0,2)
INSERT INTO ORDERDETAILS VALUES(2975,10423,'S18_3320',21,80.36E0,5)
INSERT INTO ORDERDETAILS VALUES(2976,10423,'S24_4258',28,78.89E0,4)
INSERT INTO ORDERDETAILS VALUES(2977,10424,'S10_1949',50,201.44E0,6)
INSERT INTO ORDERDETAILS VALUES(2978,10424,'S12_1666',49,121.64E0,3)
INSERT INTO ORDERDETAILS VALUES(2979,10424,'S18_1097',54,108.5E0,5)
INSERT INTO ORDERDETAILS VALUES(2980,10424,'S18_4668',26,40.25E0,4)
INSERT INTO ORDERDETAILS VALUES(2981,10424,'S32_3522',44,54.94E0,2)
INSERT INTO ORDERDETAILS VALUES(2982,10424,'S700_2824',46,85.98E0,1)
INSERT INTO ORDERDETAILS VALUES(2983,10425,'S10_4962',38,131.49E0,12)
INSERT INTO ORDERDETAILS VALUES(2984,10425,'S12_4473',33,95.99E0,4)
INSERT INTO ORDERDETAILS VALUES(2985,10425,'S18_2238',28,147.36E0,3)
INSERT INTO ORDERDETAILS VALUES(2986,10425,'S18_2319',38,117.82E0,7)
INSERT INTO ORDERDETAILS VALUES(2987,10425,'S18_2432',19,48.62E0,10)
INSERT INTO ORDERDETAILS VALUES(2988,10425,'S18_3232',28,140.55E0,8)
INSERT INTO ORDERDETAILS VALUES(2989,10425,'S18_4600',38,107.76E0,13)
INSERT INTO ORDERDETAILS VALUES(2990,10425,'S24_1444',55,53.75E0,1)
INSERT INTO ORDERDETAILS VALUES(2991,10425,'S24_2300',49,127.79E0,9)
INSERT INTO ORDERDETAILS VALUES(2992,10425,'S24_2840',31,31.82E0,5)
INSERT INTO ORDERDETAILS VALUES(2993,10425,'S32_1268',41,83.79E0,11)
INSERT INTO ORDERDETAILS VALUES(2994,10425,'S32_2509',11,50.32E0,6)
INSERT INTO ORDERDETAILS VALUES(2995,10425,'S50_1392',18,94.92E0,2)
INSERT INTO PRODUCTS VALUES('S10_1678','1969 Harley Davidson Ultimate Chopper','Motorcycles','1:10','Min Lin Diecast','This replica features working kickstand, front suspension, gear-shift lever, footbrake lever, drive chain, wheels and steering. All parts are particularly delicate due to their precise scale and require special care and attention.',7933,48.81E0,95.7E0)
INSERT INTO PRODUCTS VALUES('S10_1949','1952 Alpine Renault 1300','Classic Cars','1:10','Classic Metal Creations','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',7305,98.58E0,214.3E0)
INSERT INTO PRODUCTS VALUES('S10_2016','1996 Moto Guzzi 1100i','Motorcycles','1:10','Highway 66 Mini Classics','Official Moto Guzzi logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.',6625,68.99E0,118.94E0)
INSERT INTO PRODUCTS VALUES('S10_4698','2003 Harley-Davidson Eagle Drag Bike','Motorcycles','1:10','Red Start Diecast','Model features, official Harley Davidson logos and insignias, detachable rear wheelie bar, heavy diecast metal with resin parts, authentic multi-color tampo-printed graphics, separate engine drive belts, free-turning front fork, rotating tires and rear racing slick, certificate of authenticity, detailed engine, display stand, precision diecast replica, baked enamel finish, 1:10 scale model, removable fender, seat and tank cover piece for displaying the superior detail of the v-twin engine',5582,91.02E0,193.66E0)
INSERT INTO PRODUCTS VALUES('S10_4757','1972 Alfa Romeo GTA','Classic Cars','1:10','Motor City Art Classics','Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',3252,85.68E0,136.0E0)
INSERT INTO PRODUCTS VALUES('S10_4962','1962 LanciaA Delta 16V','Classic Cars','1:10','Second Gear Diecast','Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',6791,103.42E0,147.74E0)
INSERT INTO PRODUCTS VALUES('S12_1099','1968 Ford Mustang','Classic Cars','1:12','Autoart Studio Design','Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color dark green.',68,95.34E0,194.57E0)
INSERT INTO PRODUCTS VALUES('S12_1108','2001 Ferrari Enzo','Classic Cars','1:12','Second Gear Diecast','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',3619,95.59E0,207.8E0)
INSERT INTO PRODUCTS VALUES('S12_1666','1958 Setra Bus','Trucks and Buses','1:12','Welly Diecast Productions','Model features 30 windows, skylights & glare resistant glass, working steering system, original logos',1579,77.9E0,136.67E0)
INSERT INTO PRODUCTS VALUES('S12_2823','2002 Suzuki XREO','Motorcycles','1:12','Unimax Art Galleries','Official logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.',9997,66.27E0,150.62E0)
INSERT INTO PRODUCTS VALUES('S12_3148','1969 Corvair Monza','Classic Cars','1:18','Welly Diecast Productions','1:18 scale die-cast about 10| long doors open, hood opens, trunk opens and wheels roll',6906,89.14E0,151.08E0)
INSERT INTO PRODUCTS VALUES('S12_3380','1968 Dodge Charger','Classic Cars','1:12','Welly Diecast Productions','1:12 scale model of a 1968 Dodge Charger. Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color black',9123,75.16E0,117.44E0)
INSERT INTO PRODUCTS VALUES('S12_3891','1969 Ford Falcon','Classic Cars','1:12','Second Gear Diecast','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',1049,83.05E0,173.02E0)
INSERT INTO PRODUCTS VALUES('S12_3990','1970 Plymouth Hemi Cuda','Classic Cars','1:12','Studio M Art Models','Very detailed 1970 Plymouth Cuda model in 1:12 scale. The Cuda is generally accepted as one of the fastest original muscle cars from the 1970s. This model is a reproduction of one of the orginal 652 cars built in 1970. Red color.',5663,31.92E0,79.8E0)
INSERT INTO PRODUCTS VALUES('S12_4473','1957 Chevy Pickup','Trucks and Buses','1:12','Exoto Designs','1:12 scale die-cast about 20| long Hood opens, Rubber wheels',6125,55.7E0,118.5E0)
INSERT INTO PRODUCTS VALUES('S12_4675','1969 Dodge Charger','Classic Cars','1:12','Welly Diecast Productions','Detailed model of the 1969 Dodge Charger. This model includes finely detailed interior and exterior features. Painted in red and white.',7323,58.73E0,115.16E0)
INSERT INTO PRODUCTS VALUES('S18_1097','1940 Ford Pickup Truck','Trucks and Buses','1:18','Studio M Art Models','This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood,  removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box',2613,58.33E0,116.67E0)
INSERT INTO PRODUCTS VALUES('S18_1129','1993 Mazda RX-7','Classic Cars','1:18','Highway 66 Mini Classics','This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color red.',3975,83.51E0,141.54E0)
INSERT INTO PRODUCTS VALUES('S18_1342','1937 Lincoln Berline','Vintage Cars','1:18','Motor City Art Classics','Features opening engine cover, doors, trunk, and fuel filler cap. Color black',8693,60.62E0,102.74E0)
INSERT INTO PRODUCTS VALUES('S18_1367','1936 Mercedes-Benz 500K Special Roadster','Vintage Cars','1:18','Studio M Art Models','This 1:18 scale replica is constructed of heavy die-cast metal and has all the features of the original: working doors and rumble seat, independent spring suspension, detailed interior, working steering system, and a bifold hood that reveals an engine so accurate that it even includes the wiring. All this is topped off with a baked enamel finish. Color white.',8635,24.26E0,53.91E0)
INSERT INTO PRODUCTS VALUES('S18_1589','1965 Aston Martin DB5','Classic Cars','1:18','Classic Metal Creations','Die-cast model of the silver 1965 Aston Martin DB5 in silver. This model includes full wire wheels and doors that open with fully detailed passenger compartment. In 1:18 scale, this model measures approximately 10 inches/20 cm long.',9042,65.96E0,124.44E0)
INSERT INTO PRODUCTS VALUES('S18_1662','1980s Black Hawk Helicopter','Planes','1:18','Red Start Diecast','1:18 scale replica of actual Army''s UH-60L BLACK HAWK Helicopter. 100% hand-assembled. Features rotating rotor blades, propeller blades and rubber wheels.',5330,77.27E0,157.69E0)
INSERT INTO PRODUCTS VALUES('S18_1749','1917 Grand Touring Sedan','Vintage Cars','1:18','Welly Diecast Productions','This 1:18 scale replica of the 1917 Grand Touring car has all the features you would expect from museum quality reproductions: all four doors and bi-fold hood opening, detailed engine and instrument panel, chrome-look trim, and tufted upholstery, all topped off with a factory baked-enamel finish.',2724,86.7E0,170.0E0)
INSERT INTO PRODUCTS VALUES('S18_1889','1948 Porsche 356-A Roadster','Classic Cars','1:18','Gearbox Collectibles','This precision die-cast replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',8826,53.9E0,77.0E0)
INSERT INTO PRODUCTS VALUES('S18_1984','1995 Honda Civic','Classic Cars','1:18','Min Lin Diecast','This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color yellow.',9772,93.89E0,142.25E0)
INSERT INTO PRODUCTS VALUES('S18_2238','1998 Chrysler Plymouth Prowler','Classic Cars','1:18','Gearbox Collectibles','Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',4724,101.51E0,163.73E0)
INSERT INTO PRODUCTS VALUES('S18_2248','1911 Ford Town Car','Vintage Cars','1:18','Motor City Art Classics','Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system.',540,33.3E0,60.54E0)
INSERT INTO PRODUCTS VALUES('S18_2319','1964 Mercedes Tour Bus','Trucks and Buses','1:18','Unimax Art Galleries','Exact replica. 100+ parts. working steering system, original logos',8258,74.86E0,122.73E0)
INSERT INTO PRODUCTS VALUES('S18_2325','1932 Model A Ford J-Coupe','Vintage Cars','1:18','Autoart Studio Design','This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine',9354,58.48E0,127.13E0)
INSERT INTO PRODUCTS VALUES('S18_2432','1926 Ford Fire Engine','Trucks and Buses','1:18','Carousel DieCast Legends','Gleaming red handsome appearance. Everything is here the fire hoses, ladder, axes, bells, lanterns, ready to fight any inferno.',2018,24.92E0,60.77E0)
INSERT INTO PRODUCTS VALUES('S18_2581','P-51-D Mustang','Planes','1:72','Gearbox Collectibles','Has retractable wheels and comes with a stand',992,49.0E0,84.48E0)
INSERT INTO PRODUCTS VALUES('S18_2625','1936 Harley Davidson El Knucklehead','Motorcycles','1:18','Welly Diecast Productions','Intricately detailed with chrome accents and trim, official die-struck logos and baked enamel finish.',4357,24.23E0,60.57E0)
INSERT INTO PRODUCTS VALUES('S18_2795','1928 Mercedes-Benz SSK','Vintage Cars','1:18','Gearbox Collectibles','This 1:18 replica features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine. Color black.',548,72.56E0,168.75E0)
INSERT INTO PRODUCTS VALUES('S18_2870','1999 Indy 500 Monte Carlo SS','Classic Cars','1:18','Red Start Diecast','Features include opening and closing doors. Color: Red',8164,56.76E0,132.0E0)
INSERT INTO PRODUCTS VALUES('S18_2949','1913 Ford Model T Speedster','Vintage Cars','1:18','Carousel DieCast Legends','This 250 part reproduction includes moving handbrakes, clutch, throttle and foot pedals, squeezable horn, detailed wired engine, removable water, gas, and oil cans, pivoting monocle windshield, all topped with a baked enamel red finish. Each replica comes with an Owners Title and Certificate of Authenticity. Color red.',4189,60.78E0,101.31E0)
INSERT INTO PRODUCTS VALUES('S18_2957','1934 Ford V8 Coupe','Vintage Cars','1:18','Min Lin Diecast','Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System',5649,34.35E0,62.46E0)
INSERT INTO PRODUCTS VALUES('S18_3029','1999 Yamaha Speed Boat','Ships','1:18','Min Lin Diecast','Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.',4259,51.61E0,86.02E0)
INSERT INTO PRODUCTS VALUES('S18_3136','18th Century Vintage Horse Carriage','Vintage Cars','1:18','Red Start Diecast','Hand crafted diecast-like metal horse carriage is re-created in about 1:18 scale of antique horse carriage. This antique style metal Stagecoach is all hand-assembled with many different parts.This collectible metal horse carriage is painted in classic Red, and features turning steering wheel and is entirely hand-finished.',5992,60.74E0,104.72E0)
INSERT INTO PRODUCTS VALUES('S18_3140','1903 Ford Model A','Vintage Cars','1:18','Unimax Art Galleries','Features opening trunk,  working steering system',3913,68.3E0,136.59E0)
INSERT INTO PRODUCTS VALUES('S18_3232','1992 Ferrari 360 Spider red','Classic Cars','1:18','Unimax Art Galleries','his replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',8347,77.9E0,169.34E0)
INSERT INTO PRODUCTS VALUES('S18_3233','1985 Toyota Supra','Classic Cars','1:18','Highway 66 Mini Classics','This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood, removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box',7733,57.01E0,107.57E0)
INSERT INTO PRODUCTS VALUES('S18_3259','Collectable Wooden Train','Trains','1:18','Carousel DieCast Legends','Hand crafted wooden toy train set is in about 1:18 scale, 25 inches in total length including 2 additional carts, of actual vintage train. This antique style wooden toy train model set is all hand-assembled with 100% wood.',6450,67.56E0,100.84E0)
INSERT INTO PRODUCTS VALUES('S18_3278','1969 Dodge Super Bee','Classic Cars','1:18','Min Lin Diecast','This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',1917,49.05E0,80.41E0)
INSERT INTO PRODUCTS VALUES('S18_3320','1917 Maxwell Touring Car','Vintage Cars','1:18','Exoto Designs','Features Gold Trim, Full Size Spare Tire, Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System',7913,57.54E0,99.21E0)
INSERT INTO PRODUCTS VALUES('S18_3482','1976 Ford Gran Torino','Classic Cars','1:18','Gearbox Collectibles','Highly detailed 1976 Ford Gran Torino |Starsky and Hutch| diecast model. Very well constructed and painted in red and white patterns.',9127,73.49E0,146.99E0)
INSERT INTO PRODUCTS VALUES('S18_3685','1948 Porsche Type 356 Roadster','Classic Cars','1:18','Gearbox Collectibles','This model features working front and rear suspension on accurately replicated and actuating shock absorbers as well as opening engine cover, rear stabilizer flap,  and 4 opening doors.',8990,62.16E0,141.28E0)
INSERT INTO PRODUCTS VALUES('S18_3782','1957 Vespa GS150','Motorcycles','1:18','Studio M Art Models','Features rotating wheels , working kick stand. Comes with stand.',7689,32.95E0,62.17E0)
INSERT INTO PRODUCTS VALUES('S18_3856','1941 Chevrolet Special Deluxe Cabriolet','Vintage Cars','1:18','Exoto Designs','Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system, leather upholstery. Color black.',2378,64.58E0,105.87E0)
INSERT INTO PRODUCTS VALUES('S18_4027','1970 Triumph Spitfire','Classic Cars','1:18','Min Lin Diecast','Features include opening and closing doors. Color: White.',5545,91.92E0,143.62E0)
INSERT INTO PRODUCTS VALUES('S18_4409','1932 Alfa Romeo 8C2300 Spider Sport','Vintage Cars','1:18','Exoto Designs','This 1:18 scale precision die cast replica features the 6 front headlights of the original, plus a detailed version of the 142 horsepower straight 8 engine, dual spares and their famous comprehensive dashboard. Color black.',6553,43.26E0,92.03E0)
INSERT INTO PRODUCTS VALUES('S18_4522','1904 Buick Runabout','Vintage Cars','1:18','Exoto Designs','Features opening trunk,  working steering system',8290,52.66E0,87.77E0)
INSERT INTO PRODUCTS VALUES('S18_4600','1940s Ford truck','Trucks and Buses','1:18','Motor City Art Classics','This 1940s Ford Pick-Up truck is re-created in 1:18 scale of original 1940s Ford truck. This antique style metal 1940s Ford Flatbed truck is all hand-assembled. This collectible 1940''s Pick-Up truck is painted in classic dark green color, and features rotating wheels.',3128,84.76E0,121.08E0)
INSERT INTO PRODUCTS VALUES('S18_4668','1939 Cadillac Limousine','Vintage Cars','1:18','Studio M Art Models','Features completely detailed interior including Velvet flocked drapes,deluxe wood grain floor, and a wood grain casket with seperate chrome handles',6645,23.14E0,50.31E0)
INSERT INTO PRODUCTS VALUES('S18_4721','1957 Corvette Convertible','Classic Cars','1:18','Classic Metal Creations','1957 die cast Corvette Convertible in Roman Red with white sides and whitewall tires. 1:18 scale quality die-cast with detailed engine and underbvody. Now you can own The Classic Corvette.',1249,69.93E0,148.8E0)
INSERT INTO PRODUCTS VALUES('S18_4933','1957 Ford Thunderbird','Classic Cars','1:18','Studio M Art Models','This 1:18 scale precision die-cast replica, with its optional porthole hardtop and factory baked-enamel Thunderbird Bronze finish, is a 100% accurate rendition of this American classic.',3209,34.21E0,71.27E0)
INSERT INTO PRODUCTS VALUES('S24_1046','1970 Chevy Chevelle SS 454','Classic Cars','1:24','Unimax Art Galleries','This model features rotating wheels, working streering system and opening doors. All parts are particularly delicate due to their precise scale and require special care and attention. It should not be picked up by the doors, roof, hood or trunk.',1005,49.24E0,73.49E0)
INSERT INTO PRODUCTS VALUES('S24_1444','1970 Dodge Coronet','Classic Cars','1:24','Highway 66 Mini Classics','1:24 scale die-cast about 18| long doors open, hood opens and rubber wheels',4074,32.37E0,57.8E0)
INSERT INTO PRODUCTS VALUES('S24_1578','1997 BMW R 1100 S','Motorcycles','1:24','Autoart Studio Design','Detailed scale replica with working suspension and constructed from over 70 parts',7003,60.86E0,112.7E0)
INSERT INTO PRODUCTS VALUES('S24_1628','1966 Shelby Cobra 427 S/C','Classic Cars','1:24','Carousel DieCast Legends','This diecast model of the 1966 Shelby Cobra 427 S/C includes many authentic details and operating parts. The 1:24 scale model of this iconic lighweight sports car from the 1960s comes in silver and it''s own display case.',8197,29.18E0,50.31E0)
INSERT INTO PRODUCTS VALUES('S24_1785','1928 British Royal Navy Airplane','Planes','1:24','Classic Metal Creations','Official logos and insignias',3627,66.74E0,109.42E0)
INSERT INTO PRODUCTS VALUES('S24_1937','1939 Chevrolet Deluxe Coupe','Vintage Cars','1:24','Motor City Art Classics','This 1:24 scale die-cast replica of the 1939 Chevrolet Deluxe Coupe has the same classy look as the original. Features opening trunk, hood and doors and a showroom quality baked enamel finish.',7332,22.57E0,33.19E0)
INSERT INTO PRODUCTS VALUES('S24_2000','1960 BSA Gold Star DBD34','Motorcycles','1:24','Highway 66 Mini Classics','Detailed scale replica with working suspension and constructed from over 70 parts',15,37.32E0,76.17E0)
INSERT INTO PRODUCTS VALUES('S24_2011','18th century schooner','Ships','1:24','Carousel DieCast Legends','All wood with canvas sails. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with 4 masts, all square-rigged.',1898,82.34E0,122.89E0)
INSERT INTO PRODUCTS VALUES('S24_2022','1938 Cadillac V-16 Presidential Limousine','Vintage Cars','1:24','Classic Metal Creations','This 1:24 scale precision die cast replica of the 1938 Cadillac V-16 Presidential Limousine has all the details of the original, from the flags on the front to an opening back seat compartment complete with telephone and rifle. Features factory baked-enamel black finish, hood goddess ornament, working jump seats.',2847,20.61E0,44.8E0)
INSERT INTO PRODUCTS VALUES('S24_2300','1962 Volkswagen Microbus','Trucks and Buses','1:24','Autoart Studio Design','This 1:18 scale die cast replica of the 1962 Microbus is loaded with features: A working steering system, opening front doors and tailgate, and famous two-tone factory baked enamel finish, are all topped of by the sliding, real fabric, sunroof.',2327,61.34E0,127.79E0)
INSERT INTO PRODUCTS VALUES('S24_2360','1982 Ducati 900 Monster','Motorcycles','1:24','Highway 66 Mini Classics','Features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand',6840,47.1E0,69.26E0)
INSERT INTO PRODUCTS VALUES('S24_2766','1949 Jaguar XK 120','Classic Cars','1:24','Classic Metal Creations','Precision-engineered from original Jaguar specification in perfect scale ratio. Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',2350,47.25E0,90.87E0)
INSERT INTO PRODUCTS VALUES('S24_2840','1958 Chevy Corvette Limited Edition','Classic Cars','1:24','Carousel DieCast Legends','The operating parts of this 1958 Chevy Corvette Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, working streering, opening doors and trunk. Color dark green.',2542,15.91E0,35.36E0)
INSERT INTO PRODUCTS VALUES('S24_2841','1900s Vintage Bi-Plane','Planes','1:24','Autoart Studio Design','Hand crafted diecast-like metal bi-plane is re-created in about 1:24 scale of antique pioneer airplane. All hand-assembled with many different parts. Hand-painted in classic yellow and features correct markings of original airplane.',5942,34.25E0,68.51E0)
INSERT INTO PRODUCTS VALUES('S24_2887','1952 Citroen-15CV','Classic Cars','1:24','Exoto Designs','Precision crafted hand-assembled 1:18 scale reproduction of the 1952 15CV, with its independent spring suspension, working steering system, opening doors and hood, detailed engine and instrument panel, all topped of with a factory fresh baked enamel finish.',1452,72.82E0,117.44E0)
INSERT INTO PRODUCTS VALUES('S24_2972','1982 Lamborghini Diablo','Classic Cars','1:24','Second Gear Diecast','This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',7723,16.24E0,37.76E0)
INSERT INTO PRODUCTS VALUES('S24_3151','1912 Ford Model T Delivery Wagon','Vintage Cars','1:24','Min Lin Diecast','This model features chrome trim and grille, opening hood, opening doors, opening trunk, detailed engine, working steering system. Color white.',9173,46.91E0,88.51E0)
INSERT INTO PRODUCTS VALUES('S24_3191','1969 Chevrolet Camaro Z28','Classic Cars','1:24','Exoto Designs','1969 Z/28 Chevy Camaro 1:24 scale replica. The operating parts of this limited edition 1:24 scale diecast model car 1969 Chevy Camaro Z28- hood, trunk, wheels, streering, suspension and doors- are particularly delicate due to their precise scale and require special care and attention.',4695,50.51E0,85.61E0)
INSERT INTO PRODUCTS VALUES('S24_3371','1971 Alpine Renault 1600s','Classic Cars','1:24','Welly Diecast Productions','This 1971 Alpine Renault 1600s replica Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',7995,38.58E0,61.23E0)
INSERT INTO PRODUCTS VALUES('S24_3420','1937 Horch 930V Limousine','Vintage Cars','1:24','Autoart Studio Design','Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system',2902,26.3E0,65.75E0)
INSERT INTO PRODUCTS VALUES('S24_3432','2002 Chevy Corvette','Classic Cars','1:24','Gearbox Collectibles','The operating parts of this limited edition Diecast 2002 Chevy Corvette 50th Anniversary Pace car Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, poseable streering, opening doors and trunk.',9446,62.11E0,107.08E0)
INSERT INTO PRODUCTS VALUES('S24_3816','1940 Ford Delivery Sedan','Vintage Cars','1:24','Carousel DieCast Legends','Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System. Color black.',6621,48.64E0,83.86E0)
INSERT INTO PRODUCTS VALUES('S24_3856','1956 Porsche 356A Coupe','Classic Cars','1:18','Classic Metal Creations','Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.',6600,98.3E0,140.43E0)
INSERT INTO PRODUCTS VALUES('S24_3949','Corsair F4U ( Bird Cage)','Planes','1:24','Second Gear Diecast','Has retractable wheels and comes with a stand. Official logos and insignias.',6812,29.34E0,68.24E0)
INSERT INTO PRODUCTS VALUES('S24_3969','1936 Mercedes Benz 500k Roadster','Vintage Cars','1:24','Red Start Diecast','This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system and rubber wheels. Color black.',2081,21.75E0,41.03E0)
INSERT INTO PRODUCTS VALUES('S24_4048','1992 Porsche Cayenne Turbo Silver','Classic Cars','1:24','Exoto Designs','This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.',6582,69.78E0,118.28E0)
INSERT INTO PRODUCTS VALUES('S24_4258','1936 Chrysler Airflow','Vintage Cars','1:24','Second Gear Diecast','Features opening trunk,  working steering system. Color dark green.',4710,57.46E0,97.39E0)
INSERT INTO PRODUCTS VALUES('S24_4278','1900s Vintage Tri-Plane','Planes','1:24','Unimax Art Galleries','Hand crafted diecast-like metal Triplane is Re-created in about 1:24 scale of antique pioneer airplane. This antique style metal triplane is all hand-assembled with many different parts.',2756,36.23E0,72.45E0)
INSERT INTO PRODUCTS VALUES('S24_4620','1961 Chevrolet Impala','Classic Cars','1:18','Classic Metal Creations','This 1:18 scale precision die-cast reproduction of the 1961 Chevrolet Impala has all the features-doors, hood and trunk that open; detailed 409 cubic-inch engine; chrome dashboard and stick shift, two-tone interior; working steering system; all topped of with a factory baked-enamel finish.',7869,32.33E0,80.84E0)
INSERT INTO PRODUCTS VALUES('S32_1268','1980\u005cu005cufffds GM Manhattan Express','Trucks and Buses','1:32','Motor City Art Classics','This 1980\u005cu005cufffds era new look Manhattan express is still active, running from the Bronx to mid-town Manhattan. Has 35 opeining windows and working lights. Needs a battery.',5099,53.93E0,96.31E0)
INSERT INTO PRODUCTS VALUES('S32_1374','1997 BMW F650 ST','Motorcycles','1:32','Exoto Designs','Features official die-struck logos and baked enamel finish. Comes with stand.',178,66.92E0,99.89E0)
INSERT INTO PRODUCTS VALUES('S32_2206','1982 Ducati 996 R','Motorcycles','1:32','Gearbox Collectibles','Features rotating wheels , working kick stand. Comes with stand.',9241,24.14E0,40.23E0)
INSERT INTO PRODUCTS VALUES('S32_2509','1954 Greyhound Scenicruiser','Trucks and Buses','1:32','Classic Metal Creations','Model features bi-level seating, 50 windows, skylights & glare resistant glass, working steering system, original logos',2874,25.98E0,54.11E0)
INSERT INTO PRODUCTS VALUES('S32_3207','1950''s Chicago Surface Lines Streetcar','Trains','1:32','Gearbox Collectibles','This streetcar is a joy to see. It has 80 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).',8601,26.72E0,62.14E0)
INSERT INTO PRODUCTS VALUES('S32_3522','1996 Peterbilt 379 Stake Bed with Outrigger','Trucks and Buses','1:32','Red Start Diecast','This model features, opening doors, detailed engine, working steering, tinted windows, detailed interior, die-struck logos, removable stakes operating outriggers, detachable second trailer, functioning 360-degree self loader, precision molded resin trailer and trim, baked enamel finish on cab',814,33.61E0,64.64E0)
INSERT INTO PRODUCTS VALUES('S32_4289','1928 Ford Phaeton Deluxe','Vintage Cars','1:32','Highway 66 Mini Classics','This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system',136,33.02E0,68.79E0)
INSERT INTO PRODUCTS VALUES('S32_4485','1974 Ducati 350 Mk3 Desmo','Motorcycles','1:32','Second Gear Diecast','This model features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand',3341,56.13E0,102.05E0)
INSERT INTO PRODUCTS VALUES('S50_1341','1930 Buick Marquette Phaeton','Vintage Cars','1:50','Studio M Art Models','Features opening trunk,  working steering system',7062,27.06E0,43.64E0)
INSERT INTO PRODUCTS VALUES('S50_1392','Diamond T620 Semi-Skirted Tanker','Trucks and Buses','1:50','Highway 66 Mini Classics','This limited edition model is licensed and perfectly scaled for Lionel Trains. The Diamond T620 has been produced in solid precision diecast and painted with a fire baked enamel finish. It comes with a removable tanker and is a perfect model to add authenticity to your static train or car layout or to just have on display.',1016,68.29E0,115.75E0)
INSERT INTO PRODUCTS VALUES('S50_1514','1962 City of Detroit Streetcar','Trains','1:50','Classic Metal Creations','This streetcar is a joy to see. It has 99 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).',1645,37.49E0,58.58E0)
INSERT INTO PRODUCTS VALUES('S50_4713','2002 Yamaha YZR M1','Motorcycles','1:50','Autoart Studio Design','Features rotating wheels , working kick stand. Comes with stand.',600,34.17E0,81.36E0)
INSERT INTO PRODUCTS VALUES('S700_1138','The Schooner Bluenose','Ships','1:700','Autoart Studio Design','All wood with canvas sails. Measures 31 1/2 inches in Length, 22 inches High and 4 3/4 inches Wide. Many extras.The schooner Bluenose was built in Nova Scotia in 1921 to fish the rough waters off the coast of Newfoundland. Because of the Bluenose racing prowess she became the pride of all Canadians. Still featured on stamps and the Canadian dime, the Bluenose was lost off Haiti in 1946.',1897,34.0E0,66.67E0)
INSERT INTO PRODUCTS VALUES('S700_1691','American Airlines: B767-300','Planes','1:700','Min Lin Diecast','Exact replia with official logos and insignias and retractable wheels',5841,51.15E0,91.34E0)
INSERT INTO PRODUCTS VALUES('S700_1938','The Mayflower','Ships','1:700','Studio M Art Models','Measures 31 1/2 inches Long x 25 1/2 inches High x 10 5/8 inches Wide All wood with canvas sail. Extras include long boats, rigging, ladders, railing, anchors, side cannons, hand painted, etc.',737,43.3E0,86.61E0)
INSERT INTO PRODUCTS VALUES('S700_2047','HMS Bounty','Ships','1:700','Unimax Art Galleries','Measures 30 inches Long x 27 1/2 inches High x 4 3/4 inches Wide. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.',3501,39.83E0,90.52E0)
INSERT INTO PRODUCTS VALUES('S700_2466','America West Airlines B757-200','Planes','1:700','Motor City Art Classics','Official logos and insignias. Working steering system. Rotating jet engines',9653,68.8E0,99.72E0)
INSERT INTO PRODUCTS VALUES('S700_2610','The USS Constitution Ship','Ships','1:700','Red Start Diecast','All wood with canvas sails. Measures 31 1/2| Length x 22 3/8| High x 8 1/4| Width. Extras include 4 boats on deck, sea sprite on bow, anchors, copper railing, pilot houses, etc.',7083,33.97E0,72.28E0)
INSERT INTO PRODUCTS VALUES('S700_2824','1982 Camaro Z28','Classic Cars','1:18','Carousel DieCast Legends','Features include opening and closing doors. Color: White.Measures approximately 9 1/2| Long.',6934,46.53E0,101.15E0)
INSERT INTO PRODUCTS VALUES('S700_2834','ATA: B757-300','Planes','1:700','Highway 66 Mini Classics','Exact replia with official logos and insignias and retractable wheels',7106,59.33E0,118.65E0)
INSERT INTO PRODUCTS VALUES('S700_3167','F/A 18 Hornet 1/72','Planes','1:72','Motor City Art Classics','10| Wingspan with retractable landing gears.Comes with pilot',551,54.4E0,80.0E0)
INSERT INTO PRODUCTS VALUES('S700_3505','The Titanic','Ships','1:700','Carousel DieCast Legends','Completed model measures 19 1/2 inches long, 9 inches high, 3inches wide and is in barn red/black. All wood and metal.',1956,51.09E0,100.17E0)
INSERT INTO PRODUCTS VALUES('S700_3962','The Queen Mary','Ships','1:700','Welly Diecast Productions','Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.',5088,53.63E0,99.31E0)
INSERT INTO PRODUCTS VALUES('S700_4002','American Airlines: MD-11S','Planes','1:700','Second Gear Diecast','Polished finish. Exact replia with official logos and insignias and retractable wheels',8820,36.27E0,74.03E0)
INSERT INTO PRODUCTS VALUES('S72_1253','Boeing X-32A JSF','Planes','1:72','Motor City Art Classics','10| Wingspan with retractable landing gears.Comes with pilot',4857,32.77E0,49.66E0)
INSERT INTO PRODUCTS VALUES('S72_3212','Pont Yacht','Ships','1:72','Unimax Art Galleries','Measures 38 inches Long x 33 3/4 inches High. Includes a stand.Many extras including rigging, long boats, pilot house, anchors, etc. Comes with 2 masts, all square-rigged',414,33.3E0,54.6E0)
INSERT INTO PRODUCTLINES VALUES('Classic Cars','Attention car enthusiasts: Make your wildest car ownership dreams come true. Whether you are looking for classic muscle cars, dream sports cars or movie-inspired miniatures, you will find great choices in this category. These replicas feature superb attention to detail and craftsmanship and offer features such as working steering system, opening forward compartment, opening rear trunk with removable spare wheel, 4-wheel independent spring suspension, and so on. The models range in size from 1:10 to 1:24 scale and include numerous limited edition and several out-of-production vehicles. All models include a certificate of authenticity from their manufacturers and come fully assembled and ready for display in the home or office.','')
INSERT INTO PRODUCTLINES VALUES('Motorcycles','Our motorcycles are state of the art replicas of classic as well as contemporary motorcycle legends such as Harley Davidson, Ducati and Vespa. Models contain stunning details such as official logos, rotating wheels, working kickstand, front suspension, gear-shift lever, footbrake lever, and drive chain. Materials used include diecast and plastic. The models range in size from 1:10 to 1:50 scale and include numerous limited edition and several out-of-production vehicles. All models come fully assembled and ready for display in the home or office. Most include a certificate of authenticity.','')
INSERT INTO PRODUCTLINES VALUES('Planes','Unique, diecast airplane and helicopter replicas suitable for collections, as well as home, office or classroom decorations. Models contain stunning details such as official logos and insignias, rotating jet engines and propellers, retractable wheels, and so on. Most come fully assembled and with a certificate of authenticity from their manufacturers.','')
INSERT INTO PRODUCTLINES VALUES('Ships','The perfect holiday or anniversary gift for executives, clients, friends, and family. These handcrafted model ships are unique, stunning works of art that will be treasured for generations! They come fully assembled and ready for display in the home or office. We guarantee the highest quality, and best value.','')
INSERT INTO PRODUCTLINES VALUES('Trains','Model trains are a rewarding hobby for enthusiasts of all ages. Whether you''re looking for collectible wooden trains, electric streetcars or locomotives, you''ll find a number of great choices for any budget within this category. The interactive aspect of trains makes toy trains perfect for young children. The wooden train sets are ideal for children under the age of 5.','')
INSERT INTO PRODUCTLINES VALUES('Trucks and Buses','The Truck and Bus models are realistic replicas of buses and specialized trucks produced from the early 1920s to present. The models range in size from 1:12 to 1:50 scale and include numerous limited edition and several out-of-production vehicles. Materials used include tin, diecast and plastic. All models include a certificate of authenticity from their manufacturers and are a perfect ornament for the home and office.','')
INSERT INTO PRODUCTLINES VALUES('Vintage Cars','Our Vintage Car models realistically portray automobiles produced from the early 1900s through the 1940s. Materials used include Bakelite, diecast, plastic and wood. Most of the replicas are in the 1:18 and 1:24 scale sizes, which provide the optimum in detail and accuracy. Prices range from $30.00 up to $180.00 for some special limited edition replicas. All models include a certificate of authenticity from their manufacturers and come fully assembled and ready for display in the home or office.','')
INSERT INTO ORDERS VALUES(10100,'2003-01-06','2003-01-13','2003-01-10','Shipped','',363)
INSERT INTO ORDERS VALUES(10101,'2003-01-09','2003-01-18','2003-01-11','Shipped','Check on availability.',128)
INSERT INTO ORDERS VALUES(10102,'2003-01-10','2003-01-18','2003-01-14','Shipped','',181)
INSERT INTO ORDERS VALUES(10103,'2003-01-29','2003-02-07','2003-02-02','Shipped','',121)
INSERT INTO ORDERS VALUES(10104,'2003-01-31','2003-02-09','2003-02-01','Shipped','',141)
INSERT INTO ORDERS VALUES(10105,'2003-02-11','2003-02-21','2003-02-12','Shipped','',145)
INSERT INTO ORDERS VALUES(10106,'2003-02-17','2003-02-24','2003-02-21','Shipped','',278)
INSERT INTO ORDERS VALUES(10107,'2003-02-24','2003-03-03','2003-02-26','Shipped','Difficult to negotiate with customer. We need more marketing materials',131)
INSERT INTO ORDERS VALUES(10108,'2003-03-03','2003-03-12','2003-03-08','Shipped','',385)
INSERT INTO ORDERS VALUES(10109,'2003-03-10','2003-03-19','2003-03-11','Shipped','Customer requested that FedEx Ground is used for this shipping',486)
INSERT INTO ORDERS VALUES(10110,'2003-03-18','2003-03-24','2003-03-20','Shipped','',187)
INSERT INTO ORDERS VALUES(10111,'2003-03-25','2003-03-31','2003-03-30','Shipped','',129)
INSERT INTO ORDERS VALUES(10112,'2003-03-24','2003-04-03','2003-03-29','Shipped','Customer requested that ad materials (such as posters, pamphlets) be included in the shippment',144)
INSERT INTO ORDERS VALUES(10113,'2003-03-26','2003-04-02','2003-03-27','Shipped','',124)
INSERT INTO ORDERS VALUES(10114,'2003-04-01','2003-04-07','2003-04-02','Shipped','',172)
INSERT INTO ORDERS VALUES(10115,'2003-04-04','2003-04-12','2003-04-07','Shipped','',424)
INSERT INTO ORDERS VALUES(10116,'2003-04-11','2003-04-19','2003-04-13','Shipped','',381)
INSERT INTO ORDERS VALUES(10117,'2003-04-16','2003-04-24','2003-04-17','Shipped','',148)
INSERT INTO ORDERS VALUES(10118,'2003-04-21','2003-04-29','2003-04-26','Shipped','Customer has worked with some of our vendors in the past and is aware of their MSRP',216)
INSERT INTO ORDERS VALUES(10119,'2003-04-28','2003-05-05','2003-05-02','Shipped','',382)
INSERT INTO ORDERS VALUES(10120,'2003-04-29','2003-05-08','2003-05-01','Shipped','',114)
INSERT INTO ORDERS VALUES(10121,'2003-05-07','2003-05-13','2003-05-13','Shipped','',353)
INSERT INTO ORDERS VALUES(10122,'2003-05-08','2003-05-16','2003-05-13','Shipped','',350)
INSERT INTO ORDERS VALUES(10123,'2003-05-20','2003-05-29','2003-05-22','Shipped','',103)
INSERT INTO ORDERS VALUES(10124,'2003-05-21','2003-05-29','2003-05-25','Shipped','Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch',112)
INSERT INTO ORDERS VALUES(10125,'2003-05-21','2003-05-27','2003-05-24','Shipped','',114)
INSERT INTO ORDERS VALUES(10126,'2003-05-28','2003-06-07','2003-06-02','Shipped','',458)
INSERT INTO ORDERS VALUES(10127,'2003-06-03','2003-06-09','2003-06-06','Shipped','Customer requested special shippment. The instructions were passed along to the warehouse',151)
INSERT INTO ORDERS VALUES(10128,'2003-06-06','2003-06-12','2003-06-11','Shipped','',141)
INSERT INTO ORDERS VALUES(10129,'2003-06-12','2003-06-18','2003-06-14','Shipped','',324)
INSERT INTO ORDERS VALUES(10130,'2003-06-16','2003-06-24','2003-06-21','Shipped','',198)
INSERT INTO ORDERS VALUES(10131,'2003-06-16','2003-06-25','2003-06-21','Shipped','',447)
INSERT INTO ORDERS VALUES(10132,'2003-06-25','2003-07-01','2003-06-28','Shipped','',323)
INSERT INTO ORDERS VALUES(10133,'2003-06-27','2003-07-04','2003-07-03','Shipped','',141)
INSERT INTO ORDERS VALUES(10134,'2003-07-01','2003-07-10','2003-07-05','Shipped','',250)
INSERT INTO ORDERS VALUES(10135,'2003-07-02','2003-07-12','2003-07-03','Shipped','',124)
INSERT INTO ORDERS VALUES(10136,'2003-07-04','2003-07-14','2003-07-06','Shipped','Customer is interested in buying more Ferrari models',242)
INSERT INTO ORDERS VALUES(10137,'2003-07-10','2003-07-20','2003-07-14','Shipped','',353)
INSERT INTO ORDERS VALUES(10138,'2003-07-07','2003-07-16','2003-07-13','Shipped','',496)
INSERT INTO ORDERS VALUES(10139,'2003-07-16','2003-07-23','2003-07-21','Shipped','',282)
INSERT INTO ORDERS VALUES(10140,'2003-07-24','2003-08-02','2003-07-30','Shipped','',161)
INSERT INTO ORDERS VALUES(10141,'2003-08-01','2003-08-09','2003-08-04','Shipped','',334)
INSERT INTO ORDERS VALUES(10142,'2003-08-08','2003-08-16','2003-08-13','Shipped','',124)
INSERT INTO ORDERS VALUES(10143,'2003-08-10','2003-08-18','2003-08-12','Shipped','Can we deliver the new Ford Mustang models by end-of-quarter?',320)
INSERT INTO ORDERS VALUES(10144,'2003-08-13','2003-08-21','2003-08-14','Shipped','',381)
INSERT INTO ORDERS VALUES(10145,'2003-08-25','2003-09-02','2003-08-31','Shipped','',205)
INSERT INTO ORDERS VALUES(10146,'2003-09-03','2003-09-13','2003-09-06','Shipped','',447)
INSERT INTO ORDERS VALUES(10147,'2003-09-05','2003-09-12','2003-09-09','Shipped','',379)
INSERT INTO ORDERS VALUES(10148,'2003-09-11','2003-09-21','2003-09-15','Shipped','They want to reevaluate their terms agreement with Finance.',276)
INSERT INTO ORDERS VALUES(10149,'2003-09-12','2003-09-18','2003-09-17','Shipped','',487)
INSERT INTO ORDERS VALUES(10150,'2003-09-19','2003-09-27','2003-09-21','Shipped','They want to reevaluate their terms agreement with Finance.',148)
INSERT INTO ORDERS VALUES(10151,'2003-09-21','2003-09-30','2003-09-24','Shipped','',311)
INSERT INTO ORDERS VALUES(10152,'2003-09-25','2003-10-03','2003-10-01','Shipped','',333)
INSERT INTO ORDERS VALUES(10153,'2003-09-28','2003-10-05','2003-10-03','Shipped','',141)
INSERT INTO ORDERS VALUES(10154,'2003-10-02','2003-10-12','2003-10-08','Shipped','',219)
INSERT INTO ORDERS VALUES(10155,'2003-10-06','2003-10-13','2003-10-07','Shipped','',186)
INSERT INTO ORDERS VALUES(10156,'2003-10-08','2003-10-17','2003-10-11','Shipped','',141)
INSERT INTO ORDERS VALUES(10157,'2003-10-09','2003-10-15','2003-10-14','Shipped','',473)
INSERT INTO ORDERS VALUES(10158,'2003-10-10','2003-10-18','2003-10-15','Shipped','',121)
INSERT INTO ORDERS VALUES(10159,'2003-10-10','2003-10-19','2003-10-16','Shipped','',321)
INSERT INTO ORDERS VALUES(10160,'2003-10-11','2003-10-17','2003-10-17','Shipped','',347)
INSERT INTO ORDERS VALUES(10161,'2003-10-17','2003-10-25','2003-10-20','Shipped','',227)
INSERT INTO ORDERS VALUES(10162,'2003-10-18','2003-10-26','2003-10-19','Shipped','',321)
INSERT INTO ORDERS VALUES(10163,'2003-10-20','2003-10-27','2003-10-24','Shipped','',424)
INSERT INTO ORDERS VALUES(10164,'2003-10-21','2003-10-30','2003-10-23','Resolved','This order was disputed, but resolved on 11/1/2003; Customer doesn''t like the colors and precision of the models.',452)
INSERT INTO ORDERS VALUES(10165,'2003-10-22','2003-10-31','2003-12-26','Shipped','This order was on hold because customers''s credit limit had been exceeded. Order will ship when payment is received',148)
INSERT INTO ORDERS VALUES(10166,'2003-10-21','2003-10-30','2003-10-27','Shipped','',462)
INSERT INTO ORDERS VALUES(10167,'2003-10-23','2003-10-30',NULL,'Cancelled','Customer called to cancel. The warehouse was notified in time and the order didn''t ship. They have a new VP of Sales and are shifting their sales model. Our VP of Sales should contact them.',448)
INSERT INTO ORDERS VALUES(10168,'2003-10-28','2003-11-03','2003-11-01','Shipped','',161)
INSERT INTO ORDERS VALUES(10169,'2003-11-04','2003-11-14','2003-11-09','Shipped','',276)
INSERT INTO ORDERS VALUES(10170,'2003-11-04','2003-11-12','2003-11-07','Shipped','',452)
INSERT INTO ORDERS VALUES(10171,'2003-11-05','2003-11-13','2003-11-07','Shipped','',233)
INSERT INTO ORDERS VALUES(10172,'2003-11-05','2003-11-14','2003-11-11','Shipped','',175)
INSERT INTO ORDERS VALUES(10173,'2003-11-05','2003-11-15','2003-11-09','Shipped','Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches',278)
INSERT INTO ORDERS VALUES(10174,'2003-11-06','2003-11-15','2003-11-10','Shipped','',333)
INSERT INTO ORDERS VALUES(10175,'2003-11-06','2003-11-14','2003-11-09','Shipped','',324)
INSERT INTO ORDERS VALUES(10176,'2003-11-06','2003-11-15','2003-11-12','Shipped','',386)
INSERT INTO ORDERS VALUES(10177,'2003-11-07','2003-11-17','2003-11-12','Shipped','',344)
INSERT INTO ORDERS VALUES(10178,'2003-11-08','2003-11-16','2003-11-10','Shipped','Custom shipping instructions sent to warehouse',242)
INSERT INTO ORDERS VALUES(10179,'2003-11-11','2003-11-17','2003-11-13','Cancelled','Customer cancelled due to urgent budgeting issues. Must be cautious when dealing with them in the future. Since order shipped already we must discuss who would cover the shipping charges.',496)
INSERT INTO ORDERS VALUES(10180,'2003-11-11','2003-11-19','2003-11-14','Shipped','',171)
INSERT INTO ORDERS VALUES(10181,'2003-11-12','2003-11-19','2003-11-15','Shipped','',167)
INSERT INTO ORDERS VALUES(10182,'2003-11-12','2003-11-21','2003-11-18','Shipped','',124)
INSERT INTO ORDERS VALUES(10183,'2003-11-13','2003-11-22','2003-11-15','Shipped','We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.',339)
INSERT INTO ORDERS VALUES(10184,'2003-11-14','2003-11-22','2003-11-20','Shipped','',484)
INSERT INTO ORDERS VALUES(10185,'2003-11-14','2003-11-21','2003-11-20','Shipped','',320)
INSERT INTO ORDERS VALUES(10186,'2003-11-14','2003-11-20','2003-11-18','Shipped','They want to reevaluate their terms agreement with the VP of Sales',489)
INSERT INTO ORDERS VALUES(10187,'2003-11-15','2003-11-24','2003-11-16','Shipped','',211)
INSERT INTO ORDERS VALUES(10188,'2003-11-18','2003-11-26','2003-11-24','Shipped','',167)
INSERT INTO ORDERS VALUES(10189,'2003-11-18','2003-11-25','2003-11-24','Shipped','They want to reevaluate their terms agreement with Finance.',205)
INSERT INTO ORDERS VALUES(10190,'2003-11-19','2003-11-29','2003-11-20','Shipped','',141)
INSERT INTO ORDERS VALUES(10191,'2003-11-20','2003-11-30','2003-11-24','Shipped','We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.',259)
INSERT INTO ORDERS VALUES(10192,'2003-11-20','2003-11-29','2003-11-25','Shipped','',363)
INSERT INTO ORDERS VALUES(10193,'2003-11-21','2003-11-28','2003-11-27','Shipped','',471)
INSERT INTO ORDERS VALUES(10194,'2003-11-25','2003-12-02','2003-11-26','Shipped','',146)
INSERT INTO ORDERS VALUES(10195,'2003-11-25','2003-12-01','2003-11-28','Shipped','',319)
INSERT INTO ORDERS VALUES(10196,'2003-11-26','2003-12-03','2003-12-01','Shipped','',455)
INSERT INTO ORDERS VALUES(10197,'2003-11-26','2003-12-02','2003-12-01','Shipped','Customer inquired about remote controlled models and gold models.',216)
INSERT INTO ORDERS VALUES(10198,'2003-11-27','2003-12-06','2003-12-03','Shipped','',385)
INSERT INTO ORDERS VALUES(10199,'2003-12-01','2003-12-10','2003-12-06','Shipped','',475)
INSERT INTO ORDERS VALUES(10200,'2003-12-01','2003-12-09','2003-12-06','Shipped','',211)
INSERT INTO ORDERS VALUES(10201,'2003-12-01','2003-12-11','2003-12-02','Shipped','',129)
INSERT INTO ORDERS VALUES(10202,'2003-12-02','2003-12-09','2003-12-06','Shipped','',357)
INSERT INTO ORDERS VALUES(10203,'2003-12-02','2003-12-11','2003-12-07','Shipped','',141)
INSERT INTO ORDERS VALUES(10204,'2003-12-02','2003-12-10','2003-12-04','Shipped','',151)
INSERT INTO ORDERS VALUES(10205,'2003-12-03','2003-12-09','2003-12-07','Shipped',' I need all the information I can get on our competitors.',141)
INSERT INTO ORDERS VALUES(10206,'2003-12-05','2003-12-13','2003-12-08','Shipped','Can we renegotiate this one?',202)
INSERT INTO ORDERS VALUES(10207,'2003-12-09','2003-12-17','2003-12-11','Shipped','Check on availability.',495)
INSERT INTO ORDERS VALUES(10208,'2004-01-02','2004-01-11','2004-01-04','Shipped','',146)
INSERT INTO ORDERS VALUES(10209,'2004-01-09','2004-01-15','2004-01-12','Shipped','',347)
INSERT INTO ORDERS VALUES(10210,'2004-01-12','2004-01-22','2004-01-20','Shipped','',177)
INSERT INTO ORDERS VALUES(10211,'2004-01-15','2004-01-25','2004-01-18','Shipped','',406)
INSERT INTO ORDERS VALUES(10212,'2004-01-16','2004-01-24','2004-01-18','Shipped','',141)
INSERT INTO ORDERS VALUES(10213,'2004-01-22','2004-01-28','2004-01-27','Shipped','Difficult to negotiate with customer. We need more marketing materials',489)
INSERT INTO ORDERS VALUES(10214,'2004-01-26','2004-02-04','2004-01-29','Shipped','',458)
INSERT INTO ORDERS VALUES(10215,'2004-01-29','2004-02-08','2004-02-01','Shipped','Customer requested that FedEx Ground is used for this shipping',475)
INSERT INTO ORDERS VALUES(10216,'2004-02-02','2004-02-10','2004-02-04','Shipped','',256)
INSERT INTO ORDERS VALUES(10217,'2004-02-04','2004-02-14','2004-02-06','Shipped','',166)
INSERT INTO ORDERS VALUES(10218,'2004-02-09','2004-02-16','2004-02-11','Shipped','Customer requested that ad materials (such as posters, pamphlets) be included in the shippment',473)
INSERT INTO ORDERS VALUES(10219,'2004-02-10','2004-02-17','2004-02-12','Shipped','',487)
INSERT INTO ORDERS VALUES(10220,'2004-02-12','2004-02-19','2004-02-16','Shipped','',189)
INSERT INTO ORDERS VALUES(10221,'2004-02-18','2004-02-26','2004-02-19','Shipped','',314)
INSERT INTO ORDERS VALUES(10222,'2004-02-19','2004-02-27','2004-02-20','Shipped','',239)
INSERT INTO ORDERS VALUES(10223,'2004-02-20','2004-02-29','2004-02-24','Shipped','',114)
INSERT INTO ORDERS VALUES(10224,'2004-02-21','2004-03-02','2004-02-26','Shipped','Customer has worked with some of our vendors in the past and is aware of their MSRP',171)
INSERT INTO ORDERS VALUES(10225,'2004-02-22','2004-03-01','2004-02-24','Shipped','',298)
INSERT INTO ORDERS VALUES(10226,'2004-02-26','2004-03-06','2004-03-02','Shipped','',239)
INSERT INTO ORDERS VALUES(10227,'2004-03-02','2004-03-12','2004-03-08','Shipped','',146)
INSERT INTO ORDERS VALUES(10228,'2004-03-10','2004-03-18','2004-03-13','Shipped','',173)
INSERT INTO ORDERS VALUES(10229,'2004-03-11','2004-03-20','2004-03-12','Shipped','',124)
INSERT INTO ORDERS VALUES(10230,'2004-03-15','2004-03-24','2004-03-20','Shipped','Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch',128)
INSERT INTO ORDERS VALUES(10231,'2004-03-19','2004-03-26','2004-03-25','Shipped','',344)
INSERT INTO ORDERS VALUES(10232,'2004-03-20','2004-03-30','2004-03-25','Shipped','',240)
INSERT INTO ORDERS VALUES(10233,'2004-03-29','2004-04-04','2004-04-02','Shipped','Customer requested special shippment. The instructions were passed along to the warehouse',328)
INSERT INTO ORDERS VALUES(10234,'2004-03-30','2004-04-05','2004-04-02','Shipped','',412)
INSERT INTO ORDERS VALUES(10235,'2004-04-02','2004-04-12','2004-04-06','Shipped','',260)
INSERT INTO ORDERS VALUES(10236,'2004-04-03','2004-04-11','2004-04-08','Shipped','',486)
INSERT INTO ORDERS VALUES(10237,'2004-04-05','2004-04-12','2004-04-10','Shipped','',181)
INSERT INTO ORDERS VALUES(10238,'2004-04-09','2004-04-16','2004-04-10','Shipped','',145)
INSERT INTO ORDERS VALUES(10239,'2004-04-12','2004-04-21','2004-04-17','Shipped','',311)
INSERT INTO ORDERS VALUES(10240,'2004-04-13','2004-04-20','2004-04-20','Shipped','',177)
INSERT INTO ORDERS VALUES(10241,'2004-04-13','2004-04-20','2004-04-19','Shipped','',209)
INSERT INTO ORDERS VALUES(10242,'2004-04-20','2004-04-28','2004-04-25','Shipped','Customer is interested in buying more Ferrari models',456)
INSERT INTO ORDERS VALUES(10243,'2004-04-26','2004-05-03','2004-04-28','Shipped','',495)
INSERT INTO ORDERS VALUES(10244,'2004-04-29','2004-05-09','2004-05-04','Shipped','',141)
INSERT INTO ORDERS VALUES(10245,'2004-05-04','2004-05-12','2004-05-09','Shipped','',455)
INSERT INTO ORDERS VALUES(10246,'2004-05-05','2004-05-13','2004-05-06','Shipped','',141)
INSERT INTO ORDERS VALUES(10247,'2004-05-05','2004-05-11','2004-05-08','Shipped','',334)
INSERT INTO ORDERS VALUES(10248,'2004-05-07','2004-05-14',NULL,'Cancelled','Order was mistakenly placed. The warehouse noticed the lack of documentation.',131)
INSERT INTO ORDERS VALUES(10249,'2004-05-08','2004-05-17','2004-05-11','Shipped','Can we deliver the new Ford Mustang models by end-of-quarter?',173)
INSERT INTO ORDERS VALUES(10250,'2004-05-11','2004-05-19','2004-05-15','Shipped','',450)
INSERT INTO ORDERS VALUES(10251,'2004-05-18','2004-05-24','2004-05-24','Shipped','',328)
INSERT INTO ORDERS VALUES(10252,'2004-05-26','2004-06-04','2004-05-29','Shipped','',406)
INSERT INTO ORDERS VALUES(10253,'2004-06-01','2004-06-09','2004-06-02','Cancelled','Customer disputed the order and we agreed to cancel it. We must be more cautions with this customer going forward, since they are very hard to please. We must cover the shipping fees.',201)
INSERT INTO ORDERS VALUES(10254,'2004-06-03','2004-06-13','2004-06-04','Shipped','Customer requested that DHL is used for this shipping',323)
INSERT INTO ORDERS VALUES(10255,'2004-06-04','2004-06-12','2004-06-09','Shipped','',209)
INSERT INTO ORDERS VALUES(10256,'2004-06-08','2004-06-16','2004-06-10','Shipped','',145)
INSERT INTO ORDERS VALUES(10257,'2004-06-14','2004-06-24','2004-06-15','Shipped','',450)
INSERT INTO ORDERS VALUES(10258,'2004-06-15','2004-06-25','2004-06-23','Shipped','',398)
INSERT INTO ORDERS VALUES(10259,'2004-06-15','2004-06-22','2004-06-17','Shipped','',166)
INSERT INTO ORDERS VALUES(10260,'2004-06-16','2004-06-22',NULL,'Cancelled','Customer heard complaints from their customers and called to cancel this order. Will notify the Sales Manager.',357)
INSERT INTO ORDERS VALUES(10261,'2004-06-17','2004-06-25','2004-06-22','Shipped','',233)
INSERT INTO ORDERS VALUES(10262,'2004-06-24','2004-07-01',NULL,'Cancelled','This customer found a better offer from one of our competitors. Will call back to renegotiate.',141)
INSERT INTO ORDERS VALUES(10263,'2004-06-28','2004-07-04','2004-07-02','Shipped','',175)
INSERT INTO ORDERS VALUES(10264,'2004-06-30','2004-07-06','2004-07-01','Shipped','Customer will send a truck to our local warehouse on 7/1/2004',362)
INSERT INTO ORDERS VALUES(10265,'2004-07-02','2004-07-09','2004-07-07','Shipped','',471)
INSERT INTO ORDERS VALUES(10266,'2004-07-06','2004-07-14','2004-07-10','Shipped','',386)
INSERT INTO ORDERS VALUES(10267,'2004-07-07','2004-07-17','2004-07-09','Shipped','',151)
INSERT INTO ORDERS VALUES(10268,'2004-07-12','2004-07-18','2004-07-14','Shipped','',412)
INSERT INTO ORDERS VALUES(10269,'2004-07-16','2004-07-22','2004-07-18','Shipped','',382)
INSERT INTO ORDERS VALUES(10270,'2004-07-19','2004-07-27','2004-07-24','Shipped','Can we renegotiate this one?',282)
INSERT INTO ORDERS VALUES(10271,'2004-07-20','2004-07-29','2004-07-23','Shipped','',124)
INSERT INTO ORDERS VALUES(10272,'2004-07-20','2004-07-26','2004-07-22','Shipped','',157)
INSERT INTO ORDERS VALUES(10273,'2004-07-21','2004-07-28','2004-07-22','Shipped','',314)
INSERT INTO ORDERS VALUES(10274,'2004-07-21','2004-07-29','2004-07-22','Shipped','',379)
INSERT INTO ORDERS VALUES(10275,'2004-07-23','2004-08-02','2004-07-29','Shipped','',119)
INSERT INTO ORDERS VALUES(10276,'2004-08-02','2004-08-11','2004-08-08','Shipped','',204)
INSERT INTO ORDERS VALUES(10277,'2004-08-04','2004-08-12','2004-08-05','Shipped','',148)
INSERT INTO ORDERS VALUES(10278,'2004-08-06','2004-08-16','2004-08-09','Shipped','',112)
INSERT INTO ORDERS VALUES(10279,'2004-08-09','2004-08-19','2004-08-15','Shipped','Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches',141)
INSERT INTO ORDERS VALUES(10280,'2004-08-17','2004-08-27','2004-08-19','Shipped','',249)
INSERT INTO ORDERS VALUES(10281,'2004-08-19','2004-08-28','2004-08-23','Shipped','',157)
INSERT INTO ORDERS VALUES(10282,'2004-08-20','2004-08-26','2004-08-22','Shipped','',124)
INSERT INTO ORDERS VALUES(10283,'2004-08-20','2004-08-30','2004-08-23','Shipped','',260)
INSERT INTO ORDERS VALUES(10284,'2004-08-21','2004-08-29','2004-08-26','Shipped','Custom shipping instructions sent to warehouse',299)
INSERT INTO ORDERS VALUES(10285,'2004-08-27','2004-09-04','2004-08-31','Shipped','',286)
INSERT INTO ORDERS VALUES(10286,'2004-08-28','2004-09-06','2004-09-01','Shipped','',172)
INSERT INTO ORDERS VALUES(10287,'2004-08-30','2004-09-06','2004-09-01','Shipped','',298)
INSERT INTO ORDERS VALUES(10288,'2004-09-01','2004-09-11','2004-09-05','Shipped','',166)
INSERT INTO ORDERS VALUES(10289,'2004-09-03','2004-09-13','2004-09-04','Shipped','We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.',167)
INSERT INTO ORDERS VALUES(10290,'2004-09-07','2004-09-15','2004-09-13','Shipped','',198)
INSERT INTO ORDERS VALUES(10291,'2004-09-08','2004-09-17','2004-09-14','Shipped','',448)
INSERT INTO ORDERS VALUES(10292,'2004-09-08','2004-09-18','2004-09-11','Shipped','They want to reevaluate their terms agreement with Finance.',131)
INSERT INTO ORDERS VALUES(10293,'2004-09-09','2004-09-18','2004-09-14','Shipped','',249)
INSERT INTO ORDERS VALUES(10294,'2004-09-10','2004-09-17','2004-09-14','Shipped','',204)
INSERT INTO ORDERS VALUES(10295,'2004-09-10','2004-09-17','2004-09-14','Shipped','They want to reevaluate their terms agreement with Finance.',362)
INSERT INTO ORDERS VALUES(10296,'2004-09-15','2004-09-22','2004-09-16','Shipped','',415)
INSERT INTO ORDERS VALUES(10297,'2004-09-16','2004-09-22','2004-09-21','Shipped','We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.',189)
INSERT INTO ORDERS VALUES(10298,'2004-09-27','2004-10-05','2004-10-01','Shipped','',103)
INSERT INTO ORDERS VALUES(10299,'2004-09-30','2004-10-10','2004-10-01','Shipped','',186)
INSERT INTO ORDERS VALUES(10300,'2003-10-04','2003-10-13','2003-10-09','Shipped','',128)
INSERT INTO ORDERS VALUES(10301,'2003-10-05','2003-10-15','2003-10-08','Shipped','',299)
INSERT INTO ORDERS VALUES(10302,'2003-10-06','2003-10-16','2003-10-07','Shipped','',201)
INSERT INTO ORDERS VALUES(10303,'2004-10-06','2004-10-14','2004-10-09','Shipped','Customer inquired about remote controlled models and gold models.',484)
INSERT INTO ORDERS VALUES(10304,'2004-10-11','2004-10-20','2004-10-17','Shipped','',256)
INSERT INTO ORDERS VALUES(10305,'2004-10-13','2004-10-22','2004-10-15','Shipped','Check on availability.',286)
INSERT INTO ORDERS VALUES(10306,'2004-10-14','2004-10-21','2004-10-17','Shipped','',187)
INSERT INTO ORDERS VALUES(10307,'2004-10-14','2004-10-23','2004-10-20','Shipped','',339)
INSERT INTO ORDERS VALUES(10308,'2004-10-15','2004-10-24','2004-10-20','Shipped','Customer requested that FedEx Ground is used for this shipping',319)
INSERT INTO ORDERS VALUES(10309,'2004-10-15','2004-10-24','2004-10-18','Shipped','',121)
INSERT INTO ORDERS VALUES(10310,'2004-10-16','2004-10-24','2004-10-18','Shipped','',259)
INSERT INTO ORDERS VALUES(10311,'2004-10-16','2004-10-23','2004-10-20','Shipped','Difficult to negotiate with customer. We need more marketing materials',141)
INSERT INTO ORDERS VALUES(10312,'2004-10-21','2004-10-27','2004-10-23','Shipped','',124)
INSERT INTO ORDERS VALUES(10313,'2004-10-22','2004-10-28','2004-10-25','Shipped','Customer requested that FedEx Ground is used for this shipping',202)
INSERT INTO ORDERS VALUES(10314,'2004-10-22','2004-11-01','2004-10-23','Shipped','',227)
INSERT INTO ORDERS VALUES(10315,'2004-10-29','2004-11-08','2004-10-30','Shipped','',119)
INSERT INTO ORDERS VALUES(10316,'2004-11-01','2004-11-09','2004-11-07','Shipped','Customer requested that ad materials (such as posters, pamphlets) be included in the shippment',240)
INSERT INTO ORDERS VALUES(10317,'2004-11-02','2004-11-12','2004-11-08','Shipped','',161)
INSERT INTO ORDERS VALUES(10318,'2004-11-02','2004-11-09','2004-11-07','Shipped','',157)
INSERT INTO ORDERS VALUES(10319,'2004-11-03','2004-11-11','2004-11-06','Shipped','Customer requested that DHL is used for this shipping',456)
INSERT INTO ORDERS VALUES(10320,'2004-11-03','2004-11-13','2004-11-07','Shipped','',144)
INSERT INTO ORDERS VALUES(10321,'2004-11-04','2004-11-12','2004-11-07','Shipped','',462)
INSERT INTO ORDERS VALUES(10322,'2004-11-04','2004-11-12','2004-11-10','Shipped','Customer has worked with some of our vendors in the past and is aware of their MSRP',363)
INSERT INTO ORDERS VALUES(10323,'2004-11-05','2004-11-12','2004-11-09','Shipped','',128)
INSERT INTO ORDERS VALUES(10324,'2004-11-05','2004-11-11','2004-11-08','Shipped','',181)
INSERT INTO ORDERS VALUES(10325,'2004-11-05','2004-11-13','2004-11-08','Shipped','',121)
INSERT INTO ORDERS VALUES(10326,'2004-11-09','2004-11-16','2004-11-10','Shipped','',144)
INSERT INTO ORDERS VALUES(10327,'2004-11-10','2004-11-19','2004-11-13','Resolved','Order was disputed and resolved on 12/1/04. The Sales Manager was involved. Customer claims the scales of the models don''t match what was discussed.',145)
INSERT INTO ORDERS VALUES(10328,'2004-11-12','2004-11-21','2004-11-18','Shipped','Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch',278)
INSERT INTO ORDERS VALUES(10329,'2004-11-15','2004-11-24','2004-11-16','Shipped','',131)
INSERT INTO ORDERS VALUES(10330,'2004-11-16','2004-11-25','2004-11-21','Shipped','',385)
INSERT INTO ORDERS VALUES(10331,'2004-11-17','2004-11-23','2004-11-23','Shipped','Customer requested special shippment. The instructions were passed along to the warehouse',486)
INSERT INTO ORDERS VALUES(10332,'2004-11-17','2004-11-25','2004-11-18','Shipped','',187)
INSERT INTO ORDERS VALUES(10333,'2004-11-18','2004-11-27','2004-11-20','Shipped','',129)
INSERT INTO ORDERS VALUES(10334,'2004-11-19','2004-11-28',NULL,'On Hold','The outstaniding balance for this customer exceeds their credit limit. Order will be shipped when a payment is received.',144)
INSERT INTO ORDERS VALUES(10335,'2004-11-19','2004-11-29','2004-11-23','Shipped','',124)
INSERT INTO ORDERS VALUES(10336,'2004-11-20','2004-11-26','2004-11-24','Shipped','Customer requested that DHL is used for this shipping',172)
INSERT INTO ORDERS VALUES(10337,'2004-11-21','2004-11-30','2004-11-26','Shipped','',424)
INSERT INTO ORDERS VALUES(10338,'2004-11-22','2004-12-02','2004-11-27','Shipped','',381)
INSERT INTO ORDERS VALUES(10339,'2004-11-23','2004-11-30','2004-11-30','Shipped','',398)
INSERT INTO ORDERS VALUES(10340,'2004-11-24','2004-12-01','2004-11-25','Shipped','Customer is interested in buying more Ferrari models',216)
INSERT INTO ORDERS VALUES(10341,'2004-11-24','2004-12-01','2004-11-29','Shipped','',382)
INSERT INTO ORDERS VALUES(10342,'2004-11-24','2004-12-01','2004-11-29','Shipped','',114)
INSERT INTO ORDERS VALUES(10343,'2004-11-24','2004-12-01','2004-11-26','Shipped','',353)
INSERT INTO ORDERS VALUES(10344,'2004-11-25','2004-12-02','2004-11-29','Shipped','',350)
INSERT INTO ORDERS VALUES(10345,'2004-11-25','2004-12-01','2004-11-26','Shipped','',103)
INSERT INTO ORDERS VALUES(10346,'2004-11-29','2004-12-05','2004-11-30','Shipped','',112)
INSERT INTO ORDERS VALUES(10347,'2004-11-29','2004-12-07','2004-11-30','Shipped','Can we deliver the new Ford Mustang models by end-of-quarter?',114)
INSERT INTO ORDERS VALUES(10348,'2004-11-01','2004-11-08','2004-11-05','Shipped','',458)
INSERT INTO ORDERS VALUES(10349,'2004-12-01','2004-12-07','2004-12-03','Shipped','',151)
INSERT INTO ORDERS VALUES(10350,'2004-12-02','2004-12-08','2004-12-05','Shipped','',141)
INSERT INTO ORDERS VALUES(10351,'2004-12-03','2004-12-11','2004-12-07','Shipped','',324)
INSERT INTO ORDERS VALUES(10352,'2004-12-03','2004-12-12','2004-12-09','Shipped','',198)
INSERT INTO ORDERS VALUES(10353,'2004-12-04','2004-12-11','2004-12-05','Shipped','',447)
INSERT INTO ORDERS VALUES(10354,'2004-12-04','2004-12-10','2004-12-05','Shipped','',323)
INSERT INTO ORDERS VALUES(10355,'2004-12-07','2004-12-14','2004-12-13','Shipped','',141)
INSERT INTO ORDERS VALUES(10356,'2004-12-09','2004-12-15','2004-12-12','Shipped','',250)
INSERT INTO ORDERS VALUES(10357,'2004-12-10','2004-12-16','2004-12-14','Shipped','',124)
INSERT INTO ORDERS VALUES(10358,'2004-12-10','2004-12-16','2004-12-16','Shipped','Customer requested that DHL is used for this shipping',141)
INSERT INTO ORDERS VALUES(10359,'2004-12-15','2004-12-23','2004-12-18','Shipped','',353)
INSERT INTO ORDERS VALUES(10360,'2004-12-16','2004-12-22','2004-12-18','Shipped','',496)
INSERT INTO ORDERS VALUES(10361,'2004-12-17','2004-12-24','2004-12-20','Shipped','',282)
INSERT INTO ORDERS VALUES(10362,'2005-01-05','2005-01-16','2005-01-10','Shipped','',161)
INSERT INTO ORDERS VALUES(10363,'2005-01-06','2005-01-12','2005-01-10','Shipped','',334)
INSERT INTO ORDERS VALUES(10364,'2005-01-06','2005-01-17','2005-01-09','Shipped','',350)
INSERT INTO ORDERS VALUES(10365,'2005-01-07','2005-01-18','2005-01-11','Shipped','',320)
INSERT INTO ORDERS VALUES(10366,'2005-01-10','2005-01-19','2005-01-12','Shipped','',381)
INSERT INTO ORDERS VALUES(10367,'2005-01-12','2005-01-21','2005-01-16','Resolved','This order was disputed and resolved on 2/1/2005. Customer claimed that container with shipment was damaged. FedEx''s investigation proved this wrong.',205)
INSERT INTO ORDERS VALUES(10368,'2005-01-19','2005-01-27','2005-01-24','Shipped','Can we renegotiate this one?',124)
INSERT INTO ORDERS VALUES(10369,'2005-01-20','2005-01-28','2005-01-24','Shipped','',379)
INSERT INTO ORDERS VALUES(10370,'2005-01-20','2005-02-01','2005-01-25','Shipped','',276)
INSERT INTO ORDERS VALUES(10371,'2005-01-23','2005-02-03','2005-01-25','Shipped','',124)
INSERT INTO ORDERS VALUES(10372,'2005-01-26','2005-02-05','2005-01-28','Shipped','',398)
INSERT INTO ORDERS VALUES(10373,'2005-01-31','2005-02-08','2005-02-06','Shipped','',311)
INSERT INTO ORDERS VALUES(10374,'2005-02-02','2005-02-09','2005-02-03','Shipped','',333)
INSERT INTO ORDERS VALUES(10375,'2005-02-03','2005-02-10','2005-02-06','Shipped','',119)
INSERT INTO ORDERS VALUES(10376,'2005-02-08','2005-02-18','2005-02-13','Shipped','',219)
INSERT INTO ORDERS VALUES(10377,'2005-02-09','2005-02-21','2005-02-12','Shipped','Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches',186)
INSERT INTO ORDERS VALUES(10378,'2005-02-10','2005-02-18','2005-02-11','Shipped','',141)
INSERT INTO ORDERS VALUES(10379,'2005-02-10','2005-02-18','2005-02-11','Shipped','',141)
INSERT INTO ORDERS VALUES(10380,'2005-02-16','2005-02-24','2005-02-18','Shipped','',141)
INSERT INTO ORDERS VALUES(10381,'2005-02-17','2005-02-25','2005-02-18','Shipped','',321)
INSERT INTO ORDERS VALUES(10382,'2005-02-17','2005-02-23','2005-02-18','Shipped','Custom shipping instructions sent to warehouse',124)
INSERT INTO ORDERS VALUES(10383,'2005-02-22','2005-03-02','2005-02-25','Shipped','',141)
INSERT INTO ORDERS VALUES(10384,'2005-02-23','2005-03-06','2005-02-27','Shipped','',321)
INSERT INTO ORDERS VALUES(10385,'2005-02-28','2005-03-09','2005-03-01','Shipped','',124)
INSERT INTO ORDERS VALUES(10386,'2005-03-01','2005-03-09','2005-03-06','Resolved','Disputed then Resolved on 3/15/2005. Customer doesn''t like the craftsmaship of the models.',141)
INSERT INTO ORDERS VALUES(10387,'2005-03-02','2005-03-09','2005-03-06','Shipped','We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.',148)
INSERT INTO ORDERS VALUES(10388,'2005-03-03','2005-03-11','2005-03-09','Shipped','',462)
INSERT INTO ORDERS VALUES(10389,'2005-03-03','2005-03-09','2005-03-08','Shipped','',448)
INSERT INTO ORDERS VALUES(10390,'2005-03-04','2005-03-11','2005-03-07','Shipped','They want to reevaluate their terms agreement with Finance.',124)
INSERT INTO ORDERS VALUES(10391,'2005-03-09','2005-03-20','2005-03-15','Shipped','',276)
INSERT INTO ORDERS VALUES(10392,'2005-03-10','2005-03-18','2005-03-12','Shipped','',452)
INSERT INTO ORDERS VALUES(10393,'2005-03-11','2005-03-22','2005-03-14','Shipped','They want to reevaluate their terms agreement with Finance.',323)
INSERT INTO ORDERS VALUES(10394,'2005-03-15','2005-03-25','2005-03-19','Shipped','',141)
INSERT INTO ORDERS VALUES(10395,'2005-03-17','2005-03-24','2005-03-23','Shipped','We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.',250)
INSERT INTO ORDERS VALUES(10396,'2005-03-23','2005-04-02','2005-03-28','Shipped','',124)
INSERT INTO ORDERS VALUES(10397,'2005-03-28','2005-04-09','2005-04-01','Shipped','',242)
INSERT INTO ORDERS VALUES(10398,'2005-03-30','2005-04-09','2005-03-31','Shipped','',353)
INSERT INTO ORDERS VALUES(10399,'2005-04-01','2005-04-12','2005-04-03','Shipped','',496)
INSERT INTO ORDERS VALUES(10400,'2005-04-01','2005-04-11','2005-04-04','Shipped','Customer requested that DHL is used for this shipping',450)
INSERT INTO ORDERS VALUES(10401,'2005-04-03','2005-04-14',NULL,'On Hold','Customer credit limit exceeded. Will ship when a payment is received.',328)
INSERT INTO ORDERS VALUES(10402,'2005-04-07','2005-04-14','2005-04-12','Shipped','',406)
INSERT INTO ORDERS VALUES(10403,'2005-04-08','2005-04-18','2005-04-11','Shipped','',201)
INSERT INTO ORDERS VALUES(10404,'2005-04-08','2005-04-14','2005-04-11','Shipped','',323)
INSERT INTO ORDERS VALUES(10405,'2005-04-14','2005-04-24','2005-04-20','Shipped','',209)
INSERT INTO ORDERS VALUES(10406,'2005-04-15','2005-04-25','2005-04-21','Disputed','Customer claims container with shipment was damaged during shipping and some items were missing. I am talking to FedEx about this.',145)
INSERT INTO ORDERS VALUES(10407,'2005-04-22','2005-05-04',NULL,'On Hold','Customer credit limit exceeded. Will ship when a payment is received.',450)
INSERT INTO ORDERS VALUES(10408,'2005-04-22','2005-04-29','2005-04-27','Shipped','',398)
INSERT INTO ORDERS VALUES(10409,'2005-04-23','2005-05-05','2005-04-24','Shipped','',166)
INSERT INTO ORDERS VALUES(10410,'2005-04-29','2005-05-10','2005-04-30','Shipped','',357)
INSERT INTO ORDERS VALUES(10411,'2005-05-01','2005-05-08','2005-05-06','Shipped','',233)
INSERT INTO ORDERS VALUES(10412,'2005-05-03','2005-05-13','2005-05-05','Shipped','',141)
INSERT INTO ORDERS VALUES(10413,'2005-05-05','2005-05-14','2005-05-09','Shipped','Customer requested that DHL is used for this shipping',175)
INSERT INTO ORDERS VALUES(10414,'2005-05-06','2005-05-13',NULL,'On Hold','Customer credit limit exceeded. Will ship when a payment is received.',362)
INSERT INTO ORDERS VALUES(10415,'2005-05-09','2005-05-20','2005-05-12','Disputed','Customer claims the scales of the models don''t match what was discussed. I keep all the paperwork though to prove otherwise',471)
INSERT INTO ORDERS VALUES(10416,'2005-05-10','2005-05-16','2005-05-14','Shipped','',386)
INSERT INTO ORDERS VALUES(10417,'2005-05-13','2005-05-19','2005-05-19','Disputed','Customer doesn''t like the colors and precision of the models.',141)
INSERT INTO ORDERS VALUES(10418,'2005-05-16','2005-05-24','2005-05-20','Shipped','',412)
INSERT INTO ORDERS VALUES(10419,'2005-05-17','2005-05-28','2005-05-19','Shipped','',382)
INSERT INTO ORDERS VALUES(10420,'2005-05-29','2005-06-07',NULL,'In Process','',282)
INSERT INTO ORDERS VALUES(10421,'2005-05-29','2005-06-06',NULL,'In Process','Custom shipping instructions were sent to warehouse',124)
INSERT INTO ORDERS VALUES(10422,'2005-05-30','2005-06-11',NULL,'In Process','',157)
INSERT INTO ORDERS VALUES(10423,'2005-05-30','2005-06-05',NULL,'In Process','',314)
INSERT INTO ORDERS VALUES(10424,'2005-05-31','2005-06-08',NULL,'In Process','',141)
INSERT INTO ORDERS VALUES(10425,'2005-05-31','2005-06-07',NULL,'In Process','',119)
INSERT INTO PAYMENTS VALUES(0,103,'HQ336336','2004-10-19',6066.78E0)
INSERT INTO PAYMENTS VALUES(1,103,'JM555205','2003-06-05',14571.44E0)
INSERT INTO PAYMENTS VALUES(2,103,'OM314933','2004-12-18',1676.14E0)
INSERT INTO PAYMENTS VALUES(3,112,'BO864823','2004-12-17',14191.12E0)
INSERT INTO PAYMENTS VALUES(4,112,'HQ55022','2003-06-06',32641.98E0)
INSERT INTO PAYMENTS VALUES(5,112,'ND748579','2004-08-20',33347.88E0)
INSERT INTO PAYMENTS VALUES(6,114,'GG31455','2003-05-20',45864.03E0)
INSERT INTO PAYMENTS VALUES(7,114,'MA765515','2004-12-15',82261.22E0)
INSERT INTO PAYMENTS VALUES(8,114,'NP603840','2003-05-31',7565.08E0)
INSERT INTO PAYMENTS VALUES(9,114,'NR27552','2004-03-10',44894.74E0)
INSERT INTO PAYMENTS VALUES(10,119,'DB933704','2004-11-14',19501.82E0)
INSERT INTO PAYMENTS VALUES(11,119,'LN373447','2004-08-08',47924.19E0)
INSERT INTO PAYMENTS VALUES(12,119,'NG94694','2005-02-22',49523.67E0)
INSERT INTO PAYMENTS VALUES(13,121,'DB889831','2003-02-16',50218.95E0)
INSERT INTO PAYMENTS VALUES(14,121,'FD317790','2003-10-28',1491.38E0)
INSERT INTO PAYMENTS VALUES(15,121,'KI831359','2004-11-04',17876.32E0)
INSERT INTO PAYMENTS VALUES(16,121,'MA302151','2004-11-28',34638.14E0)
INSERT INTO PAYMENTS VALUES(17,124,'AE215433','2005-03-05',101244.59E0)
INSERT INTO PAYMENTS VALUES(18,124,'BG255406','2004-08-28',85410.87E0)
INSERT INTO PAYMENTS VALUES(19,124,'CQ287967','2003-04-11',11044.3E0)
INSERT INTO PAYMENTS VALUES(20,124,'ET64396','2005-04-16',83598.04E0)
INSERT INTO PAYMENTS VALUES(21,124,'HI366474','2004-12-27',47142.7E0)
INSERT INTO PAYMENTS VALUES(22,124,'HR86578','2004-11-02',55639.66E0)
INSERT INTO PAYMENTS VALUES(23,124,'KI131716','2003-08-15',111654.4E0)
INSERT INTO PAYMENTS VALUES(24,124,'LF217299','2004-03-26',43369.3E0)
INSERT INTO PAYMENTS VALUES(25,124,'NT141748','2003-11-25',45084.38E0)
INSERT INTO PAYMENTS VALUES(26,128,'DI925118','2003-01-28',10549.01E0)
INSERT INTO PAYMENTS VALUES(27,128,'FA465482','2003-10-18',24101.81E0)
INSERT INTO PAYMENTS VALUES(28,128,'FH668230','2004-03-24',33820.62E0)
INSERT INTO PAYMENTS VALUES(29,128,'IP383901','2004-11-18',7466.32E0)
INSERT INTO PAYMENTS VALUES(30,129,'DM826140','2004-12-08',26248.78E0)
INSERT INTO PAYMENTS VALUES(31,129,'ID449593','2003-12-11',23923.93E0)
INSERT INTO PAYMENTS VALUES(32,129,'PI42991','2003-04-09',16537.85E0)
INSERT INTO PAYMENTS VALUES(33,131,'CL442705','2003-03-12',22292.62E0)
INSERT INTO PAYMENTS VALUES(34,131,'MA724562','2004-12-02',50025.35E0)
INSERT INTO PAYMENTS VALUES(35,131,'NB445135','2004-09-11',35321.97E0)
INSERT INTO PAYMENTS VALUES(36,141,'AU364101','2003-07-19',36251.03E0)
INSERT INTO PAYMENTS VALUES(37,141,'DB583216','2004-11-01',36140.38E0)
INSERT INTO PAYMENTS VALUES(38,141,'DL460618','2005-05-19',46895.48E0)
INSERT INTO PAYMENTS VALUES(39,141,'HJ32686','2004-01-30',59830.55E0)
INSERT INTO PAYMENTS VALUES(40,141,'ID10962','2004-12-31',116208.4E0)
INSERT INTO PAYMENTS VALUES(41,141,'IN446258','2005-03-25',65071.26E0)
INSERT INTO PAYMENTS VALUES(42,141,'JE105477','2005-03-18',120166.58E0)
INSERT INTO PAYMENTS VALUES(43,141,'JN355280','2003-10-26',49539.37E0)
INSERT INTO PAYMENTS VALUES(44,141,'JN722010','2003-02-25',40206.2E0)
INSERT INTO PAYMENTS VALUES(45,141,'KT52578','2003-12-09',63843.55E0)
INSERT INTO PAYMENTS VALUES(46,141,'MC46946','2004-07-09',35420.74E0)
INSERT INTO PAYMENTS VALUES(47,141,'MF629602','2004-08-16',20009.53E0)
INSERT INTO PAYMENTS VALUES(48,141,'NU627706','2004-05-17',26155.91E0)
INSERT INTO PAYMENTS VALUES(49,144,'IR846303','2004-12-12',36005.71E0)
INSERT INTO PAYMENTS VALUES(50,144,'LA685678','2003-04-09',7674.94E0)
INSERT INTO PAYMENTS VALUES(51,145,'CN328545','2004-07-03',4710.73E0)
INSERT INTO PAYMENTS VALUES(52,145,'ED39322','2004-04-26',28211.7E0)
INSERT INTO PAYMENTS VALUES(53,145,'HR182688','2004-12-01',20564.86E0)
INSERT INTO PAYMENTS VALUES(54,145,'JJ246391','2003-02-20',53959.21E0)
INSERT INTO PAYMENTS VALUES(55,146,'FP549817','2004-03-18',40978.53E0)
INSERT INTO PAYMENTS VALUES(56,146,'FU793410','2004-01-16',49614.72E0)
INSERT INTO PAYMENTS VALUES(57,146,'LJ160635','2003-12-10',39712.1E0)
INSERT INTO PAYMENTS VALUES(58,148,'BI507030','2003-04-22',44380.15E0)
INSERT INTO PAYMENTS VALUES(59,148,'DD635282','2004-08-11',2611.84E0)
INSERT INTO PAYMENTS VALUES(60,148,'KM172879','2003-12-26',105743.0E0)
INSERT INTO PAYMENTS VALUES(61,148,'ME497970','2005-03-27',3516.04E0)
INSERT INTO PAYMENTS VALUES(62,151,'BF686658','2003-12-22',58793.53E0)
INSERT INTO PAYMENTS VALUES(63,151,'GB852215','2004-07-26',20314.44E0)
INSERT INTO PAYMENTS VALUES(64,151,'IP568906','2003-06-18',58841.35E0)
INSERT INTO PAYMENTS VALUES(65,151,'KI884577','2004-12-14',39964.63E0)
INSERT INTO PAYMENTS VALUES(66,157,'HI618861','2004-11-19',35152.12E0)
INSERT INTO PAYMENTS VALUES(67,157,'NN711988','2004-09-07',63357.13E0)
INSERT INTO PAYMENTS VALUES(68,161,'BR352384','2004-11-14',2434.25E0)
INSERT INTO PAYMENTS VALUES(69,161,'BR478494','2003-11-18',50743.65E0)
INSERT INTO PAYMENTS VALUES(70,161,'KG644125','2005-02-02',12692.19E0)
INSERT INTO PAYMENTS VALUES(71,161,'NI908214','2003-08-05',38675.13E0)
INSERT INTO PAYMENTS VALUES(72,166,'BQ327613','2004-09-16',38785.48E0)
INSERT INTO PAYMENTS VALUES(73,166,'DC979307','2004-07-07',44160.92E0)
INSERT INTO PAYMENTS VALUES(74,166,'LA318629','2004-02-28',22474.17E0)
INSERT INTO PAYMENTS VALUES(75,167,'ED743615','2004-09-19',12538.01E0)
INSERT INTO PAYMENTS VALUES(76,167,'GN228846','2003-12-03',85024.46E0)
INSERT INTO PAYMENTS VALUES(77,171,'GB878038','2004-03-15',18997.89E0)
INSERT INTO PAYMENTS VALUES(78,171,'IL104425','2003-11-22',42783.81E0)
INSERT INTO PAYMENTS VALUES(79,172,'AD832091','2004-09-09',1960.8E0)
INSERT INTO PAYMENTS VALUES(80,172,'CE51751','2004-12-04',51209.58E0)
INSERT INTO PAYMENTS VALUES(81,172,'EH208589','2003-04-20',33383.14E0)
INSERT INTO PAYMENTS VALUES(82,173,'GP545698','2004-05-13',11843.45E0)
INSERT INTO PAYMENTS VALUES(83,173,'IG462397','2004-03-29',20355.24E0)
INSERT INTO PAYMENTS VALUES(84,175,'CITI3434344','2005-05-19',28500.78E0)
INSERT INTO PAYMENTS VALUES(85,175,'IO448913','2003-11-19',24879.08E0)
INSERT INTO PAYMENTS VALUES(86,175,'PI15215','2004-07-10',42044.77E0)
INSERT INTO PAYMENTS VALUES(87,177,'AU750837','2004-04-17',15183.63E0)
INSERT INTO PAYMENTS VALUES(88,177,'CI381435','2004-01-19',47177.59E0)
INSERT INTO PAYMENTS VALUES(89,181,'CM564612','2004-04-25',22602.36E0)
INSERT INTO PAYMENTS VALUES(90,181,'GQ132144','2003-01-30',5494.78E0)
INSERT INTO PAYMENTS VALUES(91,181,'OH367219','2004-11-16',44400.5E0)
INSERT INTO PAYMENTS VALUES(92,186,'AE192287','2005-03-10',23602.9E0)
INSERT INTO PAYMENTS VALUES(93,186,'AK412714','2003-10-27',37602.48E0)
INSERT INTO PAYMENTS VALUES(94,186,'KA602407','2004-10-21',34341.08E0)
INSERT INTO PAYMENTS VALUES(95,187,'AM968797','2004-11-03',52825.29E0)
INSERT INTO PAYMENTS VALUES(96,187,'BQ39062','2004-12-08',47159.11E0)
INSERT INTO PAYMENTS VALUES(97,187,'KL124726','2003-03-27',48425.69E0)
INSERT INTO PAYMENTS VALUES(98,189,'BO711618','2004-10-03',17359.53E0)
INSERT INTO PAYMENTS VALUES(99,189,'NM916675','2004-03-01',32538.74E0)
INSERT INTO PAYMENTS VALUES(100,198,'FI192930','2004-12-06',9658.74E0)
INSERT INTO PAYMENTS VALUES(101,198,'HQ920205','2003-07-06',6036.96E0)
INSERT INTO PAYMENTS VALUES(102,198,'IS946883','2004-09-21',5858.56E0)
INSERT INTO PAYMENTS VALUES(103,201,'DP677013','2003-10-20',23908.24E0)
INSERT INTO PAYMENTS VALUES(104,201,'OO846801','2004-06-15',37258.94E0)
INSERT INTO PAYMENTS VALUES(105,202,'HI358554','2003-12-18',36527.61E0)
INSERT INTO PAYMENTS VALUES(106,202,'IQ627690','2004-11-08',33594.58E0)
INSERT INTO PAYMENTS VALUES(107,204,'GC697638','2004-08-13',51152.86E0)
INSERT INTO PAYMENTS VALUES(108,204,'IS150005','2004-09-24',4424.4E0)
INSERT INTO PAYMENTS VALUES(109,205,'GL756480','2003-12-04',3879.96E0)
INSERT INTO PAYMENTS VALUES(110,205,'LL562733','2003-09-05',50342.74E0)
INSERT INTO PAYMENTS VALUES(111,205,'NM739638','2005-02-06',39580.6E0)
INSERT INTO PAYMENTS VALUES(112,209,'BOAF82044','2005-05-03',35157.75E0)
INSERT INTO PAYMENTS VALUES(113,209,'ED520529','2004-06-21',4632.31E0)
INSERT INTO PAYMENTS VALUES(114,209,'PH785937','2004-05-04',36069.26E0)
INSERT INTO PAYMENTS VALUES(115,211,'BJ535230','2003-12-09',45480.79E0)
INSERT INTO PAYMENTS VALUES(116,216,'BG407567','2003-05-09',3101.4E0)
INSERT INTO PAYMENTS VALUES(117,216,'ML780814','2004-12-06',24945.21E0)
INSERT INTO PAYMENTS VALUES(118,216,'MM342086','2003-12-14',40473.86E0)
INSERT INTO PAYMENTS VALUES(119,219,'BN17870','2005-03-02',3452.75E0)
INSERT INTO PAYMENTS VALUES(120,219,'BR941480','2003-10-18',4465.85E0)
INSERT INTO PAYMENTS VALUES(121,227,'MQ413968','2003-10-31',36164.46E0)
INSERT INTO PAYMENTS VALUES(122,227,'NU21326','2004-11-02',53745.34E0)
INSERT INTO PAYMENTS VALUES(123,233,'BOFA23232','2005-05-20',29070.38E0)
INSERT INTO PAYMENTS VALUES(124,233,'II180006','2004-07-01',22997.45E0)
INSERT INTO PAYMENTS VALUES(125,233,'JG981190','2003-11-18',16909.84E0)
INSERT INTO PAYMENTS VALUES(126,239,'NQ865547','2004-03-15',80375.24E0)
INSERT INTO PAYMENTS VALUES(127,240,'IF245157','2004-11-16',46788.14E0)
INSERT INTO PAYMENTS VALUES(128,240,'JO719695','2004-03-28',24995.61E0)
INSERT INTO PAYMENTS VALUES(129,242,'AF40894','2003-11-22',33818.34E0)
INSERT INTO PAYMENTS VALUES(130,242,'HR224331','2005-06-03',12432.32E0)
INSERT INTO PAYMENTS VALUES(131,242,'KI744716','2003-07-21',14232.7E0)
INSERT INTO PAYMENTS VALUES(132,249,'IJ399820','2004-09-19',33924.24E0)
INSERT INTO PAYMENTS VALUES(133,249,'NE404084','2004-09-04',48298.99E0)
INSERT INTO PAYMENTS VALUES(134,250,'EQ12267','2005-05-17',17928.09E0)
INSERT INTO PAYMENTS VALUES(135,250,'HD284647','2004-12-30',26311.63E0)
INSERT INTO PAYMENTS VALUES(136,250,'HN114306','2003-07-18',23419.47E0)
INSERT INTO PAYMENTS VALUES(137,256,'EP227123','2004-02-10',5759.42E0)
INSERT INTO PAYMENTS VALUES(138,256,'HE84936','2004-10-22',53116.99E0)
INSERT INTO PAYMENTS VALUES(139,259,'EU280955','2004-11-06',61234.67E0)
INSERT INTO PAYMENTS VALUES(140,259,'GB361972','2003-12-07',27988.47E0)
INSERT INTO PAYMENTS VALUES(141,260,'IO164641','2004-08-30',37527.58E0)
INSERT INTO PAYMENTS VALUES(142,260,'NH776924','2004-04-24',29284.42E0)
INSERT INTO PAYMENTS VALUES(143,276,'EM979878','2005-02-09',27083.78E0)
INSERT INTO PAYMENTS VALUES(144,276,'KM841847','2003-11-13',38547.19E0)
INSERT INTO PAYMENTS VALUES(145,276,'LE432182','2003-09-28',41554.73E0)
INSERT INTO PAYMENTS VALUES(146,276,'OJ819725','2005-04-30',29848.52E0)
INSERT INTO PAYMENTS VALUES(147,278,'BJ483870','2004-12-05',37654.09E0)
INSERT INTO PAYMENTS VALUES(148,278,'GP636783','2003-03-02',52151.81E0)
INSERT INTO PAYMENTS VALUES(149,278,'NI983021','2003-11-24',37723.79E0)
INSERT INTO PAYMENTS VALUES(150,282,'IA793562','2003-08-03',24013.52E0)
INSERT INTO PAYMENTS VALUES(151,282,'JT819493','2004-08-02',35806.73E0)
INSERT INTO PAYMENTS VALUES(152,282,'OD327378','2005-01-03',31835.36E0)
INSERT INTO PAYMENTS VALUES(153,286,'DR578578','2004-10-28',47411.33E0)
INSERT INTO PAYMENTS VALUES(154,286,'KH910279','2004-09-05',43134.04E0)
INSERT INTO PAYMENTS VALUES(155,298,'AJ574927','2004-03-13',47375.92E0)
INSERT INTO PAYMENTS VALUES(156,298,'LF501133','2004-09-18',61402.0E0)
INSERT INTO PAYMENTS VALUES(157,299,'AD304085','2003-10-24',36798.88E0)
INSERT INTO PAYMENTS VALUES(158,299,'NR157385','2004-09-05',32260.16E0)
INSERT INTO PAYMENTS VALUES(159,311,'DG336041','2005-02-15',46770.52E0)
INSERT INTO PAYMENTS VALUES(160,311,'FA728475','2003-10-06',32723.04E0)
INSERT INTO PAYMENTS VALUES(161,311,'NQ966143','2004-04-25',16212.59E0)
INSERT INTO PAYMENTS VALUES(162,314,'LQ244073','2004-08-09',45352.47E0)
INSERT INTO PAYMENTS VALUES(163,314,'MD809704','2004-03-03',16901.38E0)
INSERT INTO PAYMENTS VALUES(164,319,'HL685576','2004-11-06',42339.76E0)
INSERT INTO PAYMENTS VALUES(165,319,'OM548174','2003-12-07',36092.4E0)
INSERT INTO PAYMENTS VALUES(166,320,'GJ597719','2005-01-18',8307.28E0)
INSERT INTO PAYMENTS VALUES(167,320,'HO576374','2003-08-20',41016.75E0)
INSERT INTO PAYMENTS VALUES(168,320,'MU817160','2003-11-24',52548.49E0)
INSERT INTO PAYMENTS VALUES(169,321,'DJ15149','2003-11-03',85559.12E0)
INSERT INTO PAYMENTS VALUES(170,321,'LA556321','2005-03-15',46781.66E0)
INSERT INTO PAYMENTS VALUES(171,323,'AL493079','2005-05-23',75020.13E0)
INSERT INTO PAYMENTS VALUES(172,323,'ES347491','2004-06-24',37281.36E0)
INSERT INTO PAYMENTS VALUES(173,323,'HG738664','2003-07-05',2880.0E0)
INSERT INTO PAYMENTS VALUES(174,323,'PQ803830','2004-12-24',39440.59E0)
INSERT INTO PAYMENTS VALUES(175,324,'DQ409197','2004-12-13',13671.82E0)
INSERT INTO PAYMENTS VALUES(176,324,'FP443161','2003-07-07',29429.14E0)
INSERT INTO PAYMENTS VALUES(177,324,'HB150714','2003-11-23',37455.77E0)
INSERT INTO PAYMENTS VALUES(178,328,'EN930356','2004-04-16',7178.66E0)
INSERT INTO PAYMENTS VALUES(179,328,'NR631421','2004-05-30',31102.85E0)
INSERT INTO PAYMENTS VALUES(180,333,'HL209210','2003-11-15',23936.53E0)
INSERT INTO PAYMENTS VALUES(181,333,'JK479662','2003-10-17',9821.32E0)
INSERT INTO PAYMENTS VALUES(182,333,'NF959653','2005-03-01',21432.31E0)
INSERT INTO PAYMENTS VALUES(183,334,'CS435306','2005-01-27',45785.34E0)
INSERT INTO PAYMENTS VALUES(184,334,'HH517378','2003-08-16',29716.86E0)
INSERT INTO PAYMENTS VALUES(185,334,'LF737277','2004-05-22',28394.54E0)
INSERT INTO PAYMENTS VALUES(186,339,'AP286625','2004-10-24',23333.06E0)
INSERT INTO PAYMENTS VALUES(187,339,'DA98827','2003-11-28',34606.28E0)
INSERT INTO PAYMENTS VALUES(188,344,'AF246722','2003-11-24',31428.21E0)
INSERT INTO PAYMENTS VALUES(189,344,'NJ906924','2004-04-02',15322.93E0)
INSERT INTO PAYMENTS VALUES(190,347,'DG700707','2004-01-18',21053.69E0)
INSERT INTO PAYMENTS VALUES(191,347,'LG808674','2003-10-24',20452.5E0)
INSERT INTO PAYMENTS VALUES(192,350,'BQ602907','2004-12-11',18888.31E0)
INSERT INTO PAYMENTS VALUES(193,350,'CI471510','2003-05-25',50824.66E0)
INSERT INTO PAYMENTS VALUES(194,350,'OB648482','2005-01-29',1834.56E0)
INSERT INTO PAYMENTS VALUES(195,353,'CO351193','2005-01-10',49705.52E0)
INSERT INTO PAYMENTS VALUES(196,353,'ED878227','2003-07-21',13920.26E0)
INSERT INTO PAYMENTS VALUES(197,353,'GT878649','2003-05-21',16700.47E0)
INSERT INTO PAYMENTS VALUES(198,353,'HJ618252','2005-06-09',46656.94E0)
INSERT INTO PAYMENTS VALUES(199,357,'AG240323','2003-12-16',20220.04E0)
INSERT INTO PAYMENTS VALUES(200,357,'NB291497','2004-05-15',36442.34E0)
INSERT INTO PAYMENTS VALUES(201,362,'FP170292','2004-07-11',18473.71E0)
INSERT INTO PAYMENTS VALUES(202,362,'OG208861','2004-09-21',15059.76E0)
INSERT INTO PAYMENTS VALUES(203,363,'HL575273','2004-11-17',50799.69E0)
INSERT INTO PAYMENTS VALUES(204,363,'IS232033','2003-01-16',10223.83E0)
INSERT INTO PAYMENTS VALUES(205,363,'PN238558','2003-12-05',55425.77E0)
INSERT INTO PAYMENTS VALUES(206,379,'CA762595','2005-02-12',28322.83E0)
INSERT INTO PAYMENTS VALUES(207,379,'FR499138','2003-09-16',32680.31E0)
INSERT INTO PAYMENTS VALUES(208,379,'GB890854','2004-08-02',12530.51E0)
INSERT INTO PAYMENTS VALUES(209,381,'BC726082','2004-12-03',12081.52E0)
INSERT INTO PAYMENTS VALUES(210,381,'CC475233','2003-04-19',1627.56E0)
INSERT INTO PAYMENTS VALUES(211,381,'GB117430','2005-02-03',14379.9E0)
INSERT INTO PAYMENTS VALUES(212,381,'MS154481','2003-08-22',1128.2E0)
INSERT INTO PAYMENTS VALUES(213,382,'CC871084','2003-05-12',35826.33E0)
INSERT INTO PAYMENTS VALUES(214,382,'CT821147','2004-08-01',6419.84E0)
INSERT INTO PAYMENTS VALUES(215,382,'PH29054','2004-11-27',42813.83E0)
INSERT INTO PAYMENTS VALUES(216,385,'BN347084','2003-12-02',20644.24E0)
INSERT INTO PAYMENTS VALUES(217,385,'CP804873','2004-11-19',15822.84E0)
INSERT INTO PAYMENTS VALUES(218,385,'EK785462','2003-03-09',51001.22E0)
INSERT INTO PAYMENTS VALUES(219,386,'DO106109','2003-11-18',38524.29E0)
INSERT INTO PAYMENTS VALUES(220,386,'HG438769','2004-07-18',51619.02E0)
INSERT INTO PAYMENTS VALUES(221,398,'AJ478695','2005-02-14',33967.73E0)
INSERT INTO PAYMENTS VALUES(222,398,'DO787644','2004-06-21',22037.91E0)
INSERT INTO PAYMENTS VALUES(223,398,'JPMR4544','2005-05-18',615.45E0)
INSERT INTO PAYMENTS VALUES(224,398,'KB54275','2004-11-29',48927.64E0)
INSERT INTO PAYMENTS VALUES(225,406,'BJMPR4545','2005-04-23',12190.85E0)
INSERT INTO PAYMENTS VALUES(226,406,'HJ217687','2004-01-28',49165.16E0)
INSERT INTO PAYMENTS VALUES(227,406,'NA197101','2004-06-17',25080.96E0)
INSERT INTO PAYMENTS VALUES(228,412,'GH197075','2004-07-25',35034.57E0)
INSERT INTO PAYMENTS VALUES(229,412,'PJ434867','2004-04-14',31670.37E0)
INSERT INTO PAYMENTS VALUES(230,415,'ER54537','2004-09-28',31310.09E0)
INSERT INTO PAYMENTS VALUES(231,424,'KF480160','2004-12-07',25505.98E0)
INSERT INTO PAYMENTS VALUES(232,424,'LM271923','2003-04-16',21665.98E0)
INSERT INTO PAYMENTS VALUES(233,424,'OA595449','2003-10-31',22042.37E0)
INSERT INTO PAYMENTS VALUES(234,447,'AO757239','2003-09-15',6631.36E0)
INSERT INTO PAYMENTS VALUES(235,447,'ER615123','2003-06-25',17032.29E0)
INSERT INTO PAYMENTS VALUES(236,447,'OU516561','2004-12-17',26304.13E0)
INSERT INTO PAYMENTS VALUES(237,448,'FS299615','2005-04-18',27966.54E0)
INSERT INTO PAYMENTS VALUES(238,448,'KR822727','2004-09-30',48809.9E0)
INSERT INTO PAYMENTS VALUES(239,450,'EF485824','2004-06-21',59551.38E0)
INSERT INTO PAYMENTS VALUES(240,452,'ED473873','2003-11-15',27121.9E0)
INSERT INTO PAYMENTS VALUES(241,452,'FN640986','2003-11-20',15130.97E0)
INSERT INTO PAYMENTS VALUES(242,452,'HG635467','2005-05-03',8807.12E0)
INSERT INTO PAYMENTS VALUES(243,455,'HA777606','2003-12-05',38139.18E0)
INSERT INTO PAYMENTS VALUES(244,455,'IR662429','2004-05-12',32239.47E0)
INSERT INTO PAYMENTS VALUES(245,456,'GJ715659','2004-11-13',27550.51E0)
INSERT INTO PAYMENTS VALUES(246,456,'MO743231','2004-04-30',1679.92E0)
INSERT INTO PAYMENTS VALUES(247,458,'DD995006','2004-11-15',33145.56E0)
INSERT INTO PAYMENTS VALUES(248,458,'NA377824','2004-02-06',22162.61E0)
INSERT INTO PAYMENTS VALUES(249,458,'OO606861','2003-06-13',57131.92E0)
INSERT INTO PAYMENTS VALUES(250,462,'ED203908','2005-04-15',30293.77E0)
INSERT INTO PAYMENTS VALUES(251,462,'GC60330','2003-11-08',9977.85E0)
INSERT INTO PAYMENTS VALUES(252,462,'PE176846','2004-11-27',48355.87E0)
INSERT INTO PAYMENTS VALUES(253,471,'AB661578','2004-07-28',9415.13E0)
INSERT INTO PAYMENTS VALUES(254,471,'CO645196','2003-12-10',35505.63E0)
INSERT INTO PAYMENTS VALUES(255,473,'LL427009','2004-02-17',7612.06E0)
INSERT INTO PAYMENTS VALUES(256,473,'PC688499','2003-10-27',17746.26E0)
INSERT INTO PAYMENTS VALUES(257,475,'JP113227','2003-12-09',7678.25E0)
INSERT INTO PAYMENTS VALUES(258,475,'PB951268','2004-02-13',36070.47E0)
INSERT INTO PAYMENTS VALUES(259,484,'GK294076','2004-10-26',3474.66E0)
INSERT INTO PAYMENTS VALUES(260,484,'JH546765','2003-11-29',47513.19E0)
INSERT INTO PAYMENTS VALUES(261,486,'BL66528','2004-04-14',5899.38E0)
INSERT INTO PAYMENTS VALUES(262,486,'HS86661','2004-11-23',45994.07E0)
INSERT INTO PAYMENTS VALUES(263,486,'JB117768','2003-03-20',25833.14E0)
INSERT INTO PAYMENTS VALUES(264,487,'AH612904','2003-09-28',29997.09E0)
INSERT INTO PAYMENTS VALUES(265,487,'PT550181','2004-02-29',12573.28E0)
INSERT INTO PAYMENTS VALUES(266,489,'OC773849','2003-12-04',22275.73E0)
INSERT INTO PAYMENTS VALUES(267,489,'PO860906','2004-01-31',7310.42E0)
INSERT INTO PAYMENTS VALUES(268,495,'BH167026','2003-12-26',59265.14E0)
INSERT INTO PAYMENTS VALUES(269,495,'FN155234','2004-05-14',6276.6E0)
INSERT INTO PAYMENTS VALUES(270,496,'EU531600','2005-05-25',30253.75E0)
INSERT INTO PAYMENTS VALUES(271,496,'MB342426','2003-07-16',32077.44E0)
INSERT INTO PAYMENTS VALUES(272,496,'MN89921','2004-12-31',52166.0E0)

ALTER TABLE CUSTOMERS ADD CONSTRAINT SYS_FK_55 FOREIGN KEY(SALESREPEMPLOYEENUMBER) REFERENCES EMPLOYEES(EMPLOYEENUMBER)
ALTER TABLE ORDERDETAILS ADD CONSTRAINT SYS_FK_58 FOREIGN KEY(ORDERNUMBER) REFERENCES ORDERS(ORDERNUMBER)
ALTER TABLE ORDERDETAILS ADD CONSTRAINT SYS_FK_61 FOREIGN KEY(PRODUCTCODE) REFERENCES PRODUCTS(PRODUCTCODE)
ALTER TABLE PRODUCTS ADD CONSTRAINT SYS_FK_64 FOREIGN KEY(PRODUCTLINE) REFERENCES PRODUCTLINES(PRODUCTLINE)
ALTER TABLE ORDERDETAILS ALTER COLUMN ORDERDETAILNUMBER RESTART WITH 2996
ALTER TABLE PAYMENTS ALTER COLUMN PAYMENTNUMBER RESTART WITH 273
