/*******************************************************************************
 * Copyright (c) 2007 Exadel, Inc. and Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Exadel, Inc. and Red Hat, Inc. - initial API and implementation
 ******************************************************************************/ 
package org.jboss.tools.hibernate.core;

import java.io.Serializable;
import java.util.Arrays;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.hibernate.internal.core.util.ClassUtils;
import org.jboss.tools.hibernate.internal.core.util.ScanProject;
import org.jboss.tools.hibernate.internal.core.util.StringUtils;
import org.jboss.tools.hibernate.internal.core.util.TypeUtils;

/**
 * @author kaa
 * akuzmin@exadel.com
 * Aug 18, 2005
 */
public class CodeGenerationService extends CodeRendererService implements ICodeGenerationService 
{

    public IType createImportType(ICompilationUnit unit, String typeName) throws CoreException {
        if (typeName == null || unit == null)
            return null;
        
        if (unit == null || !unit.exists())
            return null;

        IType result = ScanProject.findClassInCU(unit,typeName);
        
        
        if (result == null || !result.exists())
        {
            StringBuffer body = new StringBuffer("public ");
            body.append("interface "+typeName);
            body.append("{}");
            result = unit.createType(body.toString(), null, false, null);
        }
        if (result != null && result.exists())
        {
            formatMember(result);
        }
        
        return result;
    }


	public void createFinders(IType type, String classTypeName, String idTypeName,boolean isInterface) throws CoreException {
        if (type == null || classTypeName == null || idTypeName == null)
            return ;

        String[] params = new String[]{};
//      getAll()
        String className = importTypeName("java.util.List", new TypeImportsResolver(type));
        IMethod newmethod = getMethod(type, "getAll",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public "+className+" getAll()");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append("List values = null;\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Criteria", new TypeImportsResolver(type))+" allValues = session.createCriteria("+importTypeName(classTypeName, new TypeImportsResolver(type))+".class);\t"+StringUtils.EOL);
                methodBody.append(" values = allValues.list();\t"+StringUtils.EOL);
                methodBody.append(" return values;\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//		iterateAll()
        newmethod = getMethod(type, "iterateAll",params);
        className = importTypeName("java.util.Iterator", new TypeImportsResolver(type));
        
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public "+className+" iterateAll()");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
                //methodBody.append(" return getAll().iterator();\t"+StringUtils.EOL);
                methodBody.append("\t"+importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append("\t"+importTypeName("org.hibernate.Query", new TypeImportsResolver(type))+" allValues = session.createQuery(\"from \"+"+importTypeName(classTypeName, new TypeImportsResolver(type))+".class.getName());\t"+StringUtils.EOL);                
                methodBody.append(" return allValues.iterate();\t"+StringUtils.EOL);
                // #changed#
                methodBody.append("\t}"+StringUtils.EOL);
            }
            
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//		getById()
        params=new String[1];
        params[0]=idTypeName;
        newmethod = getMethod(type, "getById",params);
        className = importTypeName(idTypeName, new TypeImportsResolver(type));
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public "+importTypeName(classTypeName, new TypeImportsResolver(type))+" getById("+className+" id)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append(importTypeName(classTypeName, new TypeImportsResolver(type))+" value = null;\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                // #changed# by Konstantin Mishin on 27.01.2006 fixed for ESORM-29
                String idString = "id";
                if(ClassUtils.isPrimitiveType(className))
                	idString = "new "+ClassUtils.getUnqualifyName(ClassUtils.getComplementarySimpleType(className))+"(id)";
                // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
                //methodBody.append(" value = ("+importTypeName(classTypeName, new TypeImportsResolver(type))+") session.load("+importTypeName(classTypeName, new TypeImportsResolver(type))+".class,"+idString+");\t"+StringUtils.EOL);
                methodBody.append(" value = ("+importTypeName(classTypeName, new TypeImportsResolver(type))+") session.get("+importTypeName(classTypeName, new TypeImportsResolver(type))+".class,"+idString+");\t"+StringUtils.EOL);
                // #changed#
                // #changed#
                methodBody.append(" return value;\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            	
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//		findByCriteria()
        params=new String[1];
        	params[0]=type.getPackageFragment().getElementName()+"."+classTypeName.split("\\.")[classTypeName.split("\\.").length-1]+"DAO$SearchCriteria";
        newmethod = getMethod(type,"findByCriteria",params);
        className = importTypeName("java.util.List", new TypeImportsResolver(type));
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public "+className+" findByCriteria(SearchCriteria criteria)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append("List values = null;\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Criteria", new TypeImportsResolver(type))+" crit = getHBCriteria(session,criteria);\t"+StringUtils.EOL);
                // #deleted# by Konstantin Mishin on 11.03.2006 fixed for ESORM-542
                //methodBody.append("if (criteria.startFrom < criteria.maxResults && criteria.startFrom > -1){\t "+StringUtils.EOL);
                //methodBody.append("  crit.setFirstResult(criteria.startFrom);\t "+StringUtils.EOL);
                //methodBody.append("  crit.setMaxResults(criteria.maxResults - criteria.startFrom);\t "+StringUtils.EOL);
                //methodBody.append(" \t}"+StringUtils.EOL);
                // #deleted#
                methodBody.append(" values = crit.list();\t"+StringUtils.EOL);
                methodBody.append(" return values;\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        
		
	}
	public void createSearchCriteriaMethods(IType type) throws CoreException {
        if (type == null)
            return ;
        
        String[] params = {"java.lang.String"};
//      addAscendingOrder()

        String className = importTypeName("java.lang.String", new TypeImportsResolver(type));
        IMethod newmethod = getMethod(type, "addAscendingOrder",params);            
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void addAscendingOrder("+className+" propertyName)");
            // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-542
            //className = importTypeName("java.util.HashSet", new TypeImportsResolver(type));
            className = importTypeName("java.util.ArrayList", new TypeImportsResolver(type));
            // #changed#
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append("if (ascending==null) ascending=new "+className+"();\t"+StringUtils.EOL);
            methodBody.append("ascending.add(propertyName);\t"+StringUtils.EOL);
            methodBody.append("if ((descending!=null)&&(descending.contains(propertyName))) descending.remove(propertyName);\t"+StringUtils.EOL);
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//      addDescendingOrder()
        newmethod = getMethod(type, "addDescendingOrder",params);
        className = importTypeName("java.lang.String", new TypeImportsResolver(type));
            
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void addDescendingOrder("+className+" propertyName)");
            // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-542
            //className = importTypeName("java.util.HashSet", new TypeImportsResolver(type));
            className = importTypeName("java.util.ArrayList", new TypeImportsResolver(type));
            // #changed#
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append("if (descending==null) descending=new "+className+"();\t"+StringUtils.EOL);
            methodBody.append("descending.add(propertyName);\t"+StringUtils.EOL);
            methodBody.append("if ((ascending!=null)&&(ascending.contains(propertyName))) ascending.remove(propertyName);\t"+StringUtils.EOL);
            methodBody.append("\t}"+StringUtils.EOL);

            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
		
	}

	
	public void createWorkMethods(IType type, String classTypeName, String idTypeName,boolean isInterface,boolean isLog) throws CoreException {
        if (type == null || classTypeName == null || idTypeName == null)
            return ;
        
        String[] params = new String[1];
//      insert()
        params[0]=classTypeName;
        IMethod newmethod = getMethod(type, "insert",params);
        String className = importTypeName(classTypeName, new TypeImportsResolver(type));
            
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void insert("+className+" value)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append(" session.save(value);\t"+StringUtils.EOL);
                if (isLog)
                    methodBody.append(" if(log.isDebugEnabled()) log.debug(\"inserting document: \" + value);\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//		update()
        newmethod = getMethod(type, "update",params);
        
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void update("+className+" value)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
                //methodBody.append(" session.update(value);\t"+StringUtils.EOL);
                methodBody.append(" session.saveOrUpdate(value);\t"+StringUtils.EOL);
                // #changed#
                if (isLog)
                    methodBody.append(" if(log.isDebugEnabled()) log.debug(\"updating document: \" + value);\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//		merge()
        newmethod = getMethod(type, "merge",params);
        
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public "+className+" merge("+className+" value)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append(importTypeName(classTypeName, new TypeImportsResolver(type))+" newValue = null;\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append("newValue = ("+className+") session.merge(value);\t"+StringUtils.EOL);
                if (isLog)
                    methodBody.append(" if(log.isDebugEnabled()) log.debug(\"merging document: \" + value);\t"+StringUtils.EOL);
                methodBody.append("return newValue;\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
//		delete()
        newmethod = getMethod(type, "delete",params);
        
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void delete("+className+" value)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                // #deleted# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
                //methodBody.append(" session.refresh(value, "+importTypeName("org.hibernate.LockMode", new TypeImportsResolver(type))+".UPGRADE);\t"+StringUtils.EOL);
                // #deleted#
                methodBody.append(" session.delete(value);\t"+StringUtils.EOL);
                if (isLog)
                    methodBody.append(" if(log.isDebugEnabled()) log.debug(\"deleting document: \" + value);\t"+StringUtils.EOL);
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        
//		deletebyId()
        params=new String[1];
        params[0]=idTypeName;
        newmethod = getMethod(type, "delete",params);
        className = importTypeName(idTypeName, new TypeImportsResolver(type));        
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void delete("+className+" id)");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
                methodBody.append(importTypeName(classTypeName, new TypeImportsResolver(type))+" value = getById(id);\t"+StringUtils.EOL);
                methodBody.append(importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append(" if (value!=null){\t "+StringUtils.EOL);
                // #deleted# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
                //methodBody.append("  session.refresh(value, "+importTypeName("org.hibernate.LockMode", new TypeImportsResolver(type))+".UPGRADE);\t"+StringUtils.EOL);
                // #deleted#
               methodBody.append("  session.delete(value);\t"+StringUtils.EOL);
                if (isLog)
                    methodBody.append(" if(log.isDebugEnabled()) log.debug(\"deleting document: \" + value+\" by ID:\"+id);\t"+StringUtils.EOL);
                methodBody.append(" \t}"+StringUtils.EOL);                
                methodBody.append("\t}"+StringUtils.EOL);
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
		
        // #added# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
//		flush()
        params=new String[]{};
        newmethod = getMethod(type, "flush",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("public void flush()");
            if (isInterface)
            	methodBody.append(";"+StringUtils.EOL);
            else
            {
                methodBody.append(" {\t "+StringUtils.EOL);
                methodBody.append("\t"+importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session = getSession();\t"+StringUtils.EOL);
                methodBody.append("\tsession.flush();\t"+StringUtils.EOL);
                methodBody.append(" \t}"+StringUtils.EOL);                
            }
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        // #added#
	}

    // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
//	public void createSessionMethods(IType type,boolean isLog) throws CoreException {
//        if (type == null)
//            return ;
//
//        IField result = null;
//        
//        StringBuffer fieldBody = new StringBuffer();
//
//        String className = importTypeName("org.hibernate.SessionFactory", new TypeImportsResolver(type));
//        fieldBody.append(autoGenerated+" "+className+" sessionFactory= null;");
//        fieldBody.append(StringUtils.EOL);
//    	if (!type.getField("sessionFactory").exists())
//    	{
//    		result = type.createField(fieldBody.toString(),null,true,null);
//    	}
//        formatMember(result);
//        if (isLog)
//        {
//        	fieldBody = new StringBuffer();
//            fieldBody.append(autoGenerated+"static private final "+importTypeName("org.apache.commons.logging.Log", new TypeImportsResolver(type))+" log = "+importTypeName("org.apache.commons.logging.LogFactory", new TypeImportsResolver(type))+".getLog("+type.getCompilationUnit().getElementName().split("\\.")[0]+".class);");
//            fieldBody.append(StringUtils.EOL);
//        	if (!type.getField("log").exists())
//        	{
//        		result = type.createField(fieldBody.toString(),null,true,null);
//        	}
//            formatMember(result);        	
//        }
//        
//        String[] params = {};
//        String getterMethodName = "get";
//        IMethod getter = getMethod(type, getterMethodName+StringUtils.beanCapitalize("sessionFactory"),params);
//        
//        if (getter == null || !getter.exists()){
//            StringBuffer getterBody = new StringBuffer();
//            getterBody.append(autoGenerated);
//            getterBody.append("private "+ className +" "+ getterMethodName + StringUtils.beanCapitalize("sessionFactory") + "()");
//                getterBody.append("{\t return this.sessionFactory" + ";\t}"+StringUtils.EOL);
//            
//            getter = type.createMethod(getterBody.toString(),null,false,null);
//        }
//        formatMember(getter);
//        
//        
////      getSession()
//        className = importTypeName("org.hibernate.Session", new TypeImportsResolver(type));        
//        IMethod newmethod = getMethod(type, "getSession",params);
//        if (newmethod == null || !newmethod.exists()){
//            StringBuffer methodBody = new StringBuffer();
//            methodBody.append(autoGenerated);
//            methodBody.append("public "+className+" getSession()");
//            methodBody.append("{\t return getSessionFactory().getCurrentSession();" + "\t}"+StringUtils.EOL);
//            newmethod = type.createMethod(methodBody.toString(),null,false,null);
//        }
//        formatMember(newmethod);
//        
//	}

	public void createLogField(IType type) throws CoreException {
        IField result = null;
		StringBuffer fieldBody = new StringBuffer();
        fieldBody.append(autoGenerated+"static private final "+importTypeName("org.apache.commons.logging.Log", new TypeImportsResolver(type))+" log = "+importTypeName("org.apache.commons.logging.LogFactory", new TypeImportsResolver(type))+".getLog("+type.getCompilationUnit().getElementName().split("\\.")[0]+".class);");
        fieldBody.append(StringUtils.EOL);
    	if (!type.getField("log").exists())
    	{
    		result = type.createField(fieldBody.toString(),null,true,null);
    	}
        formatMember(result);        	
		
	}
    // #changed#
	
    public IType createTypeWithOutMethodStubs(ICompilationUnit unit, String typeName, String baseTypeName, String[] implementingInterfaceNames, boolean isStatic) throws CoreException {
        if (typeName == null || unit == null)
            return null;
        
        if (unit == null || !unit.exists())
            return null;

        IType result = ScanProject.findClassInCU(unit,typeName);
        
        boolean createSerialVersionId = false;
        
        if (result == null || !result.exists())
        {
            String className = typeName;
            
            IType innerTypeHolder = null;
            
            StringBuffer body = new StringBuffer("public ");
            if (isStatic)
            {
                body.append("static ");
            }
            
            body.append("class "+className);
            if (baseTypeName != null)
            {
                body.append(" extends " + importTypeName(baseTypeName,new CUImportsResolver(unit)));
            }

            if (implementingInterfaceNames != null && implementingInterfaceNames.length != 0)
            {
                body.append(" implements ");
                for (int i = 0; i < implementingInterfaceNames.length; i++) {
                    String ifaceName = importTypeName(implementingInterfaceNames[i],new CUImportsResolver(unit));
                    
                    if (Serializable.class.getName().equals(implementingInterfaceNames[i]))
                        createSerialVersionId = true;
                    
                    body.append(ifaceName);
                    
                    if (i < implementingInterfaceNames.length - 1)
                        body.append(", ");
                }
            }
            
            body.append("{}");
            
            if (innerTypeHolder != null)
            {
                result = innerTypeHolder.createType(body.toString(), null, false, null);
            }
            else
            {
                result = unit.createType(body.toString(), null, false, null);
            }
            
        }
        else
        {
        	if (implementingInterfaceNames != null && implementingInterfaceNames.length != 0)
        	{
        	String[] interfases=new String [implementingInterfaceNames.length];
        	for(int i=0;i<implementingInterfaceNames.length;i++)
        		interfases[i]=implementingInterfaceNames[i].split("\\.")[implementingInterfaceNames[i].split("\\.").length-1];
        	if (!Arrays.equals(result.getSuperInterfaceNames(),interfases))
                   	ClassUtils.implementsNewInterface(unit,interfases);
        	}
        }

        if (result != null && result.exists())
        {
            if (createSerialVersionId)
                ClassUtils.createSerialVersion(result);
            formatMember(result);
        }
        
        return result;
    }

	public void createHBCriteria(IType type, String classTypeName, PropertyInfoStructure[] fieldNames) throws CoreException {
        String[] params = {"org.hibernate.Session",type.getPackageFragment().getElementName()+"."+classTypeName.split("\\.")[classTypeName.split("\\.").length-1]+"DAO$SearchCriteria"};
        IMethod newmethod = getMethod(type,"getHBCriteria",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("private "+importTypeName("org.hibernate.Criteria", new TypeImportsResolver(type))+" getHBCriteria("+importTypeName("org.hibernate.Session", new TypeImportsResolver(type))+" session, SearchCriteria criteria)");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append(importTypeName("org.hibernate.Criteria", new TypeImportsResolver(type))+" newCriteria = session.createCriteria("+importTypeName(classTypeName, new TypeImportsResolver(type))+".class);\t"+StringUtils.EOL);
            for(int i=0;i<fieldNames.length;i++)
            {
                // #deleted# by Konstantin Mishin on 10.03.2006 fixed for ESORM-542
            	// #changed# by Konstantin Mishin on 28.01.2006 fixed for ESORM-29
//            	if(ClassUtils.isPrimitiveType(fieldNames[i].propertyTypeName)) {
//            		String getterMethodName="boolean".equals(fieldNames[i].propertyTypeName) ? "is" : "get"+StringUtils.beanCapitalize(fieldNames[i].propertyName);
//            		methodBody.append("  newCriteria.add("+importTypeName("org.hibernate.criterion.Restrictions", new TypeImportsResolver(type))+".eq(\""+fieldNames[i].propertyName+"\", "+"new "+ClassUtils.getUnqualifyName(ClassUtils.getComplementarySimpleType(fieldNames[i].propertyTypeName))+"(criteria."+getterMethodName+"())"+"));\t"+StringUtils.EOL);
//            	} else {
                // #deleted#
            	// #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
            	//String getterMethodName="get"+StringUtils.beanCapitalize(fieldNames[i].propertyName);
            	//methodBody.append("if (criteria."+getterMethodName+"()!=null){\t "+StringUtils.EOL);
            	//methodBody.append("  newCriteria.add("+importTypeName("org.hibernate.criterion.Restrictions", new TypeImportsResolver(type))+".eq(\""+fieldNames[i].propertyName+"\", criteria."+getterMethodName+"()));\t"+StringUtils.EOL);
            	methodBody.append("if (criteria."+fieldNames[i].propertyName+" !=null) {\t "+StringUtils.EOL);
            	methodBody.append("  newCriteria.add("+importTypeName("org.hibernate.criterion.Restrictions", new TypeImportsResolver(type))+".eq(\""+fieldNames[i].propertyName+"\", criteria."+fieldNames[i].propertyName+"));\t"+StringUtils.EOL);
            	// #changed#
                methodBody.append(" \t}"+StringUtils.EOL);
//            	}
            	// #changed#
                // #deleted# by Konstantin Mishin on 11.03.2006 fixed for ESORM-542
                //methodBody.append("if ((criteria.ascending!=null)&&(criteria.ascending.contains(\""+fieldNames[i].propertyName+"\")))\t"+StringUtils.EOL);
             	//methodBody.append("  newCriteria.addOrder("+importTypeName("org.hibernate.criterion.Order", new TypeImportsResolver(type))+".asc(\""+fieldNames[i].propertyName+"\"));\t"+StringUtils.EOL);
                //methodBody.append("else \t"+StringUtils.EOL);                
                //methodBody.append("if ((criteria.descending!=null)&&(criteria.descending.contains(\""+fieldNames[i].propertyName+"\")))\t"+StringUtils.EOL);
             	//methodBody.append("  newCriteria.addOrder("+importTypeName("org.hibernate.criterion.Order", new TypeImportsResolver(type))+".desc(\""+fieldNames[i].propertyName+"\"));\t"+StringUtils.EOL);
                // #deleted#
            }
            // #added# by Konstantin Mishin on 11.03.2006 fixed for ESORM-542
            String str = "a";
            for (int i = 0; i < 2; i++) {
                methodBody.append("if ((criteria."+str+"scending != null)) {\t"+StringUtils.EOL);
             	methodBody.append(importTypeName("java.util.Iterator", new TypeImportsResolver(type))+" it=criteria."+str+"scending.iterator();\t"+StringUtils.EOL);
                methodBody.append("while (it.hasNext()) {"+StringUtils.EOL);                
                methodBody.append("newCriteria.addOrder("+importTypeName("org.hibernate.criterion.Order", new TypeImportsResolver(type))+"."+str+"sc((String)it.next()));\t"+StringUtils.EOL);
                methodBody.append("}\t"+StringUtils.EOL);
                methodBody.append("}\t"+StringUtils.EOL);
             	str = "de";
			}
            methodBody.append("if(criteria.maxResults>0)newCriteria.setMaxResults(criteria.maxResults);\t"+StringUtils.EOL);
            methodBody.append("if(criteria.startFrom>0)newCriteria.setFirstResult(criteria.startFrom);\t"+StringUtils.EOL);
            // #added#
         	methodBody.append(" return newCriteria;\t"+StringUtils.EOL);
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = type.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        
	}

	public IField createField(IType enclosingType, PropertyInfoStructure fieldNames,String scopeModifier) throws CoreException {
        if (enclosingType == null || fieldNames == null|| scopeModifier==null)
            return null;
        IField field = enclosingType.getField(fieldNames.propertyName);
        if (!field.exists())
            field = enclosingType.createField(autoGenerated + scopeModifier + " " + importTypeName(fieldNames.propertyTypeName, new TypeImportsResolver(enclosingType)) +
            		" " + fieldNames.propertyName + ";",null,false,null);
        
        formatMember(field);

        return field;
		
	}

	public void createDAOTestCaseMethods(IType enclosingType, String classTypeName, PropertyInfoStructure idInfo, PropertyInfoStructure[] fieldNames) throws CoreException {
        String[] params = new String[0];
        //setUp
        IMethod newmethod = getMethod(enclosingType,"setUp",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("protected void setUp() throws Exception");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append(" super.setUp();\t"+StringUtils.EOL);
            // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
            //methodBody.append(" factory = new "+importTypeName("org.hibernate.cfg.Configuration", new TypeImportsResolver(enclosingType))+"().configure().buildSessionFactory();\t"+StringUtils.EOL);
            methodBody.append(" "+importTypeName("org.hibernate.SessionFactory", new TypeImportsResolver(enclosingType))+" sf = new "+importTypeName("org.hibernate.cfg.Configuration", new TypeImportsResolver(enclosingType))+"().configure().buildSessionFactory();\t"+StringUtils.EOL);
            methodBody.append(" session = sf.openSession();\t"+StringUtils.EOL);
            methodBody.append(" dao=new "+importTypeName(classTypeName.split("\\.")[classTypeName.split("\\.").length-1]+"DAOImpl", new TypeImportsResolver(enclosingType))+"();\t"+StringUtils.EOL);
            //methodBody.append(" dao.setSessionFactory(factory);\t"+StringUtils.EOL);
            methodBody.append(" dao.setSession(session);\t"+StringUtils.EOL);
            // #changed#
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        //tearDown
        newmethod = getMethod(enclosingType,"tearDown",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("protected void tearDown() throws Exception");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append(" super.tearDown();\t"+StringUtils.EOL);
            // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
            //methodBody.append(" if(factory!=null) factory.close();\t"+StringUtils.EOL);
            methodBody.append(" if(session!=null) session.close();\t"+StringUtils.EOL);
            // #changed#
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        //testDAO
        newmethod = getMethod(enclosingType,"testDAO",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            String getterMethodName = "boolean".equals(idInfo.propertyTypeName) ? "is" : "get";
            getterMethodName=getterMethodName+StringUtils.beanCapitalize(idInfo.propertyName);
            methodBody.append(autoGenerated);
            methodBody.append("public void testDAO()");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append(importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+" value=create();\t"+StringUtils.EOL);
            methodBody.append(" testInsert(value);\t"+StringUtils.EOL);
            methodBody.append(" assertNotNull(testRetrieve(value."+getterMethodName+"()));\t"+StringUtils.EOL);
            methodBody.append(" testDelete(value);\t"+StringUtils.EOL);
            methodBody.append(" assertNull(testRetrieve(value."+getterMethodName+"()));\t"+StringUtils.EOL);
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        //testInsert
        params=new String[1];
        params[0]=classTypeName;
        newmethod = getMethod(enclosingType,"testInsert",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("protected void testInsert("+importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+" value)");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            //methodBody.append(" "+importTypeName("org.hibernate.Session", new TypeImportsResolver(enclosingType))+" session = factory.getCurrentSession();\t"+StringUtils.EOL);
            // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
            //methodBody.append(importTypeName("org.hibernate.Transaction", new TypeImportsResolver(enclosingType))+" transaction = session.beginTransaction();\t"+StringUtils.EOL);
            //methodBody.append(" try {\t"+StringUtils.EOL);
            methodBody.append(" dao.insert(value);\t"+StringUtils.EOL);
            //methodBody.append(" transaction.commit();\t"+StringUtils.EOL);
            methodBody.append(" dao.flush();\t"+StringUtils.EOL);
            //methodBody.append("\t}"+StringUtils.EOL);
            //methodBody.append("finally {\t"+StringUtils.EOL);
            //methodBody.append("session.close();\t"+StringUtils.EOL);
            //methodBody.append("\t}"+StringUtils.EOL);            
            // #changed#
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        //testRetrieve
        params=new String[1];
        params[0]=idInfo.propertyTypeName;
        newmethod = getMethod(enclosingType,"testRetrieve",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("protected "+importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+" testRetrieve("+importTypeName(idInfo.propertyTypeName, new TypeImportsResolver(enclosingType))+" id)");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append(" try {\t"+StringUtils.EOL);
            methodBody.append(" return dao.getById(id);\t"+StringUtils.EOL);
            methodBody.append("\t}catch(Exception ex){\t"+StringUtils.EOL);
            methodBody.append("return null;\t"+StringUtils.EOL);
            methodBody.append("\t}"+StringUtils.EOL);            
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        //testDelete
        params=new String[1];
        params[0]=classTypeName;
        newmethod = getMethod(enclosingType,"testDelete",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("protected void testDelete("+importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+" value)");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            //methodBody.append(" "+importTypeName("org.hibernate.Session", new TypeImportsResolver(enclosingType))+" session = factory.getCurrentSession();\t"+StringUtils.EOL);
            // #changed# by Konstantin Mishin on 10.03.2006 fixed for ESORM-526
            //methodBody.append(importTypeName("org.hibernate.Transaction", new TypeImportsResolver(enclosingType))+" transaction = session.beginTransaction();\t"+StringUtils.EOL);
            //methodBody.append(" try {\t"+StringUtils.EOL);
            methodBody.append(" dao.delete(value);\t"+StringUtils.EOL);
            //methodBody.append(" transaction.commit();\t"+StringUtils.EOL);
            methodBody.append(" dao.flush();\t"+StringUtils.EOL);
            //methodBody.append("\t}"+StringUtils.EOL);
            //methodBody.append("finally {\t"+StringUtils.EOL);
            //methodBody.append("session.close();\t"+StringUtils.EOL);
            //methodBody.append("\t}"+StringUtils.EOL);            
            // #changed#
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
        //create
        params=new String[0];
        newmethod = getMethod(enclosingType,"create",params);
        if (newmethod == null || !newmethod.exists()){
            StringBuffer methodBody = new StringBuffer();
            methodBody.append(autoGenerated);
            methodBody.append("protected "+importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+" create()");
            methodBody.append(StringUtils.EOL+"{\t "+StringUtils.EOL);
            methodBody.append(importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+" value=new "+importTypeName(classTypeName, new TypeImportsResolver(enclosingType))+"();\t"+StringUtils.EOL);
            for(int i=0;i<fieldNames.length;i++)
            {
            	PropertyInfoStructure valueInfo=TypeUtils.getTestValuesForType(fieldNames[i].propertyTypeName); 
            	if (valueInfo.propertyTypeName!=null)
            		importTypeName(valueInfo.propertyTypeName, new TypeImportsResolver(enclosingType));
            	methodBody.append("value."+"set"+StringUtils.beanCapitalize(fieldNames[i].propertyName)+"("+valueInfo.propertyName+");\t"+StringUtils.EOL);
            }
            methodBody.append(" return value;\t"+StringUtils.EOL);
            methodBody.append("\t}"+StringUtils.EOL);
            newmethod = enclosingType.createMethod(methodBody.toString(),null,false,null);
        }
        formatMember(newmethod);
	}
    
    
}
