package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.Action;

public class ActionDomAdapter extends JpdlElementDomAdapter {
	
	private static HashMap NODE_TYPES = null;
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("configInfoElement", "configInfoElement");
		}
		return NODE_TYPES;
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Action action = (Action)jpdlElement;
		action.setConfigInfoString(getTextContent());
		action.setClassName(getAttribute("class"));
		action.setConfigType(getAttribute("config-type"));
		action.setName(getAttribute("name"));
		action.setRefName(getAttribute("ref-name"));
		action.setAcceptPropagatedEvents(getAttribute("accept-propagated-events"));
		action.setExpression(getAttribute("expression"));
		action.setAsync(getAttribute("async"));
		action.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		Action action = (Action)getJpdlElement();
		if (action != null) {
			setTextContent(action.getConfigInfoString());
			setAttribute("class", action.getClassName());
			setAttribute("config-type", action.getConfigType());
			setAttribute("name", action.getName());
			setAttribute("ref-name", action.getRefName());
			setAttribute("accept-propagated-events", action.getAcceptPropagatedEvents());
			setAttribute("expression", action.getExpression());
			setAttribute("async", action.getAsync());
		}
	}

	protected String getDefaultValue(String attributeName) {
		if ("accept-propagated-events".equals(attributeName)) {
			return "true";
		} else if ("async".equals(attributeName)) {
			return "false";
		} else if ("config-type".equals(attributeName)) {
			return "field";
		} else {
			return super.getDefaultValue(attributeName);
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("configInfoString".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		} else if ("className".equals(evt.getPropertyName())) {
			setAttribute("class", (String)evt.getNewValue());
		} else if ("configType".equals(evt.getPropertyName())) {
			setAttribute("config-type", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		} else if ("refName".equals(evt.getPropertyName())) {
			setAttribute("ref-name", (String)evt.getNewValue());
		} else if ("acceptPropagatedEvents".equals(evt.getPropertyName())) {
			setAttribute("accept-propagated-events", (String)evt.getNewValue());
		} else if ("expression".equals(evt.getPropertyName())) {
			setAttribute("expression", (String)evt.getNewValue());
		} else if ("async".equals(evt.getPropertyName())) {
			setAttribute("async", (String)evt.getNewValue());
		} else if ("configInfoElementAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("configInfoElementRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		}
	}
	
	private boolean isDifferent(String left, String right) {
		if (left == null) return right == null;
		return left.equals(right);
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Action action = (Action)getJpdlElement();
		if ("#text".equals(name) && action.getConfigInfoElements().length == 0) {
			if (isDifferent(action.getConfigInfoString(), getTextContent())) {
				action.setConfigInfoString(newValue);
			}
		} else if ("class".equals(name)) {
			action.setClassName(newValue);
		} else if ("config-type".equals(name)) {
			action.setConfigType(newValue);
		} else if ("name".equals(name)) {
			action.setName(newValue);
		} else if ("ref-name".equals(name)) {
			action.setRefName(newValue);
		} else if ("accept-propagated-events".equals(name)) {
			action.setAcceptPropagatedEvents(newValue);
		} else if ("expression".equals(name)) {
			action.setExpression(newValue);
		} else if ("async".equals(name)) {
			action.setAsync(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
//		String type = child.getElementType();
//		Action action = (Action)getJpdlElement();
//		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(type);
//		child.initialize(jpdlElement);
//		if ("configInfoElement".equals(type)) {
//			action.addConfigInfoElement((ConfigInfoElement)jpdlElement);
//		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// an action cannot have any child nodes
	}
	
}
