package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.Mail;
import org.jbpm.gd.jpdl.model.Subject;
import org.jbpm.gd.jpdl.model.Text;

public class MailDomAdapter extends JpdlElementDomAdapter {

	private static final String[] CHILD_ELEMENTS = {"subject", "text"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("subject", "subject");
			NODE_TYPES.put("text", "text");
		}
		return NODE_TYPES;
	}
	
	protected String getDefaultValue(String attributeName) {
		if ("async".equals(attributeName)) {
			return "false";
		} else {
			return super.getDefaultValue(attributeName);
		}
	}
	protected void initialize() {
		super.initialize();
		Mail mail = (Mail)getJpdlElement();
		if (mail != null) {
			setAttribute("async", mail.getAsync());
			setAttribute("template", mail.getTemplate());
			setAttribute("actors", mail.getActors());
			setAttribute("to", mail.getTo());
			setAttribute("name", mail.getName());
			addElement(mail.getSubject());
			addElement(mail.getText());
		}
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Mail mail = (Mail)jpdlElement;
		mail.setAsync(getAttribute("async"));
		mail.setTemplate(getAttribute("template"));
		mail.setActors(getAttribute("actors"));
		mail.setTo(getAttribute("to"));
		mail.setName(getAttribute("name"));
		mail.addPropertyChangeListener(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("subject".equals(evt.getPropertyName())) {
			setElement("subject", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("text".equals(evt.getPropertyName())) {
			setElement("text", (AbstractJpdlElement)evt.getOldValue(), (AbstractJpdlElement)evt.getNewValue());
		} else if ("async".equals(evt.getPropertyName())) {
			setAttribute("async", (String)evt.getNewValue());
		} else if ("template".equals(evt.getPropertyName())) {
			setAttribute("template", (String)evt.getNewValue());
		} else if ("actors".equals(evt.getPropertyName())) {
			setAttribute("actors", (String)evt.getNewValue());
		} else if ("to".equals(evt.getPropertyName())) {
			setAttribute("to", (String)evt.getNewValue());
		} else if ("subject".equals(evt.getPropertyName())) {
			setAttribute("subject", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		} else if ("text".equals(evt.getPropertyName())) {
			setAttribute("text", (String)evt.getNewValue());
		}
	}

	protected void doModelUpdate(String name, String newValue) {
		Mail mail = (Mail)getJpdlElement();
		if ("async".equals(name)) {
			mail.setAsync(newValue);
		} else if ("template".equals(name)) {
			mail.setTemplate(newValue);
		} else if ("actors".equals(name)) {
			mail.setActors(newValue);
		} else if ("to".equals(name)) {
			mail.setTo(newValue);
		} else if ("name".equals(name)) {
			mail.setName(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Mail mail = (Mail)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(child.getElementType());
		child.initialize(jpdlElement);
		if ("subject".equals(type)) {
			mail.setSubject((Subject)jpdlElement);
		} else if ("text".equals(type)) {
			mail.setText((Text)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Mail mail = (Mail)getJpdlElement();
		if ("subject".equals(type)) {
			mail.setSubject(null);
		} else if ("script".equals(type)) {
			mail.setText(null);
		}
	}
	
}
