package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.SubProcess;


public class SubProcessDomAdapter extends JpdlElementDomAdapter {
	
	protected void initialize() {
		super.initialize();
		SubProcess subProcess = (SubProcess)getJpdlElement();
		if (subProcess != null) {
			setAttribute("name", subProcess.getName());
			setAttribute("version", subProcess.getVersion());
		}
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		SubProcess subProcess = (SubProcess)jpdlElement;
		subProcess.setName(getAttribute("name"));
		subProcess.setVersion(getAttribute("version"));
		subProcess.addPropertyChangeListener(this);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		} else if ("version".equals(evt.getPropertyName())) {
			setAttribute("version", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		SubProcess subProcess = (SubProcess)getJpdlElement();
		if ("name".equals(name)) {
			subProcess.setName(newValue);
		} else if ("version".equals(name)) {
			subProcess.setVersion(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a subprocess cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a subprocess cannot have any child nodes
	}
	
}
