package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.Text;

public class TextDomAdapter extends JpdlElementDomAdapter {
	
	protected void initialize() {
		super.initialize();
		Text text = (Text)getJpdlElement();
		if (text != null) {
			setTextContent(text.getText());
		}
	}

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Text text = (Text)jpdlElement;
		text.setText(getTextContent());
		text.addPropertyChangeListener(this);
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("text".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Text text = (Text)getJpdlElement();
		if ("#text".equals(name)) {
			text.setText(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a text cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a text cannot have any child nodes
	}
	
}
