/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.ui.command;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.commands.Command;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.jpdl.model.AbstractNode;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;


public class NodeDeleteCommand extends Command {

	private Node node;
	private NodeElementContainer nodeElementContainer;
	private ArrayList edgeDeleteCommands;
	private ArrayList nodeDeleteCommands;

	public void setNode(Node node) {
		this.node = node;
	}
	
	public void execute() {		
		if (nodeElementContainer == null) {
			nodeElementContainer = (NodeElementContainer)((AbstractNotationElement)node.getContainer()).getSemanticElement();
		}
		if (edgeDeleteCommands == null) {
			constructEdgeDeleteCommands();
		}
		if (nodeDeleteCommands == null) {
			constructNodeDeleteCommands();
		}
		executeCommands(nodeDeleteCommands);
		executeCommands(edgeDeleteCommands);
		removeAbstractNode(nodeElementContainer, (AbstractNode)node.getSemanticElement());
	}
	
	public void undo() {
		node.register();
		addAbstractNode(nodeElementContainer, (AbstractNode)node.getSemanticElement());
		undoCommands(edgeDeleteCommands);
		undoCommands(nodeDeleteCommands);
	}
	
	private void addAbstractNode(NodeElementContainer nodeElementContainer, AbstractNode abstractNode) {
		if (abstractNode instanceof StartState) {
			((ProcessDefinition)nodeElementContainer).addStartState((StartState)abstractNode);
		} else {
			nodeElementContainer.addNodeElement(abstractNode);
		}
	}
	
	private void removeAbstractNode(NodeElementContainer nodeElementContainer, AbstractNode abstractNode) {
		if (abstractNode instanceof StartState) {
			((ProcessDefinition)nodeElementContainer).removeStartState((StartState)abstractNode);
		} else {
			nodeElementContainer.removeNodeElement(abstractNode);
		}
	}
	
	private void constructNodeDeleteCommands() {
		nodeDeleteCommands = new ArrayList();
		if (node instanceof NodeContainer) {
			List nodes = ((NodeContainer)node).getNodes();
			for (int i = 0; i < nodes.size(); i++) {
				NodeDeleteCommand command = new NodeDeleteCommand();
				command.setNode((Node)nodes.get(i));
				nodeDeleteCommands.add(command);
			}
		}
	}
	
	private void constructEdgeDeleteCommands() {
		edgeDeleteCommands = new ArrayList();
		List list = node.getArrivingEdges();
		for (int i = 0; i < list.size(); i++) {
			TransitionDeleteCommand command = new TransitionDeleteCommand();
			Edge edge = (Edge)list.get(i);
			command.setEdge(edge);
			command.setParent((AbstractNode)edge.getSource().getSemanticElement());
			edgeDeleteCommands.add(command);
		}
		list = node.getLeavingEdges();
		for (int i = 0; i < list.size(); i++) {
			TransitionDeleteCommand command = new TransitionDeleteCommand();
			command.setEdge((Edge)list.get(i));
			command.setParent((AbstractNode)node.getSemanticElement());
			edgeDeleteCommands.add(command);
		}
	}
	
	private void executeCommands(List commands) {
		for (int i = 0; i < commands.size(); i++) {
			((Command)commands.get(i)).execute();
		}
	}
	
	private void undoCommands(List commands) {
		for (int i = 0; i < commands.size(); i++) {
			((Command)commands.get(i)).undo();
		}
	}
	
	
	
}
